/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

class RETokenRange
extends REToken {
    private char lo;
    private char hi;
    private boolean insens;

    RETokenRange(int f_subIndex, char f_lo, char f_hi, boolean ins) {
        super(f_subIndex);
        this.insens = ins;
        this.lo = this.insens ? Character.toLowerCase(f_lo) : f_lo;
        this.hi = ins ? Character.toLowerCase(f_hi) : f_hi;
    }

    int getMinimumLength() {
        return 1;
    }

    int[] match(CharIndexed input, int index, int eflags, REMatch mymatch) {
        char c = input.charAt(index);
        if (c == '\uffff') {
            return null;
        }
        if (this.insens) {
            c = Character.toLowerCase(c);
        }
        return c >= this.lo && c <= this.hi ? this.next(input, index + 1, eflags, mymatch) : null;
    }

    void dump(StringBuffer os) {
        os.append(this.lo).append('-').append(this.hi);
    }
}

