/*
 * $Id: sig_isa_bus.h,v 1.24 2012-03-06 14:46:49 siflkres Exp $
 * 
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_ISA_BUS_H_INCLUDED
#define __SIG_ISA_BUS_H_INCLUDED

#include <inttypes.h>

#include "sig_boolean.h"
#include "sig_boolean_or.h"
#include "sig_gen.h"

struct sig_isa_bus_main_funcs {
	int (*inb)(void *s, unsigned char *valp, unsigned short port);
	int (*inw)(void *s, unsigned short *valp, unsigned short port);
	int (*outb)(void *s, unsigned char val, unsigned short port);
	int (*outw)(void *s, unsigned short val, unsigned short port);

	int (*readb)(void *s, uint32_t addr, uint8_t *valp);
	int (*readw)(void *s, uint32_t addr, uint16_t *valp);
	int (*writeb)(void *s, uint32_t addr, uint8_t val);
	int (*writew)(void *s, uint32_t addr, uint16_t val);
	int (*map)(void *s, unsigned long pa,
			char **haddr_mr_p, char **haddr_mw_p);

	int (*ack)(void *s, unsigned char *valp);
};

struct sig_isa_bus_main {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_isa_bus_main_funcs *f;
	} member[16];
	int member_count;
};

struct sig_isa_bus_main_merge {
	struct sig_isa_bus_main *s0;
	struct sig_isa_bus_main *s1;
};

extern int
sig_isa_bus_inb(struct sig_isa_bus_main *b, void *s,
		unsigned char *valp, unsigned short port);
extern int
sig_isa_bus_inw(struct sig_isa_bus_main *b, void *s,
		unsigned short *valp, unsigned short port);
extern int
sig_isa_bus_outb(struct sig_isa_bus_main *b, void *s,
		unsigned char val, unsigned short port);
extern int
sig_isa_bus_outw(struct sig_isa_bus_main *b, void *s,
		unsigned short val, unsigned short port);

extern int
sig_isa_bus_readb(struct sig_isa_bus_main *b, void *s,
		uint32_t addr, uint8_t *valp);
extern int
sig_isa_bus_readw(struct sig_isa_bus_main *b, void *s,
		uint32_t addr, uint16_t *valp);
extern int
sig_isa_bus_writeb(struct sig_isa_bus_main *b, void *s,
		uint32_t addr, uint8_t val);
extern int
sig_isa_bus_writew(struct sig_isa_bus_main *b, void *s,
		uint32_t addr, uint16_t val);

extern int
sig_isa_bus_map(struct sig_isa_bus_main *b, void *s,
		unsigned long pa, char **haddr_mr_p, char **haddr_mw_p);

extern int
sig_isa_bus_ack(struct sig_isa_bus_main *b, void *s,
		unsigned char *valp);

extern void
sig_isa_bus_main_connect(struct sig_isa_bus_main *b,
		void *s, const struct sig_isa_bus_main_funcs *f);

extern struct sig_isa_bus_main_merge *
sig_isa_bus_main_merge(
	struct sig_isa_bus_main *s0,
	struct sig_isa_bus_main *s1
);
extern void
sig_isa_bus_main_split(struct sig_isa_bus_main_merge *m);

extern struct sig_isa_bus_main *
sig_isa_bus_main_create(const char *name);
extern void
sig_isa_bus_main_destroy(struct sig_isa_bus_main *sig);

extern void
sig_isa_bus_main_suspend(struct sig_isa_bus_main *b, FILE *fSig);
extern void
sig_isa_bus_main_resume(struct sig_isa_bus_main *b, FILE *fSig);

struct sig_isa_bus_dma_funcs {
	/* Slave -> DMA Controller. */
	int (*req)(void *s);

	/* Controller -> Glue. */
	int (*ack_in)(void *s, uint32_t addr, unsigned int tc);
	int (*ack_out)(void *s, uint32_t addr, unsigned int tc);
	int (*ack_verify)(void *s, unsigned int tc);

	/* Glue -> Slave. */
	int (*ack_inb)(void *s, unsigned int tc, unsigned char *val);
	int (*ack_inw)(void *s, unsigned int tc, unsigned short *val);
	int (*ack_outb)(void *s, unsigned int tc, unsigned char val);
	int (*ack_outw)(void *s, unsigned int tc, unsigned short val);
	int (*ack_verifyb)(void *s, unsigned int tc);
	int (*ack_verifyw)(void *s, unsigned int tc);
};

struct sig_isa_bus_dma {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_isa_bus_dma_funcs *f;
	} member[16];
	int member_count;
};

struct sig_isa_bus_dma_merge {
	struct sig_isa_bus_dma *s0;
	struct sig_isa_bus_dma *s1;
};

extern int
sig_isa_bus_dma_ack_in(struct sig_isa_bus_dma *d, void *s,
		uint32_t addr, unsigned int tc);
extern int
sig_isa_bus_dma_ack_out(struct sig_isa_bus_dma *d, void *s,
		uint32_t addr, unsigned int tc);
extern int
sig_isa_bus_dma_ack_verify(struct sig_isa_bus_dma *d, void *s,
		unsigned int tc);

extern int
sig_isa_bus_dma_ack_inb(struct sig_isa_bus_dma *d, void *s,
		unsigned int tc, uint8_t *valp);
extern int
sig_isa_bus_dma_ack_inw(struct sig_isa_bus_dma *d, void *s,
		unsigned int tc, uint16_t *valp);
extern int
sig_isa_bus_dma_ack_outb(struct sig_isa_bus_dma *d, void *s,
		unsigned int tc, uint8_t val);
extern int
sig_isa_bus_dma_ack_outw(struct sig_isa_bus_dma *d, void *s,
		unsigned int tc, uint16_t val);
extern int
sig_isa_bus_dma_ack_verifyb(struct sig_isa_bus_dma *d, void *s,
		unsigned int tc);
extern int
sig_isa_bus_dma_ack_verifyw(struct sig_isa_bus_dma *d, void *s,
		unsigned int tc);

extern int
sig_isa_bus_dma_req(struct sig_isa_bus_dma *b, void *s);

extern void
sig_isa_bus_dma_connect(struct sig_isa_bus_dma *b,
		void *s, const struct sig_isa_bus_dma_funcs *f);

extern struct sig_isa_bus_dma_merge *
sig_isa_bus_dma_merge(
	struct sig_isa_bus_dma *s0,
	struct sig_isa_bus_dma *s1
);
extern void
sig_isa_bus_dma_split(struct sig_isa_bus_dma_merge *m);

extern struct sig_isa_bus_dma *
sig_isa_bus_dma_create(const char *name);
extern void
sig_isa_bus_dma_destroy(struct sig_isa_bus_dma *sig);

extern void
sig_isa_bus_dma_suspend(struct sig_isa_bus_dma *b, FILE *fSig);
extern void
sig_isa_bus_dma_resume(struct sig_isa_bus_dma *b, FILE *fSig);

struct sig_isa_bus {
	enum sig_gen_type type;
	struct sig_boolean *p5V;
	struct sig_boolean *m5V;
	struct sig_boolean *p12V;
	struct sig_boolean *m12V;
	struct sig_boolean *n_reset;
	struct sig_isa_bus_main *main;
	struct sig_isa_bus_dma *dma0;
	struct sig_isa_bus_dma *dma1;
	struct sig_isa_bus_dma *dma2;
	struct sig_isa_bus_dma *dma3;
	struct sig_isa_bus_dma *dma5;
	struct sig_isa_bus_dma *dma6;
	struct sig_isa_bus_dma *dma7;
	struct sig_boolean_or *int3;
	struct sig_boolean_or *int4;
	struct sig_boolean_or *int5;
	struct sig_boolean_or *int6;
	struct sig_boolean_or *int7;
	struct sig_boolean_or *int9;
	struct sig_boolean_or *int10;
	struct sig_boolean_or *int11;
	struct sig_boolean_or *int12;
	struct sig_boolean_or *int14;
	struct sig_boolean_or *int15;
};

extern void
sig_isa_bus_merge(
	struct sig_isa_bus *c,
	struct sig_isa_bus_main *main
);

extern struct sig_isa_bus *
sig_isa_bus_create(const char *name);
extern void
sig_isa_bus_destroy(struct sig_isa_bus *sig);

extern void
sig_isa_bus_suspend(struct sig_isa_bus *b, FILE *fSig);
extern void
sig_isa_bus_resume(struct sig_isa_bus *b, FILE *fSig);

#endif /* __SIG_ISA_BUS_H_INCLUDED */
