/* $Id: cim_video.c,v 1.5 2009-01-27 17:06:40 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "cim_video.h"

struct cim_video_buf {
	enum {
		CIM_VIDEO_OUT,
		CIM_VIDEO_HOR_RETR,
		CIM_VIDEO_VERT_RETR,
		CIM_VIDEO_NO_SYNC
	} type;
	union {
		struct {
			uint8_t r;
			uint8_t g;
			uint8_t b;
		} pixel;
		struct {
			uint32_t sync_dummy; /* Not used. */
		} sync;
	};
};

static void
cim_video__out(void *_css,
		uint8_t r, uint8_t g, uint8_t b)
{
	struct cim_video *css = (struct cim_video *) _css;
	struct cim_video_buf buf;

	buf.type = CIM_VIDEO_OUT;
	buf.pixel.r = r;
	buf.pixel.g = g;
	buf.pixel.b = b;

	cim_send(&css->bridge, &buf, sizeof(buf));
}

static void
cim_video__no_sync(void *_css)
{
	struct cim_video *css = (struct cim_video *) _css;
	struct cim_video_buf buf;

	buf.type = CIM_VIDEO_NO_SYNC;

	cim_send(&css->bridge, &buf, sizeof(buf));
}

static void
cim_video__hor_retr(void *_css)
{
	struct cim_video *css = (struct cim_video *) _css;
	struct cim_video_buf buf;

	buf.type = CIM_VIDEO_HOR_RETR;

	cim_send(&css->bridge, &buf, sizeof(buf));
}

static void
cim_video__vert_retr(void *_css)
{
	struct cim_video *css = (struct cim_video *) _css;
	struct cim_video_buf buf;

	buf.type = CIM_VIDEO_VERT_RETR;

	cim_send(&css->bridge, &buf, sizeof(buf));
}
void
cim_video_init(struct cim_video *css, struct sig_video *sig_video)
{
	static const struct sig_video_funcs funcs = {
		.out = cim_video__out,
		.hor_retrace = cim_video__hor_retr,
		.vert_retrace = cim_video__vert_retr,
		.no_sync = cim_video__no_sync,
	};

	css->sig_video = sig_video;
	sig_video_connect(sig_video, css, &funcs);
}

void
cim_video_create(struct cim_video *css)
{
	cim_create(&css->bridge);
}

void
cim_video_destroy(struct cim_video *css)
{
	cim_destroy(&css->bridge);
}
