#!/usr/bin/perl -w

# acd2docbook.pl was made for Debian by Charles Plessy in 2007, and can be
# used, modified and redistributed as if it were in the public domain.
#
# You can report bugs to bugs.debian.org/emboss, and access the latest version here:
# http://svn.debian.org/wsvn/pkg-emboss/emboss/trunk/debian/acd2docbook.pl?op=file&rev=0&sc=0
#
# Many thanks to David Bauer for the original idea.

use strict;
use warnings;

use EMBOSS::ACD;

my $acdfile = shift; 
my $embossversion = shift;
my $date = qx(date -R);
chop $date;

my $acd = EMBOSS::ACD->new($acdfile) ;

my $name = $acd->name or die "No name !";
my $NAME = $name;
$NAME =~ s/(.)/\U$1/g;
my $purpose = $acd->documentation;
my $groups = join(",", $acd->groups);

print <<"__XML__";
<?xml version='1.0' encoding='ISO-8859-1'?>
<?xml-stylesheet type="text/xsl"
	href="http://docbook.sourceforge.net/release/xsl/current/manpages/docbook.xsl"?>
<!DOCTYPE refentry PUBLIC "-//OASIS//DTD DocBook XML V4.5//EN"
	"http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd" [

<!-- Autogenerated by the acd2docbook.pl script from the emboss Debian package.    -->
<!-- Template from docbook-xsl version 1.72.0.dfsg.1-1                             -->

  <!ENTITY dhemail     "debian-med-packaging\@lists.alioth.debian.org">
  <!ENTITY dhusername  "Debian Med Packaging Team">
  <!ENTITY dhrelease   "$embossversion">
  <!ENTITY dhtitle     "EMBOSS Manual for Debian">
  <!ENTITY dhucpackage "$NAME">
  <!ENTITY dhpackage   "$name">
  <!ENTITY dhproduct   "EMBOSS">
  <!ENTITY dhsection   "1e">
]>

<refentry>
	<refentryinfo>
		<title>&dhtitle;</title>
		<productname>&dhproduct;</productname>
		<releaseinfo role="version">&dhrelease;</releaseinfo>
		<authorgroup>
			<author>
				<othername>&dhusername;</othername>
				<contrib>Wrote the script used to autogenerate this manual page.</contrib>
				<address>
					<email>&dhemail;</email>
				</address>
			</author>
		</authorgroup>
		<legalnotice>
			<para>This manual page was autogenerated from an Ajax Control Definition of the EMBOSS package. It can be redistributed under the same terms as EMBOSS itself.</para>
		</legalnotice>
	</refentryinfo>

	<refmeta>
		<refentrytitle>&dhucpackage;</refentrytitle>
		<manvolnum>&dhsection;</manvolnum>
	</refmeta>

	<refnamediv>
		<refname>&dhpackage;</refname>
		<refpurpose>$purpose</refpurpose>
	</refnamediv>

	<refsynopsisdiv>
		<cmdsynopsis>
			<command>&dhpackage;</command>
__XML__

foreach my $parameter ( $acd->param) {
	next if $$parameter{datatype} =~ /section/;
	my ($paraname, $argname, $paratype) = ( $$parameter{name}, $$parameter{datatype}, $$parameter{type} );
	my $additional = 'choice="plain"';
	$additional = 'choice="opt"' if $$parameter{additional} eq 'Y';
	print qq(\t\t\t<arg $additional><option>-$paraname <replaceable>$argname</replaceable></option></arg>\n);
}


print <<"__XML__";
		</cmdsynopsis>
		<cmdsynopsis>
			<command>&dhpackage;</command>
			<arg choice="plain"><option>-help</option></arg>
		</cmdsynopsis>
	</refsynopsisdiv>
	<refsect1 id="description">
		<title>DESCRIPTION</title>
		<para><command>&dhpackage;</command> is a command line program from EMBOSS (<quote>the European Molecular Biology Open Software Suite</quote>). It is part of the "$groups" command group(s). 
		</para>
	</refsect1>

	<refsect1 id="options">
			<!-- Use the variablelist.term.separator and the
			     variablelist.term.break.after parameters to
			     control the term elements. -->
		<title>OPTIONS</title>
__XML__

foreach my $parameter( $acd->param) {

	# Does a section begin ?
	if ($$parameter{datatype} eq "section") {
		print qq(\t\t<refsect2 id="$$parameter{name}">\n\t\t\t<title>$$parameter{information}</title>\n\t\t\t<variablelist>\n);
		next;
	}

	# Does a section end ?
	if ($$parameter{datatype} eq "endsection") {
		print "\t\t\t</variablelist>\n\t\t</refsect2>\n";
		next;
	}

	# Is there a Default value ?
	my $default = '';
	$default = " Default value: $$parameter{default}" if $$parameter{default};

	# Use entities when necessary:
	$$parameter{help} =~ s/&/&amp;/g ;
	$$parameter{help} =~ s/</&lt;/g ;
	$$parameter{help} =~ s/>/&gt;/g ;
        $default =~ s/&/&amp;/g ;
        $default =~ s/</&lt;/g ;
        $default =~ s/>/&gt;/g ;



	print<<"__XML__";
				<varlistentry>
					<term>
						<option>-$$parameter{name}</option>
						<parameter>$$parameter{datatype}</parameter>
					</term>
					<listitem>
						<para>$$parameter{help}$default</para>
					</listitem>
				</varlistentry>
__XML__
}

print<<"__XML__";
	</refsect1>

	<refsect1 id="bugs">
		<!-- Or use this section to tell about upstream BTS. -->
		<title>BUGS</title>
		<para>Bugs can be reported to the Debian Bug Tracking system (http://bugs.debian.org/emboss), or directly to the EMBOSS developers (http://sourceforge.net/tracker/?group_id=93650&amp;atid=605031).</para>
	</refsect1>

	<refsect1 id="see_also">
		<title>SEE ALSO</title>
		<para>&dhpackage; is fully documented via the <citerefentry><refentrytitle>tfm</refentrytitle><manvolnum>1</manvolnum></citerefentry> system.</para>
	</refsect1>
</refentry>
__XML__
