
! Copyright (C) 2023 J. K. Dewhurst and S. Sharma.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

subroutine ggair_5c(vx,vc,wx,wc,dtdg2r)
use modmain
implicit none
! arguments
real(8), intent(inout) :: vx(ngtot),vc(ngtot)
real(8), intent(in) :: wx(ngtot),wc(ngtot)
real(8), intent(in) :: dtdg2r(ngtot)
! local variables
integer ig,ifg
! allocatable arrays
complex(8), allocatable :: zfft1(:)
allocate(zfft1(ngtot))
!------------------!
!     exchange     !
!------------------!
! Fourier transform (wx * dtdg2r) to G-space
zfft1(:)=wx(:)*dtdg2r(:)
call zfftifc(3,ngridg,-1,zfft1)
! grad^2 (wx * dtdg2r)
do ig=1,ngtot
  ifg=igfft(ig)
  zfft1(ifg)=-(gc(ig)**2)*zfft1(ifg)
end do
call zfftifc(3,ngridg,1,zfft1)
vx(:)=vx(:)+dble(zfft1(:))
!---------------------!
!     correlation     !
!---------------------!
! Fourier transform (wc * dtdg2r) to G-space
zfft1(:)=wc(:)*dtdg2r(:)
call zfftifc(3,ngridg,-1,zfft1)
! grad^2 (wc * dtdg2r)
do ig=1,ngtot
  ifg=igfft(ig)
  zfft1(ifg)=-(gc(ig)**2)*zfft1(ifg)
end do
call zfftifc(3,ngridg,1,zfft1)
vc(:)=vc(:)+dble(zfft1(:))
deallocate(zfft1)
end subroutine

