#!/usr/bin/perl
# This script converts html.cfg and links.cfg files of Links and older ELinks
# versions to the new ELinks' elinks.conf. Intended use:
#
#     cat .links/html.cfg .links/links.cfg .links/user.cfg |
#       conf-links2elinks.pl > .elinks/elinks.conf

eval 'exec /usr/bin/perl -S $0 ${1+"$@"}'
    if $running_under_some_shell;
			# this emulates #! processing on NIH machines.
			# (remove #! line above if indigestible)

eval '$'.$1.'$2;' while $ARGV[0] =~ /^([A-Za-z_0-9]+=)(.*)/ && shift;
			# process any FOO=bar switches

$[ = 1;			# set array base to 1
$, = ' ';		# set output field separator
$\ = "\n";		# set output record separator

print <<HEADER
# This file was automatically generated by conf-links2elinks.pl -- feel free
# to mess around! Note that if you want to see option descriptions here, don't
# let ELinks load this file and save options to clean new file and it'll be all
# there nicely indented! ;-)
HEADER

;
@system_id = qw(unix os2 win32 beos riscos atheos);

# get_token() vars
$pos = 0;
$line = '';

while (<>) {
    chomp;	# strip record separator
    @Fld = split(' ', $_, 9999);

    ###
    ### links.conf
    ###

    if ($Fld[1] eq 'accesskey_enter') {
	print 'set document.browse.accesskey.auto_follow = ' . $Fld[2];
    }
    if ($Fld[1] eq 'accesskey_priority') {
	print 'set document.browse.accesskey.priority = ' . $Fld[2];
    }
    if ($Fld[1] eq 'allow_special_files') {
	print 'set protocol.file.allow_special_files = ' . $Fld[2];
    }
    if ($Fld[1] eq 'async_dns') {
	print 'set connection.async_dns = ' . $Fld[2];
    }
    if ($Fld[1] eq 'color_dirs') {
	print 'set document.browse.links.color_dirs = ' . $Fld[2];
    }
    if ($Fld[1] eq 'cookies_accept') {
	print 'set cookies.accept_policy = ' . $Fld[2];
    }
    if ($Fld[1] eq 'cookies_paranoid_security') {
	print 'set cookies.paranoid_security = ' . $Fld[2];
    }
    if ($Fld[1] eq 'cookies_save') {
	print 'set cookies.save = ' . $Fld[2];
    }
    if ($Fld[1] eq 'cookies_resave') {
	print 'set cookies.resave = ' . $Fld[2];
    }
    if ($Fld[1] eq 'download_dir') {
	print 'set document.download.directory = ' . $Fld[2];
    }
    if ($Fld[1] eq 'download_utime') {
	print 'set document.download.set_original_time = ' . $Fld[2];
    }
    if ($Fld[1] eq 'dump_width') {
	print 'set document.dump.width = ' . $Fld[2];
    }
    if ($Fld[1] eq 'format_cache_size') {
	print 'set document.cache.format.size = ' . $Fld[2];
    }
    if ($Fld[1] eq 'form_submit_auto') {
	print 'set document.browse.forms.auto_submit = ' . $Fld[2];
    }
    if ($Fld[1] eq 'form_submit_confirm') {
	print 'set document.browse.forms.confirm_submit = ' . $Fld[2];
    }
    if ($Fld[1] eq 'ftp.anonymous_password') {
	print 'set protocol.ftp.anon_passwd = ' . $Fld[2];
    }
    if ($Fld[1] eq 'ftp_proxy') {
	print 'set protocol.ftp.proxy.host = ' . $Fld[2];
    }
    if ($Fld[1] eq 'http_bugs.allow_blacklist') {
	print 'set protocol.http.bugs.allow_blacklist = ' . $Fld[2];
    }
    if ($Fld[1] eq 'http_bugs.bug_302_redirect') {
	print 'set protocol.http.bugs.broken_302_redirect = ' . $Fld[2];
    }
    if ($Fld[1] eq 'http_bugs.bug_post_no_keepalive') {
	print 'set protocol.http.bugs.post_no_keepalive = ' . $Fld[2];
    }
    if ($Fld[1] eq 'http_bugs.http10') {
	print 'set protocol.http.bugs.http10 = ' . $Fld[2];
    }
    if ($Fld[1] eq 'http_proxy') {
	print 'set protocol.http.proxy.host = ' . $Fld[2];
    }
    if ($Fld[1] eq 'http_referer') {
	print 'set protocol.http.referer.policy = ' . $Fld[2];
    }
    if ($Fld[1] eq 'fake_referer') {
	print 'set protocol.http.referer.fake = ' . $Fld[2];
    }
    if ($Fld[1] eq 'enable_global_history') {
	print 'set document.history.global.enable = ' . $Fld[2];
    }
    if ($Fld[1] eq 'keep_unhistory') {
	print 'set document.history.keep_unhistory = ' . $Fld[2];
    }
    if ($Fld[1] eq 'language') {
	print 'set ui.language = ' . $Fld[2];
    }
    if ($Fld[1] eq 'max_connections') {
	print 'set connection.max_connections = ' . $Fld[2];
    }
    if ($Fld[1] eq 'max_connections_to_host') {
	print 'set connection.max_connections_to_host = ' . $Fld[2];
    }
    if ($Fld[1] eq 'memory_cache_size') {
	print 'set document.cache.memory.size = ' . $Fld[2];
    }
    if ($Fld[1] eq 'receive_timeout') {
	print 'set connection.receive_timeout = ' . $Fld[2];
    }
    if ($Fld[1] eq 'retries') {
	print 'set connection.retries = ' . $Fld[2];
    }
    if ($Fld[1] eq 'show_status_bar') {
	print 'set ui.show_status_bar = ' . $Fld[2];
    }
    if ($Fld[1] eq 'show_title_bar') {
	print 'set ui.show_title_bar = ' . $Fld[2];
    }
    if ($Fld[1] eq 'unrestartable_receive_timeout') {
	print 'set connection.unrestartable_receive_timeout = ' . $Fld[2];
    }
    if ($Fld[1] eq 'user_agent') {
	print 'set protocol.http.user_agent = ' . $Fld[2];
    }
    if ($Fld[1] eq 'terminal') {
	$Fld[2] = substr($Fld[2], 2, length($Fld[2]) - 2);
	print 'set terminal.' . $Fld[2] . '.type = ' . $Fld[4];
	print 'set terminal.' . $Fld[2] . '.m11_hack = ' . $Fld[4];
	print 'set terminal.' . $Fld[2] . '.utf_8_io = ' . (($Fld[7] eq '') ? '0' : '1');
	print 'set terminal.' . $Fld[2] . '.restrict_852 = ' . (!(!($Fld[5] & 2))+0);
	print 'set terminal.' . $Fld[2] . '.block_cursor = ' . (!(!($Fld[5] & 4))+0);
	print 'set terminal.' . $Fld[2] . '.colors = ' . (!(!($Fld[5] & 1))+0);
	print 'set terminal.' . $Fld[2] . '.charset = "' . $Fld[6] . '"';
    }
    if ($Fld[1] eq 'extension') {
	$num_exts = (@ext = split(/, */, substr($Fld[2], 2, length($Fld[2]) - 2), 9999));
	for ($i = $num_exts; $i; --$i) {
	    $ext[$i] =~ s/\./*/g;
	    print 'set mime.extension.' . $ext[$i] . ' = ' . $Fld[3];
	}
    }
    if ($Fld[1] eq 'association') {
	$pos = length($Fld[1]) + 2;
	$line = $_;

	$name = &get_token();
	$name = substr($name, 2, length($name) - 2);
	$name =~ s/[ \t]/_/g;
	$name =~ s/[^a-zA-Z0-9_]/-/g;

	$mimelist = &get_token();
	$mimelist = substr($mimelist, 2, length($mimelist) - 2);
	$mimelist =~ s/\./*/g;
	$mimelist =~ s/\//./g;
	$num_mimetypes = (@mimetype = split(/, */, $mimelist, 9999));

	$program = &get_token();

	$flags = $Fld[$#Fld - 1];
	$cons = $flags & 1;
	$xwin = $flags & 2;
	$ask = (!(!($flags & 4))+0);
	$block = ($flags & 8 or $flags & 16) ? !(!($flags & 16)) : (!$xwin or $cons);

	for ($i = $num_mimetypes; $i; $i--) {
	    print 'set mime.type.' . $mimetype[$i] . " = \"" . $name . "\"";
	}
	if ($cons || $Fld[$#Fld] != 1) {
	    &print_association($name, $system_id[$Fld[$#Fld]], $ask, $block, $program);
	}
	if ($xwin && $Fld[$#Fld] == 1) {
	    &print_association($name, $system_id[$Fld[$#Fld]] . '-xwin', $ask, $block, $program);
	}
    }
    if ($Fld[1] eq 'mailto' || $Fld[1] eq 'telnet' || $Fld[1] eq 'tn3270') {
	$val = $Fld[0];
	$val =~ s/^[^ ]* (".*") .$/$1/;
	if ($val eq "mailto") { $val =~ s/%/\%h/g; } else { $val =~ s/%/\%h:\%p/g; }
	print 'set protocol.user.' . $Fld[1] . '.' . $system_id[$Fld[$#Fld]] . ' = ' . $val;
	if ($Fld[$#Fld] = 1) {# Only Unix has X.
	    print 'set protocol.user.' . $Fld[1] . '.' . $system_id[$Fld[$#Fld]] . '-xwin = ' . $val;
	}
    }

    ###
    ### html.conf
    ###

    if ($Fld[1] eq 'html_assume_codepage') {
	print "set document.codepage.assume = \"" . $Fld[2] . "\"";
    }
    if ($Fld[1] eq 'html_avoid_dark_on_black') {
	print 'set document.allow_dark_on_black = ' . (!($Fld[2])+0);
    }
    if ($Fld[1] eq 'html_frames') {
	print 'set document.html.display_frames = ' . $Fld[2];
    }
    if ($Fld[1] eq 'html_hard_assume') {
	print 'set document.codepage.force_assumed = ' . $Fld[2];
    }
    if ($Fld[1] eq 'html_images') {
	print 'set document.browse.images.show_as_links = ' . $Fld[2];
    }
    if ($Fld[1] eq 'html_margin') {
	print 'set document.browse.margin_width = ' . $Fld[2];
    }
    if ($Fld[1] eq 'html_numbered_links') {
	print 'set document.browse.links.numbering = ' . $Fld[2];
    }
    if ($Fld[1] eq 'html_tables') {
	print 'set document.html.display_tables = ' . $Fld[2];
    }
    if ($Fld[1] eq 'html_table_order') {
	print 'set document.browse.table_move_order = ' . $Fld[2];
    }
    if ($Fld[1] eq 'html_use_document_colours') {
	print 'set document.colors.use_document_colors = ' . $Fld[2];
    }
}

sub get_token {
    $backwhacked = 0;
    $quote = 0;
    $token = '';
    $len = length($line);
    for (; $pos <= $len; ++$pos) {	#???
	$char = substr($line, $pos, 1);
	if ($backwhacked) {
	    $backwhacked = 0;
	}
	elsif ($char eq "\\") {
	    $backwhacked = 1;
	}
	elsif ($char eq "\"") {
	    $quote = !$quote;
	}
	elsif (($char eq ' ' || $char eq '	') && !$quote) {
	    last;
	}
	$token = $token . $char;
    }
    ++$pos;

    $token;
}

sub print_association {
    local($name, $system_str, $ask, $block, $program) = @_;
    print 'set mime.handler.' . $name . '.' . $system_str . '.ask = ' . $ask;
    print 'set mime.handler.' . $name . '.' . $system_str . '.block = ' . ($block ? '1' : '0');
    print 'set mime.handler.' . $name . '.' . $system_str . '.program = ' . $program;
}
