#ifndef DUNE_GRIDTYPE_HH
#define DUNE_GRIDTYPE_HH

/**
 * @file
 * @author Andreas Dedner
 *
 * @brief This file can be included directly following config.h to
 *        test if a grid type was correctly selected.
 *
**/

#ifndef HEADERCHECK

// NOGRID is used to specify that no default was set during configure
// If NOGRID and HAVE_GRIDTYPE are both not set then no grid was selected
// and an error is produced
#if defined NOGRID 
  #if ! HAVE_GRIDTYPE
    #error "No grid type selected, use GRIDTYPE=..."
  #endif
#else
  #if ! HAVE_GRIDTYPE
    #error "No grid type selected, typo in GRIDTYPE=...?"
  #endif
#endif

#endif  // HEADERCHECK
  
#endif  // DUNE_GRIDTYPE_HH
