/*********************************************************************
 * FILE:         platform.h
 * PURPOSE:      platform specific stuff
 *********************************************************************/


#ifndef PLATFORM_H
#define PLATFORM_H

/* if DPALL is defined, include everything */

#ifdef DPALL
#define HAS_PGPLOT   /* PGPLOT plotting library */
#define HAS_SFL      /* Standard Function Library */
#define HAS_CDL      /* Client Display Library */
#endif /* DPALL */

/* for Microsoft Windows, include and define some stuff */

#ifdef WIN
#ifndef CYGWIN
#include <io.h>
#include <float.h>
#include <direct.h>

#define isatty _isatty
#define strncasecmp _strnicmp
#define finite _finite
#define isnan _isnan
#define chdir _chdir
#define getcwd _getcwd
#endif /* !CYGWIN */
//#ifdef _WINDOWS // only for Visual C++ 6.0
//#define vsnprintf _vsnprintf
//#endif

#ifndef CYGWIN
unsigned int sleep(unsigned int seconds);
#endif /* !CYGWIN */

#endif /* WIN */

char *convertFileName(const char *fname);
char *convertFileNameReverse(const char *fname);

#endif /* PLATFORM_H */
