# -*- Makefile -*-

########################################################################
#
# cabal-make -- an assistant for Haskell projects
#
# Version 0.5
#
# See http://haskell.org/haskellwiki/cabal-make
# 
# Copyright 2007 by Conal Elliott; BSD3 license.
# 
########################################################################

# Default target
all:

#### Default settings.  To override, define before including this file.

build-args ?= 

# Pass to "./setup configure"
configure-args ?= \
        $(extra-configure-args) \
	$(configure-dirs) \
	$(haddock-config)


# (Conal) I've forgotten the purpose of $(configure-dirs).

show-configure-args:
	@echo $(configure-args)

haddock-config ?= $(source-args) $(comments-args)

# No longer necessary, since cabal's haddock command does what I want.
source-args ?= 

# Where to place the comments.
comments ?= http://haskell.org/haskellwiki/Talk:$(package)/Library

# Generate links to user comment pages
comments-args ?= \
  --haddock-option=--comments-base=$(comments) \
  --haddock-option=--comments-module=$(comments)/%{MODULE/.//}

# Where the haskell sources are to be found.  Note trailing "/".  If your
# sources are in your main project directory, use "top-src-dir=".
top-src-dir ?= src/

# Version with dots in place of slashes
top-src-dot = $(subst /,.,$(top-src-dir))

# Version with hyphens in place of slashes
top-src-dash = $(subst /,-,$(top-src-dir))

# Location of the hscolour css file
hscolour-css ?= hscolour.css

# For test-get-build
tmp-dir ?= c:/tmp

# The user name above is for the make target "webdoc", which uses scp to copy
# your documentation to darcs.haskell.org.
user ?= UnknownUser

# Package name.   Extract from cabal file.
package ?= $(strip $(shell cat *.cabal | egrep -i 'name:' | sed -e 's/[nN][aA][mM][eE]://'))
show-package:
	@echo $(package)

# Extract modules from $(package).cabal.
modules = $(strip $(shell egrep '^[[:space:]]+[A-Z][0-9A-Za-z.]+[^.][ \t]*$$' *.cabal))
show-modules:
	@echo $(modules)


# For seeing generated docs and setting up comment watch.
BROWSER ?= firefox

HsColour ?= HsColour


#### Rules

all:  configure build doc

# I'm never sure which one of the following to use
# config-file = .setup-config
config-file = dist/setup-config

configure: $(config-file)

show-config:
	ls -l $(config-file)

# alias
-- config: configure

build: $(config-file)
	./setup build $(build-args)

install: build
	./setup install

# Maybe add haddock as a prereq for install

doc: doc-clean haddock

hasktags:
	hasktags *.cabal $(sources)

clean: touch-setup
	rm -rf dist
	rm -f $(config-file) .installed-pkg-config ./setup `find . -name '*.hi' -o -name '*.o'`

version ?= $(strip $(shell cat *.cabal | egrep -i 'version:' | sed -e 's/[vV][eE][rR][sS][iI][oO][nN]://'))

show-version:
	@echo $(version)

show-config-args:
	@echo $(configure-args)

show-build-args:
	@echo $(build-args)


setup: Setup.*hs
	ghc --make Setup.*hs -o setup

$(config-file): setup *.cabal
	./setup configure $(configure-args)

# modules with "." replaced by "/"
slash-modules = $(subst .,/,$(modules))
show-slash-modules:
	@echo $(slash-modules)

# Massage module names into source file names.
sources = $(patsubst %,$(top-src-dir)%.hs,$(slash-modules))
show-sources:
	@echo $(sources)

# Modify sources to use the unix end-of-line convention rather than dos.
unixify-sources:
	touch CHANGES TODO
	dos2unix README CHANGES Makefile TODO *.cabal Setup.*hs `find $(top-src-dir) -name '*.*hs'`

# Or for docs (probably not worth bothering)
unixify-docs:
	dos2unix `find dist/doc/html -name '*.html'`

# Similarly to get the dos end-of-line convention.
dosify-sources:
	unix2dos README CHANGES Makefile TODO *.cabal `find $(top-src-dir) -name '*.*hs'`

# Remove old docs first, in case some modules have been renamed or deleted.
doc-clean:
	rm -rf dist/doc

haddock: $(config-file)
	./setup haddock


# Make a new repo (requires account)
darcs-repo:
	darcs put $(user)@darcs.haskell.org:/home/darcs/packages/$(package)
	ssh $(user)@darcs.haskell.org "mkdir -p /home/darcs/packages/$(package)/dist"

# Tag with current version
darcs-tag:
	darcs tag $(version)

# Make a tarball and copy to server.
darcs-dist:
	darcs dist -d $(package)-$(version)
	scp $(package)-$(version).tar.gz $(user)@darcs.haskell.org:/home/darcs/packages/$(package)/dist/
	mkdir -p tarballs
	mv $(package)-$(version).tar.gz tarballs

# After "darcs record" and "darcs push", see if everything works
test-get-build:
	cd $(tmp-dir); \
	rm -rf $(package); \
	darcs get http://darcs.haskell.org/packages/$(package); \
	cd $(package); \
	ghc --make Setup.*hs; \
	./setup configure; \
	./setup build

# Server location for web docs
web-doc-dir ?= /home/darcs/packages/$(package)/doc/html

# The package's home on the web.
package-home ?= darcs.haskell.org:/home/darcs/packages/$(package)

# After "make doc", copy to the server.  Remove old docs first, in case
# some modules have been renamed or deleted.
web-doc:
	ssh $(user)@darcs.haskell.org \
             "rm -rf $(web-doc-dir); mkdir -p $(web-doc-dir)"
	scp -r dist/doc/html/$(package)/* $(user)@$(package-home)/doc/html

# Check out local or remote docs
see-doc:
	$(BROWSER) dist/doc/html/$(package)/index.html; echo
see-web-doc:
	$(BROWSER) http://darcs.haskell.org/packages/$(package)/doc/html

# Make & see docs
doc-see: doc see-doc
web-doc-see: web-doc see-web-doc

# Automatically add yourself to the watch list of all project talk pages.
# There's one talk page for the project and one for each module.
watch-comments:
	$(BROWSER) "$(comments)&action=watch" ;\
	for file in $(slash-modules); do \
	  $(BROWSER) "$(comments)/$$file&action=watch"; \
	done; \
	echo Now watching all talk pages for $(package)



# PanDoc.  Perhaps it makes more sense to put formatted info on the wiki.
%.html: %
	pandoc --toc --smart --standalone -o $@ $<

pandocs: TODO.html CHANGES.html README.html

### Some simple targets here to help automate use from parent makefiles

# Check for forgotten darcs add
check-add:
	darcs add -r -v --dry-run .

add-new:
	darcs add -r -v .

whatsnew:
	darcs whatsnew

push:
	darcs push --verbose

unreg:
	ghc-pkg unregister $(package)

touch-setup:
	touch Setup.*hs

repair:
	darcs repair

# Handy for passing down to several libs  Generate & install one lib's
# docs before generating the next, so inter-lib links work.
haddock-install: haddock install
