// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2005 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id: 85464d6abb14b17eaf2377a010391dd47edadf59 $

#ifndef RULESETS_PY_TASK_H
#define RULESETS_PY_TASK_H

#include <Python.h>

class Task;

/// \brief Wrapper for Task in Python
/// \ingroup PythonWrappers
typedef struct {
    PyObject_HEAD
    /// \brief Task object handled by this wrapper
    Task * m_task;
} PyTask;

extern PyTypeObject PyTask_Type;

#define PyTask_Check(_o) ((_o)->ob_type == &PyTask_Type)

PyTask * newPyTask();

#endif // RULESETS_PY_TASK_H
