#define XERR "memoryaccess"
#include "memoryaccess.ih"

// returns the ID of a newly allocated shmget memory block

    // by create.cc, get.cc 

// static
int MemoryAccess::getID(size_t sharedSegmentSize, size_t access)
{
    int id = shmget(IPC_PRIVATE, sharedSegmentSize, access);

    if (id == -1)                           // no block available
        throw Exception{} << XERR ": cannot get a shared segment of " << 
                                                sharedSegmentSize << " bytes";

    if (size_t size = getSegmentSize(id); size != sharedSegmentSize)
        throw Exception{} << XERR ": incorrect size (" << size <<
                            ", should be: " << sharedSegmentSize <<
                            ") of shared segment";
    return id;
}


