# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gobject import io_add_watch, idle_add
from socket import (socket, AF_UNIX, SOCK_DGRAM, SOCK_DGRAM,
                    error as socket_error)
from gtk.gdk import INPUT_READ
from pickle import loads

from extensionsloader import ExtensionsLoader
from common.config import ConfigLoader
from gui.mainwindow import MainWindow

extensions = ExtensionsLoader()
config = ConfigLoader()

class MainApplication(object):
    def __init__(self):
        print 'The dolphin reaches the surface!'
        SOCKET_NAME = '/tmp/bluemindo'
        self.classes = []

        def handle_connection(source, condition):
            """This is the UNIX socket server."""
            datagram = server.recv(1024)
            argv = loads(datagram)
            usercommand = argv[1]

            # PlayPause, Play or Pause
            if usercommand in ('--playpause', '--play', '--pause'):
                idle_add(extensions.load_event, 'OnPlayPressed')

            # Stop
            elif usercommand == '--stop':
                idle_add(extensions.load_event, 'OnStopPressed')

            # Next
            elif usercommand == '--next':
                idle_add(extensions.load_event, 'OnNextPressed')

            # Previous
            elif usercommand == '--previous':
                idle_add(extensions.load_event, 'OnPreviousPressed')

            # More volume
            elif usercommand.startswith('--volume-more'):
                self.classes[1].volume_more(usercommand)

            # Less volume
            elif usercommand.startswith('--volume-less'):
                self.classes[1].volume_less(usercommand)

            # Set the volume
            elif usercommand.startswith('--volume='):
                self.classes[1].volume_set(usercommand.split('=')[1])

            # Reload songs list
            elif usercommand == '--reload':
                idle_add(extensions.load_event, 'OnMenuRefreshPressed',
                                                self.widgets)

            # Quit Bluemindo
            elif usercommand in ('--quit', '--plunge'):
                idle_add(self.classes[0].on_menu_quit, 'socket')

            # The command isn't handled by any action
            else:
                print 'Receive unknown event `%s`!' % usercommand

            return True

        # Create the UNIX socket server
        server = socket(AF_UNIX, SOCK_DGRAM)
        server.bind(SOCKET_NAME)
        io_add_watch(server, INPUT_READ, handle_connection)

        # Launch extensions and start user interface
        extensions.load()
        gui = MainWindow(extensions)
        self.classes = gui.get_classes()

        # Nothing can be done after that
        gui.start_thread()