IF(WIN32 AND NOT UNIX)

    # Libs needed for packaging
    FIND_PACKAGE(ZLIB REQUIRED)
    FIND_PACKAGE(CURL REQUIRED)
    FIND_PACKAGE(Sword REQUIRED)

    SET(CPACK_PACKAGE_NAME "BibleTime")
    SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "BibleTime for Windows")
    SET(CPACK_PACKAGE_VENDOR "http://www.bibletime.info")
    SET(CPACK_PACKAGE_VERSION_MAJOR ${BT_VERSION_MAJOR})
    SET(CPACK_PACKAGE_VERSION_MINOR ${BT_VERSION_MINOR})
    SET(CPACK_PACKAGE_VERSION_PATCH ${BT_VERSION_PATCH})
    SET(CPACK_PACKAGE_INSTALL_DIRECTORY "BibleTime")

    SET(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/LICENSE")

    # We need the libraries, and they're not pulled in automatically
    SET(CMAKE_INSTALL_DEBUG_LIBRARIES TRUE)

    SET(QT_BINARY_DIR "${Qt5Core_DIR}/../../../bin")
    INSTALL(DIRECTORY
        "${QT_BINARY_DIR}/../translations"
        DESTINATION "${BT_DESTINATION}"
        CONFIGURATIONS "Release"
    )

    FIND_PROGRAM(QT_WINDEPLOYQT_EXECUTABLE windeployqt HINTS "${QT_BIN_DIR}")
    MESSAGE(STATUS "Running ${QT_WINDEPLOYQT_EXECUTABLE}")
    INSTALL(CODE "EXECUTE_PROCESS(COMMAND ${QT_WINDEPLOYQT_EXECUTABLE} \"\${CMAKE_INSTALL_PREFIX}/bin/bibletime.exe\") ")

    IF(CMAKE_BUILD_TYPE STREQUAL "Debug")
        SET(ZLIB_LIBRARY ${ZLIB_LIBRARY_DEBUG})
    ELSE()
        SET(ZLIB_LIBRARY ${ZLIB_LIBRARY_RELEASE})
    ENDIF()

    MESSAGE(STATUS  "INSTALL Zlib_LIBRARY ${ZLIB_LIBRARY}" )
    STRING(REPLACE ".lib" ".dll" ZLIB_DLL "${ZLIB_LIBRARY}")
    INSTALL(FILES ${ZLIB_DLL} DESTINATION ${BT_DESTINATION})

    MESSAGE(STATUS  "INSTALL CLucene_LIBRARY ${CLucene_LIBRARY}" )
    STRING(REPLACE ".lib" ".dll" CLUCENE_DLL "${CLucene_LIBRARY}")
    INSTALL(FILES ${CLUCENE_DLL} DESTINATION ${BT_DESTINATION})

    MESSAGE(STATUS  "INSTALL CLucene_LIBRARY ${CLucene_SHARED_LIB}" )
    STRING(REPLACE ".lib" ".dll" CLUCENE_SHARED_DLL "${CLucene_SHARED_LIB}")
    INSTALL(FILES ${CLUCENE_SHARED_DLL} DESTINATION ${BT_DESTINATION})

    MESSAGE(STATUS  "INSTALL CURL_LIBRARY ${CURL_LIBRARY}" )
    STRING(REPLACE "_imp.lib" ".dll" CURL_DLL "${CURL_LIBRARY}")
    INSTALL(FILES ${CURL_DLL} DESTINATION ${BT_DESTINATION})

    SET(SWORD_DLL "${Sword_LIBRARY_DIRS}/sword.dll")
    MESSAGE(STATUS  "INSTALL SWORD_LIBRARY ${SWORD_DLL}" )
    INSTALL(FILES ${SWORD_DLL} DESTINATION ${BT_DESTINATION})

    # Some options for the CPack system.  These should be pretty self-evident
    SET(CPACK_PACKAGE_ICON "${CMAKE_CURRENT_SOURCE_DIR}\\\\pics\\\\icons\\\\bibletime.png")
    SET(CPACK_NSIS_INSTALLED_ICON_NAME "bin\\\\bibletime.exe")
    SET(CPACK_NSIS_DISPLAY_NAME "${CPACK_PACKAGE_INSTALL_DIRECTORY}")
    SET(CPACK_NSIS_HELP_LINK "http:\\\\\\\\www.bibletime.info")
    SET(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\www.bibletime.info")
    SET(CPACK_NSIS_CONTACT "bt-devel@crosswire.org")
    SET(CPACK_NSIS_MODIFY_PATH OFF)
    SET(CPACK_GENERATOR "NSIS")

    SET(CPACK_PACKAGE_EXECUTABLES "bibletime" "BibleTime")

    # This adds in the required Windows system libraries
    MESSAGE(STATUS  "INSTALL Microsoft Redist ${MSVC_REDIST}" )
    SET(CPACK_NSIS_EXTRA_INSTALL_COMMANDS "
        ExecWait \\\"$INSTDIR\\\\bin\\\\vcredist_x86.exe  /q\\\"
        Delete   \\\"$INSTDIR\\\\bin\\\\vcredist_x86.exe\\\"
    ")

    INCLUDE(CPack)

ENDIF(WIN32 AND NOT UNIX)

