//
// BAGEL - Parallel electron correlation program.
// Filename: _r2root_2.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root2(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[2] = {5.857886722809685e-01,3.414226587031987e+00};
  constexpr double aw[2] = {4.267783233468789e-01,7.322358402358216e-02};
  constexpr double x[1054] = {  2.865970157019227e-01,  2.948538308279342e-02,  1.839200647449686e-03,  6.471114065040126e-05, -7.433248473661826e-07,
 -2.532292036268259e-07, -1.435146717713722e-08, -1.341625397864645e-10,  3.792432445017854e-11,  2.970150893412537e-12,  7.030802574470450e-14, -5.144820370255235e-15,
  1.558140610836833e+00,  3.585494641340562e-02, -1.635966445788037e-03,  2.657352694985419e-05,  2.703192407300337e-06, -2.217234382145987e-07,  3.670494072077213e-09,
  4.376281229381440e-10, -3.471473040693733e-11,  5.446340386596916e-13,  7.830819906557541e-14, -5.668567479273047e-15,  4.379472684263130e-01,  4.660469424521846e-02,
  2.321933206230654e-03, -3.921525793245692e-06, -8.422780491838611e-06, -4.085133438388949e-07,  1.357303017077623e-08,  2.350425146669200e-09,  6.163249335746857e-11,
 -6.667272419628865e-12, -5.895392160758895e-13, -1.853352613503910e-15,  1.678053114391786e+00,  2.448482368225179e-02, -1.181688930125147e-03,  4.140369068415005e-05,
 -3.844557606971795e-07, -8.256497678148373e-08,  5.321770637246095e-09, -1.347161207571933e-10, -1.944536203890262e-12,  5.820987610675781e-13, -3.026556462619337e-14,
  8.500809849600234e-17,  6.574491961144960e-01,  6.230824687606157e-02,  1.315841790487265e-03, -1.641362836416328e-04, -8.269313384352307e-06,  5.860923734840178e-07,
  4.940445450391646e-08, -1.841855322408895e-09, -2.708251850895023e-10,  3.584822006502329e-12,  1.366711162708569e-12,  9.589251144836154e-15,  1.759968124631849e+00,
  1.682744555350401e-02, -7.571911070015106e-04,  2.774295456878698e-05, -1.046801531392773e-06,  4.478937858793752e-09,  2.315185193911194e-09, -6.663790975173551e-11,
  1.192007773678803e-12, -2.378785899704144e-13, -4.358870490774331e-15,  1.077809720634870e-15,  9.136142488616629e-01,  6.387342897584188e-02, -9.325340795639043e-04,
 -1.686615096385714e-04,  7.733250465139772e-06,  5.949263883023128e-07, -4.882829172479653e-08, -1.868853529403173e-09,  2.713930828407501e-10,  3.841874485075997e-12,
 -1.380707720865795e-12,  7.283852778314527e-15,  1.816899166959078e+00,  1.184010040718913e-02, -5.137888704679817e-04,  1.407873856497809e-05, -5.607147584600765e-07,
  3.521333818236664e-08,  1.041407096696408e-12, -1.079669523345527e-10, -3.025761843340823e-14,  3.113828986499429e-13,  1.174619257929631e-14, -1.416422841676261e-15,
  1.144982783125312e+00,  5.089070835847648e-02, -2.036614712156608e-03, -1.502639841583597e-05,  8.166216601785093e-06, -3.900980460999875e-07, -1.323766802391449e-08,
  2.340168534108537e-09, -6.354341771027820e-11, -6.734043185205177e-12,  6.068190014608625e-13, -1.745009506851746e-15,  1.856958529793575e+00,  8.301961191627714e-03,
 -3.779374959972071e-04,  9.850749648087040e-06, -5.669775376214723e-08,  9.114585464723557e-09, -1.473075712330773e-09,  3.241435611837083e-11,  4.855819699630097e-12,
 -2.453236297469806e-13, -1.430870889264806e-14,  1.293032137461758e-15,  1.317139017512249e+00,  3.548099475023035e-02, -1.698746872878716e-03,  5.267417423747532e-05,
  8.813970489738051e-07, -2.356171491309403e-07,  1.386786994569283e-08, -1.606690138051982e-10, -3.648399110110659e-11,  3.016681775438152e-12, -7.811014685234179e-14,
 -5.023926514888644e-15,  1.884851707900416e+00,  5.739643752446106e-03, -2.640391346443162e-04,  8.984144205055497e-06, -1.038644032187989e-07, -7.197586433523670e-09,
  1.115082531477151e-10,  3.812834392945503e-11, -2.657174329158124e-12, -4.968657651001934e-15,  9.977450285388007e-15, -4.696419806604986e-16,  1.435884171577372e+00,
  2.440494173123944e-02, -1.086562107260047e-03,  4.429444379256186e-05, -1.215631320531524e-06, -1.379061331989157e-08,  4.297042941029498e-09, -2.886820438376611e-10,
  9.922827644721491e-12,  3.918756202120366e-14, -2.879078791329633e-14,  1.961923945395610e-15,  1.904216756807439e+00,  4.021475795339734e-03, -1.698696410385541e-04,
  6.523001369937316e-06, -1.782008594431641e-07,  2.572418789970916e-10,  2.777155190994551e-10, -1.191571703399219e-11, -2.358256331422438e-13,  5.326040280890196e-14,
 -2.664059146163731e-15,  9.542838041578838e-18,  1.519023102903731e+00,  1.751224052914679e-02, -6.687057679617333e-04,  2.610374040752904e-05, -9.422391869443738e-07,
  2.478883570637453e-08,  9.475532576551613e-12, -5.295628952058693e-11,  3.886154407497809e-12, -1.710312850771897e-13,  4.266536465055513e-15,  4.020999117659188e-17,
  1.918014851712282e+00,  2.929328844356341e-03, -1.076687979828807e-04,  3.962425954829805e-06, -1.327229337862187e-07,  3.191136501137809e-09,  1.998657638364386e-12,
 -5.309519357138562e-12,  2.967072103996690e-13, -6.227743896643396e-15, -2.936214748586956e-16,  3.387359669286810e-17,  1.580042530005932e+00,  1.319535010934839e-02,
 -4.304199325044021e-04,  1.469373786315180e-05, -5.115893363315418e-07,  1.673522341254766e-08, -4.321059825741749e-10,  3.736917286644733e-12,  4.584376705975995e-13,
 -3.795115886551906e-14,  1.829700202875556e-15, -6.195556633510581e-17,  1.928265836573465e+00,  2.226758735211113e-03, -7.084470879783331e-05,  2.317784824122251e-06,
 -7.592081938689178e-08,  2.291171567545032e-09, -5.215108980369307e-11,  1.742406054067824e-13,  6.424612570682416e-14, -4.131149508515764e-15,  1.456461719998777e-16,
 -1.950153293459104e-18,  1.626886719700453e+00,  1.034016871487337e-02, -2.938456461839306e-04,  8.675752711094708e-06, -2.674337871235689e-07,  8.408094221326111e-09,
 -2.524932465082394e-10,  6.382089281458278e-12, -9.126295874334183e-14, -2.587438340474589e-15,  2.873447183438912e-16, -1.469501051593744e-17,  1.936190413540537e+00,
  1.753665223557327e-03, -4.901632969531997e-05,  1.406066553220583e-06, -4.147127187513006e-08,  1.227951447083995e-09, -3.406971153001144e-11,  7.586279962253353e-13,
 -6.516831294357861e-15, -5.330741812626858e-16,  3.972998180094762e-17, -1.648449710958528e-18,  1.664117018795161e+00,  8.344014388802204e-03, -2.107769456691263e-04,
  5.467152309922276e-06, -1.472577624661109e-07,  4.131575305104822e-09, -1.183631740636237e-10,  3.286643478186697e-12, -8.059896169247179e-14,  1.401183631175798e-15,
  3.298835161928934e-18, -1.707151148827062e-18,  1.942513887524769e+00,  1.419357050999462e-03, -3.543984614870677e-05,  9.012267143293292e-07, -2.353495753912850e-08,
  6.319667743415281e-10, -1.710113398814609e-11,  4.411416424726067e-13, -9.660796152256223e-15,  1.224770872231315e-16,  2.881778404135693e-18, -2.897667436141727e-19,
  1.694486784769994e+00,  6.885581330905256e-03, -1.570068392764790e-04,  3.644364915548866e-06, -8.689273511625529e-08,  2.148761552632331e-09, -5.523246135012326e-11,
  1.451734700794551e-12, -3.743909914734035e-14,  8.833774971092781e-16, -1.665140634694174e-17,  1.347609389038230e-19,  1.947684840567252e+00,  1.173529856484378e-03,
 -2.652953420196305e-05,  6.071095911668781e-07, -1.416124212733018e-08,  3.392464821416349e-10, -8.357325152127644e-12,  2.082918885911663e-13, -5.025298829199630e-15,
  1.076471855933915e-16, -1.641550536839776e-18, -4.242622109967101e-21,  1.719764395532934e+00,  5.783679396415367e-03, -1.203986474418871e-04,  2.537578730073376e-06,
 -5.447132382190223e-08,  1.200733318481732e-09, -2.740696004209298e-11,  6.489727519147142e-13, -1.573472058866517e-14,  3.780316188702843e-16, -8.529226745160672e-18,
  1.650507934840323e-19,  1.951995791112638e+00,  9.870364995477397e-04, -2.041037473041028e-05,  4.256086805747146e-07, -8.990006501054119e-09,  1.936223232707293e-10,
 -4.281639948840812e-12,  9.736323304783966e-14, -2.247789917860680e-15,  5.088245907367701e-17, -1.058147133834971e-18,  1.761392768358487e-20,  1.741146820569608e+00,
  4.929097730224890e-03, -9.448550619261585e-05,  1.827711280043368e-06, -3.581068476808469e-08,  7.146633202574900e-10, -1.463504189387662e-11,  3.097632826137252e-13,
 -6.789131709953998e-15,  1.525182341019901e-16, -3.421919560175847e-18,  7.349866344813542e-20,  1.955646612520775e+00,  8.419995436602830e-04, -1.605418345652185e-05,
  3.079646461866496e-07, -5.960107665932893e-09,  1.168846734278784e-10, -2.337201811326061e-12,  4.795699237195793e-14, -1.011705247092808e-15,  2.173108365400465e-17,
 -4.624361216471016e-19,  9.273382956718684e-21,  1.759477890097041e+00,  4.252178663301570e-03, -7.557381767400938e-05,  1.352566440560550e-06, -2.443562515055187e-08,
  4.472189404212794e-10, -8.334700043719107e-12,  1.592249931136535e-13, -3.137979213396087e-15,  6.392392348920464e-17, -1.335680008664756e-18,  2.803344489837480e-20,
  1.958779072165349e+00,  7.268871217165029e-04, -1.286239953486586e-05,  2.286556387319881e-07, -4.090823341244949e-09,  7.385975106979974e-11, -1.351475070472931e-12,
  2.520647730726211e-14, -4.820586454877036e-16,  9.474631739179400e-18, -1.900227647905439e-19,  3.805336389060287e-21,  1.775371651004110e+00,  3.706480763421748e-03,
 -6.142517841989854e-05,  1.023618729933812e-06, -1.718124461245320e-08,  2.911484071173376e-10, -4.997860185359782e-12,  8.731995338918004e-14, -1.561956101059238e-15,
  2.876815903781533e-17, -5.467309687227759e-19,  1.065716052157686e-20,  1.961496764119833e+00,  6.339525858687549e-04, -1.046762405048409e-05,  1.734698855000413e-07,
 -2.888653223242148e-09,  4.842041322353010e-11, -8.192077718487528e-13,  1.404525426361201e-14, -2.453293352904994e-16,  4.389875658421557e-18, -8.068105331989871e-20,
  1.514947037448241e-21,  1.789286503338915e+00,  3.259943693152902e-03, -5.061805534285851e-05,  7.895259572135698e-07, -1.238533515288204e-08,  1.957171143070544e-10,
 -3.122498383927748e-12,  5.045374348321916e-14, -8.292051249156556e-16,  1.393457820048982e-17, -2.406568356683513e-19,  4.279867642116283e-21,  1.963877255978048e+00,
  5.578196978978477e-04, -8.634468386515727e-06,  1.340498781681148e-07, -2.089037102416829e-09,  3.271811200553198e-11, -5.158791776772029e-13,  8.210141197157845e-15,
 -1.323804511783633e-16,  2.173198712376932e-18, -3.650979695934889e-20,  6.293090986911192e-22,  1.801571998792747e+00,  2.889800905764012e-03, -4.221555786346511e-05,
  6.190353190477348e-07, -9.119708312912875e-09,  1.351363463228979e-10, -2.017258561959134e-12,  3.039949273271958e-14, -4.638155624073649e-16,  7.192442841030149e-18,
 -1.138926801714538e-19,  1.849581634306026e-21,  1.965979829372538e+00,  4.946558438746484e-04, -7.206807860686521e-06,  1.052578608445523e-07, -1.542065260954278e-09,
  2.268033129217479e-11, -3.352764764290850e-13,  4.989967234954016e-15, -7.495520359590739e-17,  1.140323299595116e-18, -1.764951210611688e-20,  2.791740605364953e-22,
  1.812499549108782e+00,  2.579499218572968e-03, -3.558123271227101e-05,  4.923733091685215e-07, -6.839932968779187e-09,  9.547053957057292e-11, -1.340396237138670e-12,
  1.895758507275918e-14, -2.706296910328726e-16,  3.909874066046882e-18, -5.736584037564395e-20,  8.581381433870124e-22,  1.967850593405757e+00,  4.416661677943924e-04,
 -6.078079952548120e-06,  8.381953959323297e-08, -1.158863553271946e-09,  1.607287891065247e-11, -2.238147774429557e-13,  3.132674530677502e-15, -4.414465966676278e-17,
  6.277444404619123e-19, -9.037043280005212e-21,  1.322207325536824e-22,  1.822283218128829e+00,  2.316757403183965e-03, -3.027158375642563e-05,  3.966261848374165e-07,
 -5.213779410894436e-09,  6.880805041919641e-11, -9.124439148981942e-13,  1.217079038455536e-14, -1.635235687259216e-16,  2.217098925782606e-18, -3.040760023337947e-20,
  4.230923255596650e-22,  1.969525964068253e+00,  3.967723270637931e-04, -5.173758560276649e-06,  6.758472505976811e-08, -8.847612391594089e-10,  1.161291677931920e-11,
 -1.529181510878350e-13,  2.021773823929583e-15, -2.686853992880469e-17,  3.594715764719037e-19, -4.852139078631336e-21,  6.625962893147570e-23,  1.831094172707481e+00,
  2.092302035098293e-03, -2.597074032669839e-05,  3.231312718606051e-07, -4.031772470929126e-09,  5.047365447326609e-11, -6.344064731537240e-13,  8.012272620969942e-15,
 -1.017820525318420e-16,  1.302204358670891e-18, -1.680783135286332e-20,  2.193023711250454e-22,  1.971035091679318e+00,  3.584021153908936e-04, -4.440611647536140e-06,
  5.510484699389728e-08, -6.850737151876284e-10,  8.535786926434799e-12, -1.066375947145114e-13,  1.336591823644731e-15, -1.682105680818849e-17,  2.127830448699853e-19,
 -2.709468706182308e-21,  3.479307132153138e-23,  1.839070953589332e+00,  1.899021470281706e-03, -2.244938874196649e-05,  2.659415989216962e-07, -3.158118900510475e-09,
  3.761108228252436e-11, -4.494403430387435e-13,  5.392249003686935e-15, -6.500474251819514e-17,  7.881608072825477e-19, -9.622895280035850e-21,  1.184736795061918e-22,
  1.972401591294347e+00,  3.253480448003891e-04, -3.839905060940285e-06,  4.538205192682947e-08, -5.372064290273050e-10,  6.371152444872912e-12, -7.573076012010074e-14,
  9.026172422253312e-16, -1.079363145366301e-17,  1.295977177759045e-19, -1.563993730175475e-21,  1.899374239559569e-23,  1.846326918962214e+00,  1.731386148715318e-03,
 -1.953821332447925e-05,  2.208908162727775e-07, -2.502645792873223e-09,  2.842504531891610e-11, -3.237901230274368e-13,  3.700867444209767e-15, -4.247006330351081e-17,
  4.896893259624126e-19, -5.678177560182459e-21,  6.627894580802016e-23,  1.973644799749675e+00,  2.966701052064493e-04, -3.342985280110636e-06,  3.771532253691511e-08,
 -4.260964960437869e-10,  4.821780229030906e-12, -5.466913538647403e-14,  6.212532252636362e-16, -7.079175592253508e-18,  8.093436610565753e-20, -9.290517487380632e-22,
  1.071677472868938e-23,  1.852955732538957e+00,  1.585043108940794e-03, -1.711029464288381e-05,  1.850069321079385e-07, -2.004190792164635e-09,  2.175885390411421e-11,
 -2.368246734613058e-13,  2.585160063488537e-15, -2.831565161991463e-17,  3.113827796938919e-19, -3.440275693750604e-21,  3.821509459168667e-23,  1.974780704262604e+00,
  2.716275537544465e-04, -2.928340098896333e-06,  3.160346080162394e-08, -3.414942184604333e-10,  3.695320585646781e-12, -4.005376473773408e-14,  4.349927944406610e-16,
 -4.735024524947511e-18,  5.168389203247249e-20, -5.660067093570726e-22,  6.222638932246154e-24,  1.859035472395943e+00,  1.456527126860176e-03, -1.506919019492866e-05,
  1.561353692351004e-07, -1.620476915920951e-09,  1.685076968505088e-11, -1.756123327012656e-13,  1.834818039237219e-15, -1.922664848969000e-17,  2.021563690112864e-19,
 -2.133942290654841e-21,  2.262684870473201e-23,  1.975822638766912e+00,  2.496302095866110e-04, -2.579601671132839e-06,  2.668242816238038e-08, -2.762958684141560e-10,
  2.864641219423796e-12, -2.974385785509627e-14,  3.093551185087506e-16, -3.223841580153956e-18,  3.367420264410104e-20, -3.527070916337724e-22,  3.706017401603167e-24,
  1.864631749880022e+00,  1.343051540608405e-03, -1.334070693334130e-05,  1.326911606017404e-07, -1.321779886714100e-09,  1.318922926662196e-11, -1.318639924872034e-13,
  1.321294871379985e-15, -1.327333567433760e-17,  1.337306259250824e-19, -1.351898240819692e-21,  1.371828861357684e-23,  1.976781813185631e+00,  2.302031163744566e-04,
 -2.284164339847168e-06,  2.268399965093599e-08, -2.254957770966333e-10,  2.244104658697519e-12, -2.236166621562080e-14,  2.231544380335539e-16, -2.230734156550542e-18,
  2.234355698693595e-20, -2.243190768398988e-22,  2.258006064533319e-24,  1.869800106792404e+00,  1.242354526328027e-03, -1.186712356927145e-05,  1.134927771917303e-07,
 -1.086876408727531e-09,  1.042455462323393e-11, -1.001585477615300e-13,  9.642128196471621e-16, -9.303130372652327e-18,  8.998954300850603e-20, -8.730092673964715e-22,
  8.496709228368540e-24,  1.977667720686024e+00,  2.129605303676734e-04, -2.032211810283901e-06,  1.940795260404834e-08, -1.855131145367405e-10,  1.775024028227116e-12,
 -1.700309615512180e-14,  1.630857717645824e-16, -1.566576391618833e-18,  1.507417692828557e-20, -1.453385660603219e-22,  1.404415290919788e-24,  1.874587878885837e+00,
  1.152584600716496e-03, -1.060306953855769e-05,  9.764868683236000e-08, -9.003985101467430e-10,  8.313854215530815e-12, -7.688550276881851e-14,  7.122738184816625e-16,
 -6.611631984269611e-18,  6.150960186344157e-20, -5.736938314232983e-22,  5.365775497906084e-24,  1.978488454570513e+00,  1.975865193448662e-04, -1.816021933139535e-06,
  1.670303129009139e-08, -1.537507839218953e-10,  1.416545906652139e-12, -1.306429117216441e-14,  1.206263382298040e-16, -1.115241928632851e-18,  1.032639510386245e-20,
 -9.578076955544903e-23,  8.900939494172659e-25,  1.879035659602769e+00,  1.072214290670153e-03, -9.512543627682058e-06,  8.447864410348518e-08, -7.510739272032311e-10,
  6.685916900428225e-12, -5.960005303790392e-14,  5.321247963412169e-16, -4.759327752599242e-18,  4.265195382605540e-20, -3.830919565368462e-22,  3.449274511665742e-24,
  1.979250957392993e+00,  1.838203170586928e-04, -1.629462924002319e-06,  1.445371021999447e-08, -1.283011896665783e-10,  1.139819489806247e-12, -1.013535578405315e-14,
  9.021731653353175e-17, -8.039843401018474e-19,  7.174320921181605e-21, -6.411656260333161e-23,  5.739525359931539e-25,  1.883178460823735e+00,  9.999743060724407e-04,
 -8.566728906976846e-06,  7.345826289519743e-08, -6.305360273628187e-10,  5.418419762008547e-12, -4.662139191015255e-14,  4.017088927970983e-16, -3.466757925821438e-18,
  2.997114692394021e-20, -2.596234741404420e-22,  2.253813397372465e-24,  1.979961218649756e+00,  1.714451445542490e-04, -1.467623619290713e-06,  1.257085525630868e-08,
 -1.077467452760995e-10,  9.241988595029431e-13, -7.933891317307432e-15,  6.817261951952715e-17, -5.863903102088244e-19,  5.049807764357014e-21, -4.354536163119543e-23,
  3.760404152682851e-25,  1.887046641470738e+00,  9.348028247704441e-04, -7.742372049735182e-06,  6.417945015983156e-08, -5.325064929203856e-10,  4.422874564313051e-12,
 -3.677768902818235e-14,  3.062103337535946e-16, -2.553132588619935e-18,  2.132139061843692e-20, -1.783716765807627e-22,  1.495077260519778e-24,  1.980624433031490e+00,
  1.602795901781540e-04, -1.326538899330289e-06,  1.098504624951279e-08, -9.102257348257728e-11,  7.547277921610993e-13, -6.262653204031220e-15,  5.201046274193823e-17,
 -4.323450997333963e-19,  3.597721414895994e-21, -2.997361444764503e-23,  2.500353989853329e-25,  1.890666656460571e+00,  8.758060452311949e-04, -7.020567938688763e-06,
  5.632180574625775e-08, -4.522260348392993e-10,  3.634527576206822e-12, -2.924133294191559e-14,  2.355329911247968e-16, -1.899617667795713e-18,  1.534269541726328e-20,
 -1.241157185678119e-22,  1.005749920051873e-24,  1.981245128129167e+00,  1.501708995416225e-04, -1.202983556118809e-06,  9.641743489145159e-09, -7.732069500695605e-11,
  6.204481745789308e-13, -4.982113232627349e-15,  4.003618849936022e-17, -3.220032675864094e-19,  2.592262894874902e-21, -2.089094746260403e-23,  1.685488167850572e-25,
 -2.003580155156858e+00,  2.114999083286317e-03, -3.839580422968201e-04,  6.977421460896726e-05, -1.269272992318622e-05,  2.311403235382208e-06, -4.213753479052401e-07,
  7.690380730580471e-08, -1.405155699117684e-08,  2.570380914344440e-09, -4.702559726373307e-10,  8.342019249275743e-11, -2.003470512230760e+00,  2.045192337315363e-03,
 -3.653572363838705e-04,  6.534279813299009e-05, -1.170022147813703e-05,  2.097622802724661e-06, -3.765468624349885e-07,  6.768479407167181e-08, -1.218333207918661e-08,
  2.196108048942784e-09, -3.960537284121426e-10,  6.933394491871035e-11, -2.001699466319606e+00,  9.995166004751665e-04, -1.761918597774345e-04,  3.106556092756644e-05,
 -5.478620112797070e-06,  9.664133356618804e-07, -1.705122189247786e-07,  3.009193352075106e-08, -5.311870274184494e-09,  9.378572812533716e-10, -1.654755664721310e-10,
  2.834609718260676e-11, -2.001673758300994e+00,  9.832311185448677e-04, -1.719521689707937e-04,  3.007938771461437e-05, -5.263100038143193e-06,  9.211441527553123e-07,
 -1.612608664592163e-07,  2.823890728344556e-08, -4.946364068144655e-09,  8.666310011274142e-10, -1.517470040795435e-10,  2.580908308975824e-11, -2.000828849157430e+00,
  4.864768049610078e-04, -8.457995740947039e-05,  1.470604620511677e-05, -2.557099649092387e-06,  4.446545746310288e-07, -7.732525948441397e-08,  1.344756435404601e-08,
 -2.338779581989868e-09,  4.067686954096401e-10, -7.068960401043729e-11,  1.193508695002776e-11, -2.000822616441514e+00,  4.825377005663870e-04, -8.356557999775954e-05,
  1.447269398680846e-05, -2.506670913011055e-06,  4.341816736991845e-07, -7.520939784604182e-08,  1.302864992313066e-08, -2.257113047255432e-09,  3.910419088829839e-10,
 -6.769429057063591e-11,  1.138776691425755e-11, -2.000409402424622e+00,  2.400535898154337e-04, -4.145789495854416e-05,  7.159981999804893e-06, -1.236580148818006e-06,
  2.135690328690328e-07, -3.688586536207899e-08,  6.370703056297996e-09, -1.100322869515638e-09,  1.900412116428166e-10, -3.279572021463627e-11,  5.500473802505241e-12,
 -2.000407867497365e+00,  2.390845984078517e-04, -4.120968034331392e-05,  7.103185449235319e-06, -1.224371889816965e-06,  2.110473306699194e-07, -3.637916451616239e-08,
  6.270929818198033e-09, -1.080978958345399e-09,  1.863366295246213e-10, -3.209404132497385e-11,  5.372925382742513e-12, -2.000203469305514e+00,  1.192466510230705e-04,
 -2.052641919874816e-05,  3.533308760706889e-06, -6.082069540447580e-07,  1.046941871433181e-07, -1.802167508567008e-08,  3.102195278931336e-09, -5.340036142469927e-10,
  9.192000172621162e-11, -1.580949565742870e-11,  2.643111707830571e-12, -2.000203088418935e+00,  1.190063320737185e-04, -2.046501968116474e-05,  3.519296092280910e-06,
 -6.052028926860886e-07,  1.040753148955888e-07, -1.789765060748167e-08,  3.077838768748586e-09, -5.292939789141588e-10,  9.102045998922602e-11, -1.563956899157123e-11,
  2.612300468018935e-12, -2.000101429558017e+00,  5.943024500691560e-05, -1.021324257572587e-05,  1.755173767947197e-06, -3.016316698678179e-07,  5.183631304323349e-08,
 -8.908233990608413e-09,  1.530909316456913e-09, -2.630918240858904e-10,  4.521213844206427e-11, -7.763296290458790e-12,  1.295880026238169e-12, -2.000101334688299e+00,
  5.937040369699187e-05, -1.019797335416730e-05,  1.751693534982151e-06, -3.008865433508326e-07,  5.168300860824121e-08, -8.877551360890364e-09,  1.524891613103995e-09,
 -2.619297530218177e-10,  4.499047415402084e-11, -7.721477967175655e-12,  1.288306820194704e-12, -2.000050638861199e+00,  2.966709366359236e-05, -5.094211364399614e-06,
  8.747400360596593e-07, -1.502038741664661e-07,  2.579190087270838e-08, -4.428795769730681e-09,  7.604804142541854e-10, -1.305840670680296e-10,  2.242239238007715e-11,
 -3.846962891127705e-12,  6.416535144327154e-13, -2.000050615187531e+00,  2.965216297400247e-05, -5.090404073015149e-06,  8.738728216042092e-07, -1.500183218080350e-07,
  2.575374960252586e-08, -4.421165070199957e-09,  7.589847994154906e-10, -1.302954389395064e-10,  2.236737264291360e-11, -3.836589823481066e-12,  6.397761197820191e-13,
 -2.000025300495362e+00,  1.482156958892636e-05, -2.544013350672375e-06,  4.366611923619162e-07, -7.494968779242817e-08,  1.286456428238642e-08, -2.208108227797804e-09,
  3.790056140783379e-10, -6.505349642279689e-11,  1.116568070614922e-11, -1.914893194572595e-12,  3.192713466792246e-13, -2.000025294582401e+00,  1.481784061099009e-05,
 -2.543062775346640e-06,  4.364447427979331e-07, -7.490339043904356e-08,  1.285504820444363e-08, -2.206205518134442e-09,  3.786328045307580e-10, -6.498157389730794e-11,
  1.115197492584527e-11, -1.912310030544890e-12,  3.188039683629309e-13, -2.000012645519382e+00,  7.407794217619307e-06, -1.271234856183092e-06,  2.181537488923074e-07,
 -3.743687369327014e-08,  6.424457688136909e-09, -1.102486746381091e-09,  1.891952713602326e-10, -3.246735247023948e-11,  5.571511495612514e-12, -9.553098167585001e-13,
  1.592488264663985e-13, -2.000012644041823e+00,  7.406862434302883e-06, -1.270997368028360e-06,  2.180996806689902e-07, -3.742531067067274e-08,  6.422081378941582e-09,
 -1.102011687784432e-09,  1.891022052959133e-10, -3.244940104686758e-11,  5.568091170740016e-12, -9.546652832676847e-13,  1.591322270653726e-13, -2.000006321578304e+00,
  3.703149930584893e-06, -6.354246309620650e-07,  1.090327074117727e-07, -1.870895578023891e-08,  3.210275483140341e-09, -5.508521600187355e-10,  9.452089031170083e-11,
 -1.621885699419669e-11,  2.782929757116209e-12, -4.771219922982750e-13,  7.952795093566507e-14, -2.000006321208999e+00,  3.702917042361810e-06, -6.353652783665431e-07,
  1.090191958713810e-07, -1.870606643741990e-08,  3.209681744181584e-09, -5.507334726077531e-10,  9.449764080805929e-11, -1.621437278279538e-11,  2.782075439426819e-12,
 -4.769610157825182e-13,  7.949883166328479e-14, -2.000003160493891e+00,  1.851388228937872e-06, -3.176641358868471e-07,  5.450531753932634e-08, -9.352109057153958e-09,
  1.604649744860320e-09, -2.753283551718381e-10,  4.724127610018701e-11, -8.105727391025739e-12,  1.390759157102074e-12, -2.384279266229884e-13,  3.973989099025225e-14,
 -2.000003160401576e+00,  1.851330014080360e-06, -3.176493001673361e-07,  5.450194034331335e-08, -9.351386897950741e-09,  1.604501352385292e-09, -2.752986929667381e-10,
  4.723546584909169e-11, -8.104606793321492e-12,  1.390545673027464e-12, -2.383877020804274e-13,  3.973261499006553e-14,     0.995405185725972,     0.973218237020255,
     0.997707243768449,     0.986636689148782,     0.998854761300549,     0.993325041445136,     0.999427662704154,     0.996664171515387,     0.999713901522235,
      0.99833249558976,     0.999856968261151,     0.999166349898398,     0.999928488500296,     0.999583200430999,     0.999964245341919,     0.999791606580454,
      0.99998212294382,     0.999895804880779,     0.999991061540115,     0.999947902837942,     0.999995530787107,     0.999973951518348  };
  constexpr double w[1054] = {  6.909961894068787e-01, -2.481362049085455e-01,  5.043662894988601e-02, -7.201020518528624e-03,  7.955855187884865e-04,
 -7.176467142124536e-05,  5.471953806106182e-06, -3.614252066191177e-07,  2.106041352952890e-08, -1.098311538978220e-09,  5.186645382208816e-11, -2.236589924860402e-12,
  5.052918239157295e-01, -8.348709165067535e-02,  1.051610113610950e-02, -1.098692223755731e-03,  9.864746882626769e-05, -7.809255169552660e-06,  5.537673306975264e-07,
 -3.549490016583173e-08,  2.067629504813216e-09, -1.096577300575763e-10,  5.292887968687449e-12, -2.318063572682894e-13,  1.625379942553103e-01, -4.941478747795010e-02,
  9.250852344420657e-03, -1.246858817526868e-03,  1.324132322632654e-04, -1.161393306948203e-05,  8.669293126789031e-07, -5.633620157960823e-08,  3.240394618314930e-09,
 -1.670815238587940e-10,  7.809231060363982e-12, -3.333178671871890e-13,  2.826966636684965e-01, -3.370045336624167e-02,  3.308462031940131e-03, -2.866098194012898e-04,
  2.209076340456603e-05, -1.535704899475583e-06,  9.804513109258549e-08, -5.771627706107448e-09,  3.149474809042359e-10, -1.603688191346273e-11,  7.585790493142027e-13,
 -3.327234484051246e-14,  5.249895580665401e-02, -1.155102464530675e-02,  1.917697913431204e-03, -2.360539895722159e-04,  2.343898171686858e-05, -1.970552295395188e-06,
  1.426010903861606e-07, -9.025588986680674e-09,  5.101377742976169e-10, -2.598965740759269e-11,  1.196000544737362e-12, -5.053233741386088e-14,  1.852440345170768e-01,
 -1.669324712586579e-02,  1.278007905227337e-03, -9.070037462162742e-05,  6.022884081714419e-06, -3.613880253911334e-07,  2.023048024426859e-08, -1.088939781484246e-09,
  5.381364294378986e-11, -2.477085836447536e-12,  1.149788153714467e-13, -4.852372271425965e-15,  2.521590427747586e-02, -3.274014063107783e-03,  4.631594581171086e-04,
 -5.161886510776776e-05,  4.575148997656449e-06, -3.535836494806394e-07,  2.479812783829002e-08, -1.530069307172187e-09,  8.192514256127524e-11, -4.054934896434722e-12,
  1.942519510892141e-13, -8.064405423912657e-15,  1.337811753291893e-01, -9.602644884694854e-03,  5.930365702480472e-04, -3.345283320841894e-05,  1.925218317027066e-06,
 -1.060549776672125e-07,  4.897977689487406e-09, -2.161264412925404e-10,  1.163525972863816e-11, -5.292597506127745e-13,  1.209899567841210e-14, -4.986895980769857e-16,
  1.685235260753553e-02, -1.184738917251627e-03,  1.244350243192687e-04, -1.320417356329698e-05,  1.093214550771855e-06, -7.140749971265282e-08,  4.257262788126382e-09,
 -2.653918878340915e-10,  1.575123986167099e-11, -7.201755888602911e-13,  2.329684062171029e-14, -9.250966029760192e-16,  1.028861789621556e-01, -6.067970352849390e-03,
  3.228842201294131e-04, -1.472766277350701e-05,  6.431557025345317e-07, -3.363744282284222e-08,  1.799724732974476e-09, -6.267468053841471e-11,  8.059368166823295e-13,
 -5.596568484344593e-14,  1.049256430564476e-14, -4.415319271928293e-16,  1.341156980994956e-02, -6.074599931904535e-04,  3.678876733992313e-05, -3.342189678356364e-06,
  2.969740251619229e-07, -2.018062221690534e-08,  1.000285318920957e-09, -3.915960094927802e-11,  1.829529531192709e-12, -1.331976697071637e-13,  8.718939258122528e-15,
 -3.194327849430339e-16,  8.285653022108148e-02, -4.055536070776436e-03,  1.917817830281911e-04, -8.020432112071805e-06,  2.744606649524661e-07, -8.620093824323018e-09,
  4.329290467733115e-10, -3.012437403669387e-11,  1.379542482810206e-12, -7.844036445904567e-15, -2.870271171037764e-15,  9.149874178102460e-17,  1.139876999639792e-02,
 -4.165047366188613e-04,  1.527989797312333e-05, -8.072017506992843e-07,  6.667940862395463e-08, -5.381587933311040e-09,  3.349307026002799e-10, -1.480271764201040e-11,
  4.037333930107135e-13, -3.795862733732548e-15,  9.202805501350650e-17, -4.101935514523452e-17,  6.918474311316095e-02, -2.842133179827671e-03,  1.174375560694725e-04,
 -4.649854806012043e-06,  1.602613216963216e-07, -4.156261181887282e-09,  6.808199522602874e-11, -2.153202974906531e-12,  2.980143735375751e-13, -2.443409932719391e-14,
  1.001046734189936e-15,  6.117787133529759e-19,  9.933543591441971e-03, -3.208158304798969e-04,  9.532017331181381e-06, -2.810362679505139e-07,  1.281449678578009e-08,
 -9.999772264749516e-10,  7.699929720354164e-11, -4.661807151525153e-12,  2.097347350107020e-13, -6.271639905750299e-15,  5.663613196750269e-17,  5.644131250995343e-18,
  5.939569649810176e-02, -2.088026767859725e-03,  7.454191605057840e-05, -2.670887900856560e-06,  9.163987078308910e-08, -2.730840159918423e-09,  5.751824372429675e-11,
 -2.210096646905809e-13, -3.238809667560805e-14, -1.172420509276851e-16,  1.694282226533618e-16, -1.342161462481197e-17,  8.784959540444958e-03, -2.556050612471778e-04,
  6.961223793442391e-06, -1.687816473392080e-07,  3.839011163104558e-09, -1.452360853328621e-10,  1.128910938557050e-11, -8.637707188065856e-13,  5.183806869530989e-14,
 -2.403990382997118e-15,  8.323877159514333e-17, -1.781579775907053e-18,  5.206358147913966e-02, -1.598649860220948e-03,  4.971895180014332e-05, -1.570557592850866e-06,
  4.980494598619804e-08, -1.519924003458863e-09,  4.080351340684588e-11, -7.795127553801736e-13,  3.678700605496422e-16,  7.398929687443823e-16, -3.034228135254578e-17,
  1.191588310796491e-19,  7.862358141656034e-03, -2.071277744583922e-04,  5.240032297147142e-06, -1.215531556763628e-07,  2.385714275866023e-09, -3.777818813083830e-11,
  1.038103264556371e-12, -9.340799027159330e-14,  7.642704608156020e-15, -4.627700122652837e-16,  2.178094071052247e-17, -8.104694237294900e-19,  4.636159371748623e-02,
 -1.264738548451616e-03,  3.480305376434841e-05, -9.708165190807828e-07,  2.751473195868085e-08, -7.841654117451091e-10,  2.167901938158852e-11, -5.385897583163646e-13,
  1.006827760990331e-14, -3.699235464529293e-17, -7.611672540559733e-18,  4.088061537423377e-19,  7.109297397346390e-03, -1.704447133069811e-04,  3.988308310113170e-06,
 -8.861427794873371e-08,  1.762202039166285e-09, -2.740856584794329e-11,  2.190551237323059e-13, -6.432811453408811e-16,  4.817707961346662e-16, -5.284565364428352e-17,
  3.376825863396496e-18, -1.608416596805710e-19,  4.179490388564121e-02, -1.026460468355727e-03,  2.535619482369716e-05, -6.322808038123120e-07,  1.599046897838402e-08,
 -4.110544548793229e-10,  1.065004486741071e-11, -2.700278763953331e-13,  6.296339161851114e-15, -1.179715283921960e-16,  9.558161677271209e-19,  5.043133611003552e-20,
  6.485220936853704e-03, -1.423521778286834e-04,  3.076967877011588e-06, -6.450909652834220e-08,  1.269209462905574e-09, -2.171598567416743e-11,  2.568478751333895e-13,
  5.630161045265217e-16, -1.127809589911983e-16,  3.578698781014243e-19,  2.645654624798323e-19, -2.018785781982636e-20,  3.805212425786569e-02, -8.501568204122896e-04,
  1.907145879731225e-05, -4.305224983353819e-07,  9.815167253707119e-09, -2.270088073381148e-10,  5.338753512679567e-12, -1.268472653292306e-13,  2.973990730909766e-15,
 -6.549282660580521e-17,  1.226417741444669e-18, -1.412438766458615e-20,  5.960587618219634e-03, -1.205184799458488e-04,  2.411453468462970e-06, -4.734273932529653e-08,
  8.959161136895072e-10, -1.571633027313548e-11,  2.316444260056545e-13, -1.922551506156737e-15, -3.519889135058868e-17,  2.105537137889276e-18, -4.343465999900676e-20,
 -5.745412720695644e-22,  3.492728520357723e-02, -7.158856248975921e-04,  1.471728150227319e-05, -3.038784327041912e-07,  6.316066945910544e-09, -1.326170307079799e-10,
  2.825051184862307e-12, -6.120991472295952e-14,  1.342722157879808e-15, -2.927668084383497e-17,  6.103757444122366e-19, -1.130644408640139e-20,  5.513813795470247e-03,
 -1.032776382529366e-04,  1.919900424505887e-06, -3.524044579951070e-08,  6.324187520453634e-10, -1.087225152848649e-11,  1.710294309842012e-13, -2.169293611040667e-15,
  1.049825940432191e-17,  5.696649690036792e-19, -2.590316905363856e-20,  6.281918468393879e-22,  3.227831105064619e-02, -6.111957884995194e-04,  1.160008238747782e-05,
 -2.208625791261165e-07,  4.224417527080083e-09, -8.135418792873103e-11,  1.582848781730676e-12, -3.124147472064553e-14,  6.272488864768736e-16, -1.277242989524441e-17,
  2.600753239403573e-19, -5.136133400838091e-21,  5.128966140461063e-03, -8.945313431576038e-05,  1.551219640556129e-06, -2.665806999480016e-08,  4.513553720941769e-10,
 -7.445442866788775e-12,  1.169318747857473e-13, -1.657520854436682e-15,  1.803059834205445e-17, -2.370680066347524e-20, -6.582387723039214e-21,  2.553184155437397e-22,
  3.000381807050170e-02, -5.279590679299911e-04,  9.307542688180919e-06, -1.644859607109372e-07,  2.916510942906126e-09, -5.195753625505607e-11,  9.320693562696860e-13,
 -1.689172580920953e-14,  3.104768559999141e-16, -5.804619704377269e-18,  1.102077014663879e-19, -2.101840864469410e-21,  4.794106661876252e-03, -7.821059597252496e-05,
  1.270192501645613e-06, -2.048980655274928e-08,  3.270793946725867e-10, -5.132955429681449e-12,  7.821257955329099e-14, -1.127650545495514e-15,  1.446283997452193e-17,
 -1.341003765139421e-19, -3.261846017762571e-22,  6.244716857881635e-23,  2.802942642821019e-02, -4.606725646276509e-04,  7.582945678356286e-06, -1.250623897828075e-07,
  2.067827214207956e-09, -3.430740873199532e-11,  5.719412205023900e-13, -9.601430109179284e-15,  1.628088046448825e-16, -2.798955154698432e-18,  4.893325990383574e-20,
 -8.692674451635514e-22,  4.500146218774282e-03, -6.895079022850136e-05,  1.052629871995355e-06, -1.598567139065181e-08,  2.408851632096416e-10, -3.586892568764661e-12,
  5.239770673042685e-14, -7.407003063162233e-16,  9.846204480261091e-18, -1.146535286111187e-19,  8.973049599517021e-22,  5.923666828827323e-24,  2.629928944974870e-02,
 -4.054972612415460e-04,  6.260254788485940e-06, -9.680241530783035e-08,  1.499860223857697e-09, -2.329941869891242e-11,  3.632082036828179e-13, -5.689471053161427e-15,
  8.973934135867691e-17, -1.429372351780626e-18,  2.307230783340168e-20, -3.784785126132873e-22,  4.240056055965668e-03, -6.123658344721702e-05,  8.817629431147489e-07,
 -1.264354224802435e-08,  1.802115984551350e-10, -2.546179061364616e-12,  3.549934709333662e-14, -4.845575627485864e-16,  6.379277732181839e-18, -7.848321081025551e-20,
  8.320495198018371e-22, -5.418621745355572e-24,  2.477064032635387e-02, -3.596863620406039e-04,  5.228633807028406e-06, -7.610781309264859e-08,  1.109634234812253e-09,
 -1.621148377639658e-11,  2.374748314829175e-13, -3.490960572440427e-15,  5.156721276162335e-17, -7.669112801063746e-19,  1.151421894460834e-20, -1.750567995092761e-22,
  4.008321471569155e-03, -5.474394314324808e-05,  7.457985467895254e-07, -1.012548342674925e-08,  1.368178188247602e-10, -1.836331791507668e-12,  2.440783699440781e-14,
 -3.196998634415985e-16,  4.091438629265033e-18, -5.033747810663892e-20,  5.750801605988688e-22, -5.563426448340656e-24,  2.341016478518301e-02, -3.212314280882691e-04,
  4.412085064660851e-06, -6.066801295151551e-08,  8.353469378315997e-10, -1.152125116740433e-11,  1.592359891195837e-13, -2.206727072137619e-15,  3.068969601695598e-17,
 -4.288614556815618e-19,  6.032712665942266e-21, -8.562132845661645e-23,  3.800558040299084e-03, -4.922896206706129e-05,  6.363106568902543e-07, -8.201180938876878e-09,
  1.052938812828516e-10, -1.344695268023182e-12,  1.704579269002311e-14, -2.137797879350439e-16,  2.638599202103773e-18, -3.175723069545795e-20,  3.662532501196772e-22,
 -3.896794847307615e-24,  2.219152093067431e-02, -2.886358578583488e-04,  3.757277838941743e-06, -4.895739757257135e-08,  6.386522148103920e-10, -8.342839431496734e-12,
  1.091695562276538e-13, -1.431559269008056e-15,  1.882301880087065e-17, -2.483701348849012e-19,  3.292727884830936e-21, -4.392564331945554e-23,  3.613237781241732e-03,
 -4.450540253720253e-05,  5.471840255241285e-07, -6.711278492884089e-09,  8.205128394962022e-11, -9.988481457024095e-13,  1.208853479564891e-14, -1.451168198539758e-16,
  1.721919410494263e-18, -2.008159650819866e-20,  2.279285184754941e-22, -2.470694001944534e-24,  2.109360279392575e-02, -2.607656960893169e-04,  3.226020034783960e-06,
 -3.994396080558539e-08,  4.950690818315153e-10, -6.143148125351987e-12,  7.633598162451054e-14, -9.501997652766474e-16,  1.185296817165364e-17, -1.482556112838699e-19,
  1.860845009565928e-21, -2.346069822516792e-23,  3.443490685491916e-03, -4.042917601832422e-05,  4.739139064531291e-07, -5.543787670987906e-09,  6.467600224041024e-11,
 -7.518660891440599e-13,  8.699411373815337e-15, -1.000161437430065e-16,  1.139786381719609e-18, -1.282714706890983e-20,  1.416995223561327e-22, -1.520332876083939e-24,
  2.009929914814845e-02, -2.367489199896308e-04,  2.790464113714490e-06, -3.291455035334780e-08,  3.885740048765355e-10, -4.591955061007134e-12,  5.433000713680436e-14,
 -6.437280341338519e-16,  7.640438159059622e-18, -9.087882959212967e-20,  1.083859307714461e-21, -1.296919131133451e-23,  3.288958692317901e-03, -3.688744828122451e-05,
  4.131354309945533e-07, -4.618809285259047e-09,  5.151932493572911e-11, -5.729547576895396e-13,  6.347264447395086e-15, -6.995624886493789e-17,  7.657243111170738e-19,
 -8.302330906664078e-21,  8.881561218119711e-23, -9.313540827225799e-25,  1.919458994329008e-02, -2.159059613879071e-04,  2.429975786502236e-06, -2.736689997164219e-08,
  3.084450936229629e-10, -3.479448922823173e-12,  3.929048383558216e-14, -4.442102783157592e-16,  5.029392103277981e-18, -5.704248321072495e-20,  6.483478885849164e-22,
 -7.387807234791959e-24,  3.147686735736417e-03, -3.379087465546982e-05,  3.623025284257596e-07, -3.878515494129414e-09,  4.143813369684582e-11, -4.416103529201233e-13,
  4.691062429314083e-15, -4.962235750886806e-17,  5.220140603361341e-19, -5.450949251471510e-21,  5.634519875082963e-23, -5.740830236033042e-25,  1.836787769122236e-02,
 -1.977008448681054e-04,  2.129042425682072e-06, -2.294117985991379e-08,  2.473649043347899e-10, -2.669278719766996e-12,  2.882937376181188e-14, -3.116921231923520e-16,
  3.374000968188769e-18, -3.657575126794734e-20,  3.971892296716825e-22, -4.321866127730970e-24,  3.018040385006563e-03, -3.106798571952200e-05,  3.194655417437388e-07,
 -3.280486489290921e-09,  3.362827702079539e-11, -3.439772723354281e-13,  3.508835346073413e-15, -3.566762749008476e-17,  3.609278681262978e-19, -3.630724504132541e-21,
  3.623547589748489e-23, -3.577225086772673e-25,  1.760948539048614e-02, -1.817062257945115e-04,  1.875847738196737e-06, -1.937559486571511e-08,  2.002497239323873e-10,
 -2.071017471299374e-12,  2.143548593162253e-14, -2.220611279719239e-16,  2.302846069356947e-18, -2.391051495968482e-20,  2.486237840110667e-22, -2.589422050104529e-24,
  2.898642833249465e-03, -2.866107255982844e-05,  2.831149403367254e-07, -2.793212428729194e-09,  2.751622451619632e-11, -2.705559143242129e-13,  2.654017497818434e-15,
 -2.595757604609636e-17,  2.529237815196418e-19, -2.452524476803353e-21,  2.363167798845956e-23, -2.257829393225627e-25,  1.691127446813186e-02, -1.675779807831808e-04,
  1.661282808709253e-06, -1.647698396579083e-08,  1.635101502547875e-10, -1.623583119452771e-12,  1.613254282478198e-14, -1.604251275358674e-16,  1.596742527941263e-18,
 -1.590937894619108e-20,  1.587101347533984e-22, -1.585409709904684e-24,  2.788326148850396e-03, -2.652313274427385e-05,  2.520699546556885e-07, -2.393012590201370e-09,
  2.268760139360713e-11, -2.147421757151911e-13,  2.028438550404566e-15, -1.911200199304994e-17,  1.795028342847476e-19, -1.679154932799603e-21,  1.562693483502451e-23,
 -1.444480321509102e-25,  1.626635051679163e-02, -1.550364771371757e-04,  1.478248617659615e-06, -1.410098776706326e-08,  1.345741975018413e-10, -1.285019665346467e-12,
  1.227788450919732e-14, -1.173920814585650e-16,  1.123306247634511e-18, -1.075852916159931e-20,  1.031490061758876e-22, -9.900798495285330e-25,  2.686093170486331e-03,
 -2.461557676519798e-05,  2.253981810856730e-07, -2.061895575954534e-09,  1.883936941031929e-11, -1.718840315998597e-13,  1.565425409432249e-15, -1.422586264208407e-17,
  1.289280217488119e-19, -1.164516457789357e-21,  1.047343727541612e-23, -9.367633653906532e-26,  1.566883413696760e-02, -1.438525859053813e-04,  1.321156749067910e-06,
 -1.213844220630260e-08,  1.115738222474394e-10, -1.026063673777691e-12,  9.441142786456765e-15, -8.692469567107896e-17,  8.008768600709286e-19, -7.384729590356012e-21,
  6.815541903708831e-23, -6.296322664880706e-25,  2.591087436046417e-03, -2.290648663706934e-05,  2.023568316534816e-07, -1.786053307585731e-09,  1.574738156901422e-11,
 -1.386635410275663e-13,  1.219091639178096e-15, -1.069748338665428e-17,  9.365071069762549e-20, -8.174985437871925e-22,  7.110543381603639e-24, -6.156367738347444e-26,
  1.511368066382583e-02, -1.338371125977047e-04,  1.185567064717051e-06, -1.050589838048141e-08,  9.313526665535657e-11, -8.260150646348331e-13,  7.329537938929232e-15,
 -6.507372782225415e-17,  5.781030740728361e-19, -5.139380396122496e-21,  4.572608888472613e-23, -4.071744799115966e-25,  2.502569240287770e-03, -2.136928017727192e-05,
  1.823493077795799e-07, -1.554787751023335e-09,  1.324407234686509e-11, -1.126864092380846e-13,  9.574560587147520e-16, -8.121529061409332e-18,  6.874996005317943e-20,
 -5.805333721035064e-22,  4.887126659592431e-24, -4.098278623620115e-26,  1.459653702144581e-02, -1.248327227868972e-04,  1.067921453073150e-06, -9.138922771667263e-09,
  7.823658871343348e-11, -6.700396559607204e-13,  5.740977288689948e-15, -4.921391178268581e-17,  4.221164490408957e-19, -3.622837842583763e-21,  3.111521701598105e-23,
 -2.674319670040616e-25,  2.419896414304892e-03, -1.998167667769166e-05,  1.648927559722288e-07, -1.359736975332735e-09,  1.120292148768618e-11, -9.220574200942424e-14,
  7.579612722042938e-16, -6.221447177077747e-18,  5.097529969866645e-20, -4.167631117578128e-22,  3.398410088551834e-24, -2.762052950108762e-26,  1.411362707406567e-02,
 -1.167077111455697e-04,  9.653458987931726e-07, -7.987299981356769e-09,  6.610941965842970e-11, -5.473781604168892e-13,  4.534077349093403e-15, -3.757394283677137e-17,
  3.115322367915910e-19, -2.584419959570801e-21,  2.145342952174476e-23, -1.782003656622457e-25,  2.342508776566869e-03, -1.872488882253673e-05,  1.495935843508744e-07,
 -1.194310849456774e-09,  9.527504144522708e-12, -7.593373182412129e-14,  6.045163169526521e-16, -4.806258400765695e-18,  3.815226196607664e-20, -3.022807863275023e-22,
  2.389506396039093e-24, -1.883536714876922e-26,  1.366165906445284e-02, -1.093511478915195e-04,  8.755017547851421e-07, -7.011555818211684e-09,  5.617029482498392e-11,
 -4.501390530154236e-13,  3.608684252257931e-15, -2.894208887117672e-17,  2.322248512214190e-19, -1.864263353710014e-21,  1.497445106439784e-23, -1.203485668695546e-25,
  2.003039076046978e+00, -1.769953978461176e-03,  2.913391134807301e-04, -4.754148426073764e-05,  7.674595440331418e-06, -1.221956817703320e-06,  1.910751618409392e-07,
 -2.915070339241920e-08,  4.292654885342771e-09, -5.984350396000771e-10,  7.586884122424653e-11, -7.926267905665982e-12,  2.003379904558266e+00, -1.987510985941589e-03,
  3.499942520543699e-04, -6.168366706484562e-05,  1.088071080369100e-05, -1.921070486369341e-06,  3.395085481578993e-07, -6.006248379062706e-08,  1.063716375653238e-08,
 -1.885960145469867e-09,  3.344679502362565e-10, -5.762243900948621e-11,  2.001574042135819e+00, -9.200041218717288e-04,  1.554204209843568e-04, -2.621702828408333e-05,
  4.415242037922641e-06, -7.422519745348967e-07,  1.245357461267031e-07, -2.084924943739530e-08,  3.482038799866258e-09, -5.799506561048187e-10,  9.623289386807292e-11,
 -1.550513953572480e-11,  2.001652492835935e+00, -9.697611228228385e-04,  1.684469026142823e-04, -2.926435335748753e-05,  5.085041012860561e-06, -8.837545277120528e-07,
  1.536217126308517e-07, -2.670911237076087e-08,  4.644661722251197e-09, -8.078444786503165e-10,  1.404167953809592e-10, -2.371530098120378e-11,  2.000798601969593e+00,
 -4.673536136225599e-04,  7.964718880339500e-05, -1.356935793377340e-05,  2.311033749159865e-06, -3.934641864663674e-07,  6.696524587070167e-08, -1.139284138519955e-08,
  1.937515697923801e-09, -3.293605311728703e-10,  5.592066012393532e-11, -9.231980696418938e-12,  2.000817457225714e+00, -4.792772252925930e-04,  8.272616619433583e-05,
 -1.427963744428169e-05,  2.464959932197152e-06, -4.255211728700440e-07,  7.346007046073410e-08, -1.268237486969045e-08,  2.189620411329864e-09, -3.780470056668580e-10,
  6.521971407385372e-11, -1.093566739836150e-11,  2.000401972537088e+00, -2.353623176820391e-04,  4.025519463409951e-05, -6.884549208188791e-06,  1.177326770867979e-06,
 -2.013194799135673e-07,  3.442240153877776e-08, -5.885216014430050e-09,  1.006117059237152e-09, -1.719843143353522e-10,  2.937268058698568e-11, -4.877749803729739e-12,
  2.000406596447467e+00, -2.382822138977057e-04,  4.100417047340457e-05, -7.056166772461101e-06,  1.214266663956232e-06, -2.089602905295175e-07,  3.595985543007978e-08,
 -6.188374832176914e-09,  1.064975232360982e-09, -1.832720942380612e-10,  3.151365976045354e-11, -5.267437133202022e-12,  2.000201627928370e+00, -1.180847399287735e-04,
  2.022943839409409e-05, -3.465503289026242e-06,  5.936646222892755e-07, -1.016970395584323e-07,  1.742078261191817e-08, -2.984139585058359e-09,  5.111664636501523e-10,
 -8.755626152888527e-11,  1.498482328204019e-11, -2.493522522595243e-12,  2.000202772948332e+00, -1.188072899604156e-04,  2.041416951647337e-05, -3.507691800595650e-06,
  6.027153124768670e-07, -1.035628784821102e-07,  1.779496318108176e-08, -3.057673870797924e-09,  5.253951015082738e-10, -9.027582200045076e-11,  1.549891329296005e-11,
 -2.586798197372079e-12,  2.000100971201670e+00, -5.914111340909637e-05,  1.013945209352781e-05, -1.738351611017085e-06,  2.980292552699488e-07, -5.109498756787367e-08,
  8.759832775051052e-09, -1.501797692607178e-09,  2.574689390948878e-10, -4.413935231403514e-11,  7.560866413622516e-12, -1.259213248393862e-12,  2.000101256103953e+00,
 -5.932083513075838e-05,  1.018532578210453e-05, -1.748810940900800e-06,  3.002693942519074e-07, -5.155603901358035e-08,  8.852140313356593e-09, -1.519907983143492e-09,
  2.609674036312976e-10, -4.480691292726260e-11,  7.686849195411750e-12, -1.282035825074549e-12,  2.000050524519132e+00, -2.959497797803827e-05,  5.075820149912355e-06,
 -8.705505024644147e-07,  1.493073733017763e-07, -2.560755288506840e-08,  4.391920179563057e-09, -7.532520561295172e-10,  1.291889718521782e-10, -2.215642460389889e-11,
  3.796813823538983e-12, -6.325762794814191e-13,  2.000050595576661e+00, -2.963979468674677e-05,  5.087250243177044e-06, -8.731544634365425e-07,  1.498646219833412e-07,
 -2.572214806144192e-08,  4.414844503977055e-09, -7.577459920465338e-10,  1.300563744556319e-10, -2.232180177234176e-11,  3.827998333748646e-12, -6.382211936095543e-13,
  2.000025271940632e+00, -1.480356150364990e-05,  2.539422570934012e-06, -4.356158006509423e-07,  7.472607275146738e-08, -1.281859948020081e-08,  2.198917233109911e-09,
 -3.772046725100202e-10,  6.470604016069108e-11, -1.109946491024546e-11,  1.902412683887803e-12, -3.170131068087436e-13,  2.000025289684074e+00, -1.481475151221997e-05,
  2.542275322193062e-06, -4.362654383432614e-07,  7.486503855603595e-08, -1.284716532878888e-08,  2.204629376043133e-09, -3.783239840974713e-10,  6.492199669692763e-11,
 -1.114062180940521e-11,  1.910170297996888e-12, -3.184168244004111e-13,  2.000012638384542e+00, -7.403294796728206e-06,  1.270088037561673e-06, -2.178926493648266e-07,
  3.738103353882473e-08, -6.412981716723991e-09,  1.100192473999823e-09, -1.887458016405125e-10,  3.238065243351670e-11, -5.554991913634640e-12,  9.521967499432055e-13,
 -1.586856430819709e-13,  2.000012642817789e+00, -7.406090530696368e-06,  1.270800630054725e-06, -2.180548901161731e-07,  3.741573181181087e-08, -6.420112842669052e-09,
  1.101618150643329e-09, -1.890251099849485e-10,  3.243453027274550e-11, -5.565257821442439e-12,  9.541313630961913e-13, -1.590356385791124e-13,  2.000006319795074e+00,
 -3.702025400160731e-06,  6.351380357415703e-07, -1.089674635449786e-07,  1.869500368199971e-08, -3.207408391112305e-09,  5.502790257394080e-10, -9.440861841505454e-11,
  1.619720244729381e-11, -2.778804148069153e-12,  4.763446061071969e-13, -7.938732672563792e-14,  2.000006320903059e+00, -3.702724112811968e-06,  6.353161095235418e-07,
 -1.090080026736037e-07,  1.870367286030359e-08, -3.209189882565971e-09,  5.506351505235681e-10, -9.447838068140418e-11,  1.621065802446550e-11, -2.781367717063482e-12,
  4.768276620791671e-13, -7.947470917111345e-14,  2.000003160048144e+00, -1.851107136915742e-06,  3.175925007545702e-07, -5.448901044733028e-08,  9.348622024494582e-09,
 -1.603933209280708e-09,  2.751851257840619e-10, -4.721322005672188e-11,  8.100316309507459e-12, -1.389728290058354e-12,  2.382336900087382e-13, -3.970475636502441e-14,
  2.000003160325099e+00, -1.851281787484752e-06,  3.176370099120166e-07, -5.449914259863031e-08,  9.350788645784982e-09, -1.604378421014388e-09,  2.752741202147995e-10,
 -4.723065252859249e-11,  8.103678470293187e-12, -1.390368819227843e-12,  2.383543794294988e-13, -3.972658744204039e-14,   0.00334744107194711,  0.000574250122515674,
   0.00167037998722564,  0.000286582283098398,  0.000834365647935441,  0.000143153334085197,  0.000416978042950007,  7.15419757306386e-05,  0.000208437986811567,
  3.57622865423363e-05,  0.000104206254656289,  1.78789644652063e-05,  5.20999451205936e-05,  8.93893710203416e-06,  2.60491773177829e-05,  4.46933221506987e-06,
  1.30243898868971e-05,  2.23463201690555e-06,  6.51214525527685e-06,  1.11730748496638e-06,  3.25606020619872e-06,  5.58651611508043e-07  };
  int offset = -2;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 2;
    if (std::isnan(t)) {
      fill_n(rr+offset, 2, 0.5);
      fill_n(ww+offset, 2, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 2; ++r) {
        ww[offset+r] = aw[2-r-1] / t;
        rr[offset+r] = 1.0 - ax[2-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=2; ++j) {
        const int boxof = it*24+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 1032 + (it - 32) * 2 + 2 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
