/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 19:14:53 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import java.io.Writer;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class BlastStreamFeature_ESTest extends BlastStreamFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      Location location0 = mock(Location.class, new ViolatedAssumptionAnswer());
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, (QualifierVector) null);
      // Undeclared exception!
      try { 
        blastStreamFeature0.writeToStream((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      // Undeclared exception!
      try { 
        BlastStreamFeature.readFromStream((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      Location location0 = mock(Location.class, new ViolatedAssumptionAnswer());
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, (QualifierVector) null);
      BlastStreamFeature blastStreamFeature1 = new BlastStreamFeature(blastStreamFeature0);
      assertFalse(blastStreamFeature1.equals((Object)blastStreamFeature0));
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      BlastStreamFeature blastStreamFeature0 = BlastStreamFeature.readFromStream(linePushBackReader0);
      assertNull(blastStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn(0).when(linePushBackReader0).getLineNumber();
      doReturn("94kO%A?n7gdfBf").when(linePushBackReader0).readLine();
      try { 
        BlastStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // invalid Blast line (not enough fields): 94kO%A?n7gdfBf
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      BlastStreamFeature blastStreamFeature0 = null;
      try {
        blastStreamFeature0 = new BlastStreamFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      Location location0 = mock(Location.class, new ViolatedAssumptionAnswer());
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, (QualifierVector) null);
      Feature feature0 = blastStreamFeature0.copy();
      assertFalse(feature0.equals((Object)blastStreamFeature0));
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      Location location0 = mock(Location.class, new ViolatedAssumptionAnswer());
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, (QualifierVector) null);
      Writer writer0 = mock(Writer.class, new ViolatedAssumptionAnswer());
      blastStreamFeature0.writeToStream(writer0);
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      Location location0 = mock(Location.class, new ViolatedAssumptionAnswer());
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, (QualifierVector) null);
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      try { 
        blastStreamFeature0.setFromStream(entryInformation0, linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }
}
