# -*- coding: utf-8 -*-
#   thanks to Dave Arter <davea@sucs.org>
#   Copyright (c) 2005 Dave Arter
from subprocess import Popen
from subprocess import PIPE

class  AptFtpArchive:

    """Mkisofs is a wrapper for the mkisofs program. It simplifies
    calls to mkisofs and tracks its progress. An optional hook is
    provided which will be called whenever a percentage progress is
    reported by mkisofs."""

    def __init__(self):
        self.progress_hook = None
        self.progress = 0.0
        self.retval = None

    def set_progress_hook(self, hook = None):

        """Sets the progress hook function to the argument hook. The
        function specified by hook should accept a floating point number
        as its only argument."""

        if (callable(hook)):
            self.progress_hook = hook

    def _set_progress(self, progress):
        try:
            self.progress = float(progress)
        except ValueError:
            pass

    def report_progress(self):

        """Calls the progress hook if one has been specified."""
        if callable(self.progress_hook):
            self.progress_hook(self.progress)

    def execute(self, command, path, destination):

        """Takes a source file path and creates an iso file with it, which
        is written to the isofile path. mkisofs is called with option -r.
        See the mkisofs manual for details"""
        args = command
        inFile = open(destination,'w')
        process = Popen(args, 1, stdout=inFile, stderr=PIPE, cwd = path, shell = True )
        self.retval = process.poll()
        while (self.retval is None):
            self._set_progress(-1)
            self.report_progress()
            self.retval = process.poll()

        inFile.close()

    def get_retval(self):

        """Gets the value returned by mkisofs or None if it hasn't
        finished a run."""

        return self.retval
