# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from apache_openid import logging
from apache_openid.request import Request
from apache_openid.utils import DONE, HTTP_MOVED_TEMPORARILY, SERVER_RETURN


class Response(Request):

    def __init__(self, request, action_path, session):
        self.apache_request = request.request
        super(Response, self).__init__(request, action_path, session)

    def login_redirect(self, message=None, target=None, logout=False):
        """Issue a 302 redirect to the OpenID login page."""
        if target:
            logging.debug('Setting target: %r', target)
            self.session['target'] = target
        self.session['message'] = message
        self.session['logout'] = logout
        #self.handler.clear_user()
        self.redirect(self.request.action_url('login'))

    def redirect(self, url=None):
        # This function raises an exception, so it will halt anything
        # that calls it. This is probably what you want, but beware!
        #try:
        #    util.redirect(self.request, url)
        #except IOError:
        #    # Mask the symptom of body content being output
        #    # too early. This is not a proper fix, but will
        #    # at least avoid tracebacks.
        #    raise apache.SERVER_RETURN, apache.DONE

        # The below will perform a request without printing
        # any default Apache method, but browser cookies
        # will also not be set on the first page load.
        #self.request.log_error("redirecting to: %r" % url)
        if url is None:
            url = self.request.action_path
        self.request.request.headers_out['location'] = url
        self.request.request.status = HTTP_MOVED_TEMPORARILY
        self.session.save()
        raise SERVER_RETURN, DONE
