# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from apache_openid.handlers.openid.handler import OpenIDLoginHandler
from apache_openid.handlers.openidteams.actions import *
from apache_openid.handlers.openidteams.authenticator import TeamsAuthenticator


class OpenIDTeamsLoginHandler(OpenIDLoginHandler):
    actions = {
        '+login': TeamsLoginAction,
        '+logout': TeamsLogoutAction,
        '+return': TeamsReturnAction,
        }

    def _get_authenticator(self):
        return TeamsAuthenticator(self.request, self.options, self.session)
