//
// Cross-platform free Puyo-Puyo clone.
// Copyright (C) 2006, 2007 Emma's software
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#if !defined (AMOEBAX_JOYSTICK_H)
#define AMOEBAX_JOYSTICK_H

#include "Options.h"

namespace Amoebax
{
    ///
    /// \class Joystick.
    /// \brief Handles player joystick's events.
    ///
    class Joystick
    {
        public:
            ///
            /// \enum Action
            /// \brief A game's action generated by a joystick event.
            ///
            enum Action
            {
                /// No action.
                Nothing,
                /// The down key was pressed.
                DownPressed,
                /// The down button was released.
                DownReleased,
                /// The left button was pressed.
                LeftPressed,
                /// The left button was released.
                LeftReleased,
                /// The right button was pressed.
                RightPressed,
                /// The right button was released.
                RightReleased,
                /// The clockwise rotation button was pressed.
                RotateCWPressed,
                /// The clockwise rotation button was released.
                RotateCWReleased,
                /// The counter clockwise rotation button was pressed.
                RotateCCWPressed,
                /// The counter clockwise rotation button was released.
                RotateCCWReleased
            };

            /// An axis values dead zone, to prevent false joystick's movements.
            static const int16_t k_DeadZone = 10000;

            Joystick (void);
            Action down (uint8_t joystick, uint8_t button);
            Action motion (uint8_t joystick, uint8_t axis, int16_t value);
            void setControls (const Options::PlayerControls &controls);
            Action up (uint8_t joystick, uint8_t button);

        private:
            int8_t getAxisXDirection (void) const;
            int8_t getAxisYDirection (void) const;
            bool hasConfiguration (void) const;
            void setAxisXDirection (int8_t direction);
            void setAxisYDirection (int8_t direction);

            /// The current direction of the joystick's X axis.
            int8_t m_AxisXDirection;
            /// The current direction of the joystick's Y axis.
            int8_t m_AxisYDirection;
            /// Tells if the joystick class has the player's configuration.
            bool m_HasConfiguration;
            /// The player's controls.
            Options::PlayerControls m_PlayerControls;
    };
}

#endif // AMOEBAX_JOYSTICK_H
