// ---------------------------------------------------------------------------
// - Krylov.hpp                                                              -
// - afnix:mth module - krylov based solver class definitions                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2012 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_KRYLOV_HPP
#define  AFNIX_KRYLOV_HPP

#ifndef  AFNIX_RVI_HPP
#include "Rvi.hpp"
#endif

#ifndef  AFNIX_RMI_HPP
#include "Rmi.hpp"
#endif
 
namespace afnix {

  /// The Krylov class is a class that implements various krylov space
  /// based algorithms used mostly with linear solver. The base design
  /// provides the implementation for preconditioned 'conjugate gradient
  /// squared' and the preconditioned 'bi-conjugate stabilized' algorithms. 
  /// @author amaury darsch

  class Krylov {
  public:
    /// solve a system with conjugate gradient squared method
    /// @param x  the result vector
    /// @param a  the system matrix
    /// @param b  the system vector
    /// @param ni the number of iterations
    static bool cgs (Rvi& x, const Rmi& a, const Rvi& b, const long ni);

    /// solve a system with a preconditioned conjugate gradient squared method
    /// @param x  the result vector
    /// @param a  the system matrix
    /// @param m  the diagonal preconditioner
    /// @param b  the system vector
    /// @param ni the number of iterations
    static bool cgs (Rvi& x, const Rmi& a, const Rvi& m, const Rvi& b,
		     const long ni);

    /// solve a system with bi-conjugate stabilized method
    /// @param x  the result vector
    /// @param a  the system matrix
    /// @param b  the system vector
    /// @param ni the number of iterations
    static bool bcs (Rvi& x, const Rmi& a, const Rvi& b, const long ni);

    /// solve a system with a preconditioned bi-conjugate stabilized method
    /// @param x  the result vector
    /// @param a  the system matrix
    /// @param m  the diagonal preconditioner
    /// @param b  the system vector
    /// @param ni the number of iterations
    static bool bcs (Rvi& x, const Rmi& a, const Rvi& m, const Rvi& b,
		     const long ni);
  };
}

#endif
