/* $Id: VBoxISAExec.c $ */
/** @file
 * VBoxISAExec, ISA exec wrapper, Solaris hosts.
 */

/*
 * Copyright (C) 2006-2023 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */


/*********************************************************************************************************************************
*   Header Files                                                                                                                 *
*********************************************************************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int main(int argc, char *argv[], char *envv[])
{
    int rc = 0;
    const char *pszExec = getexecname();

    if (!pszExec)
    {
        fprintf(stderr, "Failed to get executable name.\n");
        return -1;
    }

    rc = isaexec(pszExec, argv, envv);
    if (rc == -1)
        fprintf(stderr, "Failed to find/execute ISA specific executable for %s\n", pszExec);

    return rc;
}

