/* A Bison parser, made by GNU Bison 2.5.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2011 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         sfcXmlparse
#define yylex           sfcXmllex
#define yyerror         sfcXmlerror
#define yylval          sfcXmllval
#define yychar          sfcXmlchar
#define yydebug         sfcXmldebug
#define yynerrs         sfcXmlnerrs


/* Copy the first part of user declarations.  */

/* Line 268 of yacc.c  */
#line 1 "cimXmlOps.y"


/*
 * cimXmlOps.y
 *
 * (C) Copyright IBM Corp. 2005
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE ECLIPSE PUBLIC LICENSE
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Eclipse Public License from
 * http://www.opensource.org/licenses/eclipse-1.0.php
 *
 * Author:       Adrian Schuur <schuur@de.ibm.com>
 *
 * Description:
 *
 * CIM XML grammar for sfcb.
 *
*/


/*
**==============================================================================
**
** Includes
**
**==============================================================================
*/

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cmpidtx.h"
#include "cimXmlGen.h"
#include "cimXmlParser.h"
#include "cimXmlOps.h"
#include "objectImpl.h"
#include "constClass.h"
#include "native.h"
#include "control.h"

extern CMPIConstClass initConstClass(ClClass * cl);
extern MsgSegment setConstClassMsgSegment(CMPIConstClass * cl);
extern MsgSegment setInstanceMsgSegment(CMPIInstance *ci);
extern MsgSegment setArgsMsgSegment(CMPIArgs * args);
#ifdef HAVE_QUALREP
extern CMPIQualifierDecl initQualifier(ClQualifierDeclaration * qual);
#endif

int updateMethodParamTypes(RequestHdr * hdr);
//
// Define the global parser state object:
//

#define YYPARSE_PARAM parm
#define YYLEX_PARAM parm
#define YYERROR_VERBOSE 1


/* assumed max number of elements; used for initial malloc */
#define VALUEARRAY_MAX_START 32
#define VALUEREFARRAY_MAX_START 32
#define KEYBINDING_MAX_START 12

#ifdef LOCAL_CONNECT_ONLY_ENABLE
// from httpAdapter.c
int             noChunking = 0;
#endif                          // LOCAL_CONNECT_ONLY_ENABLE
extern int      noChunking;



extern int yyerror(void* parm, const char*);
extern int yylex (void *lvalp, ParserControl *parm);
//extern MsgSegment setInstanceMsgSegment(const CMPIInstance *ci);


static void setRequest(void *parm, void *req, unsigned long size, int type)
{
   ((ParserControl*)parm)->reqHdr.cimRequestLength=size;
   ((ParserControl*)parm)->reqHdr.cimRequest=malloc(size);
   memcpy(((ParserControl*)parm)->reqHdr.cimRequest,req,size);
   ((ParserControl*)parm)->reqHdr.opType = type;
}

static void
buildAssociatorNamesRequest(void *parm)
{
  CMPIObjectPath *path;
  AssociatorNamesReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  int       i, m;
  BinRequestContext *binCtx = hdr->binCtx;
  CMPIType        type;
  CMPIValue       val,
                 *valp;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildAssociatorNamesRequest");
  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokAssociatorNames *req = (XtokAssociatorNames *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  for (i = 0, m = req->objectName.bindings.next; i < m; i++) {
    valp = getKeyValueTypePtr(req->objectName.bindings.keyBindings[i].type,
                              req->objectName.bindings.keyBindings[i].
                              value,
                              &req->objectName.bindings.keyBindings[i].ref,
                              &val, &type, req->op.nameSpace.data);
    CMAddKey(path, req->objectName.bindings.keyBindings[i].name, valp,
             type);
  }

  if (req->objectName.bindings.next == 0) {
    free(hdr->binCtx->bHdr);
    hdr->rc = CMPI_RC_ERR_NOT_SUPPORTED;
    hdr->errMsg = strdup("AssociatorNames operation for classes not supported.");
    return;
  }
  if (!req->objNameSet) {
    free(hdr->binCtx->bHdr);
    hdr->rc = CMPI_RC_ERR_INVALID_PARAMETER;
    hdr->errMsg = strdup("ObjectName parameter required.");
    return;
  }
  sreq = calloc(1, sizeof(*sreq)); 
  sreq->hdr.operation = OPS_AssociatorNames;
  sreq->hdr.count = AIN_REQ_REG_SEGMENTS;

  sreq->objectPath = setObjectPathMsgSegment(path);

  sreq->resultClass = req->op.resultClass;
  sreq->role = req->op.role;
  sreq->assocClass = req->op.assocClass;
  sreq->resultRole = req->op.resultRole;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  req->op.className = req->op.assocClass;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq); 
  binCtx->type = CMPI_ref;
  binCtx->xmlAs = XML_asObjectPath;
  binCtx->noResp = 0;
  binCtx->pAs = NULL;

}

static void
buildAssociatorsRequest(void *parm)
{

  CMPIObjectPath *path;
  AssociatorsReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  int             i,m,
      sreqSize = sizeof(AssociatorsReq);        // -sizeof(MsgSegment);
  BinRequestContext *binCtx = hdr->binCtx;
  CMPIType        type;
  CMPIValue       val,
                 *valp;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildAssociatorsRequest");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokAssociators *req = (XtokAssociators *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);

  if (req->objectName.bindings.next == 0) {
    free(hdr->binCtx->bHdr);
    hdr->rc = CMPI_RC_ERR_NOT_SUPPORTED;
    hdr->errMsg = strdup("Associator operation for classes not supported.");
    return;
  }
  if (!req->objNameSet) {
    free(hdr->binCtx->bHdr);
    hdr->rc = CMPI_RC_ERR_INVALID_PARAMETER;
    hdr->errMsg = strdup("ObjectName parameter required.");
    return;
  }

  if (req->properties)
    sreqSize += req->properties * sizeof(MsgSegment);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_Associators;
  sreq->hdr.count = req->properties + AI_REQ_REG_SEGMENTS;

  for (i = 0, m = req->objectName.bindings.next; i < m; i++) {
    valp = getKeyValueTypePtr(req->objectName.bindings.keyBindings[i].type,
                              req->objectName.bindings.keyBindings[i].
                              value,
                              &req->objectName.bindings.keyBindings[i].ref,
                              &val, &type, req->op.nameSpace.data);
    CMAddKey(path, req->objectName.bindings.keyBindings[i].name, valp,
             type);
  }

  sreq->objectPath = setObjectPathMsgSegment(path);

  sreq->resultClass = req->op.resultClass;
  sreq->role = req->op.role;
  sreq->assocClass = req->op.assocClass;
  sreq->resultRole = req->op.resultRole;
  sreq->hdr.flags = req->flags;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  for (i = 0; i < req->properties; i++)
    sreq->properties[i] =
        setCharsMsgSegment(req->propertyList.values[i].value);

  req->op.className = req->op.assocClass;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;
  binCtx->type = CMPI_instance;
  binCtx->xmlAs = XML_asObj;
  binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildEnumInstanceRequest(void *parm)
{
  CMPIObjectPath *path;
  EnumInstancesReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  int    i,
      sreqSize = sizeof(EnumInstancesReq);      // -sizeof(MsgSegment);
  BinRequestContext *binCtx = hdr->binCtx;
  
  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildEnumInstancesRequest");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokEnumInstances *req = (XtokEnumInstances *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  if (req->properties)
    sreqSize += req->properties * sizeof(MsgSegment);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_EnumerateInstances;
  sreq->hdr.count = req->properties + EI_REQ_REG_SEGMENTS;

  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->hdr.sessionId = hdr->sessionId;

  for (i = 0; i < req->properties; i++) {
    sreq->properties[i] =
        setCharsMsgSegment(req->propertyList.values[i].value);
  }

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;

  binCtx->type = CMPI_instance;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildCreateInstanceRequest(void *parm)
{
  CMPIObjectPath *path;
  CMPIInstance   *inst;
  CMPIValue       val;
  CMPIStatus      st = { CMPI_RC_OK, NULL };
  CreateInstanceReq *sreq;
  XtokProperty   *p = NULL;

  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;
  CMPIStatus rc = {CMPI_RC_OK, NULL};

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokCreateInstance *req = (XtokCreateInstance *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  inst = TrackedCMPIInstance(path, NULL);

  sreq = calloc(1, sizeof(CreateInstanceReq));
  sreq->hdr.operation = OPS_CreateInstance;
  sreq->hdr.count = CI_REQ_REG_SEGMENTS;


  for (p = req->instance.properties.first; p; p = p->next) {
    if (p->val.val.value) {
      val =
          str2CMPIValue(p->valueType, p->val.val, &p->val.ref,
                        req->op.nameSpace.data, &rc);
      CMSetProperty(inst, p->name, &val, p->valueType);
    }
  }

  sreq->instance = setInstanceMsgSegment(inst);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  path = inst->ft->getObjectPath(inst, &st);
  /*
   * if st.rc is set the class was probably not found and the path is
   * NULL, so we don't set it. Let the provider manager handle unknown
   * class. 
   */
  if (!st.rc) {
    sreq->path = setObjectPathMsgSegment(path);
  }

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildGetInstanceRequest(void *parm)
{
  CMPIObjectPath *path;
  CMPIValue       val;
  CMPIType        type;
  GetInstanceReq *sreq;
  int             sreqSize = sizeof(GetInstanceReq);
  CMPIValue      *valp;
  int             i,
                  m;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  XtokGetInstance *req = (XtokGetInstance *)hdr->cimRequest;
  hdr->className = req->op.className.data;

  if (req->properties)
    sreqSize += req->properties * sizeof(MsgSegment);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_GetInstance;
  sreq->hdr.count = req->properties + GI_REQ_REG_SEGMENTS;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);

  for (i = 0, m = req->instanceName.bindings.next; i < m; i++) {
    valp =
        getKeyValueTypePtr(req->instanceName.bindings.keyBindings[i].type,
                           req->instanceName.bindings.keyBindings[i].value,
                           &req->instanceName.bindings.keyBindings[i].ref,
                           &val, &type, req->op.nameSpace.data);
    CMAddKey(path, req->instanceName.bindings.keyBindings[i].name, valp,
             type);
  }
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  for (i = 0; i < req->properties; i++) {
    sreq->properties[i] =
        setCharsMsgSegment(req->propertyList.values[i].value);
  }

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildGetClassRequest(void *parm)
{
  CMPIObjectPath *path;
  int             i,
                  sreqSize = sizeof(GetClassReq);       // -sizeof(MsgSegment);
  GetClassReq    *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokGetClass   *req = (XtokGetClass *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  if (req->properties)
    sreqSize += req->properties * sizeof(MsgSegment);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_GetClass;
  sreq->hdr.count=req->properties+GC_REQ_REG_SEGMENTS;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  for (i = 0; i < req->properties; i++)
    sreq->properties[i] =
        setCharsMsgSegment(req->propertyList.values[i].value);

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildDeleteClassRequest(void *parm)
{
  CMPIObjectPath *path;
  DeleteClassReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokDeleteClass *req = (XtokDeleteClass *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  sreq = calloc(1, sizeof(DeleteClassReq));
  sreq->hdr.operation = OPS_DeleteClass;
  sreq->hdr.count = DC_REQ_REG_SEGMENTS;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = 0;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildDeleteInstanceRequest(void *parm)
{
  CMPIObjectPath *path;
  int             i, m;
  CMPIType        type;
  CMPIValue       val,
                  *valp;
  DeleteInstanceReq *sreq;
  int             sreqSize = sizeof(DeleteInstanceReq);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;
  memset(binCtx, 0, sizeof(BinRequestContext));

  XtokDeleteInstance *req = (XtokDeleteInstance *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_DeleteInstance;
  sreq->hdr.count = DI_REQ_REG_SEGMENTS;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  for (i = 0, m = req->instanceName.bindings.next; i < m; i++) {
    valp =
        getKeyValueTypePtr(req->instanceName.bindings.keyBindings[i].type,
                           req->instanceName.bindings.keyBindings[i].value,
                           &req->instanceName.bindings.keyBindings[i].ref,
                           &val, &type, req->op.nameSpace.data);
    CMAddKey(path, req->instanceName.bindings.keyBindings[i].name, valp,
             type);
  }
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildCreateClassRequest(void *parm)
{
  CMPIConstClass *cls;
  CMPIObjectPath *path;
  ClClass        *cl;
  ClClass        *tmp;
  CreateClassReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  XtokProperty   *p = NULL;
  XtokProperties *ps = NULL;
  XtokQualifier  *q = NULL;
  XtokQualifiers *qs = NULL;
  XtokMethod     *m = NULL;
  XtokMethods    *ms = NULL;
  XtokParam      *r = NULL;
  XtokParams     *rs = NULL;
  XtokClass      *c;
  CMPIData        d;
  CMPIParameter   pa;
  CMPIStatus      rc = {CMPI_RC_OK, NULL};

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokCreateClass *req = (XtokCreateClass *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);

  cl = ClClassNew(req->op.className.data,
                  req->superClass ? req->superClass : NULL);
  c = &req->cls;

  qs = &c->qualifiers;
  for (q = qs->first; q; q = q->next) {
    if (q->value.value == NULL) {
      d.state = CMPI_nullValue;
      d.value.uint64 = 0;
    } else {
      d.state = CMPI_goodValue;
      d.value = str2CMPIValue(q->type, q->value, NULL, NULL, &rc);
    }
    d.type = q->type;
    ClClassAddQualifier(&cl->hdr, &cl->qualifiers, q->name, d);
  }

  ps = &c->properties;
  for (p = ps->first; p; p = p->next) {
    ClProperty     *prop;
    int             propId;
    if (p->val.val.value == NULL) {
      d.state = CMPI_nullValue;
      d.value.uint64 = 0;
    } else {
      d.state = CMPI_goodValue;
      d.value =
          str2CMPIValue(p->valueType, p->val.val, &p->val.ref,
                        req->op.nameSpace.data, &rc);
    }
    d.type = p->valueType;
    propId = ClClassAddProperty(cl, p->name, d, p->referenceClass);

    qs = &p->val.qualifiers;
    prop =
        ((ClProperty *) ClObjectGetClSection(&cl->hdr, &cl->properties)) +
        propId - 1;
    for (q = qs->first; q; q = q->next) {
      if (q->value.value == NULL) {
        d.state = CMPI_nullValue;
        d.value.uint64 = 0;
      } else {
        d.state = CMPI_goodValue;
        d.value = str2CMPIValue(q->type, q->value, NULL, NULL, &rc);
      }
      d.type = q->type;
      ClClassAddPropertyQualifier(&cl->hdr, prop, q->name, d);
    }
  }

  ms = &c->methods;
  for (m = ms->first; m; m = m->next) {
    ClMethod       *meth;
    ClParameter    *cl_parm;
    int             methId;

    methId = ClClassAddMethod(cl, m->name, m->type);
    meth =
        ((ClMethod *) ClObjectGetClSection(&cl->hdr, &cl->methods)) +
        methId - 1;

    qs = &m->qualifiers;
    for (q = qs->first; q; q = q->next) {
      if (q->value.value == NULL) {
        d.state = CMPI_nullValue;
        d.value.uint64 = 0;
      } else {
        d.state = CMPI_goodValue;
        d.value = str2CMPIValue(q->type, q->value, NULL, NULL, &rc);
      }
      d.type = q->type;
      ClClassAddMethodQualifier(&cl->hdr, meth, q->name, d);
    }

    rs = &m->params;
    for (r = rs->first; r; r = r->next) {
      pa.type = r->type;
      pa.arraySize = (unsigned int) r->arraySize;
      pa.refName = r->refClass;
      ClClassAddMethParameter(&cl->hdr, meth, r->name, pa);
      cl_parm = ((ClParameter *)
              ClObjectGetClSection(&cl->hdr,
                                   &meth->parameters)) + methId - 1;

      qs = &r->qualifiers;
      for (q = qs->first; q; q = q->next) {
        if (q->value.value == NULL) {
          d.state = CMPI_nullValue;
          d.value.uint64 = 0;
        } else {
          d.state = CMPI_goodValue;
          d.value = str2CMPIValue(q->type, q->value, NULL, NULL, &rc);
        }
        d.type = q->type;
        ClClassAddMethParamQualifier(&cl->hdr, cl_parm, q->name, d);
      }
    }
  }

  tmp = cl;
  cl = ClClassRebuildClass(cl, NULL);
  ClClassFreeClass(tmp);
  cls = calloc(1, sizeof(*cls));
  *cls = initConstClass(cl);

  int sreqSize = sizeof(*sreq) + (3 * sizeof(MsgSegment));
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_CreateClass;
  sreq->hdr.count = CC_REQ_REG_SEGMENTS;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->path = setObjectPathMsgSegment(path);
  sreq->cls = setConstClassMsgSegment(cls);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static int
buildModifyInstanceRequest(void *parm)
{
  CMPIObjectPath *path;
  CMPIInstance   *inst;
  CMPIType        type;
  CMPIValue       val,
                 *valp;
  int             i,
                  m,
                  sreqSize = sizeof(ModifyInstanceReq); // -sizeof(MsgSegment);
  ModifyInstanceReq *sreq;
  XtokInstance   *xci;
  XtokInstanceName *xco;
  XtokProperty   *p = NULL;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;
  CMPIStatus rc = {CMPI_RC_OK, NULL};
  int err = 0;

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokModifyInstance *req = (XtokModifyInstance *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  if (req->properties)
    sreqSize += req->properties * sizeof(MsgSegment);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_ModifyInstance;
  sreq->hdr.count = req->properties + MI_REQ_REG_SEGMENTS;

  for (i = 0; i < req->properties; i++) {
    sreq->properties[i] =
        setCharsMsgSegment(req->propertyList.values[i].value);
  }
  xci = &req->namedInstance.instance;
  xco = &req->namedInstance.path;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);

  for (i = 0, m = xco->bindings.next; i < m; i++) {
    valp = getKeyValueTypePtr(xco->bindings.keyBindings[i].type,
                              xco->bindings.keyBindings[i].value,
                              &xco->bindings.keyBindings[i].ref,
                              &val, &type, req->op.nameSpace.data);

    CMAddKey(path, xco->bindings.keyBindings[i].name, valp, type);
  }

  inst = TrackedCMPIInstance(path, NULL);
  for (p = xci->properties.first; p; p = p->next) {
    if (p->val.val.value) {
      val =
          str2CMPIValue(p->valueType, p->val.val, &p->val.ref,
                        req->op.nameSpace.data, &rc);
      if (rc.rc != CMPI_RC_OK) { /* bugzilla 75543 */
         binCtx->rc = rc.rc;
	 err = 1;
         break;
      }
      CMSetProperty(inst, p->name, &val, p->valueType);
    }
  }
  sreq->instance = setInstanceMsgSegment(inst);
  sreq->path = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
  return err;
}

static void
buildEnumClassesRequest(void *parm)
{
  CMPIObjectPath *path;
  EnumClassesReq *sreq;
  int             sreqSize;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildEnumClassesRequest");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokEnumClasses *req = (XtokEnumClasses *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  sreqSize = sizeof(*sreq);// + 2 * sizeof(MsgSegment);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_EnumerateClasses;
  sreq->hdr.count = EC_REQ_REG_SEGMENTS;
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.flags = req->flags;
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->type = CMPI_class;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildEnumClassNamesRequest(void *parm)
{
  CMPIObjectPath *path;
  EnumClassNamesReq *sreq;// = BINREQ(OPS_EnumerateClassNames, 2);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "enumClassNames");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokEnumClassNames *req = (XtokEnumClassNames *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  sreq = calloc(1, sizeof(*sreq));
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.operation = OPS_EnumerateClassNames;
  sreq->hdr.count = ECN_REQ_REG_SEGMENTS;
  sreq->hdr.flags = req->flags;
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->type = CMPI_ref;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->chunkedMode = 0;
  binCtx->pAs = NULL;
}

static void
buildEnumInstanceNamesRequest(void *parm)
{
  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildEnumInstanceNamesRequest");
  CMPIObjectPath *path;
  EnumInstanceNamesReq *sreq;// = BINREQ(OPS_EnumerateInstanceNames, 2);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  memset(binCtx, 0, sizeof(BinRequestContext));

  XtokEnumInstanceNames *req = (XtokEnumInstanceNames *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  sreq = calloc(1, sizeof(*sreq));
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.operation = OPS_EnumerateInstanceNames;
  sreq->hdr.count = EIN_REQ_REG_SEGMENTS;
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = 0;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->type = CMPI_ref;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->chunkedMode = 0;
  binCtx->pAs = NULL;
}

static void
buildExecQueryRequest(void *parm)
{
  CMPIObjectPath *path;
  ExecQueryReq   *sreq;// = BINREQ(OPS_ExecQuery, 4);
  int             irc;
  QLStatement    *qs = NULL;
  char          **fCls;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokExecQuery  *req = (XtokExecQuery *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  qs = parseQuery(MEM_TRACKED, (char *) req->op.query.data,
                  (char *) req->op.queryLang.data, NULL, NULL, &irc);

  fCls = qs->ft->getFromClassList(qs);
  if (irc) {
    hdr->rc = CMPI_RC_ERR_INVALID_QUERY;
    hdr->errMsg = strdup("syntax error in query.");
    return;
  }
  if (fCls == NULL || *fCls == NULL) {
    hdr->rc = CMPI_RC_ERR_INVALID_QUERY;
    hdr->errMsg = strdup("required from clause is missing.");
    return;
  }
  req->op.className = setCharsMsgSegment(*fCls);

  path = TrackedCMPIObjectPath(req->op.nameSpace.data, *fCls, NULL);

  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_ExecQuery;
  sreq->hdr.count = EQ_REQ_REG_SEGMENTS;
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->query = setCharsMsgSegment((char *) req->op.query.data);
  sreq->queryLang = setCharsMsgSegment((char *) req->op.queryLang.data);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = 0;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->type = CMPI_instance;
  binCtx->xmlAs = XML_asObj;
  binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildReferencesRequest(void *parm)
{
  CMPIObjectPath *path;
  ReferencesReq  *sreq;
  int             i,
                  m,
                  sreqSize = sizeof(ReferencesReq);
  CMPIType        type;
  CMPIValue       val,
                 *valp;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokReferences *req = (XtokReferences *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  if (req->properties)
    sreqSize += req->properties * sizeof(MsgSegment);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = OPS_References;
  sreq->hdr.count = req->properties + RI_REQ_REG_SEGMENTS;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  for (i = 0, m = req->objectName.bindings.next; i < m; i++) {
    valp = getKeyValueTypePtr(req->objectName.bindings.keyBindings[i].type,
                              req->objectName.bindings.keyBindings[i].
                              value,
                              &req->objectName.bindings.keyBindings[i].ref,
                              &val, &type, req->op.nameSpace.data);
    CMAddKey(path, req->objectName.bindings.keyBindings[i].name, valp,
             type);
  }

  if (req->objectName.bindings.next == 0) {
    free(sreq);
    hdr->rc = CMPI_RC_ERR_NOT_SUPPORTED;
    hdr->errMsg = strdup("References operation for classes not supported");
    return;
  }
  if (!req->objNameSet) {
    free(sreq);
    hdr->rc = CMPI_RC_ERR_INVALID_PARAMETER;
    hdr->errMsg = strdup("ObjectName parameter required");
    return;
  }

  sreq->objectPath = setObjectPathMsgSegment(path);

  sreq->resultClass = req->op.resultClass;
  sreq->role = req->op.role;
  sreq->hdr.flags = req->flags;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  for (i = 0; i < req->properties; i++)
    sreq->properties[i] =
        setCharsMsgSegment(req->propertyList.values[i].value);

  req->op.className = req->op.resultClass;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;
  binCtx->type = CMPI_instance;
  binCtx->xmlAs = XML_asObj;
  binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildReferenceNamesRequest(void *parm)
{
  CMPIObjectPath *path = NULL;
  ReferenceNamesReq *sreq;// = BINREQ(OPS_ReferenceNames, 4);
  int             i,
                  m;
  CMPIType        type;
  CMPIValue       val,
                 *valp;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokReferenceNames *req = (XtokReferenceNames *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  for (i = 0, m = req->objectName.bindings.next; i < m; i++) {
    valp = getKeyValueTypePtr(req->objectName.bindings.keyBindings[i].type,
                              req->objectName.bindings.keyBindings[i].
                              value,
                              &req->objectName.bindings.keyBindings[i].ref,
                              &val, &type, req->op.nameSpace.data);
    CMAddKey(path, req->objectName.bindings.keyBindings[i].name, valp,
             type);
  }

  if (req->objectName.bindings.next == 0) {
    hdr->rc = CMPI_RC_ERR_NOT_SUPPORTED;
    hdr->errMsg = strdup("ReferenceNames operation for classes not supported");
    return;
  }
  if (!req->objNameSet) {
    hdr->rc = CMPI_RC_ERR_INVALID_PARAMETER;
    hdr->errMsg = strdup("ObjectName parameter required");
    return;
  }

  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_ReferenceNames;
  sreq->hdr.count = RIN_REQ_REG_SEGMENTS;
  sreq->objectPath = setObjectPathMsgSegment(path);

  sreq->resultClass = req->op.resultClass;
  sreq->role = req->op.role;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  req->op.className = req->op.resultClass;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = 0;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->type = CMPI_ref;
  binCtx->xmlAs = XML_asObjectPath;
  binCtx->noResp = 0;
  binCtx->chunkedMode = 0;
  binCtx->pAs = NULL;
}

static void
buildGetPropertyRequest(void *parm)
{

  CMPIObjectPath *path;
  CMPIStatus      rc;
  GetPropertyReq  *sreq;//BINREQ(OPS_GetProperty, 3);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;
  int i, m;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildGetPropertyRequest");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokGetProperty *req = (XtokGetProperty *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data,
                            req->instanceName.className, &rc);
  for (i = 0, m = req->instanceName.bindings.next; i < m; i++) {
    CMPIType type;
    CMPIValue val, *valp;

    valp = getKeyValueTypePtr(req->instanceName.bindings.keyBindings[i].type,
                              req->instanceName.bindings.keyBindings[i].value,
                              &req->instanceName.bindings.keyBindings[i].ref,
                              &val, &type, req->op.nameSpace.data);
    CMAddKey(path, req->instanceName.bindings.keyBindings[i].name, valp, type);
  }

  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_GetProperty;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->path = setObjectPathMsgSegment(path);
  sreq->name = setCharsMsgSegment(req->name);
  sreq->hdr.sessionId = hdr->sessionId;
  sreq->hdr.count = 3;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;

}

static void
buildSetPropertyRequest(void *parm)
{
  CMPIObjectPath *path;
  CMPIInstance   *inst;
  CMPIType        t, type;
  CMPIStatus      rc;
  CMPIValue       val, *valp;
  int             i, m;
  SetPropertyReq *sreq;// = BINREQ(OPS_SetProperty, 3);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;
  CMPIStatus      st = {CMPI_RC_OK, NULL};

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokSetProperty *req = (XtokSetProperty *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data,
                            req->instanceName.className, &rc);
  for (i = 0, m = req->instanceName.bindings.next; i < m; i++) {
    valp = getKeyValueTypePtr(req->instanceName.bindings.keyBindings[i].type,
                              req->instanceName.bindings.keyBindings[i].value,
                              &req->instanceName.bindings.keyBindings[i].ref,
                              &val, &type, req->op.nameSpace.data);
    CMAddKey(path, req->instanceName.bindings.keyBindings[i].name, valp, type);
  }

  inst = internal_new_CMPIInstance(MEM_TRACKED, NULL, NULL, 1);

  if (req->newVal.type == 0) {
    t = guessType(req->newVal.val.value);
  } else if (req->newVal.type == CMPI_ARRAY) {
    t = guessType(req->newVal.arr.values[0].value) | CMPI_ARRAY;
  } else {
    t = req->newVal.type;
  }
  if (t != CMPI_null) {
    val =
        str2CMPIValue(t, req->newVal.val, &req->newVal.ref,
                      req->op.nameSpace.data, &st);
    CMSetProperty(inst, req->propertyName, &val, t);
  } else {
    val.string = 0;
    CMSetProperty(inst, req->propertyName, 0, t);
  }

  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_SetProperty;
  sreq->hdr.count = 3;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->path = setObjectPathMsgSegment(path);
  sreq->inst = setInstanceMsgSegment(inst);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

#ifdef HAVE_QUALREP

static void
buildGetQualifierRequest(void *parm)
{
  CMPIObjectPath *path;
  CMPIStatus      rc;
  GetQualifierReq *sreq;// = BINREQ(OPS_GetQualifier, 2);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokGetQualifier *req = (XtokGetQualifier *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path = TrackedCMPIObjectPath(req->op.nameSpace.data, req->name, &rc);

  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_GetQualifier;
  sreq->hdr.count = 2;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->path = setObjectPathMsgSegment(path);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildDeleteQualifierRequest(void *parm)
{
  CMPIObjectPath *path;
  CMPIStatus      rc;
  DeleteQualifierReq *sreq;// = BINREQ(OPS_DeleteQualifier, 2);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokDeleteQualifier *req = (XtokDeleteQualifier *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  /* abuse classname for qualifier name */
  path = TrackedCMPIObjectPath(req->op.nameSpace.data, req->name, &rc);

  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_DeleteQualifier;
  sreq->hdr.count = 2;
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->path = setObjectPathMsgSegment(path);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildSetQualifierRequest(void *parm)
{
  CMPIObjectPath *path;
  CMPIQualifierDecl *qual;
  CMPIData        d;
  ClQualifierDeclaration *q;
  SetQualifierReq *sreq;// = BINREQ(OPS_SetQualifier, 3);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;
  CMPIStatus rc = {CMPI_RC_OK, NULL};

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokSetQualifier *req = (XtokSetQualifier *) hdr->cimRequest;

  path = TrackedCMPIObjectPath(req->op.nameSpace.data, NULL, NULL);
  q = ClQualifierDeclarationNew(req->op.nameSpace.data,
                                req->qualifierdeclaration.name);

  if (req->qualifierdeclaration.overridable)
    q->flavor |= ClQual_F_Overridable;
  if (req->qualifierdeclaration.tosubclass)
    q->flavor |= ClQual_F_ToSubclass;
  if (req->qualifierdeclaration.toinstance)
    q->flavor |= ClQual_F_ToInstance;
  if (req->qualifierdeclaration.translatable)
    q->flavor |= ClQual_F_Translatable;
  if (req->qualifierdeclaration.isarray)
    q->type |= CMPI_ARRAY;

  if (req->qualifierdeclaration.type)
    q->type |= req->qualifierdeclaration.type;

  if (req->qualifierdeclaration.scope.class)
    q->scope |= ClQual_S_Class;
  if (req->qualifierdeclaration.scope.association)
    q->scope |= ClQual_S_Association;
  if (req->qualifierdeclaration.scope.reference)
    q->scope |= ClQual_S_Reference;
  if (req->qualifierdeclaration.scope.property)
    q->scope |= ClQual_S_Property;
  if (req->qualifierdeclaration.scope.method)
    q->scope |= ClQual_S_Method;
  if (req->qualifierdeclaration.scope.parameter)
    q->scope |= ClQual_S_Parameter;
  if (req->qualifierdeclaration.scope.indication)
    q->scope |= ClQual_S_Indication;
  q->arraySize = req->qualifierdeclaration.arraySize;

  if (req->qualifierdeclaration.data.value.value) {     // default value
    // is set
    d.state = CMPI_goodValue;
    d.type = q->type;           // "specified" type
    d.type |= req->qualifierdeclaration.data.type;      // actual type

    // default value declared - isarray attribute must match, if set
    if (req->qualifierdeclaration.isarrayIsSet)
      if (!req->qualifierdeclaration.
          isarray ^ !(req->qualifierdeclaration.data.type & CMPI_ARRAY))
        hdr->rc = CMPI_RC_ERROR;
        hdr->errMsg = "ISARRAY attribute and default value conflict";
        return;

    d.value = str2CMPIValue(d.type, req->qualifierdeclaration.data.value,
                            (XtokValueReference *) &
                            req->qualifierdeclaration.data.valueArray,
                            NULL, &rc);
    ClQualifierAddQualifier(&q->hdr, &q->qualifierData,
                            req->qualifierdeclaration.name, d);
  } else {                      // no default value - rely on ISARRAY
    // attr, check if it's set
    /*
     * if(!req->qualifierdeclaration.isarrayIsSet)
     * _SFCB_RETURN(iMethodErrResponse(hdr, getErrSegment(CMPI_RC_ERROR,
     * "ISARRAY attribute MUST be present if the Qualifier declares no
     * default value")));
     */
    q->qualifierData.sectionOffset = 0;
    q->qualifierData.used = 0;
    q->qualifierData.max = 0;
  }

  qual = malloc(sizeof(*qual));
  *qual = initQualifier(q);

  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_SetQualifier;
  sreq->hdr.count = 3;
  sreq->qualifier = setQualifierMsgSegment(qual);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->hdr.sessionId = hdr->sessionId;
  sreq->path = setObjectPathMsgSegment(path);

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildEnumQualifiersRequest(void *parm)
{
  CMPIObjectPath *path;
  EnumClassNamesReq *sreq;// = BINREQ(OPS_EnumerateQualifiers, 2);
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "enumQualifiers");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokEnumQualifiers *req = (XtokEnumQualifiers *) hdr->cimRequest;

  path = TrackedCMPIObjectPath(req->op.nameSpace.data, NULL, NULL);
  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_EnumerateQualifiers;
  sreq->hdr.count = 2;
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->type = CMPI_qualifierDecl;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->chunkedMode = 0;
  binCtx->pAs = NULL;
}
#else

static void buildDeleteQualifierRequest(void *parm) { return; }
static void buildGetQualifierRequest(void *parm) { return; }
static void buildSetQualifierRequest(void *parm) { return; }
static void buildEnumQualifiersRequest(void *parm) { return; }
#endif  // HAVE_QUALREP

static void
buildInvokeMethodRequest(void *parm)
{
  CMPIObjectPath *path;
  CMPIType        type;
  CMPIValue       val,
                 *valp;
  int             i,
                  m,
                  rc,
                  vmpt = 0;
  InvokeMethodReq *sreq;// = BINREQ(OPS_InvokeMethod, 5);
  CMPIArgs       *in = TrackedCMPIArgs(NULL);
  XtokParamValue *p;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  BinRequestContext *binCtx = hdr->binCtx;
  CMPIStatus     st = {CMPI_RC_OK, NULL};

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokMethodCall *req = (XtokMethodCall *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  if (req->instName)
    for (i = 0, m = req->instanceName.bindings.next; i < m; i++) {
      valp =
          getKeyValueTypePtr(req->instanceName.bindings.keyBindings[i].
                             type,
                             req->instanceName.bindings.keyBindings[i].
                             value,
                             &req->instanceName.bindings.keyBindings[i].
                             ref, &val, &type, req->op.nameSpace.data);
      CMAddKey(path, req->instanceName.bindings.keyBindings[i].name, valp,
               type);
    }
  sreq = calloc(1, sizeof(*sreq));
  sreq->hdr.operation = OPS_InvokeMethod;
  sreq->hdr.count = IM_REQ_REG_SEGMENTS;
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->hdr.sessionId = hdr->sessionId;

  if (getControlBool("validateMethodParamTypes", &vmpt))
    vmpt = 1;

  for (p = req->paramValues.first; p; p = p->next) {
    /*
     * Update untyped params (p->type==0) and verify those that were specified.
     * (Unlikely to be untyped at this point. Even if no paramtype is given in
     * the XML, the rule actions would assign one.)
     */
    if (p->type == 0 || p->type == CMPI_ARRAY || p->type == CMPI_class || 
        p->type == CMPI_instance || vmpt) {
      rc = updateMethodParamTypes(hdr);

      if (rc != CMPI_RC_OK) {
        free(sreq);
        hdr->rc = rc;
        hdr->errMsg = NULL;
        return;
      }
    }
    /*
     * TODO: Add support for PARAMVALUE subelements CLASS, CLASSNAME, INSTANCE,
     * INSTANCENAME, VALUE.NAMEDINSTANCE, in addition to EmbeddedInstance.
     */
    if (p->value.value) {
      CMPIValue val = str2CMPIValue(p->type, p->value, &p->valueRef, req->op.nameSpace.data, &st);
      if (st.rc) {
        free(sreq);
        hdr->rc = st.rc;
        hdr->errMsg = NULL;
        return;
      }
      CMAddArg(in, p->name, &val, p->type);
    }

  }

  sreq->in = setArgsMsgSegment(in);
  sreq->out = setArgsMsgSegment(NULL);
  sreq->method = setCharsMsgSegment(req->method);

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = 0;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sizeof(*sreq);
  binCtx->chunkedMode = binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

int
updateMethodParamTypes(RequestHdr * hdr)
{

  _SFCB_ENTER(TRACE_CIMXMLPROC, "updateMethodParamTypes");

  CMPIConstClass *cls = NULL;
  ClMethod       *meth;
  ClParameter    *param = NULL;
  int             i,
                  m;
  ClClass        *cl;
  char           *mname;
  XtokParamValue *ptok;
  int             p,
                  pm;

  XtokMethodCall *req = (XtokMethodCall *) hdr->cimRequest;
  cls =
      getConstClass((char *) req->op.nameSpace.data,
                    (char *) req->op.className.data);
  if (!cls) {
    _SFCB_RETURN(CMPI_RC_ERR_INVALID_CLASS);
  }

  cl = (ClClass *) cls->hdl;

  /*
   * check that the method specified in req exists in class 
   */
  for (i = 0, m = ClClassGetMethodCount(cl); i < m; i++) {
    ClClassGetMethodAt(cl, i, NULL, &mname, NULL);
    if (strcasecmp(req->method, mname) == 0) {
      break;
    }
  }
  if (i == m) {
    _SFCB_RETURN(CMPI_RC_ERR_METHOD_NOT_FOUND);
  }

  meth = ((ClMethod *) ClObjectGetClSection(&cl->hdr, &cl->methods)) + i;

  /*
   * loop through all params from parsed req 
   */
  for (ptok = req->paramValues.first; ptok; ptok = ptok->next) {
    CMPIParameter   pdata;
    char           *sname;

    /*
     * loop through all params for meth 
     */
    for (p = 0, pm = ClClassGetMethParameterCount(cl, i); p < pm; p++) {
      ClClassGetMethParameterAt(cl, meth, p, &pdata, &sname);

      if (strcasecmp(sname, ptok->name) == 0) {
        // fprintf(stderr, "%s matches %s", sname, ptok->name);
        param = ((ClParameter *)
                 ClObjectGetClSection(&cl->hdr, &meth->parameters)) + p;
        break;
      }
    }
    if (p == pm) {
      _SFCB_RETURN(CMPI_RC_ERR_INVALID_PARAMETER);
    }
    // fprintf(stderr, " pdata.type=%u (expec), ptok->type=%u\n",
    // pdata.type, ptok->type);
    /*
     * special case: EmbeddedInstance. Parser will set type to instance,
     * but repository would have type as string. Check here to not fail
     * the else-if below. 
     */
    if (param && (ptok->type & CMPI_instance)) {
      int             isEI = 0;
      int             qcount =
          ClClassGetMethParmQualifierCount(cl, meth, p);
      for (; qcount > 0; qcount--) {
        char           *qname;
        ClClassGetMethParamQualifierAt(cl, param, (qcount - 1), NULL, &qname);
        if (strcmp(qname, "EmbeddedInstance") == 0) {
          // fprintf(stderr, " is EmbeddedInstance\n");
          isEI = 1;
          break;
          /*
           * TODO: For PARAMVALUE subelements CLASS, CLASSNAME, INSTANCE,
           * INSTANCENAME, VALUE.NAMEDINSTANCE, we probably want to skip
           * the below repository check as well.
           */
        }
      }
      if (isEI)
        continue;
    }

    if ((ptok->type == 0) || (ptok->type == CMPI_ARRAY)) {
      /*
       * Type was unknown, fill it in 
       * (unlikely at this point, see comment in buildInvokeMethodRequest)
       */
      // printf("parameter %s missing type, using %s\n", sname,
      // paramType(pdata.type));
      ptok->type = pdata.type;
    } else if (ptok->type != pdata.type) {
      /*
       * Parameter type mismatch 
       */
      _SFCB_RETURN(CMPI_RC_ERR_TYPE_MISMATCH);
    }
  }
  _SFCB_RETURN(CMPI_RC_OK);
}

static void addProperty(XtokProperties *ps, XtokProperty *p)
{
   XtokProperty *np;
   np=malloc(sizeof(*np));
   memcpy(np,p,sizeof(XtokProperty));
   np->next=NULL;
   if (ps->last) {
      ps->last->next=np;
   }
   else ps->first=np;
   ps->last=np;
}

static void addParamValue(XtokParamValues *vs, XtokParamValue *v)
{
   XtokParamValue *nv;
   nv=malloc(sizeof(*nv));
   memcpy(nv,v,sizeof(XtokParamValue));
   nv->next=NULL;
   if (vs->last) {
      vs->last->next=nv;
   }
   else vs->first=nv;
   vs->last=nv;
}

static void addQualifier(XtokQualifiers *qs, XtokQualifier *q)
{
   XtokQualifier *nq;
   nq=malloc(sizeof(*nq));
   memcpy(nq,q,sizeof(XtokQualifier));
   nq->next=NULL;
   if (qs->last) {
      qs->last->next=nq;
   }
   else qs->first=nq;
   qs->last=nq;
}

static void addMethod(XtokMethods *ms, XtokMethod *m)
{
   XtokMethod *nm;
   nm=malloc(sizeof(*nm));
   memcpy(nm,m,sizeof(XtokMethod));
   nm->next=NULL;
   if (ms->last) {
      ms->last->next=nm;
   }
   else ms->first=nm;
   ms->last=nm;
}

static void addParam(XtokParams *ps, XtokParam *p)
{
   XtokParam *np;
   np=malloc(sizeof(*np));
   memcpy(np,p,sizeof(XtokParam));
   np->next=NULL;
   if (ps->last) {
      ps->last->next=np;
   }
   else ps->first=np;
   ps->last=np;
}

static void
buildOpenEnumInstanceRequest(void *parm)
{
  CMPIObjectPath *path;
  EnumInstancesReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  int    i,
      sreqSize = sizeof(EnumInstancesReq);      // -sizeof(MsgSegment);
  BinRequestContext *binCtx = hdr->binCtx;
  
  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildOpenEnumInstanceRequest");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokOpenEnumInstances *req = (XtokOpenEnumInstances *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path =
      TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data,
                            NULL);
  if (req->properties)
    sreqSize += req->properties * sizeof(MsgSegment);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = req->op.type;
  sreq->hdr.count = req->properties + EI_REQ_REG_SEGMENTS;

  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->hdr.sessionId = hdr->sessionId;

  for (i = 0; i < req->properties; i++) {
    sreq->properties[i] =
        setCharsMsgSegment(req->propertyList.values[i].value);
  }

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->bHdr->flags = req->flags;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;

  binCtx->type = CMPI_instance;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildPullInstancesRequest(void *parm)
{
  CMPIObjectPath *path;
  EnumInstancesReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  int sreqSize = sizeof(EnumInstancesReq);  // TODO
  BinRequestContext *binCtx = hdr->binCtx;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildPullInstancesRequest");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokPullInstances *req = (XtokPullInstances *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path = TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data, NULL);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = req->op.type;

  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;

  binCtx->type = CMPI_instance;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}


static void
buildCloseEnumerationRequest(void *parm)
{
  CMPIObjectPath *path;
  EnumInstancesReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  int sreqSize = sizeof(EnumInstancesReq);  // TODO
  BinRequestContext *binCtx = hdr->binCtx;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildCloseEnumerationRequest");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokCloseEnumeration *req = (XtokCloseEnumeration *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path = TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data, NULL);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = req->op.type;

  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;

  binCtx->type = CMPI_instance;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}

static void
buildEnumerationCountRequest(void *parm)
{
  CMPIObjectPath *path;
  EnumInstancesReq *sreq;
  RequestHdr     *hdr = &(((ParserControl *)parm)->reqHdr);
  int sreqSize = sizeof(EnumInstancesReq);  // TODO
  BinRequestContext *binCtx = hdr->binCtx;

  _SFCB_ENTER(TRACE_CIMXMLPROC, "buildEnumerationCountRequest");

  memset(binCtx, 0, sizeof(BinRequestContext));
  XtokEnumerationCount *req = (XtokEnumerationCount *) hdr->cimRequest;
  hdr->className = req->op.className.data;

  path = TrackedCMPIObjectPath(req->op.nameSpace.data, req->op.className.data, NULL);
  sreq = calloc(1, sreqSize);
  sreq->hdr.operation = req->op.type;

  sreq->principal = setCharsMsgSegment(hdr->principal);
  sreq->userRole = setCharsMsgSegment(hdr->role);
  sreq->objectPath = setObjectPathMsgSegment(path);
  sreq->hdr.sessionId = hdr->sessionId;

  binCtx->oHdr = (OperationHdr *) req;
  binCtx->bHdr = &sreq->hdr;
  binCtx->rHdr = hdr;
  binCtx->bHdrSize = sreqSize;

  binCtx->type = CMPI_instance;
  binCtx->xmlAs = binCtx->noResp = 0;
  binCtx->pAs = NULL;
}




/* Line 268 of yacc.c  */
#line 1878 "cimXmlOps.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     XTOK_XML = 258,
     ZTOK_XML = 259,
     XTOK_CIM = 260,
     ZTOK_CIM = 261,
     XTOK_MESSAGE = 262,
     ZTOK_MESSAGE = 263,
     XTOK_SIMPLEREQ = 264,
     ZTOK_SIMPLEREQ = 265,
     XTOK_GETCLASS = 266,
     XTOK_ENUMCLASSNAMES = 267,
     XTOK_ENUMCLASSES = 268,
     XTOK_CREATECLASS = 269,
     XTOK_CREATEINSTANCE = 270,
     XTOK_DELETECLASS = 271,
     XTOK_DELETEINSTANCE = 272,
     XTOK_MODIFYINSTANCE = 273,
     XTOK_GETINSTANCE = 274,
     XTOK_ENUMINSTANCENAMES = 275,
     XTOK_ENUMINSTANCES = 276,
     XTOK_EXECQUERY = 277,
     XTOK_ASSOCIATORS = 278,
     XTOK_REFERENCES = 279,
     XTOK_ASSOCIATORNAMES = 280,
     XTOK_REFERENCENAMES = 281,
     XTOK_SETQUALIFIER = 282,
     XTOK_SETPROPERTY = 283,
     XTOK_ENUMQUALIFIERS = 284,
     XTOK_GETQUALIFIER = 285,
     XTOK_DELETEQUALIFIER = 286,
     XTOK_GETPROPERTY = 287,
     XTOK_OPENENUMINSTANCEPATHS = 288,
     XTOK_OPENENUMINSTANCES = 289,
     XTOK_OPENASSOCIATORINSTANCEPATHS = 290,
     XTOK_OPENASSOCIATORINSTANCES = 291,
     XTOK_OPENREFERENCEINSTANCEPATHS = 292,
     XTOK_OPENREFERENCEINSTANCES = 293,
     XTOK_OPENQUERYINSTANCES = 294,
     XTOK_PULLINSTANCES = 295,
     XTOK_PULLINSTANCESWITHPATH = 296,
     XTOK_PULLINSTANCEPATHS = 297,
     XTOK_CLOSEENUMERATION = 298,
     XTOK_ENUMERATIONCOUNT = 299,
     ZTOK_IMETHODCALL = 300,
     XTOK_METHODCALL = 301,
     ZTOK_METHODCALL = 302,
     XTOK_NAMESPACEPATH = 303,
     ZTOK_NAMESPACEPATH = 304,
     XTOK_LOCALNAMESPACEPATH = 305,
     ZTOK_LOCALNAMESPACEPATH = 306,
     XTOK_NAMESPACE = 307,
     ZTOK_NAMESPACE = 308,
     ZTOK_IPARAMVALUE = 309,
     XTOK_HOST = 310,
     ZTOK_HOST = 311,
     XTOK_VALUE = 312,
     ZTOK_VALUE = 313,
     XTOK_CDATA = 314,
     ZTOK_CDATA = 315,
     XTOK_VALUEARRAY = 316,
     ZTOK_VALUEARRAY = 317,
     XTOK_VALUEREFERENCE = 318,
     ZTOK_VALUEREFERENCE = 319,
     XTOK_VALUEREFARRAY = 320,
     ZTOK_VALUEREFARRAY = 321,
     XTOK_CLASSNAME = 322,
     ZTOK_CLASSNAME = 323,
     XTOK_INSTANCENAME = 324,
     ZTOK_INSTANCENAME = 325,
     XTOK_KEYBINDING = 326,
     ZTOK_KEYBINDING = 327,
     XTOK_KEYVALUE = 328,
     ZTOK_KEYVALUE = 329,
     XTOK_IP_LOCALONLY = 330,
     XTOK_IP_INCLUDEQUALIFIERS = 331,
     XTOK_IP_INCLUDECLASSORIGIN = 332,
     XTOK_IP_DEEPINHERITANCE = 333,
     XTOK_IP_CLASSNAME = 334,
     XTOK_IP_INSTANCE = 335,
     XTOK_IP_MODIFIEDINSTANCE = 336,
     XTOK_IP_INSTANCENAME = 337,
     XTOK_IP_OBJECTNAME = 338,
     XTOK_IP_ASSOCCLASS = 339,
     XTOK_IP_RESULTCLASS = 340,
     XTOK_IP_ROLE = 341,
     XTOK_IP_RESULTROLE = 342,
     XTOK_IP_QUERY = 343,
     XTOK_IP_QUERYLANG = 344,
     XTOK_IP_CLASS = 345,
     XTOK_IP_QUALIFIERDECLARATION = 346,
     XTOK_IP_QUALIFIERNAME = 347,
     XTOK_IP_PROPERTYNAME = 348,
     XTOK_IP_NEWVALUE = 349,
     XTOK_IP_FILTERQUERYLANG = 350,
     XTOK_IP_FILTERQUERY = 351,
     XTOK_IP_CONTINUEONERROR = 352,
     XTOK_IP_ENDOFSEQUENCE = 353,
     XTOK_IP_RETURNQUERYRESULTCLASS = 354,
     XTOK_IP_OPERATIONTIMEOUT = 355,
     XTOK_IP_MAXOBJECTCOUNT = 356,
     XTOK_IP_ENUMERATIONCONTEXT = 357,
     XTOK_IP_PROPERTYLIST = 358,
     XTOK_VALUENAMEDINSTANCE = 359,
     ZTOK_VALUENAMEDINSTANCE = 360,
     XTOK_QUALIFIER = 361,
     ZTOK_QUALIFIER = 362,
     XTOK_QUALIFIERDECLARATION = 363,
     ZTOK_QUALIFIERDECLARATION = 364,
     XTOK_SCOPE = 365,
     ZTOK_SCOPE = 366,
     XTOK_PROPERTY = 367,
     ZTOK_PROPERTY = 368,
     XTOK_PROPERTYARRAY = 369,
     ZTOK_PROPERTYARRAY = 370,
     XTOK_PROPERTYREFERENCE = 371,
     ZTOK_PROPERTYREFERENCE = 372,
     XTOK_PARAM = 373,
     ZTOK_PARAM = 374,
     XTOK_PARAMARRAY = 375,
     ZTOK_PARAMARRAY = 376,
     XTOK_PARAMREF = 377,
     ZTOK_PARAMREF = 378,
     XTOK_PARAMREFARRAY = 379,
     ZTOK_PARAMREFARRAY = 380,
     XTOK_METHOD = 381,
     ZTOK_METHOD = 382,
     XTOK_CLASS = 383,
     ZTOK_CLASS = 384,
     XTOK_INSTANCE = 385,
     ZTOK_INSTANCE = 386,
     XTOK_PARAMVALUE = 387,
     ZTOK_PARAMVALUE = 388,
     XTOK_INSTANCEPATH = 389,
     ZTOK_INSTANCEPATH = 390,
     XTOK_LOCALINSTANCEPATH = 391,
     ZTOK_LOCALINSTANCEPATH = 392,
     XTOK_LOCALCLASSPATH = 393,
     ZTOK_LOCALCLASSPATH = 394
   };
#endif
/* Tokens.  */
#define XTOK_XML 258
#define ZTOK_XML 259
#define XTOK_CIM 260
#define ZTOK_CIM 261
#define XTOK_MESSAGE 262
#define ZTOK_MESSAGE 263
#define XTOK_SIMPLEREQ 264
#define ZTOK_SIMPLEREQ 265
#define XTOK_GETCLASS 266
#define XTOK_ENUMCLASSNAMES 267
#define XTOK_ENUMCLASSES 268
#define XTOK_CREATECLASS 269
#define XTOK_CREATEINSTANCE 270
#define XTOK_DELETECLASS 271
#define XTOK_DELETEINSTANCE 272
#define XTOK_MODIFYINSTANCE 273
#define XTOK_GETINSTANCE 274
#define XTOK_ENUMINSTANCENAMES 275
#define XTOK_ENUMINSTANCES 276
#define XTOK_EXECQUERY 277
#define XTOK_ASSOCIATORS 278
#define XTOK_REFERENCES 279
#define XTOK_ASSOCIATORNAMES 280
#define XTOK_REFERENCENAMES 281
#define XTOK_SETQUALIFIER 282
#define XTOK_SETPROPERTY 283
#define XTOK_ENUMQUALIFIERS 284
#define XTOK_GETQUALIFIER 285
#define XTOK_DELETEQUALIFIER 286
#define XTOK_GETPROPERTY 287
#define XTOK_OPENENUMINSTANCEPATHS 288
#define XTOK_OPENENUMINSTANCES 289
#define XTOK_OPENASSOCIATORINSTANCEPATHS 290
#define XTOK_OPENASSOCIATORINSTANCES 291
#define XTOK_OPENREFERENCEINSTANCEPATHS 292
#define XTOK_OPENREFERENCEINSTANCES 293
#define XTOK_OPENQUERYINSTANCES 294
#define XTOK_PULLINSTANCES 295
#define XTOK_PULLINSTANCESWITHPATH 296
#define XTOK_PULLINSTANCEPATHS 297
#define XTOK_CLOSEENUMERATION 298
#define XTOK_ENUMERATIONCOUNT 299
#define ZTOK_IMETHODCALL 300
#define XTOK_METHODCALL 301
#define ZTOK_METHODCALL 302
#define XTOK_NAMESPACEPATH 303
#define ZTOK_NAMESPACEPATH 304
#define XTOK_LOCALNAMESPACEPATH 305
#define ZTOK_LOCALNAMESPACEPATH 306
#define XTOK_NAMESPACE 307
#define ZTOK_NAMESPACE 308
#define ZTOK_IPARAMVALUE 309
#define XTOK_HOST 310
#define ZTOK_HOST 311
#define XTOK_VALUE 312
#define ZTOK_VALUE 313
#define XTOK_CDATA 314
#define ZTOK_CDATA 315
#define XTOK_VALUEARRAY 316
#define ZTOK_VALUEARRAY 317
#define XTOK_VALUEREFERENCE 318
#define ZTOK_VALUEREFERENCE 319
#define XTOK_VALUEREFARRAY 320
#define ZTOK_VALUEREFARRAY 321
#define XTOK_CLASSNAME 322
#define ZTOK_CLASSNAME 323
#define XTOK_INSTANCENAME 324
#define ZTOK_INSTANCENAME 325
#define XTOK_KEYBINDING 326
#define ZTOK_KEYBINDING 327
#define XTOK_KEYVALUE 328
#define ZTOK_KEYVALUE 329
#define XTOK_IP_LOCALONLY 330
#define XTOK_IP_INCLUDEQUALIFIERS 331
#define XTOK_IP_INCLUDECLASSORIGIN 332
#define XTOK_IP_DEEPINHERITANCE 333
#define XTOK_IP_CLASSNAME 334
#define XTOK_IP_INSTANCE 335
#define XTOK_IP_MODIFIEDINSTANCE 336
#define XTOK_IP_INSTANCENAME 337
#define XTOK_IP_OBJECTNAME 338
#define XTOK_IP_ASSOCCLASS 339
#define XTOK_IP_RESULTCLASS 340
#define XTOK_IP_ROLE 341
#define XTOK_IP_RESULTROLE 342
#define XTOK_IP_QUERY 343
#define XTOK_IP_QUERYLANG 344
#define XTOK_IP_CLASS 345
#define XTOK_IP_QUALIFIERDECLARATION 346
#define XTOK_IP_QUALIFIERNAME 347
#define XTOK_IP_PROPERTYNAME 348
#define XTOK_IP_NEWVALUE 349
#define XTOK_IP_FILTERQUERYLANG 350
#define XTOK_IP_FILTERQUERY 351
#define XTOK_IP_CONTINUEONERROR 352
#define XTOK_IP_ENDOFSEQUENCE 353
#define XTOK_IP_RETURNQUERYRESULTCLASS 354
#define XTOK_IP_OPERATIONTIMEOUT 355
#define XTOK_IP_MAXOBJECTCOUNT 356
#define XTOK_IP_ENUMERATIONCONTEXT 357
#define XTOK_IP_PROPERTYLIST 358
#define XTOK_VALUENAMEDINSTANCE 359
#define ZTOK_VALUENAMEDINSTANCE 360
#define XTOK_QUALIFIER 361
#define ZTOK_QUALIFIER 362
#define XTOK_QUALIFIERDECLARATION 363
#define ZTOK_QUALIFIERDECLARATION 364
#define XTOK_SCOPE 365
#define ZTOK_SCOPE 366
#define XTOK_PROPERTY 367
#define ZTOK_PROPERTY 368
#define XTOK_PROPERTYARRAY 369
#define ZTOK_PROPERTYARRAY 370
#define XTOK_PROPERTYREFERENCE 371
#define ZTOK_PROPERTYREFERENCE 372
#define XTOK_PARAM 373
#define ZTOK_PARAM 374
#define XTOK_PARAMARRAY 375
#define ZTOK_PARAMARRAY 376
#define XTOK_PARAMREF 377
#define ZTOK_PARAMREF 378
#define XTOK_PARAMREFARRAY 379
#define ZTOK_PARAMREFARRAY 380
#define XTOK_METHOD 381
#define ZTOK_METHOD 382
#define XTOK_CLASS 383
#define ZTOK_CLASS 384
#define XTOK_INSTANCE 385
#define ZTOK_INSTANCE 386
#define XTOK_PARAMVALUE 387
#define ZTOK_PARAMVALUE 388
#define XTOK_INSTANCEPATH 389
#define ZTOK_INSTANCEPATH 390
#define XTOK_LOCALINSTANCEPATH 391
#define ZTOK_LOCALINSTANCEPATH 392
#define XTOK_LOCALCLASSPATH 393
#define ZTOK_LOCALCLASSPATH 394




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 293 of yacc.c  */
#line 1811 "cimXmlOps.y"

   int                           intValue;
   char                          boolValue;
   char*                         className;
   void*                         tokCim;
   uint64_t                      enumerationContext;

   XtokMessage                   xtokMessage;
   XtokNameSpace                 xtokNameSpace;
   char*                         xtokLocalNameSpacePath;
   XtokNameSpacePath             xtokNameSpacePath;
   XtokHost                      xtokHost;
   XtokInstancePath              xtokInstancePath;
   XtokLocalInstancePath         xtokLocalInstancePath;
   XtokLocalClassPath            xtokLocalClassPath;

   XtokValue                     xtokValue;
   XtokValueArray                xtokValueArray;
   XtokValueReference            xtokValueReference;
   XtokValueRefArray             xtokValueRefArray;

   XtokInstanceName              xtokInstanceName;
   XtokKeyBinding                xtokKeyBinding;
   XtokKeyBindings               xtokKeyBindings;
   XtokKeyValue                  xtokKeyValue;

   XtokClass                     xtokClass;
   XtokInstance                  xtokInstance;
   XtokInstanceData              xtokInstanceData;
   XtokNamedInstance             xtokNamedInstance;

   XtokProperty                  xtokProperty;
   XtokPropertyData              xtokPropertyData;

   XtokMethod                    xtokMethod;
   XtokMethodData                xtokMethodData;
   XtokQualifier                 xtokQualifier;
   XtokQualifierDeclaration      xtokQualifierDeclaration;
   XtokQualifierDeclarationData  xtokQualifierDeclarationData;
   XtokQualifiers                xtokQualifiers;

   XtokParamValues               xtokParamValues;
   XtokParamValue                xtokParamValue;
   XtokParam                     xtokParam;
   XtokMethodCall                xtokMethodCall;

   XtokGetClassParmsList         xtokGetClassParmsList;
   XtokGetClassParms             xtokGetClassParms;
   XtokGetClass                  xtokGetClass;

   XtokEnumClassNames            xtokEnumClassNames;
   XtokEnumClassNamesParmsList   xtokEnumClassNamesParmsList;
   XtokEnumClassNamesParms       xtokEnumClassNamesParms;

   XtokEnumClasses               xtokEnumClasses;
   XtokEnumClassesParmsList      xtokEnumClassesParmsList;
   XtokEnumClassesParms          xtokEnumClassesParms;

   XtokGetInstance               xtokGetInstance;
   XtokGetInstanceParmsList      xtokGetInstanceParmsList;
   XtokGetInstanceParms          xtokGetInstanceParms;

   XtokDeleteClass               xtokDeleteClass;
   XtokDeleteClassParm           xtokDeleteClassParm;

   XtokDeleteInstance            xtokDeleteInstance;
   XtokDeleteInstanceParm        xtokDeleteInstanceParm;

   XtokCreateClass               xtokCreateClass;
   XtokCreateClassParm           xtokCreateClassParm;
 
   XtokCreateInstance            xtokCreateInstance;
   XtokCreateInstanceParm        xtokCreateInstanceParm;

   XtokModifyInstance            xtokModifyInstance;
   XtokModifyInstanceParmsList   xtokModifyInstanceParmsList;
   XtokModifyInstanceParms       xtokModifyInstanceParms;

   XtokEnumInstanceNames         xtokEnumInstanceNames;

   XtokEnumInstances             xtokEnumInstances;
   XtokEnumInstancesParmsList    xtokEnumInstancesParmsList;
   XtokEnumInstancesParms        xtokEnumInstancesParms;

   XtokExecQuery                 xtokExecQuery;
   
   XtokAssociators               xtokAssociators;
   XtokAssociatorsParmsList      xtokAssociatorsParmsList;
   XtokAssociatorsParms          xtokAssociatorsParms;

   XtokReferences                xtokReferences;
   XtokReferencesParmsList       xtokReferencesParmsList;
   XtokReferencesParms           xtokReferencesParms;

   XtokAssociatorNames           xtokAssociatorNames;
   XtokAssociatorNamesParmsList  xtokAssociatorNamesParmsList;
   XtokAssociatorNamesParms      xtokAssociatorNamesParms;

   XtokReferenceNames            xtokReferenceNames;
   XtokReferenceNamesParmsList   xtokReferenceNamesParmsList;
   XtokReferenceNamesParms       xtokReferenceNamesParms;

   XtokSetQualifier              xtokSetQualifier;
   XtokSetQualifierParm          xtokSetQualifierParm;
   
   XtokEnumQualifiers            xtokEnumQualifiers;
   
   XtokGetQualifier              xtokGetQualifier;
   XtokGetQualifierParm          xtokGetQualifierParm;

   XtokDeleteQualifier           xtokDeleteQualifier;
   XtokDeleteQualifierParm       xtokDeleteQualifierParm;
   
   XtokGetProperty               xtokGetProperty;
   XtokGetPropertyParm           xtokGetPropertyParm;
   
   XtokSetProperty               xtokSetProperty;
   XtokSetPropertyParms          xtokSetPropertyParms;
   XtokSetPropertyParmsList      xtokSetPropertyParmsList;
   
   XtokOpenEnumInstancePaths                xtokOpenEnumInstancePaths;
   XtokOpenEnumInstancePathsParmsList       xtokOpenEnumInstancePathsParmsList;
   XtokOpenEnumInstancePathsParms           xtokOpenEnumInstancePathsParms;

   XtokOpenEnumInstances                    xtokOpenEnumInstances;
   XtokOpenEnumInstancesParmsList           xtokOpenEnumInstancesParmsList;
   XtokOpenEnumInstancesParms               xtokOpenEnumInstancesParms;

   XtokOpenAssociatorInstancePaths          xtokOpenAssociatorInstancePaths;
   XtokOpenAssociatorInstancePathsParmsList xtokOpenAssociatorInstancePathsParmsList;
   XtokOpenAssociatorInstancePathsParms     xtokOpenAssociatorInstancePathsParms;

   XtokOpenAssociatorInstances              xtokOpenAssociatorInstances;
   XtokOpenAssociatorInstancesParmsList     xtokOpenAssociatorInstancesParmsList;
   XtokOpenAssociatorInstancesParms         xtokOpenAssociatorInstancesParms;

   XtokOpenReferenceInstancePaths           xtokOpenReferenceInstancePaths;
   XtokOpenReferenceInstancePathsParmsList  xtokOpenReferenceInstancePathsParmsList;
   XtokOpenReferenceInstancePathsParms      xtokOpenReferenceInstancePathsParms;

   XtokOpenReferenceInstances               xtokOpenReferenceInstances;
   XtokOpenReferenceInstancesParmsList      xtokOpenReferenceInstancesParmsList;
   XtokOpenReferenceInstancesParms          xtokOpenReferenceInstancesParms;

   XtokOpenQueryInstances                   xtokOpenQueryInstances;
   XtokOpenQueryInstancesParmsList          xtokOpenQueryInstancesParmsList;
   XtokOpenQueryInstancesParms              xtokOpenQueryInstancesParms;

   XtokPullInstances                   xtokPullInstances;
   XtokPullInstancesParmsList          xtokPullInstancesParmsList;
   XtokPullInstancesParms              xtokPullInstancesParms;

   XtokPullInstancesWithPath           xtokPullInstancesWithPath;
   XtokPullInstancesWithPathParmsList  xtokPullInstancesWithPathParmsList;
   XtokPullInstancesWithPathParms      xtokPullInstancesWithPathParms;

   XtokPullInstancePaths               xtokPullInstancePaths;
   XtokPullInstancePathsParmsList      xtokPullInstancePathsParmsList;
   XtokPullInstancePathsParms          xtokPullInstancePathsParms;

   XtokCloseEnumeration                xtokCloseEnumeration;

   XtokEnumerationCount                xtokEnumerationCount;

   XtokNewValue                  xtokNewValue;
   
   XtokScope                     xtokScope;
   



/* Line 293 of yacc.c  */
#line 2364 "cimXmlOps.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 343 of yacc.c  */
#line 2376 "cimXmlOps.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  4
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1063

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  140
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  128
/* YYNRULES -- Number of rules.  */
#define YYNRULES  466
/* YYNRULES -- Number of states.  */
#define YYNSTATES  911

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   394

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     7,    11,    15,    19,    23,    27,    31,
      35,    39,    43,    47,    51,    55,    59,    63,    67,    71,
      75,    79,    83,    87,    91,    95,    99,   103,   107,   111,
     115,   119,   123,   127,   131,   135,   139,   143,   147,   151,
     155,   159,   161,   164,   166,   169,   171,   174,   177,   181,
     185,   189,   193,   197,   201,   205,   209,   213,   216,   223,
     230,   232,   235,   237,   240,   244,   248,   252,   254,   256,
     258,   261,   265,   268,   272,   274,   277,   281,   283,   286,
     288,   291,   295,   299,   302,   306,   309,   313,   316,   320,
     323,   325,   328,   330,   333,   336,   340,   344,   347,   349,
     352,   354,   357,   360,   364,   367,   371,   374,   378,   381,
     385,   388,   392,   394,   397,   399,   402,   406,   410,   413,
     417,   420,   424,   427,   431,   434,   436,   439,   443,   445,
     448,   452,   454,   457,   459,   462,   466,   470,   473,   477,
     480,   482,   485,   489,   491,   494,   498,   503,   505,   508,
     510,   513,   517,   521,   524,   528,   531,   535,   538,   542,
     545,   549,   552,   560,   568,   570,   573,   575,   578,   582,
     586,   590,   593,   597,   600,   604,   607,   611,   614,   618,
     621,   625,   628,   632,   635,   637,   640,   642,   645,   649,
     653,   657,   660,   664,   667,   671,   674,   678,   681,   685,
     688,   690,   693,   695,   698,   702,   706,   710,   713,   717,
     720,   724,   727,   731,   734,   736,   739,   741,   744,   748,
     752,   756,   759,   763,   766,   771,   775,   776,   779,   782,
     785,   789,   790,   793,   798,   799,   802,   806,   807,   810,
     813,   814,   819,   820,   822,   824,   825,   828,   833,   838,
     843,   844,   847,   848,   850,   852,   854,   858,   862,   866,
     869,   873,   878,   881,   886,   891,   896,   900,   906,   912,
     915,   918,   922,   924,   927,   931,   935,   939,   943,   945,
     948,   951,   953,   956,   958,   961,   965,   969,   972,   976,
     979,   983,   986,   990,   993,   997,  1000,  1002,  1005,  1007,
    1010,  1014,  1018,  1021,  1025,  1028,  1032,  1035,  1039,  1042,
    1046,  1049,  1053,  1056,  1060,  1063,  1067,  1070,  1074,  1077,
    1081,  1084,  1086,  1089,  1091,  1094,  1098,  1102,  1105,  1109,
    1112,  1116,  1119,  1123,  1126,  1130,  1133,  1137,  1140,  1144,
    1147,  1151,  1154,  1158,  1161,  1163,  1166,  1168,  1171,  1175,
    1179,  1182,  1186,  1189,  1193,  1196,  1200,  1203,  1207,  1210,
    1214,  1217,  1221,  1224,  1228,  1231,  1235,  1238,  1242,  1245,
    1249,  1252,  1256,  1259,  1261,  1264,  1266,  1269,  1273,  1277,
    1280,  1284,  1287,  1291,  1294,  1298,  1301,  1305,  1308,  1312,
    1315,  1319,  1322,  1324,  1327,  1329,  1332,  1336,  1340,  1343,
    1347,  1350,  1354,  1357,  1361,  1364,  1368,  1371,  1375,  1378,
    1382,  1385,  1389,  1392,  1396,  1399,  1403,  1406,  1408,  1411,
    1413,  1416,  1420,  1423,  1427,  1430,  1434,  1437,  1441,  1444,
    1448,  1451,  1455,  1458,  1460,  1463,  1465,  1468,  1472,  1475,
    1479,  1482,  1484,  1487,  1489,  1492,  1496,  1499,  1503,  1506,
    1508,  1511,  1513,  1516,  1520,  1523,  1527,  1530,  1535,  1540,
    1543,  1546,  1549,  1553,  1555,  1558,  1563
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     141,     0,    -1,     3,     4,   142,    -1,     5,   143,     6,
      -1,     7,   144,     8,    -1,     9,   145,    10,    -1,    11,
     162,    45,    -1,    12,   165,    45,    -1,    13,   168,    45,
      -1,    17,   183,    45,    -1,    19,   171,    45,    -1,    18,
     178,    45,    -1,    15,   176,    45,    -1,    20,   185,    45,
      -1,    21,   186,    45,    -1,    23,   190,    45,    -1,    25,
     196,    45,    -1,    24,   193,    45,    -1,    26,   199,    45,
      -1,    22,   189,    45,    -1,    46,   146,    47,    -1,    16,
     181,    45,    -1,    14,   174,    45,    -1,    29,   159,    45,
      -1,    27,   160,    45,    -1,    30,   155,    45,    -1,    31,
     157,    45,    -1,    32,   149,    45,    -1,    28,   151,    45,
      -1,    33,   231,    45,    -1,    34,   234,    45,    -1,    36,
     240,    45,    -1,    35,   237,    45,    -1,    38,   246,    45,
      -1,    37,   243,    45,    -1,    39,   249,    45,    -1,    40,
     252,    45,    -1,    41,   255,    45,    -1,    42,   258,    45,
      -1,    43,   261,    45,    -1,    44,   262,    45,    -1,   223,
      -1,   223,   147,    -1,   222,    -1,   222,   147,    -1,   148,
      -1,   147,   148,    -1,   132,   133,    -1,   132,   224,   133,
      -1,   132,   225,   133,    -1,   132,   227,   133,    -1,   132,
     228,   133,    -1,   132,   264,   133,    -1,   132,   265,   133,
      -1,   132,   203,   133,    -1,   132,   208,   133,    -1,   132,
     202,   133,    -1,   217,   150,    -1,    93,   224,    54,    82,
     265,    54,    -1,    82,   265,    54,    93,   224,    54,    -1,
     217,    -1,   217,   152,    -1,   153,    -1,   152,   153,    -1,
      82,   265,    54,    -1,    93,   224,    54,    -1,    94,   154,
      54,    -1,   224,    -1,   225,    -1,   227,    -1,   217,   156,
      -1,    92,   224,    54,    -1,   217,   158,    -1,    92,   224,
      54,    -1,   217,    -1,   217,   161,    -1,    91,   210,    54,
      -1,   217,    -1,   217,   163,    -1,   164,    -1,   163,   164,
      -1,    79,   264,    54,    -1,    75,   230,    54,    -1,    75,
      54,    -1,    76,   230,    54,    -1,    76,    54,    -1,    77,
     230,    54,    -1,    77,    54,    -1,   103,   225,    54,    -1,
     103,    54,    -1,   217,    -1,   217,   166,    -1,   167,    -1,
     166,   167,    -1,    79,    54,    -1,    79,   264,    54,    -1,
      78,   230,    54,    -1,    78,    54,    -1,   217,    -1,   217,
     169,    -1,   170,    -1,   169,   170,    -1,    79,    54,    -1,
      79,   264,    54,    -1,    78,    54,    -1,    78,   230,    54,
      -1,    75,    54,    -1,    75,   230,    54,    -1,    76,    54,
      -1,    76,   230,    54,    -1,    77,    54,    -1,    77,   230,
      54,    -1,   217,    -1,   217,   172,    -1,   173,    -1,   172,
     173,    -1,    82,   265,    54,    -1,    75,   230,    54,    -1,
      75,    54,    -1,    76,   230,    54,    -1,    76,    54,    -1,
      77,   230,    54,    -1,    77,    54,    -1,   103,   225,    54,
      -1,   103,    54,    -1,   217,    -1,   217,   175,    -1,    90,
     203,    54,    -1,   217,    -1,   217,   177,    -1,    80,   208,
      54,    -1,   217,    -1,   217,   179,    -1,   180,    -1,   179,
     180,    -1,    81,   202,    54,    -1,    76,   230,    54,    -1,
      76,    54,    -1,   103,   225,    54,    -1,   103,    54,    -1,
     217,    -1,   217,   182,    -1,    79,   264,    54,    -1,   217,
      -1,   217,   184,    -1,    82,   265,    54,    -1,   217,    79,
     264,    54,    -1,   217,    -1,   217,   187,    -1,   188,    -1,
     187,   188,    -1,    79,   264,    54,    -1,    75,   230,    54,
      -1,    75,    54,    -1,    76,   230,    54,    -1,    76,    54,
      -1,    78,   230,    54,    -1,    78,    54,    -1,    77,   230,
      54,    -1,    77,    54,    -1,   103,   225,    54,    -1,   103,
      54,    -1,   217,    88,   224,    54,    89,   224,    54,    -1,
     217,    89,   224,    54,    88,   224,    54,    -1,   217,    -1,
     217,   191,    -1,   192,    -1,   191,   192,    -1,    83,   265,
      54,    -1,    83,   264,    54,    -1,    84,   264,    54,    -1,
      84,    54,    -1,    85,   264,    54,    -1,    85,    54,    -1,
      86,   224,    54,    -1,    86,    54,    -1,    87,   224,    54,
      -1,    87,    54,    -1,    76,   230,    54,    -1,    76,    54,
      -1,    77,   230,    54,    -1,    77,    54,    -1,   103,   225,
      54,    -1,   103,    54,    -1,   217,    -1,   217,   194,    -1,
     195,    -1,   194,   195,    -1,    83,   265,    54,    -1,    83,
     264,    54,    -1,    85,   264,    54,    -1,    85,    54,    -1,
      86,   224,    54,    -1,    86,    54,    -1,    76,   230,    54,
      -1,    76,    54,    -1,    77,   230,    54,    -1,    77,    54,
      -1,   103,   225,    54,    -1,   103,    54,    -1,   217,    -1,
     217,   197,    -1,   198,    -1,   197,   198,    -1,    83,   265,
      54,    -1,    83,   264,    54,    -1,    84,   264,    54,    -1,
      84,    54,    -1,    85,   264,    54,    -1,    85,    54,    -1,
      86,   224,    54,    -1,    86,    54,    -1,    87,   224,    54,
      -1,    87,    54,    -1,   217,    -1,   217,   200,    -1,   201,
      -1,   200,   201,    -1,    83,   265,    54,    -1,    83,   264,
      54,    -1,    85,   264,    54,    -1,    85,    54,    -1,    86,
     224,    54,    -1,    86,    54,    -1,   104,   265,   208,   105,
      -1,   128,   204,   129,    -1,    -1,   204,   216,    -1,   204,
     213,    -1,   204,   205,    -1,   126,   206,   127,    -1,    -1,
     206,   216,    -1,   206,   118,   207,   119,    -1,    -1,   207,
     216,    -1,   130,   209,   131,    -1,    -1,   209,   216,    -1,
     209,   213,    -1,    -1,   108,   212,   211,   109,    -1,    -1,
     224,    -1,   225,    -1,    -1,   110,   111,    -1,   112,   214,
     215,   113,    -1,   116,   214,   215,   117,    -1,   114,   214,
     215,   115,    -1,    -1,   214,   216,    -1,    -1,   224,    -1,
     227,    -1,   225,    -1,   106,   224,   107,    -1,   106,   225,
     107,    -1,    50,   218,    51,    -1,    52,    53,    -1,   218,
      52,    53,    -1,    48,   220,   217,    49,    -1,    55,    56,
      -1,   134,   219,   265,   135,    -1,   136,   217,   265,   137,
      -1,   138,   217,   264,   139,    -1,    57,   208,    58,    -1,
      57,    59,   208,    60,    58,    -1,    57,    59,   203,    60,
      58,    -1,    57,    58,    -1,    61,    62,    -1,    61,   226,
      62,    -1,   224,    -1,   226,   224,    -1,    63,   221,    64,
      -1,    63,   222,    64,    -1,    63,   265,    64,    -1,    65,
     229,    66,    -1,   227,    -1,   229,   227,    -1,    57,    58,
      -1,   217,    -1,   217,   232,    -1,   233,    -1,   232,   233,
      -1,    79,   264,    54,    -1,    97,   230,    54,    -1,    97,
      54,    -1,   100,   224,    54,    -1,   100,    54,    -1,   101,
     224,    54,    -1,   101,    54,    -1,    96,   224,    54,    -1,
      96,    54,    -1,    95,   224,    54,    -1,    95,    54,    -1,
     217,    -1,   217,   235,    -1,   236,    -1,   235,   236,    -1,
      79,   264,    54,    -1,    75,   230,    54,    -1,    75,    54,
      -1,    76,   230,    54,    -1,    76,    54,    -1,    78,   230,
      54,    -1,    78,    54,    -1,    77,   230,    54,    -1,    77,
      54,    -1,   103,   225,    54,    -1,   103,    54,    -1,    97,
     230,    54,    -1,    97,    54,    -1,   100,   224,    54,    -1,
     100,    54,    -1,   101,   224,    54,    -1,   101,    54,    -1,
      96,   224,    54,    -1,    96,    54,    -1,    95,   224,    54,
      -1,    95,    54,    -1,   217,    -1,   217,   238,    -1,   239,
      -1,   238,   239,    -1,    82,   265,    54,    -1,    84,   264,
      54,    -1,    84,    54,    -1,    85,   264,    54,    -1,    85,
      54,    -1,    86,   224,    54,    -1,    86,    54,    -1,    87,
     224,    54,    -1,    87,    54,    -1,    97,   230,    54,    -1,
      97,    54,    -1,   100,   224,    54,    -1,   100,    54,    -1,
     101,   224,    54,    -1,   101,    54,    -1,    96,   224,    54,
      -1,    96,    54,    -1,    95,   224,    54,    -1,    95,    54,
      -1,   217,    -1,   217,   241,    -1,   242,    -1,   241,   242,
      -1,    82,   265,    54,    -1,    84,   264,    54,    -1,    84,
      54,    -1,    85,   264,    54,    -1,    85,    54,    -1,    86,
     224,    54,    -1,    86,    54,    -1,    87,   224,    54,    -1,
      87,    54,    -1,    76,   230,    54,    -1,    76,    54,    -1,
      77,   230,    54,    -1,    77,    54,    -1,   103,   225,    54,
      -1,   103,    54,    -1,    97,   230,    54,    -1,    97,    54,
      -1,   100,   224,    54,    -1,   100,    54,    -1,   101,   224,
      54,    -1,   101,    54,    -1,    96,   224,    54,    -1,    96,
      54,    -1,    95,   224,    54,    -1,    95,    54,    -1,   217,
      -1,   217,   244,    -1,   245,    -1,   244,   245,    -1,    82,
     265,    54,    -1,    85,   264,    54,    -1,    85,    54,    -1,
      86,   224,    54,    -1,    86,    54,    -1,    97,   230,    54,
      -1,    97,    54,    -1,   100,   224,    54,    -1,   100,    54,
      -1,   101,   224,    54,    -1,   101,    54,    -1,    96,   224,
      54,    -1,    96,    54,    -1,    95,   224,    54,    -1,    95,
      54,    -1,   217,    -1,   217,   247,    -1,   248,    -1,   247,
     248,    -1,    82,   265,    54,    -1,    85,   264,    54,    -1,
      85,    54,    -1,    86,   224,    54,    -1,    86,    54,    -1,
      76,   230,    54,    -1,    76,    54,    -1,    77,   230,    54,
      -1,    77,    54,    -1,   103,   225,    54,    -1,   103,    54,
      -1,    97,   230,    54,    -1,    97,    54,    -1,   100,   224,
      54,    -1,   100,    54,    -1,   101,   224,    54,    -1,   101,
      54,    -1,    96,   224,    54,    -1,    96,    54,    -1,    95,
     224,    54,    -1,    95,    54,    -1,   217,    -1,   217,   250,
      -1,   251,    -1,   250,   251,    -1,    99,   230,    54,    -1,
      99,    54,    -1,    97,   230,    54,    -1,    97,    54,    -1,
     100,   224,    54,    -1,   100,    54,    -1,   101,   224,    54,
      -1,   101,    54,    -1,    96,   224,    54,    -1,    96,    54,
      -1,    95,   224,    54,    -1,    95,    54,    -1,   217,    -1,
     217,   253,    -1,   254,    -1,   253,   254,    -1,   101,   224,
      54,    -1,   101,    54,    -1,   102,   263,    54,    -1,   102,
      54,    -1,   217,    -1,   217,   256,    -1,   257,    -1,   256,
     257,    -1,   101,   224,    54,    -1,   101,    54,    -1,   102,
     263,    54,    -1,   102,    54,    -1,   217,    -1,   217,   259,
      -1,   260,    -1,   259,   260,    -1,   101,   224,    54,    -1,
     101,    54,    -1,   102,   263,    54,    -1,   102,    54,    -1,
     217,   102,   263,    54,    -1,   217,   102,   263,    54,    -1,
      57,    58,    -1,    67,    68,    -1,    69,    70,    -1,    69,
     266,    70,    -1,   267,    -1,   266,   267,    -1,    71,    73,
      74,    72,    -1,    71,   227,    72,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  2326,  2326,  2332,  2338,  2344,  2350,  2353,  2356,  2359,
    2362,  2365,  2368,  2371,  2374,  2377,  2380,  2383,  2386,  2389,
    2392,  2395,  2398,  2401,  2404,  2407,  2410,  2413,  2416,  2419,
    2422,  2425,  2428,  2431,  2434,  2437,  2440,  2443,  2446,  2449,
    2452,  2463,  2476,  2488,  2502,  2518,  2524,  2531,  2536,  2546,
    2558,  2563,  2569,  2574,  2579,  2584,  2589,  2601,  2615,  2620,
    2632,  2643,  2659,  2665,  2680,  2687,  2694,  2703,  2716,  2721,
    2732,  2745,  2755,  2768,  2778,  2794,  2809,  2820,  2834,  2851,
    2862,  2876,  2884,  2891,  2895,  2902,  2906,  2913,  2917,  2924,
    2936,  2947,  2961,  2966,  2974,  2979,  2984,  2990,  3002,  3013,
    3027,  3033,  3042,  3046,  3051,  3055,  3061,  3065,  3071,  3075,
    3081,  3085,  3098,  3113,  3131,  3142,  3156,  3164,  3171,  3175,
    3182,  3186,  3193,  3197,  3204,  3217,  3228,  3243,  3256,  3266,
    3281,  3293,  3306,  3323,  3334,  3349,  3357,  3364,  3368,  3375,
    3387,  3397,  3412,  3424,  3434,  3449,  3462,  3481,  3494,  3510,
    3520,  3533,  3540,  3548,  3552,  3560,  3564,  3572,  3576,  3584,
    3588,  3595,  3609,  3622,  3644,  3662,  3684,  3701,  3721,  3730,
    3744,  3752,  3756,  3764,  3768,  3776,  3780,  3788,  3792,  3801,
    3805,  3814,  3818,  3825,  3840,  3856,  3876,  3891,  3909,  3918,
    3929,  3937,  3941,  3949,  3953,  3962,  3966,  3975,  3979,  3986,
    3999,  4014,  4032,  4043,  4057,  4063,  4071,  4077,  4081,  4087,
    4091,  4097,  4101,  4107,  4121,  4134,  4151,  4160,  4172,  4178,
    4186,  4192,  4196,  4202,  4214,  4227,  4242,  4243,  4248,  4252,
    4259,  4274,  4275,  4282,  4296,  4297,  4312,  4326,  4332,  4336,
    4347,  4348,  4357,  4360,  4365,  4376,  4377,  4387,  4399,  4404,
    4420,  4423,  4432,  4437,  4441,  4445,  4458,  4462,  4476,  4483,
    4487,  4500,  4508,  4514,  4533,  4542,  4555,  4561,  4567,  4571,
    4579,  4584,  4594,  4601,  4613,  4618,  4623,  4631,  4638,  4645,
    4657,  4669,  4680,  4698,  4708,  4721,  4726,  4732,  4736,  4741,
    4745,  4750,  4754,  4759,  4763,  4768,  4780,  4793,  4813,  4827,
    4844,  4849,  4855,  4859,  4865,  4869,  4875,  4879,  4885,  4889,
    4895,  4899,  4905,  4909,  4914,  4918,  4923,  4927,  4932,  4936,
    4941,  4953,  4970,  4994,  5011,  5031,  5037,  5042,  5046,  5051,
    5055,  5060,  5064,  5069,  5073,  5079,  5083,  5088,  5092,  5097,
    5101,  5106,  5110,  5115,  5127,  5145,  5171,  5192,  5216,  5222,
    5227,  5231,  5236,  5240,  5245,  5249,  5254,  5258,  5264,  5268,
    5274,  5278,  5284,  5288,  5294,  5298,  5303,  5307,  5312,  5316,
    5321,  5325,  5330,  5342,  5357,  5379,  5394,  5412,  5418,  5423,
    5427,  5432,  5436,  5442,  5446,  5451,  5455,  5460,  5464,  5469,
    5473,  5478,  5490,  5506,  5530,  5549,  5571,  5577,  5582,  5586,
    5591,  5595,  5601,  5605,  5611,  5615,  5621,  5625,  5631,  5635,
    5640,  5644,  5649,  5653,  5658,  5662,  5667,  5679,  5689,  5709,
    5718,  5730,  5736,  5740,  5746,  5750,  5755,  5759,  5764,  5768,
    5773,  5777,  5782,  5793,  5803,  5818,  5823,  5831,  5836,  5840,
    5845,  5857,  5868,  5884,  5889,  5897,  5902,  5906,  5911,  5923,
    5934,  5950,  5955,  5963,  5968,  5972,  5977,  5988,  6006,  6021,
    6028,  6040,  6046,  6054,  6064,  6079,  6085
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "XTOK_XML", "ZTOK_XML", "XTOK_CIM",
  "ZTOK_CIM", "XTOK_MESSAGE", "ZTOK_MESSAGE", "XTOK_SIMPLEREQ",
  "ZTOK_SIMPLEREQ", "XTOK_GETCLASS", "XTOK_ENUMCLASSNAMES",
  "XTOK_ENUMCLASSES", "XTOK_CREATECLASS", "XTOK_CREATEINSTANCE",
  "XTOK_DELETECLASS", "XTOK_DELETEINSTANCE", "XTOK_MODIFYINSTANCE",
  "XTOK_GETINSTANCE", "XTOK_ENUMINSTANCENAMES", "XTOK_ENUMINSTANCES",
  "XTOK_EXECQUERY", "XTOK_ASSOCIATORS", "XTOK_REFERENCES",
  "XTOK_ASSOCIATORNAMES", "XTOK_REFERENCENAMES", "XTOK_SETQUALIFIER",
  "XTOK_SETPROPERTY", "XTOK_ENUMQUALIFIERS", "XTOK_GETQUALIFIER",
  "XTOK_DELETEQUALIFIER", "XTOK_GETPROPERTY", "XTOK_OPENENUMINSTANCEPATHS",
  "XTOK_OPENENUMINSTANCES", "XTOK_OPENASSOCIATORINSTANCEPATHS",
  "XTOK_OPENASSOCIATORINSTANCES", "XTOK_OPENREFERENCEINSTANCEPATHS",
  "XTOK_OPENREFERENCEINSTANCES", "XTOK_OPENQUERYINSTANCES",
  "XTOK_PULLINSTANCES", "XTOK_PULLINSTANCESWITHPATH",
  "XTOK_PULLINSTANCEPATHS", "XTOK_CLOSEENUMERATION",
  "XTOK_ENUMERATIONCOUNT", "ZTOK_IMETHODCALL", "XTOK_METHODCALL",
  "ZTOK_METHODCALL", "XTOK_NAMESPACEPATH", "ZTOK_NAMESPACEPATH",
  "XTOK_LOCALNAMESPACEPATH", "ZTOK_LOCALNAMESPACEPATH", "XTOK_NAMESPACE",
  "ZTOK_NAMESPACE", "ZTOK_IPARAMVALUE", "XTOK_HOST", "ZTOK_HOST",
  "XTOK_VALUE", "ZTOK_VALUE", "XTOK_CDATA", "ZTOK_CDATA",
  "XTOK_VALUEARRAY", "ZTOK_VALUEARRAY", "XTOK_VALUEREFERENCE",
  "ZTOK_VALUEREFERENCE", "XTOK_VALUEREFARRAY", "ZTOK_VALUEREFARRAY",
  "XTOK_CLASSNAME", "ZTOK_CLASSNAME", "XTOK_INSTANCENAME",
  "ZTOK_INSTANCENAME", "XTOK_KEYBINDING", "ZTOK_KEYBINDING",
  "XTOK_KEYVALUE", "ZTOK_KEYVALUE", "XTOK_IP_LOCALONLY",
  "XTOK_IP_INCLUDEQUALIFIERS", "XTOK_IP_INCLUDECLASSORIGIN",
  "XTOK_IP_DEEPINHERITANCE", "XTOK_IP_CLASSNAME", "XTOK_IP_INSTANCE",
  "XTOK_IP_MODIFIEDINSTANCE", "XTOK_IP_INSTANCENAME", "XTOK_IP_OBJECTNAME",
  "XTOK_IP_ASSOCCLASS", "XTOK_IP_RESULTCLASS", "XTOK_IP_ROLE",
  "XTOK_IP_RESULTROLE", "XTOK_IP_QUERY", "XTOK_IP_QUERYLANG",
  "XTOK_IP_CLASS", "XTOK_IP_QUALIFIERDECLARATION", "XTOK_IP_QUALIFIERNAME",
  "XTOK_IP_PROPERTYNAME", "XTOK_IP_NEWVALUE", "XTOK_IP_FILTERQUERYLANG",
  "XTOK_IP_FILTERQUERY", "XTOK_IP_CONTINUEONERROR",
  "XTOK_IP_ENDOFSEQUENCE", "XTOK_IP_RETURNQUERYRESULTCLASS",
  "XTOK_IP_OPERATIONTIMEOUT", "XTOK_IP_MAXOBJECTCOUNT",
  "XTOK_IP_ENUMERATIONCONTEXT", "XTOK_IP_PROPERTYLIST",
  "XTOK_VALUENAMEDINSTANCE", "ZTOK_VALUENAMEDINSTANCE", "XTOK_QUALIFIER",
  "ZTOK_QUALIFIER", "XTOK_QUALIFIERDECLARATION",
  "ZTOK_QUALIFIERDECLARATION", "XTOK_SCOPE", "ZTOK_SCOPE", "XTOK_PROPERTY",
  "ZTOK_PROPERTY", "XTOK_PROPERTYARRAY", "ZTOK_PROPERTYARRAY",
  "XTOK_PROPERTYREFERENCE", "ZTOK_PROPERTYREFERENCE", "XTOK_PARAM",
  "ZTOK_PARAM", "XTOK_PARAMARRAY", "ZTOK_PARAMARRAY", "XTOK_PARAMREF",
  "ZTOK_PARAMREF", "XTOK_PARAMREFARRAY", "ZTOK_PARAMREFARRAY",
  "XTOK_METHOD", "ZTOK_METHOD", "XTOK_CLASS", "ZTOK_CLASS",
  "XTOK_INSTANCE", "ZTOK_INSTANCE", "XTOK_PARAMVALUE", "ZTOK_PARAMVALUE",
  "XTOK_INSTANCEPATH", "ZTOK_INSTANCEPATH", "XTOK_LOCALINSTANCEPATH",
  "ZTOK_LOCALINSTANCEPATH", "XTOK_LOCALCLASSPATH", "ZTOK_LOCALCLASSPATH",
  "$accept", "start", "cimOperation", "message", "simpleReq",
  "iMethodCall", "methodCall", "paramValues", "paramValue", "getProperty",
  "getPropertyParm", "setProperty", "setPropertyParmsList",
  "setPropertyParms", "newValue", "getQualifier", "getQualifierParm",
  "deleteQualifier", "deleteQualifierParm", "enumQualifiers",
  "setQualifier", "setQualifierParm", "getClass", "getClassParmsList",
  "getClassParms", "enumClassNames", "enumClassNamesParmsList",
  "enumClassNamesParms", "enumClasses", "enumClassesParmsList",
  "enumClassesParms", "getInstance", "getInstanceParmsList",
  "getInstanceParms", "createClass", "createClassParm", "createInstance",
  "createInstanceParm", "modifyInstance", "modifyInstanceParmsList",
  "modifyInstanceParms", "deleteClass", "deleteClassParm",
  "deleteInstance", "deleteInstanceParm", "enumInstanceNames",
  "enumInstances", "enumInstancesParmsList", "enumInstancesParms",
  "execQuery", "associators", "associatorsParmsList", "associatorsParms",
  "references", "referencesParmsList", "referencesParms",
  "associatorNames", "associatorNamesParmsList", "associatorNamesParms",
  "referenceNames", "referenceNamesParmsList", "referenceNamesParms",
  "namedInstance", "class", "classData", "method", "methodData",
  "parameter", "instance", "instanceData", "qualifierDeclaration",
  "qualifierDeclarationData", "scope", "property", "qualifierList",
  "propertyData", "qualifier", "localNameSpacePath", "namespaces",
  "nameSpacePath", "host", "instancePath", "localInstancePath",
  "localClassPath", "value", "valueArray", "valueList", "valueReference",
  "valueRefArray", "valueRefList", "boolValue", "openEnumInstancePaths",
  "openEnumInstancePathsParmsList", "openEnumInstancePathsParms",
  "openEnumInstances", "openEnumInstancesParmsList",
  "openEnumInstancesParms", "openAssociatorInstancePaths",
  "openAssociatorInstancePathsParmsList",
  "openAssociatorInstancePathsParms", "openAssociatorInstances",
  "openAssociatorInstancesParmsList", "openAssociatorInstancesParms",
  "openReferenceInstancePaths", "openReferenceInstancePathsParmsList",
  "openReferenceInstancePathsParms", "openReferenceInstances",
  "openReferenceInstancesParmsList", "openReferenceInstancesParms",
  "openQueryInstances", "openQueryInstancesParmsList",
  "openQueryInstancesParms", "pullInstances", "pullInstancesParmsList",
  "pullInstancesParms", "pullInstancesWithPath",
  "pullInstancesWithPathParmsList", "pullInstancesWithPathParms",
  "pullInstancePaths", "pullInstancePathsParmsList",
  "pullInstancePathsParms", "closeEnumeration", "enumerationCount",
  "enumerationContext", "className", "instanceName", "keyBindings",
  "keyBinding", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   140,   141,   142,   143,   144,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   146,   146,   146,   146,   147,   147,   148,   148,   148,
     148,   148,   148,   148,   148,   148,   148,   149,   150,   150,
     151,   151,   152,   152,   153,   153,   153,   154,   154,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   162,   163,
     163,   164,   164,   164,   164,   164,   164,   164,   164,   164,
     165,   165,   166,   166,   167,   167,   167,   167,   168,   168,
     169,   169,   170,   170,   170,   170,   170,   170,   170,   170,
     170,   170,   171,   171,   172,   172,   173,   173,   173,   173,
     173,   173,   173,   173,   173,   174,   174,   175,   176,   176,
     177,   178,   178,   179,   179,   180,   180,   180,   180,   180,
     181,   181,   182,   183,   183,   184,   185,   186,   186,   187,
     187,   188,   188,   188,   188,   188,   188,   188,   188,   188,
     188,   188,   189,   189,   190,   190,   191,   191,   192,   192,
     192,   192,   192,   192,   192,   192,   192,   192,   192,   192,
     192,   192,   192,   192,   193,   193,   194,   194,   195,   195,
     195,   195,   195,   195,   195,   195,   195,   195,   195,   195,
     196,   196,   197,   197,   198,   198,   198,   198,   198,   198,
     198,   198,   198,   198,   199,   199,   200,   200,   201,   201,
     201,   201,   201,   201,   202,   203,   204,   204,   204,   204,
     205,   206,   206,   206,   207,   207,   208,   209,   209,   209,
     210,   210,   211,   211,   211,   212,   212,   213,   213,   213,
     214,   214,   215,   215,   215,   215,   216,   216,   217,   218,
     218,   219,   220,   221,   222,   223,   224,   224,   224,   224,
     225,   225,   226,   226,   227,   227,   227,   228,   229,   229,
     230,   231,   231,   232,   232,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   234,   234,   235,   235,
     236,   236,   236,   236,   236,   236,   236,   236,   236,   236,
     236,   236,   236,   236,   236,   236,   236,   236,   236,   236,
     236,   237,   237,   238,   238,   239,   239,   239,   239,   239,
     239,   239,   239,   239,   239,   239,   239,   239,   239,   239,
     239,   239,   239,   239,   240,   240,   241,   241,   242,   242,
     242,   242,   242,   242,   242,   242,   242,   242,   242,   242,
     242,   242,   242,   242,   242,   242,   242,   242,   242,   242,
     242,   242,   242,   243,   243,   244,   244,   245,   245,   245,
     245,   245,   245,   245,   245,   245,   245,   245,   245,   245,
     245,   245,   246,   246,   247,   247,   248,   248,   248,   248,
     248,   248,   248,   248,   248,   248,   248,   248,   248,   248,
     248,   248,   248,   248,   248,   248,   248,   249,   249,   250,
     250,   251,   251,   251,   251,   251,   251,   251,   251,   251,
     251,   251,   251,   252,   252,   253,   253,   254,   254,   254,
     254,   255,   255,   256,   256,   257,   257,   257,   257,   258,
     258,   259,   259,   260,   260,   260,   260,   261,   262,   263,
     264,   265,   265,   266,   266,   267,   267
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     1,     2,     1,     2,     1,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     6,     6,
       1,     2,     1,     2,     3,     3,     3,     1,     1,     1,
       2,     3,     2,     3,     1,     2,     3,     1,     2,     1,
       2,     3,     3,     2,     3,     2,     3,     2,     3,     2,
       1,     2,     1,     2,     2,     3,     3,     2,     1,     2,
       1,     2,     2,     3,     2,     3,     2,     3,     2,     3,
       2,     3,     1,     2,     1,     2,     3,     3,     2,     3,
       2,     3,     2,     3,     2,     1,     2,     3,     1,     2,
       3,     1,     2,     1,     2,     3,     3,     2,     3,     2,
       1,     2,     3,     1,     2,     3,     4,     1,     2,     1,
       2,     3,     3,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     7,     7,     1,     2,     1,     2,     3,     3,
       3,     2,     3,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     3,     2,     1,     2,     1,     2,     3,     3,
       3,     2,     3,     2,     3,     2,     3,     2,     3,     2,
       1,     2,     1,     2,     3,     3,     3,     2,     3,     2,
       3,     2,     3,     2,     1,     2,     1,     2,     3,     3,
       3,     2,     3,     2,     4,     3,     0,     2,     2,     2,
       3,     0,     2,     4,     0,     2,     3,     0,     2,     2,
       0,     4,     0,     1,     1,     0,     2,     4,     4,     4,
       0,     2,     0,     1,     1,     1,     3,     3,     3,     2,
       3,     4,     2,     4,     4,     4,     3,     5,     5,     2,
       2,     3,     1,     2,     3,     3,     3,     3,     1,     2,
       2,     1,     2,     1,     2,     3,     3,     2,     3,     2,
       3,     2,     3,     2,     3,     2,     1,     2,     1,     2,
       3,     3,     2,     3,     2,     3,     2,     3,     2,     3,
       2,     3,     2,     3,     2,     3,     2,     3,     2,     3,
       2,     1,     2,     1,     2,     3,     3,     2,     3,     2,
       3,     2,     3,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     3,     2,     1,     2,     1,     2,     3,     3,
       2,     3,     2,     3,     2,     3,     2,     3,     2,     3,
       2,     3,     2,     3,     2,     3,     2,     3,     2,     3,
       2,     3,     2,     1,     2,     1,     2,     3,     3,     2,
       3,     2,     3,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     1,     2,     1,     2,     3,     3,     2,     3,
       2,     3,     2,     3,     2,     3,     2,     3,     2,     3,
       2,     3,     2,     3,     2,     3,     2,     1,     2,     1,
       2,     3,     2,     3,     2,     3,     2,     3,     2,     3,
       2,     3,     2,     1,     2,     1,     2,     3,     2,     3,
       2,     1,     2,     1,     2,     3,     2,     3,     2,     1,
       2,     1,     2,     3,     2,     3,     2,     4,     4,     2,
       2,     2,     3,     1,     2,     4,     3
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,     0,     0,     1,     0,     2,     0,     0,     0,
       0,     3,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,    77,     0,    90,     0,    98,     0,   125,     0,   128,
       0,   140,     0,   143,     0,   131,     0,   112,     0,     0,
       0,   147,     0,     0,     0,   164,     0,   184,     0,   200,
       0,   214,     0,     0,     0,    60,     0,    74,     0,     0,
       0,     0,     0,     0,   281,     0,   296,     0,   321,     0,
     344,     0,   373,     0,   392,     0,   417,     0,   433,     0,
     441,     0,   449,     0,     0,     0,     0,     0,     0,     0,
       0,    43,    41,     5,     0,     0,     6,     0,     0,     0,
       0,     0,    78,    79,     7,     0,     0,    91,    92,     8,
       0,     0,     0,     0,     0,    99,   100,    22,     0,   126,
      12,     0,   129,    21,     0,   141,     9,     0,   144,    11,
       0,     0,     0,   132,   133,    10,     0,     0,     0,     0,
       0,   113,   114,    13,     0,    14,     0,     0,     0,     0,
       0,     0,   148,   149,    19,     0,     0,    15,     0,     0,
       0,     0,     0,     0,     0,     0,   165,   166,    17,     0,
       0,     0,     0,     0,     0,   185,   186,    16,     0,     0,
       0,     0,     0,   201,   202,    18,     0,     0,     0,   215,
     216,    24,   240,    75,    28,     0,     0,     0,    61,    62,
      23,    25,     0,    70,    26,     0,    72,    27,     0,     0,
      57,     0,     0,     0,     0,     0,     0,   282,   283,    29,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   297,   298,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   322,   323,    32,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     345,   346,    31,     0,     0,     0,     0,     0,     0,     0,
       0,   374,   375,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   393,   394,    33,     0,     0,
       0,     0,     0,     0,   418,   419,    35,     0,     0,   434,
     435,    36,     0,     0,   442,   443,    37,     0,     0,   450,
     451,    38,     0,    39,     0,    40,     0,     0,    20,     0,
      44,    45,    42,   259,   258,     0,    83,     0,     0,    85,
       0,    87,     0,     0,     0,    89,     0,     0,    80,    97,
       0,    94,     0,    93,   106,     0,   108,     0,   110,     0,
     104,     0,   102,     0,   101,   226,     0,   237,     0,     0,
       0,     0,   137,     0,     0,     0,   139,     0,   134,   118,
       0,   120,     0,   122,     0,     0,   124,     0,   115,     0,
     153,     0,   155,     0,   159,     0,   157,     0,     0,   161,
       0,   150,     0,     0,     0,   179,     0,   181,     0,     0,
       0,   171,     0,   173,     0,   175,     0,   177,     0,   183,
       0,   167,   195,     0,   197,     0,     0,     0,   191,     0,
     193,     0,   199,     0,   187,     0,     0,   207,     0,   209,
       0,   211,     0,   213,     0,   203,     0,     0,   221,     0,
     223,     0,   217,   245,     0,     0,     0,     0,     0,    67,
      68,    69,    63,     0,     0,     0,     0,     0,   295,     0,
     293,     0,   287,     0,   289,     0,   291,     0,   284,   302,
       0,   304,     0,   308,     0,   306,     0,     0,   320,     0,
     318,     0,   312,     0,   314,     0,   316,     0,   310,     0,
     299,     0,   327,     0,   329,     0,   331,     0,   333,     0,
     343,     0,   341,     0,   335,     0,   337,     0,   339,     0,
     324,   358,     0,   360,     0,     0,   350,     0,   352,     0,
     354,     0,   356,     0,   372,     0,   370,     0,   364,     0,
     366,     0,   368,     0,   362,     0,   347,     0,   379,     0,
     381,     0,   391,     0,   389,     0,   383,     0,   385,     0,
     387,     0,   376,   402,     0,   404,     0,     0,   398,     0,
     400,     0,   416,     0,   414,     0,   408,     0,   410,     0,
     412,     0,   406,     0,   395,   432,     0,   430,     0,   424,
       0,   422,     0,   426,     0,   428,     0,   420,   438,     0,
     440,     0,     0,   436,   446,     0,   448,     0,   444,   454,
       0,   456,     0,   452,     0,     0,     0,     0,     0,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
     260,   280,    82,    84,    86,   460,    81,   270,   272,     0,
      88,    96,    95,   107,   109,   111,   105,   103,     0,   127,
       0,   130,   142,   461,     0,     0,   463,   145,   136,     0,
     135,   138,   117,   119,   121,   116,   123,   146,   152,   154,
     158,   156,   151,   160,   269,     0,     0,     0,     0,   178,
     180,   169,   168,   170,   172,   174,   176,   182,   194,   196,
     189,   188,   190,   192,   198,   205,   204,   206,   208,   210,
     212,   219,   218,   220,   222,     0,   242,    76,    64,    65,
       0,     0,     0,     0,    66,    71,    73,     0,     0,   285,
     294,   292,   286,   288,   290,   301,   303,   307,   305,   300,
     319,   317,   311,   313,   315,   309,   325,   326,   328,   330,
     332,   342,   340,   334,   336,   338,   357,   359,   348,   349,
     351,   353,   355,   371,   369,   363,   365,   367,   361,   377,
     378,   380,   390,   388,   382,   384,   386,   401,   403,   396,
     397,   399,   415,   413,   407,   409,   411,   405,   431,   429,
     423,   421,   425,   427,   437,   459,   439,   445,   447,   453,
     455,   457,   458,   264,   265,   278,     0,    56,    54,    55,
      48,    49,    50,    51,    52,    53,   271,   273,     0,   250,
     250,   250,   231,   225,   229,   228,   227,   236,   239,   238,
       0,     0,   462,   464,     0,     0,     0,   266,     0,     0,
     246,     0,   243,   244,     0,     0,   274,   275,   276,     0,
       0,   277,   279,     0,     0,   252,   252,   252,     0,     0,
     466,   224,     0,     0,     0,     0,   241,     0,     0,     0,
       0,     0,   256,   257,     0,   251,   253,   255,   254,     0,
       0,   234,   230,   232,   465,   268,   267,   162,   163,   262,
       0,   263,    59,    58,   247,   249,   248,     0,   261,   233,
     235
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     2,     6,     8,    10,    47,   120,   350,   351,    92,
     240,    84,   228,   229,   478,    88,   233,    90,   236,    86,
      82,   223,    50,   132,   133,    52,   137,   138,    54,   145,
     146,    66,   171,   172,    56,   149,    58,   152,    64,   163,
     164,    60,   155,    62,   158,    68,    70,   182,   183,    72,
      74,   196,   197,    76,   205,   206,    78,   213,   214,    80,
     219,   220,   395,   386,   668,   834,   868,   907,   388,   670,
     474,   851,   726,   835,   865,   884,   885,    51,   125,   855,
     878,   731,   121,   122,   886,   887,   659,   888,   646,   816,
     358,    95,   247,   248,    97,   261,   262,    99,   274,   275,
     101,   290,   291,   103,   301,   302,   105,   315,   316,   107,
     324,   325,   109,   329,   330,   111,   334,   335,   113,   339,
     340,   115,   117,   622,   364,   391,   675,   676
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -632
static const yytype_int16 yypact[] =
{
      37,    52,    85,   116,  -632,   133,  -632,   157,   150,   565,
     182,  -632,   132,   132,   132,   132,   132,   132,   132,   132,
     132,   132,   132,   132,   132,   132,   132,   132,   132,   132,
     132,   132,   132,   132,   132,   132,   132,   132,   132,   132,
     132,   132,   132,   132,   132,   132,   147,   192,  -632,   108,
     169,    70,   214,   304,   248,   321,   258,   185,   298,   278,
     329,   309,   359,   233,   365,   -40,   383,   174,   393,   374,
     444,     1,   458,   144,   464,   186,   485,    93,   491,   332,
     498,   267,   527,   535,   616,   173,   618,  -632,   625,   547,
     626,   581,   627,    21,   199,   629,    -9,   630,   260,   631,
     236,   632,   145,   633,   355,   634,   290,   635,   247,   636,
     291,   637,   319,   638,   582,   640,   585,   641,   132,   132,
     642,   559,   559,  -632,   639,   392,  -632,    43,    63,    75,
     621,    83,    70,  -632,  -632,   137,    -5,   304,  -632,  -632,
     204,   230,   270,   305,     4,   321,  -632,  -632,   567,  -632,
    -632,   563,  -632,  -632,   621,  -632,  -632,   628,  -632,  -632,
     315,   595,   203,   -40,  -632,  -632,   351,   352,   368,   628,
     225,   174,  -632,  -632,   621,  -632,   372,   373,   379,   385,
     621,   227,     1,  -632,  -632,   643,   643,  -632,   391,   400,
     593,     7,    41,   405,   406,   243,   186,  -632,  -632,   407,
     411,   593,    69,   412,   244,    93,  -632,  -632,   593,    72,
      87,   413,   417,   332,  -632,  -632,   593,    98,   418,   267,
    -632,  -632,   588,  -632,  -632,   628,   643,   310,   173,  -632,
    -632,  -632,   643,  -632,  -632,   643,  -632,  -632,   628,   643,
    -632,   621,   419,   423,   424,   436,   437,   199,  -632,  -632,
     441,   442,   443,   447,   621,   448,   453,   454,   460,   461,
     253,    -9,  -632,  -632,   628,   110,   114,   462,   466,   468,
     470,   472,   474,   478,   260,  -632,  -632,   480,   484,   628,
     151,   152,   488,   490,   494,   495,   496,   500,   504,   265,
     236,  -632,  -632,   628,   154,   505,   506,   510,   511,   512,
     516,   145,  -632,  -632,   517,   556,   628,   155,   558,   560,
     562,   564,   566,   568,   274,   355,  -632,  -632,   573,   574,
     578,   579,   580,   584,   290,  -632,  -632,   586,   590,   247,
    -632,  -632,   591,   592,   291,  -632,  -632,   596,   597,   319,
    -632,  -632,   644,  -632,   644,  -632,   628,   621,  -632,   -15,
     559,  -632,   559,  -632,  -632,   645,  -632,   646,   648,  -632,
     649,  -632,   651,   622,   652,  -632,   249,   653,  -632,  -632,
     654,  -632,   655,  -632,  -632,   656,  -632,   657,  -632,   658,
    -632,   659,  -632,   660,  -632,  -632,   661,  -632,   662,   663,
     594,   664,  -632,   665,   628,   666,  -632,   667,  -632,  -632,
     668,  -632,   669,  -632,   670,   671,  -632,   672,  -632,   673,
    -632,   674,  -632,   676,  -632,   678,  -632,   679,   681,  -632,
     682,  -632,   -14,   683,   684,  -632,   685,  -632,   686,   687,
     688,  -632,   689,  -632,   691,  -632,   692,  -632,   693,  -632,
     694,  -632,  -632,   695,  -632,   696,   697,   698,  -632,   699,
    -632,   700,  -632,   701,  -632,   702,   703,  -632,   704,  -632,
     705,  -632,   706,  -632,   707,  -632,   708,   709,  -632,   712,
    -632,   713,  -632,   675,   714,   715,   716,   -12,   717,  -632,
    -632,  -632,  -632,   718,   719,   720,   722,   723,  -632,   724,
    -632,   725,  -632,   726,  -632,   727,  -632,   728,  -632,  -632,
     729,  -632,   730,  -632,   732,  -632,   733,   734,  -632,   735,
    -632,   736,  -632,   737,  -632,   738,  -632,   739,  -632,   740,
    -632,   741,  -632,   742,  -632,   743,  -632,   744,  -632,   745,
    -632,   746,  -632,   747,  -632,   748,  -632,   749,  -632,   750,
    -632,  -632,   751,  -632,   752,   753,  -632,   754,  -632,   755,
    -632,   756,  -632,   757,  -632,   758,  -632,   759,  -632,   760,
    -632,   761,  -632,   762,  -632,   763,  -632,   764,  -632,   765,
    -632,   766,  -632,   767,  -632,   768,  -632,   769,  -632,   770,
    -632,   771,  -632,  -632,   772,  -632,   773,   774,  -632,   775,
    -632,   776,  -632,   777,  -632,   778,  -632,   779,  -632,   780,
    -632,   781,  -632,   782,  -632,  -632,   783,  -632,   784,  -632,
     785,  -632,   786,  -632,   787,  -632,   788,  -632,  -632,   789,
    -632,   790,   791,  -632,  -632,   792,  -632,   793,  -632,  -632,
     795,  -632,   796,  -632,   797,   798,   557,   721,   794,  -632,
     711,   731,   799,   800,   801,   802,   803,   804,   805,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,   268,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,    81,  -632,
      19,  -632,  -632,  -632,    20,   598,  -632,  -632,  -632,   563,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,   528,   808,   806,   809,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,   807,    -2,  -632,  -632,  -632,
     810,   811,   812,   813,  -632,  -632,  -632,   814,   816,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,   589,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,    -2,  -632,
    -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
     815,   818,  -632,  -632,   817,   819,   820,  -632,   643,   643,
    -632,   821,  -632,  -632,   823,   628,  -632,  -632,  -632,   643,
     628,  -632,  -632,   822,   824,   -10,   -10,   -10,   -46,   827,
    -632,  -632,   825,   826,   828,   831,  -632,   830,   132,   829,
     833,   834,  -632,  -632,   832,  -632,  -632,  -632,  -632,   835,
     836,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,  -632,
     842,  -632,  -632,  -632,  -632,  -632,  -632,   141,  -632,  -632,
    -632
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -632,  -632,  -632,  -632,  -632,  -632,  -632,   837,   307,  -632,
    -632,  -632,  -632,   677,  -632,  -632,  -632,  -632,  -632,  -632,
    -632,  -632,  -632,  -632,   838,  -632,  -632,   839,  -632,  -632,
     710,  -632,  -632,   690,  -632,  -632,  -632,  -632,  -632,  -632,
     840,  -632,  -632,  -632,  -632,  -632,  -632,  -632,   680,  -632,
    -632,  -632,   841,  -632,  -632,   843,  -632,  -632,   650,  -632,
    -632,   844,   507,  -316,  -632,  -632,  -632,  -632,  -311,  -632,
    -632,  -632,  -632,   183,  -347,  -200,  -631,   -13,  -632,  -632,
    -632,  -632,   377,  -632,   -84,   -97,  -632,  -192,  -632,  -632,
     235,  -632,  -632,   612,  -632,  -632,   606,  -632,  -632,   599,
    -632,  -632,   602,  -632,  -632,   569,  -632,  -632,   553,  -632,
    -632,   545,  -632,  -632,   542,  -632,  -632,   538,  -632,  -632,
     554,  -632,  -632,    -4,   100,  -126,  -632,   206
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint16 yytable[] =
{
      53,    55,    57,    59,    61,    63,    65,    67,    69,    71,
      73,    75,    77,    79,    81,    83,    85,    87,    89,    91,
      93,    94,    96,    98,   100,   102,   104,   106,   108,   110,
     112,   114,   116,   641,   367,   481,   160,   836,   642,   839,
       1,   161,   422,   405,   694,   695,   366,   422,   477,   371,
     638,   366,   363,   477,   390,   422,     3,   390,   382,   366,
     828,   431,   363,   162,   430,   397,   250,   251,   252,   253,
     254,   363,   891,   407,   363,   447,   176,   177,   178,   179,
     180,   892,   456,   477,   420,     4,   255,   256,   257,   394,
     467,   258,   259,   840,   260,   433,   828,   356,   440,   475,
     357,   423,   424,   238,   181,   346,   347,   453,   363,   436,
     438,   696,   485,   385,   239,   387,   387,   359,   639,   451,
     357,     5,   730,   448,   118,   828,   457,   462,   464,   361,
     480,   829,   357,   830,   471,   831,   363,   365,   521,   363,
       7,   459,   476,   479,   366,   127,   128,   129,   483,   130,
     837,   484,   468,   545,   363,   486,    11,   645,   489,   491,
     124,   495,   497,   519,   522,   363,     9,   567,   524,   199,
     200,   509,   511,   131,   515,   517,   201,   363,   202,   203,
     587,   363,    49,   527,   529,   531,   533,   828,   537,   539,
      48,   369,   565,   829,   357,   830,   204,   831,   551,   553,
     555,   557,   123,   561,   563,   546,   548,   832,   568,   588,
     833,   571,   573,   575,   126,   579,   581,   603,   363,   363,
     636,   363,   363,   648,   591,   593,   595,   293,   599,   601,
     294,   295,   185,   186,   606,   608,   372,   893,   614,   616,
     296,   297,   298,   619,   383,   299,   300,   828,   625,   166,
     167,   168,   644,   630,   389,   225,   169,   396,   374,   134,
     909,   357,   188,   189,   366,   643,   226,   227,   679,   190,
     191,   192,   193,   194,   409,   148,   910,   170,   241,   406,
     418,   419,   658,   118,   376,   119,   366,   357,   366,   195,
     429,   432,   434,   139,   242,   243,   244,   439,   452,   245,
     246,   446,   449,   147,   366,   366,   422,   518,   455,   458,
     460,   657,   277,   278,   366,   157,   466,   469,   279,   564,
     280,   281,   282,   283,   378,   422,   366,   357,   602,   627,
     826,   284,   285,   286,   632,   366,   287,   288,   634,   289,
     635,   487,   264,   150,   265,   266,   267,   268,   327,   328,
     216,   733,   217,   218,   507,   269,   270,   271,   151,   380,
     272,   273,   357,   360,   362,   523,   525,   422,   844,   392,
     370,   366,   357,   477,   153,   375,   377,   379,   381,   845,
     547,   549,   135,   136,   846,   318,   319,   320,   154,   321,
     322,   323,   332,   333,   569,   393,   140,   141,   142,   143,
     144,   400,   402,   404,   156,   399,   401,   589,   357,   357,
     159,   411,   413,   415,   417,   208,   209,   210,   211,   212,
     337,   338,   403,   426,   428,   357,   410,   412,   165,   357,
     357,   304,   305,   414,   443,   445,   357,   306,   173,   416,
     307,   308,   357,   354,   355,   425,   815,   637,   357,   647,
     309,   310,   311,   174,   427,   312,   313,   357,   314,   435,
     437,   442,   422,   422,   357,   444,   450,   461,   357,   422,
     422,   463,   470,   488,   422,   422,   422,   490,   492,   493,
     422,   357,   841,   866,   867,   500,   502,   504,   506,   175,
     494,   496,   513,   422,   422,   499,   501,   503,   357,   357,
     357,   505,   508,   184,   357,   422,   535,   510,   512,   187,
     422,   357,   542,   544,   514,   516,   526,   422,   422,   422,
     528,   559,   530,   422,   532,   422,   534,   422,   536,   357,
     198,   422,   538,   577,   541,   422,   207,   357,   543,   584,
     586,   357,   550,   215,   552,   422,   597,   422,   554,   556,
     558,   422,   422,   357,   560,   610,   612,   422,   562,   570,
     572,   422,   422,   422,   574,   576,   578,   422,   357,   422,
     580,   583,   221,   422,   357,   827,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
     585,    46,   590,   357,   592,   422,   594,   422,   596,   422,
     598,   357,   600,   422,   862,   422,   222,   605,   607,   853,
     422,   422,   609,   611,   613,   357,   357,   422,   615,   232,
     618,   422,   852,   422,   620,   624,   626,   621,   422,   621,
     629,   631,   477,   422,   621,   861,   385,   649,   387,   649,
     363,   224,   390,   230,   673,   674,   889,   890,   842,   674,
     231,   234,   237,   235,   249,   263,   276,   292,   303,   317,
     326,   331,   336,   341,   342,   343,   345,   344,   363,   348,
     655,   349,   353,   387,   813,   385,   473,   390,   650,   394,
     422,   621,   652,   653,   651,   654,   656,   660,   661,   662,
     663,   664,   665,   666,   667,   669,   671,   672,   677,   678,
     680,   681,   682,   683,   684,   685,   686,   687,   688,   879,
     689,   864,   690,   691,   881,   692,   693,   697,   698,   699,
     700,   701,   702,   703,   863,   704,   705,   706,   707,   708,
     709,   710,   711,   712,   713,   714,   715,   716,   717,   718,
     719,   720,   721,   722,   874,   875,   723,   724,   727,   728,
     729,   734,   735,   736,   737,   880,   738,   739,   740,   741,
     742,   743,   744,   745,   746,   725,   747,   748,   749,   750,
     751,   752,   753,   754,   755,   756,   757,   758,   759,   760,
     761,   762,   763,   764,   765,   766,   767,   768,   769,   770,
     771,   772,   773,   774,   775,   776,   777,   778,   779,   780,
     781,   782,   783,   784,   785,   786,   787,   788,   789,   790,
     791,   792,   793,   794,   795,   796,   797,   798,   799,   800,
     801,   802,   803,   804,   817,   806,   807,   808,   805,   809,
     810,   811,   812,   838,   732,   384,   640,   477,   854,   498,
     814,   408,   421,   465,   818,   900,   847,   520,   604,   617,
     582,   623,   628,   540,     0,   856,   857,   858,   877,   872,
     873,   843,   897,   895,   896,   898,   899,   902,   903,   869,
     870,   908,   566,   633,     0,   848,     0,   849,   860,   894,
       0,     0,     0,     0,     0,   482,     0,   859,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   850,     0,
       0,     0,   871,     0,     0,     0,     0,     0,     0,   882,
     876,   883,   819,   820,   821,   822,   823,   824,   825,     0,
       0,     0,     0,     0,     0,   904,     0,     0,     0,     0,
     905,     0,     0,   906,     0,     0,     0,     0,     0,   352,
       0,     0,     0,     0,   901,     0,     0,     0,     0,     0,
     368,     0,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   398,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   441,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   472
};

#define yypact_value_is_default(yystate) \
  ((yystate) == (-632))

#define yytable_value_is_error(yytable_value) \
  YYID (0)

static const yytype_int16 yycheck[] =
{
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,   349,   131,   227,    76,   668,   349,   670,
       3,    81,    57,   169,    58,    59,    61,    57,    63,    54,
      65,    61,    67,    63,    69,    57,     4,    69,    54,    61,
     106,    54,    67,   103,   190,   162,    75,    76,    77,    78,
      79,    67,   118,   170,    67,   201,    75,    76,    77,    78,
      79,   127,   208,    63,   181,     0,    95,    96,    97,   104,
     216,   100,   101,    73,   103,    54,   106,    54,   195,   225,
      57,   185,   186,    82,   103,   118,   119,   204,    67,   193,
     194,   422,   238,   128,    93,   130,   130,    54,   133,   203,
      57,     5,   134,    54,   136,   106,    54,   211,   212,    54,
     227,   112,    57,   114,   218,   116,    67,    54,   264,    67,
       7,    54,   226,   227,    61,    75,    76,    77,   232,    79,
     131,   235,    54,   279,    67,   239,     6,   349,   242,   243,
      52,   245,   246,   260,    54,    67,     9,   293,    54,    76,
      77,   255,   256,   103,   258,   259,    83,    67,    85,    86,
     306,    67,    50,   267,   268,   269,   270,   106,   272,   273,
       8,    54,   289,   112,    57,   114,   103,   116,   282,   283,
     284,   285,    10,   287,   288,    54,    54,   126,    54,    54,
     129,   295,   296,   297,    45,   299,   300,   314,    67,    67,
     346,    67,    67,   349,   308,   309,   310,    82,   312,   313,
      85,    86,    88,    89,   318,   319,   136,   868,   322,   323,
      95,    96,    97,   327,   144,   100,   101,   106,   332,    75,
      76,    77,   349,   337,   154,    82,    82,    54,    54,    45,
     119,    57,    76,    77,    61,   349,    93,    94,   394,    83,
      84,    85,    86,    87,   174,    90,   907,   103,    79,    54,
     180,    54,   366,   136,    54,   138,    61,    57,    61,   103,
     190,   191,   192,    45,    95,    96,    97,    54,    54,   100,
     101,   201,   202,    45,    61,    61,    57,    54,   208,   209,
     210,    62,    76,    77,    61,    82,   216,   217,    82,    54,
      84,    85,    86,    87,    54,    57,    61,    57,    54,   333,
      62,    95,    96,    97,   338,    61,   100,   101,   342,   103,
     344,   241,    82,    45,    84,    85,    86,    87,   101,   102,
      83,   477,    85,    86,   254,    95,    96,    97,    80,    54,
     100,   101,    57,   128,   129,   265,   266,    57,   679,    54,
     135,    61,    57,    63,    45,   140,   141,   142,   143,   695,
     280,   281,    78,    79,   695,    95,    96,    97,    79,    99,
     100,   101,   101,   102,   294,   160,    75,    76,    77,    78,
      79,   166,   167,   168,    45,    54,    54,   307,    57,    57,
      45,   176,   177,   178,   179,    83,    84,    85,    86,    87,
     101,   102,    54,   188,   189,    57,    54,    54,    45,    57,
      57,    76,    77,    54,   199,   200,    57,    82,    45,    54,
      85,    86,    57,    51,    52,    54,   638,   347,    57,   349,
      95,    96,    97,    79,    54,   100,   101,    57,   103,    54,
      54,    54,    57,    57,    57,    54,    54,    54,    57,    57,
      57,    54,    54,    54,    57,    57,    57,    54,    54,   244,
      57,    57,   674,   830,   831,   250,   251,   252,   253,    45,
      54,    54,   257,    57,    57,    54,    54,    54,    57,    57,
      57,    54,    54,    45,    57,    57,   271,    54,    54,    45,
      57,    57,   277,   278,    54,    54,    54,    57,    57,    57,
      54,   286,    54,    57,    54,    57,    54,    57,    54,    57,
      45,    57,    54,   298,    54,    57,    45,    57,    54,   304,
     305,    57,    54,    45,    54,    57,   311,    57,    54,    54,
      54,    57,    57,    57,    54,   320,   321,    57,    54,    54,
      54,    57,    57,    57,    54,    54,    54,    57,    57,    57,
      54,    54,    45,    57,    57,   659,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      54,    46,    54,    57,    54,    57,    54,    57,    54,    57,
      54,    57,    54,    57,   816,    57,    91,    54,    54,   726,
      57,    57,    54,    54,    54,    57,    57,    57,    54,    92,
      54,    57,   726,    57,    54,    54,    54,    57,    57,    57,
      54,    54,    63,    57,    57,    66,   128,   350,   130,   352,
      67,    45,    69,    45,    70,    71,   866,   867,    70,    71,
      45,    45,    45,    92,    45,    45,    45,    45,    45,    45,
      45,    45,    45,    45,   102,    45,    45,   102,    67,    47,
      68,   132,    53,   130,   137,   128,   108,    69,    53,   104,
      57,    57,    54,    54,    58,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,   855,
      54,   828,    54,    54,   860,    54,    54,    54,    54,    54,
      54,    54,    54,    54,   828,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,   848,   849,    54,    54,    54,    54,
      54,    54,    54,    54,    54,   859,    54,    54,    54,    54,
      54,    54,    54,    54,    54,   110,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,   133,    54,    54,    54,    58,    54,
      54,    54,    54,   670,   477,   145,   349,    63,    48,   247,
     139,   171,   182,   213,   133,   878,    58,   261,   315,   324,
     301,   329,   334,   274,    -1,    64,    64,    64,    55,    60,
      60,   675,    54,    58,    58,    54,    56,    54,    54,    74,
      72,    49,   290,   339,    -1,    89,    -1,    88,    82,    72,
      -1,    -1,    -1,    -1,    -1,   228,    -1,    93,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,    -1,
      -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     109,   107,   133,   133,   133,   133,   133,   133,   133,    -1,
      -1,    -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,    -1,
     115,    -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,   122,
      -1,    -1,    -1,    -1,   135,    -1,    -1,    -1,    -1,    -1,
     132,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   163,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   219
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     3,   141,     4,     0,     5,   142,     7,   143,     9,
     144,     6,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    46,   145,     8,    50,
     162,   217,   165,   217,   168,   217,   174,   217,   176,   217,
     181,   217,   183,   217,   178,   217,   171,   217,   185,   217,
     186,   217,   189,   217,   190,   217,   193,   217,   196,   217,
     199,   217,   160,   217,   151,   217,   159,   217,   155,   217,
     157,   217,   149,   217,   217,   231,   217,   234,   217,   237,
     217,   240,   217,   243,   217,   246,   217,   249,   217,   252,
     217,   255,   217,   258,   217,   261,   217,   262,   136,   138,
     146,   222,   223,    10,    52,   218,    45,    75,    76,    77,
      79,   103,   163,   164,    45,    78,    79,   166,   167,    45,
      75,    76,    77,    78,    79,   169,   170,    45,    90,   175,
      45,    80,   177,    45,    79,   182,    45,    82,   184,    45,
      76,    81,   103,   179,   180,    45,    75,    76,    77,    82,
     103,   172,   173,    45,    79,    45,    75,    76,    77,    78,
      79,   103,   187,   188,    45,    88,    89,    45,    76,    77,
      83,    84,    85,    86,    87,   103,   191,   192,    45,    76,
      77,    83,    85,    86,   103,   194,   195,    45,    83,    84,
      85,    86,    87,   197,   198,    45,    83,    85,    86,   200,
     201,    45,    91,   161,    45,    82,    93,    94,   152,   153,
      45,    45,    92,   156,    45,    92,   158,    45,    82,    93,
     150,    79,    95,    96,    97,   100,   101,   232,   233,    45,
      75,    76,    77,    78,    79,    95,    96,    97,   100,   101,
     103,   235,   236,    45,    82,    84,    85,    86,    87,    95,
      96,    97,   100,   101,   238,   239,    45,    76,    77,    82,
      84,    85,    86,    87,    95,    96,    97,   100,   101,   103,
     241,   242,    45,    82,    85,    86,    95,    96,    97,   100,
     101,   244,   245,    45,    76,    77,    82,    85,    86,    95,
      96,    97,   100,   101,   103,   247,   248,    45,    95,    96,
      97,    99,   100,   101,   250,   251,    45,   101,   102,   253,
     254,    45,   101,   102,   256,   257,    45,   101,   102,   259,
     260,    45,   102,    45,   102,    45,   217,   217,    47,   132,
     147,   148,   147,    53,    51,    52,    54,    57,   230,    54,
     230,    54,   230,    67,   264,    54,    61,   225,   164,    54,
     230,    54,   264,   167,    54,   230,    54,   230,    54,   230,
      54,   230,    54,   264,   170,   128,   203,   130,   208,   264,
      69,   265,    54,   230,   104,   202,    54,   225,   180,    54,
     230,    54,   230,    54,   230,   265,    54,   225,   173,   264,
      54,   230,    54,   230,    54,   230,    54,   230,   264,    54,
     225,   188,    57,   224,   224,    54,   230,    54,   230,   264,
     265,    54,   264,    54,   264,    54,   224,    54,   224,    54,
     225,   192,    54,   230,    54,   230,   264,   265,    54,   264,
      54,   224,    54,   225,   195,   264,   265,    54,   264,    54,
     264,    54,   224,    54,   224,   198,   264,   265,    54,   264,
      54,   224,   201,   108,   210,   265,   224,    63,   154,   224,
     225,   227,   153,   224,   224,   265,   224,   264,    54,   224,
      54,   224,    54,   230,    54,   224,    54,   224,   233,    54,
     230,    54,   230,    54,   230,    54,   230,   264,    54,   224,
      54,   224,    54,   230,    54,   224,    54,   224,    54,   225,
     236,   265,    54,   264,    54,   264,    54,   224,    54,   224,
      54,   224,    54,   224,    54,   230,    54,   224,    54,   224,
     239,    54,   230,    54,   230,   265,    54,   264,    54,   264,
      54,   224,    54,   224,    54,   224,    54,   224,    54,   230,
      54,   224,    54,   224,    54,   225,   242,   265,    54,   264,
      54,   224,    54,   224,    54,   224,    54,   230,    54,   224,
      54,   224,   245,    54,   230,    54,   230,   265,    54,   264,
      54,   224,    54,   224,    54,   224,    54,   230,    54,   224,
      54,   224,    54,   225,   248,    54,   224,    54,   224,    54,
     230,    54,   230,    54,   224,    54,   224,   251,    54,   224,
      54,    57,   263,   254,    54,   224,    54,   263,   257,    54,
     224,    54,   263,   260,   263,   263,   265,   264,    65,   133,
     202,   203,   208,   224,   225,   227,   228,   264,   265,   148,
      53,    58,    54,    54,    54,    68,    54,    62,   224,   226,
      54,    54,    54,    54,    54,    54,    54,    54,   204,    54,
     209,    54,    54,    70,    71,   266,   267,    54,    54,   265,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    58,    59,   208,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,   110,   212,    54,    54,    54,
     134,   221,   222,   265,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    58,    54,    54,    54,    54,
      54,    54,    54,   137,   139,   227,   229,   133,   133,   133,
     133,   133,   133,   133,   133,   133,    62,   224,   106,   112,
     114,   116,   126,   129,   205,   213,   216,   131,   213,   216,
      73,   227,    70,   267,   208,   203,   208,    58,    89,    88,
     111,   211,   224,   225,    48,   219,    64,    64,    64,    93,
      82,    66,   227,   224,   225,   214,   214,   214,   206,    74,
      72,   105,    60,    60,   224,   224,   109,    55,   220,   265,
     224,   265,   107,   107,   215,   216,   224,   225,   227,   215,
     215,   118,   127,   216,    72,    58,    58,    54,    54,    56,
     217,   135,    54,    54,   113,   115,   117,   207,    49,   119,
     216
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (parm, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* This macro is provided for backward compatibility. */

#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, parm); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, void* parm)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, parm)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    void* parm;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (parm);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, void* parm)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, parm)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    void* parm;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep, parm);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule, void* parm)
#else
static void
yy_reduce_print (yyvsp, yyrule, parm)
    YYSTYPE *yyvsp;
    int yyrule;
    void* parm;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       , parm);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule, parm); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (0, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  YYSIZE_T yysize1;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = 0;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                yysize1 = yysize + yytnamerr (0, yytname[yyx]);
                if (! (yysize <= yysize1
                       && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                  return 2;
                yysize = yysize1;
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  yysize1 = yysize + yystrlen (yyformat);
  if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
    return 2;
  yysize = yysize1;

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, void* parm)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, parm)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    void* parm;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (parm);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void* parm);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void* parm)
#else
int
yyparse (parm)
    void* parm;
#endif
#endif
{
/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1806 of yacc.c  */
#line 2327 "cimXmlOps.y"
    {
    }
    break;

  case 3:

/* Line 1806 of yacc.c  */
#line 2333 "cimXmlOps.y"
    {
    }
    break;

  case 4:

/* Line 1806 of yacc.c  */
#line 2339 "cimXmlOps.y"
    {
    }
    break;

  case 5:

/* Line 1806 of yacc.c  */
#line 2345 "cimXmlOps.y"
    {
    }
    break;

  case 6:

/* Line 1806 of yacc.c  */
#line 2351 "cimXmlOps.y"
    {
    }
    break;

  case 7:

/* Line 1806 of yacc.c  */
#line 2354 "cimXmlOps.y"
    {
    }
    break;

  case 8:

/* Line 1806 of yacc.c  */
#line 2357 "cimXmlOps.y"
    {
    }
    break;

  case 9:

/* Line 1806 of yacc.c  */
#line 2360 "cimXmlOps.y"
    {
    }
    break;

  case 10:

/* Line 1806 of yacc.c  */
#line 2363 "cimXmlOps.y"
    {
    }
    break;

  case 11:

/* Line 1806 of yacc.c  */
#line 2366 "cimXmlOps.y"
    {
    }
    break;

  case 12:

/* Line 1806 of yacc.c  */
#line 2369 "cimXmlOps.y"
    {
    }
    break;

  case 13:

/* Line 1806 of yacc.c  */
#line 2372 "cimXmlOps.y"
    {
    }
    break;

  case 14:

/* Line 1806 of yacc.c  */
#line 2375 "cimXmlOps.y"
    {
    }
    break;

  case 15:

/* Line 1806 of yacc.c  */
#line 2378 "cimXmlOps.y"
    {
    }
    break;

  case 16:

/* Line 1806 of yacc.c  */
#line 2381 "cimXmlOps.y"
    {
    }
    break;

  case 17:

/* Line 1806 of yacc.c  */
#line 2384 "cimXmlOps.y"
    {
    }
    break;

  case 18:

/* Line 1806 of yacc.c  */
#line 2387 "cimXmlOps.y"
    {
    }
    break;

  case 19:

/* Line 1806 of yacc.c  */
#line 2390 "cimXmlOps.y"
    {
    }
    break;

  case 20:

/* Line 1806 of yacc.c  */
#line 2393 "cimXmlOps.y"
    {
    }
    break;

  case 21:

/* Line 1806 of yacc.c  */
#line 2396 "cimXmlOps.y"
    {
    }
    break;

  case 22:

/* Line 1806 of yacc.c  */
#line 2399 "cimXmlOps.y"
    {
    }
    break;

  case 23:

/* Line 1806 of yacc.c  */
#line 2402 "cimXmlOps.y"
    {
    }
    break;

  case 24:

/* Line 1806 of yacc.c  */
#line 2405 "cimXmlOps.y"
    {
    }
    break;

  case 25:

/* Line 1806 of yacc.c  */
#line 2408 "cimXmlOps.y"
    {
    }
    break;

  case 26:

/* Line 1806 of yacc.c  */
#line 2411 "cimXmlOps.y"
    {
    }
    break;

  case 27:

/* Line 1806 of yacc.c  */
#line 2414 "cimXmlOps.y"
    {
    }
    break;

  case 28:

/* Line 1806 of yacc.c  */
#line 2417 "cimXmlOps.y"
    {
    }
    break;

  case 29:

/* Line 1806 of yacc.c  */
#line 2420 "cimXmlOps.y"
    {
    }
    break;

  case 30:

/* Line 1806 of yacc.c  */
#line 2423 "cimXmlOps.y"
    {
    }
    break;

  case 31:

/* Line 1806 of yacc.c  */
#line 2426 "cimXmlOps.y"
    {
    }
    break;

  case 32:

/* Line 1806 of yacc.c  */
#line 2429 "cimXmlOps.y"
    {
    }
    break;

  case 33:

/* Line 1806 of yacc.c  */
#line 2432 "cimXmlOps.y"
    {
    }
    break;

  case 34:

/* Line 1806 of yacc.c  */
#line 2435 "cimXmlOps.y"
    {
    }
    break;

  case 35:

/* Line 1806 of yacc.c  */
#line 2438 "cimXmlOps.y"
    {
    }
    break;

  case 36:

/* Line 1806 of yacc.c  */
#line 2441 "cimXmlOps.y"
    {
    }
    break;

  case 37:

/* Line 1806 of yacc.c  */
#line 2444 "cimXmlOps.y"
    {
    }
    break;

  case 38:

/* Line 1806 of yacc.c  */
#line 2447 "cimXmlOps.y"
    {
    }
    break;

  case 39:

/* Line 1806 of yacc.c  */
#line 2450 "cimXmlOps.y"
    {
    }
    break;

  case 40:

/* Line 1806 of yacc.c  */
#line 2453 "cimXmlOps.y"
    {
    }
    break;

  case 41:

/* Line 1806 of yacc.c  */
#line 2464 "cimXmlOps.y"
    {
       (yyval.xtokMethodCall).op.count = IM_REQ_REG_SEGMENTS;
       (yyval.xtokMethodCall).op.type = OPS_InvokeMethod;
       (yyval.xtokMethodCall).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalClassPath).path);
       (yyval.xtokMethodCall).op.className=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalClassPath).className);
       (yyval.xtokMethodCall).instName=0;
       (yyval.xtokMethodCall).paramValues.first=NULL;
       (yyval.xtokMethodCall).paramValues.last=NULL;
       
       setRequest(parm,&(yyval.xtokMethodCall),sizeof(XtokMethodCall),OPS_InvokeMethod);
       buildInvokeMethodRequest(parm);
    }
    break;

  case 42:

/* Line 1806 of yacc.c  */
#line 2477 "cimXmlOps.y"
    {
       (yyval.xtokMethodCall).op.count = IM_REQ_REG_SEGMENTS;
       (yyval.xtokMethodCall).op.type = OPS_InvokeMethod;
       (yyval.xtokMethodCall).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalClassPath).path);
       (yyval.xtokMethodCall).op.className=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalClassPath).className);
       (yyval.xtokMethodCall).instName=0;
       (yyval.xtokMethodCall).paramValues=(yyvsp[(2) - (2)].xtokParamValues);
       
       setRequest(parm,&(yyval.xtokMethodCall),sizeof(XtokMethodCall),OPS_InvokeMethod);
       buildInvokeMethodRequest(parm);
    }
    break;

  case 43:

/* Line 1806 of yacc.c  */
#line 2489 "cimXmlOps.y"
    {
       (yyval.xtokMethodCall).op.count = IM_REQ_REG_SEGMENTS;
       (yyval.xtokMethodCall).op.type = OPS_InvokeMethod;
       (yyval.xtokMethodCall).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalInstancePath).path);
       (yyval.xtokMethodCall).op.className=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalInstancePath).instanceName.className);
       (yyval.xtokMethodCall).instanceName=(yyvsp[(1) - (1)].xtokLocalInstancePath).instanceName;
       (yyval.xtokMethodCall).instName=1;
       (yyval.xtokMethodCall).paramValues.first=NULL;
       (yyval.xtokMethodCall).paramValues.last=NULL;
       
       setRequest(parm,&(yyval.xtokMethodCall),sizeof(XtokMethodCall),OPS_InvokeMethod);
       buildInvokeMethodRequest(parm);
    }
    break;

  case 44:

/* Line 1806 of yacc.c  */
#line 2503 "cimXmlOps.y"
    {
       (yyval.xtokMethodCall).op.count = IM_REQ_REG_SEGMENTS;
       (yyval.xtokMethodCall).op.type = OPS_InvokeMethod;
       (yyval.xtokMethodCall).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalInstancePath).path);
       (yyval.xtokMethodCall).op.className=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalInstancePath).instanceName.className);
       (yyval.xtokMethodCall).instanceName=(yyvsp[(1) - (2)].xtokLocalInstancePath).instanceName;
       (yyval.xtokMethodCall).instName=1;
       (yyval.xtokMethodCall).paramValues=(yyvsp[(2) - (2)].xtokParamValues);
              
       setRequest(parm,&(yyval.xtokMethodCall),sizeof(XtokMethodCall),OPS_InvokeMethod);
       buildInvokeMethodRequest(parm);
    }
    break;

  case 45:

/* Line 1806 of yacc.c  */
#line 2519 "cimXmlOps.y"
    {
      (yyval.xtokParamValues).first = NULL;
      (yyval.xtokParamValues).last = NULL;
      addParamValue(&(yyval.xtokParamValues),&(yyvsp[(1) - (1)].xtokParamValue));
    }
    break;

  case 46:

/* Line 1806 of yacc.c  */
#line 2525 "cimXmlOps.y"
    {
      addParamValue(&(yyval.xtokParamValues),&(yyvsp[(2) - (2)].xtokParamValue));
    }
    break;

  case 47:

/* Line 1806 of yacc.c  */
#line 2532 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).value.value=NULL;
       (yyval.xtokParamValue).type=0;
    }
    break;

  case 48:

/* Line 1806 of yacc.c  */
#line 2537 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).value=(yyvsp[(2) - (3)].xtokValue);
       if((yyval.xtokParamValue).value.type == typeValue_Instance) {
          (yyval.xtokParamValue).type = CMPI_instance;
       } else 
       if((yyval.xtokParamValue).value.type == typeValue_Class) {
          (yyval.xtokParamValue).type = CMPI_class;
       }
    }
    break;

  case 49:

/* Line 1806 of yacc.c  */
#line 2547 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).valueArray=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokParamValue).type|=CMPI_ARRAY;
       
       if((yyval.xtokParamValue).valueArray.values) {
          if((yyval.xtokParamValue).valueArray.values[0].type == typeValue_Instance)
          	(yyval.xtokParamValue).type = CMPI_instance | CMPI_ARRAY;
          else if((yyval.xtokParamValue).valueArray.values[0].type == typeValue_Class)
          	(yyval.xtokParamValue).type = CMPI_class | CMPI_ARRAY;          	
       }
    }
    break;

  case 50:

/* Line 1806 of yacc.c  */
#line 2559 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).valueRef=(yyvsp[(2) - (3)].xtokValueReference);
       (yyval.xtokParamValue).type=CMPI_ref;
    }
    break;

  case 51:

/* Line 1806 of yacc.c  */
#line 2564 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).valueRefArray=(yyvsp[(2) - (3)].xtokValueRefArray);
       (yyval.xtokParamValue).type=CMPI_ARRAY | CMPI_ref;
    }
    break;

  case 52:

/* Line 1806 of yacc.c  */
#line 2570 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).className=(yyvsp[(2) - (3)].className);
       if (!(yyval.xtokParamValue).type) (yyval.xtokParamValue).type=CMPI_class;  /* should this be CMPI_string? */
    }
    break;

  case 53:

/* Line 1806 of yacc.c  */
#line 2575 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).instanceName=(yyvsp[(2) - (3)].xtokInstanceName);
       if (!(yyval.xtokParamValue).type) (yyval.xtokParamValue).type=CMPI_instance;
    }
    break;

  case 54:

/* Line 1806 of yacc.c  */
#line 2580 "cimXmlOps.y"
    {
       //$$.class=$2;
       if (!(yyval.xtokParamValue).type) (yyval.xtokParamValue).type=CMPI_class;
    }
    break;

  case 55:

/* Line 1806 of yacc.c  */
#line 2585 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).instance=(yyvsp[(2) - (3)].xtokInstance);
       if (!(yyval.xtokParamValue).type) (yyval.xtokParamValue).type=CMPI_instance;
    }
    break;

  case 56:

/* Line 1806 of yacc.c  */
#line 2590 "cimXmlOps.y"
    {
       (yyval.xtokParamValue).namedInstance=(yyvsp[(2) - (3)].xtokNamedInstance);
       /* should we ignore paramtype from the XML and always set to CMPI_instance? */
       if (!(yyval.xtokParamValue).type) (yyval.xtokParamValue).type=CMPI_instance;
    }
    break;

  case 57:

/* Line 1806 of yacc.c  */
#line 2602 "cimXmlOps.y"
    {
       (yyval.xtokGetProperty).op.count = 3;
       (yyval.xtokGetProperty).op.type = OPS_GetProperty;
       (yyval.xtokGetProperty).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokGetProperty).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokGetPropertyParm).instanceName.className);
       (yyval.xtokGetProperty).name = (yyvsp[(2) - (2)].xtokGetPropertyParm).name;
       (yyval.xtokGetProperty).instanceName = (yyvsp[(2) - (2)].xtokGetPropertyParm).instanceName;
       setRequest(parm,&(yyval.xtokGetProperty),sizeof(XtokGetProperty),OPS_GetProperty);
       buildGetPropertyRequest(parm);
	}
    break;

  case 58:

/* Line 1806 of yacc.c  */
#line 2616 "cimXmlOps.y"
    {
		(yyval.xtokGetPropertyParm).name = (yyvsp[(2) - (6)].xtokValue).value;
		(yyval.xtokGetPropertyParm).instanceName = (yyvsp[(5) - (6)].xtokInstanceName);
	}
    break;

  case 59:

/* Line 1806 of yacc.c  */
#line 2621 "cimXmlOps.y"
    {
		(yyval.xtokGetPropertyParm).name = (yyvsp[(5) - (6)].xtokValue).value;
		(yyval.xtokGetPropertyParm).instanceName = (yyvsp[(2) - (6)].xtokInstanceName);
	}
    break;

  case 60:

/* Line 1806 of yacc.c  */
#line 2633 "cimXmlOps.y"
    {
       (yyval.xtokSetProperty).op.count = 3;
       (yyval.xtokSetProperty).op.type = OPS_SetProperty;
       (yyval.xtokSetProperty).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokSetProperty).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokSetProperty).propertyName = NULL;

       setRequest(parm,&(yyval.xtokSetProperty),sizeof(XtokSetProperty),OPS_SetProperty);
       buildSetPropertyRequest(parm);
	}
    break;

  case 61:

/* Line 1806 of yacc.c  */
#line 2644 "cimXmlOps.y"
    {
       (yyval.xtokSetProperty).op.count = 3;
       (yyval.xtokSetProperty).op.type = OPS_SetProperty;
       (yyval.xtokSetProperty).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokSetProperty).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokSetPropertyParmsList).instanceName.className);
       (yyval.xtokSetProperty).newVal = (yyvsp[(2) - (2)].xtokSetPropertyParmsList).newVal;
       (yyval.xtokSetProperty).instanceName = (yyvsp[(2) - (2)].xtokSetPropertyParmsList).instanceName;
       (yyval.xtokSetProperty).propertyName = (yyvsp[(2) - (2)].xtokSetPropertyParmsList).propertyName;
       
       setRequest(parm,&(yyval.xtokSetProperty),sizeof(XtokSetProperty),OPS_SetProperty);
       buildSetPropertyRequest(parm);
	}
    break;

  case 62:

/* Line 1806 of yacc.c  */
#line 2660 "cimXmlOps.y"
    {
       (yyval.xtokSetPropertyParmsList).newVal = (yyvsp[(1) - (1)].xtokSetPropertyParms).newVal;
       (yyval.xtokSetPropertyParmsList).instanceName = (yyvsp[(1) - (1)].xtokSetPropertyParms).instanceName;
       (yyval.xtokSetPropertyParmsList).propertyName = (yyvsp[(1) - (1)].xtokSetPropertyParms).propertyName;
	}
    break;

  case 63:

/* Line 1806 of yacc.c  */
#line 2666 "cimXmlOps.y"
    {
		if((yyvsp[(2) - (2)].xtokSetPropertyParms).propertyName) {
			(yyval.xtokSetPropertyParmsList).propertyName = (yyvsp[(2) - (2)].xtokSetPropertyParms).propertyName;
		}
		else if((yyvsp[(2) - (2)].xtokSetPropertyParms).instanceName.className) {
			(yyval.xtokSetPropertyParmsList).instanceName = (yyvsp[(2) - (2)].xtokSetPropertyParms).instanceName;
		}
		else {
			(yyval.xtokSetPropertyParmsList).newVal = (yyvsp[(2) - (2)].xtokSetPropertyParms).newVal;
		}
	}
    break;

  case 64:

/* Line 1806 of yacc.c  */
#line 2681 "cimXmlOps.y"
    {
		(yyval.xtokSetPropertyParms).instanceName = (yyvsp[(2) - (3)].xtokInstanceName);
		(yyval.xtokSetPropertyParms).propertyName = NULL;
		(yyval.xtokSetPropertyParms).newVal.type = 0;
		(yyval.xtokSetPropertyParms).newVal.val.value = NULL;
	}
    break;

  case 65:

/* Line 1806 of yacc.c  */
#line 2688 "cimXmlOps.y"
    {
		(yyval.xtokSetPropertyParms).propertyName = (yyvsp[(2) - (3)].xtokValue).value;
		(yyval.xtokSetPropertyParms).instanceName.className = NULL;
		(yyval.xtokSetPropertyParms).newVal.type = 0;
		(yyval.xtokSetPropertyParms).newVal.val.value = NULL;
	}
    break;

  case 66:

/* Line 1806 of yacc.c  */
#line 2695 "cimXmlOps.y"
    {
		(yyval.xtokSetPropertyParms).newVal = (yyvsp[(2) - (3)].xtokNewValue);
		(yyval.xtokSetPropertyParms).propertyName = NULL;
		(yyval.xtokSetPropertyParms).instanceName.className = NULL;
	}
    break;

  case 67:

/* Line 1806 of yacc.c  */
#line 2704 "cimXmlOps.y"
    {
		if((yyvsp[(1) - (1)].xtokValue).type == typeValue_Instance) {
			(yyval.xtokNewValue).type = CMPI_instance;
		}
		else if((yyvsp[(1) - (1)].xtokValue).type == typeValue_Class) {
			(yyval.xtokNewValue).type = CMPI_class;
		}
		else {
			(yyval.xtokNewValue).type = 0;
		}
		(yyval.xtokNewValue).val = (yyvsp[(1) - (1)].xtokValue);
	}
    break;

  case 68:

/* Line 1806 of yacc.c  */
#line 2717 "cimXmlOps.y"
    {
		(yyval.xtokNewValue).arr = (yyvsp[(1) - (1)].xtokValueArray);
		(yyval.xtokNewValue).type = CMPI_ARRAY;
	}
    break;

  case 69:

/* Line 1806 of yacc.c  */
#line 2722 "cimXmlOps.y"
    {
		(yyval.xtokNewValue).ref = (yyvsp[(1) - (1)].xtokValueReference);
		(yyval.xtokNewValue).type = CMPI_ref;
	}
    break;

  case 70:

/* Line 1806 of yacc.c  */
#line 2733 "cimXmlOps.y"
    {
       (yyval.xtokGetQualifier).op.count = 2;
       (yyval.xtokGetQualifier).op.type = OPS_GetQualifier;
       (yyval.xtokGetQualifier).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokGetQualifier).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokGetQualifier).name = (yyvsp[(2) - (2)].xtokGetQualifierParm).name;
       setRequest(parm,&(yyval.xtokGetQualifier),sizeof(XtokGetQualifier),OPS_GetQualifier);
       buildGetQualifierRequest(parm);
    }
    break;

  case 71:

/* Line 1806 of yacc.c  */
#line 2746 "cimXmlOps.y"
    {
       (yyval.xtokGetQualifierParm).name = (yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 72:

/* Line 1806 of yacc.c  */
#line 2756 "cimXmlOps.y"
    {
       (yyval.xtokDeleteQualifier).op.count = 2;
       (yyval.xtokDeleteQualifier).op.type = OPS_DeleteQualifier;
       (yyval.xtokDeleteQualifier).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokDeleteQualifier).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokDeleteQualifier).name = (yyvsp[(2) - (2)].xtokDeleteQualifierParm).name;
       setRequest(parm,&(yyval.xtokDeleteQualifier),sizeof(XtokDeleteQualifier),OPS_DeleteQualifier);
       buildDeleteQualifierRequest(parm);
    }
    break;

  case 73:

/* Line 1806 of yacc.c  */
#line 2769 "cimXmlOps.y"
    {
       (yyval.xtokDeleteQualifierParm).name = (yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 74:

/* Line 1806 of yacc.c  */
#line 2779 "cimXmlOps.y"
    {
       (yyval.xtokEnumQualifiers).op.count = 2;
       (yyval.xtokEnumQualifiers).op.type = OPS_EnumerateQualifiers;
       (yyval.xtokEnumQualifiers).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokEnumQualifiers).op.className=setCharsMsgSegment(NULL);
       setRequest(parm,&(yyval.xtokEnumQualifiers),sizeof(XtokEnumQualifiers),OPS_EnumerateQualifiers);
       buildEnumQualifiersRequest(parm);
    }
    break;

  case 75:

/* Line 1806 of yacc.c  */
#line 2795 "cimXmlOps.y"
    {
       (yyval.xtokSetQualifier).op.count = 3;
       (yyval.xtokSetQualifier).op.type = OPS_SetQualifier;
       (yyval.xtokSetQualifier).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokSetQualifier).op.className=setCharsMsgSegment(NULL);       
       (yyval.xtokSetQualifier).qualifierdeclaration = (yyvsp[(2) - (2)].xtokSetQualifierParm).qualifierdeclaration;

       setRequest(parm,&(yyval.xtokSetQualifier),sizeof(XtokSetQualifier),OPS_SetQualifier);
       buildSetQualifierRequest(parm);
    }
    break;

  case 76:

/* Line 1806 of yacc.c  */
#line 2810 "cimXmlOps.y"
    {
       (yyval.xtokSetQualifierParm).qualifierdeclaration = (yyvsp[(2) - (3)].xtokQualifierDeclaration);
    }
    break;

  case 77:

/* Line 1806 of yacc.c  */
#line 2821 "cimXmlOps.y"
    {
       (yyval.xtokGetClass).op.count = GC_REQ_REG_SEGMENTS;
       (yyval.xtokGetClass).op.type = OPS_GetClass;
       (yyval.xtokGetClass).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokGetClass).op.className=setCharsMsgSegment(NULL);
//     $$.flags = FL_localOnly;
       (yyval.xtokGetClass).flags = FL_localOnly|FL_includeQualifiers;
       (yyval.xtokGetClass).propertyList.values = NULL;
       (yyval.xtokGetClass).properties=0;

       setRequest(parm,&(yyval.xtokGetClass),sizeof(XtokGetClass),OPS_GetClass);
       buildGetClassRequest(parm);
    }
    break;

  case 78:

/* Line 1806 of yacc.c  */
#line 2835 "cimXmlOps.y"
    {
       (yyval.xtokGetClass).op.count = GC_REQ_REG_SEGMENTS;
       (yyval.xtokGetClass).op.type = OPS_GetClass;
       (yyval.xtokGetClass).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokGetClass).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokGetClassParmsList).className);
//     $$.flags = ($2.flags &  $2.flagsSet) | ((~$2.flagsSet) & (FL_localOnly));
       (yyval.xtokGetClass).flags = ((yyvsp[(2) - (2)].xtokGetClassParmsList).flags &  (yyvsp[(2) - (2)].xtokGetClassParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokGetClassParmsList).flagsSet) & (FL_localOnly|FL_includeQualifiers));
       (yyval.xtokGetClass).propertyList = (yyvsp[(2) - (2)].xtokGetClassParmsList).propertyList;
       (yyval.xtokGetClass).properties=(yyvsp[(2) - (2)].xtokGetClassParmsList).properties;

       setRequest(parm,&(yyval.xtokGetClass),sizeof(XtokGetClass),OPS_GetClass);
       buildGetClassRequest(parm);
    }
    break;

  case 79:

/* Line 1806 of yacc.c  */
#line 2852 "cimXmlOps.y"
    {
       (yyval.xtokGetClassParmsList).flags=(yyvsp[(1) - (1)].xtokGetClassParms).flags;
       (yyval.xtokGetClassParmsList).flagsSet=(yyvsp[(1) - (1)].xtokGetClassParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokGetClassParms).clsNameSet) (yyval.xtokGetClassParmsList).className=(yyvsp[(1) - (1)].xtokGetClassParms).className;
       (yyval.xtokGetClassParmsList).clsNameSet = (yyvsp[(1) - (1)].xtokGetClassParms).clsNameSet;
       if ((yyvsp[(1) - (1)].xtokGetClassParms).propertyList.values) {
          (yyval.xtokGetClassParmsList).propertyList=(yyvsp[(1) - (1)].xtokGetClassParms).propertyList;
          (yyval.xtokGetClassParmsList).properties=(yyvsp[(1) - (1)].xtokGetClassParms).properties;
       }
    }
    break;

  case 80:

/* Line 1806 of yacc.c  */
#line 2863 "cimXmlOps.y"
    {
       (yyval.xtokGetClassParmsList).flags=(yyvsp[(1) - (2)].xtokGetClassParmsList).flags|(yyvsp[(2) - (2)].xtokGetClassParms).flags;
       (yyval.xtokGetClassParmsList).flagsSet=(yyvsp[(1) - (2)].xtokGetClassParmsList).flagsSet|(yyvsp[(2) - (2)].xtokGetClassParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokGetClassParms).clsNameSet) (yyval.xtokGetClassParmsList).className=(yyvsp[(2) - (2)].xtokGetClassParms).className;
       (yyval.xtokGetClassParmsList).clsNameSet |= (yyvsp[(2) - (2)].xtokGetClassParms).clsNameSet;
       if ((yyvsp[(2) - (2)].xtokGetClassParms).propertyList.values) {
          (yyval.xtokGetClassParmsList).propertyList=(yyvsp[(2) - (2)].xtokGetClassParms).propertyList;
          (yyval.xtokGetClassParmsList).properties=(yyvsp[(2) - (2)].xtokGetClassParms).properties;
       }
    }
    break;

  case 81:

/* Line 1806 of yacc.c  */
#line 2877 "cimXmlOps.y"
    {
       (yyval.xtokGetClassParms).className = (yyvsp[(2) - (3)].className);
       (yyval.xtokGetClassParms).flags = (yyval.xtokGetClassParms).flagsSet = 0 ;
       (yyval.xtokGetClassParms).clsNameSet = 1;
       (yyval.xtokGetClassParms).propertyList.values=0;
       (yyval.xtokGetClassParms).properties=0;
    }
    break;

  case 82:

/* Line 1806 of yacc.c  */
#line 2885 "cimXmlOps.y"
    {
       (yyval.xtokGetClassParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_localOnly : 0 ;
       (yyval.xtokGetClassParms).flagsSet = FL_localOnly;
       (yyval.xtokGetClassParms).properties=(yyval.xtokGetClassParms).clsNameSet=0;
       (yyval.xtokGetClassParms).propertyList.values=0;
    }
    break;

  case 83:

/* Line 1806 of yacc.c  */
#line 2892 "cimXmlOps.y"
    {
       memset(&(yyval.xtokGetClassParms), 0, sizeof((yyval.xtokGetClassParms)));
    }
    break;

  case 84:

/* Line 1806 of yacc.c  */
#line 2896 "cimXmlOps.y"
    {
       (yyval.xtokGetClassParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokGetClassParms).flagsSet = FL_includeQualifiers;
       (yyval.xtokGetClassParms).properties=(yyval.xtokGetClassParms).clsNameSet=0;
       (yyval.xtokGetClassParms).propertyList.values=0;
    }
    break;

  case 85:

/* Line 1806 of yacc.c  */
#line 2903 "cimXmlOps.y"
    {
       memset(&(yyval.xtokGetClassParms), 0, sizeof((yyval.xtokGetClassParms)));
    }
    break;

  case 86:

/* Line 1806 of yacc.c  */
#line 2907 "cimXmlOps.y"
    {
       (yyval.xtokGetClassParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokGetClassParms).flagsSet = FL_includeClassOrigin;
       (yyval.xtokGetClassParms).properties=(yyval.xtokGetClassParms).clsNameSet=0;
       (yyval.xtokGetClassParms).propertyList.values=0;
    }
    break;

  case 87:

/* Line 1806 of yacc.c  */
#line 2914 "cimXmlOps.y"
    {
       memset(&(yyval.xtokGetClassParms), 0, sizeof((yyval.xtokGetClassParms)));
    }
    break;

  case 88:

/* Line 1806 of yacc.c  */
#line 2918 "cimXmlOps.y"
    {
       (yyval.xtokGetClassParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokGetClassParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
       (yyval.xtokGetClassParms).clsNameSet=0;
       (yyval.xtokGetClassParms).flags = (yyval.xtokGetClassParms).flagsSet = 0 ;
    }
    break;

  case 89:

/* Line 1806 of yacc.c  */
#line 2925 "cimXmlOps.y"
    {
       memset(&(yyval.xtokGetClassParms), 0, sizeof((yyval.xtokGetClassParms)));
    }
    break;

  case 90:

/* Line 1806 of yacc.c  */
#line 2937 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassNames).op.count = ECN_REQ_REG_SEGMENTS;
       (yyval.xtokEnumClassNames).op.type = OPS_EnumerateClassNames;
       (yyval.xtokEnumClassNames).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokEnumClassNames).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokEnumClassNames).flags = 0;

       setRequest(parm,&(yyval.xtokEnumClassNames),sizeof(XtokEnumClassNames),OPS_EnumerateClassNames);
       buildEnumClassNamesRequest(parm);
    }
    break;

  case 91:

/* Line 1806 of yacc.c  */
#line 2948 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassNames).op.count = ECN_REQ_REG_SEGMENTS;
       (yyval.xtokEnumClassNames).op.type = OPS_EnumerateClassNames;
       (yyval.xtokEnumClassNames).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokEnumClassNames).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokEnumClassNamesParmsList).className);
       (yyval.xtokEnumClassNames).flags = (yyvsp[(2) - (2)].xtokEnumClassNamesParmsList).flags;

       setRequest(parm,&(yyval.xtokEnumClassNames),sizeof(XtokEnumClassNames),OPS_EnumerateClassNames);
       buildEnumClassNamesRequest(parm);
    }
    break;

  case 92:

/* Line 1806 of yacc.c  */
#line 2962 "cimXmlOps.y"
    {
       if ((yyvsp[(1) - (1)].xtokEnumClassNamesParms).className) (yyval.xtokEnumClassNamesParmsList).className=(yyvsp[(1) - (1)].xtokEnumClassNamesParms).className;
       (yyval.xtokEnumClassNamesParmsList).flags=(yyvsp[(1) - (1)].xtokEnumClassNamesParms).flags;
    }
    break;

  case 93:

/* Line 1806 of yacc.c  */
#line 2967 "cimXmlOps.y"
    {
       if ((yyvsp[(2) - (2)].xtokEnumClassNamesParms).className) (yyval.xtokEnumClassNamesParmsList).className=(yyvsp[(2) - (2)].xtokEnumClassNamesParms).className;
       (yyval.xtokEnumClassNamesParmsList).flags = ((yyvsp[(2) - (2)].xtokEnumClassNamesParms).flags & (yyvsp[(2) - (2)].xtokEnumClassNamesParms).flagsSet) | ((~(yyvsp[(2) - (2)].xtokEnumClassNamesParms).flagsSet) & FL_deepInheritance);
    }
    break;

  case 94:

/* Line 1806 of yacc.c  */
#line 2975 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassNamesParms).className = NULL;
       (yyval.xtokEnumClassNamesParms).flags = (yyval.xtokEnumClassNamesParms).flagsSet = 0 ;
    }
    break;

  case 95:

/* Line 1806 of yacc.c  */
#line 2980 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassNamesParms).className = (yyvsp[(2) - (3)].className);
       (yyval.xtokEnumClassNamesParms).flags = (yyval.xtokEnumClassNamesParms).flagsSet = 0 ;
    }
    break;

  case 96:

/* Line 1806 of yacc.c  */
#line 2985 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassNamesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_deepInheritance : 0 ;
       (yyval.xtokEnumClassNamesParms).flagsSet = FL_deepInheritance;
       (yyval.xtokEnumClassNamesParms).className=0;
    }
    break;

  case 97:

/* Line 1806 of yacc.c  */
#line 2991 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassNamesParms).className = NULL;
       (yyval.xtokEnumClassNamesParms).flags = (yyval.xtokEnumClassNamesParms).flagsSet = 0 ;
    }
    break;

  case 98:

/* Line 1806 of yacc.c  */
#line 3003 "cimXmlOps.y"
    {
       (yyval.xtokEnumClasses).op.count = EC_REQ_REG_SEGMENTS;
       (yyval.xtokEnumClasses).op.type = OPS_EnumerateClasses;
       (yyval.xtokEnumClasses).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokEnumClasses).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokEnumClasses).flags = FL_localOnly|FL_includeQualifiers;

       setRequest(parm,&(yyval.xtokEnumClasses),sizeof(XtokEnumClasses),OPS_EnumerateClasses);
       buildEnumClassesRequest(parm);
    }
    break;

  case 99:

/* Line 1806 of yacc.c  */
#line 3014 "cimXmlOps.y"
    {
       (yyval.xtokEnumClasses).op.count = EC_REQ_REG_SEGMENTS;
       (yyval.xtokEnumClasses).op.type = OPS_EnumerateClasses;
       (yyval.xtokEnumClasses).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokEnumClasses).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokEnumClassesParmsList).className);
       (yyval.xtokEnumClasses).flags = ((yyvsp[(2) - (2)].xtokEnumClassesParmsList).flags & (yyvsp[(2) - (2)].xtokEnumClassesParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokEnumClassesParmsList).flagsSet) & (FL_localOnly|FL_includeQualifiers));

       setRequest(parm,&(yyval.xtokEnumClasses),sizeof(XtokEnumClasses),OPS_EnumerateClasses);
       buildEnumClassesRequest(parm);
    }
    break;

  case 100:

/* Line 1806 of yacc.c  */
#line 3028 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassesParmsList).flags=(yyvsp[(1) - (1)].xtokEnumClassesParms).flags;
       (yyval.xtokEnumClassesParmsList).flagsSet=(yyvsp[(1) - (1)].xtokEnumClassesParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokEnumClassesParms).className) (yyval.xtokEnumClassesParmsList).className=(yyvsp[(1) - (1)].xtokEnumClassesParms).className;
    }
    break;

  case 101:

/* Line 1806 of yacc.c  */
#line 3034 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassesParmsList).flags=(yyvsp[(1) - (2)].xtokEnumClassesParmsList).flags|(yyvsp[(2) - (2)].xtokEnumClassesParms).flags;
       (yyval.xtokEnumClassesParmsList).flagsSet=(yyvsp[(1) - (2)].xtokEnumClassesParmsList).flagsSet|(yyvsp[(2) - (2)].xtokEnumClassesParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokEnumClassesParms).className) (yyval.xtokEnumClassesParmsList).className=(yyvsp[(2) - (2)].xtokEnumClassesParms).className;
    }
    break;

  case 102:

/* Line 1806 of yacc.c  */
#line 3043 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumClassesParms), 0, sizeof((yyval.xtokEnumClassesParms)));
    }
    break;

  case 103:

/* Line 1806 of yacc.c  */
#line 3047 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassesParms).className = (yyvsp[(2) - (3)].className);
       (yyval.xtokEnumClassesParms).flags = (yyval.xtokEnumClassesParms).flagsSet = 0 ;
    }
    break;

  case 104:

/* Line 1806 of yacc.c  */
#line 3052 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumClassesParms), 0, sizeof((yyval.xtokEnumClassesParms)));
    }
    break;

  case 105:

/* Line 1806 of yacc.c  */
#line 3056 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_deepInheritance : 0 ;
       (yyval.xtokEnumClassesParms).flagsSet = FL_deepInheritance;
       (yyval.xtokEnumClassesParms).className=0;
    }
    break;

  case 106:

/* Line 1806 of yacc.c  */
#line 3062 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumClassesParms), 0, sizeof((yyval.xtokEnumClassesParms)));
    }
    break;

  case 107:

/* Line 1806 of yacc.c  */
#line 3066 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_localOnly : 0 ;
       (yyval.xtokEnumClassesParms).flagsSet = FL_localOnly;
       (yyval.xtokEnumClassesParms).className=0;
    }
    break;

  case 108:

/* Line 1806 of yacc.c  */
#line 3072 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumClassesParms), 0, sizeof((yyval.xtokEnumClassesParms)));
    }
    break;

  case 109:

/* Line 1806 of yacc.c  */
#line 3076 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokEnumClassesParms).flagsSet = FL_includeQualifiers;
       (yyval.xtokEnumClassesParms).className=0;
    }
    break;

  case 110:

/* Line 1806 of yacc.c  */
#line 3082 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumClassesParms), 0, sizeof((yyval.xtokEnumClassesParms)));
    }
    break;

  case 111:

/* Line 1806 of yacc.c  */
#line 3086 "cimXmlOps.y"
    {
       (yyval.xtokEnumClassesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokEnumClassesParms).flagsSet = FL_includeClassOrigin;
       (yyval.xtokEnumClassesParms).className=0;
    }
    break;

  case 112:

/* Line 1806 of yacc.c  */
#line 3099 "cimXmlOps.y"
    {
       (yyval.xtokGetInstance).op.count = GI_REQ_REG_SEGMENTS;
       (yyval.xtokGetInstance).op.type = OPS_GetInstance;
       (yyval.xtokGetInstance).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokGetInstance).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokGetInstance).flags = FL_localOnly;
       (yyval.xtokGetInstance).propertyList.values = NULL;
       (yyval.xtokGetInstance).properties=0;
       (yyval.xtokGetInstance).instNameSet = 0;
       //$$.userRole=setCharsMsgSegment($$.op.role);

       setRequest(parm,&(yyval.xtokGetInstance),sizeof(XtokGetInstance),OPS_GetInstance);
       buildGetInstanceRequest(parm);
    }
    break;

  case 113:

/* Line 1806 of yacc.c  */
#line 3114 "cimXmlOps.y"
    {
       (yyval.xtokGetInstance).op.count = GI_REQ_REG_SEGMENTS;
       (yyval.xtokGetInstance).op.type = OPS_GetInstance;
       (yyval.xtokGetInstance).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokGetInstance).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokGetInstanceParmsList).instanceName.className);
       (yyval.xtokGetInstance).flags = ((yyvsp[(2) - (2)].xtokGetInstanceParmsList).flags & (yyvsp[(2) - (2)].xtokGetInstanceParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokGetInstanceParmsList).flagsSet) & (FL_localOnly));
       (yyval.xtokGetInstance).instanceName = (yyvsp[(2) - (2)].xtokGetInstanceParmsList).instanceName;
       (yyval.xtokGetInstance).instNameSet = (yyvsp[(2) - (2)].xtokGetInstanceParmsList).instNameSet;
       (yyval.xtokGetInstance).propertyList = (yyvsp[(2) - (2)].xtokGetInstanceParmsList).propertyList;
       (yyval.xtokGetInstance).properties=(yyvsp[(2) - (2)].xtokGetInstanceParmsList).properties;

       setRequest(parm,&(yyval.xtokGetInstance),sizeof(XtokGetInstance),OPS_GetInstance);
       buildGetInstanceRequest(parm);
    }
    break;

  case 114:

/* Line 1806 of yacc.c  */
#line 3132 "cimXmlOps.y"
    {
       (yyval.xtokGetInstanceParmsList).flags=(yyvsp[(1) - (1)].xtokGetInstanceParms).flags;
       (yyval.xtokGetInstanceParmsList).flagsSet=(yyvsp[(1) - (1)].xtokGetInstanceParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokGetInstanceParms).instNameSet) (yyval.xtokGetInstanceParmsList).instanceName=(yyvsp[(1) - (1)].xtokGetInstanceParms).instanceName;
       (yyval.xtokGetInstanceParmsList).instNameSet = (yyvsp[(1) - (1)].xtokGetInstanceParms).instNameSet;
       if ((yyvsp[(1) - (1)].xtokGetInstanceParms).propertyList.values) {
          (yyval.xtokGetInstanceParmsList).propertyList=(yyvsp[(1) - (1)].xtokGetInstanceParms).propertyList;
          (yyval.xtokGetInstanceParmsList).properties=(yyvsp[(1) - (1)].xtokGetInstanceParms).properties;
       }
    }
    break;

  case 115:

/* Line 1806 of yacc.c  */
#line 3143 "cimXmlOps.y"
    {
       (yyval.xtokGetInstanceParmsList).flags=(yyvsp[(1) - (2)].xtokGetInstanceParmsList).flags|(yyvsp[(2) - (2)].xtokGetInstanceParms).flags;
       (yyval.xtokGetInstanceParmsList).flagsSet=(yyvsp[(1) - (2)].xtokGetInstanceParmsList).flagsSet|(yyvsp[(2) - (2)].xtokGetInstanceParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokGetInstanceParms).instNameSet) (yyval.xtokGetInstanceParmsList).instanceName=(yyvsp[(2) - (2)].xtokGetInstanceParms).instanceName;
       (yyval.xtokGetInstanceParmsList).instNameSet = (yyvsp[(2) - (2)].xtokGetInstanceParms).instNameSet;
       if ((yyvsp[(2) - (2)].xtokGetInstanceParms).propertyList.values) {
          (yyval.xtokGetInstanceParmsList).propertyList=(yyvsp[(2) - (2)].xtokGetInstanceParms).propertyList;
          (yyval.xtokGetInstanceParmsList).properties=(yyvsp[(2) - (2)].xtokGetInstanceParms).properties;
       }
    }
    break;

  case 116:

/* Line 1806 of yacc.c  */
#line 3157 "cimXmlOps.y"
    {
       (yyval.xtokGetInstanceParms).instanceName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokGetInstanceParms).flags = (yyval.xtokGetInstanceParms).flagsSet = 0 ;
       (yyval.xtokGetInstanceParms).propertyList.values=0;
       (yyval.xtokGetInstanceParms).instNameSet = 1;
       (yyval.xtokGetInstanceParms).properties=0;
    }
    break;

  case 117:

/* Line 1806 of yacc.c  */
#line 3165 "cimXmlOps.y"
    {
       (yyval.xtokGetInstanceParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_localOnly : 0 ;
       (yyval.xtokGetInstanceParms).flagsSet = FL_localOnly;
       (yyval.xtokGetInstanceParms).propertyList.values=0;
       (yyval.xtokGetInstanceParms).properties=(yyval.xtokGetInstanceParms).instNameSet=0;
    }
    break;

  case 118:

/* Line 1806 of yacc.c  */
#line 3172 "cimXmlOps.y"
    {
       memset(&(yyval.xtokGetInstanceParms), 0, sizeof((yyval.xtokGetInstanceParms)));
    }
    break;

  case 119:

/* Line 1806 of yacc.c  */
#line 3176 "cimXmlOps.y"
    {
       (yyval.xtokGetInstanceParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokGetInstanceParms).flagsSet = FL_includeQualifiers;
       (yyval.xtokGetInstanceParms).propertyList.values=0;
       (yyval.xtokGetInstanceParms).properties=(yyval.xtokGetInstanceParms).instNameSet=0;
    }
    break;

  case 120:

/* Line 1806 of yacc.c  */
#line 3183 "cimXmlOps.y"
    {
      memset(&(yyval.xtokGetInstanceParms), 0, sizeof((yyval.xtokGetInstanceParms)));
    }
    break;

  case 121:

/* Line 1806 of yacc.c  */
#line 3187 "cimXmlOps.y"
    {
       (yyval.xtokGetInstanceParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokGetInstanceParms).flagsSet = FL_includeClassOrigin;
       (yyval.xtokGetInstanceParms).propertyList.values=0;
       (yyval.xtokGetInstanceParms).properties=(yyval.xtokGetInstanceParms).instNameSet=0;
    }
    break;

  case 122:

/* Line 1806 of yacc.c  */
#line 3194 "cimXmlOps.y"
    {
      memset(&(yyval.xtokGetInstanceParms), 0, sizeof((yyval.xtokGetInstanceParms)));
    }
    break;

  case 123:

/* Line 1806 of yacc.c  */
#line 3198 "cimXmlOps.y"
    {
       (yyval.xtokGetInstanceParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokGetInstanceParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
       (yyval.xtokGetInstanceParms).instNameSet=0;
       (yyval.xtokGetInstanceParms).flags = (yyval.xtokGetInstanceParms).flagsSet = 0 ;
    }
    break;

  case 124:

/* Line 1806 of yacc.c  */
#line 3205 "cimXmlOps.y"
    {
      memset(&(yyval.xtokGetInstanceParms), 0, sizeof((yyval.xtokGetInstanceParms)));
    }
    break;

  case 125:

/* Line 1806 of yacc.c  */
#line 3218 "cimXmlOps.y"
    {
       (yyval.xtokCreateClass).op.count = CC_REQ_REG_SEGMENTS;
       (yyval.xtokCreateClass).op.type = OPS_CreateClass;
       (yyval.xtokCreateClass).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokCreateClass).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokCreateClass).superClass=NULL;

       setRequest(parm,&(yyval.xtokCreateClass),sizeof(XtokCreateClass),OPS_CreateClass);
       buildCreateClassRequest(parm);
    }
    break;

  case 126:

/* Line 1806 of yacc.c  */
#line 3229 "cimXmlOps.y"
    {
       (yyval.xtokCreateClass).op.count = CC_REQ_REG_SEGMENTS;
       (yyval.xtokCreateClass).op.type = OPS_CreateClass;
       (yyval.xtokCreateClass).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokCreateClass).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokCreateClassParm).cls.className);
       (yyval.xtokCreateClass).superClass=(yyvsp[(2) - (2)].xtokCreateClassParm).cls.superClass;
       (yyval.xtokCreateClass).cls = (yyvsp[(2) - (2)].xtokCreateClassParm).cls;

       setRequest(parm,&(yyval.xtokCreateClass),sizeof(XtokCreateClass),OPS_CreateClass);
       buildCreateClassRequest(parm);
    }
    break;

  case 127:

/* Line 1806 of yacc.c  */
#line 3244 "cimXmlOps.y"
    {
       (yyval.xtokCreateClassParm).cls = (yyvsp[(2) - (3)].xtokClass);
    }
    break;

  case 128:

/* Line 1806 of yacc.c  */
#line 3257 "cimXmlOps.y"
    {
       (yyval.xtokCreateInstance).op.count = CI_REQ_REG_SEGMENTS;
       (yyval.xtokCreateInstance).op.type = OPS_CreateInstance;
       (yyval.xtokCreateInstance).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokCreateInstance).op.className=setCharsMsgSegment(NULL);

       setRequest(parm,&(yyval.xtokCreateInstance),sizeof(XtokCreateInstance),OPS_CreateInstance);
       buildCreateInstanceRequest(parm);
    }
    break;

  case 129:

/* Line 1806 of yacc.c  */
#line 3267 "cimXmlOps.y"
    {
       (yyval.xtokCreateInstance).op.count = CI_REQ_REG_SEGMENTS;
       (yyval.xtokCreateInstance).op.type = OPS_CreateInstance;
       (yyval.xtokCreateInstance).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokCreateInstance).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokCreateInstanceParm).instance.className);
       (yyval.xtokCreateInstance).instance = (yyvsp[(2) - (2)].xtokCreateInstanceParm).instance;

       setRequest(parm,&(yyval.xtokCreateInstance),sizeof(XtokCreateInstance),OPS_CreateInstance);
       buildCreateInstanceRequest(parm);
    }
    break;

  case 130:

/* Line 1806 of yacc.c  */
#line 3282 "cimXmlOps.y"
    {
       (yyval.xtokCreateInstanceParm).instance = (yyvsp[(2) - (3)].xtokInstance);
    }
    break;

  case 131:

/* Line 1806 of yacc.c  */
#line 3294 "cimXmlOps.y"
    {
       (yyval.xtokModifyInstance).op.count = MI_REQ_REG_SEGMENTS;
       (yyval.xtokModifyInstance).op.type = OPS_ModifyInstance;
       (yyval.xtokModifyInstance).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokModifyInstance).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokModifyInstance).flags = FL_includeQualifiers;
       (yyval.xtokModifyInstance).propertyList.values = 0;
       (yyval.xtokModifyInstance).properties=0;

       setRequest(parm,&(yyval.xtokModifyInstance),sizeof(XtokModifyInstance),OPS_ModifyInstance);
       if (buildModifyInstanceRequest(parm)) yyerror(parm, "Invalid Parameter");
    }
    break;

  case 132:

/* Line 1806 of yacc.c  */
#line 3307 "cimXmlOps.y"
    {
       (yyval.xtokModifyInstance).op.count = MI_REQ_REG_SEGMENTS;
       (yyval.xtokModifyInstance).op.type = OPS_ModifyInstance;
       (yyval.xtokModifyInstance).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokModifyInstance).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokModifyInstanceParmsList).namedInstance.path.className);
       (yyval.xtokModifyInstance).namedInstance = (yyvsp[(2) - (2)].xtokModifyInstanceParmsList).namedInstance;
       (yyval.xtokModifyInstance).flags = (yyvsp[(2) - (2)].xtokModifyInstanceParmsList).flags | ((~(yyvsp[(2) - (2)].xtokModifyInstanceParmsList).flagsSet) & (FL_includeQualifiers));
       (yyval.xtokModifyInstance).propertyList = (yyvsp[(2) - (2)].xtokModifyInstanceParmsList).propertyList;
       (yyval.xtokModifyInstance).properties=(yyvsp[(2) - (2)].xtokModifyInstanceParmsList).properties;

       setRequest(parm,&(yyval.xtokModifyInstance),sizeof(XtokModifyInstance),OPS_ModifyInstance);
       if (buildModifyInstanceRequest(parm)) yyerror(parm, "Invalid Parameter");
    }
    break;

  case 133:

/* Line 1806 of yacc.c  */
#line 3324 "cimXmlOps.y"
    {
       (yyval.xtokModifyInstanceParmsList).flags=(yyvsp[(1) - (1)].xtokModifyInstanceParms).flags;
       (yyval.xtokModifyInstanceParmsList).flagsSet=(yyvsp[(1) - (1)].xtokModifyInstanceParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokModifyInstanceParms).namedInstSet) (yyval.xtokModifyInstanceParmsList).namedInstance=(yyvsp[(1) - (1)].xtokModifyInstanceParms).namedInstance;
       (yyval.xtokModifyInstanceParmsList).namedInstSet = (yyvsp[(1) - (1)].xtokModifyInstanceParms).namedInstSet;
       if ((yyvsp[(1) - (1)].xtokModifyInstanceParms).propertyList.values) {
          (yyval.xtokModifyInstanceParmsList).propertyList=(yyvsp[(1) - (1)].xtokModifyInstanceParms).propertyList;
          (yyval.xtokModifyInstanceParmsList).properties=(yyvsp[(1) - (1)].xtokModifyInstanceParms).properties;
       }
    }
    break;

  case 134:

/* Line 1806 of yacc.c  */
#line 3335 "cimXmlOps.y"
    {
       (yyval.xtokModifyInstanceParmsList).flags=(yyvsp[(1) - (2)].xtokModifyInstanceParmsList).flags|(yyvsp[(2) - (2)].xtokModifyInstanceParms).flags;
       (yyval.xtokModifyInstanceParmsList).flagsSet=(yyvsp[(1) - (2)].xtokModifyInstanceParmsList).flagsSet|(yyvsp[(2) - (2)].xtokModifyInstanceParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokModifyInstanceParms).namedInstSet) (yyval.xtokModifyInstanceParmsList).namedInstance=(yyvsp[(2) - (2)].xtokModifyInstanceParms).namedInstance;
       (yyval.xtokModifyInstanceParmsList).namedInstSet = (yyvsp[(2) - (2)].xtokModifyInstanceParms).namedInstSet;
       if ((yyvsp[(2) - (2)].xtokModifyInstanceParms).propertyList.values) {
          (yyval.xtokModifyInstanceParmsList).propertyList=(yyvsp[(2) - (2)].xtokModifyInstanceParms).propertyList;
          (yyval.xtokModifyInstanceParmsList).properties=(yyvsp[(2) - (2)].xtokModifyInstanceParms).properties;
       }
    }
    break;

  case 135:

/* Line 1806 of yacc.c  */
#line 3350 "cimXmlOps.y"
    {
       (yyval.xtokModifyInstanceParms).namedInstance=(yyvsp[(2) - (3)].xtokNamedInstance);
       (yyval.xtokModifyInstanceParms).namedInstSet=1;
       (yyval.xtokModifyInstanceParms).propertyList.values=NULL;
       (yyval.xtokModifyInstanceParms).properties=0;
       (yyval.xtokModifyInstanceParms).flags = (yyval.xtokModifyInstanceParms).flagsSet = 0 ;
    }
    break;

  case 136:

/* Line 1806 of yacc.c  */
#line 3358 "cimXmlOps.y"
    {
       (yyval.xtokModifyInstanceParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokModifyInstanceParms).flagsSet = FL_includeQualifiers;
       (yyval.xtokModifyInstanceParms).propertyList.values=0;
       (yyval.xtokModifyInstanceParms).properties=(yyval.xtokModifyInstanceParms).namedInstSet=0;
    }
    break;

  case 137:

/* Line 1806 of yacc.c  */
#line 3365 "cimXmlOps.y"
    {
       memset(&(yyval.xtokModifyInstanceParms), 0, sizeof((yyval.xtokModifyInstanceParms)));
    }
    break;

  case 138:

/* Line 1806 of yacc.c  */
#line 3369 "cimXmlOps.y"
    {
       (yyval.xtokModifyInstanceParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokModifyInstanceParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
       (yyval.xtokModifyInstanceParms).namedInstSet=0;
       (yyval.xtokModifyInstanceParms).flags = (yyval.xtokModifyInstanceParms).flagsSet = 0 ;
    }
    break;

  case 139:

/* Line 1806 of yacc.c  */
#line 3376 "cimXmlOps.y"
    {
       memset(&(yyval.xtokModifyInstanceParms), 0, sizeof((yyval.xtokModifyInstanceParms)));
    }
    break;

  case 140:

/* Line 1806 of yacc.c  */
#line 3388 "cimXmlOps.y"
    {
       (yyval.xtokDeleteClass).op.count = DC_REQ_REG_SEGMENTS;
       (yyval.xtokDeleteClass).op.type = OPS_DeleteClass;
       (yyval.xtokDeleteClass).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokDeleteClass).op.className=setCharsMsgSegment(NULL);

       setRequest(parm,&(yyval.xtokDeleteClass),sizeof(XtokDeleteClass),OPS_DeleteClass);
       buildDeleteClassRequest(parm);
    }
    break;

  case 141:

/* Line 1806 of yacc.c  */
#line 3398 "cimXmlOps.y"
    {
       (yyval.xtokDeleteClass).op.count = DC_REQ_REG_SEGMENTS;
       (yyval.xtokDeleteClass).op.type = OPS_DeleteClass;
       (yyval.xtokDeleteClass).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokDeleteClass).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokDeleteClassParm).className);
       (yyval.xtokDeleteClass).className = (yyvsp[(2) - (2)].xtokDeleteClassParm).className;

       setRequest(parm,&(yyval.xtokDeleteClass),sizeof(XtokDeleteClass),OPS_DeleteClass);
       buildDeleteClassRequest(parm);
    }
    break;

  case 142:

/* Line 1806 of yacc.c  */
#line 3413 "cimXmlOps.y"
    {
       (yyval.xtokDeleteClassParm).className = (yyvsp[(2) - (3)].className);
    }
    break;

  case 143:

/* Line 1806 of yacc.c  */
#line 3425 "cimXmlOps.y"
    {
       (yyval.xtokDeleteInstance).op.count = DI_REQ_REG_SEGMENTS;
       (yyval.xtokDeleteInstance).op.type = OPS_DeleteInstance;
       (yyval.xtokDeleteInstance).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokDeleteInstance).op.className=setCharsMsgSegment(NULL);

       setRequest(parm,&(yyval.xtokDeleteInstance),sizeof(XtokDeleteInstance),OPS_DeleteInstance);
       buildDeleteInstanceRequest(parm);
    }
    break;

  case 144:

/* Line 1806 of yacc.c  */
#line 3435 "cimXmlOps.y"
    {
       (yyval.xtokDeleteInstance).op.count = DI_REQ_REG_SEGMENTS;
       (yyval.xtokDeleteInstance).op.type = OPS_DeleteInstance;
       (yyval.xtokDeleteInstance).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokDeleteInstance).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokDeleteInstanceParm).instanceName.className);
       (yyval.xtokDeleteInstance).instanceName = (yyvsp[(2) - (2)].xtokDeleteInstanceParm).instanceName;

       setRequest(parm,&(yyval.xtokDeleteInstance),sizeof(XtokDeleteInstance),OPS_DeleteInstance);
       buildDeleteInstanceRequest(parm);
    }
    break;

  case 145:

/* Line 1806 of yacc.c  */
#line 3450 "cimXmlOps.y"
    {
       (yyval.xtokDeleteInstanceParm).instanceName = (yyvsp[(2) - (3)].xtokInstanceName);
    }
    break;

  case 146:

/* Line 1806 of yacc.c  */
#line 3463 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstanceNames).op.count = EIN_REQ_REG_SEGMENTS;
       (yyval.xtokEnumInstanceNames).op.type = OPS_EnumerateInstanceNames;
       (yyval.xtokEnumInstanceNames).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (4)].xtokLocalNameSpacePath));
       (yyval.xtokEnumInstanceNames).op.className=setCharsMsgSegment((yyvsp[(3) - (4)].className));

       setRequest(parm,&(yyval.xtokEnumInstanceNames),sizeof(XtokEnumInstanceNames),OPS_EnumerateInstanceNames);
       buildEnumInstanceNamesRequest(parm);
    }
    break;

  case 147:

/* Line 1806 of yacc.c  */
#line 3482 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstances).op.count = EI_REQ_REG_SEGMENTS;
       (yyval.xtokEnumInstances).op.type = OPS_EnumerateInstances;
       (yyval.xtokEnumInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokEnumInstances).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokEnumInstances).flags = FL_localOnly | FL_deepInheritance;
       (yyval.xtokEnumInstances).propertyList.values = NULL;
       (yyval.xtokEnumInstances).properties=0;

       setRequest(parm,&(yyval.xtokEnumInstances),sizeof(XtokEnumInstances),OPS_EnumerateInstances);
       buildEnumInstanceRequest(parm);
    }
    break;

  case 148:

/* Line 1806 of yacc.c  */
#line 3495 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstances).op.count = EI_REQ_REG_SEGMENTS;
       (yyval.xtokEnumInstances).op.type = OPS_EnumerateInstances;
       (yyval.xtokEnumInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokEnumInstances).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokEnumInstancesParmsList).className);
       (yyval.xtokEnumInstances).flags = ((yyvsp[(2) - (2)].xtokEnumInstancesParmsList).flags & (yyvsp[(2) - (2)].xtokEnumInstancesParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokEnumInstancesParmsList).flagsSet) & (FL_localOnly));
       (yyval.xtokEnumInstances).propertyList = (yyvsp[(2) - (2)].xtokEnumInstancesParmsList).propertyList;
       (yyval.xtokEnumInstances).properties=(yyvsp[(2) - (2)].xtokEnumInstancesParmsList).properties;

       setRequest(parm,&(yyval.xtokEnumInstances),sizeof(XtokEnumInstances),OPS_EnumerateInstances);
       buildEnumInstanceRequest(parm);
    }
    break;

  case 149:

/* Line 1806 of yacc.c  */
#line 3511 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstancesParmsList).flags=(yyvsp[(1) - (1)].xtokEnumInstancesParms).flags;
       (yyval.xtokEnumInstancesParmsList).flagsSet=(yyvsp[(1) - (1)].xtokEnumInstancesParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokEnumInstancesParms).className) (yyval.xtokEnumInstancesParmsList).className=(yyvsp[(1) - (1)].xtokEnumInstancesParms).className;
       if ((yyvsp[(1) - (1)].xtokEnumInstancesParms).propertyList.values) {
          (yyval.xtokEnumInstancesParmsList).propertyList=(yyvsp[(1) - (1)].xtokEnumInstancesParms).propertyList;
          (yyval.xtokEnumInstancesParmsList).properties=(yyvsp[(1) - (1)].xtokEnumInstancesParms).properties;
       }
    }
    break;

  case 150:

/* Line 1806 of yacc.c  */
#line 3521 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstancesParmsList).flags=(yyvsp[(1) - (2)].xtokEnumInstancesParmsList).flags|(yyvsp[(2) - (2)].xtokEnumInstancesParms).flags;
       (yyval.xtokEnumInstancesParmsList).flagsSet=(yyvsp[(1) - (2)].xtokEnumInstancesParmsList).flagsSet|(yyvsp[(2) - (2)].xtokEnumInstancesParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokEnumInstancesParms).className) (yyval.xtokEnumInstancesParmsList).className=(yyvsp[(2) - (2)].xtokEnumInstancesParms).className;
       if ((yyvsp[(2) - (2)].xtokEnumInstancesParms).propertyList.values) {
          (yyval.xtokEnumInstancesParmsList).propertyList=(yyvsp[(2) - (2)].xtokEnumInstancesParms).propertyList;
          (yyval.xtokEnumInstancesParmsList).properties=(yyvsp[(2) - (2)].xtokEnumInstancesParms).properties;
       }
    }
    break;

  case 151:

/* Line 1806 of yacc.c  */
#line 3534 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstancesParms).className = (yyvsp[(2) - (3)].className);
       (yyval.xtokEnumInstancesParms).flags = (yyval.xtokEnumInstancesParms).flagsSet = 0 ;
       (yyval.xtokEnumInstancesParms).properties=0;
       (yyval.xtokEnumInstancesParms).propertyList.values=0;
    }
    break;

  case 152:

/* Line 1806 of yacc.c  */
#line 3541 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_localOnly : 0 ;
       (yyval.xtokEnumInstancesParms).flagsSet = FL_localOnly;
       (yyval.xtokEnumInstancesParms).className=0;
       (yyval.xtokEnumInstancesParms).properties=0;
       (yyval.xtokEnumInstancesParms).propertyList.values=0;
    }
    break;

  case 153:

/* Line 1806 of yacc.c  */
#line 3549 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumInstancesParms), 0, sizeof((yyval.xtokEnumInstancesParms)));
    }
    break;

  case 154:

/* Line 1806 of yacc.c  */
#line 3553 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokEnumInstancesParms).flagsSet = FL_includeQualifiers;
       (yyval.xtokEnumInstancesParms).className=0;
       (yyval.xtokEnumInstancesParms).properties=0;
       (yyval.xtokEnumInstancesParms).propertyList.values=0;
    }
    break;

  case 155:

/* Line 1806 of yacc.c  */
#line 3561 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumInstancesParms), 0, sizeof((yyval.xtokEnumInstancesParms)));
    }
    break;

  case 156:

/* Line 1806 of yacc.c  */
#line 3565 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_deepInheritance : 0 ;
       (yyval.xtokEnumInstancesParms).flagsSet = FL_deepInheritance;
       (yyval.xtokEnumInstancesParms).className=0;
       (yyval.xtokEnumInstancesParms).properties=0;
       (yyval.xtokEnumInstancesParms).propertyList.values=0;
    }
    break;

  case 157:

/* Line 1806 of yacc.c  */
#line 3573 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumInstancesParms), 0, sizeof((yyval.xtokEnumInstancesParms)));
    }
    break;

  case 158:

/* Line 1806 of yacc.c  */
#line 3577 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokEnumInstancesParms).flagsSet = FL_includeClassOrigin;
       (yyval.xtokEnumInstancesParms).className=0;
       (yyval.xtokEnumInstancesParms).properties=0;
       (yyval.xtokEnumInstancesParms).propertyList.values=0;
    }
    break;

  case 159:

/* Line 1806 of yacc.c  */
#line 3585 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumInstancesParms), 0, sizeof((yyval.xtokEnumInstancesParms)));
    }
    break;

  case 160:

/* Line 1806 of yacc.c  */
#line 3589 "cimXmlOps.y"
    {
       (yyval.xtokEnumInstancesParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokEnumInstancesParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
       (yyval.xtokEnumInstancesParms).className=0;
       (yyval.xtokEnumInstancesParms).flags = (yyval.xtokEnumInstancesParms).flagsSet = 0 ;
    }
    break;

  case 161:

/* Line 1806 of yacc.c  */
#line 3596 "cimXmlOps.y"
    {
       memset(&(yyval.xtokEnumInstancesParms), 0, sizeof((yyval.xtokEnumInstancesParms)));
    }
    break;

  case 162:

/* Line 1806 of yacc.c  */
#line 3612 "cimXmlOps.y"
    {
       (yyval.xtokExecQuery).op.count = EQ_REQ_REG_SEGMENTS;
       (yyval.xtokExecQuery).op.type = OPS_ExecQuery;
       (yyval.xtokExecQuery).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (7)].xtokLocalNameSpacePath));
       (yyval.xtokExecQuery).op.query=setCharsMsgSegment((yyvsp[(3) - (7)].xtokValue).value);
       (yyval.xtokExecQuery).op.queryLang=setCharsMsgSegment((yyvsp[(6) - (7)].xtokValue).value);

       setRequest(parm,&(yyval.xtokExecQuery),sizeof(XtokExecQuery),OPS_ExecQuery);
       buildExecQueryRequest(parm);
    }
    break;

  case 163:

/* Line 1806 of yacc.c  */
#line 3625 "cimXmlOps.y"
    {
       (yyval.xtokExecQuery).op.count = EQ_REQ_REG_SEGMENTS;
       (yyval.xtokExecQuery).op.type = OPS_ExecQuery;
       (yyval.xtokExecQuery).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (7)].xtokLocalNameSpacePath));
       (yyval.xtokExecQuery).op.query=setCharsMsgSegment((yyvsp[(6) - (7)].xtokValue).value);
       (yyval.xtokExecQuery).op.queryLang=setCharsMsgSegment((yyvsp[(3) - (7)].xtokValue).value);

       setRequest(parm,&(yyval.xtokExecQuery),sizeof(XtokExecQuery),OPS_ExecQuery);
       buildExecQueryRequest(parm);
    }
    break;

  case 164:

/* Line 1806 of yacc.c  */
#line 3645 "cimXmlOps.y"
    {
       (yyval.xtokAssociators).op.count = AI_REQ_REG_SEGMENTS;
       (yyval.xtokAssociators).op.type = OPS_Associators;
       (yyval.xtokAssociators).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokAssociators).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokAssociators).op.assocClass=setCharsMsgSegment(NULL);
       (yyval.xtokAssociators).op.resultClass=setCharsMsgSegment(NULL);
       (yyval.xtokAssociators).op.role=setCharsMsgSegment(NULL);
       (yyval.xtokAssociators).op.resultRole=setCharsMsgSegment(NULL);
       (yyval.xtokAssociators).flags = 0;
       (yyval.xtokAssociators).objNameSet = 0;
       (yyval.xtokAssociators).propertyList.values = 0;
       (yyval.xtokAssociators).properties=0;

       setRequest(parm,&(yyval.xtokAssociators),sizeof(XtokAssociators),OPS_Associators);
       buildAssociatorsRequest(parm);
    }
    break;

  case 165:

/* Line 1806 of yacc.c  */
#line 3663 "cimXmlOps.y"
    {
       (yyval.xtokAssociators).op.count = AI_REQ_REG_SEGMENTS;
       (yyval.xtokAssociators).op.type = OPS_Associators;
       (yyval.xtokAssociators).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokAssociators).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorsParmsList).objectName.className);
       (yyval.xtokAssociators).op.assocClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorsParmsList).assocClass);
       (yyval.xtokAssociators).op.resultClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorsParmsList).resultClass);
       (yyval.xtokAssociators).op.role=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorsParmsList).role);
       (yyval.xtokAssociators).op.resultRole=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorsParmsList).resultRole);
       (yyval.xtokAssociators).flags = ((yyvsp[(2) - (2)].xtokAssociatorsParmsList).flags & (yyvsp[(2) - (2)].xtokAssociatorsParmsList).flagsSet) | (~(yyvsp[(2) - (2)].xtokAssociatorsParmsList).flagsSet & 0);
       (yyval.xtokAssociators).objectName = (yyvsp[(2) - (2)].xtokAssociatorsParmsList).objectName;
       (yyval.xtokAssociators).objNameSet = (yyvsp[(2) - (2)].xtokAssociatorsParmsList).objNameSet;
       (yyval.xtokAssociators).propertyList = (yyvsp[(2) - (2)].xtokAssociatorsParmsList).propertyList;
       (yyval.xtokAssociators).properties=(yyvsp[(2) - (2)].xtokAssociatorsParmsList).properties;

       setRequest(parm,&(yyval.xtokAssociators),sizeof(XtokAssociators),OPS_Associators);
       buildAssociatorsRequest(parm);
    }
    break;

  case 166:

/* Line 1806 of yacc.c  */
#line 3685 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParmsList).flags=(yyvsp[(1) - (1)].xtokAssociatorsParms).flags;
       (yyval.xtokAssociatorsParmsList).flagsSet=(yyvsp[(1) - (1)].xtokAssociatorsParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokAssociatorsParms).objNameSet)  {
          (yyval.xtokAssociatorsParmsList).objectName=(yyvsp[(1) - (1)].xtokAssociatorsParms).objectName;
          (yyval.xtokAssociatorsParmsList).objNameSet = (yyvsp[(1) - (1)].xtokAssociatorsParms).objNameSet;
       }
       (yyval.xtokAssociatorsParmsList).assocClass=(yyvsp[(1) - (1)].xtokAssociatorsParms).assocClass;
       (yyval.xtokAssociatorsParmsList).resultClass=(yyvsp[(1) - (1)].xtokAssociatorsParms).resultClass;
       (yyval.xtokAssociatorsParmsList).role=(yyvsp[(1) - (1)].xtokAssociatorsParms).role;
       (yyval.xtokAssociatorsParmsList).resultRole=(yyvsp[(1) - (1)].xtokAssociatorsParms).resultRole;
       if ((yyvsp[(1) - (1)].xtokAssociatorsParms).propertyList.values) {
          (yyval.xtokAssociatorsParmsList).propertyList=(yyvsp[(1) - (1)].xtokAssociatorsParms).propertyList;
          (yyval.xtokAssociatorsParmsList).properties=(yyvsp[(1) - (1)].xtokAssociatorsParms).properties;
       }
    }
    break;

  case 167:

/* Line 1806 of yacc.c  */
#line 3702 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParmsList).flags=(yyvsp[(1) - (2)].xtokAssociatorsParmsList).flags|(yyvsp[(2) - (2)].xtokAssociatorsParms).flags;
       (yyval.xtokAssociatorsParmsList).flagsSet=(yyvsp[(1) - (2)].xtokAssociatorsParmsList).flagsSet|(yyvsp[(2) - (2)].xtokAssociatorsParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokAssociatorsParms).assocClass) (yyval.xtokAssociatorsParmsList).assocClass=(yyvsp[(2) - (2)].xtokAssociatorsParms).assocClass;
       else if ((yyvsp[(2) - (2)].xtokAssociatorsParms).resultClass) (yyval.xtokAssociatorsParmsList).resultClass=(yyvsp[(2) - (2)].xtokAssociatorsParms).resultClass;
       else if ((yyvsp[(2) - (2)].xtokAssociatorsParms).role) (yyval.xtokAssociatorsParmsList).role=(yyvsp[(2) - (2)].xtokAssociatorsParms).role;
       else if ((yyvsp[(2) - (2)].xtokAssociatorsParms).resultRole) (yyval.xtokAssociatorsParmsList).resultRole=(yyvsp[(2) - (2)].xtokAssociatorsParms).resultRole;
       else if ((yyvsp[(2) - (2)].xtokAssociatorsParms).objNameSet) {
          (yyval.xtokAssociatorsParmsList).objectName=(yyvsp[(2) - (2)].xtokAssociatorsParms).objectName;
          (yyval.xtokAssociatorsParmsList).objNameSet = (yyvsp[(2) - (2)].xtokAssociatorsParms).objNameSet;
       }
       else if ((yyvsp[(2) - (2)].xtokAssociatorsParms).propertyList.values) {
          (yyval.xtokAssociatorsParmsList).propertyList=(yyvsp[(2) - (2)].xtokAssociatorsParms).propertyList;
          (yyval.xtokAssociatorsParmsList).properties=(yyvsp[(2) - (2)].xtokAssociatorsParms).properties;
       }
    }
    break;

  case 168:

/* Line 1806 of yacc.c  */
#line 3722 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParms).objectName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokAssociatorsParms).objNameSet = 1;
       (yyval.xtokAssociatorsParms).flags = (yyval.xtokAssociatorsParms).flagsSet = 0 ;
       (yyval.xtokAssociatorsParms).assocClass=(yyval.xtokAssociatorsParms).resultClass=(yyval.xtokAssociatorsParms).role=(yyval.xtokAssociatorsParms).resultRole=0;
       (yyval.xtokAssociatorsParms).properties=0;
       (yyval.xtokAssociatorsParms).propertyList.values=0;
    }
    break;

  case 169:

/* Line 1806 of yacc.c  */
#line 3731 "cimXmlOps.y"
    {
       // This is an unsupported operation. To ensure we handle with a friendly
       // error message, make it appear as if INSTANCENAME with no KEYBINDING
       // was passed in the XML.
       (yyval.xtokAssociatorsParms).objectName.className = (yyvsp[(2) - (3)].className);
       (yyval.xtokAssociatorsParms).objectName.bindings.next=0;
       (yyval.xtokAssociatorsParms).objectName.bindings.keyBindings=NULL;
       (yyval.xtokAssociatorsParms).objNameSet = 1;
       (yyval.xtokAssociatorsParms).flags = (yyval.xtokAssociatorsParms).flagsSet = 0;
       (yyval.xtokAssociatorsParms).resultClass=(yyval.xtokAssociatorsParms).role=0;
       (yyval.xtokAssociatorsParms).properties=0;
       (yyval.xtokAssociatorsParms).propertyList.values=0;
    }
    break;

  case 170:

/* Line 1806 of yacc.c  */
#line 3745 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParms).assocClass = (yyvsp[(2) - (3)].className);
       (yyval.xtokAssociatorsParms).objNameSet=(yyval.xtokAssociatorsParms).flags = (yyval.xtokAssociatorsParms).flagsSet = 0 ;
       (yyval.xtokAssociatorsParms).resultClass=(yyval.xtokAssociatorsParms).role=(yyval.xtokAssociatorsParms).resultRole=0;
       (yyval.xtokAssociatorsParms).properties=0;
       (yyval.xtokAssociatorsParms).propertyList.values=0;
    }
    break;

  case 171:

/* Line 1806 of yacc.c  */
#line 3753 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorsParms), 0, sizeof((yyval.xtokAssociatorsParms)));
    }
    break;

  case 172:

/* Line 1806 of yacc.c  */
#line 3757 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParms).resultClass = (yyvsp[(2) - (3)].className);
       (yyval.xtokAssociatorsParms).objNameSet=(yyval.xtokAssociatorsParms).flags = (yyval.xtokAssociatorsParms).flagsSet = 0 ;
       (yyval.xtokAssociatorsParms).assocClass=(yyval.xtokAssociatorsParms).role=(yyval.xtokAssociatorsParms).resultRole=0;
       (yyval.xtokAssociatorsParms).properties=0;
       (yyval.xtokAssociatorsParms).propertyList.values=0;
    }
    break;

  case 173:

/* Line 1806 of yacc.c  */
#line 3765 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorsParms), 0, sizeof((yyval.xtokAssociatorsParms)));
    }
    break;

  case 174:

/* Line 1806 of yacc.c  */
#line 3769 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParms).role = (yyvsp[(2) - (3)].xtokValue).value;
       (yyval.xtokAssociatorsParms).objNameSet=(yyval.xtokAssociatorsParms).flags = (yyval.xtokAssociatorsParms).flagsSet = 0 ;
       (yyval.xtokAssociatorsParms).assocClass=(yyval.xtokAssociatorsParms).resultClass=(yyval.xtokAssociatorsParms).resultRole=0;
       (yyval.xtokAssociatorsParms).properties=0;
       (yyval.xtokAssociatorsParms).propertyList.values=0;
    }
    break;

  case 175:

/* Line 1806 of yacc.c  */
#line 3777 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorsParms), 0, sizeof((yyval.xtokAssociatorsParms)));
    }
    break;

  case 176:

/* Line 1806 of yacc.c  */
#line 3781 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParms).resultRole = (yyvsp[(2) - (3)].xtokValue).value;
       (yyval.xtokAssociatorsParms).objNameSet=(yyval.xtokAssociatorsParms).flags = (yyval.xtokAssociatorsParms).flagsSet = 0 ;
       (yyval.xtokAssociatorsParms).assocClass=(yyval.xtokAssociatorsParms).resultClass=(yyval.xtokAssociatorsParms).role=0;
       (yyval.xtokAssociatorsParms).properties=0;
       (yyval.xtokAssociatorsParms).propertyList.values=0;
    }
    break;

  case 177:

/* Line 1806 of yacc.c  */
#line 3789 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorsParms), 0, sizeof((yyval.xtokAssociatorsParms)));
    }
    break;

  case 178:

/* Line 1806 of yacc.c  */
#line 3793 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokAssociatorsParms).flagsSet = FL_includeQualifiers;
       (yyval.xtokAssociatorsParms).objNameSet=0;
       (yyval.xtokAssociatorsParms).assocClass=(yyval.xtokAssociatorsParms).resultClass=(yyval.xtokAssociatorsParms).role=(yyval.xtokAssociatorsParms).resultRole=0;
       (yyval.xtokAssociatorsParms).properties=0;
       (yyval.xtokAssociatorsParms).propertyList.values=0;
    }
    break;

  case 179:

/* Line 1806 of yacc.c  */
#line 3802 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorsParms), 0, sizeof((yyval.xtokAssociatorsParms)));
    }
    break;

  case 180:

/* Line 1806 of yacc.c  */
#line 3806 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokAssociatorsParms).flagsSet = FL_includeClassOrigin;
       (yyval.xtokAssociatorsParms).objNameSet=0;
       (yyval.xtokAssociatorsParms).assocClass=(yyval.xtokAssociatorsParms).resultClass=(yyval.xtokAssociatorsParms).role=(yyval.xtokAssociatorsParms).resultRole=0;
       (yyval.xtokAssociatorsParms).properties=0;
       (yyval.xtokAssociatorsParms).propertyList.values=0;
    }
    break;

  case 181:

/* Line 1806 of yacc.c  */
#line 3815 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorsParms), 0, sizeof((yyval.xtokAssociatorsParms)));
    }
    break;

  case 182:

/* Line 1806 of yacc.c  */
#line 3819 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorsParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokAssociatorsParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
       (yyval.xtokAssociatorsParms).objNameSet=(yyval.xtokAssociatorsParms).flags = (yyval.xtokAssociatorsParms).flagsSet = 0 ;
       (yyval.xtokAssociatorsParms).assocClass=(yyval.xtokAssociatorsParms).resultClass=(yyval.xtokAssociatorsParms).role=(yyval.xtokAssociatorsParms).resultRole=0;
    }
    break;

  case 183:

/* Line 1806 of yacc.c  */
#line 3826 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorsParms), 0, sizeof((yyval.xtokAssociatorsParms)));
    }
    break;

  case 184:

/* Line 1806 of yacc.c  */
#line 3841 "cimXmlOps.y"
    {
       (yyval.xtokReferences).op.count = RI_REQ_REG_SEGMENTS;
       (yyval.xtokReferences).op.type = OPS_References;
       (yyval.xtokReferences).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokReferences).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokReferences).op.resultClass=setCharsMsgSegment(NULL);
       (yyval.xtokReferences).op.role=setCharsMsgSegment(NULL);
       (yyval.xtokReferences).flags = 0;
       (yyval.xtokReferences).objNameSet = 0;
       (yyval.xtokReferences).propertyList.values = 0;
       (yyval.xtokReferences).properties=0;

       setRequest(parm,&(yyval.xtokReferences),sizeof(XtokReferences),OPS_References);
       buildReferencesRequest(parm);
    }
    break;

  case 185:

/* Line 1806 of yacc.c  */
#line 3857 "cimXmlOps.y"
    {
       (yyval.xtokReferences).op.count = RI_REQ_REG_SEGMENTS;
       (yyval.xtokReferences).op.type = OPS_References;
       (yyval.xtokReferences).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokReferences).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokReferencesParmsList).objectName.className);
       (yyval.xtokReferences).op.resultClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokReferencesParmsList).resultClass);
       (yyval.xtokReferences).op.role=setCharsMsgSegment((yyvsp[(2) - (2)].xtokReferencesParmsList).role);
       (yyval.xtokReferences).flags = ((yyvsp[(2) - (2)].xtokReferencesParmsList).flags & (yyvsp[(2) - (2)].xtokReferencesParmsList).flagsSet) | (~(yyvsp[(2) - (2)].xtokReferencesParmsList).flagsSet & 0);
       (yyval.xtokReferences).objectName = (yyvsp[(2) - (2)].xtokReferencesParmsList).objectName;
       (yyval.xtokReferences).objNameSet = (yyvsp[(2) - (2)].xtokReferencesParmsList).objNameSet;
       (yyval.xtokReferences).propertyList = (yyvsp[(2) - (2)].xtokReferencesParmsList).propertyList;
       (yyval.xtokReferences).properties=(yyvsp[(2) - (2)].xtokReferencesParmsList).properties;

       setRequest(parm,&(yyval.xtokReferences),sizeof(XtokReferences),OPS_References);
       buildReferencesRequest(parm);
    }
    break;

  case 186:

/* Line 1806 of yacc.c  */
#line 3877 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParmsList).flags=(yyvsp[(1) - (1)].xtokReferencesParms).flags;
       (yyval.xtokReferencesParmsList).flagsSet=(yyvsp[(1) - (1)].xtokReferencesParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokReferencesParms).objNameSet)  {
          (yyval.xtokReferencesParmsList).objectName=(yyvsp[(1) - (1)].xtokReferencesParms).objectName;
          (yyval.xtokReferencesParmsList).objNameSet = (yyvsp[(1) - (1)].xtokReferencesParms).objNameSet;
       }
       (yyval.xtokReferencesParmsList).resultClass=(yyvsp[(1) - (1)].xtokReferencesParms).resultClass;
       (yyval.xtokReferencesParmsList).role=(yyvsp[(1) - (1)].xtokReferencesParms).role;
       if ((yyvsp[(1) - (1)].xtokReferencesParms).propertyList.values) {
          (yyval.xtokReferencesParmsList).propertyList=(yyvsp[(1) - (1)].xtokReferencesParms).propertyList;
          (yyval.xtokReferencesParmsList).properties=(yyvsp[(1) - (1)].xtokReferencesParms).properties;
       }
    }
    break;

  case 187:

/* Line 1806 of yacc.c  */
#line 3892 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParmsList).flags=(yyvsp[(1) - (2)].xtokReferencesParmsList).flags|(yyvsp[(2) - (2)].xtokReferencesParms).flags;
       (yyval.xtokReferencesParmsList).flagsSet=(yyvsp[(1) - (2)].xtokReferencesParmsList).flagsSet|(yyvsp[(2) - (2)].xtokReferencesParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokReferencesParms).resultClass) (yyval.xtokReferencesParmsList).resultClass=(yyvsp[(2) - (2)].xtokReferencesParms).resultClass;
       else if ((yyvsp[(2) - (2)].xtokReferencesParms).role) (yyval.xtokReferencesParmsList).role=(yyvsp[(2) - (2)].xtokReferencesParms).role;
       else if ((yyvsp[(2) - (2)].xtokReferencesParms).objNameSet) {
          (yyval.xtokReferencesParmsList).objectName=(yyvsp[(2) - (2)].xtokReferencesParms).objectName;
          (yyval.xtokReferencesParmsList).objNameSet = (yyvsp[(2) - (2)].xtokReferencesParms).objNameSet;
       }
       else if ((yyvsp[(2) - (2)].xtokReferencesParms).propertyList.values) {
          (yyval.xtokReferencesParmsList).propertyList=(yyvsp[(2) - (2)].xtokReferencesParms).propertyList;
          (yyval.xtokReferencesParmsList).properties=(yyvsp[(2) - (2)].xtokReferencesParms).properties;
       }
   }
    break;

  case 188:

/* Line 1806 of yacc.c  */
#line 3910 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParms).objectName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokReferencesParms).objNameSet = 1;
       (yyval.xtokReferencesParms).flags = (yyval.xtokReferencesParms).flagsSet = 0 ;
       (yyval.xtokReferencesParms).resultClass=(yyval.xtokReferencesParms).role=0;
       (yyval.xtokReferencesParms).properties=0;
       (yyval.xtokReferencesParms).propertyList.values=0;
    }
    break;

  case 189:

/* Line 1806 of yacc.c  */
#line 3919 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParms).objectName.className = (yyvsp[(2) - (3)].className);
       (yyval.xtokReferencesParms).objectName.bindings.next=0;
       (yyval.xtokReferencesParms).objectName.bindings.keyBindings=NULL;
       (yyval.xtokReferencesParms).objNameSet = 1;
       (yyval.xtokReferencesParms).flags = (yyval.xtokReferencesParms).flagsSet = 0;
       (yyval.xtokReferencesParms).resultClass=(yyval.xtokReferencesParms).role=0;
       (yyval.xtokReferencesParms).properties=0;
       (yyval.xtokReferencesParms).propertyList.values=0;
    }
    break;

  case 190:

/* Line 1806 of yacc.c  */
#line 3930 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParms).resultClass = (yyvsp[(2) - (3)].className);
       (yyval.xtokReferencesParms).objNameSet=(yyval.xtokReferencesParms).flags = (yyval.xtokReferencesParms).flagsSet = 0 ;
       (yyval.xtokReferencesParms).role=0;
       (yyval.xtokReferencesParms).properties=0;
       (yyval.xtokReferencesParms).propertyList.values=0;
   }
    break;

  case 191:

/* Line 1806 of yacc.c  */
#line 3938 "cimXmlOps.y"
    {
       memset(&(yyval.xtokReferencesParms), 0, sizeof((yyval.xtokReferencesParms)));
    }
    break;

  case 192:

/* Line 1806 of yacc.c  */
#line 3942 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParms).role = (yyvsp[(2) - (3)].xtokValue).value;
       (yyval.xtokReferencesParms).objNameSet=(yyval.xtokReferencesParms).flags = (yyval.xtokReferencesParms).flagsSet = 0 ;
       (yyval.xtokReferencesParms).resultClass=0;
       (yyval.xtokReferencesParms).properties=0;
       (yyval.xtokReferencesParms).propertyList.values=0;
    }
    break;

  case 193:

/* Line 1806 of yacc.c  */
#line 3950 "cimXmlOps.y"
    {
       memset(&(yyval.xtokReferencesParms), 0, sizeof((yyval.xtokReferencesParms)));
    }
    break;

  case 194:

/* Line 1806 of yacc.c  */
#line 3954 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokReferencesParms).flagsSet = FL_includeQualifiers;
       (yyval.xtokReferencesParms).objNameSet=0;
       (yyval.xtokReferencesParms).resultClass=(yyval.xtokReferencesParms).role=0;
       (yyval.xtokReferencesParms).properties=0;
       (yyval.xtokReferencesParms).propertyList.values=0;
    }
    break;

  case 195:

/* Line 1806 of yacc.c  */
#line 3963 "cimXmlOps.y"
    {
       memset(&(yyval.xtokReferencesParms), 0, sizeof((yyval.xtokReferencesParms)));
    }
    break;

  case 196:

/* Line 1806 of yacc.c  */
#line 3967 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokReferencesParms).flagsSet = FL_includeClassOrigin;
       (yyval.xtokReferencesParms).objNameSet=0;
       (yyval.xtokReferencesParms).resultClass=(yyval.xtokReferencesParms).role=0;
       (yyval.xtokReferencesParms).properties=0;
       (yyval.xtokReferencesParms).propertyList.values=0;
    }
    break;

  case 197:

/* Line 1806 of yacc.c  */
#line 3976 "cimXmlOps.y"
    {
       memset(&(yyval.xtokReferencesParms), 0, sizeof((yyval.xtokReferencesParms)));
    }
    break;

  case 198:

/* Line 1806 of yacc.c  */
#line 3980 "cimXmlOps.y"
    {
       (yyval.xtokReferencesParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokReferencesParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
       (yyval.xtokReferencesParms).objNameSet=(yyval.xtokReferencesParms).flags = (yyval.xtokReferencesParms).flagsSet = 0 ;
       (yyval.xtokReferencesParms).resultClass=(yyval.xtokReferencesParms).role=0;
    }
    break;

  case 199:

/* Line 1806 of yacc.c  */
#line 3987 "cimXmlOps.y"
    {
       memset(&(yyval.xtokReferencesParms), 0, sizeof((yyval.xtokReferencesParms)));
    }
    break;

  case 200:

/* Line 1806 of yacc.c  */
#line 4000 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorNames).op.count = AIN_REQ_REG_SEGMENTS;
       (yyval.xtokAssociatorNames).op.type = OPS_AssociatorNames;
       (yyval.xtokAssociatorNames).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokAssociatorNames).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokAssociatorNames).op.assocClass=setCharsMsgSegment(NULL);
       (yyval.xtokAssociatorNames).op.resultClass=setCharsMsgSegment(NULL);
       (yyval.xtokAssociatorNames).op.role=setCharsMsgSegment(NULL);
       (yyval.xtokAssociatorNames).op.resultRole=setCharsMsgSegment(NULL);
       (yyval.xtokAssociatorNames).objNameSet = 0;

       setRequest(parm,&(yyval.xtokAssociatorNames),sizeof(XtokAssociatorNames),OPS_AssociatorNames);
       buildAssociatorNamesRequest(parm);
    }
    break;

  case 201:

/* Line 1806 of yacc.c  */
#line 4015 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorNames).op.count = AIN_REQ_REG_SEGMENTS;
       (yyval.xtokAssociatorNames).op.type = OPS_AssociatorNames;
       (yyval.xtokAssociatorNames).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokAssociatorNames).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorNamesParmsList).objectName.className);
       (yyval.xtokAssociatorNames).op.assocClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorNamesParmsList).assocClass);
       (yyval.xtokAssociatorNames).op.resultClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorNamesParmsList).resultClass);
       (yyval.xtokAssociatorNames).op.role=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorNamesParmsList).role);
       (yyval.xtokAssociatorNames).op.resultRole=setCharsMsgSegment((yyvsp[(2) - (2)].xtokAssociatorNamesParmsList).resultRole);
       (yyval.xtokAssociatorNames).objectName = (yyvsp[(2) - (2)].xtokAssociatorNamesParmsList).objectName;
       (yyval.xtokAssociatorNames).objNameSet = (yyvsp[(2) - (2)].xtokAssociatorNamesParmsList).objNameSet;
       setRequest(parm,&(yyval.xtokAssociatorNames),sizeof(XtokAssociatorNames),OPS_AssociatorNames);
       buildAssociatorNamesRequest(parm);
    }
    break;

  case 202:

/* Line 1806 of yacc.c  */
#line 4033 "cimXmlOps.y"
    {
       if ((yyvsp[(1) - (1)].xtokAssociatorNamesParms).objNameSet)  {
          (yyval.xtokAssociatorNamesParmsList).objectName=(yyvsp[(1) - (1)].xtokAssociatorNamesParms).objectName;
          (yyval.xtokAssociatorNamesParmsList).objNameSet = (yyvsp[(1) - (1)].xtokAssociatorNamesParms).objNameSet;
       }
      (yyval.xtokAssociatorNamesParmsList).assocClass=(yyvsp[(1) - (1)].xtokAssociatorNamesParms).assocClass;
      (yyval.xtokAssociatorNamesParmsList).resultClass=(yyvsp[(1) - (1)].xtokAssociatorNamesParms).resultClass;
      (yyval.xtokAssociatorNamesParmsList).role=(yyvsp[(1) - (1)].xtokAssociatorNamesParms).role;
      (yyval.xtokAssociatorNamesParmsList).resultRole=(yyvsp[(1) - (1)].xtokAssociatorNamesParms).resultRole;
    }
    break;

  case 203:

/* Line 1806 of yacc.c  */
#line 4044 "cimXmlOps.y"
    {
       if ((yyvsp[(2) - (2)].xtokAssociatorNamesParms).assocClass) (yyval.xtokAssociatorNamesParmsList).assocClass=(yyvsp[(2) - (2)].xtokAssociatorNamesParms).assocClass;
       else if ((yyvsp[(2) - (2)].xtokAssociatorNamesParms).resultClass) (yyval.xtokAssociatorNamesParmsList).resultClass=(yyvsp[(2) - (2)].xtokAssociatorNamesParms).resultClass;
       else if ((yyvsp[(2) - (2)].xtokAssociatorNamesParms).role) (yyval.xtokAssociatorNamesParmsList).role=(yyvsp[(2) - (2)].xtokAssociatorNamesParms).role;
       else if ((yyvsp[(2) - (2)].xtokAssociatorNamesParms).resultRole) (yyval.xtokAssociatorNamesParmsList).resultRole=(yyvsp[(2) - (2)].xtokAssociatorNamesParms).resultRole;
       else if ((yyvsp[(2) - (2)].xtokAssociatorNamesParms).objNameSet) {
          (yyval.xtokAssociatorNamesParmsList).objectName=(yyvsp[(2) - (2)].xtokAssociatorNamesParms).objectName;
          (yyval.xtokAssociatorNamesParmsList).objNameSet = (yyvsp[(2) - (2)].xtokAssociatorNamesParms).objNameSet;
       }
    }
    break;

  case 204:

/* Line 1806 of yacc.c  */
#line 4058 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorNamesParms).objectName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokAssociatorNamesParms).objNameSet = 1;
       (yyval.xtokAssociatorNamesParms).assocClass=(yyval.xtokAssociatorNamesParms).resultClass=(yyval.xtokAssociatorNamesParms).role=(yyval.xtokAssociatorNamesParms).resultRole=0;
    }
    break;

  case 205:

/* Line 1806 of yacc.c  */
#line 4064 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorNamesParms).objectName.className = (yyvsp[(2) - (3)].className);
       (yyval.xtokAssociatorNamesParms).objectName.bindings.next=0;
       (yyval.xtokAssociatorNamesParms).objectName.bindings.keyBindings=NULL;
       (yyval.xtokAssociatorNamesParms).objNameSet = 1;
       (yyval.xtokAssociatorNamesParms).resultClass=(yyval.xtokAssociatorNamesParms).role=0;
    }
    break;

  case 206:

/* Line 1806 of yacc.c  */
#line 4072 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorNamesParms).assocClass = (yyvsp[(2) - (3)].className);
       (yyval.xtokAssociatorNamesParms).objNameSet = 0 ;
       (yyval.xtokAssociatorNamesParms).resultClass=(yyval.xtokAssociatorNamesParms).role=(yyval.xtokAssociatorNamesParms).resultRole=0;
    }
    break;

  case 207:

/* Line 1806 of yacc.c  */
#line 4078 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorNamesParms), 0, sizeof((yyval.xtokAssociatorNamesParms)));
    }
    break;

  case 208:

/* Line 1806 of yacc.c  */
#line 4082 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorNamesParms).resultClass = (yyvsp[(2) - (3)].className);
       (yyval.xtokAssociatorNamesParms).objNameSet = 0 ;
       (yyval.xtokAssociatorNamesParms).assocClass=(yyval.xtokAssociatorNamesParms).role=(yyval.xtokAssociatorNamesParms).resultRole=0;
    }
    break;

  case 209:

/* Line 1806 of yacc.c  */
#line 4088 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorNamesParms), 0, sizeof((yyval.xtokAssociatorNamesParms)));
    }
    break;

  case 210:

/* Line 1806 of yacc.c  */
#line 4092 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorNamesParms).role = (yyvsp[(2) - (3)].xtokValue).value;
       (yyval.xtokAssociatorNamesParms).objNameSet = 0 ;
       (yyval.xtokAssociatorNamesParms).assocClass=(yyval.xtokAssociatorNamesParms).resultClass=(yyval.xtokAssociatorNamesParms).resultRole=0;
    }
    break;

  case 211:

/* Line 1806 of yacc.c  */
#line 4098 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorNamesParms), 0, sizeof((yyval.xtokAssociatorNamesParms)));
    }
    break;

  case 212:

/* Line 1806 of yacc.c  */
#line 4102 "cimXmlOps.y"
    {
       (yyval.xtokAssociatorNamesParms).resultRole = (yyvsp[(2) - (3)].xtokValue).value;
       (yyval.xtokAssociatorNamesParms).objNameSet= 0 ;
       (yyval.xtokAssociatorNamesParms).assocClass=(yyval.xtokAssociatorNamesParms).resultClass=(yyval.xtokAssociatorNamesParms).role=0;
    }
    break;

  case 213:

/* Line 1806 of yacc.c  */
#line 4108 "cimXmlOps.y"
    {
       memset(&(yyval.xtokAssociatorNamesParms), 0, sizeof((yyval.xtokAssociatorNamesParms)));
    }
    break;

  case 214:

/* Line 1806 of yacc.c  */
#line 4122 "cimXmlOps.y"
    {
       (yyval.xtokReferenceNames).op.count = RIN_REQ_REG_SEGMENTS;
       (yyval.xtokReferenceNames).op.type = OPS_ReferenceNames;
       (yyval.xtokReferenceNames).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokReferenceNames).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokReferenceNames).op.resultClass=setCharsMsgSegment(NULL);
       (yyval.xtokReferenceNames).op.role=setCharsMsgSegment(NULL);
       (yyval.xtokReferenceNames).objNameSet = 0;

       setRequest(parm,&(yyval.xtokReferenceNames),sizeof(XtokReferenceNames),OPS_ReferenceNames);
       buildReferenceNamesRequest(parm);
    }
    break;

  case 215:

/* Line 1806 of yacc.c  */
#line 4135 "cimXmlOps.y"
    {
       (yyval.xtokReferenceNames).op.count = RIN_REQ_REG_SEGMENTS;
       (yyval.xtokReferenceNames).op.type = OPS_ReferenceNames;
       (yyval.xtokReferenceNames).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokReferenceNames).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokReferenceNamesParmsList).objectName.className);
       (yyval.xtokReferenceNames).op.resultClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokReferenceNamesParmsList).resultClass);
       (yyval.xtokReferenceNames).op.role=setCharsMsgSegment((yyvsp[(2) - (2)].xtokReferenceNamesParmsList).role);
       (yyval.xtokReferenceNames).objectName = (yyvsp[(2) - (2)].xtokReferenceNamesParmsList).objectName;
       (yyval.xtokReferenceNames).objNameSet = (yyvsp[(2) - (2)].xtokReferenceNamesParmsList).objNameSet;

       setRequest(parm,&(yyval.xtokReferenceNames),sizeof(XtokReferenceNames),OPS_ReferenceNames);
       buildReferenceNamesRequest(parm);
    }
    break;

  case 216:

/* Line 1806 of yacc.c  */
#line 4152 "cimXmlOps.y"
    {
      if ((yyvsp[(1) - (1)].xtokReferenceNamesParms).objNameSet)  {
          (yyval.xtokReferenceNamesParmsList).objectName=(yyvsp[(1) - (1)].xtokReferenceNamesParms).objectName;
          (yyval.xtokReferenceNamesParmsList).objNameSet = (yyvsp[(1) - (1)].xtokReferenceNamesParms).objNameSet;
      }
      (yyval.xtokReferenceNamesParmsList).resultClass = (yyvsp[(1) - (1)].xtokReferenceNamesParms).resultClass;
      (yyval.xtokReferenceNamesParmsList).role = (yyvsp[(1) - (1)].xtokReferenceNamesParms).role;
    }
    break;

  case 217:

/* Line 1806 of yacc.c  */
#line 4161 "cimXmlOps.y"
    {
       if((yyvsp[(2) - (2)].xtokReferenceNamesParms).objNameSet) {
          (yyval.xtokReferenceNamesParmsList).objectName=(yyvsp[(2) - (2)].xtokReferenceNamesParms).objectName;
          (yyval.xtokReferenceNamesParmsList).objNameSet=(yyvsp[(2) - (2)].xtokReferenceNamesParms).objNameSet;
       }
       else if((yyvsp[(2) - (2)].xtokReferenceNamesParms).resultClass) (yyval.xtokReferenceNamesParmsList).resultClass=(yyvsp[(2) - (2)].xtokReferenceNamesParms).resultClass;
       else if((yyvsp[(2) - (2)].xtokReferenceNamesParms).role) (yyval.xtokReferenceNamesParmsList).role=(yyvsp[(2) - (2)].xtokReferenceNamesParms).role;              
    }
    break;

  case 218:

/* Line 1806 of yacc.c  */
#line 4173 "cimXmlOps.y"
    {
       (yyval.xtokReferenceNamesParms).objectName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokReferenceNamesParms).objNameSet = 1;
       (yyval.xtokReferenceNamesParms).resultClass=(yyval.xtokReferenceNamesParms).role=0;
    }
    break;

  case 219:

/* Line 1806 of yacc.c  */
#line 4179 "cimXmlOps.y"
    {
       (yyval.xtokReferenceNamesParms).objectName.className = (yyvsp[(2) - (3)].className);
       (yyval.xtokReferenceNamesParms).objectName.bindings.next=0;
       (yyval.xtokReferenceNamesParms).objectName.bindings.keyBindings=NULL;
       (yyval.xtokReferenceNamesParms).objNameSet = 1;
       (yyval.xtokReferenceNamesParms).resultClass=(yyval.xtokReferenceNamesParms).role=0;
    }
    break;

  case 220:

/* Line 1806 of yacc.c  */
#line 4187 "cimXmlOps.y"
    {
       (yyval.xtokReferenceNamesParms).resultClass = (yyvsp[(2) - (3)].className);
       (yyval.xtokReferenceNamesParms).objNameSet = 0;
       (yyval.xtokReferenceNamesParms).role=0;
    }
    break;

  case 221:

/* Line 1806 of yacc.c  */
#line 4193 "cimXmlOps.y"
    {
      memset(&(yyval.xtokReferenceNamesParms), 0, sizeof((yyval.xtokReferenceNamesParms)));
    }
    break;

  case 222:

/* Line 1806 of yacc.c  */
#line 4197 "cimXmlOps.y"
    {
       (yyval.xtokReferenceNamesParms).role = (yyvsp[(2) - (3)].xtokValue).value;
       (yyval.xtokReferenceNamesParms).objNameSet = 0 ;
       (yyval.xtokReferenceNamesParms).resultClass=0;
    }
    break;

  case 223:

/* Line 1806 of yacc.c  */
#line 4203 "cimXmlOps.y"
    {
      memset(&(yyval.xtokReferenceNamesParms), 0, sizeof((yyval.xtokReferenceNamesParms)));
    }
    break;

  case 224:

/* Line 1806 of yacc.c  */
#line 4215 "cimXmlOps.y"
    {
        (yyval.xtokNamedInstance).path=(yyvsp[(2) - (4)].xtokInstanceName);
	(yyval.xtokNamedInstance).instance=(yyvsp[(3) - (4)].xtokInstance);
    }
    break;

  case 225:

/* Line 1806 of yacc.c  */
#line 4228 "cimXmlOps.y"
    {
       if (((ParserControl*)parm)->Qs) 
          (yyval.xtokClass).qualifiers=((ParserControl*)parm)->qualifiers;
       else memset(&(yyval.xtokClass).qualifiers,0,sizeof((yyval.xtokClass).qualifiers));
       if (((ParserControl*)parm)->Ps) 
          (yyval.xtokClass).properties=((ParserControl*)parm)->properties;
       else memset(&(yyval.xtokClass).properties,0,sizeof((yyval.xtokClass).properties));
       if (((ParserControl*)parm)->Ms) 
          (yyval.xtokClass).methods=((ParserControl*)parm)->methods;
       else memset(&(yyval.xtokClass).methods,0,sizeof((yyval.xtokClass).methods));
    }
    break;

  case 226:

/* Line 1806 of yacc.c  */
#line 4242 "cimXmlOps.y"
    {;}
    break;

  case 227:

/* Line 1806 of yacc.c  */
#line 4244 "cimXmlOps.y"
    {
       ((ParserControl*)parm)->Qs++;
       addQualifier(&(((ParserControl*)parm)->qualifiers),&(yyvsp[(2) - (2)].xtokQualifier));
    }
    break;

  case 228:

/* Line 1806 of yacc.c  */
#line 4248 "cimXmlOps.y"
    {
       ((ParserControl*)parm)->Ps++;
       addProperty(&(((ParserControl*)parm)->properties),&(yyvsp[(2) - (2)].xtokProperty));
    }
    break;

  case 229:

/* Line 1806 of yacc.c  */
#line 4252 "cimXmlOps.y"
    {
        ((ParserControl*)parm)->Ms++;
        addMethod(&(((ParserControl*)parm)->methods),&(yyvsp[(2) - (2)].xtokMethod));
    }
    break;

  case 230:

/* Line 1806 of yacc.c  */
#line 4260 "cimXmlOps.y"
    {
       if (((ParserControl*)parm)->MQs) 
          (yyval.xtokMethod).qualifiers=(yyvsp[(2) - (3)].xtokMethodData).qualifiers;
       else memset(&(yyval.xtokMethod).qualifiers,0,sizeof((yyval.xtokMethod).qualifiers));
       if (((ParserControl*)parm)->MPs) 
          (yyval.xtokMethod).params=(yyvsp[(2) - (3)].xtokMethodData).params;
       else memset(&(yyval.xtokMethod).params,0,sizeof((yyval.xtokMethod).params));
       ((ParserControl*)parm)->MQs=0; 
       ((ParserControl*)parm)->MPs=0; 
       ((ParserControl*)parm)->MPQs=0; 
    }
    break;

  case 231:

/* Line 1806 of yacc.c  */
#line 4274 "cimXmlOps.y"
    {;}
    break;

  case 232:

/* Line 1806 of yacc.c  */
#line 4276 "cimXmlOps.y"
    {
       if (((ParserControl*)parm)->MQs==0) 
          memset(&(yyval.xtokMethodData).qualifiers,0,sizeof((yyval.xtokMethodData).qualifiers));
       ((ParserControl*)parm)->MQs++;
       addQualifier(&((yyval.xtokMethodData).qualifiers),&(yyvsp[(2) - (2)].xtokQualifier));
    }
    break;

  case 233:

/* Line 1806 of yacc.c  */
#line 4283 "cimXmlOps.y"
    {
       if (((ParserControl*)parm)->MPs==0) 
          memset(&(yyval.xtokMethodData).params,0,sizeof((yyval.xtokMethodData).params));
       ((ParserControl*)parm)->MPs++;
       if (((ParserControl*)parm)->MPQs) 
          (yyvsp[(2) - (4)].xtokParam).qualifiers=(yyvsp[(3) - (4)].xtokParam).qualifiers;
       else memset(&(yyvsp[(2) - (4)].xtokParam).qualifiers,0,sizeof((yyvsp[(2) - (4)].xtokParam).qualifiers));
       addParam(&((yyval.xtokMethodData).params),&(yyvsp[(2) - (4)].xtokParam));
       ((ParserControl*)parm)->MPQs=0; 
    }
    break;

  case 234:

/* Line 1806 of yacc.c  */
#line 4296 "cimXmlOps.y"
    {;}
    break;

  case 235:

/* Line 1806 of yacc.c  */
#line 4298 "cimXmlOps.y"
    {
       if (((ParserControl*)parm)->MPQs==0) 
          memset(&(yyval.xtokParam).qualifiers,0,sizeof((yyval.xtokParam).qualifiers));
       ((ParserControl*)parm)->MPQs++; 
       addQualifier(&((yyval.xtokParam).qualifiers),&(yyvsp[(2) - (2)].xtokQualifier));
    }
    break;

  case 236:

/* Line 1806 of yacc.c  */
#line 4313 "cimXmlOps.y"
    {
       if((yyvsp[(2) - (3)].xtokInstanceData).qualifiers.first)
          (yyval.xtokInstance).qualifiers=(yyvsp[(2) - (3)].xtokInstanceData).qualifiers;
       else memset(&(yyval.xtokInstance).qualifiers,0,sizeof((yyval.xtokInstance).qualifiers));
       
       if((yyvsp[(2) - (3)].xtokInstanceData).properties.first)
          (yyval.xtokInstance).properties=(yyvsp[(2) - (3)].xtokInstanceData).properties;
       else memset(&(yyval.xtokInstance).properties,0,sizeof((yyval.xtokInstance).properties)); 
    }
    break;

  case 237:

/* Line 1806 of yacc.c  */
#line 4326 "cimXmlOps.y"
    {
       (yyval.xtokInstanceData).properties.last=0;
       (yyval.xtokInstanceData).properties.first=0;
       (yyval.xtokInstanceData).qualifiers.last=0;
       (yyval.xtokInstanceData).qualifiers.first=0;       
    }
    break;

  case 238:

/* Line 1806 of yacc.c  */
#line 4333 "cimXmlOps.y"
    {
       addQualifier(&((yyval.xtokInstanceData).qualifiers),&(yyvsp[(2) - (2)].xtokQualifier));
    }
    break;

  case 239:

/* Line 1806 of yacc.c  */
#line 4337 "cimXmlOps.y"
    {
       addProperty(&((yyval.xtokInstanceData).properties),&(yyvsp[(2) - (2)].xtokProperty));
    }
    break;

  case 240:

/* Line 1806 of yacc.c  */
#line 4347 "cimXmlOps.y"
    {;}
    break;

  case 241:

/* Line 1806 of yacc.c  */
#line 4349 "cimXmlOps.y"
    {
    	(yyval.xtokQualifierDeclaration).scope = (yyvsp[(2) - (4)].xtokScope);
    	(yyval.xtokQualifierDeclaration).data = (yyvsp[(3) - (4)].xtokQualifierDeclarationData);
    }
    break;

  case 242:

/* Line 1806 of yacc.c  */
#line 4357 "cimXmlOps.y"
    {
    	(yyval.xtokQualifierDeclarationData).value.value = NULL;
    }
    break;

  case 243:

/* Line 1806 of yacc.c  */
#line 4361 "cimXmlOps.y"
    {
    	(yyval.xtokQualifierDeclarationData).value = (yyvsp[(1) - (1)].xtokValue);
    	(yyval.xtokQualifierDeclarationData).type = 0;
    }
    break;

  case 244:

/* Line 1806 of yacc.c  */
#line 4366 "cimXmlOps.y"
    {
    	(yyval.xtokQualifierDeclarationData).valueArray=(yyvsp[(1) - (1)].xtokValueArray);
    	(yyval.xtokQualifierDeclarationData).type=CMPI_ARRAY;
    }
    break;

  case 245:

/* Line 1806 of yacc.c  */
#line 4376 "cimXmlOps.y"
    {;}
    break;

  case 246:

/* Line 1806 of yacc.c  */
#line 4378 "cimXmlOps.y"
    {
	}
    break;

  case 247:

/* Line 1806 of yacc.c  */
#line 4388 "cimXmlOps.y"
    {
       (yyvsp[(3) - (4)].xtokPropertyData).qualifiers=(yyvsp[(2) - (4)].xtokQualifiers);
       (yyval.xtokProperty).val=(yyvsp[(3) - (4)].xtokPropertyData);
       
       if((yyval.xtokProperty).val.val.value) {
          if((yyval.xtokProperty).val.val.type == typeValue_Instance)
             (yyval.xtokProperty).valueType = CMPI_instance;
          else if((yyval.xtokProperty).val.val.type == typeValue_Class)
             (yyval.xtokProperty).valueType = CMPI_class;
       }
    }
    break;

  case 248:

/* Line 1806 of yacc.c  */
#line 4400 "cimXmlOps.y"
    {
       (yyvsp[(3) - (4)].xtokPropertyData).qualifiers=(yyvsp[(2) - (4)].xtokQualifiers);
       (yyval.xtokProperty).val=(yyvsp[(3) - (4)].xtokPropertyData);
    }
    break;

  case 249:

/* Line 1806 of yacc.c  */
#line 4405 "cimXmlOps.y"
    {
       (yyvsp[(3) - (4)].xtokPropertyData).qualifiers=(yyvsp[(2) - (4)].xtokQualifiers);
       (yyval.xtokProperty).val=(yyvsp[(3) - (4)].xtokPropertyData);
       
       if((yyval.xtokProperty).val.list.values) {
          if((yyval.xtokProperty).val.list.values[0].type == typeValue_Instance)
          	(yyval.xtokProperty).valueType = CMPI_instance | CMPI_ARRAY;
          if((yyval.xtokProperty).val.list.values[0].type == typeValue_Class)
          	(yyval.xtokProperty).valueType = CMPI_class | CMPI_ARRAY;          	
       }     
    }
    break;

  case 250:

/* Line 1806 of yacc.c  */
#line 4420 "cimXmlOps.y"
    {
      (yyval.xtokQualifiers).first = (yyval.xtokQualifiers).last = NULL;
    }
    break;

  case 251:

/* Line 1806 of yacc.c  */
#line 4424 "cimXmlOps.y"
    {
       addQualifier(&(yyvsp[(1) - (2)].xtokQualifiers),&(yyvsp[(2) - (2)].xtokQualifier));
       (yyval.xtokQualifiers) = (yyvsp[(1) - (2)].xtokQualifiers);
    }
    break;

  case 252:

/* Line 1806 of yacc.c  */
#line 4432 "cimXmlOps.y"
    {
       (yyval.xtokPropertyData).val.value = NULL;
       (yyval.xtokPropertyData).list.values = NULL;
       (yyval.xtokPropertyData).val.type = 0;
    }
    break;

  case 253:

/* Line 1806 of yacc.c  */
#line 4438 "cimXmlOps.y"
    {
       (yyval.xtokPropertyData).val=(yyvsp[(1) - (1)].xtokValue);
    }
    break;

  case 254:

/* Line 1806 of yacc.c  */
#line 4442 "cimXmlOps.y"
    {
       (yyval.xtokPropertyData).ref=(yyvsp[(1) - (1)].xtokValueReference);
    }
    break;

  case 255:

/* Line 1806 of yacc.c  */
#line 4446 "cimXmlOps.y"
    {
       (yyval.xtokPropertyData).list=(yyvsp[(1) - (1)].xtokValueArray);
    }
    break;

  case 256:

/* Line 1806 of yacc.c  */
#line 4459 "cimXmlOps.y"
    {
       (yyval.xtokQualifier).value=(yyvsp[(2) - (3)].xtokValue);
    }
    break;

  case 257:

/* Line 1806 of yacc.c  */
#line 4463 "cimXmlOps.y"
    {
       (yyval.xtokQualifier).valueArray=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokQualifier).type |= CMPI_ARRAY;
    }
    break;

  case 258:

/* Line 1806 of yacc.c  */
#line 4477 "cimXmlOps.y"
    {
       (yyval.xtokLocalNameSpacePath)=(yyvsp[(2) - (3)].xtokNameSpace).cns;
    }
    break;

  case 259:

/* Line 1806 of yacc.c  */
#line 4484 "cimXmlOps.y"
    {
       (yyval.xtokNameSpace).cns=strdup((yyvsp[(1) - (2)].xtokNameSpace).ns);
    }
    break;

  case 260:

/* Line 1806 of yacc.c  */
#line 4488 "cimXmlOps.y"
    {
       int l=strlen((yyvsp[(1) - (3)].xtokNameSpace).cns)+strlen((yyvsp[(2) - (3)].xtokNameSpace).ns)+2;
       (yyval.xtokNameSpace).cns=malloc(l);
       strcpy((yyval.xtokNameSpace).cns,(yyvsp[(1) - (3)].xtokNameSpace).cns);
       strcat((yyval.xtokNameSpace).cns,"/");
       strcat((yyval.xtokNameSpace).cns,(yyvsp[(2) - (3)].xtokNameSpace).ns);
       free((yyvsp[(1) - (3)].xtokNameSpace).cns);
    }
    break;

  case 261:

/* Line 1806 of yacc.c  */
#line 4501 "cimXmlOps.y"
    {
       (yyval.xtokNameSpacePath).host=(yyvsp[(2) - (4)].xtokHost);
       (yyval.xtokNameSpacePath).nameSpacePath=(yyvsp[(3) - (4)].xtokLocalNameSpacePath);
    }
    break;

  case 262:

/* Line 1806 of yacc.c  */
#line 4509 "cimXmlOps.y"
    {
    }
    break;

  case 263:

/* Line 1806 of yacc.c  */
#line 4515 "cimXmlOps.y"
    {
       (yyval.xtokInstancePath).path=(yyvsp[(2) - (4)].xtokNameSpacePath);
       (yyval.xtokInstancePath).instanceName=(yyvsp[(3) - (4)].xtokInstanceName);
       (yyval.xtokInstancePath).type=1;
    }
    break;

  case 264:

/* Line 1806 of yacc.c  */
#line 4534 "cimXmlOps.y"
    {
       (yyval.xtokLocalInstancePath).path=(yyvsp[(2) - (4)].xtokLocalNameSpacePath);
       (yyval.xtokLocalInstancePath).instanceName=(yyvsp[(3) - (4)].xtokInstanceName);
       (yyval.xtokLocalInstancePath).type=1;
    }
    break;

  case 265:

/* Line 1806 of yacc.c  */
#line 4543 "cimXmlOps.y"
    {
       (yyval.xtokLocalClassPath).path=(yyvsp[(2) - (4)].xtokLocalNameSpacePath);
       (yyval.xtokLocalClassPath).className=(yyvsp[(3) - (4)].className);
       (yyval.xtokLocalClassPath).type=1;
    }
    break;

  case 266:

/* Line 1806 of yacc.c  */
#line 4556 "cimXmlOps.y"
    {
       (yyval.xtokValue).instance = malloc(sizeof(XtokInstance));
       (yyval.xtokValue).instance = memcpy((yyval.xtokValue).instance, &(yyvsp[(2) - (3)].xtokInstance), sizeof(XtokInstance));
       (yyval.xtokValue).type=typeValue_Instance;
    }
    break;

  case 267:

/* Line 1806 of yacc.c  */
#line 4562 "cimXmlOps.y"
    {
       (yyval.xtokValue).instance = malloc(sizeof(XtokInstance));
       (yyval.xtokValue).instance = memcpy((yyval.xtokValue).instance, &(yyvsp[(3) - (5)].xtokInstance), sizeof(XtokInstance));
       (yyval.xtokValue).type=typeValue_Instance;
    }
    break;

  case 268:

/* Line 1806 of yacc.c  */
#line 4568 "cimXmlOps.y"
    {
       (yyval.xtokValue).type=typeValue_Class;
    }
    break;

  case 269:

/* Line 1806 of yacc.c  */
#line 4572 "cimXmlOps.y"
    {
       (yyval.xtokValue).value=(yyvsp[(1) - (2)].xtokValue).value;
       (yyval.xtokValue).type=typeValue_charP;
    }
    break;

  case 270:

/* Line 1806 of yacc.c  */
#line 4580 "cimXmlOps.y"
    {
	  (yyval.xtokValueArray).values=malloc(sizeof(XtokValue));
	  (yyval.xtokValueArray).next=0;
	}
    break;

  case 271:

/* Line 1806 of yacc.c  */
#line 4585 "cimXmlOps.y"
    {
	  (yyval.xtokValueArray) = (yyvsp[(2) - (3)].xtokValueArray);
	  (yyval.xtokValueArray).values[(yyval.xtokValueArray).next].value = NULL;
	  if((yyval.xtokValueArray).next == 0) (yyval.xtokValueArray).next = 1;
	}
    break;

  case 272:

/* Line 1806 of yacc.c  */
#line 4595 "cimXmlOps.y"
    {
          (yyval.xtokValueArray).next=1;
          (yyval.xtokValueArray).max=VALUEARRAY_MAX_START;
          (yyval.xtokValueArray).values=malloc(sizeof(XtokValue)*((yyval.xtokValueArray).max));
          (yyval.xtokValueArray).values[0]=(yyvsp[(1) - (1)].xtokValue);
        }
    break;

  case 273:

/* Line 1806 of yacc.c  */
#line 4602 "cimXmlOps.y"
    {
          if ((yyval.xtokValueArray).next == (yyval.xtokValueArray).max) { /* max was hit; let's bump it up 50% */
            (yyval.xtokValueArray).max = (int)((yyval.xtokValueArray).max * ((float)3)/2);
            (yyval.xtokValueArray).values=realloc(((yyval.xtokValueArray).values), sizeof(XtokValue)*((yyval.xtokValueArray).max));
          }
          (yyval.xtokValueArray).values[(yyval.xtokValueArray).next]=(yyvsp[(2) - (2)].xtokValue);
          (yyval.xtokValueArray).next++;
        }
    break;

  case 274:

/* Line 1806 of yacc.c  */
#line 4614 "cimXmlOps.y"
    {
       (yyval.xtokValueReference).instancePath=(yyvsp[(2) - (3)].xtokInstancePath);
       (yyval.xtokValueReference).type=typeValRef_InstancePath;
    }
    break;

  case 275:

/* Line 1806 of yacc.c  */
#line 4619 "cimXmlOps.y"
    {
       (yyval.xtokValueReference).localInstancePath=(yyvsp[(2) - (3)].xtokLocalInstancePath);
       (yyval.xtokValueReference).type=typeValRef_LocalInstancePath;
    }
    break;

  case 276:

/* Line 1806 of yacc.c  */
#line 4624 "cimXmlOps.y"
    {
       (yyval.xtokValueReference).instanceName=(yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokValueReference).type=typeValRef_InstanceName;
    }
    break;

  case 277:

/* Line 1806 of yacc.c  */
#line 4632 "cimXmlOps.y"
    {
       (yyval.xtokValueRefArray)=(yyvsp[(2) - (3)].xtokValueRefArray);
    }
    break;

  case 278:

/* Line 1806 of yacc.c  */
#line 4639 "cimXmlOps.y"
    {
       (yyval.xtokValueRefArray).next=1;
       (yyval.xtokValueRefArray).max=VALUEREFARRAY_MAX_START;
       (yyval.xtokValueRefArray).values=malloc(sizeof(XtokValueReference)*((yyval.xtokValueRefArray).max));
       (yyval.xtokValueRefArray).values[0]=(yyvsp[(1) - (1)].xtokValueReference);
    }
    break;

  case 279:

/* Line 1806 of yacc.c  */
#line 4646 "cimXmlOps.y"
    {
       if ((yyval.xtokValueRefArray).next == (yyval.xtokValueRefArray).max) { /* max was hit; let's bump it up 50% */
         (yyval.xtokValueRefArray).max = (int)((yyval.xtokValueRefArray).max * ((float)3)/2);
         (yyval.xtokValueRefArray).values=realloc(((yyval.xtokValueRefArray).values), sizeof(XtokValueReference)*((yyval.xtokValueRefArray).max));
       }
       (yyval.xtokValueRefArray).values[(yyval.xtokValueRefArray).next]=(yyvsp[(2) - (2)].xtokValueReference);
       (yyval.xtokValueRefArray).next++;
    }
    break;

  case 280:

/* Line 1806 of yacc.c  */
#line 4658 "cimXmlOps.y"
    {
    if (strcasecmp((yyvsp[(1) - (2)].xtokValue).value,"true")==0) (yyval.boolValue)=1;
    if (strcasecmp((yyvsp[(1) - (2)].xtokValue).value,"false")==0) (yyval.boolValue)=0;
    }
    break;

  case 281:

/* Line 1806 of yacc.c  */
#line 4670 "cimXmlOps.y"
    {
       (yyval.xtokOpenEnumInstancePaths).op.count = EIN_REQ_REG_SEGMENTS;
       (yyval.xtokOpenEnumInstancePaths).op.type = OPS_OpenEnumerateInstancePaths;
       (yyval.xtokOpenEnumInstancePaths).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokOpenEnumInstancePaths).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokOpenEnumInstancePaths).flags=0;

       setRequest(parm,&(yyval.xtokOpenEnumInstancePaths),sizeof((yyval.xtokOpenEnumInstancePaths)),(yyval.xtokOpenEnumInstancePaths).op.type);
       buildEnumInstanceNamesRequest(parm);   // TODO
    }
    break;

  case 282:

/* Line 1806 of yacc.c  */
#line 4681 "cimXmlOps.y"
    {
       (yyval.xtokOpenEnumInstancePaths).op.count = EIN_REQ_REG_SEGMENTS;
       (yyval.xtokOpenEnumInstancePaths).op.type = OPS_OpenEnumerateInstancePaths;
       (yyval.xtokOpenEnumInstancePaths).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokOpenEnumInstancePaths).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParmsList).className);
       (yyval.xtokOpenEnumInstancePaths).flags = ((yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParmsList).flags & (yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParmsList).flagsSet) & (FL_localOnly));
       (yyval.xtokOpenEnumInstancePaths).operationTimeout=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParmsList).operationTimeout;
       (yyval.xtokOpenEnumInstancePaths).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParmsList).maxObjectCount;
       (yyval.xtokOpenEnumInstancePaths).filterQuery=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParmsList).filterQuery;
       (yyval.xtokOpenEnumInstancePaths).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParmsList).filterQueryLang;

       setRequest(parm,&(yyval.xtokOpenEnumInstancePaths),sizeof((yyval.xtokOpenEnumInstancePaths)),(yyval.xtokOpenEnumInstancePaths).op.type);
       buildEnumInstanceNamesRequest(parm);   // TODO
    }
    break;

  case 283:

/* Line 1806 of yacc.c  */
#line 4699 "cimXmlOps.y"
    {
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).className) (yyval.xtokOpenEnumInstancePathsParmsList).className=(yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).className;
       (yyval.xtokOpenEnumInstancePathsParmsList).flags=(yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).flags;
       (yyval.xtokOpenEnumInstancePathsParmsList).flagsSet=(yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).operationTimeout) (yyval.xtokOpenEnumInstancePathsParmsList).operationTimeout=(yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).operationTimeout;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).maxObjectCount) (yyval.xtokOpenEnumInstancePathsParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).filterQuery) (yyval.xtokOpenEnumInstancePathsParmsList).filterQuery=(yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).filterQuery;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).filterQueryLang) (yyval.xtokOpenEnumInstancePathsParmsList).filterQueryLang=(yyvsp[(1) - (1)].xtokOpenEnumInstancePathsParms).filterQueryLang;
    }
    break;

  case 284:

/* Line 1806 of yacc.c  */
#line 4709 "cimXmlOps.y"
    {
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).className) (yyval.xtokOpenEnumInstancePathsParmsList).className=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).className;
       (yyval.xtokOpenEnumInstancePathsParmsList).flags=(yyvsp[(1) - (2)].xtokOpenEnumInstancePathsParmsList).flags|(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).flags;
       (yyval.xtokOpenEnumInstancePathsParmsList).flagsSet=(yyvsp[(1) - (2)].xtokOpenEnumInstancePathsParmsList).flagsSet|(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).operationTimeout) (yyval.xtokOpenEnumInstancePathsParmsList).operationTimeout=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).operationTimeout;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).maxObjectCount) (yyval.xtokOpenEnumInstancePathsParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).filterQuery) (yyval.xtokOpenEnumInstancePathsParmsList).filterQuery=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).filterQuery;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).filterQueryLang) (yyval.xtokOpenEnumInstancePathsParmsList).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenEnumInstancePathsParms).filterQueryLang;
    }
    break;

  case 285:

/* Line 1806 of yacc.c  */
#line 4722 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
       (yyval.xtokOpenEnumInstancePathsParms).className = (yyvsp[(2) - (3)].className);
    }
    break;

  case 286:

/* Line 1806 of yacc.c  */
#line 4727 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
       (yyval.xtokOpenEnumInstancePathsParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_continueOnError : 0 ;
       (yyval.xtokOpenEnumInstancePathsParms).flagsSet = FL_continueOnError;
    }
    break;

  case 287:

/* Line 1806 of yacc.c  */
#line 4733 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
    }
    break;

  case 288:

/* Line 1806 of yacc.c  */
#line 4737 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
       (yyval.xtokOpenEnumInstancePathsParms).operationTimeout=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 289:

/* Line 1806 of yacc.c  */
#line 4742 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
    }
    break;

  case 290:

/* Line 1806 of yacc.c  */
#line 4746 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
       (yyval.xtokOpenEnumInstancePathsParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 291:

/* Line 1806 of yacc.c  */
#line 4751 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
    }
    break;

  case 292:

/* Line 1806 of yacc.c  */
#line 4755 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
       (yyval.xtokOpenEnumInstancePathsParms).filterQuery=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 293:

/* Line 1806 of yacc.c  */
#line 4760 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
    }
    break;

  case 294:

/* Line 1806 of yacc.c  */
#line 4764 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
       (yyval.xtokOpenEnumInstancePathsParms).filterQueryLang=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 295:

/* Line 1806 of yacc.c  */
#line 4769 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancePathsParms), 0, sizeof((yyval.xtokOpenEnumInstancePathsParms)));
    }
    break;

  case 296:

/* Line 1806 of yacc.c  */
#line 4781 "cimXmlOps.y"
    {
       (yyval.xtokOpenEnumInstances).op.count = EI_REQ_REG_SEGMENTS;
       (yyval.xtokOpenEnumInstances).op.type = OPS_OpenEnumerateInstances;
       (yyval.xtokOpenEnumInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokOpenEnumInstances).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokOpenEnumInstances).flags = FL_localOnly | FL_deepInheritance;
       (yyval.xtokOpenEnumInstances).propertyList.values = NULL;
       (yyval.xtokOpenEnumInstances).properties=0;

       setRequest(parm,&(yyval.xtokOpenEnumInstances),sizeof((yyval.xtokOpenEnumInstances)),(yyval.xtokOpenEnumInstances).op.type);
       buildOpenEnumInstanceRequest(parm);
    }
    break;

  case 297:

/* Line 1806 of yacc.c  */
#line 4794 "cimXmlOps.y"
    {
       (yyval.xtokOpenEnumInstances).op.count = EI_REQ_REG_SEGMENTS;
       (yyval.xtokOpenEnumInstances).op.type = OPS_OpenEnumerateInstances;
       (yyval.xtokOpenEnumInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokOpenEnumInstances).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).className);
       (yyval.xtokOpenEnumInstances).flags = ((yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).flags & (yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).flagsSet) & (FL_localOnly));
       (yyval.xtokOpenEnumInstances).propertyList = (yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).propertyList;
       (yyval.xtokOpenEnumInstances).properties=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).properties;
       (yyval.xtokOpenEnumInstances).operationTimeout=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).operationTimeout;
       (yyval.xtokOpenEnumInstances).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).maxObjectCount;
       (yyval.xtokOpenEnumInstances).filterQuery=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).filterQuery;
       (yyval.xtokOpenEnumInstances).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParmsList).filterQueryLang;

       setRequest(parm,&(yyval.xtokOpenEnumInstances),sizeof((yyval.xtokOpenEnumInstances)),(yyval.xtokOpenEnumInstances).op.type);
       buildOpenEnumInstanceRequest(parm);
    }
    break;

  case 298:

/* Line 1806 of yacc.c  */
#line 4814 "cimXmlOps.y"
    {
       (yyval.xtokOpenEnumInstancesParmsList).flags=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).flags;
       (yyval.xtokOpenEnumInstancesParmsList).flagsSet=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).className) (yyval.xtokOpenEnumInstancesParmsList).className=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).className;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).propertyList.values) {
          (yyval.xtokOpenEnumInstancesParmsList).propertyList=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).propertyList;
          (yyval.xtokOpenEnumInstancesParmsList).properties=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).properties;
       }
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).operationTimeout) (yyval.xtokOpenEnumInstancesParmsList).operationTimeout=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).operationTimeout;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).maxObjectCount) (yyval.xtokOpenEnumInstancesParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).filterQuery) (yyval.xtokOpenEnumInstancesParmsList).filterQuery=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).filterQuery;
       if ((yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).filterQueryLang) (yyval.xtokOpenEnumInstancesParmsList).filterQueryLang=(yyvsp[(1) - (1)].xtokOpenEnumInstancesParms).filterQueryLang;
    }
    break;

  case 299:

/* Line 1806 of yacc.c  */
#line 4828 "cimXmlOps.y"
    {
       (yyval.xtokOpenEnumInstancesParmsList).flags=(yyvsp[(1) - (2)].xtokOpenEnumInstancesParmsList).flags|(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).flags;
       (yyval.xtokOpenEnumInstancesParmsList).flagsSet=(yyvsp[(1) - (2)].xtokOpenEnumInstancesParmsList).flagsSet|(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).className) (yyval.xtokOpenEnumInstancesParmsList).className=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).className;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).propertyList.values) {
          (yyval.xtokOpenEnumInstancesParmsList).propertyList=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).propertyList;
          (yyval.xtokOpenEnumInstancesParmsList).properties=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).properties;
       }
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).operationTimeout) (yyval.xtokOpenEnumInstancesParmsList).operationTimeout=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).operationTimeout;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).maxObjectCount) (yyval.xtokOpenEnumInstancesParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).filterQuery) (yyval.xtokOpenEnumInstancesParmsList).filterQuery=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).filterQuery;
       if ((yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).filterQueryLang) (yyval.xtokOpenEnumInstancesParmsList).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenEnumInstancesParms).filterQueryLang;
    }
    break;

  case 300:

/* Line 1806 of yacc.c  */
#line 4845 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).className = (yyvsp[(2) - (3)].className);
    }
    break;

  case 301:

/* Line 1806 of yacc.c  */
#line 4850 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_localOnly : 0 ;
       (yyval.xtokOpenEnumInstancesParms).flagsSet = FL_localOnly;
    }
    break;

  case 302:

/* Line 1806 of yacc.c  */
#line 4856 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 303:

/* Line 1806 of yacc.c  */
#line 4860 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokOpenEnumInstancesParms).flagsSet = FL_includeQualifiers;
    }
    break;

  case 304:

/* Line 1806 of yacc.c  */
#line 4866 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 305:

/* Line 1806 of yacc.c  */
#line 4870 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_deepInheritance : 0 ;
       (yyval.xtokOpenEnumInstancesParms).flagsSet = FL_deepInheritance;
    }
    break;

  case 306:

/* Line 1806 of yacc.c  */
#line 4876 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 307:

/* Line 1806 of yacc.c  */
#line 4880 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokOpenEnumInstancesParms).flagsSet = FL_includeClassOrigin;
    }
    break;

  case 308:

/* Line 1806 of yacc.c  */
#line 4886 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 309:

/* Line 1806 of yacc.c  */
#line 4890 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokOpenEnumInstancesParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
    }
    break;

  case 310:

/* Line 1806 of yacc.c  */
#line 4896 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 311:

/* Line 1806 of yacc.c  */
#line 4900 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_continueOnError : 0 ;
       (yyval.xtokOpenEnumInstancesParms).flagsSet = FL_continueOnError;
    }
    break;

  case 312:

/* Line 1806 of yacc.c  */
#line 4906 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 313:

/* Line 1806 of yacc.c  */
#line 4910 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).operationTimeout=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 314:

/* Line 1806 of yacc.c  */
#line 4915 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 315:

/* Line 1806 of yacc.c  */
#line 4919 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 316:

/* Line 1806 of yacc.c  */
#line 4924 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 317:

/* Line 1806 of yacc.c  */
#line 4928 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).filterQuery=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 318:

/* Line 1806 of yacc.c  */
#line 4933 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 319:

/* Line 1806 of yacc.c  */
#line 4937 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
       (yyval.xtokOpenEnumInstancesParms).filterQueryLang=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 320:

/* Line 1806 of yacc.c  */
#line 4942 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenEnumInstancesParms), 0, sizeof((yyval.xtokOpenEnumInstancesParms)));
    }
    break;

  case 321:

/* Line 1806 of yacc.c  */
#line 4954 "cimXmlOps.y"
    {
       (yyval.xtokOpenAssociatorInstancePaths).op.count = AIN_REQ_REG_SEGMENTS;
       (yyval.xtokOpenAssociatorInstancePaths).op.type = OPS_OpenAssociatorInstancePaths;
       (yyval.xtokOpenAssociatorInstancePaths).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokOpenAssociatorInstancePaths).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstancePaths).op.assocClass=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstancePaths).op.resultClass=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstancePaths).op.role=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstancePaths).op.resultRole=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstancePaths).objNameSet = 0;
       // TODO what initialization needs to be done here?
       //$$.flags = FL_localOnly | FL_deepInheritance;

       setRequest(parm,&(yyval.xtokOpenAssociatorInstancePaths),sizeof((yyval.xtokOpenAssociatorInstancePaths)),(yyval.xtokOpenAssociatorInstancePaths).op.type);
       buildAssociatorNamesRequest(parm);  // TODO
    }
    break;

  case 322:

/* Line 1806 of yacc.c  */
#line 4971 "cimXmlOps.y"
    {
       (yyval.xtokOpenAssociatorInstancePaths).op.count = AIN_REQ_REG_SEGMENTS;
       (yyval.xtokOpenAssociatorInstancePaths).op.type = OPS_OpenAssociatorInstancePaths;
       (yyval.xtokOpenAssociatorInstancePaths).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokOpenAssociatorInstancePaths).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).objectName.className);
       (yyval.xtokOpenAssociatorInstancePaths).op.assocClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).assocClass);
       (yyval.xtokOpenAssociatorInstancePaths).op.resultClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).resultClass);
       (yyval.xtokOpenAssociatorInstancePaths).op.role=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).role);
       (yyval.xtokOpenAssociatorInstancePaths).op.resultRole=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).resultRole);
       (yyval.xtokOpenAssociatorInstancePaths).objectName = (yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).objectName;
       (yyval.xtokOpenAssociatorInstancePaths).objNameSet = (yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).objNameSet;
       (yyval.xtokOpenAssociatorInstancePaths).flags = ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).flags & (yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).flagsSet) & (FL_localOnly));
       (yyval.xtokOpenAssociatorInstancePaths).operationTimeout=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).operationTimeout;
       (yyval.xtokOpenAssociatorInstancePaths).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).maxObjectCount;
       (yyval.xtokOpenAssociatorInstancePaths).filterQuery=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).filterQuery;
       (yyval.xtokOpenAssociatorInstancePaths).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParmsList).filterQueryLang;

       setRequest(parm,&(yyval.xtokOpenAssociatorInstancePaths),sizeof((yyval.xtokOpenAssociatorInstancePaths)),(yyval.xtokOpenAssociatorInstancePaths).op.type);
       buildAssociatorNamesRequest(parm);  // TODO
    }
    break;

  case 323:

/* Line 1806 of yacc.c  */
#line 4995 "cimXmlOps.y"
    {
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).objNameSet)  {
          (yyval.xtokOpenAssociatorInstancePathsParmsList).objectName=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).objectName;
          (yyval.xtokOpenAssociatorInstancePathsParmsList).objNameSet=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).objNameSet;
       }
       (yyval.xtokOpenAssociatorInstancePathsParmsList).assocClass=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).assocClass;
       (yyval.xtokOpenAssociatorInstancePathsParmsList).resultClass=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).resultClass;
       (yyval.xtokOpenAssociatorInstancePathsParmsList).role=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).role;
       (yyval.xtokOpenAssociatorInstancePathsParmsList).resultRole=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).resultRole;
       (yyval.xtokOpenAssociatorInstancePathsParmsList).flags=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).flags;
       (yyval.xtokOpenAssociatorInstancePathsParmsList).flagsSet=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).operationTimeout) (yyval.xtokOpenAssociatorInstancePathsParmsList).operationTimeout=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).operationTimeout;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).maxObjectCount) (yyval.xtokOpenAssociatorInstancePathsParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).filterQuery) (yyval.xtokOpenAssociatorInstancePathsParmsList).filterQuery=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).filterQuery;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).filterQueryLang) (yyval.xtokOpenAssociatorInstancePathsParmsList).filterQueryLang=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancePathsParms).filterQueryLang;
    }
    break;

  case 324:

/* Line 1806 of yacc.c  */
#line 5012 "cimXmlOps.y"
    {
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).assocClass) (yyval.xtokOpenAssociatorInstancePathsParmsList).assocClass=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).assocClass;
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).resultClass) (yyval.xtokOpenAssociatorInstancePathsParmsList).resultClass=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).resultClass;
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).role) (yyval.xtokOpenAssociatorInstancePathsParmsList).role=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).role;
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).resultRole) (yyval.xtokOpenAssociatorInstancePathsParmsList).resultRole=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).resultRole;
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).objNameSet) {
          (yyval.xtokOpenAssociatorInstancePathsParmsList).objectName=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).objectName;
          (yyval.xtokOpenAssociatorInstancePathsParmsList).objNameSet=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).objNameSet;
       }
       (yyval.xtokOpenAssociatorInstancePathsParmsList).flags=(yyvsp[(1) - (2)].xtokOpenAssociatorInstancePathsParmsList).flags|(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).flags;
       (yyval.xtokOpenAssociatorInstancePathsParmsList).flagsSet=(yyvsp[(1) - (2)].xtokOpenAssociatorInstancePathsParmsList).flagsSet|(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).operationTimeout) (yyval.xtokOpenAssociatorInstancePathsParmsList).operationTimeout=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).operationTimeout;
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).maxObjectCount) (yyval.xtokOpenAssociatorInstancePathsParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).filterQuery) (yyval.xtokOpenAssociatorInstancePathsParmsList).filterQuery=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).filterQuery;
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).filterQueryLang) (yyval.xtokOpenAssociatorInstancePathsParmsList).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancePathsParms).filterQueryLang;
    }
    break;

  case 325:

/* Line 1806 of yacc.c  */
#line 5032 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).objectName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokOpenAssociatorInstancePathsParms).objNameSet = 1;
    }
    break;

  case 326:

/* Line 1806 of yacc.c  */
#line 5038 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).assocClass = (yyvsp[(2) - (3)].className);
    }
    break;

  case 327:

/* Line 1806 of yacc.c  */
#line 5043 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 328:

/* Line 1806 of yacc.c  */
#line 5047 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).resultClass = (yyvsp[(2) - (3)].className);
    }
    break;

  case 329:

/* Line 1806 of yacc.c  */
#line 5052 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 330:

/* Line 1806 of yacc.c  */
#line 5056 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).role = (yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 331:

/* Line 1806 of yacc.c  */
#line 5061 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 332:

/* Line 1806 of yacc.c  */
#line 5065 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).resultRole = (yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 333:

/* Line 1806 of yacc.c  */
#line 5070 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 334:

/* Line 1806 of yacc.c  */
#line 5074 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_continueOnError : 0 ;
       (yyval.xtokOpenAssociatorInstancePathsParms).flagsSet = FL_continueOnError;
    }
    break;

  case 335:

/* Line 1806 of yacc.c  */
#line 5080 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 336:

/* Line 1806 of yacc.c  */
#line 5084 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).operationTimeout=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 337:

/* Line 1806 of yacc.c  */
#line 5089 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 338:

/* Line 1806 of yacc.c  */
#line 5093 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 339:

/* Line 1806 of yacc.c  */
#line 5098 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 340:

/* Line 1806 of yacc.c  */
#line 5102 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).filterQuery=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 341:

/* Line 1806 of yacc.c  */
#line 5107 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 342:

/* Line 1806 of yacc.c  */
#line 5111 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
       (yyval.xtokOpenAssociatorInstancePathsParms).filterQueryLang=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 343:

/* Line 1806 of yacc.c  */
#line 5116 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancePathsParms), 0, sizeof((yyval.xtokOpenAssociatorInstancePathsParms)));
    }
    break;

  case 344:

/* Line 1806 of yacc.c  */
#line 5128 "cimXmlOps.y"
    {
       (yyval.xtokOpenAssociatorInstances).op.count = AI_REQ_REG_SEGMENTS;
       (yyval.xtokOpenAssociatorInstances).op.type = OPS_OpenAssociatorInstances;
       (yyval.xtokOpenAssociatorInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokOpenAssociatorInstances).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstances).op.assocClass=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstances).op.resultClass=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstances).op.role=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstances).op.resultRole=setCharsMsgSegment(NULL);
       (yyval.xtokOpenAssociatorInstances).flags = 0;
       (yyval.xtokOpenAssociatorInstances).objNameSet = 0;
       (yyval.xtokOpenAssociatorInstances).propertyList.values = 0;
       (yyval.xtokOpenAssociatorInstances).properties=0;

       setRequest(parm,&(yyval.xtokOpenAssociatorInstances),sizeof((yyval.xtokOpenAssociatorInstances)),(yyval.xtokOpenAssociatorInstances).op.type);
       buildAssociatorsRequest(parm);  // TODO
    }
    break;

  case 345:

/* Line 1806 of yacc.c  */
#line 5146 "cimXmlOps.y"
    {
       (yyval.xtokOpenAssociatorInstances).op.count = AI_REQ_REG_SEGMENTS;
       (yyval.xtokOpenAssociatorInstances).op.type = OPS_OpenAssociatorInstances;
       (yyval.xtokOpenAssociatorInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokOpenAssociatorInstances).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).objectName.className);
       (yyval.xtokOpenAssociatorInstances).op.assocClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).assocClass);
       (yyval.xtokOpenAssociatorInstances).op.resultClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).resultClass);
       (yyval.xtokOpenAssociatorInstances).op.role=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).role);
       (yyval.xtokOpenAssociatorInstances).op.resultRole=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).resultRole);
       (yyval.xtokOpenAssociatorInstances).flags = ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).flags & (yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).flagsSet) | (~(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).flagsSet & 0);
       (yyval.xtokOpenAssociatorInstances).objectName = (yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).objectName;
       (yyval.xtokOpenAssociatorInstances).objNameSet = (yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).objNameSet;
       (yyval.xtokOpenAssociatorInstances).propertyList = (yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).propertyList;
       (yyval.xtokOpenAssociatorInstances).properties=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).properties;
       (yyval.xtokOpenAssociatorInstances).operationTimeout=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).operationTimeout;
       (yyval.xtokOpenAssociatorInstances).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).maxObjectCount;
       (yyval.xtokOpenAssociatorInstances).filterQuery=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).filterQuery;
       (yyval.xtokOpenAssociatorInstances).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParmsList).filterQueryLang;

       setRequest(parm,&(yyval.xtokOpenAssociatorInstances),sizeof((yyval.xtokOpenAssociatorInstances)),(yyval.xtokOpenAssociatorInstances).op.type);
       buildAssociatorsRequest(parm);  // TODO
    }
    break;

  case 346:

/* Line 1806 of yacc.c  */
#line 5172 "cimXmlOps.y"
    {
       (yyval.xtokOpenAssociatorInstancesParmsList).flags=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).flags;
       (yyval.xtokOpenAssociatorInstancesParmsList).flagsSet=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).objNameSet)  {
          (yyval.xtokOpenAssociatorInstancesParmsList).objectName=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).objectName;
          (yyval.xtokOpenAssociatorInstancesParmsList).objNameSet = (yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).objNameSet;
       }
       (yyval.xtokOpenAssociatorInstancesParmsList).assocClass=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).assocClass;
       (yyval.xtokOpenAssociatorInstancesParmsList).resultClass=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).resultClass;
       (yyval.xtokOpenAssociatorInstancesParmsList).role=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).role;
       (yyval.xtokOpenAssociatorInstancesParmsList).resultRole=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).resultRole;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).propertyList.values) {
          (yyval.xtokOpenAssociatorInstancesParmsList).propertyList=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).propertyList;
          (yyval.xtokOpenAssociatorInstancesParmsList).properties=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).properties;
       }
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).operationTimeout) (yyval.xtokOpenAssociatorInstancesParmsList).operationTimeout=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).operationTimeout;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).maxObjectCount) (yyval.xtokOpenAssociatorInstancesParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).filterQuery) (yyval.xtokOpenAssociatorInstancesParmsList).filterQuery=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).filterQuery;
       if ((yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).filterQueryLang) (yyval.xtokOpenAssociatorInstancesParmsList).filterQueryLang=(yyvsp[(1) - (1)].xtokOpenAssociatorInstancesParms).filterQueryLang;
    }
    break;

  case 347:

/* Line 1806 of yacc.c  */
#line 5193 "cimXmlOps.y"
    {
       (yyval.xtokOpenAssociatorInstancesParmsList).flags=(yyvsp[(1) - (2)].xtokOpenAssociatorInstancesParmsList).flags|(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).flags;
       (yyval.xtokOpenAssociatorInstancesParmsList).flagsSet=(yyvsp[(1) - (2)].xtokOpenAssociatorInstancesParmsList).flagsSet|(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).assocClass) (yyval.xtokOpenAssociatorInstancesParmsList).assocClass=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).assocClass;
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).resultClass) (yyval.xtokOpenAssociatorInstancesParmsList).resultClass=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).resultClass;
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).role) (yyval.xtokOpenAssociatorInstancesParmsList).role=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).role;
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).resultRole) (yyval.xtokOpenAssociatorInstancesParmsList).resultRole=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).resultRole;
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).objNameSet) {
          (yyval.xtokOpenAssociatorInstancesParmsList).objectName=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).objectName;
          (yyval.xtokOpenAssociatorInstancesParmsList).objNameSet=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).objNameSet;
       }
       else if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).propertyList.values) {
          (yyval.xtokOpenAssociatorInstancesParmsList).propertyList=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).propertyList;
          (yyval.xtokOpenAssociatorInstancesParmsList).properties=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).properties;
       }
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).operationTimeout) (yyval.xtokOpenAssociatorInstancesParmsList).operationTimeout=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).operationTimeout;
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).maxObjectCount) (yyval.xtokOpenAssociatorInstancesParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).filterQuery) (yyval.xtokOpenAssociatorInstancesParmsList).filterQuery=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).filterQuery;
       if ((yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).filterQueryLang) (yyval.xtokOpenAssociatorInstancesParmsList).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenAssociatorInstancesParms).filterQueryLang;
    }
    break;

  case 348:

/* Line 1806 of yacc.c  */
#line 5217 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).objectName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokOpenAssociatorInstancesParms).objNameSet = 1;
    }
    break;

  case 349:

/* Line 1806 of yacc.c  */
#line 5223 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).assocClass = (yyvsp[(2) - (3)].className);
    }
    break;

  case 350:

/* Line 1806 of yacc.c  */
#line 5228 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 351:

/* Line 1806 of yacc.c  */
#line 5232 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).resultClass = (yyvsp[(2) - (3)].className);
    }
    break;

  case 352:

/* Line 1806 of yacc.c  */
#line 5237 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 353:

/* Line 1806 of yacc.c  */
#line 5241 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).role = (yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 354:

/* Line 1806 of yacc.c  */
#line 5246 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 355:

/* Line 1806 of yacc.c  */
#line 5250 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).resultRole = (yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 356:

/* Line 1806 of yacc.c  */
#line 5255 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 357:

/* Line 1806 of yacc.c  */
#line 5259 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokOpenAssociatorInstancesParms).flagsSet = FL_includeQualifiers;
    }
    break;

  case 358:

/* Line 1806 of yacc.c  */
#line 5265 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 359:

/* Line 1806 of yacc.c  */
#line 5269 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokOpenAssociatorInstancesParms).flagsSet = FL_includeClassOrigin;
    }
    break;

  case 360:

/* Line 1806 of yacc.c  */
#line 5275 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 361:

/* Line 1806 of yacc.c  */
#line 5279 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokOpenAssociatorInstancesParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
    }
    break;

  case 362:

/* Line 1806 of yacc.c  */
#line 5285 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 363:

/* Line 1806 of yacc.c  */
#line 5289 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_continueOnError : 0 ;
       (yyval.xtokOpenAssociatorInstancesParms).flagsSet = FL_continueOnError;
    }
    break;

  case 364:

/* Line 1806 of yacc.c  */
#line 5295 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 365:

/* Line 1806 of yacc.c  */
#line 5299 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).operationTimeout=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 366:

/* Line 1806 of yacc.c  */
#line 5304 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 367:

/* Line 1806 of yacc.c  */
#line 5308 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 368:

/* Line 1806 of yacc.c  */
#line 5313 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 369:

/* Line 1806 of yacc.c  */
#line 5317 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).filterQuery=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 370:

/* Line 1806 of yacc.c  */
#line 5322 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 371:

/* Line 1806 of yacc.c  */
#line 5326 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
       (yyval.xtokOpenAssociatorInstancesParms).filterQueryLang=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 372:

/* Line 1806 of yacc.c  */
#line 5331 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenAssociatorInstancesParms), 0, sizeof((yyval.xtokOpenAssociatorInstancesParms)));
    }
    break;

  case 373:

/* Line 1806 of yacc.c  */
#line 5343 "cimXmlOps.y"
    {
       (yyval.xtokOpenReferenceInstancePaths).op.count = RIN_REQ_REG_SEGMENTS;
       (yyval.xtokOpenReferenceInstancePaths).op.type = OPS_OpenReferenceInstancePaths;
       (yyval.xtokOpenReferenceInstancePaths).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokOpenReferenceInstancePaths).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokOpenReferenceInstancePaths).op.resultClass=setCharsMsgSegment(NULL);
       (yyval.xtokOpenReferenceInstancePaths).op.role=setCharsMsgSegment(NULL);
       (yyval.xtokOpenReferenceInstancePaths).objNameSet=0;
       // TODO what initialization needs to be done here?
       //$$.flags = FL_localOnly | FL_deepInheritance;

       setRequest(parm,&(yyval.xtokOpenReferenceInstancePaths),sizeof((yyval.xtokOpenReferenceInstancePaths)),(yyval.xtokOpenReferenceInstancePaths).op.type);
       buildReferenceNamesRequest(parm);  // TODO
    }
    break;

  case 374:

/* Line 1806 of yacc.c  */
#line 5358 "cimXmlOps.y"
    {
       (yyval.xtokOpenReferenceInstancePaths).op.count = RIN_REQ_REG_SEGMENTS;
       (yyval.xtokOpenReferenceInstancePaths).op.type = OPS_OpenReferenceInstancePaths;
       (yyval.xtokOpenReferenceInstancePaths).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokOpenReferenceInstancePaths).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).objectName.className);
       (yyval.xtokOpenReferenceInstancePaths).op.resultClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).resultClass);
       (yyval.xtokOpenReferenceInstancePaths).op.role=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).role);
       (yyval.xtokOpenReferenceInstancePaths).objectName=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).objectName;
       (yyval.xtokOpenReferenceInstancePaths).objNameSet=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).objNameSet;
       (yyval.xtokOpenReferenceInstancePaths).flags = ((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).flags & (yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).flagsSet) & (FL_localOnly));
       (yyval.xtokOpenReferenceInstancePaths).operationTimeout=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).operationTimeout;
       (yyval.xtokOpenReferenceInstancePaths).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).maxObjectCount;
       (yyval.xtokOpenReferenceInstancePaths).filterQuery=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).filterQuery;
       (yyval.xtokOpenReferenceInstancePaths).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParmsList).filterQueryLang;

       setRequest(parm,&(yyval.xtokOpenReferenceInstancePaths),sizeof((yyval.xtokOpenReferenceInstancePaths)),(yyval.xtokOpenReferenceInstancePaths).op.type);
       buildReferenceNamesRequest(parm);  // TODO
    }
    break;

  case 375:

/* Line 1806 of yacc.c  */
#line 5380 "cimXmlOps.y"
    {
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).objNameSet)  {
          (yyval.xtokOpenReferenceInstancePathsParmsList).objectName=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).objectName;
          (yyval.xtokOpenReferenceInstancePathsParmsList).objNameSet=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).objNameSet;
       }
       (yyval.xtokOpenReferenceInstancePathsParmsList).resultClass=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).resultClass;
       (yyval.xtokOpenReferenceInstancePathsParmsList).role=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).role;
       (yyval.xtokOpenReferenceInstancePathsParmsList).flags=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).flags;
       (yyval.xtokOpenReferenceInstancePathsParmsList).flagsSet=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).operationTimeout) (yyval.xtokOpenReferenceInstancePathsParmsList).operationTimeout=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).operationTimeout;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).maxObjectCount) (yyval.xtokOpenReferenceInstancePathsParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).filterQuery) (yyval.xtokOpenReferenceInstancePathsParmsList).filterQuery=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).filterQuery;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).filterQueryLang) (yyval.xtokOpenReferenceInstancePathsParmsList).filterQueryLang=(yyvsp[(1) - (1)].xtokOpenReferenceInstancePathsParms).filterQueryLang;
    }
    break;

  case 376:

/* Line 1806 of yacc.c  */
#line 5395 "cimXmlOps.y"
    {
       if((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).objNameSet) {
          (yyval.xtokOpenReferenceInstancePathsParmsList).objectName=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).objectName;
          (yyval.xtokOpenReferenceInstancePathsParmsList).objNameSet=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).objNameSet;
       }
       else if((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).resultClass) (yyval.xtokOpenReferenceInstancePathsParmsList).resultClass=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).resultClass;
       else if((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).role) (yyval.xtokOpenReferenceInstancePathsParmsList).role=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).role;
       (yyval.xtokOpenReferenceInstancePathsParmsList).flags=(yyvsp[(1) - (2)].xtokOpenReferenceInstancePathsParmsList).flags|(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).flags;
       (yyval.xtokOpenReferenceInstancePathsParmsList).flagsSet=(yyvsp[(1) - (2)].xtokOpenReferenceInstancePathsParmsList).flagsSet|(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).operationTimeout) (yyval.xtokOpenReferenceInstancePathsParmsList).operationTimeout=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).operationTimeout;
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).maxObjectCount) (yyval.xtokOpenReferenceInstancePathsParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).filterQuery) (yyval.xtokOpenReferenceInstancePathsParmsList).filterQuery=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).filterQuery;
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).filterQueryLang) (yyval.xtokOpenReferenceInstancePathsParmsList).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenReferenceInstancePathsParms).filterQueryLang;
    }
    break;

  case 377:

/* Line 1806 of yacc.c  */
#line 5413 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
       (yyval.xtokOpenReferenceInstancePathsParms).objectName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokOpenReferenceInstancePathsParms).objNameSet = 1;
    }
    break;

  case 378:

/* Line 1806 of yacc.c  */
#line 5419 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
       (yyval.xtokOpenReferenceInstancePathsParms).resultClass = (yyvsp[(2) - (3)].className);
    }
    break;

  case 379:

/* Line 1806 of yacc.c  */
#line 5424 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
    }
    break;

  case 380:

/* Line 1806 of yacc.c  */
#line 5428 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
       (yyval.xtokOpenReferenceInstancePathsParms).role = (yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 381:

/* Line 1806 of yacc.c  */
#line 5433 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
    }
    break;

  case 382:

/* Line 1806 of yacc.c  */
#line 5437 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
       (yyval.xtokOpenReferenceInstancePathsParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_continueOnError : 0 ;
       (yyval.xtokOpenReferenceInstancePathsParms).flagsSet = FL_continueOnError;
    }
    break;

  case 383:

/* Line 1806 of yacc.c  */
#line 5443 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
    }
    break;

  case 384:

/* Line 1806 of yacc.c  */
#line 5447 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
       (yyval.xtokOpenReferenceInstancePathsParms).operationTimeout=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 385:

/* Line 1806 of yacc.c  */
#line 5452 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
    }
    break;

  case 386:

/* Line 1806 of yacc.c  */
#line 5456 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
       (yyval.xtokOpenReferenceInstancePathsParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 387:

/* Line 1806 of yacc.c  */
#line 5461 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
    }
    break;

  case 388:

/* Line 1806 of yacc.c  */
#line 5465 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
       (yyval.xtokOpenReferenceInstancePathsParms).filterQuery=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 389:

/* Line 1806 of yacc.c  */
#line 5470 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
    }
    break;

  case 390:

/* Line 1806 of yacc.c  */
#line 5474 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
       (yyval.xtokOpenReferenceInstancePathsParms).filterQueryLang=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 391:

/* Line 1806 of yacc.c  */
#line 5479 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancePathsParms), 0, sizeof((yyval.xtokOpenReferenceInstancePathsParms)));
    }
    break;

  case 392:

/* Line 1806 of yacc.c  */
#line 5491 "cimXmlOps.y"
    {
       (yyval.xtokOpenReferenceInstances).op.count = RI_REQ_REG_SEGMENTS;
       (yyval.xtokOpenReferenceInstances).op.type = OPS_OpenReferenceInstances;
       (yyval.xtokOpenReferenceInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokOpenReferenceInstances).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokOpenReferenceInstances).op.resultClass=setCharsMsgSegment(NULL);
       (yyval.xtokOpenReferenceInstances).op.role=setCharsMsgSegment(NULL);
       (yyval.xtokOpenReferenceInstances).flags = 0;
       (yyval.xtokOpenReferenceInstances).objNameSet = 0;
       (yyval.xtokOpenReferenceInstances).propertyList.values = 0;
       (yyval.xtokOpenReferenceInstances).properties=0;

       setRequest(parm,&(yyval.xtokOpenReferenceInstances),sizeof((yyval.xtokOpenReferenceInstances)),(yyval.xtokOpenReferenceInstances).op.type);
       buildReferencesRequest(parm);  // TODO
    }
    break;

  case 393:

/* Line 1806 of yacc.c  */
#line 5507 "cimXmlOps.y"
    {
       (yyval.xtokOpenReferenceInstances).op.count = RI_REQ_REG_SEGMENTS;
       (yyval.xtokOpenReferenceInstances).op.type = OPS_OpenReferenceInstances;
       (yyval.xtokOpenReferenceInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokOpenReferenceInstances).op.className=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).objectName.className);
       (yyval.xtokOpenReferenceInstances).op.resultClass=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).resultClass);
       (yyval.xtokOpenReferenceInstances).op.role=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).role);
       (yyval.xtokOpenReferenceInstances).flags = ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).flags & (yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).flagsSet) | (~(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).flagsSet & 0);
       (yyval.xtokOpenReferenceInstances).objectName = (yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).objectName;
       (yyval.xtokOpenReferenceInstances).objNameSet = (yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).objNameSet;
       (yyval.xtokOpenReferenceInstances).propertyList = (yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).propertyList;
       (yyval.xtokOpenReferenceInstances).properties=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).properties;
       (yyval.xtokOpenReferenceInstances).operationTimeout=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).operationTimeout;
       (yyval.xtokOpenReferenceInstances).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).maxObjectCount;
       (yyval.xtokOpenReferenceInstances).filterQuery=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).filterQuery;
       (yyval.xtokOpenReferenceInstances).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParmsList).filterQueryLang;

       setRequest(parm,&(yyval.xtokOpenReferenceInstances),sizeof((yyval.xtokOpenReferenceInstances)),(yyval.xtokOpenReferenceInstances).op.type);
       buildReferencesRequest(parm);  // TODO
    }
    break;

  case 394:

/* Line 1806 of yacc.c  */
#line 5531 "cimXmlOps.y"
    {
       (yyval.xtokOpenReferenceInstancesParmsList).flags=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).flags;
       (yyval.xtokOpenReferenceInstancesParmsList).flagsSet=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).objNameSet)  {
          (yyval.xtokOpenReferenceInstancesParmsList).objectName=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).objectName;
          (yyval.xtokOpenReferenceInstancesParmsList).objNameSet = (yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).objNameSet;
       }
       (yyval.xtokOpenReferenceInstancesParmsList).resultClass=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).resultClass;
       (yyval.xtokOpenReferenceInstancesParmsList).role=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).role;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).propertyList.values) {
          (yyval.xtokOpenReferenceInstancesParmsList).propertyList=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).propertyList;
          (yyval.xtokOpenReferenceInstancesParmsList).properties=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).properties;
       }
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).operationTimeout) (yyval.xtokOpenReferenceInstancesParmsList).operationTimeout=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).operationTimeout;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).maxObjectCount) (yyval.xtokOpenReferenceInstancesParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).filterQuery) (yyval.xtokOpenReferenceInstancesParmsList).filterQuery=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).filterQuery;
       if ((yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).filterQueryLang) (yyval.xtokOpenReferenceInstancesParmsList).filterQueryLang=(yyvsp[(1) - (1)].xtokOpenReferenceInstancesParms).filterQueryLang;
    }
    break;

  case 395:

/* Line 1806 of yacc.c  */
#line 5550 "cimXmlOps.y"
    {
       (yyval.xtokOpenReferenceInstancesParmsList).flags=(yyvsp[(1) - (2)].xtokOpenReferenceInstancesParmsList).flags|(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).flags;
       (yyval.xtokOpenReferenceInstancesParmsList).flagsSet=(yyvsp[(1) - (2)].xtokOpenReferenceInstancesParmsList).flagsSet|(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).resultClass) (yyval.xtokOpenReferenceInstancesParmsList).resultClass=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).resultClass;
       else if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).role) (yyval.xtokOpenReferenceInstancesParmsList).role=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).role;
       else if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).objNameSet) {
          (yyval.xtokOpenReferenceInstancesParmsList).objectName=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).objectName;
          (yyval.xtokOpenReferenceInstancesParmsList).objNameSet=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).objNameSet;
       }
       else if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).propertyList.values) {
          (yyval.xtokOpenReferenceInstancesParmsList).propertyList=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).propertyList;
          (yyval.xtokOpenReferenceInstancesParmsList).properties=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).properties;
       }
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).operationTimeout) (yyval.xtokOpenReferenceInstancesParmsList).operationTimeout=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).operationTimeout;
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).maxObjectCount) (yyval.xtokOpenReferenceInstancesParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).filterQuery) (yyval.xtokOpenReferenceInstancesParmsList).filterQuery=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).filterQuery;
       if ((yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).filterQueryLang) (yyval.xtokOpenReferenceInstancesParmsList).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenReferenceInstancesParms).filterQueryLang;
   }
    break;

  case 396:

/* Line 1806 of yacc.c  */
#line 5572 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).objectName = (yyvsp[(2) - (3)].xtokInstanceName);
       (yyval.xtokOpenReferenceInstancesParms).objNameSet = 1;
    }
    break;

  case 397:

/* Line 1806 of yacc.c  */
#line 5578 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).resultClass = (yyvsp[(2) - (3)].className);
    }
    break;

  case 398:

/* Line 1806 of yacc.c  */
#line 5583 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 399:

/* Line 1806 of yacc.c  */
#line 5587 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).role = (yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 400:

/* Line 1806 of yacc.c  */
#line 5592 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 401:

/* Line 1806 of yacc.c  */
#line 5596 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeQualifiers : 0 ;
       (yyval.xtokOpenReferenceInstancesParms).flagsSet = FL_includeQualifiers;
    }
    break;

  case 402:

/* Line 1806 of yacc.c  */
#line 5602 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 403:

/* Line 1806 of yacc.c  */
#line 5606 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_includeClassOrigin : 0 ;
       (yyval.xtokOpenReferenceInstancesParms).flagsSet = FL_includeClassOrigin;
    }
    break;

  case 404:

/* Line 1806 of yacc.c  */
#line 5612 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 405:

/* Line 1806 of yacc.c  */
#line 5616 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).propertyList=(yyvsp[(2) - (3)].xtokValueArray);
       (yyval.xtokOpenReferenceInstancesParms).properties=(yyvsp[(2) - (3)].xtokValueArray).next;
    }
    break;

  case 406:

/* Line 1806 of yacc.c  */
#line 5622 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 407:

/* Line 1806 of yacc.c  */
#line 5626 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_continueOnError : 0 ;
       (yyval.xtokOpenReferenceInstancesParms).flagsSet = FL_continueOnError;
    }
    break;

  case 408:

/* Line 1806 of yacc.c  */
#line 5632 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 409:

/* Line 1806 of yacc.c  */
#line 5636 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).operationTimeout=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 410:

/* Line 1806 of yacc.c  */
#line 5641 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 411:

/* Line 1806 of yacc.c  */
#line 5645 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 412:

/* Line 1806 of yacc.c  */
#line 5650 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 413:

/* Line 1806 of yacc.c  */
#line 5654 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).filterQuery=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 414:

/* Line 1806 of yacc.c  */
#line 5659 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 415:

/* Line 1806 of yacc.c  */
#line 5663 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
       (yyval.xtokOpenReferenceInstancesParms).filterQueryLang=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 416:

/* Line 1806 of yacc.c  */
#line 5668 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenReferenceInstancesParms), 0, sizeof((yyval.xtokOpenReferenceInstancesParms)));
    }
    break;

  case 417:

/* Line 1806 of yacc.c  */
#line 5680 "cimXmlOps.y"
    {
       (yyval.xtokOpenQueryInstances).op.count = EQ_REQ_REG_SEGMENTS;
       (yyval.xtokOpenQueryInstances).op.type = OPS_OpenQueryInstances;
       (yyval.xtokOpenQueryInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokOpenQueryInstances).op.className=setCharsMsgSegment(NULL);

       setRequest(parm,&(yyval.xtokOpenQueryInstances),sizeof((yyval.xtokOpenQueryInstances)),(yyval.xtokOpenQueryInstances).op.type);
       buildExecQueryRequest(parm);  // TODO
    }
    break;

  case 418:

/* Line 1806 of yacc.c  */
#line 5690 "cimXmlOps.y"
    {
       (yyval.xtokOpenQueryInstances).op.count = EQ_REQ_REG_SEGMENTS;
       (yyval.xtokOpenQueryInstances).op.type = OPS_OpenQueryInstances;
       (yyval.xtokOpenQueryInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokOpenQueryInstances).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokOpenQueryInstances).flags = ((yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).flags & (yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).flagsSet) | ((~(yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).flagsSet) & (FL_localOnly));
       (yyval.xtokOpenQueryInstances).operationTimeout=(yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).operationTimeout;
       (yyval.xtokOpenQueryInstances).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).maxObjectCount;
       (yyval.xtokOpenQueryInstances).filterQuery=(yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).filterQuery;
       (yyval.xtokOpenQueryInstances).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).filterQueryLang;
       (yyval.xtokOpenQueryInstances).op.query=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).filterQuery);
       (yyval.xtokOpenQueryInstances).op.queryLang=setCharsMsgSegment((yyvsp[(2) - (2)].xtokOpenQueryInstancesParmsList).filterQueryLang);

       setRequest(parm,&(yyval.xtokOpenQueryInstances),sizeof((yyval.xtokOpenQueryInstances)),(yyval.xtokOpenQueryInstances).op.type);
       buildExecQueryRequest(parm);  // TODO
    }
    break;

  case 419:

/* Line 1806 of yacc.c  */
#line 5710 "cimXmlOps.y"
    {
       (yyval.xtokOpenQueryInstancesParmsList).flags=(yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).flags;
       (yyval.xtokOpenQueryInstancesParmsList).flagsSet=(yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).flagsSet;
       if ((yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).operationTimeout) (yyval.xtokOpenQueryInstancesParmsList).operationTimeout=(yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).operationTimeout;
       if ((yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).maxObjectCount) (yyval.xtokOpenQueryInstancesParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).filterQuery) (yyval.xtokOpenQueryInstancesParmsList).filterQuery=(yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).filterQuery;
       if ((yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).filterQueryLang) (yyval.xtokOpenQueryInstancesParmsList).filterQueryLang=(yyvsp[(1) - (1)].xtokOpenQueryInstancesParms).filterQueryLang;
    }
    break;

  case 420:

/* Line 1806 of yacc.c  */
#line 5719 "cimXmlOps.y"
    {
       (yyval.xtokOpenQueryInstancesParmsList).flags=(yyvsp[(1) - (2)].xtokOpenQueryInstancesParmsList).flags|(yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).flags;
       (yyval.xtokOpenQueryInstancesParmsList).flagsSet=(yyvsp[(1) - (2)].xtokOpenQueryInstancesParmsList).flagsSet|(yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).flagsSet;
       if ((yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).operationTimeout) (yyval.xtokOpenQueryInstancesParmsList).operationTimeout=(yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).operationTimeout;
       if ((yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).maxObjectCount) (yyval.xtokOpenQueryInstancesParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).filterQuery) (yyval.xtokOpenQueryInstancesParmsList).filterQuery=(yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).filterQuery;
       if ((yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).filterQueryLang) (yyval.xtokOpenQueryInstancesParmsList).filterQueryLang=(yyvsp[(2) - (2)].xtokOpenQueryInstancesParms).filterQueryLang;
    }
    break;

  case 421:

/* Line 1806 of yacc.c  */
#line 5731 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
       (yyval.xtokOpenQueryInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_returnQueryResultClass : 0 ;
       (yyval.xtokOpenQueryInstancesParms).flagsSet = FL_returnQueryResultClass;
    }
    break;

  case 422:

/* Line 1806 of yacc.c  */
#line 5737 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
    }
    break;

  case 423:

/* Line 1806 of yacc.c  */
#line 5741 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
       (yyval.xtokOpenQueryInstancesParms).flags = (yyvsp[(2) - (3)].boolValue) ? FL_continueOnError : 0 ;
       (yyval.xtokOpenQueryInstancesParms).flagsSet = FL_continueOnError;
    }
    break;

  case 424:

/* Line 1806 of yacc.c  */
#line 5747 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
    }
    break;

  case 425:

/* Line 1806 of yacc.c  */
#line 5751 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
       (yyval.xtokOpenQueryInstancesParms).operationTimeout=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 426:

/* Line 1806 of yacc.c  */
#line 5756 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
    }
    break;

  case 427:

/* Line 1806 of yacc.c  */
#line 5760 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
       (yyval.xtokOpenQueryInstancesParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 428:

/* Line 1806 of yacc.c  */
#line 5765 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
    }
    break;

  case 429:

/* Line 1806 of yacc.c  */
#line 5769 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
       (yyval.xtokOpenQueryInstancesParms).filterQuery=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 430:

/* Line 1806 of yacc.c  */
#line 5774 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
    }
    break;

  case 431:

/* Line 1806 of yacc.c  */
#line 5778 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
       (yyval.xtokOpenQueryInstancesParms).filterQueryLang=(yyvsp[(2) - (3)].xtokValue).value;
    }
    break;

  case 432:

/* Line 1806 of yacc.c  */
#line 5783 "cimXmlOps.y"
    {
       memset(&(yyval.xtokOpenQueryInstancesParms), 0, sizeof((yyval.xtokOpenQueryInstancesParms)));
    }
    break;

  case 433:

/* Line 1806 of yacc.c  */
#line 5794 "cimXmlOps.y"
    {
       (yyval.xtokPullInstances).op.count = EI_REQ_REG_SEGMENTS;  // TODO
       (yyval.xtokPullInstances).op.type = OPS_PullInstances;
       (yyval.xtokPullInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokPullInstances).op.className=setCharsMsgSegment(NULL);

       setRequest(parm,&(yyval.xtokPullInstances),sizeof((yyval.xtokPullInstances)),(yyval.xtokPullInstances).op.type);
       buildPullInstancesRequest(parm);
    }
    break;

  case 434:

/* Line 1806 of yacc.c  */
#line 5804 "cimXmlOps.y"
    {
       (yyval.xtokPullInstances).op.count = EI_REQ_REG_SEGMENTS;
       (yyval.xtokPullInstances).op.type = OPS_PullInstances;
       (yyval.xtokPullInstances).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokPullInstances).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokPullInstances).maxObjectCount=(yyvsp[(2) - (2)].xtokPullInstancesParmsList).maxObjectCount;
       (yyval.xtokPullInstances).enumerationContext=(yyvsp[(2) - (2)].xtokPullInstancesParmsList).enumerationContext;

       setRequest(parm,&(yyval.xtokPullInstances),sizeof((yyval.xtokPullInstances)),(yyval.xtokPullInstances).op.type);
       buildPullInstancesRequest(parm);
    }
    break;

  case 435:

/* Line 1806 of yacc.c  */
#line 5819 "cimXmlOps.y"
    {
       if ((yyvsp[(1) - (1)].xtokPullInstancesParms).maxObjectCount) (yyval.xtokPullInstancesParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokPullInstancesParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokPullInstancesParms).enumerationContext) (yyval.xtokPullInstancesParmsList).enumerationContext=(yyvsp[(1) - (1)].xtokPullInstancesParms).enumerationContext;
    }
    break;

  case 436:

/* Line 1806 of yacc.c  */
#line 5824 "cimXmlOps.y"
    {
       if ((yyvsp[(2) - (2)].xtokPullInstancesParms).maxObjectCount) (yyval.xtokPullInstancesParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokPullInstancesParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokPullInstancesParms).enumerationContext) (yyval.xtokPullInstancesParmsList).enumerationContext=(yyvsp[(2) - (2)].xtokPullInstancesParms).enumerationContext;
    }
    break;

  case 437:

/* Line 1806 of yacc.c  */
#line 5832 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancesParms), 0, sizeof((yyval.xtokPullInstancesParms)));
       (yyval.xtokPullInstancesParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 438:

/* Line 1806 of yacc.c  */
#line 5837 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancesParms), 0, sizeof((yyval.xtokPullInstancesParms)));
    }
    break;

  case 439:

/* Line 1806 of yacc.c  */
#line 5841 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancesParms), 0, sizeof((yyval.xtokPullInstancesParms)));
       (yyval.xtokPullInstancesParms).enumerationContext=(yyvsp[(2) - (3)].enumerationContext);
    }
    break;

  case 440:

/* Line 1806 of yacc.c  */
#line 5846 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancesParms), 0, sizeof((yyval.xtokPullInstancesParms)));
    }
    break;

  case 441:

/* Line 1806 of yacc.c  */
#line 5858 "cimXmlOps.y"
    {
       (yyval.xtokPullInstancesWithPath).op.count = EI_REQ_REG_SEGMENTS;  // TODO
       (yyval.xtokPullInstancesWithPath).op.type = OPS_PullInstancesWithPath;
       (yyval.xtokPullInstancesWithPath).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokPullInstancesWithPath).op.className=setCharsMsgSegment(NULL);

       setRequest(parm,&(yyval.xtokPullInstancesWithPath),sizeof((yyval.xtokPullInstancesWithPath)),(yyval.xtokPullInstancesWithPath).op.type);
//     buildPullInstancePathsRequest(parm);
       buildPullInstancesRequest(parm); // TODO  Or maybe this is acceptable...
    }
    break;

  case 442:

/* Line 1806 of yacc.c  */
#line 5869 "cimXmlOps.y"
    {
       (yyval.xtokPullInstancesWithPath).op.count = EI_REQ_REG_SEGMENTS;
       (yyval.xtokPullInstancesWithPath).op.type = OPS_PullInstancesWithPath;
       (yyval.xtokPullInstancesWithPath).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokPullInstancesWithPath).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokPullInstancesWithPath).maxObjectCount=(yyvsp[(2) - (2)].xtokPullInstancesWithPathParmsList).maxObjectCount;
       (yyval.xtokPullInstancesWithPath).enumerationContext=(yyvsp[(2) - (2)].xtokPullInstancesWithPathParmsList).enumerationContext;

       setRequest(parm,&(yyval.xtokPullInstancesWithPath),sizeof((yyval.xtokPullInstancesWithPath)),(yyval.xtokPullInstancesWithPath).op.type);
//     buildPullInstancesWithPathRequest(parm);
       buildPullInstancesRequest(parm);
    }
    break;

  case 443:

/* Line 1806 of yacc.c  */
#line 5885 "cimXmlOps.y"
    {
       if ((yyvsp[(1) - (1)].xtokPullInstancesWithPathParms).maxObjectCount) (yyval.xtokPullInstancesWithPathParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokPullInstancesWithPathParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokPullInstancesWithPathParms).enumerationContext) (yyval.xtokPullInstancesWithPathParmsList).enumerationContext=(yyvsp[(1) - (1)].xtokPullInstancesWithPathParms).enumerationContext;
    }
    break;

  case 444:

/* Line 1806 of yacc.c  */
#line 5890 "cimXmlOps.y"
    {
       if ((yyvsp[(2) - (2)].xtokPullInstancesWithPathParms).maxObjectCount) (yyval.xtokPullInstancesWithPathParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokPullInstancesWithPathParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokPullInstancesWithPathParms).enumerationContext) (yyval.xtokPullInstancesWithPathParmsList).enumerationContext=(yyvsp[(2) - (2)].xtokPullInstancesWithPathParms).enumerationContext;
    }
    break;

  case 445:

/* Line 1806 of yacc.c  */
#line 5898 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancesWithPathParms), 0, sizeof((yyval.xtokPullInstancesWithPathParms)));
       (yyval.xtokPullInstancesWithPathParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 446:

/* Line 1806 of yacc.c  */
#line 5903 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancesWithPathParms), 0, sizeof((yyval.xtokPullInstancesWithPathParms)));
    }
    break;

  case 447:

/* Line 1806 of yacc.c  */
#line 5907 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancesWithPathParms), 0, sizeof((yyval.xtokPullInstancesWithPathParms)));
       (yyval.xtokPullInstancesWithPathParms).enumerationContext=(yyvsp[(2) - (3)].enumerationContext);
    }
    break;

  case 448:

/* Line 1806 of yacc.c  */
#line 5912 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancesWithPathParms), 0, sizeof((yyval.xtokPullInstancesWithPathParms)));
    }
    break;

  case 449:

/* Line 1806 of yacc.c  */
#line 5924 "cimXmlOps.y"
    {
       (yyval.xtokPullInstancePaths).op.count = EI_REQ_REG_SEGMENTS;  // TODO
       (yyval.xtokPullInstancePaths).op.type = OPS_PullInstances;
       (yyval.xtokPullInstancePaths).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (1)].xtokLocalNameSpacePath));
       (yyval.xtokPullInstancePaths).op.className=setCharsMsgSegment(NULL);

       setRequest(parm,&(yyval.xtokPullInstancePaths),sizeof((yyval.xtokPullInstancePaths)),(yyval.xtokPullInstancePaths).op.type);
//     buildPullInstancePathsRequest(parm);
       buildPullInstancesRequest(parm); // TODO  Or maybe this is acceptable...
    }
    break;

  case 450:

/* Line 1806 of yacc.c  */
#line 5935 "cimXmlOps.y"
    {
       (yyval.xtokPullInstancePaths).op.count = EI_REQ_REG_SEGMENTS;
       (yyval.xtokPullInstancePaths).op.type = OPS_PullInstances;
       (yyval.xtokPullInstancePaths).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (2)].xtokLocalNameSpacePath));
       (yyval.xtokPullInstancePaths).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokPullInstancePaths).maxObjectCount=(yyvsp[(2) - (2)].xtokPullInstancePathsParmsList).maxObjectCount;
       (yyval.xtokPullInstancePaths).enumerationContext=(yyvsp[(2) - (2)].xtokPullInstancePathsParmsList).enumerationContext;

       setRequest(parm,&(yyval.xtokPullInstancePaths),sizeof((yyval.xtokPullInstancePaths)),(yyval.xtokPullInstancePaths).op.type);
//     buildPullInstancePathsRequest(parm);
       buildPullInstancesRequest(parm);
    }
    break;

  case 451:

/* Line 1806 of yacc.c  */
#line 5951 "cimXmlOps.y"
    {
       if ((yyvsp[(1) - (1)].xtokPullInstancePathsParms).maxObjectCount) (yyval.xtokPullInstancePathsParmsList).maxObjectCount=(yyvsp[(1) - (1)].xtokPullInstancePathsParms).maxObjectCount;
       if ((yyvsp[(1) - (1)].xtokPullInstancePathsParms).enumerationContext) (yyval.xtokPullInstancePathsParmsList).enumerationContext=(yyvsp[(1) - (1)].xtokPullInstancePathsParms).enumerationContext;
    }
    break;

  case 452:

/* Line 1806 of yacc.c  */
#line 5956 "cimXmlOps.y"
    {
       if ((yyvsp[(2) - (2)].xtokPullInstancePathsParms).maxObjectCount) (yyval.xtokPullInstancePathsParmsList).maxObjectCount=(yyvsp[(2) - (2)].xtokPullInstancePathsParms).maxObjectCount;
       if ((yyvsp[(2) - (2)].xtokPullInstancePathsParms).enumerationContext) (yyval.xtokPullInstancePathsParmsList).enumerationContext=(yyvsp[(2) - (2)].xtokPullInstancePathsParms).enumerationContext;
    }
    break;

  case 453:

/* Line 1806 of yacc.c  */
#line 5964 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancePathsParms), 0, sizeof((yyval.xtokPullInstancePathsParms)));
       (yyval.xtokPullInstancePathsParms).maxObjectCount=atoi((yyvsp[(2) - (3)].xtokValue).value);
    }
    break;

  case 454:

/* Line 1806 of yacc.c  */
#line 5969 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancePathsParms), 0, sizeof((yyval.xtokPullInstancePathsParms)));
    }
    break;

  case 455:

/* Line 1806 of yacc.c  */
#line 5973 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancePathsParms), 0, sizeof((yyval.xtokPullInstancePathsParms)));
       (yyval.xtokPullInstancePathsParms).enumerationContext=(yyvsp[(2) - (3)].enumerationContext);
    }
    break;

  case 456:

/* Line 1806 of yacc.c  */
#line 5978 "cimXmlOps.y"
    {
       memset(&(yyval.xtokPullInstancePathsParms), 0, sizeof((yyval.xtokPullInstancePathsParms)));
    }
    break;

  case 457:

/* Line 1806 of yacc.c  */
#line 5989 "cimXmlOps.y"
    {
       (yyval.xtokCloseEnumeration).op.count = EI_REQ_REG_SEGMENTS;  // TODO
       (yyval.xtokCloseEnumeration).op.type = OPS_CloseEnumeration;
       (yyval.xtokCloseEnumeration).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (4)].xtokLocalNameSpacePath));
       (yyval.xtokCloseEnumeration).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokCloseEnumeration).enumerationContext=(yyvsp[(3) - (4)].enumerationContext);

       setRequest(parm,&(yyval.xtokCloseEnumeration),sizeof((yyval.xtokCloseEnumeration)),(yyval.xtokCloseEnumeration).op.type);
       buildCloseEnumerationRequest(parm);
    }
    break;

  case 458:

/* Line 1806 of yacc.c  */
#line 6007 "cimXmlOps.y"
    {
       (yyval.xtokEnumerationCount).op.count = EI_REQ_REG_SEGMENTS;  // TODO
       (yyval.xtokEnumerationCount).op.type = OPS_EnumerationCount;
       (yyval.xtokEnumerationCount).op.nameSpace=setCharsMsgSegment((yyvsp[(1) - (4)].xtokLocalNameSpacePath));
       (yyval.xtokEnumerationCount).op.className=setCharsMsgSegment(NULL);
       (yyval.xtokEnumerationCount).enumerationContext=(yyvsp[(3) - (4)].enumerationContext);

       setRequest(parm,&(yyval.xtokEnumerationCount),sizeof((yyval.xtokEnumerationCount)),(yyval.xtokEnumerationCount).op.type);
       buildEnumerationCountRequest(parm);
    }
    break;

  case 459:

/* Line 1806 of yacc.c  */
#line 6022 "cimXmlOps.y"
    {
    (yyval.enumerationContext)=atol((yyvsp[(1) - (2)].xtokValue).value); // TODO need some checking here
    }
    break;

  case 460:

/* Line 1806 of yacc.c  */
#line 6029 "cimXmlOps.y"
    {
    }
    break;

  case 461:

/* Line 1806 of yacc.c  */
#line 6041 "cimXmlOps.y"
    {
       (yyval.xtokInstanceName).className=(yyvsp[(1) - (2)].xtokInstanceName).className;
       (yyval.xtokInstanceName).bindings.next=0;
       (yyval.xtokInstanceName).bindings.keyBindings=NULL;
    }
    break;

  case 462:

/* Line 1806 of yacc.c  */
#line 6047 "cimXmlOps.y"
    {
       (yyval.xtokInstanceName).className=(yyvsp[(1) - (3)].xtokInstanceName).className;
       (yyval.xtokInstanceName).bindings=(yyvsp[(2) - (3)].xtokKeyBindings);
    }
    break;

  case 463:

/* Line 1806 of yacc.c  */
#line 6055 "cimXmlOps.y"
    {
       (yyval.xtokKeyBindings).next=1;
       (yyval.xtokKeyBindings).max=KEYBINDING_MAX_START;
       (yyval.xtokKeyBindings).keyBindings=calloc(((yyval.xtokKeyBindings).max),sizeof(XtokKeyBinding));
       (yyval.xtokKeyBindings).keyBindings[0].name=(yyvsp[(1) - (1)].xtokKeyBinding).name;
       (yyval.xtokKeyBindings).keyBindings[0].value=(yyvsp[(1) - (1)].xtokKeyBinding).value;
       (yyval.xtokKeyBindings).keyBindings[0].type=(yyvsp[(1) - (1)].xtokKeyBinding).type;
       (yyval.xtokKeyBindings).keyBindings[0].ref=(yyvsp[(1) - (1)].xtokKeyBinding).ref;
    }
    break;

  case 464:

/* Line 1806 of yacc.c  */
#line 6065 "cimXmlOps.y"
    {
       if ((yyval.xtokKeyBindings).next == (yyval.xtokKeyBindings).max) { /* max was hit; let's bump it up 50% */
         (yyval.xtokKeyBindings).max = (int)((yyval.xtokKeyBindings).max * ((float)3)/2);
         (yyval.xtokKeyBindings).keyBindings=realloc(((yyval.xtokKeyBindings).keyBindings), sizeof(XtokKeyBinding)*((yyval.xtokKeyBindings).max));
       }
       (yyval.xtokKeyBindings).keyBindings[(yyval.xtokKeyBindings).next].name=(yyvsp[(2) - (2)].xtokKeyBinding).name;
       (yyval.xtokKeyBindings).keyBindings[(yyval.xtokKeyBindings).next].value=(yyvsp[(2) - (2)].xtokKeyBinding).value;
       (yyval.xtokKeyBindings).keyBindings[(yyval.xtokKeyBindings).next].type=(yyvsp[(2) - (2)].xtokKeyBinding).type;
       (yyval.xtokKeyBindings).keyBindings[(yyval.xtokKeyBindings).next].ref=(yyvsp[(2) - (2)].xtokKeyBinding).ref;
       (yyval.xtokKeyBindings).next++;
    }
    break;

  case 465:

/* Line 1806 of yacc.c  */
#line 6080 "cimXmlOps.y"
    {
       (yyval.xtokKeyBinding).name=(yyvsp[(1) - (4)].xtokKeyBinding).name;
       (yyval.xtokKeyBinding).value=(yyvsp[(2) - (4)].xtokKeyValue).value;
       (yyval.xtokKeyBinding).type=(yyvsp[(2) - (4)].xtokKeyValue).valueType;
    }
    break;

  case 466:

/* Line 1806 of yacc.c  */
#line 6086 "cimXmlOps.y"
    {
       (yyval.xtokKeyBinding).name=(yyvsp[(1) - (3)].xtokKeyBinding).name;
       (yyval.xtokKeyBinding).value=NULL;
       (yyval.xtokKeyBinding).type="ref";
       (yyval.xtokKeyBinding).ref=(yyvsp[(2) - (3)].xtokValueReference);
    }
    break;



/* Line 1806 of yacc.c  */
#line 10031 "cimXmlOps.c"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (parm, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (parm, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, parm);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, parm);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (parm, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, parm);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, parm);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 2067 of yacc.c  */
#line 6094 "cimXmlOps.y"


