#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Anna's Quest
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240822.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='annas-quest'
GAME_NAME='Anna’s Quest'

ARCHIVE_BASE_1_NAME='anna_s_quest_1_1_0214_27877.sh'
ARCHIVE_BASE_1_MD5='48fd7d6c2a8a519a227cbf604392109b'
ARCHIVE_BASE_1_SIZE='1200000'
ARCHIVE_BASE_1_VERSION='1.1.0214-gog27877'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/annas_quest'

ARCHIVE_BASE_0_NAME='gog_anna_s_quest_2.1.0.3.sh'
ARCHIVE_BASE_0_MD5='cb4cf167a13413b6df8238397393298a'
ARCHIVE_BASE_0_SIZE='1100000'
ARCHIVE_BASE_0_VERSION='1.0.0202-gog2.1.0.3'

VISIONAIRE_NAME='anna'

CONTENT_PATH_DEFAULT='data/noarch/game'

APP_MAIN_ICON='../support/icon.png'

PKG_BIN_ARCH='64'

## Ensure smooth upgrades from packages generated by game scripts pre-20231005.1
PKG_DATA_PROVIDES='
annas-quest-videos'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
