#!/bin/bash

################################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_PCIPortGroup.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_PCIPortGroup provider module";
Name = "PCI_OpenDRIM_PCIPortGroupModule";
Location = "cmpiPCI_OpenDRIM_PCIPortGroupProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_PCIPortGroup provider";
Name = "PCI_OpenDRIM_PCIPortGroupProvider";
ProviderModuleName = "PCI_OpenDRIM_PCIPortGroupModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_PCIPortGroup provider capabilities";
ProviderModuleName = "PCI_OpenDRIM_PCIPortGroupModule";
ProviderName = "PCI_OpenDRIM_PCIPortGroupProvider";
ClassName = "OpenDRIM_PCIPortGroup";
ProviderType = {2};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "ElementName", "InstanceID", "Name", "NameFormat", "OtherNameFormat", "BusNumber"};
CapabilityID = "PCI_OpenDRIM_PCIPortGroup";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_PCIPortGroup.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_PCIPortGroup]   
   provider: PCI_OpenDRIM_PCIPortGroupProvider
   location: cmpiPCI_OpenDRIM_PCIPortGroupProvider
   type: instance
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_PCIPortGroup.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_PCIPortGroup-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_PCIPortGroup.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
