/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PCIESWITCHACCESS_H_
#define OPENDRIM_PCIESWITCHACCESS_H_

#include "PCI_Common.h"

#include "OpenDRIM_PCIeSwitch.h"

int PCI_OpenDRIM_PCIeSwitch_load(const CMPIBroker* broker, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_unload(string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PCIeSwitch>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCIeSwitch_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PCIeSwitch& instance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& newInstance, const OpenDRIM_PCIeSwitch& oldInstance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_RequestStateChange_In& in, OpenDRIM_PCIeSwitch_RequestStateChange_Out& out, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_SetPowerState_In& in, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_EnableDevice_In& in, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_OnlineDevice_In& in, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_QuiesceDevice_In& in, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_BISTExecution(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned char& returnValue, string& errorMessage);

int PCI_OpenDRIM_PCIeSwitch_populate(OpenDRIM_PCIeSwitch& instance, string& errorMessage);

#endif /*OPENDRIM_PCIESWITCHACCESS_H_*/
