/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_MEMBEROFPCICOLLECTIONACCESS_H_
#define OPENDRIM_MEMBEROFPCICOLLECTIONACCESS_H_

#include "PCI_Common.h"

#include "OpenDRIM_MemberOfPCICollection.h"
#include "assocOpenDRIM_MemberOfPCICollection.h"

int PCI_OpenDRIM_MemberOfPCICollection_load(const CMPIBroker* broker, string& errorMessage);

int PCI_OpenDRIM_MemberOfPCICollection_unload(string& errorMessage);

int PCI_OpenDRIM_MemberOfPCICollection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_MemberOfPCICollection>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_MemberOfPCICollection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_MemberOfPCICollection& instance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_MemberOfPCICollection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPCICollection& newInstance, const OpenDRIM_MemberOfPCICollection& oldInstance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_MemberOfPCICollection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPCICollection& instance, string& errorMessage);

int PCI_OpenDRIM_MemberOfPCICollection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPCICollection& instance, string& errorMessage);

int PCI_OpenDRIM_MemberOfPCICollection_associatorMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const char** properties, vector<Instance>& Collection_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_MemberOfPCICollection_associatorCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const char** properties, vector<Instance>& Member_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_MemberOfPCICollection_referenceMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const vector<Instance>& Collection_instances, vector<OpenDRIM_MemberOfPCICollection>& OpenDRIM_MemberOfPCICollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_MemberOfPCICollection_referenceCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const vector<Instance>& Member_instances, vector<OpenDRIM_MemberOfPCICollection>& OpenDRIM_MemberOfPCICollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_MemberOfPCICollection_populate(OpenDRIM_MemberOfPCICollection& instance, string& errorMessage);

#endif /*OPENDRIM_MEMBEROFPCICOLLECTIONACCESS_H_*/
