/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

╨рчЁх°рхЄё  яютЄюЁэюх ЁрёяЁюёЄЁрэхэшх ш шёяюы№чютрэшх ъръ т тшфх шёїюфэюую ъюфр,
Єръ ш т фтюшўэющ ЇюЁьх, ё шчьхэхэш ьш шыш схч, яЁш ёюсы■фхэшш ёыхфє■∙шї єёыютшщ:

      * ╧Ёш яютЄюЁэюь ЁрёяЁюёЄЁрэхэшш шёїюфэюую ъюфр фюыцэ√ юёЄртрЄ№ё  єърчрээюх
        т√°х єтхфюьыхэшх юс ртЄюЁёъюь яЁртх, ¤ЄюЄ ёяшёюъ єёыютшщ ш яюёыхфє■∙шщ
        юЄърч юЄ урЁрэЄшщ.
      * ╧Ёш яютЄюЁэюь ЁрёяЁюёЄЁрэхэшш фтюшўэюую ъюфр т фюъєьхэЄрЎшш ш/шыш т
        фЁєушї ьрЄхЁшрырї, яюёЄрты хь√ї яЁш ЁрёяЁюёЄЁрэхэшш, фюыцэ√ ёюїЁрэ Є№ё 
        єърчрээр  т√°х шэЇюЁьрЎш  юс ртЄюЁёъюь яЁртх, ¤ЄюЄ ёяшёюъ єёыютшщ ш
        яюёыхфє■∙шщ юЄърч юЄ урЁрэЄшщ.
      * ═ш эрчтрэшх Cognitive Technologies, эш шьхэр хх ёюЄЁєфэшъют эх ьюуєЄ
        с√Є№ шёяюы№чютрэ√ т ърўхёЄтх ёЁхфёЄтр яюффхЁцъш ш/шыш яЁюфтшцхэш 
        яЁюфєъЄют, юёэютрээ√ї эр ¤Єюь ╧╬, схч яЁхфтрЁшЄхы№эюую яшё№ьхээюую
        ЁрчЁх°хэш .

▌╥└ ╧╨╬├╨└╠╠└ ╧╨┼─╬╤╥└┬╦┼═└ ┬╦└─┼╦▄╓└╠╚ └┬╥╬╨╤╩╚╒ ╧╨└┬ ╚/╚╦╚ ─╨╙├╚╠╚ ╦╚╓└╠╚ "╩└╩
╬═└ ┼╤╥▄" ┴┼╟ ╩└╩╬├╬-╦╚┴╬ ┬╚─└ ├└╨└═╥╚╔, ┬█╨└╞┼══█╒ ▀┬═╬ ╚╦╚ ╧╬─╨└╟╙╠┼┬└┼╠█╒,
┬╩╦▐╫└▀ ├└╨└═╥╚╚ ╩╬╠╠┼╨╫┼╤╩╬╔ ╓┼══╬╤╥╚ ╚ ╧╨╚├╬─═╬╤╥╚ ─╦▀ ╩╬═╩╨┼╥═╬╔ ╓┼╦╚, ═╬ ═┼
╬├╨└═╚╫╚┬└▀╤▄ ╚╠╚. ═╚ ┬╦└─┼╦┼╓ └┬╥╬╨╤╩╚╒ ╧╨└┬ ╚ ═╚ ╬─═╬ ─╨╙├╬┼ ╦╚╓╬, ╩╬╥╬╨╬┼
╠╬╞┼╥ ╚╟╠┼═▀╥▄ ╚/╚╦╚ ╧╬┬╥╬╨═╬ ╨└╤╧╨╬╤╥╨└═▀╥▄ ╧╨╬├╨└╠╠╙, ═╚ ┬ ╩╬┼╠ ╤╦╙╫└┼ ═┼
═┼╤и╥ ╬╥┬┼╥╤╥┬┼══╬╤╥╚, ┬╩╦▐╫└▀ ╦▐┴█┼ ╬┴┘╚┼, ╤╦╙╫└╔═█┼, ╤╧┼╓╚└╦▄═█┼ ╚╦╚
╧╬╤╦┼─╬┬└┬╪╚┼ ╙┴█╥╩╚, ╤┬▀╟└══█┼ ╤ ╚╤╧╬╦▄╟╬┬└═╚┼╠ ╚╦╚ ╧╬═┼╤┼══█┼ ┬╤╦┼─╤╥┬╚┼
═┼┬╬╟╠╬╞═╬╤╥╚ ╚╤╧╬╦▄╟╬┬└═╚▀ ╧╨╬├╨└╠╠█ (┬╩╦▐╫└▀ ╧╬╥┼╨╚ ─└══█╒, ╚╦╚ ─└══█┼,
╤╥└┬╪╚┼ ═┼├╬─═█╠╚, ╚╦╚ ╙┴█╥╩╚ ╚/╚╦╚ ╧╬╥┼╨╚ ─╬╒╬─╬┬, ╧╬═┼╤┼══█┼ ╚╟-╟└ ─┼╔╤╥┬╚╔
╥╨┼╥▄╚╒ ╦╚╓ ╚/╚╦╚ ╬╥╩└╟└ ╧╨╬├╨└╠╠█ ╨└┴╬╥└╥▄ ╤╬┬╠┼╤╥═╬ ╤ ─╨╙├╚╠╚ ╧╨╬├╨└╠╠└╠╚,
═╬ ═┼ ╬├╨└═╚╫╚┬└▀╤▄ ▌╥╚╠╚ ╤╦╙╫└▀╠╚), ═╬ ═┼ ╬├╨└═╚╫╚┬└▀╤▄ ╚╠╚, ─└╞┼ ┼╤╦╚ ╥└╩╬╔
┬╦└─┼╦┼╓ ╚╦╚ ─╨╙├╬┼ ╦╚╓╬ ┴█╦╚ ╚╟┬┼┘┼═█ ╬ ┬╬╟╠╬╞═╬╤╥╚ ╥└╩╚╒ ╙┴█╥╩╬┬ ╚ ╧╬╥┼╨▄.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>

#include "c_types.h"
#include "msgerr.h"
#include "kernel.h"
#include "face_lng.h"

#if MORDA==LANG_ENGLISH
/*=============	English definitions for error messages ========	*/
#define msg_0_1 "Format error."
#define msg_0_2 "Some of recognition tables cannot be found."
#define msg_0_3 "Debug stop."
#define msg_0_4 "Sorry, DEMO version does not permit scanning."
#define msg_0_5 "Dictionary file(s) for the language not found."

#define msg_1_1  "101. FileSys: No enough memory for components file."
#define msg_1_2  "102. FileSys: No place in the components file."
#define msg_1_3  "103. ExtrComp(an): Main number allocation fail."
#define msg_1_4  "104. ExtrComp(an): Unable to exclude large picture."
#define msg_1_5  "105. FileSys: No place in the roots file."
#define msg_1_6  "106. LinesForming: Not enough memory."
#define msg_1_7	 "107. LinesForming: Unable to count page skew."
#define msg_1_8  "108. LinesForming: Empty page."
#define msg_1_9  "109. ExtrComp(mn): No memory for boxes."
#define msg_1_10 "110. FileSys: No place for strings."
#define msg_1_11 "111. FileSys: No strings have been found."
#define msg_1_12 "112. Tools: No place in the kit."
#define msg_1_13 "113. Main: No memory for working area (1Mb)."
#define msg_1_14 "114. Extrcomp(mn): Image is not a fax 100x200 dpi."
#define msg_1_15 "115. Sweeper: Can't create/open work file TEMP.CMP"
#define msg_1_16 "116. Sweeper: No enough space in work file TEMP.CMP"
#define msg_1_17 "117. Sweeper: Error on reading work file TEMP.CMP"

#define msg_2_1 "201. ScanTiff: Unable to access image."
#define msg_2_2 "202. ScanTiff: Error during image read."
#define msg_2_3 "203. ScanTiff: Contradictory image information."
#define msg_2_4 "204. ScanTiff: Resolution of this image isn't into 100dpi - 800dpi range."
#define msg_2_5 "205. ScanDIB: Unable to access DIB."

#define msg_3_1 "301. Scantiff: group-4 format error."
#define msg_3_2 "302. Put page into scaner."

#define msg_4_1 "401. Spelling: cannot find vocabulary."
#define msg_4_2 "402. Spelling: cannot open dynamic vocabulary."
#define msg_4_3 "403. Spelling: the page has been processed by speller."
#define msg_4_4 "404. Spelling: not enough memory."
#define msg_4_5 "405. Spelling: ed-file is corrupted."
#define msg_4_6 "406. Spelling: no ed_file."
#define msg_4_7 "407. Spelling: postrecognition error."

#define msg_6_1 "601. TextSave: Open error."		// only DOS
#define msg_6_2 "602. TextSave: Write error."
#define msg_6_3 "603. TextSave: Out of memory."
#define msg_6_4 "604. TextSave: Cannot open temporary ED-file."
#define msg_6_5 "605. Lineout: Open error in ED-file."	// Only DOS
#define msg_6_6 "606. Lineout: Read error in ED-file."
#define msg_6_7 "607. Lineout: Empty page."
#define msg_6_8 "608. TextSave: Unuseble coding for this language."
#define msg_6_9 "609. RTF: ED-file is corrupted."
#define msg_6_10 "610. Not used."
#define msg_6_11 "611. Lineout: Write error on ED-file."
#define msg_6_12 "612. Not used."
#define msg_6_13 "613. Not used."
#define msg_6_14 "614. Not used."

#define msg_7_1 "701. Very long path name."
#define msg_7_2 "702. User break."
#define msg_7_3 "703. Cannot connect with user."
#define msg_7_4 "704. Cannot process picture. Picture too big."
#define msg_7_5 "705. Open/read/write file error."
#define msg_7_6 "706. Pass II: Out of memory."
#define msg_7_7 "707. Internal error. Please, report to manufacturer."
#define msg_7_8 "708. Read/write file error."
#define msg_7_9 "709. File open fail. "
#define msg_7_10 "710. Pass II: Not enough memory for clusterization."
#define msg_7_11 "711. Recogntion need password. See submenu Password in menu Help."

#define msg_8_1 "801. Edout: Ed-file is not open."
#define msg_8_2 "802. Edout: Fragment's number is wrong."
#define msg_8_3 "803. Edout: String's number is wrong."
#define msg_8_4 "804. Edout: Word's number is wrong."
#define msg_8_5 "805. Edout: Character's number is wrong."

#elif MORDA==LANG_RUSSIAN
/*=============	Русские definitions for error messages ========	*/
#define msg_0_1 "Ошибка форматирования."
#define msg_0_2 "Не найдены некоторые таблицы распознавания."
#define msg_0_3 "Debug stop."
#define msg_0_4 "Простите, но DEMO версия не сканирует."
#define msg_0_5 "Не найден словарь для вашего языка."

#define msg_1_1 "101. FileSys: Не хватает памяти для списка компонент."
#define msg_1_2 "102. FileSys: Нет места в списке компонент."
#define msg_1_3 "103. ExtrComp(an): Main number allocation fail."
#define msg_1_4 "104. ExtrComp(an): Не могу удалить большую картинку."
#define msg_1_5 "105. FileSys: Нет места в корневом списке."
#define msg_1_6 "106. LinesForming: Не хватает оперативной памяти."
#define msg_1_7	"107. LinesForming: Сильный перекос страницы."
#define msg_1_8 "108. LinesForming: Пустая страница."
#define msg_1_9 "109. ExtrComp(mn): Нет памяти для коробочек."
#define msg_1_10 "110. FileSys: Нет места для строки."
#define msg_1_11 "111. FileSys: Не найдено ни одной строки."
#define msg_1_12 "112. Tools: No place in the kit."
#define msg_1_13 "113. Main: Не хватает оперативной памяти (1Mb)."
#define msg_1_14 "114. Extrcomp(mn): Образ страницы не факс 100x200 dpi."
#define msg_1_15 "115. Sweeper: Не могу создать/открыть рабочий файл TEMP.CMP"
#define msg_1_16 "116. Sweeper: Не хватает места для рабочего файла TEMP.CMP"
#define msg_1_17 "117. Sweeper: Ошибка чтения рабочего файла TEMP.CMP"

#define msg_2_1 "201. ScanTiff: Нет доступа к изображению."
#define msg_2_2 "202. ScanTiff: Ошибка во время чтения изображения."
#define msg_2_3 "203. ScanTiff: Противоречивая информация об изображении."
#define msg_2_4 "204. ScanTiff: Resolution of this image isn't into 100dpi - 800dpi range."
#define msg_2_5 "205. ScanDIB: Unable to access DIB."

#define msg_3_1 "301. Scantiff: Ошибка формата group-4."
#define msg_3_2 "302. Положите в сканер страницу."

#define msg_4_1 "401. Spelling: словарь не найден."
#define msg_4_2 "402. Spelling: не могу открыть динамический словарь."
#define msg_4_3 "403. Spelling: страница была откорректированна."
#define msg_4_4 "404. Spelling: не хватает памяти."
#define msg_4_5 "405. Spelling: ED-файл испорчен."
#define msg_4_6 "406. Spelling: нет ED_файла."
#define msg_4_7 "407. Spelling: ошибка дораспознавания."

#define msg_6_1 "601. TextSave: Ошибка открытия."		// only DOS
#define msg_6_2 "602. TextSave: Ошибка записи."
#define msg_6_3 "603. TestSave: Не хватает памяти."
#define msg_6_4 "604. TextSave: Не могу открыть временный ED-файл."
#define msg_6_5 "605. Lineout: Ошибка открытия ED-файла."	// Only DOS
#define msg_6_6 "606. Lineout: Ошибка чтения ED-файла."
#define msg_6_7 "607. Lineout: Пустая страница."
#define msg_6_8 "608. TestSave: Неиспользуемая кодировка для данного языка."
#define msg_6_9 "609. RTF: ED-файл испорчен."
#define msg_6_10 "610. Not used."
#define msg_6_11 "611. Lineout: Ошибка записи ED-файла."
#define msg_6_12 "612. Not used."
#define msg_6_13 "613. Not used."
#define msg_6_14 "614. Not used."

#define msg_7_1 "701. Слишком длинный путь."
#define msg_7_2 "702. Прерывание от пользователя."
#define msg_7_3 "703. Не могу связаться с пользователем."
#define msg_7_4 "704. Невозможно обработать иллюстрацию. Слишком большая картинка."
#define msg_7_5 "705. Ошибка открытия/чтения/записи файла."
#define msg_7_6 "706. Шаг II: Доступная память исчерпана."
#define msg_7_7 "707. Системная ошибка. Свяжитесь с производителем."
#define msg_7_8 "708. Ошибка при чтении/записи файла "
#define msg_7_9 "709. Ошибка открытия файла "
#define msg_7_10 "710. Шаг II: Не хватает памяти для кластеризации."
#define msg_7_11 "711. Для распознавания необходим пароль(см. пункт Пароль меню Помощь)"

#define msg_8_1 "801. Edout: ED-файл не открыт."
#define msg_8_2 "802. Edout: Не корректный номер фрагмента."
#define msg_8_3 "803. Edout: Не корректный номер строки."
#define msg_8_4 "804. Edout: Не корректный номер слова."
#define msg_8_5 "805. Edout: Не корректный номер символа."
#endif

/*============== Messages groups structure ====================	*/

static pchar format_msg[]={msg_0_1,msg_0_2,msg_0_3,msg_0_4,msg_0_5};
static pchar comp_msg[]={msg_1_1,msg_1_2,msg_1_3,msg_1_4,msg_1_5,
	                     msg_1_6,msg_1_7,msg_1_8,msg_1_9,msg_1_10,
						 msg_1_11,msg_1_12,msg_1_13,msg_1_14,msg_1_15,
						 msg_1_16,msg_1_17};
static pchar image_msg[]={msg_2_1,msg_2_2,msg_2_3,msg_2_4,msg_2_5};
static pchar run_msg[]={msg_3_1,msg_3_2};
static pchar voc_msg[]={msg_4_1,msg_4_2,msg_4_3,msg_4_4,msg_4_5,
			            msg_4_6,msg_4_7};
static pchar rtf_msg[]={msg_6_1,msg_6_2,msg_6_3,msg_6_4,msg_6_5,
                        msg_6_6,msg_6_7,msg_6_8,msg_6_9,msg_6_10,
						msg_6_11,msg_6_12,msg_6_13,msg_6_14};
static pchar kernel_msg[]={msg_7_1,msg_7_2,msg_7_3,msg_7_4,msg_7_5,
                           msg_7_6,msg_7_7,msg_7_8,msg_7_9,msg_7_10,
						   msg_7_11};
static pchar edout_msg[]={msg_8_1,msg_8_2,msg_8_3,msg_8_4,msg_8_5};

#ifndef DEMO
static pchar copyr_msg[]={
"\n\n     \n"
  };
#endif

#ifdef DEMO
static pchar copyr_msg[]={
"\n\n"
  "       ████  ██████   ████           █████     ████   ██████    \n"
  "      ██       ██    ██             ██   ██   ██      ██   ██   \n"
  "      ██       ██    ██             ██   ██   ██      ██████    \n"
  "      ██       ██    ██             ██   ██   ██      ██ ██     \n"
  "       ████    ██     ████           █████     ████   ██  ██    \n\n"
  "                     D E M O   V E R S I O N                    \n\n\n"
  };
#endif

pchar * message_groups[]={format_msg,comp_msg,image_msg,run_msg,
			voc_msg,copyr_msg,rtf_msg,kernel_msg,edout_msg};

//---------------------- Errors processing ------------------
extern jmp_buf fatal_error_exit;
static uint16_t status_code = 0;
static char mess[512],add_mess[256];
//	Fatal error break processing

static void msg_err (int16_t group, int16_t element)
{
    status_code = 1000 + group * 100 + element;
    Tiger_ReportError (status_code, get_message (status_code));
}

void error_exit (int16_t group, int16_t element)
{
 extern void FreeAllData(void);

    //MsgBox("msgerr");
    FreeAllData();
    add_mess[0]='\0';
    msg_err (group,element);                    /* show message */
    longjmp (fatal_error_exit, element);
    //MsgBox("longjump done");

}

void error_exit_str(int16_t group, int16_t element,pchar s)
{
 extern void FreeAllData(void);

    FreeAllData();
    strcpy(add_mess,s);
    msg_err (group,element); /* show message */
    longjmp (fatal_error_exit, element);
}

void error_exit_asm (int16_t element)
{
    error_exit (ERR_comp,element);
}

//	External manipulation with error status
pchar get_message (uint16_t code)
{
    pchar c=mess;
    if (code == 0) return "OK.";
    strcpy(mess,*(message_groups [(code - 1000)/100] + code%100 - 1));  /* ptr to message */
    strcat(mess,add_mess);
#ifdef __MAC__
// Перекодирование под Windows идет в WINCV\DLL_MAIN.c
// тк программа под DOS и WINDOWS собирается на одной компиляции
        {
        extern char decode_ASCII_to_[];
        int16_t i;
        for(i=0;*(c+i);i++)
                *(c+i)=decode_ASCII_to_[(uchar)(*(c+i))];
        }
#endif
    return c;
}

uint16_t get_error_status()
{
    return status_code;
}

void clear_error_status()
{
    status_code = 0; add_mess[0]='\0';
}

Bool bool_status()
{
    return ((status_code) ? FALSE : TRUE);
}

void set_error_status (uint16_t group, uint16_t element)
{
    msg_err (group, element);
}
