// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `IDS_Trinary_Operator`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x002FF2, 0x002FF3]
  ]
});
testPropertyEscapes(
  /^\p{IDS_Trinary_Operator}+$/u,
  matchSymbols,
  "\\p{IDS_Trinary_Operator}"
);
testPropertyEscapes(
  /^\p{IDST}+$/u,
  matchSymbols,
  "\\p{IDST}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x002FF1],
    [0x002FF4, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{IDS_Trinary_Operator}+$/u,
  nonMatchSymbols,
  "\\P{IDS_Trinary_Operator}"
);
testPropertyEscapes(
  /^\P{IDST}+$/u,
  nonMatchSymbols,
  "\\P{IDST}"
);

reportCompare(0, 0);
