/*
 * Copyright © 2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Daniel d'Andrada <daniel.dandrada@canonical.com>
 */

#ifndef NTRIG_INPUT_EVENTS_H_
#define NTRIG_INPUT_EVENTS_H_

#include <cstdint>

struct InputEventData {
    int64_t nsecs;
    int32_t type;
    int32_t code;
    int32_t value;
};

/*
  Events recorded from an N-Trig touchscreen.
  Frantically tapping and sliding fingers (up to 5 or 6 at the same time) for half a
  minute or so.
*/
struct InputEventData gInputEvents[] = {
    {INT64_C(1380575033089701000), 0x0003, 0x0035, 384},
    {INT64_C(1380575033089701000), 0x0003, 0x0036, 4392},
    {INT64_C(1380575033089701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033089701000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033089701000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033089701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033089701000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033095703000), 0x0003, 0x0000, 896},
    {INT64_C(1380575033095703000), 0x0003, 0x0001, 5484},
    {INT64_C(1380575033095703000), 0x0003, 0x0035, 896},
    {INT64_C(1380575033095703000), 0x0003, 0x0036, 5484},
    {INT64_C(1380575033095703000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033095703000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033095703000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033095703000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033095703000), 0x0003, 0x0035, 384},
    {INT64_C(1380575033095703000), 0x0003, 0x0036, 4395},
    {INT64_C(1380575033095703000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033095703000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033095703000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033095703000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033095703000), 0x0003, 0x0035, 2884},
    {INT64_C(1380575033095703000), 0x0003, 0x0036, 1440},
    {INT64_C(1380575033095703000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033095703000), 0x0003, 0x0030, 256},
    {INT64_C(1380575033095703000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033095703000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033095703000), 0x0001, 0x014d, 1},
    {INT64_C(1380575033095703000), 0x0001, 0x014a, 1},
    {INT64_C(1380575033095703000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033109702000), 0x0003, 0x0001, 5481},
    {INT64_C(1380575033109702000), 0x0003, 0x0035, 896},
    {INT64_C(1380575033109702000), 0x0003, 0x0036, 5481},
    {INT64_C(1380575033109702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033109702000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033109702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033109702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033109702000), 0x0003, 0x0035, 384},
    {INT64_C(1380575033109702000), 0x0003, 0x0036, 4395},
    {INT64_C(1380575033109702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033109702000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033109702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033109702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033109702000), 0x0003, 0x0035, 2892},
    {INT64_C(1380575033109702000), 0x0003, 0x0036, 1509},
    {INT64_C(1380575033109702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033109702000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033109702000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033109702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033109702000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033115702000), 0x0003, 0x0001, 5470},
    {INT64_C(1380575033115702000), 0x0003, 0x0035, 896},
    {INT64_C(1380575033115702000), 0x0003, 0x0036, 5470},
    {INT64_C(1380575033115702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033115702000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033115702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033115702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033115702000), 0x0003, 0x0035, 512},
    {INT64_C(1380575033115702000), 0x0003, 0x0036, 4409},
    {INT64_C(1380575033115702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033115702000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033115702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033115702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033115702000), 0x0003, 0x0035, 2888},
    {INT64_C(1380575033115702000), 0x0003, 0x0036, 1521},
    {INT64_C(1380575033115702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033115702000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033115702000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033115702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033115702000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033127702000), 0x0003, 0x0001, 5469},
    {INT64_C(1380575033127702000), 0x0003, 0x0035, 896},
    {INT64_C(1380575033127702000), 0x0003, 0x0036, 5469},
    {INT64_C(1380575033127702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033127702000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033127702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033127702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033127702000), 0x0003, 0x0035, 512},
    {INT64_C(1380575033127702000), 0x0003, 0x0036, 4400},
    {INT64_C(1380575033127702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033127702000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033127702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033127702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033127702000), 0x0003, 0x0035, 2896},
    {INT64_C(1380575033127702000), 0x0003, 0x0036, 1517},
    {INT64_C(1380575033127702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033127702000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033127702000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033127702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033127702000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033133703000), 0x0003, 0x0000, 990},
    {INT64_C(1380575033133703000), 0x0003, 0x0001, 5443},
    {INT64_C(1380575033133703000), 0x0003, 0x0035, 990},
    {INT64_C(1380575033133703000), 0x0003, 0x0036, 5443},
    {INT64_C(1380575033133703000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033133703000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033133703000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033133703000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033133703000), 0x0003, 0x0035, 512},
    {INT64_C(1380575033133703000), 0x0003, 0x0036, 4370},
    {INT64_C(1380575033133703000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033133703000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033133703000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033133703000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033133703000), 0x0003, 0x0035, 2903},
    {INT64_C(1380575033133703000), 0x0003, 0x0036, 1522},
    {INT64_C(1380575033133703000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033133703000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033133703000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033133703000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033133703000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033145698000), 0x0003, 0x0000, 1024},
    {INT64_C(1380575033145698000), 0x0003, 0x0001, 5428},
    {INT64_C(1380575033145698000), 0x0003, 0x0035, 1024},
    {INT64_C(1380575033145698000), 0x0003, 0x0036, 5428},
    {INT64_C(1380575033145698000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033145698000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033145698000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033145698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033145698000), 0x0003, 0x0035, 640},
    {INT64_C(1380575033145698000), 0x0003, 0x0036, 4384},
    {INT64_C(1380575033145698000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033145698000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033145698000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033145698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033145698000), 0x0003, 0x0035, 2911},
    {INT64_C(1380575033145698000), 0x0003, 0x0036, 1530},
    {INT64_C(1380575033145698000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033145698000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033145698000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033145698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033145698000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033151702000), 0x0003, 0x0000, 1089},
    {INT64_C(1380575033151702000), 0x0003, 0x0001, 5391},
    {INT64_C(1380575033151702000), 0x0003, 0x0035, 1089},
    {INT64_C(1380575033151702000), 0x0003, 0x0036, 5391},
    {INT64_C(1380575033151702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033151702000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033151702000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033151702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033151702000), 0x0003, 0x0035, 640},
    {INT64_C(1380575033151702000), 0x0003, 0x0036, 4364},
    {INT64_C(1380575033151702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033151702000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033151702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033151702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033151702000), 0x0003, 0x0035, 979},
    {INT64_C(1380575033151702000), 0x0003, 0x0036, 4320},
    {INT64_C(1380575033151702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033151702000), 0x0003, 0x0030, 256},
    {INT64_C(1380575033151702000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033151702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033151702000), 0x0003, 0x0035, 2919},
    {INT64_C(1380575033151702000), 0x0003, 0x0036, 1522},
    {INT64_C(1380575033151702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033151702000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033151702000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033151702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033151702000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033165702000), 0x0003, 0x0000, 1152},
    {INT64_C(1380575033165702000), 0x0003, 0x0001, 5369},
    {INT64_C(1380575033165702000), 0x0003, 0x0035, 1152},
    {INT64_C(1380575033165702000), 0x0003, 0x0036, 5369},
    {INT64_C(1380575033165702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033165702000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033165702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033165702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033165702000), 0x0003, 0x0035, 782},
    {INT64_C(1380575033165702000), 0x0003, 0x0036, 4361},
    {INT64_C(1380575033165702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033165702000), 0x0003, 0x0030, 640},
    {INT64_C(1380575033165702000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033165702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033165702000), 0x0003, 0x0035, 1007},
    {INT64_C(1380575033165702000), 0x0003, 0x0036, 3040},
    {INT64_C(1380575033165702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033165702000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033165702000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033165702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033165702000), 0x0003, 0x0035, 2930},
    {INT64_C(1380575033165702000), 0x0003, 0x0036, 1526},
    {INT64_C(1380575033165702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033165702000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033165702000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033165702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033165702000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033171701000), 0x0003, 0x0000, 1235},
    {INT64_C(1380575033171701000), 0x0003, 0x0001, 5346},
    {INT64_C(1380575033171701000), 0x0003, 0x0035, 1235},
    {INT64_C(1380575033171701000), 0x0003, 0x0036, 5346},
    {INT64_C(1380575033171701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033171701000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033171701000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033171701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033171701000), 0x0003, 0x0035, 832},
    {INT64_C(1380575033171701000), 0x0003, 0x0036, 4324},
    {INT64_C(1380575033171701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033171701000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033171701000), 0x0003, 0x0031, 384},
    {INT64_C(1380575033171701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033171701000), 0x0003, 0x0035, 1068},
    {INT64_C(1380575033171701000), 0x0003, 0x0036, 2960},
    {INT64_C(1380575033171701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033171701000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033171701000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033171701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033171701000), 0x0003, 0x0035, 2944},
    {INT64_C(1380575033171701000), 0x0003, 0x0036, 1520},
    {INT64_C(1380575033171701000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033171701000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033171701000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033171701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033171701000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033183702000), 0x0003, 0x0000, 1280},
    {INT64_C(1380575033183702000), 0x0003, 0x0001, 5327},
    {INT64_C(1380575033183702000), 0x0003, 0x0035, 1280},
    {INT64_C(1380575033183702000), 0x0003, 0x0036, 5327},
    {INT64_C(1380575033183702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033183702000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033183702000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033183702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033183702000), 0x0003, 0x0035, 930},
    {INT64_C(1380575033183702000), 0x0003, 0x0036, 4306},
    {INT64_C(1380575033183702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033183702000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033183702000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033183702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033183702000), 0x0003, 0x0035, 1158},
    {INT64_C(1380575033183702000), 0x0003, 0x0036, 2957},
    {INT64_C(1380575033183702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033183702000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033183702000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033183702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033183702000), 0x0003, 0x0035, 2949},
    {INT64_C(1380575033183702000), 0x0003, 0x0036, 1515},
    {INT64_C(1380575033183702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033183702000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033183702000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033183702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033183702000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033203704000), 0x0003, 0x0000, 2546},
    {INT64_C(1380575033203704000), 0x0003, 0x0001, 6080},
    {INT64_C(1380575033203704000), 0x0003, 0x0035, 2546},
    {INT64_C(1380575033203704000), 0x0003, 0x0036, 6080},
    {INT64_C(1380575033203704000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033203704000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033203704000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033203704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033203704000), 0x0003, 0x0035, 1408},
    {INT64_C(1380575033203704000), 0x0003, 0x0036, 5220},
    {INT64_C(1380575033203704000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033203704000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033203704000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033203704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033203704000), 0x0003, 0x0035, 1023},
    {INT64_C(1380575033203704000), 0x0003, 0x0036, 4254},
    {INT64_C(1380575033203704000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033203704000), 0x0003, 0x0030, 512},
    {INT64_C(1380575033203704000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033203704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033203704000), 0x0003, 0x0035, 1260},
    {INT64_C(1380575033203704000), 0x0003, 0x0036, 2962},
    {INT64_C(1380575033203704000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033203704000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033203704000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033203704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033203704000), 0x0003, 0x0035, 2967},
    {INT64_C(1380575033203704000), 0x0003, 0x0036, 1519},
    {INT64_C(1380575033203704000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033203704000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033203704000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033203704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033203704000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033221704000), 0x0003, 0x0000, 2708},
    {INT64_C(1380575033221704000), 0x0003, 0x0001, 5972},
    {INT64_C(1380575033221704000), 0x0003, 0x0035, 2708},
    {INT64_C(1380575033221704000), 0x0003, 0x0036, 5972},
    {INT64_C(1380575033221704000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033221704000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033221704000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033221704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033221704000), 0x0003, 0x0035, 1536},
    {INT64_C(1380575033221704000), 0x0003, 0x0036, 5196},
    {INT64_C(1380575033221704000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033221704000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033221704000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033221704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033221704000), 0x0003, 0x0035, 1147},
    {INT64_C(1380575033221704000), 0x0003, 0x0036, 4227},
    {INT64_C(1380575033221704000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033221704000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033221704000), 0x0003, 0x0031, 384},
    {INT64_C(1380575033221704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033221704000), 0x0003, 0x0035, 1355},
    {INT64_C(1380575033221704000), 0x0003, 0x0036, 2952},
    {INT64_C(1380575033221704000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033221704000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033221704000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033221704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033221704000), 0x0003, 0x0035, 2980},
    {INT64_C(1380575033221704000), 0x0003, 0x0036, 1600},
    {INT64_C(1380575033221704000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033221704000), 0x0003, 0x0030, 256},
    {INT64_C(1380575033221704000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033221704000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033221704000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033239700000), 0x0003, 0x0000, 2880},
    {INT64_C(1380575033239700000), 0x0003, 0x0001, 5825},
    {INT64_C(1380575033239700000), 0x0003, 0x0035, 2880},
    {INT64_C(1380575033239700000), 0x0003, 0x0036, 5825},
    {INT64_C(1380575033239700000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033239700000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033239700000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033239700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033239700000), 0x0003, 0x0035, 1664},
    {INT64_C(1380575033239700000), 0x0003, 0x0036, 5067},
    {INT64_C(1380575033239700000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033239700000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033239700000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033239700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033239700000), 0x0003, 0x0035, 1271},
    {INT64_C(1380575033239700000), 0x0003, 0x0036, 4153},
    {INT64_C(1380575033239700000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033239700000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033239700000), 0x0003, 0x0031, 384},
    {INT64_C(1380575033239700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033239700000), 0x0003, 0x0035, 1470},
    {INT64_C(1380575033239700000), 0x0003, 0x0036, 2920},
    {INT64_C(1380575033239700000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033239700000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033239700000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033239700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033239700000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033259698000), 0x0003, 0x0000, 3092},
    {INT64_C(1380575033259698000), 0x0003, 0x0001, 5655},
    {INT64_C(1380575033259698000), 0x0003, 0x0035, 3092},
    {INT64_C(1380575033259698000), 0x0003, 0x0036, 5655},
    {INT64_C(1380575033259698000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033259698000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033259698000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033259698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033259698000), 0x0003, 0x0035, 1792},
    {INT64_C(1380575033259698000), 0x0003, 0x0036, 5031},
    {INT64_C(1380575033259698000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033259698000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033259698000), 0x0003, 0x0031, 128},
    {INT64_C(1380575033259698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033259698000), 0x0003, 0x0035, 1367},
    {INT64_C(1380575033259698000), 0x0003, 0x0036, 4076},
    {INT64_C(1380575033259698000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033259698000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033259698000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033259698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033259698000), 0x0003, 0x0035, 1571},
    {INT64_C(1380575033259698000), 0x0003, 0x0036, 2880},
    {INT64_C(1380575033259698000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033259698000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033259698000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033259698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033259698000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033277700000), 0x0003, 0x0000, 3205},
    {INT64_C(1380575033277700000), 0x0003, 0x0001, 5524},
    {INT64_C(1380575033277700000), 0x0003, 0x0035, 3205},
    {INT64_C(1380575033277700000), 0x0003, 0x0036, 5524},
    {INT64_C(1380575033277700000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033277700000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033277700000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033277700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033277700000), 0x0003, 0x0035, 1917},
    {INT64_C(1380575033277700000), 0x0003, 0x0036, 4998},
    {INT64_C(1380575033277700000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033277700000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033277700000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033277700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033277700000), 0x0003, 0x0035, 1492},
    {INT64_C(1380575033277700000), 0x0003, 0x0036, 4039},
    {INT64_C(1380575033277700000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033277700000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033277700000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033277700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033277700000), 0x0003, 0x0035, 1632},
    {INT64_C(1380575033277700000), 0x0003, 0x0036, 2880},
    {INT64_C(1380575033277700000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033277700000), 0x0003, 0x0030, 256},
    {INT64_C(1380575033277700000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033277700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033277700000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033295702000), 0x0003, 0x0000, 3335},
    {INT64_C(1380575033295702000), 0x0003, 0x0001, 5418},
    {INT64_C(1380575033295702000), 0x0003, 0x0035, 3335},
    {INT64_C(1380575033295702000), 0x0003, 0x0036, 5418},
    {INT64_C(1380575033295702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033295702000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033295702000), 0x0003, 0x0031, 384},
    {INT64_C(1380575033295702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033295702000), 0x0003, 0x0035, 2033},
    {INT64_C(1380575033295702000), 0x0003, 0x0036, 4960},
    {INT64_C(1380575033295702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033295702000), 0x0003, 0x0030, 256},
    {INT64_C(1380575033295702000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033295702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033295702000), 0x0003, 0x0035, 1612},
    {INT64_C(1380575033295702000), 0x0003, 0x0036, 4024},
    {INT64_C(1380575033295702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033295702000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033295702000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033295702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033295702000), 0x0003, 0x0035, 1778},
    {INT64_C(1380575033295702000), 0x0003, 0x0036, 2880},
    {INT64_C(1380575033295702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033295702000), 0x0003, 0x0030, 256},
    {INT64_C(1380575033295702000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033295702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033295702000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033315701000), 0x0003, 0x0000, 3436},
    {INT64_C(1380575033315701000), 0x0003, 0x0001, 5290},
    {INT64_C(1380575033315701000), 0x0003, 0x0035, 3436},
    {INT64_C(1380575033315701000), 0x0003, 0x0036, 5290},
    {INT64_C(1380575033315701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033315701000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033315701000), 0x0003, 0x0031, 384},
    {INT64_C(1380575033315701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033315701000), 0x0003, 0x0035, 2143},
    {INT64_C(1380575033315701000), 0x0003, 0x0036, 4852},
    {INT64_C(1380575033315701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033315701000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033315701000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033315701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033315701000), 0x0003, 0x0035, 1725},
    {INT64_C(1380575033315701000), 0x0003, 0x0036, 3922},
    {INT64_C(1380575033315701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033315701000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033315701000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033315701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033315701000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033333701000), 0x0003, 0x0000, 3556},
    {INT64_C(1380575033333701000), 0x0003, 0x0001, 5166},
    {INT64_C(1380575033333701000), 0x0003, 0x0035, 3556},
    {INT64_C(1380575033333701000), 0x0003, 0x0036, 5166},
    {INT64_C(1380575033333701000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033333701000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033333701000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033333701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033333701000), 0x0003, 0x0035, 2258},
    {INT64_C(1380575033333701000), 0x0003, 0x0036, 4701},
    {INT64_C(1380575033333701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033333701000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033333701000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033333701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033333701000), 0x0003, 0x0035, 1816},
    {INT64_C(1380575033333701000), 0x0003, 0x0036, 3867},
    {INT64_C(1380575033333701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033333701000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033333701000), 0x0003, 0x0031, 384},
    {INT64_C(1380575033333701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033333701000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033351701000), 0x0003, 0x0000, 3647},
    {INT64_C(1380575033351701000), 0x0003, 0x0001, 4988},
    {INT64_C(1380575033351701000), 0x0003, 0x0035, 3647},
    {INT64_C(1380575033351701000), 0x0003, 0x0036, 4988},
    {INT64_C(1380575033351701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033351701000), 0x0003, 0x0030, 640},
    {INT64_C(1380575033351701000), 0x0003, 0x0031, 512},
    {INT64_C(1380575033351701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033351701000), 0x0003, 0x0035, 2370},
    {INT64_C(1380575033351701000), 0x0003, 0x0036, 4653},
    {INT64_C(1380575033351701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033351701000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033351701000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033351701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033351701000), 0x0003, 0x0035, 1869},
    {INT64_C(1380575033351701000), 0x0003, 0x0036, 3764},
    {INT64_C(1380575033351701000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033351701000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033351701000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033351701000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033351701000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033371700000), 0x0003, 0x0000, 3702},
    {INT64_C(1380575033371700000), 0x0003, 0x0001, 4870},
    {INT64_C(1380575033371700000), 0x0003, 0x0035, 3702},
    {INT64_C(1380575033371700000), 0x0003, 0x0036, 4870},
    {INT64_C(1380575033371700000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033371700000), 0x0003, 0x0030, 640},
    {INT64_C(1380575033371700000), 0x0003, 0x0031, 384},
    {INT64_C(1380575033371700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033371700000), 0x0003, 0x0035, 2430},
    {INT64_C(1380575033371700000), 0x0003, 0x0036, 4539},
    {INT64_C(1380575033371700000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033371700000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033371700000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033371700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033371700000), 0x0003, 0x0035, 1966},
    {INT64_C(1380575033371700000), 0x0003, 0x0036, 3704},
    {INT64_C(1380575033371700000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033371700000), 0x0003, 0x0030, 384},
    {INT64_C(1380575033371700000), 0x0003, 0x0031, 320},
    {INT64_C(1380575033371700000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033371700000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033389702000), 0x0003, 0x0000, 3747},
    {INT64_C(1380575033389702000), 0x0003, 0x0001, 4748},
    {INT64_C(1380575033389702000), 0x0003, 0x0035, 3747},
    {INT64_C(1380575033389702000), 0x0003, 0x0036, 4748},
    {INT64_C(1380575033389702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033389702000), 0x0003, 0x0030, 640},
    {INT64_C(1380575033389702000), 0x0003, 0x0031, 384},
    {INT64_C(1380575033389702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033389702000), 0x0003, 0x0035, 2518},
    {INT64_C(1380575033389702000), 0x0003, 0x0036, 4442},
    {INT64_C(1380575033389702000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033389702000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033389702000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033389702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033389702000), 0x0003, 0x0035, 2068},
    {INT64_C(1380575033389702000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575033389702000), 0x0003, 0x0034, 1},
    {INT64_C(1380575033389702000), 0x0003, 0x0030, 256},
    {INT64_C(1380575033389702000), 0x0003, 0x0031, 160},
    {INT64_C(1380575033389702000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033389702000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033407698000), 0x0003, 0x0000, 3775},
    {INT64_C(1380575033407698000), 0x0003, 0x0001, 4583},
    {INT64_C(1380575033407698000), 0x0003, 0x0035, 3775},
    {INT64_C(1380575033407698000), 0x0003, 0x0036, 4583},
    {INT64_C(1380575033407698000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033407698000), 0x0003, 0x0030, 320},
    {INT64_C(1380575033407698000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033407698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033407698000), 0x0003, 0x0035, 2588},
    {INT64_C(1380575033407698000), 0x0003, 0x0036, 4314},
    {INT64_C(1380575033407698000), 0x0003, 0x0034, 0},
    {INT64_C(1380575033407698000), 0x0003, 0x0030, 480},
    {INT64_C(1380575033407698000), 0x0003, 0x0031, 256},
    {INT64_C(1380575033407698000), 0x0000, 0x0002, 0},
    {INT64_C(1380575033407698000), 0x0000, 0x0000, 0},
    {INT64_C(1380575033501694000), 0x0001, 0x014d, 0},
    {INT64_C(1380575033501694000), 0x0001, 0x014a, 0},
    {INT64_C(1380575033501694000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034867687000), 0x0003, 0x0035, 1455},
    {INT64_C(1380575034867687000), 0x0003, 0x0036, 4248},
    {INT64_C(1380575034867687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034867687000), 0x0003, 0x0030, 640},
    {INT64_C(1380575034867687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034867687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034867687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034873691000), 0x0003, 0x0000, 1497},
    {INT64_C(1380575034873691000), 0x0003, 0x0001, 5657},
    {INT64_C(1380575034873691000), 0x0003, 0x0035, 1497},
    {INT64_C(1380575034873691000), 0x0003, 0x0036, 5657},
    {INT64_C(1380575034873691000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034873691000), 0x0003, 0x0030, 320},
    {INT64_C(1380575034873691000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034873691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034873691000), 0x0003, 0x0035, 1464},
    {INT64_C(1380575034873691000), 0x0003, 0x0036, 4234},
    {INT64_C(1380575034873691000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034873691000), 0x0003, 0x0030, 320},
    {INT64_C(1380575034873691000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034873691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034873691000), 0x0001, 0x014d, 1},
    {INT64_C(1380575034873691000), 0x0001, 0x014a, 1},
    {INT64_C(1380575034873691000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034885687000), 0x0003, 0x0000, 1499},
    {INT64_C(1380575034885687000), 0x0003, 0x0001, 5656},
    {INT64_C(1380575034885687000), 0x0003, 0x0035, 1499},
    {INT64_C(1380575034885687000), 0x0003, 0x0036, 5656},
    {INT64_C(1380575034885687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034885687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575034885687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034885687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034885687000), 0x0003, 0x0035, 1470},
    {INT64_C(1380575034885687000), 0x0003, 0x0036, 4249},
    {INT64_C(1380575034885687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034885687000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034885687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034885687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034885687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034891689000), 0x0003, 0x0000, 1502},
    {INT64_C(1380575034891689000), 0x0003, 0x0001, 5651},
    {INT64_C(1380575034891689000), 0x0003, 0x0035, 1502},
    {INT64_C(1380575034891689000), 0x0003, 0x0036, 5651},
    {INT64_C(1380575034891689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034891689000), 0x0003, 0x0030, 320},
    {INT64_C(1380575034891689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034891689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034891689000), 0x0003, 0x0035, 1480},
    {INT64_C(1380575034891689000), 0x0003, 0x0036, 4242},
    {INT64_C(1380575034891689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034891689000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034891689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034891689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034891689000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034905690000), 0x0003, 0x0000, 1509},
    {INT64_C(1380575034905690000), 0x0003, 0x0001, 5634},
    {INT64_C(1380575034905690000), 0x0003, 0x0035, 1509},
    {INT64_C(1380575034905690000), 0x0003, 0x0036, 5634},
    {INT64_C(1380575034905690000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034905690000), 0x0003, 0x0030, 320},
    {INT64_C(1380575034905690000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034905690000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034905690000), 0x0003, 0x0035, 1485},
    {INT64_C(1380575034905690000), 0x0003, 0x0036, 4226},
    {INT64_C(1380575034905690000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034905690000), 0x0003, 0x0030, 320},
    {INT64_C(1380575034905690000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034905690000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034905690000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034911691000), 0x0003, 0x0000, 1526},
    {INT64_C(1380575034911691000), 0x0003, 0x0001, 5648},
    {INT64_C(1380575034911691000), 0x0003, 0x0035, 1526},
    {INT64_C(1380575034911691000), 0x0003, 0x0036, 5648},
    {INT64_C(1380575034911691000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034911691000), 0x0003, 0x0030, 384},
    {INT64_C(1380575034911691000), 0x0003, 0x0031, 320},
    {INT64_C(1380575034911691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034911691000), 0x0003, 0x0035, 1506},
    {INT64_C(1380575034911691000), 0x0003, 0x0036, 4228},
    {INT64_C(1380575034911691000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034911691000), 0x0003, 0x0030, 640},
    {INT64_C(1380575034911691000), 0x0003, 0x0031, 384},
    {INT64_C(1380575034911691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034911691000), 0x0003, 0x0035, 3160},
    {INT64_C(1380575034911691000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575034911691000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034911691000), 0x0003, 0x0030, 256},
    {INT64_C(1380575034911691000), 0x0003, 0x0031, 160},
    {INT64_C(1380575034911691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034911691000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034923690000), 0x0003, 0x0000, 1556},
    {INT64_C(1380575034923690000), 0x0003, 0x0001, 5636},
    {INT64_C(1380575034923690000), 0x0003, 0x0035, 1556},
    {INT64_C(1380575034923690000), 0x0003, 0x0036, 5636},
    {INT64_C(1380575034923690000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034923690000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034923690000), 0x0003, 0x0031, 384},
    {INT64_C(1380575034923690000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034923690000), 0x0003, 0x0035, 1538},
    {INT64_C(1380575034923690000), 0x0003, 0x0036, 4245},
    {INT64_C(1380575034923690000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034923690000), 0x0003, 0x0030, 640},
    {INT64_C(1380575034923690000), 0x0003, 0x0031, 384},
    {INT64_C(1380575034923690000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034923690000), 0x0003, 0x0035, 3175},
    {INT64_C(1380575034923690000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575034923690000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034923690000), 0x0003, 0x0030, 384},
    {INT64_C(1380575034923690000), 0x0003, 0x0031, 160},
    {INT64_C(1380575034923690000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034923690000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034929691000), 0x0003, 0x0000, 1593},
    {INT64_C(1380575034929691000), 0x0003, 0x0001, 5609},
    {INT64_C(1380575034929691000), 0x0003, 0x0035, 1593},
    {INT64_C(1380575034929691000), 0x0003, 0x0036, 5609},
    {INT64_C(1380575034929691000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034929691000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034929691000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034929691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034929691000), 0x0003, 0x0035, 1557},
    {INT64_C(1380575034929691000), 0x0003, 0x0036, 4216},
    {INT64_C(1380575034929691000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034929691000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034929691000), 0x0003, 0x0031, 384},
    {INT64_C(1380575034929691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034929691000), 0x0003, 0x0035, 3162},
    {INT64_C(1380575034929691000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575034929691000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034929691000), 0x0003, 0x0030, 384},
    {INT64_C(1380575034929691000), 0x0003, 0x0031, 160},
    {INT64_C(1380575034929691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034929691000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034943688000), 0x0003, 0x0000, 1635},
    {INT64_C(1380575034943688000), 0x0003, 0x0001, 5570},
    {INT64_C(1380575034943688000), 0x0003, 0x0035, 1635},
    {INT64_C(1380575034943688000), 0x0003, 0x0036, 5570},
    {INT64_C(1380575034943688000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034943688000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034943688000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034943688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034943688000), 0x0003, 0x0035, 1587},
    {INT64_C(1380575034943688000), 0x0003, 0x0036, 4208},
    {INT64_C(1380575034943688000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034943688000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034943688000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034943688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034943688000), 0x0003, 0x0035, 3170},
    {INT64_C(1380575034943688000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575034943688000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034943688000), 0x0003, 0x0030, 384},
    {INT64_C(1380575034943688000), 0x0003, 0x0031, 160},
    {INT64_C(1380575034943688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034943688000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034949687000), 0x0003, 0x0000, 1684},
    {INT64_C(1380575034949687000), 0x0003, 0x0001, 5538},
    {INT64_C(1380575034949687000), 0x0003, 0x0035, 1684},
    {INT64_C(1380575034949687000), 0x0003, 0x0036, 5538},
    {INT64_C(1380575034949687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034949687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575034949687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034949687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034949687000), 0x0003, 0x0035, 1622},
    {INT64_C(1380575034949687000), 0x0003, 0x0036, 4204},
    {INT64_C(1380575034949687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034949687000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034949687000), 0x0003, 0x0031, 384},
    {INT64_C(1380575034949687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034949687000), 0x0003, 0x0035, 3175},
    {INT64_C(1380575034949687000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575034949687000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034949687000), 0x0003, 0x0030, 384},
    {INT64_C(1380575034949687000), 0x0003, 0x0031, 160},
    {INT64_C(1380575034949687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034949687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034961692000), 0x0003, 0x0000, 1715},
    {INT64_C(1380575034961692000), 0x0003, 0x0001, 5512},
    {INT64_C(1380575034961692000), 0x0003, 0x0035, 1715},
    {INT64_C(1380575034961692000), 0x0003, 0x0036, 5512},
    {INT64_C(1380575034961692000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034961692000), 0x0003, 0x0030, 320},
    {INT64_C(1380575034961692000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034961692000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034961692000), 0x0003, 0x0035, 1664},
    {INT64_C(1380575034961692000), 0x0003, 0x0036, 4169},
    {INT64_C(1380575034961692000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034961692000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034961692000), 0x0003, 0x0031, 384},
    {INT64_C(1380575034961692000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034961692000), 0x0003, 0x0035, 3182},
    {INT64_C(1380575034961692000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575034961692000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034961692000), 0x0003, 0x0030, 384},
    {INT64_C(1380575034961692000), 0x0003, 0x0031, 160},
    {INT64_C(1380575034961692000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034961692000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034979688000), 0x0003, 0x0000, 1754},
    {INT64_C(1380575034979688000), 0x0003, 0x0001, 5481},
    {INT64_C(1380575034979688000), 0x0003, 0x0035, 1754},
    {INT64_C(1380575034979688000), 0x0003, 0x0036, 5481},
    {INT64_C(1380575034979688000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034979688000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034979688000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034979688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034979688000), 0x0003, 0x0035, 1716},
    {INT64_C(1380575034979688000), 0x0003, 0x0036, 4144},
    {INT64_C(1380575034979688000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034979688000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034979688000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034979688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034979688000), 0x0003, 0x0035, 3190},
    {INT64_C(1380575034979688000), 0x0003, 0x0036, 1838},
    {INT64_C(1380575034979688000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034979688000), 0x0003, 0x0030, 384},
    {INT64_C(1380575034979688000), 0x0003, 0x0031, 320},
    {INT64_C(1380575034979688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034979688000), 0x0000, 0x0000, 0},
    {INT64_C(1380575034999689000), 0x0003, 0x0000, 1812},
    {INT64_C(1380575034999689000), 0x0003, 0x0001, 5461},
    {INT64_C(1380575034999689000), 0x0003, 0x0035, 1812},
    {INT64_C(1380575034999689000), 0x0003, 0x0036, 5461},
    {INT64_C(1380575034999689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034999689000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034999689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575034999689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034999689000), 0x0003, 0x0035, 1747},
    {INT64_C(1380575034999689000), 0x0003, 0x0036, 4125},
    {INT64_C(1380575034999689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575034999689000), 0x0003, 0x0030, 480},
    {INT64_C(1380575034999689000), 0x0003, 0x0031, 384},
    {INT64_C(1380575034999689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034999689000), 0x0003, 0x0035, 3194},
    {INT64_C(1380575034999689000), 0x0003, 0x0036, 1826},
    {INT64_C(1380575034999689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575034999689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575034999689000), 0x0003, 0x0031, 320},
    {INT64_C(1380575034999689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575034999689000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035017687000), 0x0003, 0x0000, 1835},
    {INT64_C(1380575035017687000), 0x0003, 0x0001, 5409},
    {INT64_C(1380575035017687000), 0x0003, 0x0035, 1835},
    {INT64_C(1380575035017687000), 0x0003, 0x0036, 5409},
    {INT64_C(1380575035017687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035017687000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035017687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035017687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035017687000), 0x0003, 0x0035, 1803},
    {INT64_C(1380575035017687000), 0x0003, 0x0036, 4096},
    {INT64_C(1380575035017687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035017687000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035017687000), 0x0003, 0x0031, 384},
    {INT64_C(1380575035017687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035017687000), 0x0003, 0x0035, 3189},
    {INT64_C(1380575035017687000), 0x0003, 0x0036, 1829},
    {INT64_C(1380575035017687000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035017687000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035017687000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035017687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035017687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035035689000), 0x0003, 0x0000, 1891},
    {INT64_C(1380575035035689000), 0x0003, 0x0001, 5369},
    {INT64_C(1380575035035689000), 0x0003, 0x0035, 1891},
    {INT64_C(1380575035035689000), 0x0003, 0x0036, 5369},
    {INT64_C(1380575035035689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035035689000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035035689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035035689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035035689000), 0x0003, 0x0035, 1859},
    {INT64_C(1380575035035689000), 0x0003, 0x0036, 4078},
    {INT64_C(1380575035035689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035035689000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035035689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035035689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035035689000), 0x0003, 0x0035, 3194},
    {INT64_C(1380575035035689000), 0x0003, 0x0036, 1835},
    {INT64_C(1380575035035689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035035689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035035689000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035035689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035035689000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035055688000), 0x0003, 0x0000, 2676},
    {INT64_C(1380575035055688000), 0x0003, 0x0001, 5920},
    {INT64_C(1380575035055688000), 0x0003, 0x0035, 2676},
    {INT64_C(1380575035055688000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575035055688000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035055688000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035055688000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035055688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035055688000), 0x0003, 0x0035, 1960},
    {INT64_C(1380575035055688000), 0x0003, 0x0036, 5322},
    {INT64_C(1380575035055688000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035055688000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035055688000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035055688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035055688000), 0x0003, 0x0035, 1932},
    {INT64_C(1380575035055688000), 0x0003, 0x0036, 4045},
    {INT64_C(1380575035055688000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035055688000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035055688000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035055688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035055688000), 0x0003, 0x0035, 3190},
    {INT64_C(1380575035055688000), 0x0003, 0x0036, 1832},
    {INT64_C(1380575035055688000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035055688000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035055688000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035055688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035055688000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035073692000), 0x0003, 0x0000, 2709},
    {INT64_C(1380575035073692000), 0x0003, 0x0001, 5760},
    {INT64_C(1380575035073692000), 0x0003, 0x0035, 2709},
    {INT64_C(1380575035073692000), 0x0003, 0x0036, 5760},
    {INT64_C(1380575035073692000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035073692000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035073692000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035073692000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035073692000), 0x0003, 0x0035, 2025},
    {INT64_C(1380575035073692000), 0x0003, 0x0036, 5259},
    {INT64_C(1380575035073692000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035073692000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035073692000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035073692000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035073692000), 0x0003, 0x0035, 2005},
    {INT64_C(1380575035073692000), 0x0003, 0x0036, 4008},
    {INT64_C(1380575035073692000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035073692000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035073692000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035073692000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035073692000), 0x0003, 0x0035, 3194},
    {INT64_C(1380575035073692000), 0x0003, 0x0036, 1836},
    {INT64_C(1380575035073692000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035073692000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035073692000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035073692000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035073692000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035091689000), 0x0003, 0x0000, 2091},
    {INT64_C(1380575035091689000), 0x0003, 0x0001, 5173},
    {INT64_C(1380575035091689000), 0x0003, 0x0035, 2091},
    {INT64_C(1380575035091689000), 0x0003, 0x0036, 5173},
    {INT64_C(1380575035091689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035091689000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035091689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035091689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035091689000), 0x0003, 0x0035, 2066},
    {INT64_C(1380575035091689000), 0x0003, 0x0036, 3894},
    {INT64_C(1380575035091689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035091689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035091689000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035091689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035091689000), 0x0003, 0x0035, 3180},
    {INT64_C(1380575035091689000), 0x0003, 0x0036, 1843},
    {INT64_C(1380575035091689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035091689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035091689000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035091689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035091689000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035111689000), 0x0003, 0x0000, 2816},
    {INT64_C(1380575035111689000), 0x0003, 0x0001, 5542},
    {INT64_C(1380575035111689000), 0x0003, 0x0035, 2816},
    {INT64_C(1380575035111689000), 0x0003, 0x0036, 5542},
    {INT64_C(1380575035111689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035111689000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035111689000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035111689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035111689000), 0x0003, 0x0035, 2138},
    {INT64_C(1380575035111689000), 0x0003, 0x0036, 5130},
    {INT64_C(1380575035111689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035111689000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035111689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035111689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035111689000), 0x0003, 0x0035, 2116},
    {INT64_C(1380575035111689000), 0x0003, 0x0036, 3849},
    {INT64_C(1380575035111689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035111689000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035111689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035111689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035111689000), 0x0003, 0x0035, 3189},
    {INT64_C(1380575035111689000), 0x0003, 0x0036, 1837},
    {INT64_C(1380575035111689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035111689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035111689000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035111689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035111689000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035129691000), 0x0003, 0x0000, 2890},
    {INT64_C(1380575035129691000), 0x0003, 0x0001, 5440},
    {INT64_C(1380575035129691000), 0x0003, 0x0035, 2890},
    {INT64_C(1380575035129691000), 0x0003, 0x0036, 5440},
    {INT64_C(1380575035129691000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035129691000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035129691000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035129691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035129691000), 0x0003, 0x0035, 2191},
    {INT64_C(1380575035129691000), 0x0003, 0x0036, 5020},
    {INT64_C(1380575035129691000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035129691000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035129691000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035129691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035129691000), 0x0003, 0x0035, 2186},
    {INT64_C(1380575035129691000), 0x0003, 0x0036, 3750},
    {INT64_C(1380575035129691000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035129691000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035129691000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035129691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035129691000), 0x0003, 0x0035, 3190},
    {INT64_C(1380575035129691000), 0x0003, 0x0036, 1837},
    {INT64_C(1380575035129691000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035129691000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035129691000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035129691000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035129691000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035147689000), 0x0003, 0x0000, 2944},
    {INT64_C(1380575035147689000), 0x0003, 0x0001, 5361},
    {INT64_C(1380575035147689000), 0x0003, 0x0035, 2944},
    {INT64_C(1380575035147689000), 0x0003, 0x0036, 5361},
    {INT64_C(1380575035147689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035147689000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035147689000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035147689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035147689000), 0x0003, 0x0035, 2244},
    {INT64_C(1380575035147689000), 0x0003, 0x0036, 4981},
    {INT64_C(1380575035147689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035147689000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035147689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035147689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035147689000), 0x0003, 0x0035, 2240},
    {INT64_C(1380575035147689000), 0x0003, 0x0036, 3724},
    {INT64_C(1380575035147689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035147689000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035147689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035147689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035147689000), 0x0003, 0x0035, 3189},
    {INT64_C(1380575035147689000), 0x0003, 0x0036, 1837},
    {INT64_C(1380575035147689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035147689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035147689000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035147689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035147689000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035167689000), 0x0003, 0x0000, 2996},
    {INT64_C(1380575035167689000), 0x0003, 0x0001, 5256},
    {INT64_C(1380575035167689000), 0x0003, 0x0035, 2996},
    {INT64_C(1380575035167689000), 0x0003, 0x0036, 5256},
    {INT64_C(1380575035167689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035167689000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035167689000), 0x0003, 0x0031, 384},
    {INT64_C(1380575035167689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035167689000), 0x0003, 0x0035, 2306},
    {INT64_C(1380575035167689000), 0x0003, 0x0036, 4882},
    {INT64_C(1380575035167689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035167689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035167689000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035167689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035167689000), 0x0003, 0x0035, 2305},
    {INT64_C(1380575035167689000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575035167689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035167689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035167689000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035167689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035167689000), 0x0003, 0x0035, 3187},
    {INT64_C(1380575035167689000), 0x0003, 0x0036, 1845},
    {INT64_C(1380575035167689000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035167689000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035167689000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035167689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035167689000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035185687000), 0x0003, 0x0000, 3080},
    {INT64_C(1380575035185687000), 0x0003, 0x0001, 5142},
    {INT64_C(1380575035185687000), 0x0003, 0x0035, 3080},
    {INT64_C(1380575035185687000), 0x0003, 0x0036, 5142},
    {INT64_C(1380575035185687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035185687000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035185687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035185687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035185687000), 0x0003, 0x0035, 2369},
    {INT64_C(1380575035185687000), 0x0003, 0x0036, 4817},
    {INT64_C(1380575035185687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035185687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035185687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035185687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035185687000), 0x0003, 0x0035, 2381},
    {INT64_C(1380575035185687000), 0x0003, 0x0036, 3558},
    {INT64_C(1380575035185687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035185687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035185687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035185687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035185687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035203687000), 0x0003, 0x0000, 3160},
    {INT64_C(1380575035203687000), 0x0003, 0x0001, 5010},
    {INT64_C(1380575035203687000), 0x0003, 0x0035, 3160},
    {INT64_C(1380575035203687000), 0x0003, 0x0036, 5010},
    {INT64_C(1380575035203687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035203687000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035203687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035203687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035203687000), 0x0003, 0x0035, 2459},
    {INT64_C(1380575035203687000), 0x0003, 0x0036, 4676},
    {INT64_C(1380575035203687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035203687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035203687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035203687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035203687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035223689000), 0x0003, 0x0000, 3228},
    {INT64_C(1380575035223689000), 0x0003, 0x0001, 4848},
    {INT64_C(1380575035223689000), 0x0003, 0x0035, 3228},
    {INT64_C(1380575035223689000), 0x0003, 0x0036, 4848},
    {INT64_C(1380575035223689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035223689000), 0x0003, 0x0030, 640},
    {INT64_C(1380575035223689000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035223689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035223689000), 0x0003, 0x0035, 2564},
    {INT64_C(1380575035223689000), 0x0003, 0x0036, 4446},
    {INT64_C(1380575035223689000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035223689000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035223689000), 0x0003, 0x0031, 384},
    {INT64_C(1380575035223689000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035223689000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035241682000), 0x0003, 0x0000, 3357},
    {INT64_C(1380575035241682000), 0x0003, 0x0001, 4677},
    {INT64_C(1380575035241682000), 0x0003, 0x0035, 3357},
    {INT64_C(1380575035241682000), 0x0003, 0x0036, 4677},
    {INT64_C(1380575035241682000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035241682000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035241682000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035241682000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035241682000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035335683000), 0x0001, 0x014d, 0},
    {INT64_C(1380575035335683000), 0x0001, 0x014a, 0},
    {INT64_C(1380575035335683000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035659684000), 0x0003, 0x0000, 6528},
    {INT64_C(1380575035659684000), 0x0003, 0x0001, 5874},
    {INT64_C(1380575035659684000), 0x0003, 0x0035, 6528},
    {INT64_C(1380575035659684000), 0x0003, 0x0036, 5874},
    {INT64_C(1380575035659684000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035659684000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035659684000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035659684000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035659684000), 0x0001, 0x014d, 1},
    {INT64_C(1380575035659684000), 0x0001, 0x014a, 1},
    {INT64_C(1380575035659684000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035673684000), 0x0003, 0x0001, 5846},
    {INT64_C(1380575035673684000), 0x0003, 0x0035, 6528},
    {INT64_C(1380575035673684000), 0x0003, 0x0036, 5846},
    {INT64_C(1380575035673684000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035673684000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035673684000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035673684000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035673684000), 0x0003, 0x0035, 3659},
    {INT64_C(1380575035673684000), 0x0003, 0x0036, 5348},
    {INT64_C(1380575035673684000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035673684000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035673684000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035673684000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035673684000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035679687000), 0x0003, 0x0001, 5837},
    {INT64_C(1380575035679687000), 0x0003, 0x0035, 6528},
    {INT64_C(1380575035679687000), 0x0003, 0x0036, 5837},
    {INT64_C(1380575035679687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035679687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035679687000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035679687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035679687000), 0x0003, 0x0035, 3642},
    {INT64_C(1380575035679687000), 0x0003, 0x0036, 5359},
    {INT64_C(1380575035679687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035679687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035679687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035679687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035679687000), 0x0003, 0x0035, 3759},
    {INT64_C(1380575035679687000), 0x0003, 0x0036, 1651},
    {INT64_C(1380575035679687000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035679687000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035679687000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035679687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035679687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035691685000), 0x0003, 0x0001, 5752},
    {INT64_C(1380575035691685000), 0x0003, 0x0035, 6528},
    {INT64_C(1380575035691685000), 0x0003, 0x0036, 5752},
    {INT64_C(1380575035691685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035691685000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035691685000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035691685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035691685000), 0x0003, 0x0035, 3640},
    {INT64_C(1380575035691685000), 0x0003, 0x0036, 5348},
    {INT64_C(1380575035691685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035691685000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035691685000), 0x0003, 0x0031, 384},
    {INT64_C(1380575035691685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035691685000), 0x0003, 0x0035, 3754},
    {INT64_C(1380575035691685000), 0x0003, 0x0036, 1661},
    {INT64_C(1380575035691685000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035691685000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035691685000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035691685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035691685000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035697686000), 0x0003, 0x0000, 4368},
    {INT64_C(1380575035697686000), 0x0003, 0x0001, 6400},
    {INT64_C(1380575035697686000), 0x0003, 0x0035, 4368},
    {INT64_C(1380575035697686000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575035697686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035697686000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035697686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035697686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035697686000), 0x0003, 0x0035, 6471},
    {INT64_C(1380575035697686000), 0x0003, 0x0036, 5548},
    {INT64_C(1380575035697686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035697686000), 0x0003, 0x0030, 640},
    {INT64_C(1380575035697686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035697686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035697686000), 0x0003, 0x0035, 3642},
    {INT64_C(1380575035697686000), 0x0003, 0x0036, 5340},
    {INT64_C(1380575035697686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035697686000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035697686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035697686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035697686000), 0x0003, 0x0035, 3763},
    {INT64_C(1380575035697686000), 0x0003, 0x0036, 1652},
    {INT64_C(1380575035697686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035697686000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035697686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035697686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035697686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035709683000), 0x0003, 0x0000, 4339},
    {INT64_C(1380575035709683000), 0x0003, 0x0035, 4339},
    {INT64_C(1380575035709683000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575035709683000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035709683000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035709683000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035709683000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035709683000), 0x0003, 0x0035, 5176},
    {INT64_C(1380575035709683000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575035709683000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035709683000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035709683000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035709683000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035709683000), 0x0003, 0x0035, 3649},
    {INT64_C(1380575035709683000), 0x0003, 0x0036, 5336},
    {INT64_C(1380575035709683000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035709683000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035709683000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035709683000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035709683000), 0x0003, 0x0035, 6454},
    {INT64_C(1380575035709683000), 0x0003, 0x0036, 5352},
    {INT64_C(1380575035709683000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035709683000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035709683000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035709683000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035709683000), 0x0003, 0x0035, 3768},
    {INT64_C(1380575035709683000), 0x0003, 0x0036, 1661},
    {INT64_C(1380575035709683000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035709683000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035709683000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035709683000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035709683000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035715688000), 0x0003, 0x0000, 4323},
    {INT64_C(1380575035715688000), 0x0003, 0x0001, 6354},
    {INT64_C(1380575035715688000), 0x0003, 0x0035, 4323},
    {INT64_C(1380575035715688000), 0x0003, 0x0036, 6354},
    {INT64_C(1380575035715688000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035715688000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035715688000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035715688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035715688000), 0x0003, 0x0035, 5186},
    {INT64_C(1380575035715688000), 0x0003, 0x0036, 6349},
    {INT64_C(1380575035715688000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035715688000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035715688000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035715688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035715688000), 0x0003, 0x0035, 3641},
    {INT64_C(1380575035715688000), 0x0003, 0x0036, 5308},
    {INT64_C(1380575035715688000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035715688000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035715688000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035715688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035715688000), 0x0003, 0x0035, 6430},
    {INT64_C(1380575035715688000), 0x0003, 0x0036, 5194},
    {INT64_C(1380575035715688000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035715688000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035715688000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035715688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035715688000), 0x0003, 0x0035, 3779},
    {INT64_C(1380575035715688000), 0x0003, 0x0036, 1660},
    {INT64_C(1380575035715688000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035715688000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035715688000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035715688000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035715688000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0000, 4304},
    {INT64_C(1380575035727687000), 0x0003, 0x0001, 6312},
    {INT64_C(1380575035727687000), 0x0003, 0x0035, 4304},
    {INT64_C(1380575035727687000), 0x0003, 0x0036, 6312},
    {INT64_C(1380575035727687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035727687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035727687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0035, 5186},
    {INT64_C(1380575035727687000), 0x0003, 0x0036, 6277},
    {INT64_C(1380575035727687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035727687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035727687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0035, 3610},
    {INT64_C(1380575035727687000), 0x0003, 0x0036, 5219},
    {INT64_C(1380575035727687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035727687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035727687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0035, 6400},
    {INT64_C(1380575035727687000), 0x0003, 0x0036, 5048},
    {INT64_C(1380575035727687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035727687000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035727687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0035, 3776},
    {INT64_C(1380575035727687000), 0x0003, 0x0036, 1658},
    {INT64_C(1380575035727687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035727687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035727687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035727687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035727687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035733686000), 0x0003, 0x0000, 4292},
    {INT64_C(1380575035733686000), 0x0003, 0x0001, 6240},
    {INT64_C(1380575035733686000), 0x0003, 0x0035, 4292},
    {INT64_C(1380575035733686000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575035733686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035733686000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035733686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035733686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035733686000), 0x0003, 0x0035, 5184},
    {INT64_C(1380575035733686000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575035733686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035733686000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035733686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035733686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035733686000), 0x0003, 0x0035, 3567},
    {INT64_C(1380575035733686000), 0x0003, 0x0036, 5157},
    {INT64_C(1380575035733686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035733686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035733686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035733686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035733686000), 0x0003, 0x0035, 6400},
    {INT64_C(1380575035733686000), 0x0003, 0x0036, 4898},
    {INT64_C(1380575035733686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035733686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035733686000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035733686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035733686000), 0x0003, 0x0035, 3789},
    {INT64_C(1380575035733686000), 0x0003, 0x0036, 1600},
    {INT64_C(1380575035733686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035733686000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035733686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035733686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035733686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0000, 4294},
    {INT64_C(1380575035747687000), 0x0003, 0x0001, 6175},
    {INT64_C(1380575035747687000), 0x0003, 0x0035, 4294},
    {INT64_C(1380575035747687000), 0x0003, 0x0036, 6175},
    {INT64_C(1380575035747687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035747687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035747687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0035, 5184},
    {INT64_C(1380575035747687000), 0x0003, 0x0036, 6175},
    {INT64_C(1380575035747687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035747687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035747687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0035, 3558},
    {INT64_C(1380575035747687000), 0x0003, 0x0036, 5031},
    {INT64_C(1380575035747687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035747687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035747687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0035, 6400},
    {INT64_C(1380575035747687000), 0x0003, 0x0036, 4806},
    {INT64_C(1380575035747687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035747687000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035747687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035747687000), 0x0003, 0x0035, 3801},
    {INT64_C(1380575035747687000), 0x0003, 0x0036, 1600},
    {INT64_C(1380575035747687000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035747687000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035747687000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035747687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035747687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0000, 4285},
    {INT64_C(1380575035765686000), 0x0003, 0x0001, 6151},
    {INT64_C(1380575035765686000), 0x0003, 0x0035, 4285},
    {INT64_C(1380575035765686000), 0x0003, 0x0036, 6151},
    {INT64_C(1380575035765686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035765686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035765686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0035, 5179},
    {INT64_C(1380575035765686000), 0x0003, 0x0036, 6115},
    {INT64_C(1380575035765686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035765686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035765686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0035, 3527},
    {INT64_C(1380575035765686000), 0x0003, 0x0036, 4976},
    {INT64_C(1380575035765686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035765686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035765686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0035, 6329},
    {INT64_C(1380575035765686000), 0x0003, 0x0036, 4747},
    {INT64_C(1380575035765686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035765686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035765686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035765686000), 0x0003, 0x0035, 3824},
    {INT64_C(1380575035765686000), 0x0003, 0x0036, 1600},
    {INT64_C(1380575035765686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035765686000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035765686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035765686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035765686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0000, 4290},
    {INT64_C(1380575035785686000), 0x0003, 0x0001, 6054},
    {INT64_C(1380575035785686000), 0x0003, 0x0035, 4290},
    {INT64_C(1380575035785686000), 0x0003, 0x0036, 6054},
    {INT64_C(1380575035785686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035785686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035785686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0035, 5173},
    {INT64_C(1380575035785686000), 0x0003, 0x0036, 6033},
    {INT64_C(1380575035785686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035785686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035785686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0035, 3512},
    {INT64_C(1380575035785686000), 0x0003, 0x0036, 4947},
    {INT64_C(1380575035785686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035785686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035785686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0035, 6290},
    {INT64_C(1380575035785686000), 0x0003, 0x0036, 4683},
    {INT64_C(1380575035785686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035785686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035785686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035785686000), 0x0003, 0x0035, 3875},
    {INT64_C(1380575035785686000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575035785686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035785686000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035785686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035785686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035785686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035803686000), 0x0003, 0x0000, 4263},
    {INT64_C(1380575035803686000), 0x0003, 0x0001, 6023},
    {INT64_C(1380575035803686000), 0x0003, 0x0035, 4263},
    {INT64_C(1380575035803686000), 0x0003, 0x0036, 6023},
    {INT64_C(1380575035803686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035803686000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035803686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035803686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035803686000), 0x0003, 0x0035, 5167},
    {INT64_C(1380575035803686000), 0x0003, 0x0036, 5984},
    {INT64_C(1380575035803686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035803686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035803686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035803686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035803686000), 0x0003, 0x0035, 3508},
    {INT64_C(1380575035803686000), 0x0003, 0x0036, 4910},
    {INT64_C(1380575035803686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035803686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035803686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035803686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035803686000), 0x0003, 0x0035, 6272},
    {INT64_C(1380575035803686000), 0x0003, 0x0036, 4545},
    {INT64_C(1380575035803686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035803686000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035803686000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035803686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035803686000), 0x0003, 0x0035, 3902},
    {INT64_C(1380575035803686000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575035803686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035803686000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035803686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035803686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035803686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035821685000), 0x0003, 0x0000, 4239},
    {INT64_C(1380575035821685000), 0x0003, 0x0001, 5992},
    {INT64_C(1380575035821685000), 0x0003, 0x0035, 4239},
    {INT64_C(1380575035821685000), 0x0003, 0x0036, 5992},
    {INT64_C(1380575035821685000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035821685000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035821685000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035821685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035821685000), 0x0003, 0x0035, 5175},
    {INT64_C(1380575035821685000), 0x0003, 0x0036, 5949},
    {INT64_C(1380575035821685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035821685000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035821685000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035821685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035821685000), 0x0003, 0x0035, 3503},
    {INT64_C(1380575035821685000), 0x0003, 0x0036, 4876},
    {INT64_C(1380575035821685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035821685000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035821685000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035821685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035821685000), 0x0003, 0x0035, 6272},
    {INT64_C(1380575035821685000), 0x0003, 0x0036, 4480},
    {INT64_C(1380575035821685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035821685000), 0x0003, 0x0030, 640},
    {INT64_C(1380575035821685000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035821685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035821685000), 0x0003, 0x0035, 3921},
    {INT64_C(1380575035821685000), 0x0003, 0x0036, 1760},
    {INT64_C(1380575035821685000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035821685000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035821685000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035821685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035821685000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035841686000), 0x0003, 0x0000, 4221},
    {INT64_C(1380575035841686000), 0x0003, 0x0001, 5960},
    {INT64_C(1380575035841686000), 0x0003, 0x0035, 4221},
    {INT64_C(1380575035841686000), 0x0003, 0x0036, 5960},
    {INT64_C(1380575035841686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035841686000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035841686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035841686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035841686000), 0x0003, 0x0035, 5172},
    {INT64_C(1380575035841686000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575035841686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035841686000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035841686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035841686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035841686000), 0x0003, 0x0035, 3494},
    {INT64_C(1380575035841686000), 0x0003, 0x0036, 4839},
    {INT64_C(1380575035841686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035841686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035841686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035841686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035841686000), 0x0003, 0x0035, 6210},
    {INT64_C(1380575035841686000), 0x0003, 0x0036, 4404},
    {INT64_C(1380575035841686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035841686000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035841686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035841686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035841686000), 0x0003, 0x0035, 3955},
    {INT64_C(1380575035841686000), 0x0003, 0x0036, 1847},
    {INT64_C(1380575035841686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035841686000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035841686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035841686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035841686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035859686000), 0x0003, 0x0000, 4200},
    {INT64_C(1380575035859686000), 0x0003, 0x0001, 5878},
    {INT64_C(1380575035859686000), 0x0003, 0x0035, 4200},
    {INT64_C(1380575035859686000), 0x0003, 0x0036, 5878},
    {INT64_C(1380575035859686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035859686000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035859686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035859686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035859686000), 0x0003, 0x0035, 5161},
    {INT64_C(1380575035859686000), 0x0003, 0x0036, 5839},
    {INT64_C(1380575035859686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035859686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035859686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035859686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035859686000), 0x0003, 0x0035, 3500},
    {INT64_C(1380575035859686000), 0x0003, 0x0036, 4797},
    {INT64_C(1380575035859686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035859686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035859686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035859686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035859686000), 0x0003, 0x0035, 6152},
    {INT64_C(1380575035859686000), 0x0003, 0x0036, 4357},
    {INT64_C(1380575035859686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035859686000), 0x0003, 0x0030, 640},
    {INT64_C(1380575035859686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035859686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035859686000), 0x0003, 0x0035, 4006},
    {INT64_C(1380575035859686000), 0x0003, 0x0036, 1889},
    {INT64_C(1380575035859686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035859686000), 0x0003, 0x0030, 512},
    {INT64_C(1380575035859686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035859686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035859686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0000, 4174},
    {INT64_C(1380575035877685000), 0x0003, 0x0001, 5842},
    {INT64_C(1380575035877685000), 0x0003, 0x0035, 4174},
    {INT64_C(1380575035877685000), 0x0003, 0x0036, 5842},
    {INT64_C(1380575035877685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035877685000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035877685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0035, 5149},
    {INT64_C(1380575035877685000), 0x0003, 0x0036, 5739},
    {INT64_C(1380575035877685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035877685000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035877685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0035, 3485},
    {INT64_C(1380575035877685000), 0x0003, 0x0036, 4762},
    {INT64_C(1380575035877685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035877685000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035877685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0035, 4152},
    {INT64_C(1380575035877685000), 0x0003, 0x0036, 4230},
    {INT64_C(1380575035877685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035877685000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035877685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0035, 6144},
    {INT64_C(1380575035877685000), 0x0003, 0x0036, 4218},
    {INT64_C(1380575035877685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035877685000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035877685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035877685000), 0x0003, 0x0035, 4067},
    {INT64_C(1380575035877685000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575035877685000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035877685000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035877685000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035877685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035877685000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0000, 4161},
    {INT64_C(1380575035897685000), 0x0003, 0x0001, 5725},
    {INT64_C(1380575035897685000), 0x0003, 0x0035, 4161},
    {INT64_C(1380575035897685000), 0x0003, 0x0036, 5725},
    {INT64_C(1380575035897685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035897685000), 0x0003, 0x0031, 384},
    {INT64_C(1380575035897685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0035, 5120},
    {INT64_C(1380575035897685000), 0x0003, 0x0036, 5655},
    {INT64_C(1380575035897685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035897685000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035897685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0035, 3465},
    {INT64_C(1380575035897685000), 0x0003, 0x0036, 4669},
    {INT64_C(1380575035897685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035897685000), 0x0003, 0x0031, 384},
    {INT64_C(1380575035897685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0035, 6066},
    {INT64_C(1380575035897685000), 0x0003, 0x0036, 4142},
    {INT64_C(1380575035897685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035897685000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035897685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035897685000), 0x0003, 0x0035, 4110},
    {INT64_C(1380575035897685000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575035897685000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035897685000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035897685000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035897685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035897685000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035915686000), 0x0003, 0x0000, 4130},
    {INT64_C(1380575035915686000), 0x0003, 0x0001, 5646},
    {INT64_C(1380575035915686000), 0x0003, 0x0035, 4130},
    {INT64_C(1380575035915686000), 0x0003, 0x0036, 5646},
    {INT64_C(1380575035915686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035915686000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035915686000), 0x0003, 0x0031, 384},
    {INT64_C(1380575035915686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035915686000), 0x0003, 0x0035, 5080},
    {INT64_C(1380575035915686000), 0x0003, 0x0036, 5530},
    {INT64_C(1380575035915686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035915686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035915686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035915686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035915686000), 0x0003, 0x0035, 3455},
    {INT64_C(1380575035915686000), 0x0003, 0x0036, 4588},
    {INT64_C(1380575035915686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035915686000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035915686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035915686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035915686000), 0x0003, 0x0035, 6016},
    {INT64_C(1380575035915686000), 0x0003, 0x0036, 4070},
    {INT64_C(1380575035915686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035915686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035915686000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035915686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035915686000), 0x0003, 0x0035, 4122},
    {INT64_C(1380575035915686000), 0x0003, 0x0036, 2048},
    {INT64_C(1380575035915686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035915686000), 0x0003, 0x0030, 384},
    {INT64_C(1380575035915686000), 0x0003, 0x0031, 320},
    {INT64_C(1380575035915686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035915686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035933684000), 0x0003, 0x0000, 4068},
    {INT64_C(1380575035933684000), 0x0003, 0x0001, 5519},
    {INT64_C(1380575035933684000), 0x0003, 0x0035, 4068},
    {INT64_C(1380575035933684000), 0x0003, 0x0036, 5519},
    {INT64_C(1380575035933684000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035933684000), 0x0003, 0x0030, 640},
    {INT64_C(1380575035933684000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035933684000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035933684000), 0x0003, 0x0035, 5080},
    {INT64_C(1380575035933684000), 0x0003, 0x0036, 5383},
    {INT64_C(1380575035933684000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035933684000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035933684000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035933684000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035933684000), 0x0003, 0x0035, 3456},
    {INT64_C(1380575035933684000), 0x0003, 0x0036, 4450},
    {INT64_C(1380575035933684000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035933684000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035933684000), 0x0003, 0x0031, 128},
    {INT64_C(1380575035933684000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035933684000), 0x0003, 0x0035, 4149},
    {INT64_C(1380575035933684000), 0x0003, 0x0036, 2080},
    {INT64_C(1380575035933684000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035933684000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035933684000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035933684000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035933684000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035953686000), 0x0003, 0x0000, 4063},
    {INT64_C(1380575035953686000), 0x0003, 0x0001, 5398},
    {INT64_C(1380575035953686000), 0x0003, 0x0035, 4063},
    {INT64_C(1380575035953686000), 0x0003, 0x0036, 5398},
    {INT64_C(1380575035953686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035953686000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035953686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035953686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035953686000), 0x0003, 0x0035, 5059},
    {INT64_C(1380575035953686000), 0x0003, 0x0036, 5328},
    {INT64_C(1380575035953686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035953686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035953686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035953686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035953686000), 0x0003, 0x0035, 3432},
    {INT64_C(1380575035953686000), 0x0003, 0x0036, 4345},
    {INT64_C(1380575035953686000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035953686000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035953686000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035953686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035953686000), 0x0003, 0x0035, 4172},
    {INT64_C(1380575035953686000), 0x0003, 0x0036, 2080},
    {INT64_C(1380575035953686000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035953686000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035953686000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035953686000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035953686000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035971687000), 0x0003, 0x0000, 4044},
    {INT64_C(1380575035971687000), 0x0003, 0x0001, 5267},
    {INT64_C(1380575035971687000), 0x0003, 0x0035, 4044},
    {INT64_C(1380575035971687000), 0x0003, 0x0036, 5267},
    {INT64_C(1380575035971687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035971687000), 0x0003, 0x0030, 480},
    {INT64_C(1380575035971687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035971687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035971687000), 0x0003, 0x0035, 5042},
    {INT64_C(1380575035971687000), 0x0003, 0x0036, 5164},
    {INT64_C(1380575035971687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035971687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035971687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035971687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035971687000), 0x0003, 0x0035, 3402},
    {INT64_C(1380575035971687000), 0x0003, 0x0036, 4174},
    {INT64_C(1380575035971687000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035971687000), 0x0003, 0x0030, 320},
    {INT64_C(1380575035971687000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035971687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035971687000), 0x0003, 0x0035, 4209},
    {INT64_C(1380575035971687000), 0x0003, 0x0036, 2080},
    {INT64_C(1380575035971687000), 0x0003, 0x0034, 1},
    {INT64_C(1380575035971687000), 0x0003, 0x0030, 256},
    {INT64_C(1380575035971687000), 0x0003, 0x0031, 160},
    {INT64_C(1380575035971687000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035971687000), 0x0000, 0x0000, 0},
    {INT64_C(1380575035989681000), 0x0003, 0x0000, 4020},
    {INT64_C(1380575035989681000), 0x0003, 0x0001, 5097},
    {INT64_C(1380575035989681000), 0x0003, 0x0035, 4020},
    {INT64_C(1380575035989681000), 0x0003, 0x0036, 5097},
    {INT64_C(1380575035989681000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035989681000), 0x0003, 0x0030, 640},
    {INT64_C(1380575035989681000), 0x0003, 0x0031, 384},
    {INT64_C(1380575035989681000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035989681000), 0x0003, 0x0035, 5015},
    {INT64_C(1380575035989681000), 0x0003, 0x0036, 4901},
    {INT64_C(1380575035989681000), 0x0003, 0x0034, 0},
    {INT64_C(1380575035989681000), 0x0003, 0x0030, 640},
    {INT64_C(1380575035989681000), 0x0003, 0x0031, 256},
    {INT64_C(1380575035989681000), 0x0000, 0x0002, 0},
    {INT64_C(1380575035989681000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036009685000), 0x0003, 0x0000, 3961},
    {INT64_C(1380575036009685000), 0x0003, 0x0001, 4913},
    {INT64_C(1380575036009685000), 0x0003, 0x0035, 3961},
    {INT64_C(1380575036009685000), 0x0003, 0x0036, 4913},
    {INT64_C(1380575036009685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036009685000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036009685000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036009685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036009685000), 0x0003, 0x0035, 4947},
    {INT64_C(1380575036009685000), 0x0003, 0x0036, 4742},
    {INT64_C(1380575036009685000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036009685000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036009685000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036009685000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036009685000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036027682000), 0x0003, 0x0000, 3882},
    {INT64_C(1380575036027682000), 0x0003, 0x0001, 4672},
    {INT64_C(1380575036027682000), 0x0003, 0x0035, 3882},
    {INT64_C(1380575036027682000), 0x0003, 0x0036, 4672},
    {INT64_C(1380575036027682000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036027682000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036027682000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036027682000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036027682000), 0x0003, 0x0035, 4899},
    {INT64_C(1380575036027682000), 0x0003, 0x0036, 4577},
    {INT64_C(1380575036027682000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036027682000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036027682000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036027682000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036027682000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036045681000), 0x0003, 0x0000, 4833},
    {INT64_C(1380575036045681000), 0x0003, 0x0001, 4427},
    {INT64_C(1380575036045681000), 0x0003, 0x0035, 4833},
    {INT64_C(1380575036045681000), 0x0003, 0x0036, 4427},
    {INT64_C(1380575036045681000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036045681000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036045681000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036045681000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036045681000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036065680000), 0x0003, 0x0000, 4630},
    {INT64_C(1380575036065680000), 0x0003, 0x0001, 4180},
    {INT64_C(1380575036065680000), 0x0003, 0x0035, 4630},
    {INT64_C(1380575036065680000), 0x0003, 0x0036, 4180},
    {INT64_C(1380575036065680000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036065680000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036065680000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036065680000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036065680000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036157678000), 0x0001, 0x014d, 0},
    {INT64_C(1380575036157678000), 0x0001, 0x014a, 0},
    {INT64_C(1380575036157678000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036533677000), 0x0003, 0x0035, 952},
    {INT64_C(1380575036533677000), 0x0003, 0x0036, 3520},
    {INT64_C(1380575036533677000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036533677000), 0x0003, 0x0030, 256},
    {INT64_C(1380575036533677000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036533677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036533677000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036539679000), 0x0003, 0x0000, 1080},
    {INT64_C(1380575036539679000), 0x0003, 0x0001, 4927},
    {INT64_C(1380575036539679000), 0x0003, 0x0035, 1080},
    {INT64_C(1380575036539679000), 0x0003, 0x0036, 4927},
    {INT64_C(1380575036539679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036539679000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036539679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036539679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036539679000), 0x0003, 0x0035, 973},
    {INT64_C(1380575036539679000), 0x0003, 0x0036, 3520},
    {INT64_C(1380575036539679000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036539679000), 0x0003, 0x0030, 256},
    {INT64_C(1380575036539679000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036539679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036539679000), 0x0001, 0x014d, 1},
    {INT64_C(1380575036539679000), 0x0001, 0x014a, 1},
    {INT64_C(1380575036539679000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036551678000), 0x0003, 0x0000, 1103},
    {INT64_C(1380575036551678000), 0x0003, 0x0001, 4910},
    {INT64_C(1380575036551678000), 0x0003, 0x0035, 1103},
    {INT64_C(1380575036551678000), 0x0003, 0x0036, 4910},
    {INT64_C(1380575036551678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036551678000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036551678000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036551678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036551678000), 0x0003, 0x0035, 1045},
    {INT64_C(1380575036551678000), 0x0003, 0x0036, 3520},
    {INT64_C(1380575036551678000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036551678000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036551678000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036551678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036551678000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036557678000), 0x0003, 0x0000, 1193},
    {INT64_C(1380575036557678000), 0x0003, 0x0001, 4862},
    {INT64_C(1380575036557678000), 0x0003, 0x0035, 1193},
    {INT64_C(1380575036557678000), 0x0003, 0x0036, 4862},
    {INT64_C(1380575036557678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036557678000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036557678000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036557678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036557678000), 0x0003, 0x0035, 1121},
    {INT64_C(1380575036557678000), 0x0003, 0x0036, 3401},
    {INT64_C(1380575036557678000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036557678000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036557678000), 0x0003, 0x0031, 320},
    {INT64_C(1380575036557678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036557678000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036571678000), 0x0003, 0x0000, 1247},
    {INT64_C(1380575036571678000), 0x0003, 0x0001, 4815},
    {INT64_C(1380575036571678000), 0x0003, 0x0035, 1247},
    {INT64_C(1380575036571678000), 0x0003, 0x0036, 4815},
    {INT64_C(1380575036571678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036571678000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036571678000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036571678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036571678000), 0x0003, 0x0035, 1221},
    {INT64_C(1380575036571678000), 0x0003, 0x0036, 3363},
    {INT64_C(1380575036571678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036571678000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036571678000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036571678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036571678000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036577674000), 0x0003, 0x0000, 1984},
    {INT64_C(1380575036577674000), 0x0003, 0x0001, 5275},
    {INT64_C(1380575036577674000), 0x0003, 0x0035, 1984},
    {INT64_C(1380575036577674000), 0x0003, 0x0036, 5275},
    {INT64_C(1380575036577674000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036577674000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036577674000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036577674000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036577674000), 0x0003, 0x0035, 1358},
    {INT64_C(1380575036577674000), 0x0003, 0x0036, 4718},
    {INT64_C(1380575036577674000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036577674000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036577674000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036577674000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036577674000), 0x0003, 0x0035, 1333},
    {INT64_C(1380575036577674000), 0x0003, 0x0036, 3360},
    {INT64_C(1380575036577674000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036577674000), 0x0003, 0x0030, 256},
    {INT64_C(1380575036577674000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036577674000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036577674000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036589676000), 0x0003, 0x0000, 2048},
    {INT64_C(1380575036589676000), 0x0003, 0x0001, 5240},
    {INT64_C(1380575036589676000), 0x0003, 0x0035, 2048},
    {INT64_C(1380575036589676000), 0x0003, 0x0036, 5240},
    {INT64_C(1380575036589676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036589676000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036589676000), 0x0003, 0x0031, 128},
    {INT64_C(1380575036589676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036589676000), 0x0003, 0x0035, 1466},
    {INT64_C(1380575036589676000), 0x0003, 0x0036, 4659},
    {INT64_C(1380575036589676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036589676000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036589676000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036589676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036589676000), 0x0003, 0x0035, 1417},
    {INT64_C(1380575036589676000), 0x0003, 0x0036, 3200},
    {INT64_C(1380575036589676000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036589676000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036589676000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036589676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036589676000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036595680000), 0x0003, 0x0000, 2170},
    {INT64_C(1380575036595680000), 0x0003, 0x0001, 5172},
    {INT64_C(1380575036595680000), 0x0003, 0x0035, 2170},
    {INT64_C(1380575036595680000), 0x0003, 0x0036, 5172},
    {INT64_C(1380575036595680000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036595680000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036595680000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036595680000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036595680000), 0x0003, 0x0035, 1593},
    {INT64_C(1380575036595680000), 0x0003, 0x0036, 4599},
    {INT64_C(1380575036595680000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036595680000), 0x0003, 0x0030, 800},
    {INT64_C(1380575036595680000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036595680000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036595680000), 0x0003, 0x0035, 1559},
    {INT64_C(1380575036595680000), 0x0003, 0x0036, 3200},
    {INT64_C(1380575036595680000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036595680000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036595680000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036595680000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036595680000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036607679000), 0x0003, 0x0000, 2269},
    {INT64_C(1380575036607679000), 0x0003, 0x0001, 5126},
    {INT64_C(1380575036607679000), 0x0003, 0x0035, 2269},
    {INT64_C(1380575036607679000), 0x0003, 0x0036, 5126},
    {INT64_C(1380575036607679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036607679000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036607679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036607679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036607679000), 0x0003, 0x0035, 1722},
    {INT64_C(1380575036607679000), 0x0003, 0x0036, 4535},
    {INT64_C(1380575036607679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036607679000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036607679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036607679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036607679000), 0x0003, 0x0035, 1685},
    {INT64_C(1380575036607679000), 0x0003, 0x0036, 3123},
    {INT64_C(1380575036607679000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036607679000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036607679000), 0x0003, 0x0031, 320},
    {INT64_C(1380575036607679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036607679000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036613679000), 0x0003, 0x0000, 2418},
    {INT64_C(1380575036613679000), 0x0003, 0x0001, 5026},
    {INT64_C(1380575036613679000), 0x0003, 0x0035, 2418},
    {INT64_C(1380575036613679000), 0x0003, 0x0036, 5026},
    {INT64_C(1380575036613679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036613679000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036613679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036613679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036613679000), 0x0003, 0x0035, 1848},
    {INT64_C(1380575036613679000), 0x0003, 0x0036, 4494},
    {INT64_C(1380575036613679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036613679000), 0x0003, 0x0030, 800},
    {INT64_C(1380575036613679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036613679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036613679000), 0x0003, 0x0035, 1844},
    {INT64_C(1380575036613679000), 0x0003, 0x0036, 3106},
    {INT64_C(1380575036613679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036613679000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036613679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036613679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036613679000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036627676000), 0x0003, 0x0000, 2574},
    {INT64_C(1380575036627676000), 0x0003, 0x0001, 4994},
    {INT64_C(1380575036627676000), 0x0003, 0x0035, 2574},
    {INT64_C(1380575036627676000), 0x0003, 0x0036, 4994},
    {INT64_C(1380575036627676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036627676000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036627676000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036627676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036627676000), 0x0003, 0x0035, 2003},
    {INT64_C(1380575036627676000), 0x0003, 0x0036, 4454},
    {INT64_C(1380575036627676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036627676000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036627676000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036627676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036627676000), 0x0003, 0x0035, 1992},
    {INT64_C(1380575036627676000), 0x0003, 0x0036, 3101},
    {INT64_C(1380575036627676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036627676000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036627676000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036627676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036627676000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036645678000), 0x0003, 0x0000, 2722},
    {INT64_C(1380575036645678000), 0x0003, 0x0001, 4901},
    {INT64_C(1380575036645678000), 0x0003, 0x0035, 2722},
    {INT64_C(1380575036645678000), 0x0003, 0x0036, 4901},
    {INT64_C(1380575036645678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036645678000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036645678000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036645678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036645678000), 0x0003, 0x0035, 2147},
    {INT64_C(1380575036645678000), 0x0003, 0x0036, 4438},
    {INT64_C(1380575036645678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036645678000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036645678000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036645678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036645678000), 0x0003, 0x0035, 2135},
    {INT64_C(1380575036645678000), 0x0003, 0x0036, 3040},
    {INT64_C(1380575036645678000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036645678000), 0x0003, 0x0030, 256},
    {INT64_C(1380575036645678000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036645678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036645678000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036663674000), 0x0003, 0x0000, 2901},
    {INT64_C(1380575036663674000), 0x0003, 0x0035, 2901},
    {INT64_C(1380575036663674000), 0x0003, 0x0036, 4901},
    {INT64_C(1380575036663674000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036663674000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036663674000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036663674000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036663674000), 0x0003, 0x0035, 2359},
    {INT64_C(1380575036663674000), 0x0003, 0x0036, 4389},
    {INT64_C(1380575036663674000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036663674000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036663674000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036663674000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036663674000), 0x0003, 0x0035, 2334},
    {INT64_C(1380575036663674000), 0x0003, 0x0036, 3040},
    {INT64_C(1380575036663674000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036663674000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036663674000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036663674000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036663674000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036683678000), 0x0003, 0x0000, 3055},
    {INT64_C(1380575036683678000), 0x0003, 0x0001, 4870},
    {INT64_C(1380575036683678000), 0x0003, 0x0035, 3055},
    {INT64_C(1380575036683678000), 0x0003, 0x0036, 4870},
    {INT64_C(1380575036683678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036683678000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036683678000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036683678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036683678000), 0x0003, 0x0035, 2529},
    {INT64_C(1380575036683678000), 0x0003, 0x0036, 4402},
    {INT64_C(1380575036683678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036683678000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036683678000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036683678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036683678000), 0x0003, 0x0035, 2512},
    {INT64_C(1380575036683678000), 0x0003, 0x0036, 3040},
    {INT64_C(1380575036683678000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036683678000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036683678000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036683678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036683678000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036701677000), 0x0003, 0x0000, 3245},
    {INT64_C(1380575036701677000), 0x0003, 0x0001, 4880},
    {INT64_C(1380575036701677000), 0x0003, 0x0035, 3245},
    {INT64_C(1380575036701677000), 0x0003, 0x0036, 4880},
    {INT64_C(1380575036701677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036701677000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036701677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036701677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036701677000), 0x0003, 0x0035, 2738},
    {INT64_C(1380575036701677000), 0x0003, 0x0036, 4444},
    {INT64_C(1380575036701677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036701677000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036701677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036701677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036701677000), 0x0003, 0x0035, 2690},
    {INT64_C(1380575036701677000), 0x0003, 0x0036, 3040},
    {INT64_C(1380575036701677000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036701677000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036701677000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036701677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036701677000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036719678000), 0x0003, 0x0000, 3436},
    {INT64_C(1380575036719678000), 0x0003, 0x0001, 4891},
    {INT64_C(1380575036719678000), 0x0003, 0x0035, 3436},
    {INT64_C(1380575036719678000), 0x0003, 0x0036, 4891},
    {INT64_C(1380575036719678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036719678000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036719678000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036719678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036719678000), 0x0003, 0x0035, 2892},
    {INT64_C(1380575036719678000), 0x0003, 0x0036, 4516},
    {INT64_C(1380575036719678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036719678000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036719678000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036719678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036719678000), 0x0003, 0x0035, 2872},
    {INT64_C(1380575036719678000), 0x0003, 0x0036, 3200},
    {INT64_C(1380575036719678000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036719678000), 0x0003, 0x0030, 256},
    {INT64_C(1380575036719678000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036719678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036719678000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036739674000), 0x0003, 0x0000, 3648},
    {INT64_C(1380575036739674000), 0x0003, 0x0001, 4982},
    {INT64_C(1380575036739674000), 0x0003, 0x0035, 3648},
    {INT64_C(1380575036739674000), 0x0003, 0x0036, 4982},
    {INT64_C(1380575036739674000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036739674000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036739674000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036739674000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036739674000), 0x0003, 0x0035, 3056},
    {INT64_C(1380575036739674000), 0x0003, 0x0036, 4599},
    {INT64_C(1380575036739674000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036739674000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036739674000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036739674000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036739674000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036757679000), 0x0003, 0x0000, 3861},
    {INT64_C(1380575036757679000), 0x0003, 0x0001, 5088},
    {INT64_C(1380575036757679000), 0x0003, 0x0035, 3861},
    {INT64_C(1380575036757679000), 0x0003, 0x0036, 5088},
    {INT64_C(1380575036757679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036757679000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036757679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036757679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036757679000), 0x0003, 0x0035, 3290},
    {INT64_C(1380575036757679000), 0x0003, 0x0036, 4771},
    {INT64_C(1380575036757679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036757679000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036757679000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036757679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036757679000), 0x0003, 0x0035, 3290},
    {INT64_C(1380575036757679000), 0x0003, 0x0036, 3360},
    {INT64_C(1380575036757679000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036757679000), 0x0003, 0x0030, 256},
    {INT64_C(1380575036757679000), 0x0003, 0x0031, 160},
    {INT64_C(1380575036757679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036757679000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036775678000), 0x0003, 0x0000, 4087},
    {INT64_C(1380575036775678000), 0x0003, 0x0001, 5170},
    {INT64_C(1380575036775678000), 0x0003, 0x0035, 4087},
    {INT64_C(1380575036775678000), 0x0003, 0x0036, 5170},
    {INT64_C(1380575036775678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036775678000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036775678000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036775678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036775678000), 0x0003, 0x0035, 3504},
    {INT64_C(1380575036775678000), 0x0003, 0x0036, 4907},
    {INT64_C(1380575036775678000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036775678000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036775678000), 0x0003, 0x0031, 320},
    {INT64_C(1380575036775678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036775678000), 0x0003, 0x0035, 3408},
    {INT64_C(1380575036775678000), 0x0003, 0x0036, 3656},
    {INT64_C(1380575036775678000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036775678000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036775678000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036775678000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036775678000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036795676000), 0x0003, 0x0000, 3681},
    {INT64_C(1380575036795676000), 0x0003, 0x0001, 5065},
    {INT64_C(1380575036795676000), 0x0003, 0x0035, 3681},
    {INT64_C(1380575036795676000), 0x0003, 0x0036, 5065},
    {INT64_C(1380575036795676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036795676000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036795676000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036795676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036795676000), 0x0003, 0x0035, 4231},
    {INT64_C(1380575036795676000), 0x0003, 0x0036, 5233},
    {INT64_C(1380575036795676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036795676000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036795676000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036795676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036795676000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036813677000), 0x0003, 0x0000, 3875},
    {INT64_C(1380575036813677000), 0x0003, 0x0001, 5189},
    {INT64_C(1380575036813677000), 0x0003, 0x0035, 3875},
    {INT64_C(1380575036813677000), 0x0003, 0x0036, 5189},
    {INT64_C(1380575036813677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036813677000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036813677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036813677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036813677000), 0x0003, 0x0035, 4457},
    {INT64_C(1380575036813677000), 0x0003, 0x0036, 5316},
    {INT64_C(1380575036813677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036813677000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036813677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036813677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036813677000), 0x0003, 0x0035, 3721},
    {INT64_C(1380575036813677000), 0x0003, 0x0036, 3895},
    {INT64_C(1380575036813677000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036813677000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036813677000), 0x0003, 0x0031, 320},
    {INT64_C(1380575036813677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036813677000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036833638000), 0x0003, 0x0000, 4558},
    {INT64_C(1380575036833638000), 0x0003, 0x0001, 5390},
    {INT64_C(1380575036833638000), 0x0003, 0x0035, 4558},
    {INT64_C(1380575036833638000), 0x0003, 0x0036, 5390},
    {INT64_C(1380575036833638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036833638000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036833638000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036833638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036833638000), 0x0003, 0x0035, 3978},
    {INT64_C(1380575036833638000), 0x0003, 0x0036, 5210},
    {INT64_C(1380575036833638000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036833638000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036833638000), 0x0003, 0x0031, 320},
    {INT64_C(1380575036833638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036833638000), 0x0003, 0x0035, 3804},
    {INT64_C(1380575036833638000), 0x0003, 0x0036, 3909},
    {INT64_C(1380575036833638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036833638000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036833638000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036833638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036833638000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036851679000), 0x0003, 0x0000, 4061},
    {INT64_C(1380575036851679000), 0x0003, 0x0001, 5228},
    {INT64_C(1380575036851679000), 0x0003, 0x0035, 4061},
    {INT64_C(1380575036851679000), 0x0003, 0x0036, 5228},
    {INT64_C(1380575036851679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036851679000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036851679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036851679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036851679000), 0x0003, 0x0035, 4628},
    {INT64_C(1380575036851679000), 0x0003, 0x0036, 5376},
    {INT64_C(1380575036851679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036851679000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036851679000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036851679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036851679000), 0x0003, 0x0035, 3840},
    {INT64_C(1380575036851679000), 0x0003, 0x0036, 3921},
    {INT64_C(1380575036851679000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036851679000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036851679000), 0x0003, 0x0031, 128},
    {INT64_C(1380575036851679000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036851679000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036869677000), 0x0003, 0x0000, 4089},
    {INT64_C(1380575036869677000), 0x0003, 0x0001, 5207},
    {INT64_C(1380575036869677000), 0x0003, 0x0035, 4089},
    {INT64_C(1380575036869677000), 0x0003, 0x0036, 5207},
    {INT64_C(1380575036869677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036869677000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036869677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036869677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036869677000), 0x0003, 0x0035, 4665},
    {INT64_C(1380575036869677000), 0x0003, 0x0036, 5375},
    {INT64_C(1380575036869677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036869677000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036869677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036869677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036869677000), 0x0003, 0x0035, 3840},
    {INT64_C(1380575036869677000), 0x0003, 0x0036, 3906},
    {INT64_C(1380575036869677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036869677000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036869677000), 0x0003, 0x0031, 128},
    {INT64_C(1380575036869677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036869677000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036889677000), 0x0003, 0x0000, 4664},
    {INT64_C(1380575036889677000), 0x0003, 0x0001, 5363},
    {INT64_C(1380575036889677000), 0x0003, 0x0035, 4664},
    {INT64_C(1380575036889677000), 0x0003, 0x0036, 5363},
    {INT64_C(1380575036889677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036889677000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036889677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036889677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036889677000), 0x0003, 0x0035, 4102},
    {INT64_C(1380575036889677000), 0x0003, 0x0036, 5192},
    {INT64_C(1380575036889677000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036889677000), 0x0003, 0x0030, 384},
    {INT64_C(1380575036889677000), 0x0003, 0x0031, 320},
    {INT64_C(1380575036889677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036889677000), 0x0003, 0x0035, 3790},
    {INT64_C(1380575036889677000), 0x0003, 0x0036, 3863},
    {INT64_C(1380575036889677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036889677000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036889677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036889677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036889677000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036907677000), 0x0003, 0x0000, 4074},
    {INT64_C(1380575036907677000), 0x0003, 0x0001, 5192},
    {INT64_C(1380575036907677000), 0x0003, 0x0035, 4074},
    {INT64_C(1380575036907677000), 0x0003, 0x0036, 5192},
    {INT64_C(1380575036907677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036907677000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036907677000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036907677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036907677000), 0x0003, 0x0035, 4658},
    {INT64_C(1380575036907677000), 0x0003, 0x0036, 5348},
    {INT64_C(1380575036907677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036907677000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036907677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036907677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036907677000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036925676000), 0x0003, 0x0000, 4636},
    {INT64_C(1380575036925676000), 0x0003, 0x0001, 5349},
    {INT64_C(1380575036925676000), 0x0003, 0x0035, 4636},
    {INT64_C(1380575036925676000), 0x0003, 0x0036, 5349},
    {INT64_C(1380575036925676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036925676000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036925676000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036925676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036925676000), 0x0003, 0x0035, 4022},
    {INT64_C(1380575036925676000), 0x0003, 0x0036, 5086},
    {INT64_C(1380575036925676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036925676000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036925676000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036925676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036925676000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036945669000), 0x0003, 0x0000, 4654},
    {INT64_C(1380575036945669000), 0x0003, 0x0001, 5277},
    {INT64_C(1380575036945669000), 0x0003, 0x0035, 4654},
    {INT64_C(1380575036945669000), 0x0003, 0x0036, 5277},
    {INT64_C(1380575036945669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036945669000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036945669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036945669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036945669000), 0x0003, 0x0035, 3865},
    {INT64_C(1380575036945669000), 0x0003, 0x0036, 4862},
    {INT64_C(1380575036945669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036945669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575036945669000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036945669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036945669000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036963675000), 0x0003, 0x0000, 4641},
    {INT64_C(1380575036963675000), 0x0003, 0x0001, 5111},
    {INT64_C(1380575036963675000), 0x0003, 0x0035, 4641},
    {INT64_C(1380575036963675000), 0x0003, 0x0036, 5111},
    {INT64_C(1380575036963675000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036963675000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036963675000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036963675000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036963675000), 0x0003, 0x0035, 3644},
    {INT64_C(1380575036963675000), 0x0003, 0x0036, 4550},
    {INT64_C(1380575036963675000), 0x0003, 0x0034, 1},
    {INT64_C(1380575036963675000), 0x0003, 0x0030, 512},
    {INT64_C(1380575036963675000), 0x0003, 0x0031, 480},
    {INT64_C(1380575036963675000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036963675000), 0x0000, 0x0000, 0},
    {INT64_C(1380575036981677000), 0x0003, 0x0000, 4506},
    {INT64_C(1380575036981677000), 0x0003, 0x0001, 4763},
    {INT64_C(1380575036981677000), 0x0003, 0x0035, 4506},
    {INT64_C(1380575036981677000), 0x0003, 0x0036, 4763},
    {INT64_C(1380575036981677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036981677000), 0x0003, 0x0030, 320},
    {INT64_C(1380575036981677000), 0x0003, 0x0031, 256},
    {INT64_C(1380575036981677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036981677000), 0x0003, 0x0035, 3456},
    {INT64_C(1380575036981677000), 0x0003, 0x0036, 4183},
    {INT64_C(1380575036981677000), 0x0003, 0x0034, 0},
    {INT64_C(1380575036981677000), 0x0003, 0x0030, 640},
    {INT64_C(1380575036981677000), 0x0003, 0x0031, 384},
    {INT64_C(1380575036981677000), 0x0000, 0x0002, 0},
    {INT64_C(1380575036981677000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037001676000), 0x0003, 0x0000, 4354},
    {INT64_C(1380575037001676000), 0x0003, 0x0001, 4440},
    {INT64_C(1380575037001676000), 0x0003, 0x0035, 4354},
    {INT64_C(1380575037001676000), 0x0003, 0x0036, 4440},
    {INT64_C(1380575037001676000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037001676000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037001676000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037001676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037001676000), 0x0003, 0x0035, 3292},
    {INT64_C(1380575037001676000), 0x0003, 0x0036, 4000},
    {INT64_C(1380575037001676000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037001676000), 0x0003, 0x0030, 256},
    {INT64_C(1380575037001676000), 0x0003, 0x0031, 160},
    {INT64_C(1380575037001676000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037001676000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037019675000), 0x0003, 0x0000, 4229},
    {INT64_C(1380575037019675000), 0x0003, 0x0001, 4085},
    {INT64_C(1380575037019675000), 0x0003, 0x0035, 4229},
    {INT64_C(1380575037019675000), 0x0003, 0x0036, 4085},
    {INT64_C(1380575037019675000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037019675000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037019675000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037019675000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037019675000), 0x0003, 0x0035, 3169},
    {INT64_C(1380575037019675000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575037019675000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037019675000), 0x0003, 0x0030, 256},
    {INT64_C(1380575037019675000), 0x0003, 0x0031, 160},
    {INT64_C(1380575037019675000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037019675000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037113670000), 0x0001, 0x014d, 0},
    {INT64_C(1380575037113670000), 0x0001, 0x014a, 0},
    {INT64_C(1380575037113670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037493671000), 0x0003, 0x0000, 1090},
    {INT64_C(1380575037493671000), 0x0003, 0x0001, 4241},
    {INT64_C(1380575037493671000), 0x0003, 0x0035, 1090},
    {INT64_C(1380575037493671000), 0x0003, 0x0036, 4241},
    {INT64_C(1380575037493671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037493671000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037493671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037493671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037493671000), 0x0001, 0x014d, 1},
    {INT64_C(1380575037493671000), 0x0001, 0x014a, 1},
    {INT64_C(1380575037493671000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037505672000), 0x0003, 0x0000, 1317},
    {INT64_C(1380575037505672000), 0x0003, 0x0001, 5657},
    {INT64_C(1380575037505672000), 0x0003, 0x0035, 1317},
    {INT64_C(1380575037505672000), 0x0003, 0x0036, 5657},
    {INT64_C(1380575037505672000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037505672000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037505672000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037505672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037505672000), 0x0003, 0x0035, 1096},
    {INT64_C(1380575037505672000), 0x0003, 0x0036, 4255},
    {INT64_C(1380575037505672000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037505672000), 0x0003, 0x0030, 800},
    {INT64_C(1380575037505672000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037505672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037505672000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037511672000), 0x0003, 0x0000, 1356},
    {INT64_C(1380575037511672000), 0x0003, 0x0001, 5613},
    {INT64_C(1380575037511672000), 0x0003, 0x0035, 1356},
    {INT64_C(1380575037511672000), 0x0003, 0x0036, 5613},
    {INT64_C(1380575037511672000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037511672000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037511672000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037511672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037511672000), 0x0003, 0x0035, 1110},
    {INT64_C(1380575037511672000), 0x0003, 0x0036, 4224},
    {INT64_C(1380575037511672000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037511672000), 0x0003, 0x0030, 640},
    {INT64_C(1380575037511672000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037511672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037511672000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037525671000), 0x0003, 0x0000, 1389},
    {INT64_C(1380575037525671000), 0x0003, 0x0001, 5544},
    {INT64_C(1380575037525671000), 0x0003, 0x0035, 1389},
    {INT64_C(1380575037525671000), 0x0003, 0x0036, 5544},
    {INT64_C(1380575037525671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037525671000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037525671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037525671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037525671000), 0x0003, 0x0035, 1175},
    {INT64_C(1380575037525671000), 0x0003, 0x0036, 4198},
    {INT64_C(1380575037525671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037525671000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037525671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037525671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037525671000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037531669000), 0x0003, 0x0000, 1464},
    {INT64_C(1380575037531669000), 0x0003, 0x0001, 5491},
    {INT64_C(1380575037531669000), 0x0003, 0x0035, 1464},
    {INT64_C(1380575037531669000), 0x0003, 0x0036, 5491},
    {INT64_C(1380575037531669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037531669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037531669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037531669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037531669000), 0x0003, 0x0035, 1247},
    {INT64_C(1380575037531669000), 0x0003, 0x0036, 4147},
    {INT64_C(1380575037531669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037531669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037531669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037531669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037531669000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037543669000), 0x0003, 0x0000, 1520},
    {INT64_C(1380575037543669000), 0x0003, 0x0001, 5427},
    {INT64_C(1380575037543669000), 0x0003, 0x0035, 1520},
    {INT64_C(1380575037543669000), 0x0003, 0x0036, 5427},
    {INT64_C(1380575037543669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037543669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037543669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037543669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037543669000), 0x0003, 0x0035, 1313},
    {INT64_C(1380575037543669000), 0x0003, 0x0036, 4108},
    {INT64_C(1380575037543669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037543669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037543669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037543669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037543669000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037549671000), 0x0003, 0x0000, 1615},
    {INT64_C(1380575037549671000), 0x0003, 0x0001, 5379},
    {INT64_C(1380575037549671000), 0x0003, 0x0035, 1615},
    {INT64_C(1380575037549671000), 0x0003, 0x0036, 5379},
    {INT64_C(1380575037549671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037549671000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037549671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037549671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037549671000), 0x0003, 0x0035, 1422},
    {INT64_C(1380575037549671000), 0x0003, 0x0036, 4070},
    {INT64_C(1380575037549671000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037549671000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037549671000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037549671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037549671000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037563633000), 0x0003, 0x0000, 1726},
    {INT64_C(1380575037563633000), 0x0003, 0x0001, 5345},
    {INT64_C(1380575037563633000), 0x0003, 0x0035, 1726},
    {INT64_C(1380575037563633000), 0x0003, 0x0036, 5345},
    {INT64_C(1380575037563633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037563633000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037563633000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037563633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037563633000), 0x0003, 0x0035, 1531},
    {INT64_C(1380575037563633000), 0x0003, 0x0036, 4067},
    {INT64_C(1380575037563633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037563633000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037563633000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037563633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037563633000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037569672000), 0x0003, 0x0000, 1839},
    {INT64_C(1380575037569672000), 0x0003, 0x0001, 5311},
    {INT64_C(1380575037569672000), 0x0003, 0x0035, 1839},
    {INT64_C(1380575037569672000), 0x0003, 0x0036, 5311},
    {INT64_C(1380575037569672000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037569672000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037569672000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037569672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037569672000), 0x0003, 0x0035, 1667},
    {INT64_C(1380575037569672000), 0x0003, 0x0036, 4048},
    {INT64_C(1380575037569672000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037569672000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037569672000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037569672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037569672000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037581672000), 0x0003, 0x0000, 1965},
    {INT64_C(1380575037581672000), 0x0003, 0x0001, 5222},
    {INT64_C(1380575037581672000), 0x0003, 0x0035, 1965},
    {INT64_C(1380575037581672000), 0x0003, 0x0036, 5222},
    {INT64_C(1380575037581672000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037581672000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037581672000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037581672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037581672000), 0x0003, 0x0035, 1802},
    {INT64_C(1380575037581672000), 0x0003, 0x0036, 4048},
    {INT64_C(1380575037581672000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037581672000), 0x0003, 0x0030, 512},
    {INT64_C(1380575037581672000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037581672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037581672000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037599670000), 0x0003, 0x0000, 2107},
    {INT64_C(1380575037599670000), 0x0003, 0x0001, 5194},
    {INT64_C(1380575037599670000), 0x0003, 0x0035, 2107},
    {INT64_C(1380575037599670000), 0x0003, 0x0036, 5194},
    {INT64_C(1380575037599670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037599670000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037599670000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037599670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037599670000), 0x0003, 0x0035, 1944},
    {INT64_C(1380575037599670000), 0x0003, 0x0036, 4032},
    {INT64_C(1380575037599670000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037599670000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037599670000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037599670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037599670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037619670000), 0x0003, 0x0000, 2272},
    {INT64_C(1380575037619670000), 0x0003, 0x0001, 5174},
    {INT64_C(1380575037619670000), 0x0003, 0x0035, 2272},
    {INT64_C(1380575037619670000), 0x0003, 0x0036, 5174},
    {INT64_C(1380575037619670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037619670000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037619670000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037619670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037619670000), 0x0003, 0x0035, 2109},
    {INT64_C(1380575037619670000), 0x0003, 0x0036, 4005},
    {INT64_C(1380575037619670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037619670000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037619670000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037619670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037619670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037637665000), 0x0003, 0x0000, 2459},
    {INT64_C(1380575037637665000), 0x0003, 0x0001, 5169},
    {INT64_C(1380575037637665000), 0x0003, 0x0035, 2459},
    {INT64_C(1380575037637665000), 0x0003, 0x0036, 5169},
    {INT64_C(1380575037637665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037637665000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037637665000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037637665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037637665000), 0x0003, 0x0035, 2306},
    {INT64_C(1380575037637665000), 0x0003, 0x0036, 4011},
    {INT64_C(1380575037637665000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037637665000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037637665000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037637665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037637665000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037655672000), 0x0003, 0x0000, 2638},
    {INT64_C(1380575037655672000), 0x0003, 0x0001, 5177},
    {INT64_C(1380575037655672000), 0x0003, 0x0035, 2638},
    {INT64_C(1380575037655672000), 0x0003, 0x0036, 5177},
    {INT64_C(1380575037655672000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037655672000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037655672000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037655672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037655672000), 0x0003, 0x0035, 2479},
    {INT64_C(1380575037655672000), 0x0003, 0x0036, 4008},
    {INT64_C(1380575037655672000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037655672000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037655672000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037655672000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037655672000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037675669000), 0x0003, 0x0000, 2799},
    {INT64_C(1380575037675669000), 0x0003, 0x0001, 5187},
    {INT64_C(1380575037675669000), 0x0003, 0x0035, 2799},
    {INT64_C(1380575037675669000), 0x0003, 0x0036, 5187},
    {INT64_C(1380575037675669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037675669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037675669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037675669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037675669000), 0x0003, 0x0035, 2636},
    {INT64_C(1380575037675669000), 0x0003, 0x0036, 4033},
    {INT64_C(1380575037675669000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037675669000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037675669000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037675669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037675669000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037693671000), 0x0003, 0x0000, 2987},
    {INT64_C(1380575037693671000), 0x0003, 0x0001, 5211},
    {INT64_C(1380575037693671000), 0x0003, 0x0035, 2987},
    {INT64_C(1380575037693671000), 0x0003, 0x0036, 5211},
    {INT64_C(1380575037693671000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037693671000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037693671000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037693671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037693671000), 0x0003, 0x0035, 2814},
    {INT64_C(1380575037693671000), 0x0003, 0x0036, 4069},
    {INT64_C(1380575037693671000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037693671000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037693671000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037693671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037693671000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037711668000), 0x0003, 0x0000, 3169},
    {INT64_C(1380575037711668000), 0x0003, 0x0001, 5234},
    {INT64_C(1380575037711668000), 0x0003, 0x0035, 3169},
    {INT64_C(1380575037711668000), 0x0003, 0x0036, 5234},
    {INT64_C(1380575037711668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037711668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037711668000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037711668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037711668000), 0x0003, 0x0035, 3013},
    {INT64_C(1380575037711668000), 0x0003, 0x0036, 4106},
    {INT64_C(1380575037711668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037711668000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037711668000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037711668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037711668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037731665000), 0x0003, 0x0000, 3390},
    {INT64_C(1380575037731665000), 0x0003, 0x0001, 5329},
    {INT64_C(1380575037731665000), 0x0003, 0x0035, 3390},
    {INT64_C(1380575037731665000), 0x0003, 0x0036, 5329},
    {INT64_C(1380575037731665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037731665000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037731665000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037731665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037731665000), 0x0003, 0x0035, 3207},
    {INT64_C(1380575037731665000), 0x0003, 0x0036, 4193},
    {INT64_C(1380575037731665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037731665000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037731665000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037731665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037731665000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037749669000), 0x0003, 0x0000, 3612},
    {INT64_C(1380575037749669000), 0x0003, 0x0001, 5382},
    {INT64_C(1380575037749669000), 0x0003, 0x0035, 3612},
    {INT64_C(1380575037749669000), 0x0003, 0x0036, 5382},
    {INT64_C(1380575037749669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037749669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037749669000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037749669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037749669000), 0x0003, 0x0035, 3376},
    {INT64_C(1380575037749669000), 0x0003, 0x0036, 4262},
    {INT64_C(1380575037749669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037749669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037749669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037749669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037749669000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037767673000), 0x0003, 0x0000, 3798},
    {INT64_C(1380575037767673000), 0x0003, 0x0001, 5445},
    {INT64_C(1380575037767673000), 0x0003, 0x0035, 3798},
    {INT64_C(1380575037767673000), 0x0003, 0x0036, 5445},
    {INT64_C(1380575037767673000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037767673000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037767673000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037767673000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037767673000), 0x0003, 0x0035, 3500},
    {INT64_C(1380575037767673000), 0x0003, 0x0036, 4318},
    {INT64_C(1380575037767673000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037767673000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037767673000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037767673000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037767673000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037787670000), 0x0003, 0x0000, 3939},
    {INT64_C(1380575037787670000), 0x0003, 0x0001, 5479},
    {INT64_C(1380575037787670000), 0x0003, 0x0035, 3939},
    {INT64_C(1380575037787670000), 0x0003, 0x0036, 5479},
    {INT64_C(1380575037787670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037787670000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037787670000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037787670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037787670000), 0x0003, 0x0035, 3617},
    {INT64_C(1380575037787670000), 0x0003, 0x0036, 4307},
    {INT64_C(1380575037787670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037787670000), 0x0003, 0x0030, 640},
    {INT64_C(1380575037787670000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037787670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037787670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037805668000), 0x0003, 0x0000, 4021},
    {INT64_C(1380575037805668000), 0x0003, 0x0001, 5463},
    {INT64_C(1380575037805668000), 0x0003, 0x0035, 4021},
    {INT64_C(1380575037805668000), 0x0003, 0x0036, 5463},
    {INT64_C(1380575037805668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037805668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037805668000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037805668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037805668000), 0x0003, 0x0035, 3680},
    {INT64_C(1380575037805668000), 0x0003, 0x0036, 4315},
    {INT64_C(1380575037805668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037805668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037805668000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037805668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037805668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037825670000), 0x0003, 0x0000, 4043},
    {INT64_C(1380575037825670000), 0x0003, 0x0001, 5446},
    {INT64_C(1380575037825670000), 0x0003, 0x0035, 4043},
    {INT64_C(1380575037825670000), 0x0003, 0x0036, 5446},
    {INT64_C(1380575037825670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037825670000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037825670000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037825670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037825670000), 0x0003, 0x0035, 3688},
    {INT64_C(1380575037825670000), 0x0003, 0x0036, 4266},
    {INT64_C(1380575037825670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037825670000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037825670000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037825670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037825670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037843671000), 0x0003, 0x0000, 5346},
    {INT64_C(1380575037843671000), 0x0003, 0x0001, 5920},
    {INT64_C(1380575037843671000), 0x0003, 0x0035, 5346},
    {INT64_C(1380575037843671000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575037843671000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037843671000), 0x0003, 0x0030, 256},
    {INT64_C(1380575037843671000), 0x0003, 0x0031, 160},
    {INT64_C(1380575037843671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037843671000), 0x0003, 0x0035, 4045},
    {INT64_C(1380575037843671000), 0x0003, 0x0036, 5412},
    {INT64_C(1380575037843671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037843671000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037843671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037843671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037843671000), 0x0003, 0x0035, 3680},
    {INT64_C(1380575037843671000), 0x0003, 0x0036, 4238},
    {INT64_C(1380575037843671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037843671000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037843671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037843671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037843671000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037861671000), 0x0003, 0x0000, 5331},
    {INT64_C(1380575037861671000), 0x0003, 0x0035, 5331},
    {INT64_C(1380575037861671000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575037861671000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037861671000), 0x0003, 0x0030, 256},
    {INT64_C(1380575037861671000), 0x0003, 0x0031, 160},
    {INT64_C(1380575037861671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037861671000), 0x0003, 0x0035, 4032},
    {INT64_C(1380575037861671000), 0x0003, 0x0036, 5394},
    {INT64_C(1380575037861671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037861671000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037861671000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037861671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037861671000), 0x0003, 0x0035, 3626},
    {INT64_C(1380575037861671000), 0x0003, 0x0036, 4133},
    {INT64_C(1380575037861671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037861671000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037861671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037861671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037861671000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037881670000), 0x0003, 0x0000, 5314},
    {INT64_C(1380575037881670000), 0x0003, 0x0035, 5314},
    {INT64_C(1380575037881670000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575037881670000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037881670000), 0x0003, 0x0030, 256},
    {INT64_C(1380575037881670000), 0x0003, 0x0031, 160},
    {INT64_C(1380575037881670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037881670000), 0x0003, 0x0035, 4019},
    {INT64_C(1380575037881670000), 0x0003, 0x0036, 5377},
    {INT64_C(1380575037881670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037881670000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037881670000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037881670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037881670000), 0x0003, 0x0035, 3502},
    {INT64_C(1380575037881670000), 0x0003, 0x0036, 4008},
    {INT64_C(1380575037881670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037881670000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037881670000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037881670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037881670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037899668000), 0x0003, 0x0000, 5263},
    {INT64_C(1380575037899668000), 0x0003, 0x0035, 5263},
    {INT64_C(1380575037899668000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575037899668000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037899668000), 0x0003, 0x0030, 256},
    {INT64_C(1380575037899668000), 0x0003, 0x0031, 160},
    {INT64_C(1380575037899668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037899668000), 0x0003, 0x0035, 3897},
    {INT64_C(1380575037899668000), 0x0003, 0x0036, 5275},
    {INT64_C(1380575037899668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037899668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037899668000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037899668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037899668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037917670000), 0x0003, 0x0000, 5032},
    {INT64_C(1380575037917670000), 0x0003, 0x0001, 5760},
    {INT64_C(1380575037917670000), 0x0003, 0x0035, 5032},
    {INT64_C(1380575037917670000), 0x0003, 0x0036, 5760},
    {INT64_C(1380575037917670000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037917670000), 0x0003, 0x0030, 256},
    {INT64_C(1380575037917670000), 0x0003, 0x0031, 160},
    {INT64_C(1380575037917670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037917670000), 0x0003, 0x0035, 3698},
    {INT64_C(1380575037917670000), 0x0003, 0x0036, 5078},
    {INT64_C(1380575037917670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037917670000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037917670000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037917670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037917670000), 0x0003, 0x0035, 3328},
    {INT64_C(1380575037917670000), 0x0003, 0x0036, 3699},
    {INT64_C(1380575037917670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037917670000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037917670000), 0x0003, 0x0031, 128},
    {INT64_C(1380575037917670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037917670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037937671000), 0x0003, 0x0000, 4875},
    {INT64_C(1380575037937671000), 0x0003, 0x0001, 5551},
    {INT64_C(1380575037937671000), 0x0003, 0x0035, 4875},
    {INT64_C(1380575037937671000), 0x0003, 0x0036, 5551},
    {INT64_C(1380575037937671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037937671000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037937671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037937671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037937671000), 0x0003, 0x0035, 3504},
    {INT64_C(1380575037937671000), 0x0003, 0x0036, 4892},
    {INT64_C(1380575037937671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037937671000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037937671000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037937671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037937671000), 0x0003, 0x0035, 3157},
    {INT64_C(1380575037937671000), 0x0003, 0x0036, 3520},
    {INT64_C(1380575037937671000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037937671000), 0x0003, 0x0030, 256},
    {INT64_C(1380575037937671000), 0x0003, 0x0031, 160},
    {INT64_C(1380575037937671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037937671000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037955668000), 0x0003, 0x0000, 4686},
    {INT64_C(1380575037955668000), 0x0003, 0x0001, 5448},
    {INT64_C(1380575037955668000), 0x0003, 0x0035, 4686},
    {INT64_C(1380575037955668000), 0x0003, 0x0036, 5448},
    {INT64_C(1380575037955668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037955668000), 0x0003, 0x0030, 320},
    {INT64_C(1380575037955668000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037955668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037955668000), 0x0003, 0x0035, 3338},
    {INT64_C(1380575037955668000), 0x0003, 0x0036, 4684},
    {INT64_C(1380575037955668000), 0x0003, 0x0034, 1},
    {INT64_C(1380575037955668000), 0x0003, 0x0030, 384},
    {INT64_C(1380575037955668000), 0x0003, 0x0031, 320},
    {INT64_C(1380575037955668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037955668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037973669000), 0x0003, 0x0000, 4522},
    {INT64_C(1380575037973669000), 0x0003, 0x0001, 5238},
    {INT64_C(1380575037973669000), 0x0003, 0x0035, 4522},
    {INT64_C(1380575037973669000), 0x0003, 0x0036, 5238},
    {INT64_C(1380575037973669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037973669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037973669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037973669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037973669000), 0x0003, 0x0035, 3227},
    {INT64_C(1380575037973669000), 0x0003, 0x0036, 4462},
    {INT64_C(1380575037973669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037973669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037973669000), 0x0003, 0x0031, 384},
    {INT64_C(1380575037973669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037973669000), 0x0000, 0x0000, 0},
    {INT64_C(1380575037993669000), 0x0003, 0x0000, 4436},
    {INT64_C(1380575037993669000), 0x0003, 0x0001, 5133},
    {INT64_C(1380575037993669000), 0x0003, 0x0035, 4436},
    {INT64_C(1380575037993669000), 0x0003, 0x0036, 5133},
    {INT64_C(1380575037993669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037993669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037993669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037993669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037993669000), 0x0003, 0x0035, 3129},
    {INT64_C(1380575037993669000), 0x0003, 0x0036, 4274},
    {INT64_C(1380575037993669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575037993669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575037993669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575037993669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575037993669000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038011670000), 0x0003, 0x0000, 4387},
    {INT64_C(1380575038011670000), 0x0003, 0x0001, 4960},
    {INT64_C(1380575038011670000), 0x0003, 0x0035, 4387},
    {INT64_C(1380575038011670000), 0x0003, 0x0036, 4960},
    {INT64_C(1380575038011670000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038011670000), 0x0003, 0x0030, 256},
    {INT64_C(1380575038011670000), 0x0003, 0x0031, 160},
    {INT64_C(1380575038011670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038011670000), 0x0003, 0x0035, 3111},
    {INT64_C(1380575038011670000), 0x0003, 0x0036, 4208},
    {INT64_C(1380575038011670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038011670000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038011670000), 0x0003, 0x0031, 384},
    {INT64_C(1380575038011670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038011670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038029668000), 0x0003, 0x0000, 4396},
    {INT64_C(1380575038029668000), 0x0003, 0x0001, 4912},
    {INT64_C(1380575038029668000), 0x0003, 0x0035, 4396},
    {INT64_C(1380575038029668000), 0x0003, 0x0036, 4912},
    {INT64_C(1380575038029668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038029668000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038029668000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038029668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038029668000), 0x0003, 0x0035, 3124},
    {INT64_C(1380575038029668000), 0x0003, 0x0036, 4147},
    {INT64_C(1380575038029668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038029668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038029668000), 0x0003, 0x0031, 384},
    {INT64_C(1380575038029668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038029668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038049668000), 0x0003, 0x0000, 4418},
    {INT64_C(1380575038049668000), 0x0003, 0x0001, 4782},
    {INT64_C(1380575038049668000), 0x0003, 0x0035, 4418},
    {INT64_C(1380575038049668000), 0x0003, 0x0036, 4782},
    {INT64_C(1380575038049668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038049668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038049668000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038049668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038049668000), 0x0003, 0x0035, 3201},
    {INT64_C(1380575038049668000), 0x0003, 0x0036, 4123},
    {INT64_C(1380575038049668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038049668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038049668000), 0x0003, 0x0031, 384},
    {INT64_C(1380575038049668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038049668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038067667000), 0x0003, 0x0000, 4531},
    {INT64_C(1380575038067667000), 0x0003, 0x0001, 4640},
    {INT64_C(1380575038067667000), 0x0003, 0x0035, 4531},
    {INT64_C(1380575038067667000), 0x0003, 0x0036, 4640},
    {INT64_C(1380575038067667000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038067667000), 0x0003, 0x0030, 256},
    {INT64_C(1380575038067667000), 0x0003, 0x0031, 160},
    {INT64_C(1380575038067667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038067667000), 0x0003, 0x0035, 3319},
    {INT64_C(1380575038067667000), 0x0003, 0x0036, 4130},
    {INT64_C(1380575038067667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038067667000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038067667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038067667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038067667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038085668000), 0x0003, 0x0000, 4608},
    {INT64_C(1380575038085668000), 0x0003, 0x0001, 4578},
    {INT64_C(1380575038085668000), 0x0003, 0x0035, 4608},
    {INT64_C(1380575038085668000), 0x0003, 0x0036, 4578},
    {INT64_C(1380575038085668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038085668000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038085668000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038085668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038085668000), 0x0003, 0x0035, 3456},
    {INT64_C(1380575038085668000), 0x0003, 0x0036, 4205},
    {INT64_C(1380575038085668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038085668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038085668000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038085668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038085668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038105667000), 0x0003, 0x0000, 3746},
    {INT64_C(1380575038105667000), 0x0003, 0x0001, 4288},
    {INT64_C(1380575038105667000), 0x0003, 0x0035, 3746},
    {INT64_C(1380575038105667000), 0x0003, 0x0036, 4288},
    {INT64_C(1380575038105667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038105667000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038105667000), 0x0003, 0x0031, 384},
    {INT64_C(1380575038105667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038105667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038123667000), 0x0003, 0x0000, 4014},
    {INT64_C(1380575038123667000), 0x0003, 0x0001, 4433},
    {INT64_C(1380575038123667000), 0x0003, 0x0035, 4014},
    {INT64_C(1380575038123667000), 0x0003, 0x0036, 4433},
    {INT64_C(1380575038123667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038123667000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038123667000), 0x0003, 0x0031, 384},
    {INT64_C(1380575038123667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038123667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038143666000), 0x0003, 0x0000, 4207},
    {INT64_C(1380575038143666000), 0x0003, 0x0001, 4612},
    {INT64_C(1380575038143666000), 0x0003, 0x0035, 4207},
    {INT64_C(1380575038143666000), 0x0003, 0x0036, 4612},
    {INT64_C(1380575038143666000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038143666000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038143666000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038143666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038143666000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038161599000), 0x0003, 0x0000, 4448},
    {INT64_C(1380575038161599000), 0x0003, 0x0001, 4790},
    {INT64_C(1380575038161599000), 0x0003, 0x0035, 4448},
    {INT64_C(1380575038161599000), 0x0003, 0x0036, 4790},
    {INT64_C(1380575038161599000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038161599000), 0x0003, 0x0030, 640},
    {INT64_C(1380575038161599000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038161599000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038161599000), 0x0003, 0x0035, 4172},
    {INT64_C(1380575038161599000), 0x0003, 0x0036, 3520},
    {INT64_C(1380575038161599000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038161599000), 0x0003, 0x0030, 256},
    {INT64_C(1380575038161599000), 0x0003, 0x0031, 160},
    {INT64_C(1380575038161599000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038161599000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038179665000), 0x0003, 0x0000, 4681},
    {INT64_C(1380575038179665000), 0x0003, 0x0001, 5011},
    {INT64_C(1380575038179665000), 0x0003, 0x0035, 4681},
    {INT64_C(1380575038179665000), 0x0003, 0x0036, 5011},
    {INT64_C(1380575038179665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038179665000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038179665000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038179665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038179665000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038199670000), 0x0003, 0x0000, 4842},
    {INT64_C(1380575038199670000), 0x0003, 0x0001, 5221},
    {INT64_C(1380575038199670000), 0x0003, 0x0035, 4842},
    {INT64_C(1380575038199670000), 0x0003, 0x0036, 5221},
    {INT64_C(1380575038199670000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038199670000), 0x0003, 0x0030, 384},
    {INT64_C(1380575038199670000), 0x0003, 0x0031, 320},
    {INT64_C(1380575038199670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038199670000), 0x0003, 0x0035, 5888},
    {INT64_C(1380575038199670000), 0x0003, 0x0036, 5138},
    {INT64_C(1380575038199670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038199670000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038199670000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038199670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038199670000), 0x0003, 0x0035, 4420},
    {INT64_C(1380575038199670000), 0x0003, 0x0036, 4095},
    {INT64_C(1380575038199670000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038199670000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038199670000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038199670000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038199670000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038217671000), 0x0003, 0x0000, 4942},
    {INT64_C(1380575038217671000), 0x0003, 0x0001, 5391},
    {INT64_C(1380575038217671000), 0x0003, 0x0035, 4942},
    {INT64_C(1380575038217671000), 0x0003, 0x0036, 5391},
    {INT64_C(1380575038217671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038217671000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038217671000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038217671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038217671000), 0x0003, 0x0035, 6016},
    {INT64_C(1380575038217671000), 0x0003, 0x0036, 5294},
    {INT64_C(1380575038217671000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038217671000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038217671000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038217671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038217671000), 0x0003, 0x0035, 4488},
    {INT64_C(1380575038217671000), 0x0003, 0x0036, 4265},
    {INT64_C(1380575038217671000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038217671000), 0x0003, 0x0030, 384},
    {INT64_C(1380575038217671000), 0x0003, 0x0031, 320},
    {INT64_C(1380575038217671000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038217671000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038235668000), 0x0003, 0x0000, 5007},
    {INT64_C(1380575038235668000), 0x0003, 0x0001, 5547},
    {INT64_C(1380575038235668000), 0x0003, 0x0035, 5007},
    {INT64_C(1380575038235668000), 0x0003, 0x0036, 5547},
    {INT64_C(1380575038235668000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038235668000), 0x0003, 0x0030, 384},
    {INT64_C(1380575038235668000), 0x0003, 0x0031, 320},
    {INT64_C(1380575038235668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038235668000), 0x0003, 0x0035, 6016},
    {INT64_C(1380575038235668000), 0x0003, 0x0036, 5376},
    {INT64_C(1380575038235668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038235668000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038235668000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038235668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038235668000), 0x0003, 0x0035, 4489},
    {INT64_C(1380575038235668000), 0x0003, 0x0036, 4396},
    {INT64_C(1380575038235668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038235668000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038235668000), 0x0003, 0x0031, 384},
    {INT64_C(1380575038235668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038235668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038255667000), 0x0003, 0x0000, 4968},
    {INT64_C(1380575038255667000), 0x0003, 0x0001, 5594},
    {INT64_C(1380575038255667000), 0x0003, 0x0035, 4968},
    {INT64_C(1380575038255667000), 0x0003, 0x0036, 5594},
    {INT64_C(1380575038255667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038255667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038255667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038255667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038255667000), 0x0003, 0x0035, 6016},
    {INT64_C(1380575038255667000), 0x0003, 0x0036, 5466},
    {INT64_C(1380575038255667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038255667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038255667000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038255667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038255667000), 0x0003, 0x0035, 4439},
    {INT64_C(1380575038255667000), 0x0003, 0x0036, 4445},
    {INT64_C(1380575038255667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038255667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038255667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038255667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038255667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038273669000), 0x0003, 0x0000, 4910},
    {INT64_C(1380575038273669000), 0x0003, 0x0001, 5693},
    {INT64_C(1380575038273669000), 0x0003, 0x0035, 4910},
    {INT64_C(1380575038273669000), 0x0003, 0x0036, 5693},
    {INT64_C(1380575038273669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038273669000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038273669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038273669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038273669000), 0x0003, 0x0035, 6016},
    {INT64_C(1380575038273669000), 0x0003, 0x0036, 5553},
    {INT64_C(1380575038273669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038273669000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038273669000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038273669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038273669000), 0x0003, 0x0035, 4355},
    {INT64_C(1380575038273669000), 0x0003, 0x0036, 4539},
    {INT64_C(1380575038273669000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038273669000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038273669000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038273669000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038273669000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038291667000), 0x0003, 0x0000, 4776},
    {INT64_C(1380575038291667000), 0x0003, 0x0001, 5733},
    {INT64_C(1380575038291667000), 0x0003, 0x0035, 4776},
    {INT64_C(1380575038291667000), 0x0003, 0x0036, 5733},
    {INT64_C(1380575038291667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038291667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038291667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038291667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038291667000), 0x0003, 0x0035, 6016},
    {INT64_C(1380575038291667000), 0x0003, 0x0036, 5632},
    {INT64_C(1380575038291667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038291667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038291667000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038291667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038291667000), 0x0003, 0x0035, 4196},
    {INT64_C(1380575038291667000), 0x0003, 0x0036, 4570},
    {INT64_C(1380575038291667000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038291667000), 0x0003, 0x0030, 384},
    {INT64_C(1380575038291667000), 0x0003, 0x0031, 320},
    {INT64_C(1380575038291667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038291667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038311667000), 0x0003, 0x0000, 4528},
    {INT64_C(1380575038311667000), 0x0003, 0x0001, 5737},
    {INT64_C(1380575038311667000), 0x0003, 0x0035, 4528},
    {INT64_C(1380575038311667000), 0x0003, 0x0036, 5737},
    {INT64_C(1380575038311667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038311667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038311667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038311667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038311667000), 0x0003, 0x0035, 5825},
    {INT64_C(1380575038311667000), 0x0003, 0x0036, 5720},
    {INT64_C(1380575038311667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038311667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038311667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038311667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038311667000), 0x0003, 0x0035, 4013},
    {INT64_C(1380575038311667000), 0x0003, 0x0036, 4614},
    {INT64_C(1380575038311667000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038311667000), 0x0003, 0x0030, 384},
    {INT64_C(1380575038311667000), 0x0003, 0x0031, 320},
    {INT64_C(1380575038311667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038311667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038329664000), 0x0003, 0x0000, 4279},
    {INT64_C(1380575038329664000), 0x0003, 0x0001, 5821},
    {INT64_C(1380575038329664000), 0x0003, 0x0035, 4279},
    {INT64_C(1380575038329664000), 0x0003, 0x0036, 5821},
    {INT64_C(1380575038329664000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038329664000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038329664000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038329664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038329664000), 0x0003, 0x0035, 5632},
    {INT64_C(1380575038329664000), 0x0003, 0x0036, 5804},
    {INT64_C(1380575038329664000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038329664000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038329664000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038329664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038329664000), 0x0003, 0x0035, 3725},
    {INT64_C(1380575038329664000), 0x0003, 0x0036, 4640},
    {INT64_C(1380575038329664000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038329664000), 0x0003, 0x0030, 256},
    {INT64_C(1380575038329664000), 0x0003, 0x0031, 160},
    {INT64_C(1380575038329664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038329664000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038349667000), 0x0003, 0x0000, 4005},
    {INT64_C(1380575038349667000), 0x0003, 0x0001, 5844},
    {INT64_C(1380575038349667000), 0x0003, 0x0035, 4005},
    {INT64_C(1380575038349667000), 0x0003, 0x0036, 5844},
    {INT64_C(1380575038349667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038349667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038349667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038349667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038349667000), 0x0003, 0x0035, 5376},
    {INT64_C(1380575038349667000), 0x0003, 0x0036, 5888},
    {INT64_C(1380575038349667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038349667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038349667000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038349667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038349667000), 0x0003, 0x0035, 3456},
    {INT64_C(1380575038349667000), 0x0003, 0x0036, 4658},
    {INT64_C(1380575038349667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038349667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038349667000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038349667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038349667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038367661000), 0x0003, 0x0000, 3748},
    {INT64_C(1380575038367661000), 0x0003, 0x0001, 5845},
    {INT64_C(1380575038367661000), 0x0003, 0x0035, 3748},
    {INT64_C(1380575038367661000), 0x0003, 0x0036, 5845},
    {INT64_C(1380575038367661000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038367661000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038367661000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038367661000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038367661000), 0x0003, 0x0035, 5036},
    {INT64_C(1380575038367661000), 0x0003, 0x0036, 5888},
    {INT64_C(1380575038367661000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038367661000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038367661000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038367661000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038367661000), 0x0003, 0x0035, 3204},
    {INT64_C(1380575038367661000), 0x0003, 0x0036, 4640},
    {INT64_C(1380575038367661000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038367661000), 0x0003, 0x0030, 256},
    {INT64_C(1380575038367661000), 0x0003, 0x0031, 160},
    {INT64_C(1380575038367661000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038367661000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038385667000), 0x0003, 0x0000, 3470},
    {INT64_C(1380575038385667000), 0x0003, 0x0001, 5830},
    {INT64_C(1380575038385667000), 0x0003, 0x0035, 3470},
    {INT64_C(1380575038385667000), 0x0003, 0x0036, 5830},
    {INT64_C(1380575038385667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038385667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038385667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038385667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038385667000), 0x0003, 0x0035, 4785},
    {INT64_C(1380575038385667000), 0x0003, 0x0036, 5911},
    {INT64_C(1380575038385667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038385667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038385667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038385667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038385667000), 0x0003, 0x0035, 2944},
    {INT64_C(1380575038385667000), 0x0003, 0x0036, 4537},
    {INT64_C(1380575038385667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038385667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038385667000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038385667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038385667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038405668000), 0x0003, 0x0000, 4481},
    {INT64_C(1380575038405668000), 0x0003, 0x0001, 5915},
    {INT64_C(1380575038405668000), 0x0003, 0x0035, 4481},
    {INT64_C(1380575038405668000), 0x0003, 0x0036, 5915},
    {INT64_C(1380575038405668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038405668000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038405668000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038405668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038405668000), 0x0003, 0x0035, 3193},
    {INT64_C(1380575038405668000), 0x0003, 0x0036, 5705},
    {INT64_C(1380575038405668000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038405668000), 0x0003, 0x0030, 384},
    {INT64_C(1380575038405668000), 0x0003, 0x0031, 320},
    {INT64_C(1380575038405668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038405668000), 0x0003, 0x0035, 2688},
    {INT64_C(1380575038405668000), 0x0003, 0x0036, 4479},
    {INT64_C(1380575038405668000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038405668000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038405668000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038405668000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038405668000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038423665000), 0x0003, 0x0000, 2944},
    {INT64_C(1380575038423665000), 0x0003, 0x0001, 5538},
    {INT64_C(1380575038423665000), 0x0003, 0x0035, 2944},
    {INT64_C(1380575038423665000), 0x0003, 0x0036, 5538},
    {INT64_C(1380575038423665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038423665000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038423665000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038423665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038423665000), 0x0003, 0x0035, 2434},
    {INT64_C(1380575038423665000), 0x0003, 0x0036, 4247},
    {INT64_C(1380575038423665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038423665000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038423665000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038423665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038423665000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038441664000), 0x0003, 0x0000, 2738},
    {INT64_C(1380575038441664000), 0x0003, 0x0001, 5357},
    {INT64_C(1380575038441664000), 0x0003, 0x0035, 2738},
    {INT64_C(1380575038441664000), 0x0003, 0x0036, 5357},
    {INT64_C(1380575038441664000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038441664000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038441664000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038441664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038441664000), 0x0003, 0x0035, 2304},
    {INT64_C(1380575038441664000), 0x0003, 0x0036, 4084},
    {INT64_C(1380575038441664000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038441664000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038441664000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038441664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038441664000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038461666000), 0x0003, 0x0000, 3839},
    {INT64_C(1380575038461666000), 0x0003, 0x0001, 5540},
    {INT64_C(1380575038461666000), 0x0003, 0x0035, 3839},
    {INT64_C(1380575038461666000), 0x0003, 0x0036, 5540},
    {INT64_C(1380575038461666000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038461666000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038461666000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038461666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038461666000), 0x0003, 0x0035, 2602},
    {INT64_C(1380575038461666000), 0x0003, 0x0036, 5182},
    {INT64_C(1380575038461666000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038461666000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038461666000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038461666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038461666000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038479661000), 0x0003, 0x0000, 3720},
    {INT64_C(1380575038479661000), 0x0003, 0x0001, 5344},
    {INT64_C(1380575038479661000), 0x0003, 0x0035, 3720},
    {INT64_C(1380575038479661000), 0x0003, 0x0036, 5344},
    {INT64_C(1380575038479661000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038479661000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038479661000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038479661000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038479661000), 0x0003, 0x0035, 2523},
    {INT64_C(1380575038479661000), 0x0003, 0x0036, 4960},
    {INT64_C(1380575038479661000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038479661000), 0x0003, 0x0030, 256},
    {INT64_C(1380575038479661000), 0x0003, 0x0031, 160},
    {INT64_C(1380575038479661000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038479661000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038497666000), 0x0003, 0x0000, 3673},
    {INT64_C(1380575038497666000), 0x0003, 0x0001, 5120},
    {INT64_C(1380575038497666000), 0x0003, 0x0035, 3673},
    {INT64_C(1380575038497666000), 0x0003, 0x0036, 5120},
    {INT64_C(1380575038497666000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038497666000), 0x0003, 0x0030, 256},
    {INT64_C(1380575038497666000), 0x0003, 0x0031, 160},
    {INT64_C(1380575038497666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038497666000), 0x0003, 0x0035, 2486},
    {INT64_C(1380575038497666000), 0x0003, 0x0036, 4640},
    {INT64_C(1380575038497666000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038497666000), 0x0003, 0x0030, 256},
    {INT64_C(1380575038497666000), 0x0003, 0x0031, 160},
    {INT64_C(1380575038497666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038497666000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038517666000), 0x0003, 0x0000, 3674},
    {INT64_C(1380575038517666000), 0x0003, 0x0001, 4754},
    {INT64_C(1380575038517666000), 0x0003, 0x0035, 3674},
    {INT64_C(1380575038517666000), 0x0003, 0x0036, 4754},
    {INT64_C(1380575038517666000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038517666000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038517666000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038517666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038517666000), 0x0003, 0x0035, 2526},
    {INT64_C(1380575038517666000), 0x0003, 0x0036, 4210},
    {INT64_C(1380575038517666000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038517666000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038517666000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038517666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038517666000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038535665000), 0x0003, 0x0000, 3745},
    {INT64_C(1380575038535665000), 0x0003, 0x0001, 4468},
    {INT64_C(1380575038535665000), 0x0003, 0x0035, 3745},
    {INT64_C(1380575038535665000), 0x0003, 0x0036, 4468},
    {INT64_C(1380575038535665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038535665000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038535665000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038535665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038535665000), 0x0003, 0x0035, 2628},
    {INT64_C(1380575038535665000), 0x0003, 0x0036, 4030},
    {INT64_C(1380575038535665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038535665000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038535665000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038535665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038535665000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038553665000), 0x0003, 0x0000, 3843},
    {INT64_C(1380575038553665000), 0x0003, 0x0001, 4262},
    {INT64_C(1380575038553665000), 0x0003, 0x0035, 3843},
    {INT64_C(1380575038553665000), 0x0003, 0x0036, 4262},
    {INT64_C(1380575038553665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038553665000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038553665000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038553665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038553665000), 0x0003, 0x0035, 2770},
    {INT64_C(1380575038553665000), 0x0003, 0x0036, 3875},
    {INT64_C(1380575038553665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038553665000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038553665000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038553665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038553665000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038573662000), 0x0003, 0x0000, 3970},
    {INT64_C(1380575038573662000), 0x0003, 0x0001, 4094},
    {INT64_C(1380575038573662000), 0x0003, 0x0035, 3970},
    {INT64_C(1380575038573662000), 0x0003, 0x0036, 4094},
    {INT64_C(1380575038573662000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038573662000), 0x0003, 0x0030, 384},
    {INT64_C(1380575038573662000), 0x0003, 0x0031, 320},
    {INT64_C(1380575038573662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038573662000), 0x0003, 0x0035, 2922},
    {INT64_C(1380575038573662000), 0x0003, 0x0036, 3724},
    {INT64_C(1380575038573662000), 0x0003, 0x0034, 1},
    {INT64_C(1380575038573662000), 0x0003, 0x0030, 384},
    {INT64_C(1380575038573662000), 0x0003, 0x0031, 320},
    {INT64_C(1380575038573662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038573662000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038591666000), 0x0003, 0x0000, 4091},
    {INT64_C(1380575038591666000), 0x0003, 0x0001, 3970},
    {INT64_C(1380575038591666000), 0x0003, 0x0035, 4091},
    {INT64_C(1380575038591666000), 0x0003, 0x0036, 3970},
    {INT64_C(1380575038591666000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038591666000), 0x0003, 0x0030, 640},
    {INT64_C(1380575038591666000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038591666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038591666000), 0x0003, 0x0035, 3072},
    {INT64_C(1380575038591666000), 0x0003, 0x0036, 3602},
    {INT64_C(1380575038591666000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038591666000), 0x0003, 0x0030, 480},
    {INT64_C(1380575038591666000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038591666000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038591666000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038609665000), 0x0003, 0x0000, 4224},
    {INT64_C(1380575038609665000), 0x0003, 0x0001, 3852},
    {INT64_C(1380575038609665000), 0x0003, 0x0035, 4224},
    {INT64_C(1380575038609665000), 0x0003, 0x0036, 3852},
    {INT64_C(1380575038609665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038609665000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038609665000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038609665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038609665000), 0x0003, 0x0035, 3328},
    {INT64_C(1380575038609665000), 0x0003, 0x0036, 3579},
    {INT64_C(1380575038609665000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038609665000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038609665000), 0x0003, 0x0031, 128},
    {INT64_C(1380575038609665000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038609665000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038629663000), 0x0003, 0x0000, 4576},
    {INT64_C(1380575038629663000), 0x0003, 0x0001, 3842},
    {INT64_C(1380575038629663000), 0x0003, 0x0035, 4576},
    {INT64_C(1380575038629663000), 0x0003, 0x0036, 3842},
    {INT64_C(1380575038629663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575038629663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575038629663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575038629663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575038629663000), 0x0000, 0x0000, 0},
    {INT64_C(1380575038723663000), 0x0001, 0x014d, 0},
    {INT64_C(1380575038723663000), 0x0001, 0x014a, 0},
    {INT64_C(1380575038723663000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039065660000), 0x0003, 0x0000, 6227},
    {INT64_C(1380575039065660000), 0x0003, 0x0001, 5508},
    {INT64_C(1380575039065660000), 0x0003, 0x0035, 6227},
    {INT64_C(1380575039065660000), 0x0003, 0x0036, 5508},
    {INT64_C(1380575039065660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039065660000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039065660000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039065660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039065660000), 0x0001, 0x014d, 1},
    {INT64_C(1380575039065660000), 0x0001, 0x014a, 1},
    {INT64_C(1380575039065660000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039079667000), 0x0003, 0x0000, 5410},
    {INT64_C(1380575039079667000), 0x0003, 0x0001, 6080},
    {INT64_C(1380575039079667000), 0x0003, 0x0035, 5410},
    {INT64_C(1380575039079667000), 0x0003, 0x0036, 6080},
    {INT64_C(1380575039079667000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039079667000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039079667000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039079667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039079667000), 0x0003, 0x0035, 6226},
    {INT64_C(1380575039079667000), 0x0003, 0x0036, 5427},
    {INT64_C(1380575039079667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039079667000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039079667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039079667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039079667000), 0x0003, 0x0035, 3742},
    {INT64_C(1380575039079667000), 0x0003, 0x0036, 4576},
    {INT64_C(1380575039079667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039079667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039079667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039079667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039079667000), 0x0003, 0x0035, 4358},
    {INT64_C(1380575039079667000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039079667000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039079667000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039079667000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039079667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039079667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039085662000), 0x0003, 0x0000, 5421},
    {INT64_C(1380575039085662000), 0x0003, 0x0035, 5421},
    {INT64_C(1380575039085662000), 0x0003, 0x0036, 6080},
    {INT64_C(1380575039085662000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039085662000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039085662000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039085662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039085662000), 0x0003, 0x0035, 4394},
    {INT64_C(1380575039085662000), 0x0003, 0x0036, 5760},
    {INT64_C(1380575039085662000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039085662000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039085662000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039085662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039085662000), 0x0003, 0x0035, 6232},
    {INT64_C(1380575039085662000), 0x0003, 0x0036, 5346},
    {INT64_C(1380575039085662000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039085662000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039085662000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039085662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039085662000), 0x0003, 0x0035, 3762},
    {INT64_C(1380575039085662000), 0x0003, 0x0036, 4514},
    {INT64_C(1380575039085662000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039085662000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039085662000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039085662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039085662000), 0x0003, 0x0035, 4357},
    {INT64_C(1380575039085662000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039085662000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039085662000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039085662000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039085662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039085662000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039097667000), 0x0003, 0x0000, 5418},
    {INT64_C(1380575039097667000), 0x0003, 0x0035, 5418},
    {INT64_C(1380575039097667000), 0x0003, 0x0036, 6080},
    {INT64_C(1380575039097667000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039097667000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039097667000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039097667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039097667000), 0x0003, 0x0035, 4405},
    {INT64_C(1380575039097667000), 0x0003, 0x0036, 5760},
    {INT64_C(1380575039097667000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039097667000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039097667000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039097667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039097667000), 0x0003, 0x0035, 6242},
    {INT64_C(1380575039097667000), 0x0003, 0x0036, 5175},
    {INT64_C(1380575039097667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039097667000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039097667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039097667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039097667000), 0x0003, 0x0035, 3775},
    {INT64_C(1380575039097667000), 0x0003, 0x0036, 4477},
    {INT64_C(1380575039097667000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039097667000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039097667000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039097667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039097667000), 0x0003, 0x0035, 4366},
    {INT64_C(1380575039097667000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039097667000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039097667000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039097667000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039097667000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039097667000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039103663000), 0x0003, 0x0000, 5409},
    {INT64_C(1380575039103663000), 0x0003, 0x0035, 5409},
    {INT64_C(1380575039103663000), 0x0003, 0x0036, 6080},
    {INT64_C(1380575039103663000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039103663000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039103663000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039103663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039103663000), 0x0003, 0x0035, 4402},
    {INT64_C(1380575039103663000), 0x0003, 0x0036, 5677},
    {INT64_C(1380575039103663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039103663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039103663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039103663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039103663000), 0x0003, 0x0035, 6286},
    {INT64_C(1380575039103663000), 0x0003, 0x0036, 4997},
    {INT64_C(1380575039103663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039103663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039103663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039103663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039103663000), 0x0003, 0x0035, 3797},
    {INT64_C(1380575039103663000), 0x0003, 0x0036, 4438},
    {INT64_C(1380575039103663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039103663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039103663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039103663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039103663000), 0x0003, 0x0035, 4360},
    {INT64_C(1380575039103663000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039103663000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039103663000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039103663000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039103663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039103663000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039115660000), 0x0003, 0x0000, 5411},
    {INT64_C(1380575039115660000), 0x0003, 0x0001, 5920},
    {INT64_C(1380575039115660000), 0x0003, 0x0035, 5411},
    {INT64_C(1380575039115660000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575039115660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039115660000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039115660000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039115660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039115660000), 0x0003, 0x0035, 4408},
    {INT64_C(1380575039115660000), 0x0003, 0x0036, 5600},
    {INT64_C(1380575039115660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039115660000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039115660000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039115660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039115660000), 0x0003, 0x0035, 6276},
    {INT64_C(1380575039115660000), 0x0003, 0x0036, 4591},
    {INT64_C(1380575039115660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039115660000), 0x0003, 0x0030, 800},
    {INT64_C(1380575039115660000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039115660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039115660000), 0x0003, 0x0035, 3798},
    {INT64_C(1380575039115660000), 0x0003, 0x0036, 4399},
    {INT64_C(1380575039115660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039115660000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039115660000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039115660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039115660000), 0x0003, 0x0035, 4390},
    {INT64_C(1380575039115660000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039115660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039115660000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039115660000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039115660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039115660000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039121663000), 0x0003, 0x0000, 4415},
    {INT64_C(1380575039121663000), 0x0003, 0x0001, 5554},
    {INT64_C(1380575039121663000), 0x0003, 0x0035, 4415},
    {INT64_C(1380575039121663000), 0x0003, 0x0036, 5554},
    {INT64_C(1380575039121663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039121663000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039121663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039121663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039121663000), 0x0003, 0x0035, 5402},
    {INT64_C(1380575039121663000), 0x0003, 0x0036, 5720},
    {INT64_C(1380575039121663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039121663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039121663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039121663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039121663000), 0x0003, 0x0035, 3819},
    {INT64_C(1380575039121663000), 0x0003, 0x0036, 4347},
    {INT64_C(1380575039121663000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039121663000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039121663000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039121663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039121663000), 0x0003, 0x0035, 6236},
    {INT64_C(1380575039121663000), 0x0003, 0x0036, 4299},
    {INT64_C(1380575039121663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039121663000), 0x0003, 0x0030, 640},
    {INT64_C(1380575039121663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039121663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039121663000), 0x0003, 0x0035, 4391},
    {INT64_C(1380575039121663000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039121663000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039121663000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039121663000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039121663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039121663000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0000, 4412},
    {INT64_C(1380575039135664000), 0x0003, 0x0001, 5434},
    {INT64_C(1380575039135664000), 0x0003, 0x0035, 4412},
    {INT64_C(1380575039135664000), 0x0003, 0x0036, 5434},
    {INT64_C(1380575039135664000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039135664000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039135664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0035, 5399},
    {INT64_C(1380575039135664000), 0x0003, 0x0036, 5551},
    {INT64_C(1380575039135664000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039135664000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039135664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0035, 3865},
    {INT64_C(1380575039135664000), 0x0003, 0x0036, 4181},
    {INT64_C(1380575039135664000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039135664000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039135664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0035, 6165},
    {INT64_C(1380575039135664000), 0x0003, 0x0036, 4077},
    {INT64_C(1380575039135664000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039135664000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039135664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039135664000), 0x0003, 0x0035, 4426},
    {INT64_C(1380575039135664000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039135664000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039135664000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039135664000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039135664000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039135664000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039141663000), 0x0003, 0x0000, 4418},
    {INT64_C(1380575039141663000), 0x0003, 0x0001, 5304},
    {INT64_C(1380575039141663000), 0x0003, 0x0035, 4418},
    {INT64_C(1380575039141663000), 0x0003, 0x0036, 5304},
    {INT64_C(1380575039141663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039141663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039141663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039141663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039141663000), 0x0003, 0x0035, 5391},
    {INT64_C(1380575039141663000), 0x0003, 0x0036, 5357},
    {INT64_C(1380575039141663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039141663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039141663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039141663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039141663000), 0x0003, 0x0035, 3911},
    {INT64_C(1380575039141663000), 0x0003, 0x0036, 4001},
    {INT64_C(1380575039141663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039141663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039141663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039141663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039141663000), 0x0003, 0x0035, 4493},
    {INT64_C(1380575039141663000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039141663000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039141663000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039141663000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039141663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039141663000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039153663000), 0x0003, 0x0000, 4379},
    {INT64_C(1380575039153663000), 0x0003, 0x0001, 5029},
    {INT64_C(1380575039153663000), 0x0003, 0x0035, 4379},
    {INT64_C(1380575039153663000), 0x0003, 0x0036, 5029},
    {INT64_C(1380575039153663000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039153663000), 0x0003, 0x0030, 512},
    {INT64_C(1380575039153663000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039153663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039153663000), 0x0003, 0x0035, 5331},
    {INT64_C(1380575039153663000), 0x0003, 0x0036, 5051},
    {INT64_C(1380575039153663000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039153663000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039153663000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039153663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039153663000), 0x0003, 0x0035, 3920},
    {INT64_C(1380575039153663000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575039153663000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039153663000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039153663000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039153663000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039153663000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039171660000), 0x0003, 0x0000, 4349},
    {INT64_C(1380575039171660000), 0x0003, 0x0001, 4801},
    {INT64_C(1380575039171660000), 0x0003, 0x0035, 4349},
    {INT64_C(1380575039171660000), 0x0003, 0x0036, 4801},
    {INT64_C(1380575039171660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039171660000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039171660000), 0x0003, 0x0031, 384},
    {INT64_C(1380575039171660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039171660000), 0x0003, 0x0035, 5326},
    {INT64_C(1380575039171660000), 0x0003, 0x0036, 4811},
    {INT64_C(1380575039171660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039171660000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039171660000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039171660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039171660000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039191661000), 0x0003, 0x0000, 5279},
    {INT64_C(1380575039191661000), 0x0003, 0x0001, 4629},
    {INT64_C(1380575039191661000), 0x0003, 0x0035, 5279},
    {INT64_C(1380575039191661000), 0x0003, 0x0036, 4629},
    {INT64_C(1380575039191661000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039191661000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039191661000), 0x0003, 0x0031, 384},
    {INT64_C(1380575039191661000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039191661000), 0x0003, 0x0035, 4321},
    {INT64_C(1380575039191661000), 0x0003, 0x0036, 4553},
    {INT64_C(1380575039191661000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039191661000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039191661000), 0x0003, 0x0031, 384},
    {INT64_C(1380575039191661000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039191661000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039209660000), 0x0003, 0x0000, 5222},
    {INT64_C(1380575039209660000), 0x0003, 0x0001, 4441},
    {INT64_C(1380575039209660000), 0x0003, 0x0035, 5222},
    {INT64_C(1380575039209660000), 0x0003, 0x0036, 4441},
    {INT64_C(1380575039209660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039209660000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039209660000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039209660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039209660000), 0x0003, 0x0035, 4295},
    {INT64_C(1380575039209660000), 0x0003, 0x0036, 4271},
    {INT64_C(1380575039209660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039209660000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039209660000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039209660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039209660000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039227657000), 0x0003, 0x0000, 5120},
    {INT64_C(1380575039227657000), 0x0003, 0x0001, 4239},
    {INT64_C(1380575039227657000), 0x0003, 0x0035, 5120},
    {INT64_C(1380575039227657000), 0x0003, 0x0036, 4239},
    {INT64_C(1380575039227657000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039227657000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039227657000), 0x0003, 0x0031, 128},
    {INT64_C(1380575039227657000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039227657000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039321656000), 0x0001, 0x014d, 0},
    {INT64_C(1380575039321656000), 0x0001, 0x014a, 0},
    {INT64_C(1380575039321656000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039589659000), 0x0003, 0x0000, 5116},
    {INT64_C(1380575039589659000), 0x0003, 0x0001, 5686},
    {INT64_C(1380575039589659000), 0x0003, 0x0035, 5116},
    {INT64_C(1380575039589659000), 0x0003, 0x0036, 5686},
    {INT64_C(1380575039589659000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039589659000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039589659000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039589659000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039589659000), 0x0003, 0x0035, 2240},
    {INT64_C(1380575039589659000), 0x0003, 0x0036, 5218},
    {INT64_C(1380575039589659000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039589659000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039589659000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039589659000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039589659000), 0x0003, 0x0035, 2849},
    {INT64_C(1380575039589659000), 0x0003, 0x0036, 1851},
    {INT64_C(1380575039589659000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039589659000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039589659000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039589659000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039589659000), 0x0001, 0x014d, 1},
    {INT64_C(1380575039589659000), 0x0001, 0x014a, 1},
    {INT64_C(1380575039589659000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039603660000), 0x0003, 0x0000, 5108},
    {INT64_C(1380575039603660000), 0x0003, 0x0001, 5677},
    {INT64_C(1380575039603660000), 0x0003, 0x0035, 5108},
    {INT64_C(1380575039603660000), 0x0003, 0x0036, 5677},
    {INT64_C(1380575039603660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039603660000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039603660000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039603660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039603660000), 0x0003, 0x0035, 2241},
    {INT64_C(1380575039603660000), 0x0003, 0x0036, 5218},
    {INT64_C(1380575039603660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039603660000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039603660000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039603660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039603660000), 0x0003, 0x0035, 2864},
    {INT64_C(1380575039603660000), 0x0003, 0x0036, 1848},
    {INT64_C(1380575039603660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039603660000), 0x0003, 0x0030, 512},
    {INT64_C(1380575039603660000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039603660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039603660000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039609656000), 0x0003, 0x0000, 5105},
    {INT64_C(1380575039609656000), 0x0003, 0x0001, 5583},
    {INT64_C(1380575039609656000), 0x0003, 0x0035, 5105},
    {INT64_C(1380575039609656000), 0x0003, 0x0036, 5583},
    {INT64_C(1380575039609656000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039609656000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039609656000), 0x0003, 0x0031, 384},
    {INT64_C(1380575039609656000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039609656000), 0x0003, 0x0035, 2257},
    {INT64_C(1380575039609656000), 0x0003, 0x0036, 5200},
    {INT64_C(1380575039609656000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039609656000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039609656000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039609656000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039609656000), 0x0003, 0x0035, 2874},
    {INT64_C(1380575039609656000), 0x0003, 0x0036, 1856},
    {INT64_C(1380575039609656000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039609656000), 0x0003, 0x0030, 512},
    {INT64_C(1380575039609656000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039609656000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039609656000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039621660000), 0x0003, 0x0000, 2884},
    {INT64_C(1380575039621660000), 0x0003, 0x0001, 6400},
    {INT64_C(1380575039621660000), 0x0003, 0x0035, 2884},
    {INT64_C(1380575039621660000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575039621660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039621660000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039621660000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039621660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039621660000), 0x0003, 0x0035, 4009},
    {INT64_C(1380575039621660000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575039621660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039621660000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039621660000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039621660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039621660000), 0x0003, 0x0035, 5089},
    {INT64_C(1380575039621660000), 0x0003, 0x0036, 5453},
    {INT64_C(1380575039621660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039621660000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039621660000), 0x0003, 0x0031, 384},
    {INT64_C(1380575039621660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039621660000), 0x0003, 0x0035, 2272},
    {INT64_C(1380575039621660000), 0x0003, 0x0036, 5187},
    {INT64_C(1380575039621660000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039621660000), 0x0003, 0x0030, 320},
    {INT64_C(1380575039621660000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039621660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039621660000), 0x0003, 0x0035, 2899},
    {INT64_C(1380575039621660000), 0x0003, 0x0036, 1865},
    {INT64_C(1380575039621660000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039621660000), 0x0003, 0x0030, 512},
    {INT64_C(1380575039621660000), 0x0003, 0x0031, 320},
    {INT64_C(1380575039621660000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039621660000), 0x0000, 0x0000, 0},
    {INT64_C(1380575039627662000), 0x0003, 0x0000, 2894},
    {INT64_C(1380575039627662000), 0x0003, 0x0035, 2894},
    {INT64_C(1380575039627662000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575039627662000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039627662000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039627662000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039627662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039627662000), 0x0003, 0x0035, 4013},
    {INT64_C(1380575039627662000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575039627662000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039627662000), 0x0003, 0x0030, 256},
    {INT64_C(1380575039627662000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039627662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039627662000), 0x0003, 0x0035, 5058},
    {INT64_C(1380575039627662000), 0x0003, 0x0036, 5288},
    {INT64_C(1380575039627662000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039627662000), 0x0003, 0x0030, 800},
    {INT64_C(1380575039627662000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039627662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039627662000), 0x0003, 0x0035, 2280},
    {INT64_C(1380575039627662000), 0x0003, 0x0036, 5095},
    {INT64_C(1380575039627662000), 0x0003, 0x0034, 0},
    {INT64_C(1380575039627662000), 0x0003, 0x0030, 480},
    {INT64_C(1380575039627662000), 0x0003, 0x0031, 256},
    {INT64_C(1380575039627662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039627662000), 0x0003, 0x0035, 2935},
    {INT64_C(1380575039627662000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575039627662000), 0x0003, 0x0034, 1},
    {INT64_C(1380575039627662000), 0x0003, 0x0030, 384},
    {INT64_C(1380575039627662000), 0x0003, 0x0031, 160},
    {INT64_C(1380575039627662000), 0x0000, 0x0002, 0},
    {INT64_C(1380575039627662000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040145654000), 0x0003, 0x0035, 2272},
    {INT64_C(1380575040145654000), 0x0003, 0x0036, 1358},
    {INT64_C(1380575040145654000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040145654000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040145654000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040145654000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040145654000), 0x0001, 0x014d, 0},
    {INT64_C(1380575040145654000), 0x0001, 0x014a, 0},
    {INT64_C(1380575040145654000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040151655000), 0x0003, 0x0000, 1152},
    {INT64_C(1380575040151655000), 0x0003, 0x0001, 5376},
    {INT64_C(1380575040151655000), 0x0003, 0x0035, 1152},
    {INT64_C(1380575040151655000), 0x0003, 0x0036, 5376},
    {INT64_C(1380575040151655000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040151655000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040151655000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040151655000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040151655000), 0x0003, 0x0035, 851},
    {INT64_C(1380575040151655000), 0x0003, 0x0036, 3917},
    {INT64_C(1380575040151655000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040151655000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040151655000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040151655000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040151655000), 0x0003, 0x0035, 2242},
    {INT64_C(1380575040151655000), 0x0003, 0x0036, 1322},
    {INT64_C(1380575040151655000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040151655000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040151655000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040151655000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040151655000), 0x0001, 0x014d, 1},
    {INT64_C(1380575040151655000), 0x0001, 0x014a, 1},
    {INT64_C(1380575040151655000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040163650000), 0x0003, 0x0000, 1216},
    {INT64_C(1380575040163650000), 0x0003, 0x0001, 5348},
    {INT64_C(1380575040163650000), 0x0003, 0x0035, 1216},
    {INT64_C(1380575040163650000), 0x0003, 0x0036, 5348},
    {INT64_C(1380575040163650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040163650000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040163650000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040163650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040163650000), 0x0003, 0x0035, 896},
    {INT64_C(1380575040163650000), 0x0003, 0x0036, 3898},
    {INT64_C(1380575040163650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040163650000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040163650000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040163650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040163650000), 0x0003, 0x0035, 2317},
    {INT64_C(1380575040163650000), 0x0003, 0x0036, 1280},
    {INT64_C(1380575040163650000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040163650000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040163650000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040163650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040163650000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040169651000), 0x0003, 0x0000, 1322},
    {INT64_C(1380575040169651000), 0x0003, 0x0001, 5238},
    {INT64_C(1380575040169651000), 0x0003, 0x0035, 1322},
    {INT64_C(1380575040169651000), 0x0003, 0x0036, 5238},
    {INT64_C(1380575040169651000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040169651000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040169651000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040169651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040169651000), 0x0003, 0x0035, 1009},
    {INT64_C(1380575040169651000), 0x0003, 0x0036, 3830},
    {INT64_C(1380575040169651000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040169651000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040169651000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040169651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040169651000), 0x0003, 0x0035, 2375},
    {INT64_C(1380575040169651000), 0x0003, 0x0036, 1280},
    {INT64_C(1380575040169651000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040169651000), 0x0003, 0x0030, 256},
    {INT64_C(1380575040169651000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040169651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040169651000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040183654000), 0x0003, 0x0000, 2048},
    {INT64_C(1380575040183654000), 0x0003, 0x0001, 5564},
    {INT64_C(1380575040183654000), 0x0003, 0x0035, 2048},
    {INT64_C(1380575040183654000), 0x0003, 0x0036, 5564},
    {INT64_C(1380575040183654000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040183654000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040183654000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040183654000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040183654000), 0x0003, 0x0035, 1386},
    {INT64_C(1380575040183654000), 0x0003, 0x0036, 5187},
    {INT64_C(1380575040183654000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040183654000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040183654000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040183654000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040183654000), 0x0003, 0x0035, 1202},
    {INT64_C(1380575040183654000), 0x0003, 0x0036, 3783},
    {INT64_C(1380575040183654000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040183654000), 0x0003, 0x0030, 512},
    {INT64_C(1380575040183654000), 0x0003, 0x0031, 480},
    {INT64_C(1380575040183654000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040183654000), 0x0003, 0x0035, 2464},
    {INT64_C(1380575040183654000), 0x0003, 0x0036, 1280},
    {INT64_C(1380575040183654000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040183654000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040183654000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040183654000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040183654000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040189656000), 0x0003, 0x0000, 2176},
    {INT64_C(1380575040189656000), 0x0003, 0x0001, 5491},
    {INT64_C(1380575040189656000), 0x0003, 0x0035, 2176},
    {INT64_C(1380575040189656000), 0x0003, 0x0036, 5491},
    {INT64_C(1380575040189656000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040189656000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040189656000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040189656000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040189656000), 0x0003, 0x0035, 1519},
    {INT64_C(1380575040189656000), 0x0003, 0x0036, 5028},
    {INT64_C(1380575040189656000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040189656000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040189656000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040189656000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040189656000), 0x0003, 0x0035, 1355},
    {INT64_C(1380575040189656000), 0x0003, 0x0036, 3750},
    {INT64_C(1380575040189656000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040189656000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040189656000), 0x0003, 0x0031, 384},
    {INT64_C(1380575040189656000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040189656000), 0x0003, 0x0035, 2533},
    {INT64_C(1380575040189656000), 0x0003, 0x0036, 1280},
    {INT64_C(1380575040189656000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040189656000), 0x0003, 0x0030, 256},
    {INT64_C(1380575040189656000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040189656000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040189656000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040201655000), 0x0003, 0x0000, 1623},
    {INT64_C(1380575040201655000), 0x0003, 0x0001, 4954},
    {INT64_C(1380575040201655000), 0x0003, 0x0035, 1623},
    {INT64_C(1380575040201655000), 0x0003, 0x0036, 4954},
    {INT64_C(1380575040201655000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040201655000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040201655000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040201655000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040201655000), 0x0003, 0x0035, 1492},
    {INT64_C(1380575040201655000), 0x0003, 0x0036, 3721},
    {INT64_C(1380575040201655000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040201655000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040201655000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040201655000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040201655000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040207655000), 0x0003, 0x0000, 2430},
    {INT64_C(1380575040207655000), 0x0003, 0x0001, 5317},
    {INT64_C(1380575040207655000), 0x0003, 0x0035, 2430},
    {INT64_C(1380575040207655000), 0x0003, 0x0036, 5317},
    {INT64_C(1380575040207655000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040207655000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040207655000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040207655000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040207655000), 0x0003, 0x0035, 1751},
    {INT64_C(1380575040207655000), 0x0003, 0x0036, 4903},
    {INT64_C(1380575040207655000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040207655000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040207655000), 0x0003, 0x0031, 384},
    {INT64_C(1380575040207655000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040207655000), 0x0003, 0x0035, 1624},
    {INT64_C(1380575040207655000), 0x0003, 0x0036, 3610},
    {INT64_C(1380575040207655000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040207655000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040207655000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040207655000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040207655000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040219653000), 0x0003, 0x0000, 2560},
    {INT64_C(1380575040219653000), 0x0003, 0x0001, 5225},
    {INT64_C(1380575040219653000), 0x0003, 0x0035, 2560},
    {INT64_C(1380575040219653000), 0x0003, 0x0036, 5225},
    {INT64_C(1380575040219653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040219653000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040219653000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040219653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040219653000), 0x0003, 0x0035, 1886},
    {INT64_C(1380575040219653000), 0x0003, 0x0036, 4813},
    {INT64_C(1380575040219653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040219653000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040219653000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040219653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040219653000), 0x0003, 0x0035, 1789},
    {INT64_C(1380575040219653000), 0x0003, 0x0036, 3590},
    {INT64_C(1380575040219653000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040219653000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040219653000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040219653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040219653000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040225654000), 0x0003, 0x0000, 2688},
    {INT64_C(1380575040225654000), 0x0003, 0x0001, 5100},
    {INT64_C(1380575040225654000), 0x0003, 0x0035, 2688},
    {INT64_C(1380575040225654000), 0x0003, 0x0036, 5100},
    {INT64_C(1380575040225654000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040225654000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040225654000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040225654000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040225654000), 0x0003, 0x0035, 2027},
    {INT64_C(1380575040225654000), 0x0003, 0x0036, 4717},
    {INT64_C(1380575040225654000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040225654000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040225654000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040225654000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040225654000), 0x0003, 0x0035, 1968},
    {INT64_C(1380575040225654000), 0x0003, 0x0036, 3570},
    {INT64_C(1380575040225654000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040225654000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040225654000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040225654000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040225654000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040239650000), 0x0003, 0x0000, 2853},
    {INT64_C(1380575040239650000), 0x0003, 0x0001, 5006},
    {INT64_C(1380575040239650000), 0x0003, 0x0035, 2853},
    {INT64_C(1380575040239650000), 0x0003, 0x0036, 5006},
    {INT64_C(1380575040239650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040239650000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040239650000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040239650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040239650000), 0x0003, 0x0035, 2223},
    {INT64_C(1380575040239650000), 0x0003, 0x0036, 4599},
    {INT64_C(1380575040239650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040239650000), 0x0003, 0x0030, 800},
    {INT64_C(1380575040239650000), 0x0003, 0x0031, 384},
    {INT64_C(1380575040239650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040239650000), 0x0003, 0x0035, 2134},
    {INT64_C(1380575040239650000), 0x0003, 0x0036, 3537},
    {INT64_C(1380575040239650000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040239650000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040239650000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040239650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040239650000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040257651000), 0x0003, 0x0000, 3054},
    {INT64_C(1380575040257651000), 0x0003, 0x0001, 4901},
    {INT64_C(1380575040257651000), 0x0003, 0x0035, 3054},
    {INT64_C(1380575040257651000), 0x0003, 0x0036, 4901},
    {INT64_C(1380575040257651000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040257651000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040257651000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040257651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040257651000), 0x0003, 0x0035, 2397},
    {INT64_C(1380575040257651000), 0x0003, 0x0036, 4504},
    {INT64_C(1380575040257651000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040257651000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040257651000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040257651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040257651000), 0x0003, 0x0035, 2343},
    {INT64_C(1380575040257651000), 0x0003, 0x0036, 3435},
    {INT64_C(1380575040257651000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040257651000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040257651000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040257651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040257651000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040277653000), 0x0003, 0x0000, 3235},
    {INT64_C(1380575040277653000), 0x0003, 0x0001, 4763},
    {INT64_C(1380575040277653000), 0x0003, 0x0035, 3235},
    {INT64_C(1380575040277653000), 0x0003, 0x0036, 4763},
    {INT64_C(1380575040277653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040277653000), 0x0003, 0x0030, 640},
    {INT64_C(1380575040277653000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040277653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040277653000), 0x0003, 0x0035, 2603},
    {INT64_C(1380575040277653000), 0x0003, 0x0036, 4386},
    {INT64_C(1380575040277653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040277653000), 0x0003, 0x0030, 800},
    {INT64_C(1380575040277653000), 0x0003, 0x0031, 384},
    {INT64_C(1380575040277653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040277653000), 0x0003, 0x0035, 2535},
    {INT64_C(1380575040277653000), 0x0003, 0x0036, 3400},
    {INT64_C(1380575040277653000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040277653000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040277653000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040277653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040277653000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040295652000), 0x0003, 0x0000, 3422},
    {INT64_C(1380575040295652000), 0x0003, 0x0001, 4635},
    {INT64_C(1380575040295652000), 0x0003, 0x0035, 3422},
    {INT64_C(1380575040295652000), 0x0003, 0x0036, 4635},
    {INT64_C(1380575040295652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040295652000), 0x0003, 0x0030, 640},
    {INT64_C(1380575040295652000), 0x0003, 0x0031, 384},
    {INT64_C(1380575040295652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040295652000), 0x0003, 0x0035, 2782},
    {INT64_C(1380575040295652000), 0x0003, 0x0036, 4307},
    {INT64_C(1380575040295652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040295652000), 0x0003, 0x0030, 800},
    {INT64_C(1380575040295652000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040295652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040295652000), 0x0003, 0x0035, 2724},
    {INT64_C(1380575040295652000), 0x0003, 0x0036, 3370},
    {INT64_C(1380575040295652000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040295652000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040295652000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040295652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040295652000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040313650000), 0x0003, 0x0000, 3601},
    {INT64_C(1380575040313650000), 0x0003, 0x0001, 4497},
    {INT64_C(1380575040313650000), 0x0003, 0x0035, 3601},
    {INT64_C(1380575040313650000), 0x0003, 0x0036, 4497},
    {INT64_C(1380575040313650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040313650000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040313650000), 0x0003, 0x0031, 384},
    {INT64_C(1380575040313650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040313650000), 0x0003, 0x0035, 2982},
    {INT64_C(1380575040313650000), 0x0003, 0x0036, 4205},
    {INT64_C(1380575040313650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040313650000), 0x0003, 0x0030, 640},
    {INT64_C(1380575040313650000), 0x0003, 0x0031, 384},
    {INT64_C(1380575040313650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040313650000), 0x0003, 0x0035, 2910},
    {INT64_C(1380575040313650000), 0x0003, 0x0036, 3244},
    {INT64_C(1380575040313650000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040313650000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040313650000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040313650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040313650000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040333652000), 0x0003, 0x0000, 3815},
    {INT64_C(1380575040333652000), 0x0003, 0x0001, 4388},
    {INT64_C(1380575040333652000), 0x0003, 0x0035, 3815},
    {INT64_C(1380575040333652000), 0x0003, 0x0036, 4388},
    {INT64_C(1380575040333652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040333652000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040333652000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040333652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040333652000), 0x0003, 0x0035, 3188},
    {INT64_C(1380575040333652000), 0x0003, 0x0036, 4079},
    {INT64_C(1380575040333652000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040333652000), 0x0003, 0x0030, 512},
    {INT64_C(1380575040333652000), 0x0003, 0x0031, 480},
    {INT64_C(1380575040333652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040333652000), 0x0003, 0x0035, 3117},
    {INT64_C(1380575040333652000), 0x0003, 0x0036, 3200},
    {INT64_C(1380575040333652000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040333652000), 0x0003, 0x0030, 256},
    {INT64_C(1380575040333652000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040333652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040333652000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040351652000), 0x0003, 0x0000, 3941},
    {INT64_C(1380575040351652000), 0x0003, 0x0001, 4289},
    {INT64_C(1380575040351652000), 0x0003, 0x0035, 3941},
    {INT64_C(1380575040351652000), 0x0003, 0x0036, 4289},
    {INT64_C(1380575040351652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040351652000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040351652000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040351652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040351652000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040369652000), 0x0003, 0x0000, 4096},
    {INT64_C(1380575040369652000), 0x0003, 0x0001, 4166},
    {INT64_C(1380575040369652000), 0x0003, 0x0035, 4096},
    {INT64_C(1380575040369652000), 0x0003, 0x0036, 4166},
    {INT64_C(1380575040369652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040369652000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040369652000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040369652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040369652000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040463647000), 0x0001, 0x014d, 0},
    {INT64_C(1380575040463647000), 0x0001, 0x014a, 0},
    {INT64_C(1380575040463647000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040669651000), 0x0003, 0x0035, 5861},
    {INT64_C(1380575040669651000), 0x0003, 0x0036, 5441},
    {INT64_C(1380575040669651000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040669651000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040669651000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040669651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040669651000), 0x0003, 0x0035, 2759},
    {INT64_C(1380575040669651000), 0x0003, 0x0036, 5283},
    {INT64_C(1380575040669651000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040669651000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040669651000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040669651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040669651000), 0x0003, 0x0035, 3449},
    {INT64_C(1380575040669651000), 0x0003, 0x0036, 1480},
    {INT64_C(1380575040669651000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040669651000), 0x0003, 0x0030, 768},
    {INT64_C(1380575040669651000), 0x0003, 0x0031, 480},
    {INT64_C(1380575040669651000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040669651000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040675653000), 0x0003, 0x0000, 3491},
    {INT64_C(1380575040675653000), 0x0003, 0x0001, 6400},
    {INT64_C(1380575040675653000), 0x0003, 0x0035, 3491},
    {INT64_C(1380575040675653000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575040675653000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040675653000), 0x0003, 0x0030, 512},
    {INT64_C(1380575040675653000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040675653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040675653000), 0x0003, 0x0035, 2768},
    {INT64_C(1380575040675653000), 0x0003, 0x0036, 5228},
    {INT64_C(1380575040675653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040675653000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040675653000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040675653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040675653000), 0x0003, 0x0035, 3564},
    {INT64_C(1380575040675653000), 0x0003, 0x0036, 5208},
    {INT64_C(1380575040675653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040675653000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040675653000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040675653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040675653000), 0x0003, 0x0035, 5861},
    {INT64_C(1380575040675653000), 0x0003, 0x0036, 5355},
    {INT64_C(1380575040675653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040675653000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040675653000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040675653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040675653000), 0x0003, 0x0035, 3470},
    {INT64_C(1380575040675653000), 0x0003, 0x0036, 1592},
    {INT64_C(1380575040675653000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040675653000), 0x0003, 0x0030, 768},
    {INT64_C(1380575040675653000), 0x0003, 0x0031, 480},
    {INT64_C(1380575040675653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040675653000), 0x0001, 0x014d, 1},
    {INT64_C(1380575040675653000), 0x0001, 0x014a, 1},
    {INT64_C(1380575040675653000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040689652000), 0x0003, 0x0000, 3511},
    {INT64_C(1380575040689652000), 0x0003, 0x0035, 3511},
    {INT64_C(1380575040689652000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575040689652000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040689652000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040689652000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040689652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040689652000), 0x0003, 0x0035, 2764},
    {INT64_C(1380575040689652000), 0x0003, 0x0036, 5214},
    {INT64_C(1380575040689652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040689652000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040689652000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040689652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040689652000), 0x0003, 0x0035, 5797},
    {INT64_C(1380575040689652000), 0x0003, 0x0036, 5245},
    {INT64_C(1380575040689652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040689652000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040689652000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040689652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040689652000), 0x0003, 0x0035, 3408},
    {INT64_C(1380575040689652000), 0x0003, 0x0036, 1552},
    {INT64_C(1380575040689652000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040689652000), 0x0003, 0x0030, 640},
    {INT64_C(1380575040689652000), 0x0003, 0x0031, 480},
    {INT64_C(1380575040689652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040689652000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040695653000), 0x0003, 0x0000, 3490},
    {INT64_C(1380575040695653000), 0x0003, 0x0001, 6240},
    {INT64_C(1380575040695653000), 0x0003, 0x0035, 3490},
    {INT64_C(1380575040695653000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575040695653000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040695653000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040695653000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040695653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040695653000), 0x0003, 0x0035, 4595},
    {INT64_C(1380575040695653000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575040695653000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040695653000), 0x0003, 0x0030, 256},
    {INT64_C(1380575040695653000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040695653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040695653000), 0x0003, 0x0035, 2761},
    {INT64_C(1380575040695653000), 0x0003, 0x0036, 5200},
    {INT64_C(1380575040695653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040695653000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040695653000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040695653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040695653000), 0x0003, 0x0035, 5760},
    {INT64_C(1380575040695653000), 0x0003, 0x0036, 5092},
    {INT64_C(1380575040695653000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040695653000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040695653000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040695653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040695653000), 0x0003, 0x0035, 3359},
    {INT64_C(1380575040695653000), 0x0003, 0x0036, 1461},
    {INT64_C(1380575040695653000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040695653000), 0x0003, 0x0030, 512},
    {INT64_C(1380575040695653000), 0x0003, 0x0031, 480},
    {INT64_C(1380575040695653000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040695653000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0000, 3477},
    {INT64_C(1380575040707652000), 0x0003, 0x0035, 3477},
    {INT64_C(1380575040707652000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575040707652000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040707652000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040707652000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040707652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0035, 4582},
    {INT64_C(1380575040707652000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575040707652000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040707652000), 0x0003, 0x0030, 256},
    {INT64_C(1380575040707652000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040707652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0035, 2751},
    {INT64_C(1380575040707652000), 0x0003, 0x0036, 5089},
    {INT64_C(1380575040707652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040707652000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040707652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0035, 5667},
    {INT64_C(1380575040707652000), 0x0003, 0x0036, 4955},
    {INT64_C(1380575040707652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040707652000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040707652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0035, 3456},
    {INT64_C(1380575040707652000), 0x0003, 0x0036, 4909},
    {INT64_C(1380575040707652000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040707652000), 0x0003, 0x0031, 128},
    {INT64_C(1380575040707652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040707652000), 0x0003, 0x0035, 3333},
    {INT64_C(1380575040707652000), 0x0003, 0x0036, 1455},
    {INT64_C(1380575040707652000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040707652000), 0x0003, 0x0030, 512},
    {INT64_C(1380575040707652000), 0x0003, 0x0031, 480},
    {INT64_C(1380575040707652000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040707652000), 0x0000, 0x0000, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0000, 3453},
    {INT64_C(1380575040713650000), 0x0003, 0x0001, 6154},
    {INT64_C(1380575040713650000), 0x0003, 0x0035, 3453},
    {INT64_C(1380575040713650000), 0x0003, 0x0036, 6154},
    {INT64_C(1380575040713650000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040713650000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040713650000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040713650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0035, 4569},
    {INT64_C(1380575040713650000), 0x0003, 0x0036, 6143},
    {INT64_C(1380575040713650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040713650000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040713650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0035, 2751},
    {INT64_C(1380575040713650000), 0x0003, 0x0036, 5038},
    {INT64_C(1380575040713650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0030, 320},
    {INT64_C(1380575040713650000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040713650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0035, 5583},
    {INT64_C(1380575040713650000), 0x0003, 0x0036, 4903},
    {INT64_C(1380575040713650000), 0x0003, 0x0034, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0030, 480},
    {INT64_C(1380575040713650000), 0x0003, 0x0031, 256},
    {INT64_C(1380575040713650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0035, 3405},
    {INT64_C(1380575040713650000), 0x0003, 0x0036, 4960},
    {INT64_C(1380575040713650000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040713650000), 0x0003, 0x0030, 256},
    {INT64_C(1380575040713650000), 0x0003, 0x0031, 160},
    {INT64_C(1380575040713650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040713650000), 0x0003, 0x0035, 3334},
    {INT64_C(1380575040713650000), 0x0003, 0x0036, 1491},
    {INT64_C(1380575040713650000), 0x0003, 0x0034, 1},
    {INT64_C(1380575040713650000), 0x0003, 0x0030, 384},
    {INT64_C(1380575040713650000), 0x0003, 0x0031, 320},
    {INT64_C(1380575040713650000), 0x0000, 0x0002, 0},
    {INT64_C(1380575040713650000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041249641000), 0x0003, 0x0035, 3500},
    {INT64_C(1380575041249641000), 0x0003, 0x0036, 5341},
    {INT64_C(1380575041249641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041249641000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041249641000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041249641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041249641000), 0x0001, 0x014d, 0},
    {INT64_C(1380575041249641000), 0x0001, 0x014a, 0},
    {INT64_C(1380575041249641000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041255646000), 0x0003, 0x0000, 1475},
    {INT64_C(1380575041255646000), 0x0003, 0x0001, 5920},
    {INT64_C(1380575041255646000), 0x0003, 0x0035, 1475},
    {INT64_C(1380575041255646000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575041255646000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041255646000), 0x0003, 0x0030, 256},
    {INT64_C(1380575041255646000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041255646000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041255646000), 0x0003, 0x0035, 3501},
    {INT64_C(1380575041255646000), 0x0003, 0x0036, 5296},
    {INT64_C(1380575041255646000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041255646000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041255646000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041255646000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041255646000), 0x0001, 0x014d, 1},
    {INT64_C(1380575041255646000), 0x0001, 0x014a, 1},
    {INT64_C(1380575041255646000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041269649000), 0x0003, 0x0000, 1505},
    {INT64_C(1380575041269649000), 0x0003, 0x0035, 1505},
    {INT64_C(1380575041269649000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575041269649000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041269649000), 0x0003, 0x0030, 256},
    {INT64_C(1380575041269649000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041269649000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041269649000), 0x0003, 0x0035, 3520},
    {INT64_C(1380575041269649000), 0x0003, 0x0036, 5120},
    {INT64_C(1380575041269649000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041269649000), 0x0003, 0x0030, 256},
    {INT64_C(1380575041269649000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041269649000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041269649000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041275647000), 0x0003, 0x0000, 1522},
    {INT64_C(1380575041275647000), 0x0003, 0x0001, 5677},
    {INT64_C(1380575041275647000), 0x0003, 0x0035, 1522},
    {INT64_C(1380575041275647000), 0x0003, 0x0036, 5677},
    {INT64_C(1380575041275647000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041275647000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041275647000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041275647000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041275647000), 0x0003, 0x0035, 3516},
    {INT64_C(1380575041275647000), 0x0003, 0x0036, 4854},
    {INT64_C(1380575041275647000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041275647000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041275647000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041275647000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041275647000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041287646000), 0x0003, 0x0000, 1583},
    {INT64_C(1380575041287646000), 0x0003, 0x0001, 5531},
    {INT64_C(1380575041287646000), 0x0003, 0x0035, 1583},
    {INT64_C(1380575041287646000), 0x0003, 0x0036, 5531},
    {INT64_C(1380575041287646000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041287646000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041287646000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041287646000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041287646000), 0x0003, 0x0035, 3519},
    {INT64_C(1380575041287646000), 0x0003, 0x0036, 4649},
    {INT64_C(1380575041287646000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041287646000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041287646000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041287646000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041287646000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041293648000), 0x0003, 0x0000, 2576},
    {INT64_C(1380575041293648000), 0x0003, 0x0001, 5756},
    {INT64_C(1380575041293648000), 0x0003, 0x0035, 2576},
    {INT64_C(1380575041293648000), 0x0003, 0x0036, 5756},
    {INT64_C(1380575041293648000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041293648000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041293648000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041293648000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041293648000), 0x0003, 0x0035, 1595},
    {INT64_C(1380575041293648000), 0x0003, 0x0036, 5372},
    {INT64_C(1380575041293648000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041293648000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041293648000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041293648000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041293648000), 0x0003, 0x0035, 3525},
    {INT64_C(1380575041293648000), 0x0003, 0x0036, 4498},
    {INT64_C(1380575041293648000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041293648000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041293648000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041293648000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041293648000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041305648000), 0x0003, 0x0000, 2593},
    {INT64_C(1380575041305648000), 0x0003, 0x0001, 5760},
    {INT64_C(1380575041305648000), 0x0003, 0x0035, 2593},
    {INT64_C(1380575041305648000), 0x0003, 0x0036, 5760},
    {INT64_C(1380575041305648000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041305648000), 0x0003, 0x0030, 256},
    {INT64_C(1380575041305648000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041305648000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041305648000), 0x0003, 0x0035, 1619},
    {INT64_C(1380575041305648000), 0x0003, 0x0036, 5302},
    {INT64_C(1380575041305648000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041305648000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041305648000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041305648000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041305648000), 0x0003, 0x0035, 3529},
    {INT64_C(1380575041305648000), 0x0003, 0x0036, 4388},
    {INT64_C(1380575041305648000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041305648000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041305648000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041305648000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041305648000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041311647000), 0x0003, 0x0000, 2632},
    {INT64_C(1380575041311647000), 0x0003, 0x0001, 5539},
    {INT64_C(1380575041311647000), 0x0003, 0x0035, 2632},
    {INT64_C(1380575041311647000), 0x0003, 0x0036, 5539},
    {INT64_C(1380575041311647000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041311647000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041311647000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041311647000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041311647000), 0x0003, 0x0035, 1725},
    {INT64_C(1380575041311647000), 0x0003, 0x0036, 5126},
    {INT64_C(1380575041311647000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041311647000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041311647000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041311647000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041311647000), 0x0003, 0x0035, 3544},
    {INT64_C(1380575041311647000), 0x0003, 0x0036, 4289},
    {INT64_C(1380575041311647000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041311647000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041311647000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041311647000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041311647000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041325644000), 0x0003, 0x0000, 2674},
    {INT64_C(1380575041325644000), 0x0003, 0x0001, 5367},
    {INT64_C(1380575041325644000), 0x0003, 0x0035, 2674},
    {INT64_C(1380575041325644000), 0x0003, 0x0036, 5367},
    {INT64_C(1380575041325644000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041325644000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041325644000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041325644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041325644000), 0x0003, 0x0035, 1754},
    {INT64_C(1380575041325644000), 0x0003, 0x0036, 4982},
    {INT64_C(1380575041325644000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041325644000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041325644000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041325644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041325644000), 0x0003, 0x0035, 3552},
    {INT64_C(1380575041325644000), 0x0003, 0x0036, 4132},
    {INT64_C(1380575041325644000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041325644000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041325644000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041325644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041325644000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041331646000), 0x0003, 0x0000, 2720},
    {INT64_C(1380575041331646000), 0x0003, 0x0001, 5176},
    {INT64_C(1380575041331646000), 0x0003, 0x0035, 2720},
    {INT64_C(1380575041331646000), 0x0003, 0x0036, 5176},
    {INT64_C(1380575041331646000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041331646000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041331646000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041331646000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041331646000), 0x0003, 0x0035, 1792},
    {INT64_C(1380575041331646000), 0x0003, 0x0036, 4738},
    {INT64_C(1380575041331646000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041331646000), 0x0003, 0x0030, 640},
    {INT64_C(1380575041331646000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041331646000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041331646000), 0x0003, 0x0035, 3580},
    {INT64_C(1380575041331646000), 0x0003, 0x0036, 4016},
    {INT64_C(1380575041331646000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041331646000), 0x0003, 0x0030, 384},
    {INT64_C(1380575041331646000), 0x0003, 0x0031, 320},
    {INT64_C(1380575041331646000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041331646000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041343647000), 0x0003, 0x0000, 2770},
    {INT64_C(1380575041343647000), 0x0003, 0x0001, 4967},
    {INT64_C(1380575041343647000), 0x0003, 0x0035, 2770},
    {INT64_C(1380575041343647000), 0x0003, 0x0036, 4967},
    {INT64_C(1380575041343647000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041343647000), 0x0003, 0x0030, 640},
    {INT64_C(1380575041343647000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041343647000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041343647000), 0x0003, 0x0035, 1869},
    {INT64_C(1380575041343647000), 0x0003, 0x0036, 4493},
    {INT64_C(1380575041343647000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041343647000), 0x0003, 0x0030, 640},
    {INT64_C(1380575041343647000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041343647000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041343647000), 0x0003, 0x0035, 3582},
    {INT64_C(1380575041343647000), 0x0003, 0x0036, 3840},
    {INT64_C(1380575041343647000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041343647000), 0x0003, 0x0030, 384},
    {INT64_C(1380575041343647000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041343647000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041343647000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041361648000), 0x0003, 0x0000, 2809},
    {INT64_C(1380575041361648000), 0x0003, 0x0001, 4729},
    {INT64_C(1380575041361648000), 0x0003, 0x0035, 2809},
    {INT64_C(1380575041361648000), 0x0003, 0x0036, 4729},
    {INT64_C(1380575041361648000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041361648000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041361648000), 0x0003, 0x0031, 384},
    {INT64_C(1380575041361648000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041361648000), 0x0003, 0x0035, 1915},
    {INT64_C(1380575041361648000), 0x0003, 0x0036, 4233},
    {INT64_C(1380575041361648000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041361648000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041361648000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041361648000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041361648000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041381645000), 0x0003, 0x0000, 2880},
    {INT64_C(1380575041381645000), 0x0003, 0x0001, 4440},
    {INT64_C(1380575041381645000), 0x0003, 0x0035, 2880},
    {INT64_C(1380575041381645000), 0x0003, 0x0036, 4440},
    {INT64_C(1380575041381645000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041381645000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041381645000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041381645000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041381645000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041399644000), 0x0003, 0x0000, 2981},
    {INT64_C(1380575041399644000), 0x0003, 0x0001, 4126},
    {INT64_C(1380575041399644000), 0x0003, 0x0035, 2981},
    {INT64_C(1380575041399644000), 0x0003, 0x0036, 4126},
    {INT64_C(1380575041399644000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041399644000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041399644000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041399644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041399644000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041493641000), 0x0001, 0x014d, 0},
    {INT64_C(1380575041493641000), 0x0001, 0x014a, 0},
    {INT64_C(1380575041493641000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041855641000), 0x0003, 0x0000, 7653},
    {INT64_C(1380575041855641000), 0x0003, 0x0001, 4420},
    {INT64_C(1380575041855641000), 0x0003, 0x0035, 7653},
    {INT64_C(1380575041855641000), 0x0003, 0x0036, 4420},
    {INT64_C(1380575041855641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041855641000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041855641000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041855641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041855641000), 0x0001, 0x014d, 1},
    {INT64_C(1380575041855641000), 0x0001, 0x014a, 1},
    {INT64_C(1380575041855641000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041867642000), 0x0003, 0x0000, 7596},
    {INT64_C(1380575041867642000), 0x0003, 0x0001, 4360},
    {INT64_C(1380575041867642000), 0x0003, 0x0035, 7596},
    {INT64_C(1380575041867642000), 0x0003, 0x0036, 4360},
    {INT64_C(1380575041867642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041867642000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041867642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041867642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041867642000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041873641000), 0x0003, 0x0000, 7552},
    {INT64_C(1380575041873641000), 0x0003, 0x0001, 4280},
    {INT64_C(1380575041873641000), 0x0003, 0x0035, 7552},
    {INT64_C(1380575041873641000), 0x0003, 0x0036, 4280},
    {INT64_C(1380575041873641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041873641000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041873641000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041873641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041873641000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041887645000), 0x0003, 0x0000, 5717},
    {INT64_C(1380575041887645000), 0x0003, 0x0001, 6240},
    {INT64_C(1380575041887645000), 0x0003, 0x0035, 5717},
    {INT64_C(1380575041887645000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575041887645000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041887645000), 0x0003, 0x0030, 256},
    {INT64_C(1380575041887645000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041887645000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041887645000), 0x0003, 0x0035, 6784},
    {INT64_C(1380575041887645000), 0x0003, 0x0036, 5759},
    {INT64_C(1380575041887645000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041887645000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041887645000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041887645000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041887645000), 0x0003, 0x0035, 7552},
    {INT64_C(1380575041887645000), 0x0003, 0x0036, 4198},
    {INT64_C(1380575041887645000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041887645000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041887645000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041887645000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041887645000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041893643000), 0x0003, 0x0000, 5696},
    {INT64_C(1380575041893643000), 0x0003, 0x0035, 5696},
    {INT64_C(1380575041893643000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575041893643000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041893643000), 0x0003, 0x0030, 256},
    {INT64_C(1380575041893643000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041893643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041893643000), 0x0003, 0x0035, 7424},
    {INT64_C(1380575041893643000), 0x0003, 0x0036, 4135},
    {INT64_C(1380575041893643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041893643000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041893643000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041893643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041893643000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041905644000), 0x0003, 0x0000, 5643},
    {INT64_C(1380575041905644000), 0x0003, 0x0001, 6080},
    {INT64_C(1380575041905644000), 0x0003, 0x0035, 5643},
    {INT64_C(1380575041905644000), 0x0003, 0x0036, 6080},
    {INT64_C(1380575041905644000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041905644000), 0x0003, 0x0030, 384},
    {INT64_C(1380575041905644000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041905644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041905644000), 0x0003, 0x0035, 4280},
    {INT64_C(1380575041905644000), 0x0003, 0x0036, 5280},
    {INT64_C(1380575041905644000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041905644000), 0x0003, 0x0030, 256},
    {INT64_C(1380575041905644000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041905644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041905644000), 0x0003, 0x0035, 7300},
    {INT64_C(1380575041905644000), 0x0003, 0x0036, 4074},
    {INT64_C(1380575041905644000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041905644000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041905644000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041905644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041905644000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041911643000), 0x0003, 0x0000, 5572},
    {INT64_C(1380575041911643000), 0x0003, 0x0035, 5572},
    {INT64_C(1380575041911643000), 0x0003, 0x0036, 6080},
    {INT64_C(1380575041911643000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041911643000), 0x0003, 0x0030, 256},
    {INT64_C(1380575041911643000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041911643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041911643000), 0x0003, 0x0035, 6528},
    {INT64_C(1380575041911643000), 0x0003, 0x0036, 5489},
    {INT64_C(1380575041911643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041911643000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041911643000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041911643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041911643000), 0x0003, 0x0035, 4213},
    {INT64_C(1380575041911643000), 0x0003, 0x0036, 5174},
    {INT64_C(1380575041911643000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041911643000), 0x0003, 0x0030, 384},
    {INT64_C(1380575041911643000), 0x0003, 0x0031, 320},
    {INT64_C(1380575041911643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041911643000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041923644000), 0x0003, 0x0000, 5494},
    {INT64_C(1380575041923644000), 0x0003, 0x0001, 5920},
    {INT64_C(1380575041923644000), 0x0003, 0x0035, 5494},
    {INT64_C(1380575041923644000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575041923644000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041923644000), 0x0003, 0x0030, 384},
    {INT64_C(1380575041923644000), 0x0003, 0x0031, 160},
    {INT64_C(1380575041923644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041923644000), 0x0003, 0x0035, 6528},
    {INT64_C(1380575041923644000), 0x0003, 0x0036, 5390},
    {INT64_C(1380575041923644000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041923644000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041923644000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041923644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041923644000), 0x0003, 0x0035, 4169},
    {INT64_C(1380575041923644000), 0x0003, 0x0036, 5050},
    {INT64_C(1380575041923644000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041923644000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041923644000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041923644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041923644000), 0x0003, 0x0035, 7168},
    {INT64_C(1380575041923644000), 0x0003, 0x0036, 4010},
    {INT64_C(1380575041923644000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041923644000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041923644000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041923644000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041923644000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041929638000), 0x0003, 0x0000, 5421},
    {INT64_C(1380575041929638000), 0x0003, 0x0001, 5829},
    {INT64_C(1380575041929638000), 0x0003, 0x0035, 5421},
    {INT64_C(1380575041929638000), 0x0003, 0x0036, 5829},
    {INT64_C(1380575041929638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041929638000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041929638000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041929638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041929638000), 0x0003, 0x0035, 6400},
    {INT64_C(1380575041929638000), 0x0003, 0x0036, 5337},
    {INT64_C(1380575041929638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041929638000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041929638000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041929638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041929638000), 0x0003, 0x0035, 4110},
    {INT64_C(1380575041929638000), 0x0003, 0x0036, 4992},
    {INT64_C(1380575041929638000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041929638000), 0x0003, 0x0030, 384},
    {INT64_C(1380575041929638000), 0x0003, 0x0031, 320},
    {INT64_C(1380575041929638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041929638000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041943643000), 0x0003, 0x0000, 5338},
    {INT64_C(1380575041943643000), 0x0003, 0x0001, 5703},
    {INT64_C(1380575041943643000), 0x0003, 0x0035, 5338},
    {INT64_C(1380575041943643000), 0x0003, 0x0036, 5703},
    {INT64_C(1380575041943643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041943643000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041943643000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041943643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041943643000), 0x0003, 0x0035, 6334},
    {INT64_C(1380575041943643000), 0x0003, 0x0036, 5276},
    {INT64_C(1380575041943643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041943643000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041943643000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041943643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041943643000), 0x0003, 0x0035, 4038},
    {INT64_C(1380575041943643000), 0x0003, 0x0036, 4886},
    {INT64_C(1380575041943643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041943643000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041943643000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041943643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041943643000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041961639000), 0x0003, 0x0000, 5300},
    {INT64_C(1380575041961639000), 0x0003, 0x0001, 5685},
    {INT64_C(1380575041961639000), 0x0003, 0x0035, 5300},
    {INT64_C(1380575041961639000), 0x0003, 0x0036, 5685},
    {INT64_C(1380575041961639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041961639000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041961639000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041961639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041961639000), 0x0003, 0x0035, 6272},
    {INT64_C(1380575041961639000), 0x0003, 0x0036, 5216},
    {INT64_C(1380575041961639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041961639000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041961639000), 0x0003, 0x0031, 128},
    {INT64_C(1380575041961639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041961639000), 0x0003, 0x0035, 3992},
    {INT64_C(1380575041961639000), 0x0003, 0x0036, 4794},
    {INT64_C(1380575041961639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041961639000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041961639000), 0x0003, 0x0031, 384},
    {INT64_C(1380575041961639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041961639000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041979643000), 0x0003, 0x0000, 5196},
    {INT64_C(1380575041979643000), 0x0003, 0x0001, 5551},
    {INT64_C(1380575041979643000), 0x0003, 0x0035, 5196},
    {INT64_C(1380575041979643000), 0x0003, 0x0036, 5551},
    {INT64_C(1380575041979643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041979643000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041979643000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041979643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041979643000), 0x0003, 0x0035, 6160},
    {INT64_C(1380575041979643000), 0x0003, 0x0036, 5160},
    {INT64_C(1380575041979643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041979643000), 0x0003, 0x0030, 640},
    {INT64_C(1380575041979643000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041979643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041979643000), 0x0003, 0x0035, 3884},
    {INT64_C(1380575041979643000), 0x0003, 0x0036, 4681},
    {INT64_C(1380575041979643000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041979643000), 0x0003, 0x0030, 384},
    {INT64_C(1380575041979643000), 0x0003, 0x0031, 320},
    {INT64_C(1380575041979643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041979643000), 0x0000, 0x0000, 0},
    {INT64_C(1380575041999642000), 0x0003, 0x0000, 5092},
    {INT64_C(1380575041999642000), 0x0003, 0x0001, 5509},
    {INT64_C(1380575041999642000), 0x0003, 0x0035, 5092},
    {INT64_C(1380575041999642000), 0x0003, 0x0036, 5509},
    {INT64_C(1380575041999642000), 0x0003, 0x0034, 1},
    {INT64_C(1380575041999642000), 0x0003, 0x0030, 384},
    {INT64_C(1380575041999642000), 0x0003, 0x0031, 320},
    {INT64_C(1380575041999642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041999642000), 0x0003, 0x0035, 6091},
    {INT64_C(1380575041999642000), 0x0003, 0x0036, 5075},
    {INT64_C(1380575041999642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041999642000), 0x0003, 0x0030, 320},
    {INT64_C(1380575041999642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041999642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041999642000), 0x0003, 0x0035, 3783},
    {INT64_C(1380575041999642000), 0x0003, 0x0036, 4511},
    {INT64_C(1380575041999642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575041999642000), 0x0003, 0x0030, 480},
    {INT64_C(1380575041999642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575041999642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575041999642000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042017645000), 0x0003, 0x0000, 5018},
    {INT64_C(1380575042017645000), 0x0003, 0x0001, 5390},
    {INT64_C(1380575042017645000), 0x0003, 0x0035, 5018},
    {INT64_C(1380575042017645000), 0x0003, 0x0036, 5390},
    {INT64_C(1380575042017645000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042017645000), 0x0003, 0x0030, 384},
    {INT64_C(1380575042017645000), 0x0003, 0x0031, 320},
    {INT64_C(1380575042017645000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042017645000), 0x0003, 0x0035, 6016},
    {INT64_C(1380575042017645000), 0x0003, 0x0036, 5035},
    {INT64_C(1380575042017645000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042017645000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042017645000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042017645000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042017645000), 0x0003, 0x0035, 3736},
    {INT64_C(1380575042017645000), 0x0003, 0x0036, 4384},
    {INT64_C(1380575042017645000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042017645000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042017645000), 0x0003, 0x0031, 384},
    {INT64_C(1380575042017645000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042017645000), 0x0003, 0x0035, 6664},
    {INT64_C(1380575042017645000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575042017645000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042017645000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042017645000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042017645000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042017645000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042037640000), 0x0003, 0x0000, 4932},
    {INT64_C(1380575042037640000), 0x0003, 0x0001, 5325},
    {INT64_C(1380575042037640000), 0x0003, 0x0035, 4932},
    {INT64_C(1380575042037640000), 0x0003, 0x0036, 5325},
    {INT64_C(1380575042037640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042037640000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042037640000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042037640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042037640000), 0x0003, 0x0035, 5937},
    {INT64_C(1380575042037640000), 0x0003, 0x0036, 4987},
    {INT64_C(1380575042037640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042037640000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042037640000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042037640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042037640000), 0x0003, 0x0035, 3684},
    {INT64_C(1380575042037640000), 0x0003, 0x0036, 4309},
    {INT64_C(1380575042037640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042037640000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042037640000), 0x0003, 0x0031, 384},
    {INT64_C(1380575042037640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042037640000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042055641000), 0x0003, 0x0000, 4886},
    {INT64_C(1380575042055641000), 0x0003, 0x0001, 5210},
    {INT64_C(1380575042055641000), 0x0003, 0x0035, 4886},
    {INT64_C(1380575042055641000), 0x0003, 0x0036, 5210},
    {INT64_C(1380575042055641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042055641000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042055641000), 0x0003, 0x0031, 384},
    {INT64_C(1380575042055641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042055641000), 0x0003, 0x0035, 5888},
    {INT64_C(1380575042055641000), 0x0003, 0x0036, 4897},
    {INT64_C(1380575042055641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042055641000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042055641000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042055641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042055641000), 0x0003, 0x0035, 3662},
    {INT64_C(1380575042055641000), 0x0003, 0x0036, 4216},
    {INT64_C(1380575042055641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042055641000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042055641000), 0x0003, 0x0031, 384},
    {INT64_C(1380575042055641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042055641000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042073643000), 0x0003, 0x0000, 4829},
    {INT64_C(1380575042073643000), 0x0003, 0x0001, 5185},
    {INT64_C(1380575042073643000), 0x0003, 0x0035, 4829},
    {INT64_C(1380575042073643000), 0x0003, 0x0036, 5185},
    {INT64_C(1380575042073643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042073643000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042073643000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042073643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042073643000), 0x0003, 0x0035, 5806},
    {INT64_C(1380575042073643000), 0x0003, 0x0036, 4846},
    {INT64_C(1380575042073643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042073643000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042073643000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042073643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042073643000), 0x0003, 0x0035, 3636},
    {INT64_C(1380575042073643000), 0x0003, 0x0036, 4106},
    {INT64_C(1380575042073643000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042073643000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042073643000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042073643000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042073643000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042093642000), 0x0003, 0x0000, 4802},
    {INT64_C(1380575042093642000), 0x0003, 0x0001, 5107},
    {INT64_C(1380575042093642000), 0x0003, 0x0035, 4802},
    {INT64_C(1380575042093642000), 0x0003, 0x0036, 5107},
    {INT64_C(1380575042093642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042093642000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042093642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042093642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042093642000), 0x0003, 0x0035, 5785},
    {INT64_C(1380575042093642000), 0x0003, 0x0036, 4804},
    {INT64_C(1380575042093642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042093642000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042093642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042093642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042093642000), 0x0003, 0x0035, 3616},
    {INT64_C(1380575042093642000), 0x0003, 0x0036, 4037},
    {INT64_C(1380575042093642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042093642000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042093642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042093642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042093642000), 0x0003, 0x0035, 6429},
    {INT64_C(1380575042093642000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575042093642000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042093642000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042093642000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042093642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042093642000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042111642000), 0x0003, 0x0000, 4742},
    {INT64_C(1380575042111642000), 0x0003, 0x0001, 5009},
    {INT64_C(1380575042111642000), 0x0003, 0x0035, 4742},
    {INT64_C(1380575042111642000), 0x0003, 0x0036, 5009},
    {INT64_C(1380575042111642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042111642000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042111642000), 0x0003, 0x0031, 384},
    {INT64_C(1380575042111642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042111642000), 0x0003, 0x0035, 5725},
    {INT64_C(1380575042111642000), 0x0003, 0x0036, 4766},
    {INT64_C(1380575042111642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042111642000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042111642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042111642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042111642000), 0x0003, 0x0035, 3582},
    {INT64_C(1380575042111642000), 0x0003, 0x0036, 3881},
    {INT64_C(1380575042111642000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042111642000), 0x0003, 0x0030, 512},
    {INT64_C(1380575042111642000), 0x0003, 0x0031, 480},
    {INT64_C(1380575042111642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042111642000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042129642000), 0x0003, 0x0000, 4696},
    {INT64_C(1380575042129642000), 0x0003, 0x0001, 4940},
    {INT64_C(1380575042129642000), 0x0003, 0x0035, 4696},
    {INT64_C(1380575042129642000), 0x0003, 0x0036, 4940},
    {INT64_C(1380575042129642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042129642000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042129642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042129642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042129642000), 0x0003, 0x0035, 5693},
    {INT64_C(1380575042129642000), 0x0003, 0x0036, 4728},
    {INT64_C(1380575042129642000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042129642000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042129642000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042129642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042129642000), 0x0003, 0x0035, 3548},
    {INT64_C(1380575042129642000), 0x0003, 0x0036, 3777},
    {INT64_C(1380575042129642000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042129642000), 0x0003, 0x0030, 384},
    {INT64_C(1380575042129642000), 0x0003, 0x0031, 320},
    {INT64_C(1380575042129642000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042129642000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042149639000), 0x0003, 0x0000, 4659},
    {INT64_C(1380575042149639000), 0x0003, 0x0001, 4859},
    {INT64_C(1380575042149639000), 0x0003, 0x0035, 4659},
    {INT64_C(1380575042149639000), 0x0003, 0x0036, 4859},
    {INT64_C(1380575042149639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042149639000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042149639000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042149639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042149639000), 0x0003, 0x0035, 5632},
    {INT64_C(1380575042149639000), 0x0003, 0x0036, 4664},
    {INT64_C(1380575042149639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042149639000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042149639000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042149639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042149639000), 0x0003, 0x0035, 3513},
    {INT64_C(1380575042149639000), 0x0003, 0x0036, 3705},
    {INT64_C(1380575042149639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042149639000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042149639000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042149639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042149639000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042167640000), 0x0003, 0x0000, 4563},
    {INT64_C(1380575042167640000), 0x0003, 0x0001, 4754},
    {INT64_C(1380575042167640000), 0x0003, 0x0035, 4563},
    {INT64_C(1380575042167640000), 0x0003, 0x0036, 4754},
    {INT64_C(1380575042167640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042167640000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042167640000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042167640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042167640000), 0x0003, 0x0035, 5553},
    {INT64_C(1380575042167640000), 0x0003, 0x0036, 4597},
    {INT64_C(1380575042167640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042167640000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042167640000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042167640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042167640000), 0x0003, 0x0035, 3496},
    {INT64_C(1380575042167640000), 0x0003, 0x0036, 3539},
    {INT64_C(1380575042167640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042167640000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042167640000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042167640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042167640000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042185641000), 0x0003, 0x0000, 4501},
    {INT64_C(1380575042185641000), 0x0003, 0x0001, 4606},
    {INT64_C(1380575042185641000), 0x0003, 0x0035, 4501},
    {INT64_C(1380575042185641000), 0x0003, 0x0036, 4606},
    {INT64_C(1380575042185641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042185641000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042185641000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042185641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042185641000), 0x0003, 0x0035, 5436},
    {INT64_C(1380575042185641000), 0x0003, 0x0036, 4505},
    {INT64_C(1380575042185641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042185641000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042185641000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042185641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042185641000), 0x0003, 0x0035, 3456},
    {INT64_C(1380575042185641000), 0x0003, 0x0036, 3380},
    {INT64_C(1380575042185641000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042185641000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042185641000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042185641000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042185641000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042205640000), 0x0003, 0x0000, 4381},
    {INT64_C(1380575042205640000), 0x0003, 0x0001, 4473},
    {INT64_C(1380575042205640000), 0x0003, 0x0035, 4381},
    {INT64_C(1380575042205640000), 0x0003, 0x0036, 4473},
    {INT64_C(1380575042205640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042205640000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042205640000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042205640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042205640000), 0x0003, 0x0035, 5376},
    {INT64_C(1380575042205640000), 0x0003, 0x0036, 4372},
    {INT64_C(1380575042205640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042205640000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042205640000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042205640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042205640000), 0x0003, 0x0035, 3353},
    {INT64_C(1380575042205640000), 0x0003, 0x0036, 3218},
    {INT64_C(1380575042205640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042205640000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042205640000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042205640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042205640000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042223640000), 0x0003, 0x0000, 4255},
    {INT64_C(1380575042223640000), 0x0003, 0x0001, 4312},
    {INT64_C(1380575042223640000), 0x0003, 0x0035, 4255},
    {INT64_C(1380575042223640000), 0x0003, 0x0036, 4312},
    {INT64_C(1380575042223640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042223640000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042223640000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042223640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042223640000), 0x0003, 0x0035, 5248},
    {INT64_C(1380575042223640000), 0x0003, 0x0036, 4160},
    {INT64_C(1380575042223640000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042223640000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042223640000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042223640000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042223640000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042241636000), 0x0003, 0x0000, 4071},
    {INT64_C(1380575042241636000), 0x0003, 0x0001, 4135},
    {INT64_C(1380575042241636000), 0x0003, 0x0035, 4071},
    {INT64_C(1380575042241636000), 0x0003, 0x0036, 4135},
    {INT64_C(1380575042241636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042241636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042241636000), 0x0003, 0x0031, 384},
    {INT64_C(1380575042241636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042241636000), 0x0003, 0x0035, 5047},
    {INT64_C(1380575042241636000), 0x0003, 0x0036, 4059},
    {INT64_C(1380575042241636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042241636000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042241636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042241636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042241636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042261636000), 0x0003, 0x0000, 3911},
    {INT64_C(1380575042261636000), 0x0003, 0x0001, 4011},
    {INT64_C(1380575042261636000), 0x0003, 0x0035, 3911},
    {INT64_C(1380575042261636000), 0x0003, 0x0036, 4011},
    {INT64_C(1380575042261636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042261636000), 0x0003, 0x0030, 512},
    {INT64_C(1380575042261636000), 0x0003, 0x0031, 320},
    {INT64_C(1380575042261636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042261636000), 0x0003, 0x0035, 4906},
    {INT64_C(1380575042261636000), 0x0003, 0x0036, 4000},
    {INT64_C(1380575042261636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042261636000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042261636000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042261636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042261636000), 0x0003, 0x0035, 3079},
    {INT64_C(1380575042261636000), 0x0003, 0x0036, 2720},
    {INT64_C(1380575042261636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042261636000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042261636000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042261636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042261636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042279638000), 0x0003, 0x0000, 3712},
    {INT64_C(1380575042279638000), 0x0003, 0x0001, 3791},
    {INT64_C(1380575042279638000), 0x0003, 0x0035, 3712},
    {INT64_C(1380575042279638000), 0x0003, 0x0036, 3791},
    {INT64_C(1380575042279638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042279638000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042279638000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042279638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042279638000), 0x0003, 0x0035, 4758},
    {INT64_C(1380575042279638000), 0x0003, 0x0036, 3739},
    {INT64_C(1380575042279638000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042279638000), 0x0003, 0x0030, 384},
    {INT64_C(1380575042279638000), 0x0003, 0x0031, 320},
    {INT64_C(1380575042279638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042279638000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042297639000), 0x0003, 0x0000, 4485},
    {INT64_C(1380575042297639000), 0x0003, 0x0001, 3680},
    {INT64_C(1380575042297639000), 0x0003, 0x0035, 4485},
    {INT64_C(1380575042297639000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575042297639000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042297639000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042297639000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042297639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042297639000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042391637000), 0x0001, 0x014d, 0},
    {INT64_C(1380575042391637000), 0x0001, 0x014a, 0},
    {INT64_C(1380575042391637000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042753637000), 0x0003, 0x0000, 3650},
    {INT64_C(1380575042753637000), 0x0003, 0x0001, 5703},
    {INT64_C(1380575042753637000), 0x0003, 0x0035, 3650},
    {INT64_C(1380575042753637000), 0x0003, 0x0036, 5703},
    {INT64_C(1380575042753637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042753637000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042753637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042753637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042753637000), 0x0003, 0x0035, 1855},
    {INT64_C(1380575042753637000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575042753637000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042753637000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042753637000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042753637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042753637000), 0x0001, 0x014d, 1},
    {INT64_C(1380575042753637000), 0x0001, 0x014a, 1},
    {INT64_C(1380575042753637000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042765637000), 0x0003, 0x0000, 3658},
    {INT64_C(1380575042765637000), 0x0003, 0x0001, 5679},
    {INT64_C(1380575042765637000), 0x0003, 0x0035, 3658},
    {INT64_C(1380575042765637000), 0x0003, 0x0036, 5679},
    {INT64_C(1380575042765637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042765637000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042765637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042765637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042765637000), 0x0003, 0x0035, 1856},
    {INT64_C(1380575042765637000), 0x0003, 0x0036, 1859},
    {INT64_C(1380575042765637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042765637000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042765637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042765637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042765637000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042771635000), 0x0003, 0x0000, 3674},
    {INT64_C(1380575042771635000), 0x0003, 0x0001, 5656},
    {INT64_C(1380575042771635000), 0x0003, 0x0035, 3674},
    {INT64_C(1380575042771635000), 0x0003, 0x0036, 5656},
    {INT64_C(1380575042771635000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042771635000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042771635000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042771635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042771635000), 0x0003, 0x0035, 1856},
    {INT64_C(1380575042771635000), 0x0003, 0x0036, 1866},
    {INT64_C(1380575042771635000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042771635000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042771635000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042771635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042771635000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042785636000), 0x0003, 0x0000, 3713},
    {INT64_C(1380575042785636000), 0x0003, 0x0001, 5544},
    {INT64_C(1380575042785636000), 0x0003, 0x0035, 3713},
    {INT64_C(1380575042785636000), 0x0003, 0x0036, 5544},
    {INT64_C(1380575042785636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042785636000), 0x0003, 0x0030, 384},
    {INT64_C(1380575042785636000), 0x0003, 0x0031, 320},
    {INT64_C(1380575042785636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042785636000), 0x0003, 0x0035, 1851},
    {INT64_C(1380575042785636000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575042785636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042785636000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042785636000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042785636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042785636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042791639000), 0x0003, 0x0000, 1453},
    {INT64_C(1380575042791639000), 0x0003, 0x0001, 5920},
    {INT64_C(1380575042791639000), 0x0003, 0x0035, 1453},
    {INT64_C(1380575042791639000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575042791639000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042791639000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042791639000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042791639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042791639000), 0x0003, 0x0035, 3753},
    {INT64_C(1380575042791639000), 0x0003, 0x0036, 5505},
    {INT64_C(1380575042791639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042791639000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042791639000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042791639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042791639000), 0x0003, 0x0035, 1870},
    {INT64_C(1380575042791639000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575042791639000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042791639000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042791639000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042791639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042791639000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042803636000), 0x0003, 0x0000, 1491},
    {INT64_C(1380575042803636000), 0x0003, 0x0001, 5760},
    {INT64_C(1380575042803636000), 0x0003, 0x0035, 1491},
    {INT64_C(1380575042803636000), 0x0003, 0x0036, 5760},
    {INT64_C(1380575042803636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042803636000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042803636000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042803636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042803636000), 0x0003, 0x0035, 3777},
    {INT64_C(1380575042803636000), 0x0003, 0x0036, 5458},
    {INT64_C(1380575042803636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042803636000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042803636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042803636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042803636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042809639000), 0x0003, 0x0000, 1535},
    {INT64_C(1380575042809639000), 0x0003, 0x0001, 5692},
    {INT64_C(1380575042809639000), 0x0003, 0x0035, 1535},
    {INT64_C(1380575042809639000), 0x0003, 0x0036, 5692},
    {INT64_C(1380575042809639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042809639000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042809639000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042809639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042809639000), 0x0003, 0x0035, 3851},
    {INT64_C(1380575042809639000), 0x0003, 0x0036, 5345},
    {INT64_C(1380575042809639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042809639000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042809639000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042809639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042809639000), 0x0003, 0x0035, 1280},
    {INT64_C(1380575042809639000), 0x0003, 0x0036, 4393},
    {INT64_C(1380575042809639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042809639000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042809639000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042809639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042809639000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042823638000), 0x0003, 0x0000, 1617},
    {INT64_C(1380575042823638000), 0x0003, 0x0001, 5578},
    {INT64_C(1380575042823638000), 0x0003, 0x0035, 1617},
    {INT64_C(1380575042823638000), 0x0003, 0x0036, 5578},
    {INT64_C(1380575042823638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042823638000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042823638000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042823638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042823638000), 0x0003, 0x0035, 3885},
    {INT64_C(1380575042823638000), 0x0003, 0x0036, 5236},
    {INT64_C(1380575042823638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042823638000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042823638000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042823638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042823638000), 0x0003, 0x0035, 1347},
    {INT64_C(1380575042823638000), 0x0003, 0x0036, 4280},
    {INT64_C(1380575042823638000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042823638000), 0x0003, 0x0030, 384},
    {INT64_C(1380575042823638000), 0x0003, 0x0031, 320},
    {INT64_C(1380575042823638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042823638000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042829637000), 0x0003, 0x0000, 1662},
    {INT64_C(1380575042829637000), 0x0003, 0x0001, 5510},
    {INT64_C(1380575042829637000), 0x0003, 0x0035, 1662},
    {INT64_C(1380575042829637000), 0x0003, 0x0036, 5510},
    {INT64_C(1380575042829637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042829637000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042829637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042829637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042829637000), 0x0003, 0x0035, 3940},
    {INT64_C(1380575042829637000), 0x0003, 0x0036, 5155},
    {INT64_C(1380575042829637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042829637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042829637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042829637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042829637000), 0x0003, 0x0035, 1444},
    {INT64_C(1380575042829637000), 0x0003, 0x0036, 4147},
    {INT64_C(1380575042829637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042829637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042829637000), 0x0003, 0x0031, 384},
    {INT64_C(1380575042829637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042829637000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042841637000), 0x0003, 0x0000, 1731},
    {INT64_C(1380575042841637000), 0x0003, 0x0001, 5377},
    {INT64_C(1380575042841637000), 0x0003, 0x0035, 1731},
    {INT64_C(1380575042841637000), 0x0003, 0x0036, 5377},
    {INT64_C(1380575042841637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042841637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042841637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042841637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042841637000), 0x0003, 0x0035, 4000},
    {INT64_C(1380575042841637000), 0x0003, 0x0036, 5047},
    {INT64_C(1380575042841637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042841637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042841637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042841637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042841637000), 0x0003, 0x0035, 1408},
    {INT64_C(1380575042841637000), 0x0003, 0x0036, 4064},
    {INT64_C(1380575042841637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042841637000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042841637000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042841637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042841637000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042859636000), 0x0003, 0x0000, 1783},
    {INT64_C(1380575042859636000), 0x0003, 0x0001, 5269},
    {INT64_C(1380575042859636000), 0x0003, 0x0035, 1783},
    {INT64_C(1380575042859636000), 0x0003, 0x0036, 5269},
    {INT64_C(1380575042859636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042859636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042859636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042859636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042859636000), 0x0003, 0x0035, 4007},
    {INT64_C(1380575042859636000), 0x0003, 0x0036, 5002},
    {INT64_C(1380575042859636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042859636000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042859636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042859636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042859636000), 0x0003, 0x0035, 1588},
    {INT64_C(1380575042859636000), 0x0003, 0x0036, 4000},
    {INT64_C(1380575042859636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042859636000), 0x0003, 0x0030, 384},
    {INT64_C(1380575042859636000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042859636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042859636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042879636000), 0x0003, 0x0000, 1846},
    {INT64_C(1380575042879636000), 0x0003, 0x0001, 5204},
    {INT64_C(1380575042879636000), 0x0003, 0x0035, 1846},
    {INT64_C(1380575042879636000), 0x0003, 0x0036, 5204},
    {INT64_C(1380575042879636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042879636000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042879636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042879636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042879636000), 0x0003, 0x0035, 4038},
    {INT64_C(1380575042879636000), 0x0003, 0x0036, 4959},
    {INT64_C(1380575042879636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042879636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042879636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042879636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042879636000), 0x0003, 0x0035, 1691},
    {INT64_C(1380575042879636000), 0x0003, 0x0036, 4000},
    {INT64_C(1380575042879636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042879636000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042879636000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042879636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042879636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042897636000), 0x0003, 0x0000, 1884},
    {INT64_C(1380575042897636000), 0x0003, 0x0001, 5149},
    {INT64_C(1380575042897636000), 0x0003, 0x0035, 1884},
    {INT64_C(1380575042897636000), 0x0003, 0x0036, 5149},
    {INT64_C(1380575042897636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042897636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042897636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042897636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042897636000), 0x0003, 0x0035, 4062},
    {INT64_C(1380575042897636000), 0x0003, 0x0036, 4930},
    {INT64_C(1380575042897636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042897636000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042897636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042897636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042897636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042915637000), 0x0003, 0x0000, 2907},
    {INT64_C(1380575042915637000), 0x0003, 0x0001, 5760},
    {INT64_C(1380575042915637000), 0x0003, 0x0035, 2907},
    {INT64_C(1380575042915637000), 0x0003, 0x0036, 5760},
    {INT64_C(1380575042915637000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042915637000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042915637000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042915637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042915637000), 0x0003, 0x0035, 1910},
    {INT64_C(1380575042915637000), 0x0003, 0x0036, 5018},
    {INT64_C(1380575042915637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042915637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042915637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042915637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042915637000), 0x0003, 0x0035, 4090},
    {INT64_C(1380575042915637000), 0x0003, 0x0036, 4879},
    {INT64_C(1380575042915637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042915637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042915637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042915637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042915637000), 0x0003, 0x0035, 1840},
    {INT64_C(1380575042915637000), 0x0003, 0x0036, 3840},
    {INT64_C(1380575042915637000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042915637000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042915637000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042915637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042915637000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042935638000), 0x0003, 0x0000, 2944},
    {INT64_C(1380575042935638000), 0x0003, 0x0001, 5570},
    {INT64_C(1380575042935638000), 0x0003, 0x0035, 2944},
    {INT64_C(1380575042935638000), 0x0003, 0x0036, 5570},
    {INT64_C(1380575042935638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042935638000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042935638000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042935638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042935638000), 0x0003, 0x0035, 2014},
    {INT64_C(1380575042935638000), 0x0003, 0x0036, 4911},
    {INT64_C(1380575042935638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042935638000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042935638000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042935638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042935638000), 0x0003, 0x0035, 4143},
    {INT64_C(1380575042935638000), 0x0003, 0x0036, 4810},
    {INT64_C(1380575042935638000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042935638000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042935638000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042935638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042935638000), 0x0003, 0x0035, 1892},
    {INT64_C(1380575042935638000), 0x0003, 0x0036, 3840},
    {INT64_C(1380575042935638000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042935638000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042935638000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042935638000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042935638000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042953635000), 0x0003, 0x0000, 2981},
    {INT64_C(1380575042953635000), 0x0003, 0x0001, 5475},
    {INT64_C(1380575042953635000), 0x0003, 0x0035, 2981},
    {INT64_C(1380575042953635000), 0x0003, 0x0036, 5475},
    {INT64_C(1380575042953635000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042953635000), 0x0003, 0x0030, 320},
    {INT64_C(1380575042953635000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042953635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042953635000), 0x0003, 0x0035, 2048},
    {INT64_C(1380575042953635000), 0x0003, 0x0036, 4809},
    {INT64_C(1380575042953635000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042953635000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042953635000), 0x0003, 0x0031, 128},
    {INT64_C(1380575042953635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042953635000), 0x0003, 0x0035, 4173},
    {INT64_C(1380575042953635000), 0x0003, 0x0036, 4725},
    {INT64_C(1380575042953635000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042953635000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042953635000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042953635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042953635000), 0x0003, 0x0035, 1968},
    {INT64_C(1380575042953635000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575042953635000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042953635000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042953635000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042953635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042953635000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042971635000), 0x0003, 0x0000, 2146},
    {INT64_C(1380575042971635000), 0x0003, 0x0001, 4733},
    {INT64_C(1380575042971635000), 0x0003, 0x0035, 2146},
    {INT64_C(1380575042971635000), 0x0003, 0x0036, 4733},
    {INT64_C(1380575042971635000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042971635000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042971635000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042971635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042971635000), 0x0003, 0x0035, 4205},
    {INT64_C(1380575042971635000), 0x0003, 0x0036, 4694},
    {INT64_C(1380575042971635000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042971635000), 0x0003, 0x0030, 480},
    {INT64_C(1380575042971635000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042971635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042971635000), 0x0003, 0x0035, 2027},
    {INT64_C(1380575042971635000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575042971635000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042971635000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042971635000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042971635000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042971635000), 0x0000, 0x0000, 0},
    {INT64_C(1380575042991634000), 0x0003, 0x0000, 2150},
    {INT64_C(1380575042991634000), 0x0003, 0x0001, 4596},
    {INT64_C(1380575042991634000), 0x0003, 0x0035, 2150},
    {INT64_C(1380575042991634000), 0x0003, 0x0036, 4596},
    {INT64_C(1380575042991634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042991634000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042991634000), 0x0003, 0x0031, 256},
    {INT64_C(1380575042991634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042991634000), 0x0003, 0x0035, 4267},
    {INT64_C(1380575042991634000), 0x0003, 0x0036, 4563},
    {INT64_C(1380575042991634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575042991634000), 0x0003, 0x0030, 640},
    {INT64_C(1380575042991634000), 0x0003, 0x0031, 384},
    {INT64_C(1380575042991634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042991634000), 0x0003, 0x0035, 2073},
    {INT64_C(1380575042991634000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575042991634000), 0x0003, 0x0034, 1},
    {INT64_C(1380575042991634000), 0x0003, 0x0030, 256},
    {INT64_C(1380575042991634000), 0x0003, 0x0031, 160},
    {INT64_C(1380575042991634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575042991634000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043009639000), 0x0003, 0x0000, 3137},
    {INT64_C(1380575043009639000), 0x0003, 0x0001, 5224},
    {INT64_C(1380575043009639000), 0x0003, 0x0035, 3137},
    {INT64_C(1380575043009639000), 0x0003, 0x0036, 5224},
    {INT64_C(1380575043009639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043009639000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043009639000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043009639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043009639000), 0x0003, 0x0035, 2248},
    {INT64_C(1380575043009639000), 0x0003, 0x0036, 4524},
    {INT64_C(1380575043009639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043009639000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043009639000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043009639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043009639000), 0x0003, 0x0035, 4284},
    {INT64_C(1380575043009639000), 0x0003, 0x0036, 4435},
    {INT64_C(1380575043009639000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043009639000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043009639000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043009639000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043009639000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043029636000), 0x0003, 0x0000, 3187},
    {INT64_C(1380575043029636000), 0x0003, 0x0001, 5136},
    {INT64_C(1380575043029636000), 0x0003, 0x0035, 3187},
    {INT64_C(1380575043029636000), 0x0003, 0x0036, 5136},
    {INT64_C(1380575043029636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043029636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043029636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043029636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043029636000), 0x0003, 0x0035, 2287},
    {INT64_C(1380575043029636000), 0x0003, 0x0036, 4463},
    {INT64_C(1380575043029636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043029636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043029636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043029636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043029636000), 0x0003, 0x0035, 4309},
    {INT64_C(1380575043029636000), 0x0003, 0x0036, 4333},
    {INT64_C(1380575043029636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043029636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043029636000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043029636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043029636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043047630000), 0x0003, 0x0000, 3231},
    {INT64_C(1380575043047630000), 0x0003, 0x0001, 5041},
    {INT64_C(1380575043047630000), 0x0003, 0x0035, 3231},
    {INT64_C(1380575043047630000), 0x0003, 0x0036, 5041},
    {INT64_C(1380575043047630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043047630000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043047630000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043047630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043047630000), 0x0003, 0x0035, 2345},
    {INT64_C(1380575043047630000), 0x0003, 0x0036, 4386},
    {INT64_C(1380575043047630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043047630000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043047630000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043047630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043047630000), 0x0003, 0x0035, 4331},
    {INT64_C(1380575043047630000), 0x0003, 0x0036, 4245},
    {INT64_C(1380575043047630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043047630000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043047630000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043047630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043047630000), 0x0003, 0x0035, 2219},
    {INT64_C(1380575043047630000), 0x0003, 0x0036, 3520},
    {INT64_C(1380575043047630000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043047630000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043047630000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043047630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043047630000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043065636000), 0x0003, 0x0000, 3272},
    {INT64_C(1380575043065636000), 0x0003, 0x0001, 4947},
    {INT64_C(1380575043065636000), 0x0003, 0x0035, 3272},
    {INT64_C(1380575043065636000), 0x0003, 0x0036, 4947},
    {INT64_C(1380575043065636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043065636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043065636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043065636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043065636000), 0x0003, 0x0035, 2374},
    {INT64_C(1380575043065636000), 0x0003, 0x0036, 4308},
    {INT64_C(1380575043065636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043065636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043065636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043065636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043065636000), 0x0003, 0x0035, 4369},
    {INT64_C(1380575043065636000), 0x0003, 0x0036, 4157},
    {INT64_C(1380575043065636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043065636000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043065636000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043065636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043065636000), 0x0003, 0x0035, 2240},
    {INT64_C(1380575043065636000), 0x0003, 0x0036, 3360},
    {INT64_C(1380575043065636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043065636000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043065636000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043065636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043065636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043085637000), 0x0003, 0x0000, 3297},
    {INT64_C(1380575043085637000), 0x0003, 0x0001, 4881},
    {INT64_C(1380575043085637000), 0x0003, 0x0035, 3297},
    {INT64_C(1380575043085637000), 0x0003, 0x0036, 4881},
    {INT64_C(1380575043085637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043085637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043085637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043085637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043085637000), 0x0003, 0x0035, 2402},
    {INT64_C(1380575043085637000), 0x0003, 0x0036, 4265},
    {INT64_C(1380575043085637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043085637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043085637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043085637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043085637000), 0x0003, 0x0035, 4392},
    {INT64_C(1380575043085637000), 0x0003, 0x0036, 4052},
    {INT64_C(1380575043085637000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043085637000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043085637000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043085637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043085637000), 0x0003, 0x0035, 2292},
    {INT64_C(1380575043085637000), 0x0003, 0x0036, 3360},
    {INT64_C(1380575043085637000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043085637000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043085637000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043085637000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043085637000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043103636000), 0x0003, 0x0000, 3346},
    {INT64_C(1380575043103636000), 0x0003, 0x0001, 4801},
    {INT64_C(1380575043103636000), 0x0003, 0x0035, 3346},
    {INT64_C(1380575043103636000), 0x0003, 0x0036, 4801},
    {INT64_C(1380575043103636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043103636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043103636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043103636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043103636000), 0x0003, 0x0035, 2490},
    {INT64_C(1380575043103636000), 0x0003, 0x0036, 4193},
    {INT64_C(1380575043103636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043103636000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043103636000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043103636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043103636000), 0x0003, 0x0035, 4416},
    {INT64_C(1380575043103636000), 0x0003, 0x0036, 4010},
    {INT64_C(1380575043103636000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043103636000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043103636000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043103636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043103636000), 0x0003, 0x0035, 2347},
    {INT64_C(1380575043103636000), 0x0003, 0x0036, 3360},
    {INT64_C(1380575043103636000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043103636000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043103636000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043103636000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043103636000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043121634000), 0x0003, 0x0000, 3388},
    {INT64_C(1380575043121634000), 0x0003, 0x0001, 4723},
    {INT64_C(1380575043121634000), 0x0003, 0x0035, 3388},
    {INT64_C(1380575043121634000), 0x0003, 0x0036, 4723},
    {INT64_C(1380575043121634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043121634000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043121634000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043121634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043121634000), 0x0003, 0x0035, 2540},
    {INT64_C(1380575043121634000), 0x0003, 0x0036, 4129},
    {INT64_C(1380575043121634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043121634000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043121634000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043121634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043121634000), 0x0003, 0x0035, 4454},
    {INT64_C(1380575043121634000), 0x0003, 0x0036, 3845},
    {INT64_C(1380575043121634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043121634000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043121634000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043121634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043121634000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043141631000), 0x0003, 0x0000, 3433},
    {INT64_C(1380575043141631000), 0x0003, 0x0001, 4600},
    {INT64_C(1380575043141631000), 0x0003, 0x0035, 3433},
    {INT64_C(1380575043141631000), 0x0003, 0x0036, 4600},
    {INT64_C(1380575043141631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043141631000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043141631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043141631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043141631000), 0x0003, 0x0035, 2624},
    {INT64_C(1380575043141631000), 0x0003, 0x0036, 4021},
    {INT64_C(1380575043141631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043141631000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043141631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043141631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043141631000), 0x0003, 0x0035, 4504},
    {INT64_C(1380575043141631000), 0x0003, 0x0036, 3690},
    {INT64_C(1380575043141631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043141631000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043141631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043141631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043141631000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043159633000), 0x0003, 0x0000, 3533},
    {INT64_C(1380575043159633000), 0x0003, 0x0001, 4438},
    {INT64_C(1380575043159633000), 0x0003, 0x0035, 3533},
    {INT64_C(1380575043159633000), 0x0003, 0x0036, 4438},
    {INT64_C(1380575043159633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043159633000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043159633000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043159633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043159633000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043177630000), 0x0003, 0x0000, 3653},
    {INT64_C(1380575043177630000), 0x0003, 0x0001, 4244},
    {INT64_C(1380575043177630000), 0x0003, 0x0035, 3653},
    {INT64_C(1380575043177630000), 0x0003, 0x0036, 4244},
    {INT64_C(1380575043177630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043177630000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043177630000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043177630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043177630000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043197633000), 0x0003, 0x0000, 3930},
    {INT64_C(1380575043197633000), 0x0003, 0x0001, 4000},
    {INT64_C(1380575043197633000), 0x0003, 0x0035, 3930},
    {INT64_C(1380575043197633000), 0x0003, 0x0036, 4000},
    {INT64_C(1380575043197633000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043197633000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043197633000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043197633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043197633000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043289630000), 0x0001, 0x014d, 0},
    {INT64_C(1380575043289630000), 0x0001, 0x014a, 0},
    {INT64_C(1380575043289630000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043559632000), 0x0003, 0x0000, 8902},
    {INT64_C(1380575043559632000), 0x0003, 0x0001, 4605},
    {INT64_C(1380575043559632000), 0x0003, 0x0035, 8902},
    {INT64_C(1380575043559632000), 0x0003, 0x0036, 4605},
    {INT64_C(1380575043559632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043559632000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043559632000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043559632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043559632000), 0x0001, 0x014d, 1},
    {INT64_C(1380575043559632000), 0x0001, 0x014a, 1},
    {INT64_C(1380575043559632000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043571631000), 0x0003, 0x0000, 7095},
    {INT64_C(1380575043571631000), 0x0003, 0x0001, 6720},
    {INT64_C(1380575043571631000), 0x0003, 0x0035, 7095},
    {INT64_C(1380575043571631000), 0x0003, 0x0036, 6720},
    {INT64_C(1380575043571631000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043571631000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043571631000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043571631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043571631000), 0x0003, 0x0035, 8258},
    {INT64_C(1380575043571631000), 0x0003, 0x0036, 6080},
    {INT64_C(1380575043571631000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043571631000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043571631000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043571631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043571631000), 0x0003, 0x0035, 8832},
    {INT64_C(1380575043571631000), 0x0003, 0x0036, 4541},
    {INT64_C(1380575043571631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043571631000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043571631000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043571631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043571631000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043577630000), 0x0003, 0x0000, 7040},
    {INT64_C(1380575043577630000), 0x0003, 0x0035, 7040},
    {INT64_C(1380575043577630000), 0x0003, 0x0036, 6720},
    {INT64_C(1380575043577630000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043577630000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043577630000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043577630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043577630000), 0x0003, 0x0035, 5275},
    {INT64_C(1380575043577630000), 0x0003, 0x0036, 5711},
    {INT64_C(1380575043577630000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043577630000), 0x0003, 0x0030, 512},
    {INT64_C(1380575043577630000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043577630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043577630000), 0x0003, 0x0035, 8192},
    {INT64_C(1380575043577630000), 0x0003, 0x0036, 5709},
    {INT64_C(1380575043577630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043577630000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043577630000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043577630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043577630000), 0x0003, 0x0035, 8832},
    {INT64_C(1380575043577630000), 0x0003, 0x0036, 4486},
    {INT64_C(1380575043577630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043577630000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043577630000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043577630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043577630000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043589615000), 0x0003, 0x0000, 7035},
    {INT64_C(1380575043589615000), 0x0003, 0x0035, 7035},
    {INT64_C(1380575043589615000), 0x0003, 0x0036, 6720},
    {INT64_C(1380575043589615000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043589615000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043589615000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043589615000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043589615000), 0x0003, 0x0035, 5235},
    {INT64_C(1380575043589615000), 0x0003, 0x0036, 5716},
    {INT64_C(1380575043589615000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043589615000), 0x0003, 0x0030, 512},
    {INT64_C(1380575043589615000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043589615000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043589615000), 0x0003, 0x0035, 8192},
    {INT64_C(1380575043589615000), 0x0003, 0x0036, 5729},
    {INT64_C(1380575043589615000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043589615000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043589615000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043589615000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043589615000), 0x0003, 0x0035, 8758},
    {INT64_C(1380575043589615000), 0x0003, 0x0036, 4411},
    {INT64_C(1380575043589615000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043589615000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043589615000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043589615000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043589615000), 0x0003, 0x0035, 5057},
    {INT64_C(1380575043589615000), 0x0003, 0x0036, 800},
    {INT64_C(1380575043589615000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043589615000), 0x0003, 0x0030, 512},
    {INT64_C(1380575043589615000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043589615000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043589615000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043595634000), 0x0003, 0x0000, 7028},
    {INT64_C(1380575043595634000), 0x0003, 0x0035, 7028},
    {INT64_C(1380575043595634000), 0x0003, 0x0036, 6720},
    {INT64_C(1380575043595634000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043595634000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043595634000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043595634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043595634000), 0x0003, 0x0035, 5216},
    {INT64_C(1380575043595634000), 0x0003, 0x0036, 5710},
    {INT64_C(1380575043595634000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043595634000), 0x0003, 0x0030, 512},
    {INT64_C(1380575043595634000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043595634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043595634000), 0x0003, 0x0035, 8192},
    {INT64_C(1380575043595634000), 0x0003, 0x0036, 5707},
    {INT64_C(1380575043595634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043595634000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043595634000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043595634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043595634000), 0x0003, 0x0035, 8752},
    {INT64_C(1380575043595634000), 0x0003, 0x0036, 4395},
    {INT64_C(1380575043595634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043595634000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043595634000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043595634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043595634000), 0x0003, 0x0035, 5031},
    {INT64_C(1380575043595634000), 0x0003, 0x0036, 800},
    {INT64_C(1380575043595634000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043595634000), 0x0003, 0x0030, 512},
    {INT64_C(1380575043595634000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043595634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043595634000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043609633000), 0x0003, 0x0000, 7015},
    {INT64_C(1380575043609633000), 0x0003, 0x0035, 7015},
    {INT64_C(1380575043609633000), 0x0003, 0x0036, 6720},
    {INT64_C(1380575043609633000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043609633000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043609633000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043609633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043609633000), 0x0003, 0x0035, 5211},
    {INT64_C(1380575043609633000), 0x0003, 0x0036, 5737},
    {INT64_C(1380575043609633000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043609633000), 0x0003, 0x0030, 512},
    {INT64_C(1380575043609633000), 0x0003, 0x0031, 480},
    {INT64_C(1380575043609633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043609633000), 0x0003, 0x0035, 8192},
    {INT64_C(1380575043609633000), 0x0003, 0x0036, 5861},
    {INT64_C(1380575043609633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043609633000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043609633000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043609633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043609633000), 0x0003, 0x0035, 8747},
    {INT64_C(1380575043609633000), 0x0003, 0x0036, 4382},
    {INT64_C(1380575043609633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043609633000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043609633000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043609633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043609633000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043615633000), 0x0003, 0x0000, 7023},
    {INT64_C(1380575043615633000), 0x0003, 0x0035, 7023},
    {INT64_C(1380575043615633000), 0x0003, 0x0036, 6720},
    {INT64_C(1380575043615633000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043615633000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043615633000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043615633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043615633000), 0x0003, 0x0035, 5212},
    {INT64_C(1380575043615633000), 0x0003, 0x0036, 5730},
    {INT64_C(1380575043615633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043615633000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043615633000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043615633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043615633000), 0x0003, 0x0035, 8192},
    {INT64_C(1380575043615633000), 0x0003, 0x0036, 5867},
    {INT64_C(1380575043615633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043615633000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043615633000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043615633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043615633000), 0x0003, 0x0035, 8739},
    {INT64_C(1380575043615633000), 0x0003, 0x0036, 4337},
    {INT64_C(1380575043615633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043615633000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043615633000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043615633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043615633000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043627633000), 0x0003, 0x0000, 6979},
    {INT64_C(1380575043627633000), 0x0003, 0x0035, 6979},
    {INT64_C(1380575043627633000), 0x0003, 0x0036, 6720},
    {INT64_C(1380575043627633000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043627633000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043627633000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043627633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043627633000), 0x0003, 0x0035, 8192},
    {INT64_C(1380575043627633000), 0x0003, 0x0036, 5866},
    {INT64_C(1380575043627633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043627633000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043627633000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043627633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043627633000), 0x0003, 0x0035, 5206},
    {INT64_C(1380575043627633000), 0x0003, 0x0036, 5691},
    {INT64_C(1380575043627633000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043627633000), 0x0003, 0x0030, 512},
    {INT64_C(1380575043627633000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043627633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043627633000), 0x0003, 0x0035, 8733},
    {INT64_C(1380575043627633000), 0x0003, 0x0036, 4322},
    {INT64_C(1380575043627633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043627633000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043627633000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043627633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043627633000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043633632000), 0x0003, 0x0000, 6961},
    {INT64_C(1380575043633632000), 0x0003, 0x0035, 6961},
    {INT64_C(1380575043633632000), 0x0003, 0x0036, 6720},
    {INT64_C(1380575043633632000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043633632000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043633632000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043633632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043633632000), 0x0003, 0x0035, 8135},
    {INT64_C(1380575043633632000), 0x0003, 0x0036, 5860},
    {INT64_C(1380575043633632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043633632000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043633632000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043633632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043633632000), 0x0003, 0x0035, 5188},
    {INT64_C(1380575043633632000), 0x0003, 0x0036, 5651},
    {INT64_C(1380575043633632000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043633632000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043633632000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043633632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043633632000), 0x0003, 0x0035, 8704},
    {INT64_C(1380575043633632000), 0x0003, 0x0036, 4288},
    {INT64_C(1380575043633632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043633632000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043633632000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043633632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043633632000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043645634000), 0x0003, 0x0000, 6865},
    {INT64_C(1380575043645634000), 0x0003, 0x0001, 6560},
    {INT64_C(1380575043645634000), 0x0003, 0x0035, 6865},
    {INT64_C(1380575043645634000), 0x0003, 0x0036, 6560},
    {INT64_C(1380575043645634000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043645634000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043645634000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043645634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043645634000), 0x0003, 0x0035, 6895},
    {INT64_C(1380575043645634000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575043645634000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043645634000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043645634000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043645634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043645634000), 0x0003, 0x0035, 8125},
    {INT64_C(1380575043645634000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575043645634000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043645634000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043645634000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043645634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043645634000), 0x0003, 0x0035, 5181},
    {INT64_C(1380575043645634000), 0x0003, 0x0036, 5540},
    {INT64_C(1380575043645634000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043645634000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043645634000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043645634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043645634000), 0x0003, 0x0035, 8099},
    {INT64_C(1380575043645634000), 0x0003, 0x0036, 5564},
    {INT64_C(1380575043645634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043645634000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043645634000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043645634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043645634000), 0x0003, 0x0035, 8704},
    {INT64_C(1380575043645634000), 0x0003, 0x0036, 4222},
    {INT64_C(1380575043645634000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043645634000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043645634000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043645634000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043645634000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043665631000), 0x0003, 0x0000, 6851},
    {INT64_C(1380575043665631000), 0x0003, 0x0035, 6851},
    {INT64_C(1380575043665631000), 0x0003, 0x0036, 6560},
    {INT64_C(1380575043665631000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043665631000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043665631000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043665631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043665631000), 0x0003, 0x0035, 5153},
    {INT64_C(1380575043665631000), 0x0003, 0x0036, 5486},
    {INT64_C(1380575043665631000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043665631000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043665631000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043665631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043665631000), 0x0003, 0x0035, 8064},
    {INT64_C(1380575043665631000), 0x0003, 0x0036, 5581},
    {INT64_C(1380575043665631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043665631000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043665631000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043665631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043665631000), 0x0003, 0x0035, 8654},
    {INT64_C(1380575043665631000), 0x0003, 0x0036, 4155},
    {INT64_C(1380575043665631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043665631000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043665631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043665631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043665631000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043683632000), 0x0003, 0x0000, 6808},
    {INT64_C(1380575043683632000), 0x0003, 0x0035, 6808},
    {INT64_C(1380575043683632000), 0x0003, 0x0036, 6560},
    {INT64_C(1380575043683632000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043683632000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043683632000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043683632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043683632000), 0x0003, 0x0035, 8064},
    {INT64_C(1380575043683632000), 0x0003, 0x0036, 5813},
    {INT64_C(1380575043683632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043683632000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043683632000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043683632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043683632000), 0x0003, 0x0035, 5133},
    {INT64_C(1380575043683632000), 0x0003, 0x0036, 5355},
    {INT64_C(1380575043683632000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043683632000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043683632000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043683632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043683632000), 0x0003, 0x0035, 8618},
    {INT64_C(1380575043683632000), 0x0003, 0x0036, 4088},
    {INT64_C(1380575043683632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043683632000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043683632000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043683632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043683632000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043701633000), 0x0003, 0x0000, 6725},
    {INT64_C(1380575043701633000), 0x0003, 0x0001, 6400},
    {INT64_C(1380575043701633000), 0x0003, 0x0035, 6725},
    {INT64_C(1380575043701633000), 0x0003, 0x0036, 6400},
    {INT64_C(1380575043701633000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043701633000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043701633000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043701633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043701633000), 0x0003, 0x0035, 8001},
    {INT64_C(1380575043701633000), 0x0003, 0x0036, 5760},
    {INT64_C(1380575043701633000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043701633000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043701633000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043701633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043701633000), 0x0003, 0x0035, 5078},
    {INT64_C(1380575043701633000), 0x0003, 0x0036, 5303},
    {INT64_C(1380575043701633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043701633000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043701633000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043701633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043701633000), 0x0003, 0x0035, 7967},
    {INT64_C(1380575043701633000), 0x0003, 0x0036, 5383},
    {INT64_C(1380575043701633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043701633000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043701633000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043701633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043701633000), 0x0003, 0x0035, 8576},
    {INT64_C(1380575043701633000), 0x0003, 0x0036, 4022},
    {INT64_C(1380575043701633000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043701633000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043701633000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043701633000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043701633000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043721631000), 0x0003, 0x0000, 6666},
    {INT64_C(1380575043721631000), 0x0003, 0x0001, 6305},
    {INT64_C(1380575043721631000), 0x0003, 0x0035, 6666},
    {INT64_C(1380575043721631000), 0x0003, 0x0036, 6305},
    {INT64_C(1380575043721631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043721631000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043721631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043721631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043721631000), 0x0003, 0x0035, 5063},
    {INT64_C(1380575043721631000), 0x0003, 0x0036, 5097},
    {INT64_C(1380575043721631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043721631000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043721631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043721631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043721631000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043739627000), 0x0003, 0x0000, 6588},
    {INT64_C(1380575043739627000), 0x0003, 0x0001, 6240},
    {INT64_C(1380575043739627000), 0x0003, 0x0035, 6588},
    {INT64_C(1380575043739627000), 0x0003, 0x0036, 6240},
    {INT64_C(1380575043739627000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043739627000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043739627000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043739627000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043739627000), 0x0003, 0x0035, 4975},
    {INT64_C(1380575043739627000), 0x0003, 0x0036, 4967},
    {INT64_C(1380575043739627000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043739627000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043739627000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043739627000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043739627000), 0x0003, 0x0035, 8448},
    {INT64_C(1380575043739627000), 0x0003, 0x0036, 3855},
    {INT64_C(1380575043739627000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043739627000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043739627000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043739627000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043739627000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043757630000), 0x0003, 0x0000, 7847},
    {INT64_C(1380575043757630000), 0x0003, 0x0001, 5493},
    {INT64_C(1380575043757630000), 0x0003, 0x0035, 7847},
    {INT64_C(1380575043757630000), 0x0003, 0x0036, 5493},
    {INT64_C(1380575043757630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043757630000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043757630000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043757630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043757630000), 0x0003, 0x0035, 4982},
    {INT64_C(1380575043757630000), 0x0003, 0x0036, 4825},
    {INT64_C(1380575043757630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043757630000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043757630000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043757630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043757630000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043777630000), 0x0003, 0x0000, 6450},
    {INT64_C(1380575043777630000), 0x0003, 0x0001, 6001},
    {INT64_C(1380575043777630000), 0x0003, 0x0035, 6450},
    {INT64_C(1380575043777630000), 0x0003, 0x0036, 6001},
    {INT64_C(1380575043777630000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043777630000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043777630000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043777630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043777630000), 0x0003, 0x0035, 8346},
    {INT64_C(1380575043777630000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575043777630000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043777630000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043777630000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043777630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043777630000), 0x0003, 0x0035, 4958},
    {INT64_C(1380575043777630000), 0x0003, 0x0036, 4720},
    {INT64_C(1380575043777630000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043777630000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043777630000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043777630000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043777630000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043795628000), 0x0003, 0x0000, 6419},
    {INT64_C(1380575043795628000), 0x0003, 0x0001, 5920},
    {INT64_C(1380575043795628000), 0x0003, 0x0035, 6419},
    {INT64_C(1380575043795628000), 0x0003, 0x0036, 5920},
    {INT64_C(1380575043795628000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043795628000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043795628000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043795628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043795628000), 0x0003, 0x0035, 7742},
    {INT64_C(1380575043795628000), 0x0003, 0x0036, 5337},
    {INT64_C(1380575043795628000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043795628000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043795628000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043795628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043795628000), 0x0003, 0x0035, 4963},
    {INT64_C(1380575043795628000), 0x0003, 0x0036, 4640},
    {INT64_C(1380575043795628000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043795628000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043795628000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043795628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043795628000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043815631000), 0x0003, 0x0000, 6335},
    {INT64_C(1380575043815631000), 0x0003, 0x0001, 5814},
    {INT64_C(1380575043815631000), 0x0003, 0x0035, 6335},
    {INT64_C(1380575043815631000), 0x0003, 0x0036, 5814},
    {INT64_C(1380575043815631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043815631000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043815631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043815631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043815631000), 0x0003, 0x0035, 7701},
    {INT64_C(1380575043815631000), 0x0003, 0x0036, 5280},
    {INT64_C(1380575043815631000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043815631000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043815631000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043815631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043815631000), 0x0003, 0x0035, 4942},
    {INT64_C(1380575043815631000), 0x0003, 0x0036, 4425},
    {INT64_C(1380575043815631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043815631000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043815631000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043815631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043815631000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0000, 6305},
    {INT64_C(1380575043833632000), 0x0003, 0x0001, 5678},
    {INT64_C(1380575043833632000), 0x0003, 0x0035, 6305},
    {INT64_C(1380575043833632000), 0x0003, 0x0036, 5678},
    {INT64_C(1380575043833632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043833632000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043833632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0035, 7680},
    {INT64_C(1380575043833632000), 0x0003, 0x0036, 5710},
    {INT64_C(1380575043833632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043833632000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043833632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0035, 8254},
    {INT64_C(1380575043833632000), 0x0003, 0x0036, 5640},
    {INT64_C(1380575043833632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043833632000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043833632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0035, 7680},
    {INT64_C(1380575043833632000), 0x0003, 0x0036, 5167},
    {INT64_C(1380575043833632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043833632000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043833632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0035, 4945},
    {INT64_C(1380575043833632000), 0x0003, 0x0036, 4293},
    {INT64_C(1380575043833632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043833632000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043833632000), 0x0003, 0x0031, 384},
    {INT64_C(1380575043833632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043833632000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043851632000), 0x0003, 0x0000, 6236},
    {INT64_C(1380575043851632000), 0x0003, 0x0001, 5522},
    {INT64_C(1380575043851632000), 0x0003, 0x0035, 6236},
    {INT64_C(1380575043851632000), 0x0003, 0x0036, 5522},
    {INT64_C(1380575043851632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043851632000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043851632000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043851632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043851632000), 0x0003, 0x0035, 8192},
    {INT64_C(1380575043851632000), 0x0003, 0x0036, 5488},
    {INT64_C(1380575043851632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043851632000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043851632000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043851632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043851632000), 0x0003, 0x0035, 7603},
    {INT64_C(1380575043851632000), 0x0003, 0x0036, 5072},
    {INT64_C(1380575043851632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043851632000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043851632000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043851632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043851632000), 0x0003, 0x0035, 4934},
    {INT64_C(1380575043851632000), 0x0003, 0x0036, 4194},
    {INT64_C(1380575043851632000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043851632000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043851632000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043851632000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043851632000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043871631000), 0x0003, 0x0000, 6215},
    {INT64_C(1380575043871631000), 0x0003, 0x0001, 5449},
    {INT64_C(1380575043871631000), 0x0003, 0x0035, 6215},
    {INT64_C(1380575043871631000), 0x0003, 0x0036, 5449},
    {INT64_C(1380575043871631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043871631000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043871631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043871631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043871631000), 0x0003, 0x0035, 8192},
    {INT64_C(1380575043871631000), 0x0003, 0x0036, 5499},
    {INT64_C(1380575043871631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043871631000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043871631000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043871631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043871631000), 0x0003, 0x0035, 7556},
    {INT64_C(1380575043871631000), 0x0003, 0x0036, 5013},
    {INT64_C(1380575043871631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043871631000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043871631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043871631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043871631000), 0x0003, 0x0035, 4948},
    {INT64_C(1380575043871631000), 0x0003, 0x0036, 4090},
    {INT64_C(1380575043871631000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043871631000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043871631000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043871631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043871631000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043889628000), 0x0003, 0x0000, 6197},
    {INT64_C(1380575043889628000), 0x0003, 0x0001, 5324},
    {INT64_C(1380575043889628000), 0x0003, 0x0035, 6197},
    {INT64_C(1380575043889628000), 0x0003, 0x0036, 5324},
    {INT64_C(1380575043889628000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043889628000), 0x0003, 0x0030, 800},
    {INT64_C(1380575043889628000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043889628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043889628000), 0x0003, 0x0035, 8064},
    {INT64_C(1380575043889628000), 0x0003, 0x0036, 5430},
    {INT64_C(1380575043889628000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043889628000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043889628000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043889628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043889628000), 0x0003, 0x0035, 7552},
    {INT64_C(1380575043889628000), 0x0003, 0x0036, 4877},
    {INT64_C(1380575043889628000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043889628000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043889628000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043889628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043889628000), 0x0003, 0x0035, 4954},
    {INT64_C(1380575043889628000), 0x0003, 0x0036, 4015},
    {INT64_C(1380575043889628000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043889628000), 0x0003, 0x0030, 384},
    {INT64_C(1380575043889628000), 0x0003, 0x0031, 320},
    {INT64_C(1380575043889628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043889628000), 0x0003, 0x0035, 8074},
    {INT64_C(1380575043889628000), 0x0003, 0x0036, 3360},
    {INT64_C(1380575043889628000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043889628000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043889628000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043889628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043889628000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043907629000), 0x0003, 0x0000, 6161},
    {INT64_C(1380575043907629000), 0x0003, 0x0001, 5126},
    {INT64_C(1380575043907629000), 0x0003, 0x0035, 6161},
    {INT64_C(1380575043907629000), 0x0003, 0x0036, 5126},
    {INT64_C(1380575043907629000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043907629000), 0x0003, 0x0030, 640},
    {INT64_C(1380575043907629000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043907629000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043907629000), 0x0003, 0x0035, 7465},
    {INT64_C(1380575043907629000), 0x0003, 0x0036, 4773},
    {INT64_C(1380575043907629000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043907629000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043907629000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043907629000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043907629000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043927631000), 0x0003, 0x0000, 6097},
    {INT64_C(1380575043927631000), 0x0003, 0x0001, 5019},
    {INT64_C(1380575043927631000), 0x0003, 0x0035, 6097},
    {INT64_C(1380575043927631000), 0x0003, 0x0036, 5019},
    {INT64_C(1380575043927631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043927631000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043927631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043927631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043927631000), 0x0003, 0x0035, 7420},
    {INT64_C(1380575043927631000), 0x0003, 0x0036, 4666},
    {INT64_C(1380575043927631000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043927631000), 0x0003, 0x0030, 320},
    {INT64_C(1380575043927631000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043927631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043927631000), 0x0003, 0x0035, 4944},
    {INT64_C(1380575043927631000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575043927631000), 0x0003, 0x0034, 1},
    {INT64_C(1380575043927631000), 0x0003, 0x0030, 256},
    {INT64_C(1380575043927631000), 0x0003, 0x0031, 160},
    {INT64_C(1380575043927631000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043927631000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043945629000), 0x0003, 0x0000, 6065},
    {INT64_C(1380575043945629000), 0x0003, 0x0001, 4857},
    {INT64_C(1380575043945629000), 0x0003, 0x0035, 6065},
    {INT64_C(1380575043945629000), 0x0003, 0x0036, 4857},
    {INT64_C(1380575043945629000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043945629000), 0x0003, 0x0030, 800},
    {INT64_C(1380575043945629000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043945629000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043945629000), 0x0003, 0x0035, 7323},
    {INT64_C(1380575043945629000), 0x0003, 0x0036, 4451},
    {INT64_C(1380575043945629000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043945629000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043945629000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043945629000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043945629000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043963628000), 0x0003, 0x0000, 6028},
    {INT64_C(1380575043963628000), 0x0003, 0x0001, 4723},
    {INT64_C(1380575043963628000), 0x0003, 0x0035, 6028},
    {INT64_C(1380575043963628000), 0x0003, 0x0036, 4723},
    {INT64_C(1380575043963628000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043963628000), 0x0003, 0x0030, 800},
    {INT64_C(1380575043963628000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043963628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043963628000), 0x0003, 0x0035, 7230},
    {INT64_C(1380575043963628000), 0x0003, 0x0036, 4339},
    {INT64_C(1380575043963628000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043963628000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043963628000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043963628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043963628000), 0x0000, 0x0000, 0},
    {INT64_C(1380575043983629000), 0x0003, 0x0000, 5948},
    {INT64_C(1380575043983629000), 0x0003, 0x0001, 4544},
    {INT64_C(1380575043983629000), 0x0003, 0x0035, 5948},
    {INT64_C(1380575043983629000), 0x0003, 0x0036, 4544},
    {INT64_C(1380575043983629000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043983629000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043983629000), 0x0003, 0x0031, 256},
    {INT64_C(1380575043983629000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043983629000), 0x0003, 0x0035, 7168},
    {INT64_C(1380575043983629000), 0x0003, 0x0036, 4199},
    {INT64_C(1380575043983629000), 0x0003, 0x0034, 0},
    {INT64_C(1380575043983629000), 0x0003, 0x0030, 480},
    {INT64_C(1380575043983629000), 0x0003, 0x0031, 128},
    {INT64_C(1380575043983629000), 0x0000, 0x0002, 0},
    {INT64_C(1380575043983629000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044001588000), 0x0003, 0x0000, 5905},
    {INT64_C(1380575044001588000), 0x0003, 0x0001, 4386},
    {INT64_C(1380575044001588000), 0x0003, 0x0035, 5905},
    {INT64_C(1380575044001588000), 0x0003, 0x0036, 4386},
    {INT64_C(1380575044001588000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044001588000), 0x0003, 0x0030, 640},
    {INT64_C(1380575044001588000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044001588000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044001588000), 0x0003, 0x0035, 7054},
    {INT64_C(1380575044001588000), 0x0003, 0x0036, 4033},
    {INT64_C(1380575044001588000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044001588000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044001588000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044001588000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044001588000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044019626000), 0x0003, 0x0000, 5825},
    {INT64_C(1380575044019626000), 0x0003, 0x0001, 4220},
    {INT64_C(1380575044019626000), 0x0003, 0x0035, 5825},
    {INT64_C(1380575044019626000), 0x0003, 0x0036, 4220},
    {INT64_C(1380575044019626000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044019626000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044019626000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044019626000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044019626000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044039627000), 0x0003, 0x0000, 5778},
    {INT64_C(1380575044039627000), 0x0003, 0x0001, 4085},
    {INT64_C(1380575044039627000), 0x0003, 0x0035, 5778},
    {INT64_C(1380575044039627000), 0x0003, 0x0036, 4085},
    {INT64_C(1380575044039627000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044039627000), 0x0003, 0x0030, 800},
    {INT64_C(1380575044039627000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044039627000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044039627000), 0x0003, 0x0035, 6928},
    {INT64_C(1380575044039627000), 0x0003, 0x0036, 3730},
    {INT64_C(1380575044039627000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044039627000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044039627000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044039627000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044039627000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044057628000), 0x0003, 0x0000, 5691},
    {INT64_C(1380575044057628000), 0x0003, 0x0001, 3923},
    {INT64_C(1380575044057628000), 0x0003, 0x0035, 5691},
    {INT64_C(1380575044057628000), 0x0003, 0x0036, 3923},
    {INT64_C(1380575044057628000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044057628000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044057628000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044057628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044057628000), 0x0003, 0x0035, 6840},
    {INT64_C(1380575044057628000), 0x0003, 0x0036, 3680},
    {INT64_C(1380575044057628000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044057628000), 0x0003, 0x0030, 256},
    {INT64_C(1380575044057628000), 0x0003, 0x0031, 160},
    {INT64_C(1380575044057628000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044057628000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044077627000), 0x0003, 0x0000, 5603},
    {INT64_C(1380575044077627000), 0x0003, 0x0001, 3795},
    {INT64_C(1380575044077627000), 0x0003, 0x0035, 5603},
    {INT64_C(1380575044077627000), 0x0003, 0x0036, 3795},
    {INT64_C(1380575044077627000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044077627000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044077627000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044077627000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044077627000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044169624000), 0x0001, 0x014d, 0},
    {INT64_C(1380575044169624000), 0x0001, 0x014a, 0},
    {INT64_C(1380575044169624000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044807625000), 0x0003, 0x0035, 1536},
    {INT64_C(1380575044807625000), 0x0003, 0x0036, 2478},
    {INT64_C(1380575044807625000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044807625000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044807625000), 0x0003, 0x0031, 128},
    {INT64_C(1380575044807625000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044807625000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044813624000), 0x0003, 0x0000, 2922},
    {INT64_C(1380575044813624000), 0x0003, 0x0001, 5026},
    {INT64_C(1380575044813624000), 0x0003, 0x0035, 2922},
    {INT64_C(1380575044813624000), 0x0003, 0x0036, 5026},
    {INT64_C(1380575044813624000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044813624000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044813624000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044813624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044813624000), 0x0003, 0x0035, 2048},
    {INT64_C(1380575044813624000), 0x0003, 0x0036, 4202},
    {INT64_C(1380575044813624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044813624000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044813624000), 0x0003, 0x0031, 128},
    {INT64_C(1380575044813624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044813624000), 0x0003, 0x0035, 1624},
    {INT64_C(1380575044813624000), 0x0003, 0x0036, 2469},
    {INT64_C(1380575044813624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044813624000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044813624000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044813624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044813624000), 0x0001, 0x014d, 1},
    {INT64_C(1380575044813624000), 0x0001, 0x014a, 1},
    {INT64_C(1380575044813624000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044825623000), 0x0003, 0x0000, 2964},
    {INT64_C(1380575044825623000), 0x0003, 0x0001, 5029},
    {INT64_C(1380575044825623000), 0x0003, 0x0035, 2964},
    {INT64_C(1380575044825623000), 0x0003, 0x0036, 5029},
    {INT64_C(1380575044825623000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044825623000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044825623000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044825623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044825623000), 0x0003, 0x0035, 2127},
    {INT64_C(1380575044825623000), 0x0003, 0x0036, 4200},
    {INT64_C(1380575044825623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044825623000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044825623000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044825623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044825623000), 0x0003, 0x0035, 1664},
    {INT64_C(1380575044825623000), 0x0003, 0x0036, 2465},
    {INT64_C(1380575044825623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044825623000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044825623000), 0x0003, 0x0031, 128},
    {INT64_C(1380575044825623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044825623000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044831623000), 0x0003, 0x0000, 3014},
    {INT64_C(1380575044831623000), 0x0003, 0x0001, 4990},
    {INT64_C(1380575044831623000), 0x0003, 0x0035, 3014},
    {INT64_C(1380575044831623000), 0x0003, 0x0036, 4990},
    {INT64_C(1380575044831623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044831623000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044831623000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044831623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044831623000), 0x0003, 0x0035, 2265},
    {INT64_C(1380575044831623000), 0x0003, 0x0036, 4163},
    {INT64_C(1380575044831623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044831623000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044831623000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044831623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044831623000), 0x0003, 0x0035, 1792},
    {INT64_C(1380575044831623000), 0x0003, 0x0036, 2467},
    {INT64_C(1380575044831623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044831623000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044831623000), 0x0003, 0x0031, 128},
    {INT64_C(1380575044831623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044831623000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044843625000), 0x0003, 0x0000, 3034},
    {INT64_C(1380575044843625000), 0x0003, 0x0001, 4965},
    {INT64_C(1380575044843625000), 0x0003, 0x0035, 3034},
    {INT64_C(1380575044843625000), 0x0003, 0x0036, 4965},
    {INT64_C(1380575044843625000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044843625000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044843625000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044843625000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044843625000), 0x0003, 0x0035, 2304},
    {INT64_C(1380575044843625000), 0x0003, 0x0036, 4119},
    {INT64_C(1380575044843625000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044843625000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044843625000), 0x0003, 0x0031, 128},
    {INT64_C(1380575044843625000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044843625000), 0x0003, 0x0035, 1920},
    {INT64_C(1380575044843625000), 0x0003, 0x0036, 2437},
    {INT64_C(1380575044843625000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044843625000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044843625000), 0x0003, 0x0031, 128},
    {INT64_C(1380575044843625000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044843625000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044849623000), 0x0003, 0x0000, 3119},
    {INT64_C(1380575044849623000), 0x0003, 0x0001, 4886},
    {INT64_C(1380575044849623000), 0x0003, 0x0035, 3119},
    {INT64_C(1380575044849623000), 0x0003, 0x0036, 4886},
    {INT64_C(1380575044849623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044849623000), 0x0003, 0x0030, 640},
    {INT64_C(1380575044849623000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044849623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044849623000), 0x0003, 0x0035, 2497},
    {INT64_C(1380575044849623000), 0x0003, 0x0036, 4078},
    {INT64_C(1380575044849623000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044849623000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044849623000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044849623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044849623000), 0x0003, 0x0035, 2156},
    {INT64_C(1380575044849623000), 0x0003, 0x0036, 2422},
    {INT64_C(1380575044849623000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044849623000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044849623000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044849623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044849623000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044863624000), 0x0003, 0x0000, 3251},
    {INT64_C(1380575044863624000), 0x0003, 0x0001, 4806},
    {INT64_C(1380575044863624000), 0x0003, 0x0035, 3251},
    {INT64_C(1380575044863624000), 0x0003, 0x0036, 4806},
    {INT64_C(1380575044863624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044863624000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044863624000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044863624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044863624000), 0x0003, 0x0035, 2635},
    {INT64_C(1380575044863624000), 0x0003, 0x0036, 4051},
    {INT64_C(1380575044863624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044863624000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044863624000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044863624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044863624000), 0x0003, 0x0035, 2311},
    {INT64_C(1380575044863624000), 0x0003, 0x0036, 2312},
    {INT64_C(1380575044863624000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044863624000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044863624000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044863624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044863624000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044869622000), 0x0003, 0x0000, 3399},
    {INT64_C(1380575044869622000), 0x0003, 0x0001, 4671},
    {INT64_C(1380575044869622000), 0x0003, 0x0035, 3399},
    {INT64_C(1380575044869622000), 0x0003, 0x0036, 4671},
    {INT64_C(1380575044869622000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044869622000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044869622000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044869622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044869622000), 0x0003, 0x0035, 2769},
    {INT64_C(1380575044869622000), 0x0003, 0x0036, 3955},
    {INT64_C(1380575044869622000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044869622000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044869622000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044869622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044869622000), 0x0003, 0x0035, 2473},
    {INT64_C(1380575044869622000), 0x0003, 0x0036, 2300},
    {INT64_C(1380575044869622000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044869622000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044869622000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044869622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044869622000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044881624000), 0x0003, 0x0000, 3589},
    {INT64_C(1380575044881624000), 0x0003, 0x0001, 4580},
    {INT64_C(1380575044881624000), 0x0003, 0x0035, 3589},
    {INT64_C(1380575044881624000), 0x0003, 0x0036, 4580},
    {INT64_C(1380575044881624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044881624000), 0x0003, 0x0030, 640},
    {INT64_C(1380575044881624000), 0x0003, 0x0031, 384},
    {INT64_C(1380575044881624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044881624000), 0x0003, 0x0035, 2947},
    {INT64_C(1380575044881624000), 0x0003, 0x0036, 3921},
    {INT64_C(1380575044881624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044881624000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044881624000), 0x0003, 0x0031, 384},
    {INT64_C(1380575044881624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044881624000), 0x0003, 0x0035, 2619},
    {INT64_C(1380575044881624000), 0x0003, 0x0036, 2285},
    {INT64_C(1380575044881624000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044881624000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044881624000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044881624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044881624000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044887620000), 0x0003, 0x0000, 3778},
    {INT64_C(1380575044887620000), 0x0003, 0x0001, 4523},
    {INT64_C(1380575044887620000), 0x0003, 0x0035, 3778},
    {INT64_C(1380575044887620000), 0x0003, 0x0036, 4523},
    {INT64_C(1380575044887620000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044887620000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044887620000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044887620000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044887620000), 0x0003, 0x0035, 3072},
    {INT64_C(1380575044887620000), 0x0003, 0x0036, 3859},
    {INT64_C(1380575044887620000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044887620000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044887620000), 0x0003, 0x0031, 128},
    {INT64_C(1380575044887620000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044887620000), 0x0003, 0x0035, 2790},
    {INT64_C(1380575044887620000), 0x0003, 0x0036, 2240},
    {INT64_C(1380575044887620000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044887620000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044887620000), 0x0003, 0x0031, 160},
    {INT64_C(1380575044887620000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044887620000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044901622000), 0x0003, 0x0000, 3950},
    {INT64_C(1380575044901622000), 0x0003, 0x0001, 4415},
    {INT64_C(1380575044901622000), 0x0003, 0x0035, 3950},
    {INT64_C(1380575044901622000), 0x0003, 0x0036, 4415},
    {INT64_C(1380575044901622000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044901622000), 0x0003, 0x0030, 640},
    {INT64_C(1380575044901622000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044901622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044901622000), 0x0003, 0x0035, 3300},
    {INT64_C(1380575044901622000), 0x0003, 0x0036, 3802},
    {INT64_C(1380575044901622000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044901622000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044901622000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044901622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044901622000), 0x0003, 0x0035, 2971},
    {INT64_C(1380575044901622000), 0x0003, 0x0036, 2240},
    {INT64_C(1380575044901622000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044901622000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044901622000), 0x0003, 0x0031, 160},
    {INT64_C(1380575044901622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044901622000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044919624000), 0x0003, 0x0000, 4157},
    {INT64_C(1380575044919624000), 0x0003, 0x0001, 4318},
    {INT64_C(1380575044919624000), 0x0003, 0x0035, 4157},
    {INT64_C(1380575044919624000), 0x0003, 0x0036, 4318},
    {INT64_C(1380575044919624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044919624000), 0x0003, 0x0030, 480},
    {INT64_C(1380575044919624000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044919624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044919624000), 0x0003, 0x0035, 3449},
    {INT64_C(1380575044919624000), 0x0003, 0x0036, 3759},
    {INT64_C(1380575044919624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044919624000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044919624000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044919624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044919624000), 0x0003, 0x0035, 3147},
    {INT64_C(1380575044919624000), 0x0003, 0x0036, 2240},
    {INT64_C(1380575044919624000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044919624000), 0x0003, 0x0030, 256},
    {INT64_C(1380575044919624000), 0x0003, 0x0031, 160},
    {INT64_C(1380575044919624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044919624000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044937622000), 0x0003, 0x0000, 4352},
    {INT64_C(1380575044937622000), 0x0003, 0x0001, 4238},
    {INT64_C(1380575044937622000), 0x0003, 0x0035, 4352},
    {INT64_C(1380575044937622000), 0x0003, 0x0036, 4238},
    {INT64_C(1380575044937622000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044937622000), 0x0003, 0x0030, 640},
    {INT64_C(1380575044937622000), 0x0003, 0x0031, 384},
    {INT64_C(1380575044937622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044937622000), 0x0003, 0x0035, 3676},
    {INT64_C(1380575044937622000), 0x0003, 0x0036, 3734},
    {INT64_C(1380575044937622000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044937622000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044937622000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044937622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044937622000), 0x0003, 0x0035, 3353},
    {INT64_C(1380575044937622000), 0x0003, 0x0036, 2080},
    {INT64_C(1380575044937622000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044937622000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044937622000), 0x0003, 0x0031, 160},
    {INT64_C(1380575044937622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044937622000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044957624000), 0x0003, 0x0000, 4565},
    {INT64_C(1380575044957624000), 0x0003, 0x0001, 4132},
    {INT64_C(1380575044957624000), 0x0003, 0x0035, 4565},
    {INT64_C(1380575044957624000), 0x0003, 0x0036, 4132},
    {INT64_C(1380575044957624000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044957624000), 0x0003, 0x0030, 640},
    {INT64_C(1380575044957624000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044957624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044957624000), 0x0003, 0x0035, 3907},
    {INT64_C(1380575044957624000), 0x0003, 0x0036, 3692},
    {INT64_C(1380575044957624000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044957624000), 0x0003, 0x0030, 384},
    {INT64_C(1380575044957624000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044957624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044957624000), 0x0003, 0x0035, 3532},
    {INT64_C(1380575044957624000), 0x0003, 0x0036, 2080},
    {INT64_C(1380575044957624000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044957624000), 0x0003, 0x0030, 256},
    {INT64_C(1380575044957624000), 0x0003, 0x0031, 160},
    {INT64_C(1380575044957624000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044957624000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044975623000), 0x0003, 0x0000, 4774},
    {INT64_C(1380575044975623000), 0x0003, 0x0001, 4042},
    {INT64_C(1380575044975623000), 0x0003, 0x0035, 4774},
    {INT64_C(1380575044975623000), 0x0003, 0x0036, 4042},
    {INT64_C(1380575044975623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044975623000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044975623000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044975623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044975623000), 0x0003, 0x0035, 4081},
    {INT64_C(1380575044975623000), 0x0003, 0x0036, 3583},
    {INT64_C(1380575044975623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044975623000), 0x0003, 0x0030, 320},
    {INT64_C(1380575044975623000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044975623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044975623000), 0x0003, 0x0035, 3754},
    {INT64_C(1380575044975623000), 0x0003, 0x0036, 2080},
    {INT64_C(1380575044975623000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044975623000), 0x0003, 0x0030, 256},
    {INT64_C(1380575044975623000), 0x0003, 0x0031, 160},
    {INT64_C(1380575044975623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044975623000), 0x0000, 0x0000, 0},
    {INT64_C(1380575044993623000), 0x0003, 0x0000, 4944},
    {INT64_C(1380575044993623000), 0x0003, 0x0001, 3890},
    {INT64_C(1380575044993623000), 0x0003, 0x0035, 4944},
    {INT64_C(1380575044993623000), 0x0003, 0x0036, 3890},
    {INT64_C(1380575044993623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575044993623000), 0x0003, 0x0030, 800},
    {INT64_C(1380575044993623000), 0x0003, 0x0031, 256},
    {INT64_C(1380575044993623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044993623000), 0x0003, 0x0035, 4278},
    {INT64_C(1380575044993623000), 0x0003, 0x0036, 3555},
    {INT64_C(1380575044993623000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044993623000), 0x0003, 0x0030, 640},
    {INT64_C(1380575044993623000), 0x0003, 0x0031, 320},
    {INT64_C(1380575044993623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044993623000), 0x0003, 0x0035, 3930},
    {INT64_C(1380575044993623000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575044993623000), 0x0003, 0x0034, 1},
    {INT64_C(1380575044993623000), 0x0003, 0x0030, 256},
    {INT64_C(1380575044993623000), 0x0003, 0x0031, 160},
    {INT64_C(1380575044993623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575044993623000), 0x0000, 0x0000, 0},
    {INT64_C(1380575045013623000), 0x0003, 0x0000, 5120},
    {INT64_C(1380575045013623000), 0x0003, 0x0001, 3885},
    {INT64_C(1380575045013623000), 0x0003, 0x0035, 5120},
    {INT64_C(1380575045013623000), 0x0003, 0x0036, 3885},
    {INT64_C(1380575045013623000), 0x0003, 0x0034, 0},
    {INT64_C(1380575045013623000), 0x0003, 0x0030, 320},
    {INT64_C(1380575045013623000), 0x0003, 0x0031, 128},
    {INT64_C(1380575045013623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575045013623000), 0x0003, 0x0035, 4484},
    {INT64_C(1380575045013623000), 0x0003, 0x0036, 3430},
    {INT64_C(1380575045013623000), 0x0003, 0x0034, 1},
    {INT64_C(1380575045013623000), 0x0003, 0x0030, 384},
    {INT64_C(1380575045013623000), 0x0003, 0x0031, 320},
    {INT64_C(1380575045013623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575045013623000), 0x0003, 0x0035, 4158},
    {INT64_C(1380575045013623000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575045013623000), 0x0003, 0x0034, 1},
    {INT64_C(1380575045013623000), 0x0003, 0x0030, 256},
    {INT64_C(1380575045013623000), 0x0003, 0x0031, 160},
    {INT64_C(1380575045013623000), 0x0000, 0x0002, 0},
    {INT64_C(1380575045013623000), 0x0000, 0x0000, 0},
    {INT64_C(1380575045031622000), 0x0003, 0x0000, 5325},
    {INT64_C(1380575045031622000), 0x0003, 0x0001, 3736},
    {INT64_C(1380575045031622000), 0x0003, 0x0035, 5325},
    {INT64_C(1380575045031622000), 0x0003, 0x0036, 3736},
    {INT64_C(1380575045031622000), 0x0003, 0x0034, 0},
    {INT64_C(1380575045031622000), 0x0003, 0x0030, 480},
    {INT64_C(1380575045031622000), 0x0003, 0x0031, 256},
    {INT64_C(1380575045031622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575045031622000), 0x0003, 0x0035, 4677},
    {INT64_C(1380575045031622000), 0x0003, 0x0036, 3403},
    {INT64_C(1380575045031622000), 0x0003, 0x0034, 0},
    {INT64_C(1380575045031622000), 0x0003, 0x0030, 320},
    {INT64_C(1380575045031622000), 0x0003, 0x0031, 256},
    {INT64_C(1380575045031622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575045031622000), 0x0003, 0x0035, 4384},
    {INT64_C(1380575045031622000), 0x0003, 0x0036, 1920},
    {INT64_C(1380575045031622000), 0x0003, 0x0034, 1},
    {INT64_C(1380575045031622000), 0x0003, 0x0030, 256},
    {INT64_C(1380575045031622000), 0x0003, 0x0031, 160},
    {INT64_C(1380575045031622000), 0x0000, 0x0002, 0},
    {INT64_C(1380575045031622000), 0x0000, 0x0000, 0},
    {INT64_C(1380575045049620000), 0x0003, 0x0000, 5504},
    {INT64_C(1380575045049620000), 0x0003, 0x0001, 3636},
    {INT64_C(1380575045049620000), 0x0003, 0x0035, 5504},
    {INT64_C(1380575045049620000), 0x0003, 0x0036, 3636},
    {INT64_C(1380575045049620000), 0x0003, 0x0034, 0},
    {INT64_C(1380575045049620000), 0x0003, 0x0030, 480},
    {INT64_C(1380575045049620000), 0x0003, 0x0031, 128},
    {INT64_C(1380575045049620000), 0x0000, 0x0002, 0},
    {INT64_C(1380575045049620000), 0x0000, 0x0000, 0},
    {INT64_C(1380575045143617000), 0x0001, 0x014d, 0},
    {INT64_C(1380575045143617000), 0x0001, 0x014a, 0},
    {INT64_C(1380575045143617000), 0x0000, 0x0000, 0},
    {INT64_C(-1), 0x0000, 0x0000, 0}
};

#endif // NTRIG_INPUT_EVENTS_H_
