[![Build Status](https://github.com/CanonicalLtd/landscape-client/actions/workflows/ci.yml/badge.svg)](https://github.com/CanonicalLtd/landscape-client/actions/workflows/ci.yml)
[![codecov](https://codecov.io/gh/CanonicalLtd/landscape-client/branch/master/graph/badge.svg)](https://codecov.io/gh/CanonicalLtd/landscape-client)

## Installation Instructions

Add our beta PPA to get the latest updates to the landscape-client package

#### Add repo to an Ubuntu series
```
sudo add-apt-repository ppa:landscape/self-hosted-beta
```

#### Add repo to a Debian based series that is not Ubuntu (experimental)

```
# 1. Install our signing key
gpg --keyserver keyserver.ubuntu.com --recv-keys 6e85a86e4652b4e6
gpg --export 6e85a86e4652b4e6 | sudo tee -a /usr/share/keyrings/landscape-client-keyring.gpg > /dev/null

# 2. Add repository
echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/landscape-client-keyring.gpg] https://ppa.launchpadcontent.net/landscape/self-hosted-beta/ubuntu focal main" | sudo tee -a /etc/apt/sources.list.d/landscape-client.list
```

#### Install the package
```
sudo apt update && sudo apt install landscape-client
```

## Non-root mode

The Landscape Client generally runs as a combination of the `root` and
`landscape` users.  It is possible to disable the administrative features of
Landscape and run only the monitoring parts of it without using the `root`
user at all.

If you wish to use the Landscape Client in this way, it's recommended that you
perform these steps immediately after installing the landscape-client package.

Edit `/etc/default/landscape-client` and add the following lines:

```
RUN=1
DAEMON_USER=landscape
```

Edit `/etc/landscape/client.conf` and add the following line:
```
monitor_only = true
```

## Running

Now you can complete the configuration of your client and register with the
Landscape service. There are two ways to do this:

1. `sudo landscape-config` and answer interactive prompts to finalize your configuration
2. `sudo landscape-config --account-name standalone --url https://<server>/message-system --ping-url http://<server>/ping` if registering to a self-hosted Landscape instance. Replace `<server>` with the hostname of your self-hosted Landscape instance.

## Developing

After cloning the repository, make sure you run the following command to pull the `snap-http` submodule:

```shell
git submodule update --init
```

To run the full test suite, run the following command:

```
make check
```

When you want to test the landscape client manually without management
features, you can simply run:

```
$ ./scripts/landscape-client
```

This defaults to the `landscape-client.conf` configuration file.

When you want to test management features manually, you'll need to run as root.
There's a configuration file `root-client.conf` which specifies use of the
system bus.

```
$ sudo ./scripts/landscape-client -c root-client.conf
```

Before opening a PR, make sure to run the full test suite and lint:
```
make check
make lint
```

You can run a specific test by running the following (for example):
```
python3 -m twisted.trial landscape.client.broker.tests.test_client.BrokerClientTest.test_ping
```

### Building the Landscape Client snap

First, you need to ensure that you have the appropriate tools installed:
```
$ sudo snap install snapcraft --classic
$ lxd init --auto
```

There are various make targets defined to assist in the lifecycle of
building and testing the snap.  To simply build the snap with the minimum
of debug information displayed:
```
$ make snap
```

If you would prefer to see more information displayed showing the progress
of the build, and would like to get dropped into a debug shell within the
snap container in the event of an error:
```
$ make snap-debug
```

To install the resulting snap:
```
$ make snap-install
```

To remove a previously installed snap:
```
$ make snap-remove
```

To clean the intermediate files as well as the snap itself from the local
build environment:
```
$ make snap-clean
```

To enter into a shell environment within the snap container:
```
$ make snap-shell
```

If you wish to upload the snap to the store, you will first need to get
credentials with the store that allow you to log in locally and publish
binaries.  This can be done at:

https://snapcraft.io/docs/creating-your-developer-account

After obtaining and confirming your store credentials, you then need to
log in using the snapcraft tool:
```
$ snapcraft login
```

Since snapcraft version 7.x and higher, the credentials are stored in the
gnome keyring on your local workstation.  If you are building in an
environment without a GUI (e.g. in a multipass or lxc container), you
will need to install the gnome keyring tools:
```
$ sudo apt install gnome-keyring
```

You will then need to initialze the default keyring as follows:
```
$ dbus-run-session -- bash
$ gnome-keyring-daemon --unlock
```
The gnome-keyring-daemon will prompt you (without a prompt) to type in
the initial unlock password (typically the same password for the account
you are using - if you are using the default multipass or lxc "ubuntu"
login, use sudo passwd ubuntu to set it to a known value before doing
the above step).

Type the login password and hit <ENTER> followed by <CTRL>+D to end
the input.

At this point, you should be able to log into snapcraft:
```
$ snapcraft login
```
You will be prompted for your UbuntuOne email address, password and,
if set up this way, your second factor for authentication.  If you
are successful, you should be able to query your login credentials
with:
```
$ snapcraft whoami
```
A common mistake that first-time users of this process might make
is that after running the gnome-keyring-daemon command, they will
exit the dbus session shell.  Do NOT do that.  Do all subsequent
work in that bash shell that dbus set up for you because it will
have access to your gnome-keyring.

If you need to leave the environment and get back in, keep in mind
that you do not have to be logged into the store UNLESS you are
uploading the snap or otherwise manipulating things in your store
account.  You will need to repeat the dbus-run-session and
gnome-keyring-daemon steps BEFORE logging in if you do need to be
logged into the store.
