// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, TabPage, TabView};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwTabBar")]
    pub struct TabBar(Object<ffi::AdwTabBar, ffi::AdwTabBarClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::adw_tab_bar_get_type(),
    }
}

impl TabBar {
    #[doc(alias = "adw_tab_bar_new")]
    pub fn new() -> TabBar {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::adw_tab_bar_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TabBar`] objects.
    ///
    /// This method returns an instance of [`TabBarBuilder`](crate::builders::TabBarBuilder) which can be used to create [`TabBar`] objects.
    pub fn builder() -> TabBarBuilder {
        TabBarBuilder::new()
    }

    #[doc(alias = "adw_tab_bar_get_autohide")]
    #[doc(alias = "get_autohide")]
    #[doc(alias = "autohide")]
    pub fn is_autohide(&self) -> bool {
        unsafe { from_glib(ffi::adw_tab_bar_get_autohide(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_tab_bar_get_end_action_widget")]
    #[doc(alias = "get_end_action_widget")]
    #[doc(alias = "end-action-widget")]
    pub fn end_action_widget(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::adw_tab_bar_get_end_action_widget(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_tab_bar_get_expand_tabs")]
    #[doc(alias = "get_expand_tabs")]
    #[doc(alias = "expand-tabs")]
    pub fn expands_tabs(&self) -> bool {
        unsafe { from_glib(ffi::adw_tab_bar_get_expand_tabs(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adw_tab_bar_get_extra_drag_preferred_action")]
    #[doc(alias = "get_extra_drag_preferred_action")]
    #[doc(alias = "extra-drag-preferred-action")]
    pub fn extra_drag_preferred_action(&self) -> gdk::DragAction {
        unsafe {
            from_glib(ffi::adw_tab_bar_get_extra_drag_preferred_action(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    #[doc(alias = "adw_tab_bar_get_extra_drag_preload")]
    #[doc(alias = "get_extra_drag_preload")]
    #[doc(alias = "extra-drag-preload")]
    pub fn is_extra_drag_preload(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_tab_bar_get_extra_drag_preload(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_tab_bar_get_inverted")]
    #[doc(alias = "get_inverted")]
    #[doc(alias = "inverted")]
    pub fn is_inverted(&self) -> bool {
        unsafe { from_glib(ffi::adw_tab_bar_get_inverted(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_tab_bar_get_is_overflowing")]
    #[doc(alias = "get_is_overflowing")]
    #[doc(alias = "is-overflowing")]
    pub fn is_overflowing(&self) -> bool {
        unsafe { from_glib(ffi::adw_tab_bar_get_is_overflowing(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_tab_bar_get_start_action_widget")]
    #[doc(alias = "get_start_action_widget")]
    #[doc(alias = "start-action-widget")]
    pub fn start_action_widget(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::adw_tab_bar_get_start_action_widget(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_tab_bar_get_tabs_revealed")]
    #[doc(alias = "get_tabs_revealed")]
    #[doc(alias = "tabs-revealed")]
    pub fn is_tabs_revealed(&self) -> bool {
        unsafe { from_glib(ffi::adw_tab_bar_get_tabs_revealed(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_tab_bar_get_view")]
    #[doc(alias = "get_view")]
    pub fn view(&self) -> Option<TabView> {
        unsafe { from_glib_none(ffi::adw_tab_bar_get_view(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_tab_bar_set_autohide")]
    #[doc(alias = "autohide")]
    pub fn set_autohide(&self, autohide: bool) {
        unsafe {
            ffi::adw_tab_bar_set_autohide(self.to_glib_none().0, autohide.into_glib());
        }
    }

    #[doc(alias = "adw_tab_bar_set_end_action_widget")]
    #[doc(alias = "end-action-widget")]
    pub fn set_end_action_widget(&self, widget: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::adw_tab_bar_set_end_action_widget(
                self.to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_tab_bar_set_expand_tabs")]
    #[doc(alias = "expand-tabs")]
    pub fn set_expand_tabs(&self, expand_tabs: bool) {
        unsafe {
            ffi::adw_tab_bar_set_expand_tabs(self.to_glib_none().0, expand_tabs.into_glib());
        }
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    #[doc(alias = "adw_tab_bar_set_extra_drag_preload")]
    #[doc(alias = "extra-drag-preload")]
    pub fn set_extra_drag_preload(&self, preload: bool) {
        unsafe {
            ffi::adw_tab_bar_set_extra_drag_preload(self.to_glib_none().0, preload.into_glib());
        }
    }

    #[doc(alias = "adw_tab_bar_set_inverted")]
    #[doc(alias = "inverted")]
    pub fn set_inverted(&self, inverted: bool) {
        unsafe {
            ffi::adw_tab_bar_set_inverted(self.to_glib_none().0, inverted.into_glib());
        }
    }

    #[doc(alias = "adw_tab_bar_set_start_action_widget")]
    #[doc(alias = "start-action-widget")]
    pub fn set_start_action_widget(&self, widget: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::adw_tab_bar_set_start_action_widget(
                self.to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_tab_bar_set_view")]
    #[doc(alias = "view")]
    pub fn set_view(&self, view: Option<&TabView>) {
        unsafe {
            ffi::adw_tab_bar_set_view(self.to_glib_none().0, view.to_glib_none().0);
        }
    }

    #[doc(alias = "extra-drag-drop")]
    pub fn connect_extra_drag_drop<F: Fn(&Self, &TabPage, &glib::Value) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn extra_drag_drop_trampoline<
            F: Fn(&TabBar, &TabPage, &glib::Value) -> bool + 'static,
        >(
            this: *mut ffi::AdwTabBar,
            page: *mut ffi::AdwTabPage,
            value: *mut glib::gobject_ffi::GValue,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(page),
                &from_glib_borrow(value),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"extra-drag-drop\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    extra_drag_drop_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    #[doc(alias = "extra-drag-value")]
    pub fn connect_extra_drag_value<
        F: Fn(&Self, &TabPage, &glib::Value) -> gdk::DragAction + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn extra_drag_value_trampoline<
            F: Fn(&TabBar, &TabPage, &glib::Value) -> gdk::DragAction + 'static,
        >(
            this: *mut ffi::AdwTabBar,
            page: *mut ffi::AdwTabPage,
            value: *mut glib::gobject_ffi::GValue,
            f: glib::ffi::gpointer,
        ) -> gdk::ffi::GdkDragAction {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(page),
                &from_glib_borrow(value),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"extra-drag-value\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    extra_drag_value_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "autohide")]
    pub fn connect_autohide_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_autohide_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::autohide\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_autohide_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "end-action-widget")]
    pub fn connect_end_action_widget_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_end_action_widget_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::end-action-widget\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_end_action_widget_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "expand-tabs")]
    pub fn connect_expand_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expand_tabs_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::expand-tabs\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_expand_tabs_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "extra-drag-preferred-action")]
    pub fn connect_extra_drag_preferred_action_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_drag_preferred_action_trampoline<
            F: Fn(&TabBar) + 'static,
        >(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-drag-preferred-action\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_extra_drag_preferred_action_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    #[doc(alias = "extra-drag-preload")]
    pub fn connect_extra_drag_preload_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_drag_preload_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-drag-preload\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_extra_drag_preload_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "inverted")]
    pub fn connect_inverted_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_inverted_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::inverted\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_inverted_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-overflowing")]
    pub fn connect_is_overflowing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_overflowing_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-overflowing\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_is_overflowing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "start-action-widget")]
    pub fn connect_start_action_widget_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_start_action_widget_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::start-action-widget\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_start_action_widget_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tabs-revealed")]
    pub fn connect_tabs_revealed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_revealed_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs-revealed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tabs_revealed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "view")]
    pub fn connect_view_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_view_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::AdwTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::view\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_view_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for TabBar {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TabBar`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TabBarBuilder {
    builder: glib::object::ObjectBuilder<'static, TabBar>,
}

impl TabBarBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn autohide(self, autohide: bool) -> Self {
        Self {
            builder: self.builder.property("autohide", autohide),
        }
    }

    pub fn end_action_widget(self, end_action_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("end-action-widget", end_action_widget.clone().upcast()),
        }
    }

    pub fn expand_tabs(self, expand_tabs: bool) -> Self {
        Self {
            builder: self.builder.property("expand-tabs", expand_tabs),
        }
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    pub fn extra_drag_preload(self, extra_drag_preload: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("extra-drag-preload", extra_drag_preload),
        }
    }

    pub fn inverted(self, inverted: bool) -> Self {
        Self {
            builder: self.builder.property("inverted", inverted),
        }
    }

    pub fn start_action_widget(self, start_action_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("start-action-widget", start_action_widget.clone().upcast()),
        }
    }

    pub fn view(self, view: &TabView) -> Self {
        Self {
            builder: self.builder.property("view", view.clone()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TabBar`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TabBar {
        self.builder.build()
    }
}
