// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "v4_12")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
use crate::SectionModel;
use crate::{ffi, Filter};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

#[cfg(feature = "v4_12")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
glib::wrapper! {
    #[doc(alias = "GtkFilterListModel")]
    pub struct FilterListModel(Object<ffi::GtkFilterListModel, ffi::GtkFilterListModelClass>) @implements gio::ListModel, SectionModel;

    match fn {
        type_ => || ffi::gtk_filter_list_model_get_type(),
    }
}

#[cfg(not(any(feature = "v4_12")))]
glib::wrapper! {
    #[doc(alias = "GtkFilterListModel")]
    pub struct FilterListModel(Object<ffi::GtkFilterListModel, ffi::GtkFilterListModelClass>) @implements gio::ListModel;

    match fn {
        type_ => || ffi::gtk_filter_list_model_get_type(),
    }
}

impl FilterListModel {
    #[doc(alias = "gtk_filter_list_model_new")]
    pub fn new(
        model: Option<impl IsA<gio::ListModel>>,
        filter: Option<impl IsA<Filter>>,
    ) -> FilterListModel {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_filter_list_model_new(
                model.map(|p| p.upcast()).into_glib_ptr(),
                filter.map(|p| p.upcast()).into_glib_ptr(),
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`FilterListModel`] objects.
    ///
    /// This method returns an instance of [`FilterListModelBuilder`](crate::builders::FilterListModelBuilder) which can be used to create [`FilterListModel`] objects.
    pub fn builder() -> FilterListModelBuilder {
        FilterListModelBuilder::new()
    }

    #[doc(alias = "gtk_filter_list_model_get_filter")]
    #[doc(alias = "get_filter")]
    pub fn filter(&self) -> Option<Filter> {
        unsafe { from_glib_none(ffi::gtk_filter_list_model_get_filter(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_filter_list_model_get_incremental")]
    #[doc(alias = "get_incremental")]
    #[doc(alias = "incremental")]
    pub fn is_incremental(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_filter_list_model_get_incremental(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_filter_list_model_get_model")]
    #[doc(alias = "get_model")]
    pub fn model(&self) -> Option<gio::ListModel> {
        unsafe { from_glib_none(ffi::gtk_filter_list_model_get_model(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_filter_list_model_get_pending")]
    #[doc(alias = "get_pending")]
    pub fn pending(&self) -> u32 {
        unsafe { ffi::gtk_filter_list_model_get_pending(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_filter_list_model_set_filter")]
    #[doc(alias = "filter")]
    pub fn set_filter(&self, filter: Option<&impl IsA<Filter>>) {
        unsafe {
            ffi::gtk_filter_list_model_set_filter(
                self.to_glib_none().0,
                filter.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_filter_list_model_set_incremental")]
    #[doc(alias = "incremental")]
    pub fn set_incremental(&self, incremental: bool) {
        unsafe {
            ffi::gtk_filter_list_model_set_incremental(
                self.to_glib_none().0,
                incremental.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_filter_list_model_set_model")]
    #[doc(alias = "model")]
    pub fn set_model(&self, model: Option<&impl IsA<gio::ListModel>>) {
        unsafe {
            ffi::gtk_filter_list_model_set_model(
                self.to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "filter")]
    pub fn connect_filter_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_filter_trampoline<F: Fn(&FilterListModel) + 'static>(
            this: *mut ffi::GtkFilterListModel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::filter\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_filter_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "incremental")]
    pub fn connect_incremental_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_incremental_trampoline<F: Fn(&FilterListModel) + 'static>(
            this: *mut ffi::GtkFilterListModel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::incremental\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_incremental_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "model")]
    pub fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_model_trampoline<F: Fn(&FilterListModel) + 'static>(
            this: *mut ffi::GtkFilterListModel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::model\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_model_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pending")]
    pub fn connect_pending_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pending_trampoline<F: Fn(&FilterListModel) + 'static>(
            this: *mut ffi::GtkFilterListModel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pending\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_pending_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for FilterListModel {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`FilterListModel`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct FilterListModelBuilder {
    builder: glib::object::ObjectBuilder<'static, FilterListModel>,
}

impl FilterListModelBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn filter(self, filter: &impl IsA<Filter>) -> Self {
        Self {
            builder: self.builder.property("filter", filter.clone().upcast()),
        }
    }

    pub fn incremental(self, incremental: bool) -> Self {
        Self {
            builder: self.builder.property("incremental", incremental),
        }
    }

    pub fn model(self, model: &impl IsA<gio::ListModel>) -> Self {
        Self {
            builder: self.builder.property("model", model.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`FilterListModel`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> FilterListModel {
        self.builder.build()
    }
}
