// Copyright John Maddock 2012.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 5>, 340> jacobi_near_1 = {{
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9936124862178929657881621645181864085183918423681860187396785862520605717123413406685399380582107113e-01), SC_(3.5736462515171262671173658796361885282655550407797367368767246967565775142270960241294075546367351927e-02), SC_(3.5723133911895480121899640922445600550831965573961005650871698226561870552026541364948342613336582806e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9936077436182305740265762942505880070947367818181132794898773596144577761932318153752214737153329561e-01), SC_(3.5749722613432715628553169307272741195011102329188833383668050964850356815583084732679478209132508739e-02), SC_(3.5709736745792682671599404581373263526701044801333523535341814550620045496488948203712498732057017070e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9935982531025601614500364655259025282505814635665229090640399025716517540590131557526316221367105587e-01), SC_(3.5776242897411389640336798137070232128793830106896650516594399176561812055650730083125160534386857905e-02), SC_(3.5682942269816429157188838670831408020383121223997457406594651516016868258020580067207389880661065297e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9935935051865263915735047486113654526010249743927673270177761276038424843029985650910155418309910845e-01), SC_(3.5789503083121607415749831967541532808130587365952231223694356024503294702063563047398592898634045898e-02), SC_(3.5669544959949864105435637819287301450816005044070102625046909813700756220300841914735887869992226382e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9935411611454537922604681816673279309149514529840821022380007801210707169443456723123140131191273797e-01), SC_(3.5935367048574188596130658870586603259325678077312780894068903977052012489188410600116295423084873594e-02), SC_(3.5522171389827658240024209410574445295562666383769236088207845918964017440183503252721885546279178521e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9934694373075237465634151921066970602357861542329676509188178432941256915556744220631478917655855971e-01), SC_(3.6134278130390913627609094654640317241259878826206151457813687944589213129451776496300461550369058584e-02), SC_(3.5321198095556949417067313300717675686827259252339991668193302765590470280891859038544561861120273525e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9934286167753124814131392571342776632513909244848527380521892160554807524960808842808040249611793657e-01), SC_(3.6246997312365705419622654899909043653736234860893527625677781635672768579458759093245682453664911900e-02), SC_(3.5207308451560232414054205505237899944531489182512040097012760453521655141311995420890008689715696573e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9931097620864165027219465310031542946941250827291810334804095750671116621959312074419161413137564784e-01), SC_(3.7115668240402753402689250059917062222914595826608378093934126249222135687424925800143195563100714367e-02), SC_(3.4329572580251660446610503280495506358429580145905143796049996103343889948196804594921179632733199316e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9927958990572377979840922995352718001556928368962504869163503233477958808920244802834130239693182256e-01), SC_(3.7951300344632531849121062722660432211073826380488963469452361292471727250417761710007993570196150397e-02), SC_(3.3485145517244791669270158219919377826756232555597493366342767643308973856626129103762653029721538067e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9922126738572525883615985096934737542379246872162570557721278008482614426793068921887463636739257892e-01), SC_(3.9457050118640992430999735288370836965982117887075206057330612359482953959031548073429030863323308119e-02), SC_(3.1963362733204485362415093423863407199447848854193799452188513745779920844752052440282754193164327043e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9893032851875707688561830988272894258600328658118144172720086651889951652362299650709125447015552495e-01), SC_(4.6240661385928097466067420828933763850527867003804137146601696125664302459519863236590458981093024575e-02), SC_(2.5104568923475994083987155204747891917416311244009618734097942128126480441578326069647043926175848547e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9858861863794450821691883948411704365274249753358965103850267796074469645752772267528127337525272991e-01), SC_(5.3110928505928287442257797909322905597834515794113431687558113958412726965037911230281021368296317952e-02), SC_(1.8153237543155462803067836701096459698569047964241988599087152572358359059054049298308131438716438194e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9768013419211395389844759575957044763860216650562470815234213356993397846622838414826864478393798484e-01), SC_(6.8076059216184755781840577950311038573406706672675088844600265894103208744445519993559300403103933746e-02), SC_(2.9943999715622324848586115105215220299985513048294403527193588267688062368550605670306861278056228327e-03) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9275223561439943369665678089317248964119678445427980155471655857570286843157774469401717822210675502e-01), SC_(1.2017902763216197969677315152451453633920175705926357660874751861325404020389385327834653677322322067e-01), SC_(-4.9965954272454113037709486732652160303751311444701747699562340013704865808780400007504197732543057380e-02) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.6735637154027865337130077405912181415705275746255993415024144757583603881348060995488920488911672649e-01), SC_(2.5341990932132061632299610199618871011222636428088359622618311788654236921637295363303486915660247366e-01), SC_(-1.8669803992671241292637737591564312105410623529773567523326462874859967205170061052766876529350597205e-01) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-8.9037307644999185961891548066152364082934652825389480690284822126953747572423134779233931568896247709e-01), SC_(4.5523157264515051576165746439917285541212023356220966397336337241653186704837219828020641191437049015e-01), SC_(-3.9749158628350816926566949245343979471653384960565298443009459540951029451206974073879850780006389752e-01) }},
      {{ SC_(-4.0245971679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-6.0719134559454416707104305589573667628292047048469766163025850056085681130949692218928367444627674035e-01), SC_(7.9455564300751576105470945564292159344239444001338371721114375059096583894484473548719583963149859832e-01), SC_(-7.6412041425334888578087126653697299732010050441086783313382612821550919553001092840088361833581189685e-01) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9884941771767374068845949560764111778511322805191229385025226734820765467112509736638548364923940404e-01), SC_(4.7956654648381339311038559193943126801582338467442869043122959184810391359715831466879439189897340727e-02), SC_(4.7946733400930347798831724061773506453356261521274285436701505289849800332902629782014328403231797354e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9884894542085558748198261281226665105707563473967662902233717417789919585586365668107117785676748824e-01), SC_(4.7966490716380906776917513236059635732930235137306330473936925478681743604444507244368925503697776871e-02), SC_(4.7936726935099251332962549955311982568754220652884694250178964216891229721756133703724300833417873220e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9884800053322777518286027010639325944449428672631354491199619955982388715763941232935413635713386273e-01), SC_(4.7986162909457619436784171981217094349436045665061053131020958274641500350267899222178077906620064086e-02), SC_(4.7916713904809832240694854347114515405949031305739202442950366657403369649264440385034724801113437354e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9884752794241685177281814388034819622266182061836822776376735766050551822913199661813487761171553118e-01), SC_(4.7995999034531894188181061791780007699592547063320373697384757078514183641285191596718326417467373772e-02), SC_(4.7906707340354307698066856396015402719730742594732622218887608495079435724059545842872281711027901343e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9884232297543326038608770002890771616117881226724123750877069057326172687020106828624715574982686243e-01), SC_(4.8104197665487255566450445334046446860024366559464112650876503175575173522280411224172226191479757093e-02), SC_(4.7796632962098612434876534391677461366778071717138792900598918391188478278146891016197818628413892516e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9883520618188656094442545723741889112072524137858741950795911346620393446252964875214651661121158311e-01), SC_(4.8251744958997729782856355993831530775258031132830738841168426330430358644767129149212735614987033393e-02), SC_(4.7646525130527562772454137301364959335446518913076001744796272588168522535454015225744735632981096234e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9883116354307066375357648023573603071848031304015961899178849367381945566316461842889014769257016251e-01), SC_(4.8335356988395413823116124116965570034960397598529377901503533920747148842234337683758463899757491677e-02), SC_(4.7561460746209608329387379461055246799942952449896525646960067576756892567585755712817712026688217943e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9879977386187957378421584308268955720754710834656872025770372117930851502380130941673515536407903258e-01), SC_(4.8979707363950480825462856407705054171535100231494828482031076682070644607992828836462101165987634001e-02), SC_(4.6905885124410934801365709020446864739215036952801770179504371287944255612531666050428145953083479929e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9876918533209429301847668105942393964506072473372678163817667069368803591028328738127139425992104707e-01), SC_(4.9599540633605490351595738331650863461228130910801032634454858207552088074852228196398880355656626972e-02), SC_(4.6275198977371426876988957737001427834950148778468835405976221025560682864073752302857007809789671278e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9871309469784108153217075732685412542923014074289296889075241954178785619479870059717722817000268388e-01), SC_(5.0716412324425238255863353821098353785851543326334904112739303539383628170392015657141530299160026178e-02), SC_(4.5138636089666923850886980782504691325294057987373770645625196731894179709070622317602006304584277816e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9844488576463040849667006713557075070979541720020951503058388950804407348075464568603069085585652741e-01), SC_(5.5747736191294206286918350505202186358057536911360398778472260156311743588118293052930563147292452169e-02), SC_(4.0016446286618777391516143355010334736500463418001764201909725908665568010714905993948947357429081489e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9814735532827967677710397737101870105197240105729104487104473579791998615872184246731575441258339540e-01), SC_(6.0842888254593837465209677375391817316105531458115344815449663418792266587914446692533472501724137846e-02), SC_(3.4825673806378223854416743345768709046750138031888498314419767132398576036290680446789151555269210869e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9740891614028336574902722674211307257403319902004487661106801730832217284591498304306253797972174694e-01), SC_(7.1940628325482287597241361278615016700663682648113274874640077382368171632252174028485602788862191003e-02), SC_(2.3507127935975096405119708066286384007170946294178298040035862006877248601460936169907912974591774094e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9386580812885720771543881036114185592162603527038551894003142010982451693350185733793880558188023956e-01), SC_(1.1059274583974118081965374214702695882529662147587735960220843134124080477924950985271860597045874499e-01), SC_(-1.6047980881733071002245323351532727544044505820640210662499575166561878588370181426155511493412935512e-02) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7770751720868602337225044625557663927650378964739536352177964002183487278943805327010254617683253116e-01), SC_(2.0997145233013683060039494252018390385539319437551858193917726127517298314252558445781644356523863767e-01), SC_(-1.1870428945825277717646317404865309708256751532834829791665120899418343477231294640785484115994121252e-01) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.3116172491550869210604328356917347068633110919576522355150591092523393694515822582577605296962969600e-01), SC_(3.6460642075034076257068603620492820863555852987910447137177523968596440610237091398446994569071517422e-01), SC_(-2.8122445593847548343640584102934078992301745144766806787882805675415102615978086733715770859305478310e-01) }},
      {{ SC_(-3.7301321029663085937500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-7.5349530006397163620403736245813406062237802034593398090637930574149568518562456356420968020156056829e-01), SC_(6.5745329323192635869573004529031763302972318915689690884945056744286795067246831990769625391398801898e-01), SC_(-5.9932554142293122580657035349385717086635844342736037395914211175705804938786086520214386851372221413e-01) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9863666620754752627820252475020147472687827098575805975724215207769904389865204088223761777048558199e-01), SC_(5.2199702162706873043330613473741278225836124159780196495841493559190948357076183439053476369585311317e-02), SC_(5.2190591392629523177929295788459506220964230084837110364735337491819997165734145145855076701347266644e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9863619467318447104479269990008973430925186913599511672668859665849477378338726011804002496826252299e-01), SC_(5.2208722342742764141977032860909491438709325492362966764532654425106637807782796568628439413723820867e-02), SC_(5.2181389997841928462636485105437457487687575170507326180956195011114444762797940979716563708354096789e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9863525135673428292278206187332338223774805463476629467712924854163003149762718727426681845912611334e-01), SC_(5.2226762753133938992187236989277867636571272779278061656960295397476074447183378013375953327840947236e-02), SC_(5.2162987119918639317259106756297591840900457325418425123806368491344350494984883848227057737359519066e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9863477957464612303055336797550418391205349080980277455838217006184501971055033085086848174089915495e-01), SC_(5.2235782983487004663663302597853738961837198053046405542670268879310494743035931808742692970768657564e-02), SC_(5.2153785636785099435822763212862759356524767666295100278653425176323427826925044664754280750008856397e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9862958452154333051984095972687357941173650344632978999289957989984284781838950353379172255030090879e-01), SC_(5.2335006623958168158633592799981917852130288606925387280730049982442379479994112361128441946322698379e-02), SC_(5.2052567379084589978834205609634238166228123978768422517467297676921313614527609066483167392588122430e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9862248425465472200248107018421169659818395827055541380300332410771331946804492585196923208552817922e-01), SC_(5.2470314855753265607893255818842033230823923988430897119022227732149066666240707378628470752949541884e-02), SC_(5.1914536742745244058684827181284681949167477713955264834723981267843219663446951841363842523592150349e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9861845252157865280035230263703139744675375966175213943776751738333868096297224688715516061943027073e-01), SC_(5.2546991192717799762778001593923088151912127366510294354491878910905948769751167360289005390327584435e-02), SC_(5.1836316443749336467376415173516808168312504041078874854373068361150252424255015799684310169447028191e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9858718427122621604195983952807858109533441759617105800650890122709038864313422768043510427469575260e-01), SC_(5.3137890523280064789754632093206590163069837822328818317259908492272736449635545004893889800334474933e-02), SC_(5.1233488798252124337682396881042257039225728945487033863986347622840573893513777317065035544623582484e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9855677501257923296628316765985048514689823752371521544780115356718787893062822423902501986556287191e-01), SC_(5.3706303880244993026607211067563171099629039513937608790106120834862509159155635712486425831389181367e-02), SC_(5.0653551082316017942589409834862004346682660963889653162365569077804797114704922714027348738859758279e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9850116204379081756299157780935655505345706895553623437834043512928871963536572063156428433791693723e-01), SC_(5.4730516142271046144413442479028517903170343000540707264974643081443291370646019331949427675922323388e-02), SC_(4.9608449654247580317585691624247831453173618547457596950590366663376871567089695205709241029101713269e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9823757214039824531437352134376925492437300904274522178189499509506778240592449490990904273535919314e-01), SC_(5.9344330540020492752256187117342294628624336773809603914109381975060740423114862008426787798700589291e-02), SC_(4.4898563358414356053425133073465109455567162049502787730010957500408613606610367901249653748606366484e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9794883758338094575136866058310360925103486654705362428533816924396119401138633455918611353122548785e-01), SC_(6.4016541346582900023214887316583635644581409062875758669555656973612871985434419027781393981691967475e-02), SC_(4.0125777745960857714394888192255612102735948519625408710961882687728629203346627996030853278500490464e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9724392033802088768550484334214667734930788649383927077036802253198851175098814721121492822499082517e-01), SC_(7.4192744583652178913525959026264728508371082697311408149287493461545862285328364043773162730137362302e-02), SC_(2.9719080625226448517051468126835953439532771392175881658259500902696088714105594517350309591656114776e-02) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9397184052742410875432651859522822535497528543286712018387510637818223510559541821951175955913850729e-01), SC_(1.0963567046598007667983559704780598064217994236663580136374343582430964610156800700877553203665518825e-01), SC_(-6.6488789140960911816423432807236934674901341709848279530307464005618747598980579188531404381991460581e-03) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7962317983211081206947603411166670743554868018875882149555459461628058479851855041934441319330146496e-01), SC_(2.0084428180962454353518866723655369175548200795927013418355348845222658659835457614413600166372430663e-01), SC_(-1.0111111717415075355920018724236546512009071655708840226929143089351913782922152867865183973038293364e-01) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.3916293410179703755541264374478730464603647247940813059884356606380300948393969707885868258523465570e-01), SC_(3.4347195403599350510907038799273091042933463514934820777324751095190547036506342197740675863720933156e-01), SC_(-2.5138200607073188819020769319260139628528084778137251228657190779086490670429899610667728168538158677e-01) }},
      {{ SC_(-3.6452302932739257812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-7.8471851238709124561975360509985550627160345492257189989580110458673277639735478623541903103007692892e-01), SC_(6.1985228588510547115659139571618058461779189047246863939894115094618468475716059008243553340361676720e-01), SC_(-5.5225294173930027507924031145111838794701528239117593661685925047169551943831075302842648371064143181e-01) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9607785848776209022431466475603351513484345921980582458382746094957548325170297159761221697590874336e-01), SC_(8.8481070463878315770982821077592972275721763728855641658037338346967095662793100070959637844378071951e-02), SC_(8.8475723348907941188124249834898656747086007952861030422958287853070318979276281019982009342275731080e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9607739512488946158100609218059226136302845594496117744453167161541911496112426543645200637091014607e-01), SC_(8.8486286628012794439582947630122696672514058391782521866569597060066777483740652804812710581568480337e-02), SC_(8.8470245266633813155919501344064562577613854144242087948491807083799834824166982255941628543340914197e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9607646831458461780421424421235508595149486502110238817277631333490561786422535077468776784217984479e-01), SC_(8.8496718978413577804320998822013702944382195469852813267671949031826093287597635494767275830144827694e-02), SC_(8.8459289058347447635027205304610786525266720650473452686960762617801805206665618161546811857217685104e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9607600486715213134055421349104677662361736297285455665347683803645529999124251069171113560090020293e-01), SC_(8.8501935164679441920467921301652453066355461176518662413583325171745341063865360175639812822848832173e-02), SC_(8.8453810932335623668294600284281676741374058113938163741884584622315580798430233679358602343200824199e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9607090508503015641025269502202860799831138087069818885621085928237721892633836878113017901022390419e-01), SC_(8.8559313700416882222664471097286336796723383552737168883333700537307778820548068581529592455640053612e-02), SC_(8.8393550584049033070930197240828397477820659423540408286354415586336592909086446750657088641809678169e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9606394533991211234123593779474273203433603834646428399963797763321817774672178241684342895130037477e-01), SC_(8.8637558596164954055129737943321701382349481136650294764343637065900061992949045670632332285107526722e-02), SC_(8.8311374539467780488708833460947257716199814016028627224256673124572259004514976054727755489774541005e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9605999866885666020345695882410004369791370833292554695082761523004367412724505643091081801371702171e-01), SC_(8.8681898106644448972966803247102650430075813535494425968069879667734679260027726835031269212702791741e-02), SC_(8.8264806658637853093126185720604859652550230134639126453883446483971706143978691974452566770081564598e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9602951775750644245870280185202965639916103579354483916076278827865035066622084941036656421778260245e-01), SC_(8.9023591006817728870751910334403881059535659752913013822454799492569923128232234759127121144519732088e-02), SC_(8.7905924742591306414935931625453981436820325101045271020741280796734727381184073881178334367274829612e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9600008609182115140397811192863329053033747112612221568900345683818955327214682761448043444182804153e-01), SC_(8.9352271963755093996338126117043097650045927308289155299361388212760402748747454565259239939405796470e-02), SC_(8.7560681681253233044037176291525459090849619187094522560846549866269719255621712515796407946649090735e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9594677980216884007336597461944106210989241374746936878666588891945076682357863358856526815116034856e-01), SC_(8.9944492892506839604401573883242631209340512231925544319148230673434448153752819815702072991228068849e-02), SC_(8.6938550512063316343310861803804161023773267473722361657836031417977883004389352327154909407700892049e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9570227776753021876712410343757739282532351911881775481389672797467393773755737688011649805634153883e-01), SC_(9.2611954134183441413108302741711246136563578770012013984259998469081568113850786321216173922336463484e-02), SC_(8.4135277266604520563112900670651269118343104210938406040705426840188643776259212302632752226597475498e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9544738625779158049942998407190880458472602545872954849623651583477964237451090495232683368437812756e-01), SC_(9.5312649698406213449381507432955496057072493872064795776489478862186495920756910480362516763566423809e-02), SC_(8.1295258395547339877322983384123315760101310007816042082876123832771260965504416780610324022704504223e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9486678383957730584496745185351334194302547493359581265341362798350472152599895433193334801793628903e-01), SC_(1.0119329233054809351527062808225210454103718976127529055551297769090351569666179704298142369584994480e-01), SC_(7.5104915883547422331087288672145774899891202704000511521632351356865293612201165008058306810557207313e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9257102153333481317945332039184783873856087338192327875147504008145322559697688447698399226532267870e-01), SC_(1.2166662324677297712910383780161039015888399481217626079062370085701421694748745148833195582527702743e-01), SC_(5.3485755490211028634309883738541751352491582456879385705457059695054367858343767192722902041229680772e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.8466578533864954957117076226425724085951544049776283541072356064106115433317095251358886585838569454e-01), SC_(1.7445140063473415904269752473077388217552395659713906777413105584349078726283463006455472850509128862e-01), SC_(-2.7372288525741857493989975966267201056039920784107185046136938470696946972946355399539626335605319111e-03) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.6607729779063181193065908003190880221350385736178375731612789261024189656062868718203474862519186701e-01), SC_(2.5825308264094526155494933981472145878002222237398869053340877531279069044936937859251468749076161487e-01), SC_(-9.3433614118696960430226908167368070684268587816825389459983881332522712757508967927427083296690506918e-02) }},
      {{ SC_(-3.1161804199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.0106659809129065011588392628429499265646678627262102966914886741086499259596506762324416228874407831e-01), SC_(4.3368074179537703439404716374090155584486830079560548568166055678803492820238999721942750414386184741e-01), SC_(-2.8915073855581522080331610134268847719275542933248057349866972078641341979365715185848267260237376165e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9247789841822904171608837218475727030939814573958033439990406898388680006934322406388952663706219474e-01), SC_(1.2242394027042029255912664312690655553944895883946394597930038459582422775708118976823848705525812028e-01), SC_(1.2242010361907238369460242281902659554319689648723427810188901733774206094923564200687514771228586484e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9247744508957122536235783416036743290541560767874149359479406219480533461577038808013533929735475714e-01), SC_(1.2242761530176569279165594051075508774375149801981125058315181353944089389338928328476647905496176067e-01), SC_(1.2241610533755248583788515221214287217464701536907722632854340414436156134172791974845589651366607930e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9247653838922421414440234747322790434210644728664905436520930742110104839534523110627208671278955436e-01), SC_(1.2243496537730859639045343956660490282028096203254695713198614618612376092048657667186991447061578208e-01), SC_(1.2240810874668740690743477422147217708366230942187201259407592621834201499280292203082777666571855646e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9247608501753490458962481386294513321998921211526485388929322110318522495289553723563227973462929556e-01), SC_(1.2243864042150593924477818660559726087467701346650294916855374502845868708890276689462077079870489880e-01), SC_(1.2240411043734237109148742714404144138923981451119251675701307463367492608764918663694187369056786895e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9247109698223946410039066394381667512105306935768661389898665369957237264272403494691976278378091757e-01), SC_(1.2247906619039119737662791525654039435182488048175854889541583090427398665942102517512563097422577815e-01), SC_(1.2236012842241950859003890877003878161235773159632442479782426154915069190618849314240611315074150406e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9246429231872017296451674523926139398568273352597875960622965441890386035252443039907140954559636652e-01), SC_(1.2253419307402303322079550695782390298368736016270664314719306330391604523782455251485455513261217825e-01), SC_(1.2230015113909375022897085902166096858063479269288434453118218858574375098753650399277172934831484194e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9246043490998784050061081838858136273722750195488932135637008002514059335311808318939590822198688672e-01), SC_(1.2256543206906990272442191739927330863014683671368433797314622915705550609280329430412532416530617742e-01), SC_(1.2226616308571802871469956910766526852566342215273731467439295768250524993229520236319208830976552689e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9243067540212352265535085408477816079971289276760980057098950027585209363000541332918922467580425122e-01), SC_(1.2280616646115510430142962586106342851865628504079803347506381684095625723125922206301407692723624862e-01), SC_(1.2200423267669842494946092151191969169001609891017437854159956620391151624578364535552757599538065513e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9240199366962403925175913274459247157551949224038425304963406071522387941241453374356710380661206088e-01), SC_(1.2303772982526737242616622857855144412991267215617230142239322881840481983318631649761692949960211516e-01), SC_(1.2175226209823157659332543850040642815583249946659420605359525821071017960419636619364542996580864012e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9235017724701662162939396816352984151195970004534812197202026969871850149507840916314464735546823427e-01), SC_(1.2345495420522699520475461705006198089626708763034160422895587791557434312424595480972729282923726558e-01), SC_(1.2129822233381313596218553181963739926414470045579598147518088429103214170490520065209281882752627276e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9211459676089248534101250572824287957913707214383007186068381741085656255959771282697975593030285086e-01), SC_(1.2533406118837649008471781278950396461925166683437182986390902022983527734320911079401937146559400930e-01), SC_(1.1925256816087932320693171768934614586834540093424605385445674008560168223508215451164613010702773728e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9187242644537612321836764314799287540392168622145583791365823692255618696132180054936742343117304582e-01), SC_(1.2723635352116128671134002937884385979921402999486504339614238708019132736191461789841680388564333492e-01), SC_(1.1718044520226581260424673466783398339423784140193525239052268555660167270440492662964553737056716942e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.9133237658779574125360938166543390902220750392625021778114104651129239395669421134178884718945778414e-01), SC_(1.3137777258270413413506679357239787835205798071858359677642138620895662952578195959376372415726875808e-01), SC_(1.1266501962432499466685130428318910960929987889043586133013792049055833865495798153892323347125405299e-01) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.8931561572543962899280958498348380776124038712304432875691366263655459780907417783798265909005319196e-01), SC_(1.4578961719475865702774951356056488501656777566018814271525582807832290577594819324065828315725748022e-01), SC_(9.6906022387358640129761586564817277813890333936219620743515565642421544347404486348145944516725310919e-02) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.8312606399671963932166337915190057388159596365868863113339592951594871233999222091262513507714762991e-01), SC_(1.8292933687716117713061729150854874621142580966604714541328695060264689340138988586920046014813673306e-01), SC_(5.5968051083927896786087254221152366873805268837230931562544541537809942261572428596842498852620623589e-02) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7027214158893503665494833604251495431427515623099753765703122897630889411390582404573491152089782759e-01), SC_(2.4201646897767432885411754043772051672092882220708041531568294727773473334038023020590376963105304964e-01), SC_(-1.0133170352039196666031220334828188740532091296761181348017168187180175832637348322346127504857518000e-02) }},
      {{ SC_(-2.7896595001220703125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.2992651495711945386647525805940495633104885496121648459338264885060449292778993959194990188051300731e-01), SC_(3.6774539668051086109254376984308870351463490632552354824475579709790495382904072300435425214043252109e-01), SC_(-1.5481136342823858856902744327814672240395710480184722225598001575916852312692414472699493396907974417e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7645223016394131884878253421532437103709096128766136098373392431453881113675828054954886720441863147e-01), SC_(2.1573372987983443108459211126175914490391248833668571674517098896103621706465803881880832624796172443e-01), SC_(2.1573162243474826729125166489884543404183393338928960595474211505067769921296894829604153858309083121e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7645181370734185743868949312277384697615899447156907870619274778505717126830047249768056578964610459e-01), SC_(2.1573561483362581847785156991916416847359601560952716024210118202898219695623351828715718477666239928e-01), SC_(2.1572929249422508264659893388196394832237710819846015485313133717724751498236986053594341555338963524e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7645098078168276485011446700666432110089507509651597713166758654225284446338100452013061302701618709e-01), SC_(2.1573938474578487546522642760008824684438086172024071892912537876503003354358100143506846372144176045e-01), SC_(2.1572463260118610076895821277604915876062799171610056852729034636406890461589918796654542399257011680e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7645056431262311115317458990815468673803315544759358646108369635807868837520631320186987303608401547e-01), SC_(2.1574126970415251890571753121344219028203369968238226720435437542011668574854856122535935045302155884e-01), SC_(2.1572230264867032482039092255671959493749557224115895234395601831151482200410072861137104485302177240e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7644598287883872697330412777026467951058871331931276597358805720993874777808649477392178039734390117e-01), SC_(2.1576200434686962665856653895166300551423367535769141312144343921626462158970582374166043239146181572e-01), SC_(2.1569667290716352691209591463915498994162687518652427779090955720419672300260064104638951341570558039e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7643973465918878125492598857824658872176054043239265021573327718791772617169379996963952542956686907e-01), SC_(2.1579027915708577422087204690766971975443333621490087909147569664151994178299277617196469891983646846e-01), SC_(2.1566172248016557029009760287330474316009920012468495456472742703602512202586576476991341308433332106e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7643619358653752851142100684437163733255341150423193840997761871054759186894129759824129313807006946e-01), SC_(2.1580630170185903974306534750337488164577515689703348579060968559919768147856406703422475261057272844e-01), SC_(2.1564191683897417198524321388426601677493258512281647479058770955150727109460805935071049935250269111e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7640889643001083491690838087344397411600757739911946984405623069291074264131053874358475141955148014e-01), SC_(2.1592977324196951658451451040599628743856546636264346711627562408395270525390987369322064975448109340e-01), SC_(2.1548928721144564689983825010568409192796094449564417722341697211096271525368750585480271022095794857e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7638262433316325735433155364415120248142124611297151730031533365029542310428476151593530345533874641e-01), SC_(2.1604853829703406030165760886476456183754360169760096449846858165645557998874995894501768576790176797e-01), SC_(2.1534246696557682568467960305221604331735391710331511821590490307714171815830899697859974844976215936e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7633525123461068199093093188837814662721999594655530490710448328086067650455380209768350747510535516e-01), SC_(2.1626251916744528842542160775920325223519059064375097758562428818050700321831103897912730846498548425e-01), SC_(2.1507791745364547349195965885351284310342822274728459188304747877942705100344909483292694351073851722e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7612130449225973594075978409092469630882999504482316342108080287331078714196302631948271500485773225e-01), SC_(2.1722614694444394405295432189375996797761302951757654275784692929765857467720657383478338071094779664e-01), SC_(2.1388622479672195250704717631140892991453869295981707269478716027022267365045034849963881863478436443e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7590373957492837914539323887059884577833493036102306375365671643461684803432545579426817980341957371e-01), SC_(2.1820149193731551784057058984587519493244378076509924350793771652758890967076464881760880115804567487e-01), SC_(2.1267947961695874598312278099359491534865995472691815191576571121172221631129167479187021404129898680e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7542667641334685435768422544474991863514079078167828238550542769055927649647864301960789292213606634e-01), SC_(2.2032430401844442787042709302448523328836677124701668516562091891507502000655516895852690333578302468e-01), SC_(2.1005107601252513849488138919458244500263298374217414203035418110747583517640443145878433922601436767e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.7372995279302494988404045637223193416233592921501766239407698466426442882406493028533968772950501178e-01), SC_(2.2770590469659192085571238934845768981817976379515426925287154772447576899401665302034299308104470243e-01), SC_(2.0089052894887977470786530391834302826727405833789014908439401465649786497519691235543439709694115592e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.6909211967962660954709760781019362265877824352870728295724011040508274127894316631337645042442242772e-01), SC_(2.4669913573997022859643758029640004745878873916049495723526992094260719848911729004389609669022750595e-01), SC_(1.7717080584993774336069026579074568380072408386670087865810682192013412152051626068188455545018607386e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.6090015429740568114685701405287931671369180419012944086380763979907245902596432215152471155061937717e-01), SC_(2.7689509470415317251294197293136078539001333065404622571950623298732838378692538828833687888689033025e-01), SC_(1.3901681011200127988993134048253663714649620706201355995860416807440481245592809505620111524458732628e-01) }},
      {{ SC_(-2.2150182723999023437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.3983122048731509275825347885080734783976133906387656574604586781527188760517593029102761209244940295e-01), SC_(3.4163910343712665155405121567123562890131170912944889895684534914330115567753692246197938141247980640e-01), SC_(5.5355626751963005003006487177267054116150235396231587445804400536294353783732766035566050692370392458e-02) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5777927286370762761566941514618110111188237188948844535667826711205684149425627182565067567658380160e-01), SC_(2.8750454687303206136896746209643124283306921086720679839427837699843633809315334250591230177411702552e-01), SC_(2.8750302542369632439473833453021835518907446147992032501692068985715156489079263730378749022262644510e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5777889176705786975961108268669931985288721930814760222003662722500983851791609273006801170779806305e-01), SC_(2.8750581643762695666257303210198293328409724570982434863917441542045254618672869384202267242854938545e-01), SC_(2.8750125208707667904364811347773469157575159805404224131580971941915998782438201556335353111279276510e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5777812956747322997329102238854974645462021939565373671625788788839123081181127603619883216012749464e-01), SC_(2.8750835556942073288778576787727215236628500238369761403200602060690010364472210597704959292783203779e-01), SC_(2.8749770540626913796297329475353895785369329174256331970688191869679225176766380018511954147211689656e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5777774846453833913592563809646810157295360276421438596882346309036536197396922520584104748389985478e-01), SC_(2.8750962513661960383240207735396127372297483443850893117273570219189197044397126229100287048187576324e-01), SC_(2.8749593206208124982852293118075398392605528370150182091341511236508019548953415282832665209188588930e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5777355619398004669791072570446306598968064979454060484478802948402660310848200537639411869544207696e-01), SC_(2.8752359043309289080766253363407517322092730862062109019564763532988694017246155016412541926283364437e-01), SC_(2.8747642510951447590956309654234689507702056044494966065372796163358121937297156225447873193944654346e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5776783905285446578348484892720410082889814810971030036395834242488083919710145673915467924608569636e-01), SC_(2.8754263418843728754985659416178195408237546229427232425015625301063782688134015247735622624470781589e-01), SC_(2.8744982422772552756367866745072553777827573288840145655276533163938557579957358763522234980824788095e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5776459913029592749317762683084655670277946083281858887782662643194672484560438480439613249228776904e-01), SC_(2.8755342573647691719712959725600577891864623958860520336794267595169315388788573164912010752975145350e-01), SC_(2.8743475014276217379104110375164982840656333338538935801518840081008750669580406798932008994365197344e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5773962759028828510480314144114498619479288590494308188527690952423949649143614997115261199009806216e-01), SC_(2.8763658623898300370760072785452726699193645729289400751701212143590895191938025948033705737553252326e-01), SC_(2.8731858490408850068175363755007610798579164820540192632956783220151803409912928825777152399960027101e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5771560068045551187296340917946515386999654026696552804596704592541469997434760988941862854900189519e-01), SC_(2.8771657618787674202031042481338148720696580261079655976350080068294591495872362226996943854039980984e-01), SC_(2.8720684324325494486571179310225159267481743231738824315670324111562354235483059823211423937840866462e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5767229311194527193415061374830941703028424722021891220910602449601741226357514852058193016686324805e-01), SC_(2.8786069374909173323458355034911796165271052305602646822840614069841350973564576746593045978103234207e-01), SC_(2.8700550562417705148084828483198349550892975768468925534231392352204467017434614149475896343417419242e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5747697908587597778663774085198399002710430450092153276421334411767351298763564313243856020053641628e-01), SC_(2.8850967838286641338665353989085938134744101870755651275284148454543423982974261784912519450147172382e-01), SC_(2.8609864058411120335930092558614824462382920083855209483576221675582742556695361047066799302423961800e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5727881407574909367960307990436003766676801568877313783111426156940937885801333255183290134457148504e-01), SC_(2.8916651279449250721790541592544299655433371018772482467616461038188927078160725334720186857224514392e-01), SC_(2.8518045783497482094081047905193873306540314269383658541578793699080998994824693223796819321116938406e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5684585581901473790231397999294687548105043221062183033375581966684799216947011157013739205036024508e-01), SC_(2.9059595351962019369163179653273887368922884214535504622350346410693417656709071760989057004726402040e-01), SC_(2.8318104296518292430345743487234682990343598360057555360312941422930140667325950932118807005696271840e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5532260777581130782924762453744149312404495327764735071654857396938010635242575615538892743140636877e-01), SC_(2.9556507755894198016951098455574103588090325139279460571550555041805343230410159797690241311843727352e-01), SC_(2.7621759326257238004322599177322781018906534449474978683919907644662760706163067078457424348716670868e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.5127552042653195868010273099982829643735313316635566427418327674480212052240604929109384640480603636e-01), SC_(3.0834215449274978794369072309101044266500570616637243601513425315075893353200916168007867989163770440e-01), SC_(2.5822004511273380563042055581765881952858402790467664432191424852282180492343190909512073504968024626e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.4445574240503090047253451664732463152579873230079449149363938440606791920747377666842443805820437125e-01), SC_(3.2863863229718127062767500043787876457775217638131422950696666119975589228566950792987261412683829300e-01), SC_(2.2935582885125495369348341635743566943485222947175631925671705490045410938087135005018685653947329147e-01) }},
      {{ SC_(-1.9183297157287597656250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-9.2816653959119849102876953999213384541458751396862381216223969111852085328403576824570078618428182294e-01), SC_(3.7216511763369248371620899865347425585324897579798863408269566698424328027507640476445448575888369587e-01), SC_(1.6630555159413075786313442987670388658837620999863039807239512807812215958708071036730239446053447556e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3724132107153170291643348867332830927102023973164695769613983600937750184890972377671883334672823159e-01), SC_(8.9934422061167531941641580612058171822238037073425154256049779080373395366903795674081388010377179030e-01), SC_(8.9934411924699231703675297266491218038459116065194943573819557494565258108141223138583132783618779787e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3724129338900855501494123574182878230888619647184227825730724270389260092648837682904340342096929074e-01), SC_(8.9934423407030688745047327741730084811922125108259638223274385853508877194724599822153570494613148751e-01), SC_(8.9934392997612165889498670882050364334551044719080201049074919896607809320161507299135701505917340148e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3724123802388472268110468556873800094665982253957261177552037695814080944012997873639491896262658810e-01), SC_(8.9934426098760455956839095747985302369725096672866227713542906368925146155555138677199482097520990569e-01), SC_(8.9934355143386999311279370616875952583071924530642104416388589243020216386675481572346693599069392951e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3724121034128403825207463235195310493340614708401227940010825951917717241039951482532516414701326178e-01), SC_(8.9934427444627066364483291605668833158846945826456179605603675984876154155346912762782304141060891447e-01), SC_(8.9934336216248898553210825301485441982917906768120566510492288930284915490696210379205770316709639704e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3724090583097070651022159086216393141824200498185903709106381809715588649530612227112975280203907230e-01), SC_(8.9934442249235760011253748469632540043878711003273293034440326841135398288857087375765541990232861773e-01), SC_(8.9934128016607022500284603880632823480522804893882653931645037307070177757369618897437341723848375391e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3724049058459447538580066559125222995731187980728262589202335293596000844765468188458692727250898832e-01), SC_(8.9934462437563007313823143694673204147460686539859410954777416501288525658076864527366529552510147149e-01), SC_(8.9933844104687201242230447363567258424787214009079717042413910061740369647809634056721726890681912851e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3724025527573329512829598040962970047688257899465300449619990017052956162263376137439281426224130475e-01), SC_(8.9934473877730089402713650264485305035479712540556883408888087221866738965639756923224463338937097880e-01), SC_(8.9933683219566938562635395680130982033332527340547323573323130488153506999096190094221817963896099727e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3723844195069606689868157440210809057273071897855957211818917489466465047402260467953276821908035649e-01), SC_(8.9934562037101608703409351037439923294241760060486083254346618781617595426208523858356635512942781678e-01), SC_(8.9932443416530528505042348556534902867044692167507364697508014696662270937425686615862708761654544445e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3723669773192264103815793215165320060034762966612962549205215851768748377224931804761691417690919041e-01), SC_(8.9934646836271243257867961535815288674814200211511690551041497214161584270579391695055766785318371510e-01), SC_(8.9931250865363024197229751917913480860232017134401948709500737193791982814113232479685289208099304620e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3723355511065395328634464065899480796544861110265452806215434615732144125062105408463009534416378462e-01), SC_(8.9934799620908631468371772257389070756684189765853429758947641493105629182465612588563391768809448726e-01), SC_(8.9929102209933550824703160216264171680267529795927953221453024438422747479247519714730358289588373319e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3721940226907729708581857444017378175404070824190579649354686412662264066463504427111773292472376041e-01), SC_(8.9935487671967997511717624913053797383009648548561937835092725967845603212934924298332342528008775141e-01), SC_(8.9919425813601346557868741002597352037953369521754051530989427244721832778735797181971734893798346702e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3720507638153645536564733326450226596932852963154362795300936338591422477288556199421048674939951415e-01), SC_(8.9936184107744691100287354138751051526970363919035478723295366653260837124939091833538393079791307899e-01), SC_(8.9909631280078300433945313295268858911715452784651940213019533197259811380758272517160352330848721885e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3717389303202092368613264783153594639263000299357059706066220101179242115288557176254680480722119886e-01), SC_(8.9937699951201060680348506412781450708178563169658716382359924796743410181930215203622556492874019194e-01), SC_(8.9888311999587851551393348849207584016067712926702029585667584945447714037418182579807074049567867718e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3706541989753172962057934952895426991612413289336456635103913869225303356104685576471683673608379800e-01), SC_(8.9942971861607634742954995379245185353277816592102706119686345465783687332639280566903912692148557817e-01), SC_(8.9814158133630226188316448041445751937875304884939657481991718138897840320248538151971666616040515430e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3678596131213107649060346543600531142149833036638073179748070276530692556738157234993372484575566721e-01), SC_(8.9956546398838452433997276465763509769888766750833148068470860377722270978251691971970684658055289398e-01), SC_(8.9623162691068753806358007677732180372137696455932887487131286797677734497701338110545678229321028304e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3634023279228020740997701994673535229871514139005837222657769859589574066787515803712280049865951970e-01), SC_(8.9978175200810708392298633999204241933832873555458874538142450105446753985050350002969856251481049876e-01), SC_(8.9318669478677173500975140463484200326229345168886610399536638708327814215183720125484216048157760948e-01) }},
      {{ SC_(4.6881496906280517578125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3537511822129500445383231165021473451054340260188328134335620309673022190964878818066068764999443420e-01), SC_(9.0024913575842626220464104601901415690588608809908414537759068320941781867863590268919994743030629815e-01), SC_(8.8659951037540444573845969843838105482698731111733775715854234112627616037435333386457191807783697555e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997988444216776382165137981817291839844667159345037504831412593031580859600297761432225285837794802e-01), SC_(8.9800762874613526355156456174340998678407542959823116916881606849001450362654501615869623131782373840e-01), SC_(8.9800752595495896057473083495747596189969753753938589403461646310451715633043530046322899700595038790e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997985622066471341467024580634653950356486541065289137716410249543184776683383195488024324520665360e-01), SC_(8.9800764257329302881239089794628645283109469629815474375393321875175008705358340919032225188346593591e-01), SC_(8.9800733419962608575016698710013020055841507148972489954534516367619021406188274408176673416878711342e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997979977757956490979368366856913367359757054194452959827619152989782100152175936201588555316330650e-01), SC_(8.9800767022764398938402791046767299844769652523722097970847076386137192232548383709906185013341478426e-01), SC_(8.9800695068844362974474696267347302877593402791247046451383820896441680851753651256272638043596879092e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997977155599746681528100660913616759933128199355742455540469955621746376554013833208514912719207051e-01), SC_(8.9800768405483718468712168998183459152548315245547671164382528623271528726183073931348108310109184856e-01), SC_(8.9800675893259404862509639437155589101035893270796802670657770115361482179609701321273955694587781523e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997946111685533924531406480953457703290130390552367289980684914940899553267342278039190697434289977e-01), SC_(8.9800783615474179259285937305216057873630461380522698933428201677634533197707562014783226739873162016e-01), SC_(8.9800464960688112858925389471898779457696839589387693430600422069168901815607323090842324210636437279e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997903778561434305142983351546404652941605833758680434546579707320988585659307162353614698346628781e-01), SC_(8.9800804356600556351817459546514081339680653693719906255117971580243289019674705362366076326168433069e-01), SC_(8.9800177322005041398616706170346890079607120298078955592521980347502918256392085780126864628750079389e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997879789527948697481713210540621795313935823971624589192120073144792952520870004144207046406933417e-01), SC_(8.9800816110023454891102779925028855443767877740689750243388544768269924916540593031523109656377037363e-01), SC_(8.9800014325031107426327571413992720114441819381600523950628916306682525399787551782867938866775227040e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997694926472434897871580497789166345107328224032883299067325578748621382579791044109251451207371966e-01), SC_(8.9800906683379660415108267422514766563578622690079288176237473796878839518526856960071997109787662402e-01), SC_(8.9798758247785241577785883195926997503338373049411786880753519457707813025727266555925157811208987487e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997517108593294627589274161319359109192749515241405026151010241703987392413053113075625710200938280e-01), SC_(8.9800993804517777927199011280126197228679044794328959866970341227595443818812247865149642992394265384e-01), SC_(8.9797550042703645307906350314300347123665259421581057138167970107017631564243147684656814541693378830e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3997196727768172377016395992601664907103301433054648921064411359760403528396185006247782161147681752e-01), SC_(8.9801150772682560457457368310566558009738946920059633586322286764010689468149248068108392372845244401e-01), SC_(8.9795373183259035240719382682827594695925739889048115924638951444149466679220708370891130262027578283e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3995753887953938209034696086917159810611815246357281928545971472132622613206937078833393564036511432e-01), SC_(8.9801857663583919481477313490999849844890268673592413980592171330741107530599555607601579027940398563e-01), SC_(8.9785569772930191051961571163771451139796457565029032849463043357087937942543225379379608228218538378e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3994293406608468373756621685601436424178573396755667720990942107332363627403099377668557607132770050e-01), SC_(8.9802573168329907532282126407826328414833400451350253882673242009466736580309708171107601912939334043e-01), SC_(8.9775646677759221489881212000210731367665224625187607596952153999832607768462130481231820257519446272e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3991114357436656849524574521212103801452736033207916148932479002756353915276673694376547337859165262e-01), SC_(8.9804130515199190551237440797303401386824613402464414333734609772870418127545709966328317552124331068e-01), SC_(8.9754047574004721136539910209883706191814664563620907559391132241254296844302300194333997954189360194e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3980055845474745926725400197224867778810229828534072294087109307875266466640608772757173348412017716e-01), SC_(8.9809546752162838377374162558896155116520311950275442905380849675180838845935682196593621191922712021e-01), SC_(8.9678920524581828082982554491795169140129389153593220162788476374764415975383564621813823512920982762e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3951565874285551639550213250179770496764561185587140604434655997394265609312983242296014960979903131e-01), SC_(8.9823492791130860882382749141889603892555954328585361599597147458322988252709297268308911238073759327e-01), SC_(8.9485419296692036745106915436796445858698696695731296439399514139096973250908863582944278775906186501e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3906125168689787181772917261713300203470129981346745447177547404826152211996486932881620596488163498e-01), SC_(8.9845713156896613322410661790347342820551124657737052249530025584478450473152962207819061013392778832e-01), SC_(8.9176933667626492999547752053538209540477367988156938034902178562730318516336147150042637964058744147e-01) }},
      {{ SC_(4.7220587730407714843750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3807734556535857868445163897353883762728490462168948148772231357754341259441430412403049896237640219e-01), SC_(8.9893728329756654077151425577056559267864658009094560341165329041228135449109869042792919921745470437e-01), SC_(8.8509588537402368199306765063479713585524802994930839058058809593111472535541470864876826361920091443e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6767446612916377714952797905110826804547646438058443415697033981073140853711371806091232113036912887e-01), SC_(4.9713279999158235108780438457168686063158513623014646604878894519072343935772307987633380341054824718e-01), SC_(4.9713207786767002013289882706063325113682601020267203697054041647525097317328981186446329053357696369e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6767420836920006357649463997083666775720027170203751479247606136424707599288236024730698479780017529e-01), SC_(4.9713324987460051237107658082781035128829742707926393262247233280991835391609316375221149300719339226e-01), SC_(4.9713108350193128490375876384625923085275506655389116201480405539133164099863917878364878876173881306e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6767369284787897832215634762770624052730250722139275008664265025615918474766237185999757476555412197e-01), SC_(4.9713414964144694965392562662630112173080143530561171488974107610423629176911046024169016828302432117e-01), SC_(4.9712909476753499503766225058669306626104284090309633777467584269890737884114458420038803164304201141e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6767343508652160572029129514570220243305871651068290252336231443590260376195607588505887204629260783e-01), SC_(4.9713459952527522434876671690838675550780040489815994592534851454478971295371415974922968041157723089e-01), SC_(4.9712810039887744154528606088840065019866850671641153080578287266417620143227976474633371710988351170e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6767059968092984644757307971832439249540475779100775390980238926187097151696119155414794514553038355e-01), SC_(4.9713954826520851141147945580548056171700182172675832902339309539894549182856248974595100500950549486e-01), SC_(4.9711716227943055278823676080360063883965051003611863179274070704726184281424188369042561397507168208e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6766673312817014227756710300947265434353312732403596838223668032877780217332375822904809382058977082e-01), SC_(4.9714629659959126939549708460488804986466137638053917741430553474175040653167384160497024691128747063e-01), SC_(4.9710224647228138973278649070483727362539512295730640241489495099288352162486665463498259446038828856e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6766454203520789052930179113357508707113323558064702413931397400998086102868813784253834080005722509e-01), SC_(4.9715012068270984135625082881646830260009664714982140916216990277750263229158220765606264722879988283e-01), SC_(4.9709379408439268268000609546478457233002510328748759009915123393597398402157737054252675017068653706e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6764765660471029512680822201519444656749848556684738889256991994805344852553576925657692091875839744e-01), SC_(4.9717958927167829119070052157483814141005455281973825658241489465374697825013562384150589864944419787e-01), SC_(4.9702865861987918436899144732608718491001032726136005669073497664096579272361657229427285261111353492e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6763141377570984536833802140427241029931737970677531728245865622628731823634890208842320401507824959e-01), SC_(4.9720793419812094946290326014520176291843979500955333956595055883944025712152106376342676841571519513e-01), SC_(4.9696600530381638818316538710383663744973925139293709923084440431828628791452180623032631446674785685e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6760214624726541677948210807500610664752982111652506995631959174829367356653879511081266138608454869e-01), SC_(4.9725900276127597877091074395703188101204051458122059415212919592482167714541220054380308539843169406e-01), SC_(4.9685312014091216346708053554253757779915441885272373057246417395950373792394180777832435607898376195e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6747030374920571122366995125570881709187327119566313324150443773927837806777269894626982976627569450e-01), SC_(4.9748896682565813440365278431858183927401074428514276576569356291220908405740065432412617643687606827e-01), SC_(4.9634473305772316531092127022226374591398583832087748961383323782125713872774547485175937222777976959e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6733678965218407764936941755812533347891714802033268230866637640260628380134483216687687509304305129e-01), SC_(4.9772170267715169332264723720202930995090619303138913508571469042565575308929079279121116334712924907e-01), SC_(4.9583011822829073499107180566916038627978675857349744114482259899769570859296558668331644217958024136e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6704596064310165821419188007686181549183238792340282786058033212362423460340994797719203259261416858e-01), SC_(4.9822816272515247122135017140282667099718057944786150696627293093238926483375640329984732536571445961e-01), SC_(4.9470990893236306502659397825737149709623941341504525624348756862937127693805596210863158268659478254e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6603208665598449910602865914333497639336195890776736767062646179224687145485240215846913020224190522e-01), SC_(4.9998842474829490324442071983217054776455705253496534284270184349810099933077361185445758813274634749e-01), SC_(4.9081277509252317366644439843299112310308742704636343526472480546614601767125727668810334045525027511e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6340430364625197553883556345036354854710869118341972266145957440098699391145167615108855654028180533e-01), SC_(5.0451264448488376571022408278619670340237884390156837794303747492040242844463615826984142431488464124e-01), SC_(4.8076984375485726681673091073200861104233695492389403674678077269359639633511276339018201911772246326e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.5916644280228734528596651590648409390750893496789615820273596257504639631949931188484366306080524583e-01), SC_(5.1169622195445600879609593097034275417407973777141632051068954805891998553293538936694716551171014677e-01), SC_(4.6474473836773829841521548720961063244821718787973381170636401749699894353965484891859071368274424347e-01) }},
      {{ SC_(1.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.4979688725361352652226180862274268750093933793149698089023332092307867129497613387297468935774837782e-01), SC_(5.2711028297128605747142637922718611697822380863488303484340986209446315471775132123510355739999797984e-01), SC_(4.3002877292707948429437834035346964911191686292569142564194199994940425293021728449749181673364983504e-01) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9631361252179240749397759697088929083277704274889891217082505633919771066179060219064432176178061527e-01), SC_(8.5785695216485244025040811470743620684530196958252217496163426754362154102799097177803727861919148124e-02), SC_(8.5780177474168222068272095318704121695741268178503282087170485703534804285487947314019399726053513086e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9631314845567116498134235892475533083285010925507928739030843041110758866231956664275934687725438284e-01), SC_(8.5791084702011724369668732009102319046869657352933113732791599214669795139150758242077207908628762207e-02), SC_(8.5774531457836957272486241402103887451990608945609574435266718206565532020936261439769457148183572388e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9631222023331405094865663036966386639661245541053901911341432745665748268799306371293039680245270796e-01), SC_(8.5801863696334241279730669768038923808216322966912814404481978206278210670718623998452919964216962131e-02), SC_(8.5763239379550825558795692562466636961612680859139672772605929868935146994428255356023460161217956693e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9631175607707788546733585166965025012657443315167882917992616908149393144400437248320431187533440796e-01), SC_(8.5807253205129793133712376873986853434676844277349075303580910181679258099940746468474306479784072784e-02), SC_(8.5757593317596414837537785041061125694340954002591290470100667895064117120825497890150890604711579315e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9630664837590002533536398547952878399213650116588225364029701118184953924395489092866441978226843082e-01), SC_(8.5866538313715124454527648333119891914573569360465598788090735888373543457871939238608933731330329248e-02), SC_(8.5695485632468981303829250431877408616382686700636992770401659754449701320569637357254742925376368722e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9629967747095855540180286949083268906222167915186819154084839053286686465433217086078535044297762495e-01), SC_(8.5947383155416416225483959637808740930131468572443636662212104173830690316352151853757728891977577500e-02), SC_(8.5610790369701066872622659720103233964408660273974494057225721468249053585694624402247891446382086987e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9629572429103659922210670090122412400703664068000696594902600706939845440122402430800008176283823535e-01), SC_(8.5993196006421259481291988383776762852461497827659617779457575154105379730510362894423162469704860949e-02), SC_(8.5562794869183990207604354215154203005903376544173172727916591223452792272449174174319857253295539913e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9626518873403922121079682589686257556025307049454744412449612794206592466708227572939700929418828946e-01), SC_(8.6346243211440357506829927607555011935066031810384491974390254410115958338007450783579840806252246456e-02), SC_(8.5192910363525612937170070458343629405377297520579289557097202714944507103937836040887620540120151384e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9623569700861944580884996512507794315079143898809387582459610300253780370119765577296967585350068316e-01), SC_(8.6685846628790514418475229402976350152389157404548481291608750784001694115606642637682333091408152772e-02), SC_(8.4837082123546292846568481423409194265640485974831926782015378678512497578958072054418925255207730765e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9618226394834684921759602674457573257497084119930854709877202687576847310000511000154792448207482866e-01), SC_(8.7297749081784516396524541385396101437027264167399473010512339058987605995877271122827094008481014755e-02), SC_(8.4195874574730879295693906155460615845412269929262143784454516499148004975681791182565753323728473833e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9593689497395453542938297305191102838163220328959373499999171565445732018195385537264035050593732936e-01), SC_(9.0053879592376547572133565548257088797161829971987748663503390543968603762674489786675577136898201037e-02), SC_(8.1306616726550021959242513096207640297309994343399011394832325483634025659455182083806615089840864169e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9568063192665056574250539129785446736666324025421587460091708963101071036314477947814422606676508794e-01), SC_(9.2844381661712832537735122641846886081866680676784894582807767268203081377160413139295304245671137640e-02), SC_(7.8379441157057450438199232314739205420168926487513040858304156278758117609580614849529631336197351005e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9509532192185896689524430392339939918438280193200188613861459507332673425077186770202041228138691281e-01), SC_(9.8920676752799608975406647590814829265774026653186255982112989751708454179933634809678553526257929718e-02), SC_(7.1998978678773365478104206619759681764697467456883479150672254633972498739366528942592992471175608306e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9276470443503731623093915175515601460049310552213641705688266103221881759531254418168504038532653035e-01), SC_(1.2007598272765873498053046788607104237256594769472099927673978687191499701443654894367646453380018146e-01), SC_(4.9714579750826903814950577599658646020196841291910101632979533674785291524964835922838956724589832588e-02) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.8463603280996395890944916732125856554052034256737836826754525150785484679780590421674252757823722482e-01), SC_(1.7461925120746445984267431182631550820245202313575003004191428396389091526930361748301736928133335998e-01), SC_(-8.2415281664681537780948610770735361376543148655872887421478044112290109494913570870076188652536283829e-03) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.6529037287145381351645187803441522212864225076615147246830447394163541333088251678852362352665859873e-01), SC_(2.6117904977560827242841200427291689855863903309451766739735067816458150652846376677630003657382106293e-01), SC_(-1.0170582290884158750840884171696920012574588032646248143292301903044451730977668423092774633180868275e-01) }},
      {{ SC_(3.1472368240356445312500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.9704144100125342306346336809941667657851901415872655754321675752520430241281389664209014817739517684e-01), SC_(4.4194643694275302318441090207824330618632419373003149266901228714563337890801498384524675654959998680e-01), SC_(-3.0294734878419160996012304018016819212689793702501478484943446547705478786713688020487495966465472391e-01) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9754138755720030970793297509759293264065659004193072400248714546179663865449020235389728059534629979e-01), SC_(7.0079812431651749703912819252108896418684900420626039736933612510492475460209601293600194237007046520e-02), SC_(7.0073041318178579953232428106102001136362057189015462805326475667631048565542730456834559013359191313e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9754091969145524634616436829274316391925942853476725247311869937478885661087098373159614424914069462e-01), SC_(7.0086471883849558965889488661605128355358940511369982485462302225021902706666892327386795292524453925e-02), SC_(7.0066158520427500416241463578692430630922333495064668600092486210853659632499331478377357513623160664e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9753998382367907186214480827752285017742181463230973581481901445175553908898008004896819119361465955e-01), SC_(7.0099790820330524263847272238050670407638577586649447099754122750109227077978927547593345701123000014e-02), SC_(7.0052392865003579622050048587814243740044685255579585598413694582601697452925032079305475170713167692e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9753951582164746790481212595097492697898686225773889624342077388786798497623242406457867987979434531e-01), SC_(7.0106450304612777872918864581259170013558719059726598315907651809895702818479533874061044143116092974e-02), SC_(7.0045510007331600935517770964753346623560331239754165895885365317402131623838080598061797907110777369e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9753436480090919855414595913795971684610385694106010408721923611774781701352939690103029566792328785e-01), SC_(7.0179705337416509814163060050445772409975539262134064652712618971066658446369957721703439505284296906e-02), SC_(6.9969797254831874806336002584429036274699043916805737706233525886166441560622212294554805881405162350e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9752733182240689677445539371047855330443541829241462277686845030260552002720326747902756106821136710e-01), SC_(7.0279600648194671232196601793828604939068595388023957782438068507002056840781438300211573080687688143e-02), SC_(6.9866548698679408811207520025056205739539808526988316844551676278774116745861172784412328972063099322e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9752334193008058223430164249743676648866724239539492545729628534341226620166529071967205708686481804e-01), SC_(7.0336209057949224647722764399832850489421933865699870399952647127107410384019667809046273004617534484e-02), SC_(6.9808039189772751882470409344707857339334908179714238730082631177421549882429306821916176783639050363e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9749248615928053290290017579770057799100753116137606613207701119427838010341539286299025213152263618e-01), SC_(7.0772452661876389863615086041565849894757904910417126512418004145808020985930808256214663450839136804e-02), SC_(6.9357123449548807282135057899562634582731503415629328403315055686703209825621066339550686226710367564e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9746262410425366490719511854510342171032263532012044536546764927126123894762678270017271062403073122e-01), SC_(7.1192088851615778876907077604728627065409096652905754510866292233062576283247314375705932812757874606e-02), SC_(6.8923337562256261851015855367037554874145540707897037491989298674792692596875111711705827008418212297e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9740836952488351249037622928864423086821521363557893651743450564663698646301202455796191691481898951e-01), SC_(7.1948206382879500580362074968097420896651899695610972306325542967047499169973852165879360774358745426e-02), SC_(6.8141635139441864390120679185721056682501338663275702980569712474612050247564795171298425078039328963e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9715683972024073567452561223136419989937236818549155339167035517462654673124722914017279570929725597e-01), SC_(7.5354077521671830713438365655876247476766599109829734914359214172165810610970358569519940419694105756e-02), SC_(6.4619093827654020339580186420815422710269504694013412593505833450691931433057341189348511070568189665e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9689023301796201072009792900641326180501874853889204633812595957377321668001773114083216688911251754e-01), SC_(7.8802685952912828971631246398090334529072790898436636741333000205724412471408934595086157859837043617e-02), SC_(6.1049975549324923765299845260851770208148119141475710476387235862928865367696219318456794762157203009e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9626808562401826239804235275950556562257787707439916579999707482484045015375959995505816447379900732e-01), SC_(8.6312812299529529591927465130857164423717877424741733456716511026704509096179606816458865004314853148e-02), SC_(5.3269144917604072651719686027432963824629149042071030866408593064451973918400296859905231668379308372e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9365558348230127126050785600859794551880981688747355813638538553245621884228920993765528041793122307e-01), SC_(1.1246591223320695145831318406688014032355387301421746775569500674606709419595599883217349285096839882e-01), SC_(2.6085021345764810798929204889375410060186876585649046810811508390639878357087752626390084797332989150e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.8368891994667904669703666463518777253972260990670357238316599248048829381551067802257785624498212222e-01), SC_(1.7987803860987605824656854953496663485972432943542644057972855851859817482205128619747614346964862820e-01), SC_(-4.4616696493531111424629776630043654561599442220130927783685464389918662239562170360310192920301675915e-02) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.5809228247207594007317739175817575210759152374123715811124305974400968639080393930795032473728664990e-01), SC_(2.8645973236643199512394354825535276748857708805146818198157772490226931077047247139830998978537671770e-01), SC_(-1.5826752227031233943968410486202816278099730556203208343474127753609160528752207566548873588559536386e-01) }},
      {{ SC_(3.3500852584838867187500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6345170424252812271655832422484810457786465412599053008332172072309755367943666769073735565136755637e-01), SC_(5.0443151610567885123472866231323159865579660028326853089582047424777950358458652408341215415047020828e-01), SC_(-3.9814633440772074108749698171245805082867729873126606966202913260940131608999969287743633791000772725e-01) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9940240167922922875149508894551281517911268765632268757938585370115682739925473162384589482815263337e-01), SC_(3.4566450754865684523296501016390564539810259178825128034687587836943480054597652973550742145450125489e-02), SC_(3.4552669690384367507974231479516644232162756634374280912692858465466527158231616284649324168189781129e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9940192724849677478107791751105149721490213581969246312691986691727498455551288861829128331772672265e-01), SC_(3.4580165008142453906661601707168096167064076665522572911652881171868749740515635968971956786838915086e-02), SC_(3.4538821754275253313722801573299761795905716267828670126324560466526782471624721866897749744863112195e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9940097781860046880134284507617303099217861687746847063867059053136849272442433230763181306819610604e-01), SC_(3.4607593606393001338473378425451455615050071121320928936401016499238149784760784371922502670555396623e-02), SC_(3.4511125732087937975232192659942605287207573734820566445719212494943556344064625667600274262629345661e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9940050281943382847479829741372771917809341591958742605963173228975862775380892705885968735946188022e-01), SC_(3.4621307951359033852384080857253525972848462450194506486308902488774530428761562197036199246934094987e-02), SC_(3.4497277646017364504367265714312312473033717789613349256451161354614788629991321450057405238020681651e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9939526532255805842737565270734765229896152187157328914190847851987516539166682166737996544976991252e-01), SC_(3.4772167761785895538425904233475323117725166451648246408449320291442366170934598168354796273611659712e-02), SC_(3.4344945401431510671589644766388845581186156115278992793119688427729092394240300515120483330478862961e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9938808632924734570010588615052616422536370561823850847486189953391007620842836799540573625727785990e-01), SC_(3.4977891634071579814962455937897449807436746805004676946682935830452861727192970515535636109483916365e-02), SC_(3.4137209876526441403412715232326919842226428268463001669530317048006706847855381762893685480176398291e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9938399930532291129268413394470108570979077886286494627904833974305479248864606986641733528182355176e-01), SC_(3.5094471537527599003161234409864748756284467323949407335348359895531200230553884657102683084272621591e-02), SC_(3.4019488096456039008126812868634191402765539232339937126249987107051866469768646697054186021913773122e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9935204579259626788341831769967463881434638157518851334883788877478755471479051193772516916866864672e-01), SC_(3.5992896106767680253736512661462121511545370551266479069292002204521400947808965379208160899294758662e-02), SC_(3.3112217278275453052204976139373321809052697684616053603247589430596246675348734159361052021726714075e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9932054435110724669545599064608248317007140981384821808077984801027460114187338963526325622591046527e-01), SC_(3.6857151786413099566317162542349248471834946832043810940070329117947433980785482693925567329291208047e-02), SC_(3.2239374345214889748813408762054486969258891769796398675245207947570222923366934973578484506149806118e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9926189134913071161908314305943709708008487764261260258016493945095438926330839726904393860000859468e-01), SC_(3.8414482911502123729668386535364818948703370437286910781858293496004684523320056627279123082678663503e-02), SC_(3.0666377869925958528711065153606648202096613946222297306300680270744527130134888135333275896842241630e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9896750067271192868133622307679297284482297500283850931024292531820021442852142209972141584577098366e-01), SC_(4.5430524977324357543732868991718392030502558896685381493264658910825545064823683587364613755294513837e-02), SC_(2.3576704282162010250796089740892944162104322336732735153392518983586076226095064697917176176827341787e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9861901771347763062328274933455013265015852117825148536198524853321270492610265858769517258718253081e-01), SC_(5.2536249018835082816547079221706518464300513163829556465851255013928570978363192138588186621696665056e-02), SC_(1.6391311384500326643977158112490023622650630405105410669117731940277863948937039839145394826236940005e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9768434700350202191667594825503498569364261067799028744651171321451588399347166957712868595376372714e-01), SC_(6.8014290735078360454916725165740186658932247487753179915147768671437241869291510873064908421613879048e-02), SC_(7.2199345030662441893972965467175517600719688702303178767000855927249989799095219473435461216250032821e-04) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9254256234705885647820301720174031631444433097628573842824628754746755097714330764176228305049530930e-01), SC_(1.2189857230310280681691250222627993846808913781895789457303404559723170790945632086677943785888022529e-01), SC_(-5.4017641162710473094191382215220401878701628663837458454950131141947620273286301354606819819845906174e-02) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.6572443203057672746117771875295439449060021249211656062721139455292245440058180180430426932595577212e-01), SC_(2.5956949238926363181349828988690404449753396988941275228924714417100569015715117370219838959115949945e-01), SC_(-1.9521737938370716462541453805869696518306691059379847672903239115043349540766593658625600633870092906e-01) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.8415328335816623505850939614956010253266971387768669820518754120818706403664687861394543027153812361e-01), SC_(4.6719693013436443779735623106026267727071270965379369808904596632502872839715938539484640235582654870e-01), SC_(-4.1197358501414171376872550051959324590676236344649543022096754939138374999108409009648812886122856009e-01) }},
      {{ SC_(4.0579185485839843750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.8652248589438042292435331310795066462921643261262979447911413012403026158549337174936896280606617391e-01), SC_(8.0993294385416643442579296156982334344366078376403833242246352189534006937260144062419539408189842176e-01), SC_(-7.8213002571242465073070435946670106443810736740126393797880140227174861409540467606198617046514637846e-01) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9948645063013721603638231426802204489402648758652106002599883288643567152993993718517572974157180951e-01), SC_(3.2044266363427349727311434985602482618393848311332308614222688457979029309107756370594326319736137185e-02), SC_(3.2029397613644065507321089663807870041419997179649533501126167127541561792440034300791916976996149296e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9948597584019908953091105882626054615656073876518603145107279733395175513036448475970244919639703104e-01), SC_(3.2059072019710144851465688134509761455584341813764308562670016826806856544673895791212688802945695817e-02), SC_(3.2014465703574949797350260951422313698651476725280242645643290832674198346401566173399458667188848616e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9948502559840813691922731657080905245807656560097810754705259396552881260677366402836314164911463267e-01), SC_(3.2088683434342258225740043948015068331862121045356231856193185002565303726957214833747113873978991444e-02), SC_(3.1984601718395732205917041064439533297767319061394924219940725692677278739371414091350919616121969306e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9948455014655197047709552679272364240408901753498122388076321124727569227517400693858370331928088424e-01), SC_(3.2103489192681836132671034088325450014443362497365279098226655550079165087502233472987662828199165104e-02), SC_(3.1969669643295239110053213540604665077035079772581584781188399209063534853219607972612624994175000717e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9947930561334952168196305768413386914883778905734125865592722211298146524124050002992062485030147969e-01), SC_(3.2266354777952022609236837094741598416709467006265529394970289391676408366848011072135474917802591510e-02), SC_(3.1805413188190771715439938711042799947146109028888801884729585200263998511425197806027806141052832743e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9947211094782679222293121449951543533853301627600643919519779160650953044748415088472045985026496037e-01), SC_(3.2488450832488323287480025255159150468908407606892391816370213831198231520853801798906670571436270925e-02), SC_(3.1581416399439283940445730198388117383197301822461816071570938810469806423252096264372852944890386265e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9946801193003806094468794694456977730720610301432863158402527970098678593271873376055653879197033297e-01), SC_(3.2614308648464346708737612110759520697654076177250314323994862174914400859129329341497460230453763309e-02), SC_(3.1454479404043036562648225232483584163126287755119228829283431574255539845633619832082679019055211900e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9943589043765658711285051286774611125977062318023649279584367232423420271660634993272317371208392732e-01), SC_(3.3584235961065103519880876000122852697427867767143286466359948847063149419473549895543069075835702819e-02), SC_(3.0476185180043999503678598594460593859547762611281511337720225919594776145985008850980412043723594188e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9940410118265128691082997789948073175267598043701801611498547197011023413258003157166382116626083117e-01), SC_(3.4517278851278363530598396570019415409264794021797925115023511828018704427000191340984640321543852718e-02), SC_(2.9535009731200745104266225684928433095292687420992798639920782028161518900425122689026507802466879415e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9934461704005201647446797865927181717426569576519536478452026713928105221223559184815054413343168640e-01), SC_(3.6198568936793300681181130578960630071923721109624477900698246671165102413738463308539953263399317476e-02), SC_(2.7838857755693606132806143435971705688871580663661724417803351909869776277547796422576347171539242178e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9904149476679759327962816478698661665982318411405420566894934616142526200222064737719011389170051846e-01), SC_(4.3773185103699468406282386880070322541851695807856661581680481237693702626854547172106089687008421992e-02), SC_(2.0193976911149365157686305012869507441302209711144922882173025590480433569701880617884926834737039091e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9867584221025147659696261827702625967029297302427032359494300813104080174038711436378629560565078582e-01), SC_(5.1444748863658525117650432263115367559241394765655614358960184084288985289322448861930873880154773017e-02), SC_(1.2445733038155405523873545499298000056093737966756963024372308687510023483143583350251596805115923084e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9767472401641398127025967508597093365822000439951328430416235983774528697692621616996347011848916292e-01), SC_(6.8155301032070832844000361762765138633375422619354577869469106204767536212620298806623295824390734130e-02), SC_(-4.4510466262957076870309489720065444117157225980903054265810572935207244037628556748018797147793909109e-03) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9198992371165338990515377017976805607236194841440408312531543808206083164243277956247359036859846876e-01), SC_(1.2631702678003503255249956985113193745762677136871415300667898155831235002391274365987806058923851667e-01), SC_(-6.3465966124831122546427281509922872668945517809316554465160946701857544203792582928316285471127346202e-02) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.6156831256511877777581356723525558135897279104713280835347407419893896758397214487531717528360718157e-01), SC_(2.7456580317051509543011267992726642500389871938556435041170581762712038325450589233096452717381502681e-01), SC_(-2.1533983914829020301913064185768165937212815513374680737441664725161880340069267520893646787826061579e-01) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6849343148818893098466528659761920594408580797324195279653726810069485797434293021878037406491538879e-01), SC_(4.9570067526872553118398500291169219836285501467313924362224157191304000359364255075893350854471146319e-01), SC_(-4.4595181763040169571884909141306447277506276244592070553252471411860057315134292140032570601242840396e-01) }},
      {{ SC_(4.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.3619429850248197656217020245869647002074751530319112652811231364043581173373537378652866781763573180e-01), SC_(8.4409458845169197920664526818577405600566953908066327279423677337800188202690794850088669012396459641e-01), SC_(-8.2188938000667030979208480051360160406743592681864816887339414439553731145143529860865909386410697350e-01) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9978737366582186565446266426046331200051518321661492495188502063368786721193215452517656754313155476e-01), SC_(2.0620559119439090985536354903381486892593773724307355346025133578338187954227459325862423506852986404e-02), SC_(2.0597431620569386751852315601363636718083046809814063817805610117927050308229774384160679391624133954e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9978689732208346115811593944418260390114306372825928156063006789106576237047074759210670952301349824e-01), SC_(2.0643641710748190653812731108369631519025829581746144883025650256434143474905627929695095515106418917e-02), SC_(2.0574259095783010170816610581089946989134866287225830855950930004209624164456675895424173742576266588e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9978594303128849419626692899682940779465952654360941727113681831681519177785606260588576993700978224e-01), SC_(2.0689807080713866552181576742318762229547056008583240030778885758770388735574574503705306748458597468e-02), SC_(2.0527913760262031967467746410541694967035040996303798138820948773163181573110295103258539791540069296e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9978546508422251413700097223424600300333916456905081009813430934889824388936470366530004719357288754e-01), SC_(2.0712889859333585348503913268514928807306318057626526305127235125180570108755894776741358279009155845e-02), SC_(2.0504740949564042918566020491418656657026544020242893890151658051635458419215782152387782192093829640e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9978017239163353478327450219679906920858127759139795339653403254286281684501205327546656179364285751e-01), SC_(2.0966804538496807225937581654524848671964837456612247695699259697451165714825225138389611487016584675e-02), SC_(2.0249833748274980777285550298460138612264813865031557655311661667721741865252456314590347434250862604e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9977285085412304275284699662119295318867368599784808584634769864676999513241457019044548275943822430e-01), SC_(2.1313063951939004659128169315357457957453698615721595203525881182367467024792225737790847125611883661e-02), SC_(1.9902214486165115891279554352091433243081849001503515461218479382366792215932874378820132834378392483e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9976864859329936402026679073045696327767411885680961217841737993983385365680445185694465652554222699e-01), SC_(2.1509283807879089780056662361044800513427327482917240693854180478327763816128307596833668871757651474e-02), SC_(1.9705220766408496269207912646161953301297722630970106906653914161624661145387697914054511233476719679e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9973497061434223491104288576768452134622279543946549497822293117125934186778496831198748119720085674e-01), SC_(2.3021479768691413237357718770364979544801978233011342859315519075342419209563873039980110203785410963e-02), SC_(1.8186981832718755965153844844110504729734602551711117892199281907829716533834598615643113938736460658e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9970041285485534876499523563699380259956727435833321651820013152988953727215210134722516599649516928e-01), SC_(2.4476203501192061866989608656098444868422613269879127964945673195136915393228331489515093227153731597e-02), SC_(1.6726312689194730508422041782329052832675459430902343053387561619688670692594605935924036570618292382e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9963279242475894572438528062361107163003359512302276064416066194761163355627130384959884287771812130e-01), SC_(2.7097607072927936613995342492164041670350003671440943788807828645469654505949773555284460907032017738e-02), SC_(1.4093868521458108098910587924887329868209769481938685007141085254765558929848184673041249453909863481e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9924277972341057012910356589131991116760375199894050869943589908646718273683568748458546855136988966e-01), SC_(3.8908446006382490437638384750634170226011564173527367721725858773772848520059259249698179124041875363e-02), SC_(2.2280713662782673773242469141080075957723196032230746475579827551951039126621577923998007941841069784e-03) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9870525027836440542854205669505576596550418453532160543754762706252846518183280302140298260888411775e-01), SC_(5.0870650344078693459747484680731463458645820893317948473460459218508928607974916099365313416320487713e-02), SC_(-9.7984899350023345980340110095370572566091766349549186269477722263903377372382594133933953763227504166e-03) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9703721924184362673742972520410116810879184799445920623753823569689988040235101068879400751121008514e-01), SC_(7.6920630824843375508125149494916658350975342500622581674716345129476358355327854029008665440255091660e-02), SC_(-3.6018875665261482847639761078379683725889814946271259280421193537537873295572465037527942370778735586e-02) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.8590368319922587970243348682569474158587481655299212804983102525126314158051405830319973681573257137e-01), SC_(1.6731385912171308788713891192301126218530330842448860932417613806911650996813055780336089065635361571e-01), SC_(-1.2732549850090630574520021784048518187192134892318356113283227771024700443138340033475061678117816865e-01) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.2001844266934337295687220369265998156334252193109493601257551829241840189712087552771582681072140502e-01), SC_(3.9187506318758806836246322927915157517593796187936469678463945747863044500227525429034565028064406673e-01), SC_(-3.5637658993347106843440113743668868014801608150846980934871685480695675887856709138375777124884154904e-01) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(7.2273834097228572500367605649210068294062254280587638282412584466479779121996905331507096700555785773e-01), SC_(6.9112176241862624280213729101019674955870822817666008403851828669741193379301706752746266831338847599e-01), SC_(-6.6723882091396313766193334432525037909845199791708343186591966133458790513606004936575701646337041920e-01) }},
      {{ SC_(4.5750675201416015625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.6104596385364498752303562472559594657110402960157612737521809177125425094547179666610344888662617286e-01), SC_(9.8694690714670689023103996104881329969199282535111571782487325614988533844115170341664055541873609823e-01), SC_(-9.8525479302489624152833061916378707604997530114844335677643424290329506195562939249397471422973723484e-01) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9981652164121803657712598496100188857288971279668968013486562151911067817824351245141195685998211380e-01), SC_(1.9155235661713627762562126663296842188222898893252455393071862389311213841354917290876889522027713460e-02), SC_(1.9130335298608360080785031466290106044733145092938202631590891043601858269479402450931325574335899704e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9981604508418107786151418855863017670662838186695116255092442068832053146517848382358009726527246496e-01), SC_(1.9180093644891057471846530951895608332400791614740500638466682443848503418398963809995086764461304907e-02), SC_(1.9105392425533099647666255120428464117308158946412515520148909374311481538636394138080426090121454129e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9981509011134578471576727392706634662034722708273165360542971500417455765908143438042762607922207112e-01), SC_(1.9229809818131547350052323862138041576422289112055716412750864752327987558641852670656380250970564190e-02), SC_(1.9055506366260218805994869203087204156251006558376164616794294435477339701502398997949162315059272211e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9981461169553627388641800876314112413243341704454408790497558530210213351035848285716321805931594190e-01), SC_(1.9254668008148577058974300940494101242859008764316494541717875672329692496548515898014354393044812686e-02), SC_(1.9030563180108357929543456460591489815615062858241145886808994849900443265552732028372975123010481531e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9980930822666975627536887725735820366041077878757596216013938820207776608094593652010845872471442456e-01), SC_(1.9528112640705235757230223600326088189171158921375603618212264442912118786484258321775223474745705940e-02), SC_(1.8756181252806964965901775084924391646131884177767563481896595697644480074809724286943151683206218715e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9980195538786051396924943566780452247974480150085528636698071035367037543674385813149145421442388734e-01), SC_(1.9901005065337141962792538794100435113174391872159672736540596225698469828414759891791057092652139975e-02), SC_(1.8382003793196042748175662898713420890759380725673846515512861566002032801745642784400284971333320390e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9979772688318621940391424674031245452515832772786872365926404950615331093383171396156804795039045072e-01), SC_(2.0112317599266764533404281584061776920070639302668248224126301364171298781698661941258649203925150702e-02), SC_(1.8169959535625027057887927821243806620643108768604205747048172538229871921226499195839980859761772471e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9976364019812939326611039585754600030006176100844331736497754308973161175562042694946223499258679239e-01), SC_(2.1740831119928997675519924509460646045110704040421337689347698367649158899313463112870485574895889909e-02), SC_(1.6535721599014390317588066472842068937942683052559864926584672737305740513919571877244729548897789541e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9972834431916633939001068245011886184502600786088088160354787233308924850503570788943320150077413914e-01), SC_(2.3307457279986421124916209642845309523438566288492633054120322793868525645965535400202690339372391775e-02), SC_(1.4963446118368927329167057086824282561642240460736023881755967053127480495590289248940560033209856137e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9965853967310629174493737445974626380869593854567296770197635006828193095800977706106318700499461313e-01), SC_(2.6130519677813033346059813081797786667824248811149834463795364874292316801218878314731104006674462056e-02), SC_(1.2129851041557348744420751590271443505867616563385388170880747570527564158662833834255658339576678621e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9924505362092683418802372636962247822185431536235882508835943173269682562023428596285995349501495044e-01), SC_(3.8850004042613122227297937425412292010928564956830200703105391499951037633049374560272788906275349882e-02), SC_(-6.4271152455749517149518434948295609610678659616636244439577260057368485435847302805451411284185795598e-04) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9866098912245224394911222264192109170522628961004457060146621778395779931627509279137247835995153980e-01), SC_(5.1732280105996883172274185851195288312148393924545113402258968031383531776615628927451986785908858379e-02), SC_(-1.3588120018339104195696646645345017568693556960290397089297313420423163662547514218959615745921689580e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9681225644300572876425900849506895516340812319052388925303653053506641048220019904359821581829675083e-01), SC_(7.9782989446393796951053522656839023251289804639472988588016021583031485971535430511329704484552546596e-02), SC_(-4.1808918914333434371753733790375653608952275952660902225164367817552179817512414079682239507485418078e-02) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.8420573596597221832137660449905946196079567665147923168040663120933169844343516260897115460578435178e-01), SC_(1.7702844204160804798820008055058215749332377701289107989854323744605690726290822261592761992294065383e-01), SC_(-1.3999097274753191675004827408172298090429739294559022776637996299756799119150709618069256979066873382e-01) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.0896349629311757323426610157922098723182795679608218191287164625954810212683244545006838760287828355e-01), SC_(4.1687571577940545192768082496144276990865744133250349559334343480187712885879429527128682846038130801e-01), SC_(-3.8452317127441947489173866625317209503218537502027936993065604005879141226720204896277237611734123154e-01) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.8678520741744595838452483503075212400889433631420566534129842943872538122233182291904905974591460455e-01), SC_(7.2686042599152124492248009227447546598237263412503879135476071237630459368861913133684643364835163350e-01), SC_(-7.0642184059262150570189258778848254440989765321210360694013219528345346043331450039337737355525016495e-01) }},
      {{ SC_(4.6488838195800781250000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.8489541079616491813567618239018413803529343191877338955384946307674082164628470846697688156317155203e-02), SC_(9.9607710601113549805867714757687512920752115193632654501180065726195002874284658240079589849667571939e-01), SC_(-9.9557122017653814791191351618397241856894683187231572661389708203537902087590945615506341428306857878e-01) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9982652260205037008487144066019211006708904085366796916497890146502530781069662543345732006726526518e-01), SC_(1.8625914782680083334635936983767829865912237618895923930486185524108090750440963038092703678052146868e-02), SC_(1.8600305314729028705285986128815148949259140846876272922448617011897611120696830708041939830463928082e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9982604596473247130754072494970124434335701842996525886981507604113241662815227456893371046119310779e-01), SC_(1.8651482797050521052774312747931928567756703797945406994623458243572956091238160614682444937737553465e-02), SC_(1.8574654258429711889551544828904284596420040348244700244635568039699667323025965699586811645363550028e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9982509072388376593502890103573660861337167248592178159170159051650003030233879215714613497479256422e-01), SC_(1.8702619040594197617082245920549144889466348263099779480276448585319400651201611176180783669165737223e-02), SC_(1.8523351821738109231942219340314109021892748430417119869312824835110705662537818931104980189627419676e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9982461212034103288891489206561777621622642312006733460438070480214269567598488622865786361306978952e-01), SC_(1.8728187269717348537085986494497327391507605242396533854389411513615466715487918693290478471380764014e-02), SC_(1.8497700441395629817410496502250191061197184125441105870840137294240730148640979408379919233655196262e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9981930422232700984989643076973432766663872912399421102734608966248125612675969408100620071828415987e-01), SC_(1.9009442505815667752688984204414974478565514100114715573521511244804092628385932301680373496621072481e-02), SC_(1.8215528137445377235208019519055004913539655030916364909035711860096525073015388997222849754873814476e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9981193835832769015428390194749009080152990216544082058131137455313050684079029505678576473830258607e-01), SC_(1.9392986262140011302222023120171842962236529779921020354008319730547748681050799049070884924298439174e-02), SC_(1.7830726729779785571658275815591356825795540981622785233142259353074672791885625139616209281817231507e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9980769889448382589770388569652029929297653708547302956809815775151633189511635498462864408085971633e-01), SC_(1.9610334808900266755957159163156998655813528319048209373954506970903594575613089015263550873297637042e-02), SC_(1.7612661875105097450940108016094260312282828788010481280578953659204417359973075301368184793395572729e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9977344090592499686352939189404039264929764230760042004649283996653659777124938785818068210489966746e-01), SC_(2.1285367253747307303468686821973296762032229894736810719363480209706159354914318762546377444493480897e-02), SC_(1.5932021338730728138626302804795332148551361008441795854801668978155311296296447115342252285096579396e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9973783513117687348129655921207000855720564367892230788696151325848636129351692101862703365158155347e-01), SC_(2.2896746651605506862901415999568207851513698877465048934295095476540249667296184239758197469375747225e-02), SC_(1.4315100382983219695813714200153506344415428952541069811525591787389620944977559561462712182802542956e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9966711276022133779416423771225334928499351833772092827937410105004622309593735390281340927801018163e-01), SC_(2.5800458632414210538017502190227016236017180502766467103255645229367645187342183812798749041978512305e-02), SC_(1.1401039663979737049074385547746680487128697395562114197606828254946912720635898593626117317759576966e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9924375733444950185178431217211004604389540076170509414704850636065898106749063652421785258703472304e-01), SC_(3.8883330980405953047705423412470134121411076194004455790837508008165272072905331179589257409228000444e-02), SC_(-1.7342453794443148616164484770366098969667435927739107278859416677444374133813554944579521206868542254e-03) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9864012276024013873142574471346653018354561941744623302013133825811569831699069798129974215256721440e-01), SC_(5.2133532523822952984929004221095683730378587208835932332014956097942334010224283580342574373024421842e-02), SC_(-1.5047176922080978465856892810519610803509780700732578910771972962012126103413018004473280911060008469e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9671539622419280648258224626989626529333364223084129750469865061362236813334569394733052130444229138e-01), SC_(8.0984065899720916410921066429657842558821272800177544235791404627823888220781861632187325128601705397e-02), SC_(-4.4067862614071691287707392616875562353137988402727628893493408444830235522488268500205793954107200790e-02) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.8348997688009748412363763034798030709093308589165960195984045467480064886097047515903312743609977994e-01), SC_(1.8096260767458374617009048624920144601271000285368739418544472293394340031988375348476692475838681831e-01), SC_(-1.4499289765339301528611751520433145208623482202062219802572268176947648290515709692837141757901138079e-01) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.0434584152960834565104712858337538677300493004900650781801886901333929651432969119908718524081895783e-01), SC_(4.2680042046383284839263311047116836554676010140425536296750230272793080843715768766767590326610863284e-01), SC_(-3.9559330729844975213514437861165465352906052502599339323204725534031042562629408215710703717995727238e-01) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.7208632715913742065446382897479645835781701635033697128957150613398738193527406228793277758154987194e-01), SC_(7.4047280088180207370566165442929492187668936024583789957917062314584342626541695847818619443978447949e-01), SC_(-7.2128096164978425779329673762520881080509059056003671440184848967241340194332014543947406813364783737e-01) }},
      {{ SC_(4.6769485473632812500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.0592769396935641655140237315403248291213552070016242868995096253896688834486885227846936598137006828e-02), SC_(9.9816257007403848030066235587960171278353092298334754301587715927663388387526257819798043428161863264e-01), SC_(-9.9792590013026113903857313284465926827053505230343012401116052168143370427149757637768850114179566751e-01) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9983053856365728428472476961341050236246696869140494127940020414498931568118063632052326861271878891e-01), SC_(1.8409078073250276002259313838456422287389087905475757243715465942582083514989223833245167072560823701e-02), SC_(1.8383166325689742604378185792213656770478063644030284954336543995226507332508925806941572059258357500e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9983006189283391264792309580205006106632798732626227485635127451556278997024754259298467123881800805e-01), SC_(1.8434948748827795739410166920783358855496687577611874048010764546336412582360214966148559898197951637e-02), SC_(1.8357213369355569580735956754499295188717737021257491452551228016492881120609896492824357733043697370e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9982910653825226339566129348864448098220087024851415298949871608548324976957390322215768978080029428e-01), SC_(1.8486690318177699261640184016361176457112943918437847786596436796383686558510261568959735399512940647e-02), SC_(1.8305307127900685405392978146625174246038655359233956869735278626564821316960030234974668738016831794e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9982862785448173144108904377878098074302003338945786445801440120976115876676012569730701977042882881e-01), SC_(1.8512561211898195455143816788214455745708386377024275881639348810867176280594105346840558139501039997e-02), SC_(1.8279353842831575816116116528498092352826773897754793956609726220528385386259796663847475593973861786e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9982331804601310937304224604654185620290460845920064798320231064951262902957432029336169030520290204e-01), SC_(1.8797145832836341225287832472661684158875279553881153956769245786300392912936212546736009453346321761e-02), SC_(1.7993860483985333725515775824405536064778781653180063028650871548018135373180291088102652608554214723e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9981594653944039454010009229731608930400964188929969909977677645154373651345438026549817072335179724e-01), SC_(1.9185229877248459843569837259930310259878826810278026860808941649346801020740902253197289187808256320e-02), SC_(1.7604530062641840881628041891980733874136664069358269701460138132616901805128001829400854358398641324e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9981170232225327544110660130995233598280265365583015893175121691587670128687032745640835753382641415e-01), SC_(1.9405151364470319649123805428415619283243870794953946250754253865090856486738176216394591965320764425e-02), SC_(1.7383898613002623581653052193849642940283776308819619767756716945332907003984392347421547105534322736e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9977736993933463137450775950066677097831261044286294319808093404408111597466860669194575352844901825e-01), SC_(2.1100013203475143448202457788255842609856347415070414690711822947773335693197034482272557276476384387e-02), SC_(1.5683476528429961139280252279937380161325937343969857968417310468005013158054324257921076388264923694e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9974162950382125787042649121716455242079385979644264303301331049098404943102172787677845800078489058e-01), SC_(2.2730469353803247187044400389622540710351651118106419398715761506749753736604985189481082185668784543e-02), SC_(1.4047523083075509485166457267282788776773894420969903123025368768851314964111856384040998712620292153e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9967050824555224979519174591336184074905895322474733637420344352734594987648608765479679252268251160e-01), SC_(2.5668559446904131887113965640028544389235512384311006740880794729680950348209196622569329937202673871e-02), SC_(1.1099159646185983233863353370149099356674728661652955126710804842553474482480163232448684673777533611e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9924286211185677611108918166132378108320746706113244358642099766124632458014771657003539524385593477e-01), SC_(3.8906330057007250408381713180240235056553607573186652777259014517078931326202856144018271219668322812e-02), SC_(-2.1907535383254148168626373572062408462032234517520250183580901827852192247578283392326814976928853759e-03) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9863071881629255801203262178940231052621568648304990364161257113029461063337971663665594165518346542e-01), SC_(5.2313358107225622095828241673842069268819770319164475575707733566482744534445899460954495722908235052e-02), SC_(-1.5660353750055635012860749617707584970451989121518805037913199111992763822624142768078030244944439741e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9667295173231449762046240689481533282856075442833213727103935242310220018219446839454752266366057443e-01), SC_(8.1504768481331788007161104365589953660977177061548297191492473611128736565635608295402338441554705691e-02), SC_(-4.5021972847494304851432067335556851123489688541495641849900299248552210611739489056221969789793853215e-02) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.8317855533137385150987773350149280376005808019669564747834480519791966867484841054865267296332553926e-01), SC_(1.8264700472910210280281733425716064789964044949718820700761820876343853639918795555129404132220312320e-01), SC_(-1.4711501379188940153416390020988053919918411282272124311407675567718121801802181486593036675671796433e-01) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.0234408779666568143685466536934976417446764802664881084744779655606056298461686632280529293981740734e-01), SC_(4.3101641177384799954373445338966397219531793102053027390116025127302935513477257519246891881296172892e-01), SC_(-4.0028003115649162400822755090455720518546364735265748553888709827027217276125411502227514514672335466e-01) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.6577129704992459342734293860891835237736910537218166311824163522101759103416013427866598338152844574e-01), SC_(7.4615586845139874458315399950521136261112588966445884392918857602525928888591300601772602151858630472e-01), SC_(-7.2747477955385934677057014889716898619479124915749284074100143732133192967159691857950020711985168600e-01) }},
      {{ SC_(4.6886768341064453125000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.8902041397031797689366520751523138963942339857272683232920566444289937064700411330883957381739685540e-02), SC_(9.9880357946255027843196924398606955271653412672331055161164196432051463511787920239245804646439137188e-01), SC_(-9.9864953053695532038896311542967207805331017041203788909528633946567585302154649920566537244128869405e-01) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9989507404745350379647237302203127134783702461832354635295289388870794196366180365533811117083370831e-01), SC_(1.4485886083960297990498634848628851214831928498229125799684138119892177024164526337692174797670448629e-02), SC_(1.4452938151587555502543851316259800950834864565909136193481326462132758670144568720874806634757500883e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9989459666715279507987684380532929982993701081909894624591066713270944935856567143009749348099445727e-01), SC_(1.4518800082370255626973306061287516935226660710358163940551510750801808535910783611105593370505661295e-02), SC_(1.4419956100058242030056265968724423110113603999216980250569899026092785589821618623282207674597393739e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9989363865115561135988784460911970825166659399616649889875606095682659445152548358244036710296611777e-01), SC_(1.4584628378956019271932640850302488092075657025449992574003456577763722870206330487062348517704925313e-02), SC_(1.4353991556363608660295655574220958032493270245083877878863508206219486378512761927171422287642750445e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9989315801543784423540911296409033043647366690863286567966416097692260609670696707799487911099507909e-01), SC_(1.4617542677024970781278929682077019374762931548691061633292779212751274361312120446153994938779216594e-02), SC_(1.4321009064304748107960049324242452752862637337805356897947499238683208408943464004116997325883404296e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9988779939962371298315213400108118914362745050842202510797834303094596623265224977825703816440820733e-01), SC_(1.4979606529473637494041316019910763339248727419203131472285365936327903106655239636962691662500335437e-02), SC_(1.3958191978745600009531936024099672561759428194445187897996198790962203137117565628215418276096126913e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9988028056445506199279702455379114210214306416430724853363492276339931371065131425689810069299653174e-01), SC_(1.5473349293111327416118480331747650725031313869493677387974161116074976844490421533957299942847793970e-02), SC_(1.3463412921914614213121237639556767390092197780098116166228394541375386821149182979302702028730437646e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9987591148558485370505976138103491630628074356166210112510975962979278900265451341319052666838688715e-01), SC_(1.5753146697434225058795974095035523231332735094694770979764848378822801133402934836427986541628327150e-02), SC_(1.3183023594463948666991344364980530524396103602942372844203368342179388021720582096642014863870295998e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9983961262556458105411816513386501069818868254597543899979739851713011745549242090003291863043360816e-01), SC_(1.7909467461679579613865846453127030740431683822307987641233759491974468137156343038472584788153719816e-02), SC_(1.1022027714560253639775210637358170803625731907710762268322205147523210932800679750596051078399995227e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9980030256396930887191418644879858746499286116603833140948641674242316282708649788931471360377120948e-01), SC_(1.9983868319107415100192575817218448002872334427605112144785457794197957548974963015124500960330632884e-02), SC_(8.9429400350182931102462515246756092360839543295569327418622781093899967392101579075705047283542737083e-03) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9971859410574829149542055218946133495999998703062622308574286556112837670807622495531498983998552142e-01), SC_(2.3721985566686811501553785842504292265143700801159531093582400523199741127440730181223853049104697981e-02), SC_(5.1959084061760747247216972187443738573816595465178798376919099189683106332314686770218982589845777935e-03) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9917693553108610108245187459387110710867895185036028369250080655683477578951699279752986546417196886e-01), SC_(4.0564165253432854495962739719292670877985837287590190952513658424683411183252903298570906316652973652e-02), SC_(-1.1693907948011891736346399073379369646285263939726984396456303809247557032844131792753244452252911330e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9833862714223532498010744688715977461168806598690747288717525459318863541168129207120227886401126061e-01), SC_(5.7619315821665505755807469277023845728196594181676552014891883345476566794225348418090613651544831445e-02), SC_(-2.8809755979513188208763166052264396245596987730186982112445949120233730597575117085318376369502829889e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9550282813148011187442008796193919282450391517768171678499412663145272607895548134555661363567896104e-01), SC_(9.4731827715001728394842167045083404424880502660480023599099701680830517630055158928067584272630580487e-02), SC_(-6.6097672659470430511445565993386991293723042460980621503600493772708300136816834870939899267701630847e-02) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.7488580947363208179564147601546168112866226007237931556521707915803372220062773907383454915316416844e-01), SC_(2.2270531759915641564428390959261643237507268828655875813370441187815589236168955504059138988493898375e-01), SC_(-1.9513426821812310447331250709147993510680832240493081023161860752378383411231604144945171703488569462e-01) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.5047999201852727152029200141398691946094097189026959484621720440391252384040853131710884789523146140e-01), SC_(5.2600739840440057115641306993358779565840766907499100219100954734337117943149800710956696665520559890e-01), SC_(-5.0396976782224493807852110187351280318514711081254077576732604138847199181605549483495869758913976615e-01) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.1327981487051663560323287861487799526557318426357663133754105221861872520039091818400141712658488619e-01), SC_(8.5822131856910206307975755122650869086923193783068105639211083604153599058747147318033641183682450386e-01), SC_(-8.4863499452477025561188325402717974396821766661061642322481772003670342956693044080319449123628917079e-01) }},
      {{ SC_(4.9288120269775390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-1.8874998553523563180450407596677553759443297406638077877671888636968292269342250146798578804443833955e-01), SC_(9.8202517430076523459567226815465938546160099991006357826594110965447969674969166451594194257839894548e-01), SC_(-9.7968838503511372732980355080304021286004233574178250953181773421728648476453800138580553004953114288e-01) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000004768371582031250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9990230743461869448445678791127692739855483254325094973521364638399647301470778701786295076066841344e-01), SC_(1.3977681743596834750245838542565526868788148525105907036279461386658032363829895912063967821083621420e-02), SC_(1.3943532504578029336223566464310890649533113683351630105746575474244424229833795304874920488538103241e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000014305114746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9990182993959446195710647247229655789894087272192991018223122155551540595968020853239245484285382831e-01), SC_(1.4011798009189115440946424983203357697063506917213864415963408126171160102402517954920500108105330871e-02), SC_(1.3909350098446540137998040892200032362998230531072660409764206932461470850614753920053416867944340582e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000033378601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9990087145233340743687363148083709437365125661771030890303935547815366122351784383668727269614239538e-01), SC_(1.4080030854519553869387256354091022075006611901455012492968743022297026887056631461218922416611180400e-02), SC_(1.3840984826000562463507298586847289168517030032198014972508385303739709934919897327599510874817235727e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000042915344238281250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9990039046007347560794974433795859349285564034207694616490402223275328043372974797633640062669854428e-01), SC_(1.4114147434138712802378427844951370551607420853342810579186545315810682561759933627157193849677482057e-02), SC_(1.3806801959804658372619591398212092857153153412847966912073167823894243759539600291883375485071922556e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000147819519042968750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9989502260196613653978264216146024156399873063751297730606299366512347908431919053242252316860296003e-01), SC_(1.4489436697595561124507049144255123371288526433896118736440705972120404661097924241761764708299954793e-02), SC_(1.3430780331105131752185610702820021510950585065908804323267469964167723504319244050213738571874089978e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000290870666503906250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9988747544293069353066537829179260575882047757007492549019748069539230620040354484126779384912576694e-01), SC_(1.5001215029545749933847659975864641865931391330840461915721059755185086271628874400178167869847889009e-02), SC_(1.2917993826264694721926108892215877113225794890847741738148129932526099630756216503817814024316857591e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000371932983398437500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9988308226099731657983151576240197041049174012751792764812244409087930727657331644783678448792904087e-01), SC_(1.5291233051905047096038520294638906781972874594444499867815398497101742249334516320782151364484948558e-02), SC_(1.2627399643574478880468698035197591815527455130858562493759790443716432493078723746069108350777491985e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0000996589660644531250000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9984640219639140402613273019667554862930150639016202863777830939274528021875552024478939209428846017e-01), SC_(1.7526323485885982097641938428519069579260358421271219311888913372990209058618455439095372023020540344e-02), SC_(1.0387751384930428488122047379910627057886096355738392117524671170521488626705245794637004721422908426e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0001597404479980468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9980639884593669404425893776595290662877785980161533745963098103525238097471831481848178344690376077e-01), SC_(1.9676504433454567937248530268282368308302071162458460119591299806242144124305023388268650598619695861e-02), SC_(8.2329894545034209975015153877461219543875964135604078659255758514717666391596123103417229683686485863e-03) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0002679824829101562500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9972263242283481540743599408497747360870457548541412998469672217116875570127792798886879974903796487e-01), SC_(2.3551183018216021253938001600501009008155573150038780116288028548084796733896793416599159415959118251e-02), SC_(4.3495699021134300166444124225546063387545267250507797699122981168308214469028322968675084635890943764e-03) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0007553100585937500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9915879545421819350530688005623615186240544270827593274622412564050735515128475466608299752025526140e-01), SC_(4.1008553576976706311793253202245137451698422113077721150856829330199964424353347050839790650622532029e-02), SC_(-1.3154931678629558158982660699935247723551027344608329867102808264119755379967383078768146573341990972e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0012483596801757812500000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9827648539531403745215917352563214138968446312144447102479978693505240691548978979441840473622948646e-01), SC_(5.8686103182775385959094432164210470495146664187835729337215293512993909532328740626483958923893141231e-02), SC_(-3.0893124798500284820335880409303644182778189826173654652430374404846006649343381743921738919251947699e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0023207664489746093750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.9526992589997827420306117917427182178979741082729092965897483434868497193943333068777040666157481100e-01), SC_(9.7148209448510965618814190119451117927847310257093339481999337817751394945307795550093447421264799168e-02), SC_(-6.9532095588469802480589239010157975152091841708321990467488846359840797625840328044562828776517609113e-02) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0060424804687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.7327357090730138720367359153239323902247504897821653720406237386695349159240208217001492967466592893e-01), SC_(2.2964876697546228888931649787788742930944361620108470728002449961617243383843764035729632038084809597e-01), SC_(-2.0311659859397708228829612914540972881961033272228812487026550233039579579564016302202736438925829861e-01) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0155692100524902343750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.4069051112564740388498305703743050846741943876819566564676351892344788777074732833738047977587592836e-01), SC_(5.4151589496828042658602571182616923878595213758699386834940240440502083614232854508648303249637786229e-01), SC_(-5.2063493838617445779646407770009371209785483807741597530330738738065076402146210854614754006055477215e-01) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0305857658386230468750000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.8671357579638665629126370168770921319757407213502466576345439294626879685237098285286502834996393092e-01), SC_(8.7356161496227327149253838986791328231133879539230423927448398220130445285498224963240552394450600870e-01), SC_(-8.6509962228485538958789361261824061503929655387763193064181839580439422746694246738587153880942281811e-01) }},
      {{ SC_(4.9646129608154296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0623893737792968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(-2.2293187234404279005404405123453640992362355261738577610576210777344443465871289033909805344032394449e-01), SC_(9.7483402704931233304677248889105249284034868811789307005518001217555908178599047906139783223849231970e-01), SC_(-9.7154855780636670580019454689623684007923466283994781397066875280116362115119765459157832338091463773e-01) }}
   }};
//#undef SC_

