/*
 * Decompiled with CFR 0.152.
 */
import Ice.Communicator;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.NotRegisteredException;
import Ice.ObjectPrx;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.Util;
import Test.HelloPrx;
import Test.HelloPrxHelper;
import Test.ServerManagerPrx;
import Test.ServerManagerPrxHelper;
import Test.TestIntfPrx;
import Test.TestIntfPrxHelper;
import java.io.PrintStream;

public class AllTests {
    private static void test(boolean bl) {
        if (!bl) {
            throw new RuntimeException();
        }
    }

    public static void allTests(Communicator communicator, PrintStream printStream) {
        String string = communicator.getProperties().getPropertyWithDefault("Test.ServerManager", "ServerManager :default -t 10000 -p 12010");
        ServerManagerPrx serverManagerPrx = ServerManagerPrxHelper.checkedCast(communicator.stringToProxy(string));
        AllTests.test(serverManagerPrx != null);
        LocatorPrx locatorPrx = LocatorPrxHelper.uncheckedCast(communicator.getDefaultLocator());
        AllTests.test(locatorPrx != null);
        printStream.print("testing stringToProxy... ");
        printStream.flush();
        ObjectPrx objectPrx = communicator.stringToProxy("test @ TestAdapter");
        ObjectPrx objectPrx2 = communicator.stringToProxy("test @ TestAdapter");
        ObjectPrx objectPrx3 = communicator.stringToProxy("test");
        ObjectPrx objectPrx4 = communicator.stringToProxy("ServerManager");
        ObjectPrx objectPrx5 = communicator.stringToProxy("test2");
        ObjectPrx objectPrx6 = communicator.stringToProxy("test @ ReplicatedAdapter");
        printStream.println("ok");
        System.out.print("testing ice_locator and ice_getLocator... ");
        AllTests.test(Util.proxyIdentityCompare(objectPrx.ice_getLocator(), communicator.getDefaultLocator()) == 0);
        LocatorPrx locatorPrx2 = LocatorPrxHelper.uncheckedCast(communicator.stringToProxy("anotherLocator"));
        objectPrx = objectPrx.ice_locator(locatorPrx2);
        AllTests.test(Util.proxyIdentityCompare(objectPrx.ice_getLocator(), locatorPrx2) == 0);
        communicator.setDefaultLocator(null);
        objectPrx = communicator.stringToProxy("test @ TestAdapter");
        AllTests.test(objectPrx.ice_getLocator() == null);
        objectPrx = objectPrx.ice_locator(locatorPrx2);
        AllTests.test(Util.proxyIdentityCompare(objectPrx.ice_getLocator(), locatorPrx2) == 0);
        communicator.setDefaultLocator(locatorPrx);
        objectPrx = communicator.stringToProxy("test @ TestAdapter");
        AllTests.test(Util.proxyIdentityCompare(objectPrx.ice_getLocator(), communicator.getDefaultLocator()) == 0);
        AllTests.test(objectPrx.ice_getRouter() == null);
        RouterPrx routerPrx = RouterPrxHelper.uncheckedCast(communicator.stringToProxy("anotherRouter"));
        objectPrx = objectPrx.ice_router(routerPrx);
        AllTests.test(Util.proxyIdentityCompare(objectPrx.ice_getRouter(), routerPrx) == 0);
        RouterPrx routerPrx2 = RouterPrxHelper.uncheckedCast(communicator.stringToProxy("dummyrouter"));
        communicator.setDefaultRouter(routerPrx2);
        objectPrx = communicator.stringToProxy("test @ TestAdapter");
        AllTests.test(Util.proxyIdentityCompare(objectPrx.ice_getRouter(), communicator.getDefaultRouter()) == 0);
        communicator.setDefaultRouter(null);
        objectPrx = communicator.stringToProxy("test @ TestAdapter");
        AllTests.test(objectPrx.ice_getRouter() == null);
        System.out.println("ok");
        printStream.print("starting server... ");
        printStream.flush();
        serverManagerPrx.startServer();
        printStream.println("ok");
        printStream.print("testing checked cast... ");
        printStream.flush();
        TestIntfPrx testIntfPrx = TestIntfPrxHelper.checkedCast(objectPrx);
        AllTests.test(testIntfPrx != null);
        TestIntfPrx testIntfPrx2 = TestIntfPrxHelper.checkedCast(objectPrx2);
        AllTests.test(testIntfPrx2 != null);
        TestIntfPrx testIntfPrx3 = TestIntfPrxHelper.checkedCast(objectPrx3);
        AllTests.test(testIntfPrx3 != null);
        ServerManagerPrx serverManagerPrx2 = ServerManagerPrxHelper.checkedCast(objectPrx4);
        AllTests.test(serverManagerPrx2 != null);
        TestIntfPrx testIntfPrx4 = TestIntfPrxHelper.checkedCast(objectPrx5);
        AllTests.test(testIntfPrx4 != null);
        TestIntfPrx testIntfPrx5 = TestIntfPrxHelper.checkedCast(objectPrx6);
        AllTests.test(testIntfPrx5 != null);
        printStream.println("ok");
        printStream.print("testing id@AdapterId indirect proxy... ");
        printStream.flush();
        testIntfPrx.shutdown();
        serverManagerPrx.startServer();
        try {
            testIntfPrx2.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("testing id@ReplicaGroupId indirect proxy... ");
        printStream.flush();
        testIntfPrx.shutdown();
        serverManagerPrx.startServer();
        try {
            testIntfPrx5.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("testing identity indirect proxy... ");
        printStream.flush();
        testIntfPrx.shutdown();
        serverManagerPrx.startServer();
        try {
            testIntfPrx3 = TestIntfPrxHelper.checkedCast(objectPrx3);
            testIntfPrx3.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        try {
            testIntfPrx2 = TestIntfPrxHelper.checkedCast(objectPrx2);
            testIntfPrx2.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        testIntfPrx.shutdown();
        serverManagerPrx.startServer();
        try {
            testIntfPrx2 = TestIntfPrxHelper.checkedCast(objectPrx2);
            testIntfPrx2.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        try {
            testIntfPrx3 = TestIntfPrxHelper.checkedCast(objectPrx3);
            testIntfPrx3.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        testIntfPrx.shutdown();
        serverManagerPrx.startServer();
        try {
            testIntfPrx2 = TestIntfPrxHelper.checkedCast(objectPrx2);
            testIntfPrx2.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        testIntfPrx.shutdown();
        serverManagerPrx.startServer();
        try {
            testIntfPrx3 = TestIntfPrxHelper.checkedCast(objectPrx2);
            testIntfPrx3.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        testIntfPrx.shutdown();
        serverManagerPrx.startServer();
        try {
            testIntfPrx4 = TestIntfPrxHelper.checkedCast(objectPrx5);
            testIntfPrx4.ice_ping();
        }
        catch (LocalException localException) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("testing reference with unknown identity... ");
        printStream.flush();
        try {
            objectPrx = communicator.stringToProxy("unknown/unknown");
            objectPrx.ice_ping();
            AllTests.test(false);
        }
        catch (NotRegisteredException notRegisteredException) {
            AllTests.test(notRegisteredException.kindOfObject.equals("object"));
            AllTests.test(notRegisteredException.id.equals("unknown/unknown"));
        }
        printStream.println("ok");
        printStream.print("testing reference with unknown adapter... ");
        printStream.flush();
        try {
            objectPrx = communicator.stringToProxy("test @ TestAdapterUnknown");
            objectPrx.ice_ping();
            AllTests.test(false);
        }
        catch (NotRegisteredException notRegisteredException) {
            AllTests.test(notRegisteredException.kindOfObject.equals("object adapter"));
            AllTests.test(notRegisteredException.id.equals("TestAdapterUnknown"));
        }
        printStream.println("ok");
        printStream.print("testing object reference from server... ");
        printStream.flush();
        HelloPrx helloPrx = testIntfPrx.getHello();
        helloPrx.sayHello();
        AllTests.test(communicator.proxyToString(helloPrx).indexOf("TestAdapter") != -1);
        helloPrx = testIntfPrx.getReplicatedHello();
        helloPrx.sayHello();
        AllTests.test(communicator.proxyToString(helloPrx).indexOf("ReplicatedAdapter") != -1);
        printStream.println("ok");
        printStream.print("testing object reference from server after shutdown... ");
        printStream.flush();
        testIntfPrx.shutdown();
        serverManagerPrx.startServer();
        helloPrx.sayHello();
        printStream.println("ok");
        printStream.print("testing object migration...");
        printStream.flush();
        helloPrx = HelloPrxHelper.checkedCast(communicator.stringToProxy("hello"));
        testIntfPrx.migrateHello();
        helloPrx.sayHello();
        testIntfPrx.migrateHello();
        helloPrx.sayHello();
        testIntfPrx.migrateHello();
        helloPrx.sayHello();
        printStream.println("ok");
        printStream.print("testing whether server is gone... ");
        printStream.flush();
        testIntfPrx.shutdown();
        try {
            testIntfPrx2.ice_ping();
            AllTests.test(false);
        }
        catch (LocalException localException) {
            printStream.println("ok");
        }
        printStream.print("shutdown server manager... ");
        printStream.flush();
        serverManagerPrx.shutdown();
        printStream.println("ok");
    }
}

