/*
 *========================================================================
 * $Id: xmlsysd_send_stats.c 163 2005-09-14 22:54:20Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */


#include "xmlsysd.h"

/* 
 * send_statlist(buffer) prints (as in inetd), transmits (as in
 * the forking daemon), or broadcast the statistics evaluated with 
 * init_statlist, get_statlist, and eval_statlist, depending on the
 * state of the daemon (determined by runtime flags or commands).
 *
 * I'm going to have to feel my way through this -- daemon behavior is
 * fairly simple (write to stdout if inetd daemon, to socket if forking 
 * daemon).  I don't have a feel for how to wrap or implement the multicast
 * of the data, though, and will have to find some template/boilerplate to
 * see how to go about it.  First we'll just fix the inetd behavior (which
 * will make the daemon much easier to test, too).  This whole note, BTW,
 * should be decrufted when I'm done screwing around here.
 */

void send_stats()
{

 int i,docsize,msglength;
 xmlChar *dumpbuf;
 int eof;

 if((verbose == D_ALL) || (verbose == D_SENDSTATS)){
   printf("D_SENDSTATS: Starting send_stats().  Use -v %d to focus.\n",D_SENDSTATS);
 }

 /*
  * This little fragment is here so that we can simulate a broken as
  * shit connection.  For example, one out of five calls, it just hangs
  * after a send and never sends anything.  One out of 10 times the
  * (child) daemon just dies.  We'll see if wulfstat can survive the
  * abuse and trauma.  Note that it is really smart to make sure that
  * the tests below are moduli prime... (duh...)
  *
  * DO NOT LEAVE THIS IN A PRODUCTION VERSION.  Sheesh, do I have to
  * remember EVERYTHING?...
  *
 if((rand() % 7) == 0) {
   if((verbose == D_ALL) || (verbose == D_SENDSTATS)){
     printf("D_SENDSTATS: No, I won't tell you!  I won't!\n");
     sleep(1);
   }
   return;
 }
 if((rand() % 3) == 0) {
   if((verbose == D_ALL) || (verbose == D_SENDSTATS)){
     printf("D_SENDSTATS: This party sucks! I'm quitting and going home!\n");
     sleep(5);
   }
   xmlsysd_quit();
 }
  */

 /*
  * We return the xml by dumping the document to a memory buffer
  * and then send the buffer, preceeded with an html-1.1 standard
  * header specifying the length, to the outgoing socket/file descriptor.
  * We have to free doc after the dump, since otherwise the daemon
  * leaks like a sonuvabitch.
  */
 xmlDocDumpFormatMemory(doc,&dumpbuf,&docsize,1);
 if((verbose == D_ALL) || (verbose == D_SENDSTATS)){
   printf("D_SENDSTATS: Sending message of length %d:\n%s",
       docsize,dumpbuf);
 }
 xmlFreeDoc(doc);

 /*
  * Send the xmlified message, already...
  */
 sprintf(outbuf,"Content-Length: %d\n\n",docsize);
 strncat(outbuf,(char*)dumpbuf,K64);
 write(client_fd,outbuf,strlen(outbuf));

 /*
  * ...and do NOT forget to free this!
  */
 free(dumpbuf);
 /* Note that this crashes and burns: xmlFree(dumpbuf); */

}

