/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.hanim;

import javax.vecmath.Matrix4f;
import org.j3d.geom.hanim.HAnimDisplacer;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.geom.hanim.HAnimObjectParent;
import org.j3d.geom.hanim.HAnimSegment;
import org.j3d.geom.hanim.HAnimSite;
import org.j3d.util.ErrorReporter;

public class HAnimJoint
extends HAnimObject
implements HAnimObjectParent {
    private static final String MIN_ARRAY_SIZE_MSG = "The source array is either null or not long enough";
    private static final String INVALID_CHILD_TYPE_MSG = "Invalid child type supplied. Must be one of Joint, Segment or Site";
    protected float[] bboxCenter = new float[3];
    protected float[] bboxSize = new float[3];
    private float[] center = new float[3];
    private float[] rotation = new float[4];
    private float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    private float[] scaleOrientation = new float[4];
    private float[] translation = new float[3];
    private float[] limitOrientation = new float[4];
    private float[] lowerLimit;
    private int numLower;
    private float[] upperLimit;
    private int numUpper;
    private float[] stiffness;
    private int numStiffness;
    protected int[] skinCoordIndex;
    protected float[] skinCoordWeight;
    protected int numSkinCoord;
    protected HAnimObject[] children;
    protected int numChildren;
    protected HAnimDisplacer[] displacers;
    protected int numDisplacers;
    protected Matrix4f localMatrix = new Matrix4f();
    protected Matrix4f globalMatrix;
    protected HAnimObjectParent parent;
    protected boolean matrixChanged;
    protected boolean updateSent;
    protected float[] sourceCoords;
    protected int numSourceCoords;
    protected float[] sourceNormals;
    protected int numSourceNormals;
    protected Object outputCoords;
    protected Object outputNormals;
    protected int objectIndex;

    public HAnimJoint() {
        this.localMatrix.setIdentity();
        this.globalMatrix = new Matrix4f();
        this.rotation[2] = 1.0f;
        this.scaleOrientation[2] = 1.0f;
        this.limitOrientation[2] = 1.0f;
        this.matrixChanged = false;
        this.updateSent = false;
    }

    public void childUpdateRequired(HAnimObject hAnimObject) {
        if (!this.updateSent) {
            if (this.parent != null) {
                this.parent.childUpdateRequired(this);
            }
            this.updateSent = true;
        }
    }

    public int requestNextObjectIndex() {
        return this.parent != null ? this.parent.requestNextObjectIndex() : -1;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        for (int i = 0; i < this.numChildren; ++i) {
            this.children[i].setErrorReporter(this.errorReporter);
        }
    }

    public void setCenter(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.center[0] = fArray[0];
        this.center[1] = fArray[1];
        this.center[2] = fArray[2];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getCenter(float[] fArray) {
        fArray[0] = this.center[0];
        fArray[1] = this.center[1];
        fArray[2] = this.center[2];
    }

    public void getScale(float[] fArray) {
        fArray[0] = this.scale[0];
        fArray[1] = this.scale[1];
        fArray[2] = this.scale[2];
    }

    public void setScale(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.scale[0] = fArray[0];
        this.scale[1] = fArray[1];
        this.scale[2] = fArray[2];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getTranslation(float[] fArray) {
        fArray[0] = this.translation[0];
        fArray[1] = this.translation[1];
        fArray[2] = this.translation[2];
    }

    public void setTranslation(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.translation[0] = fArray[0];
        this.translation[1] = fArray[1];
        this.translation[2] = fArray[2];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getScaleOrientation(float[] fArray) {
        fArray[0] = this.scaleOrientation[0];
        fArray[1] = this.scaleOrientation[1];
        fArray[2] = this.scaleOrientation[2];
        fArray[3] = this.scaleOrientation[3];
    }

    public void setScaleOrientation(float[] fArray) {
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.scaleOrientation[0] = fArray[0];
        this.scaleOrientation[1] = fArray[1];
        this.scaleOrientation[2] = fArray[2];
        this.scaleOrientation[3] = fArray[3];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getRotation(float[] fArray) {
        fArray[0] = this.rotation[0];
        fArray[1] = this.rotation[1];
        fArray[2] = this.rotation[2];
        fArray[3] = this.rotation[3];
    }

    public void setRotation(float[] fArray) {
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.rotation[0] = fArray[0];
        this.rotation[1] = fArray[1];
        this.rotation[2] = fArray[2];
        this.rotation[3] = fArray[3];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getBboxCenter(float[] fArray) {
        fArray[0] = this.bboxCenter[0];
        fArray[1] = this.bboxCenter[1];
        fArray[2] = this.bboxCenter[2];
    }

    public void setBboxCenter(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.bboxCenter[0] = fArray[0];
        this.bboxCenter[1] = fArray[1];
        this.bboxCenter[2] = fArray[2];
    }

    public void getBboxSize(float[] fArray) {
        fArray[0] = this.bboxSize[0];
        fArray[1] = this.bboxSize[1];
        fArray[2] = this.bboxSize[2];
    }

    public void setBboxSize(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.bboxSize[0] = fArray[0];
        this.bboxSize[1] = fArray[1];
        this.bboxSize[2] = fArray[2];
    }

    public void getLimitOrientation(float[] fArray) {
        fArray[0] = this.limitOrientation[0];
        fArray[1] = this.limitOrientation[1];
        fArray[2] = this.limitOrientation[2];
        fArray[3] = this.limitOrientation[3];
    }

    public void setLimitOrientation(float[] fArray) {
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.limitOrientation[0] = fArray[0];
        this.limitOrientation[1] = fArray[1];
        this.limitOrientation[2] = fArray[2];
        this.limitOrientation[3] = fArray[3];
    }

    public int numLowerLimit() {
        return this.numLower / 3;
    }

    public void getLowerLimit(float[] fArray) {
        System.arraycopy(this.lowerLimit, 0, fArray, 0, this.numLower);
    }

    public void setLowerLimit(float[] fArray, int n) {
        if (fArray == null || fArray.length < n * 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        if (this.lowerLimit == null || this.lowerLimit.length < n * 3) {
            this.lowerLimit = new float[n * 3];
        }
        System.arraycopy(fArray, 0, this.lowerLimit, 0, n * 3);
        this.numLower = n * 3;
    }

    public int numUpperLimit() {
        return this.numUpper / 3;
    }

    public void getUpperLimit(float[] fArray) {
        System.arraycopy(this.upperLimit, 0, fArray, 0, this.numUpper);
    }

    public void setUpperLimit(float[] fArray, int n) {
        if (fArray == null || fArray.length < n * 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        if (this.upperLimit == null || this.upperLimit.length < n * 3) {
            this.upperLimit = new float[n * 3];
        }
        System.arraycopy(fArray, 0, this.upperLimit, 0, n * 3);
        this.numUpper = n * 3;
    }

    public int numStiffness() {
        return this.numStiffness;
    }

    public void getStiffness(float[] fArray) {
        System.arraycopy(this.stiffness, 0, fArray, 0, this.numStiffness);
    }

    public void setStiffness(float[] fArray, int n) {
        if (fArray == null || fArray.length < n) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        if (this.stiffness == null || this.stiffness.length < n) {
            this.stiffness = new float[n];
        }
        System.arraycopy(fArray, 0, this.stiffness, 0, n);
        this.numStiffness = n;
    }

    public int numSkinCoord() {
        return this.numSkinCoord;
    }

    public void getSkinCoordIndex(float[] fArray) {
        System.arraycopy(this.skinCoordIndex, 0, fArray, 0, this.numSkinCoord);
    }

    public void setSkinCoordIndex(int[] nArray, int n) {
        if (nArray == null || nArray.length < n) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        if (this.skinCoordIndex == null || this.skinCoordIndex.length < n) {
            this.skinCoordIndex = new int[n];
            float[] fArray = new float[n];
            if (this.skinCoordWeight != null) {
                System.arraycopy(this.skinCoordWeight, 0, fArray, 0, this.numSkinCoord);
            }
            this.skinCoordWeight = fArray;
        }
        System.arraycopy(nArray, 0, this.skinCoordIndex, 0, n);
        this.numSkinCoord = n;
        this.sendUpdateMsg();
    }

    public void getSkinCoordWeight(float[] fArray) {
        System.arraycopy(this.skinCoordWeight, 0, fArray, 0, this.numSkinCoord);
    }

    public void setSkinCoordWeight(float[] fArray) {
        if (fArray == null || fArray.length < this.numSkinCoord) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        System.arraycopy(fArray, 0, this.skinCoordWeight, 0, this.numSkinCoord);
        this.numSkinCoord = this.numSkinCoord;
        this.sendUpdateMsg();
    }

    public int numChildren() {
        return this.numChildren;
    }

    public void getChildren(HAnimObject[] hAnimObjectArray) {
        System.arraycopy(this.children, 0, hAnimObjectArray, 0, this.numChildren);
    }

    public void setChildren(HAnimObject[] hAnimObjectArray, int n) {
        int n2;
        if (this.children == null || this.children.length < n) {
            this.children = new HAnimObject[n];
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (!(hAnimObjectArray[n2] instanceof HAnimJoint || hAnimObjectArray[n2] instanceof HAnimSegment || hAnimObjectArray[n2] instanceof HAnimSite)) {
                throw new IllegalArgumentException(INVALID_CHILD_TYPE_MSG);
            }
            this.children[n2] = hAnimObjectArray[n2];
            if (hAnimObjectArray[n2] instanceof HAnimJoint) {
                ((HAnimJoint)hAnimObjectArray[n2]).setParent(this, this.sourceCoords, this.numSourceCoords, this.sourceNormals, this.numSourceNormals, this.outputCoords, this.outputNormals);
                continue;
            }
            if (!(hAnimObjectArray[n2] instanceof HAnimSite)) continue;
            ((HAnimSite)hAnimObjectArray[n2]).setParent(this);
        }
        for (n2 = n; n2 < this.numChildren; ++n2) {
            this.children[n2] = null;
        }
        this.numChildren = n;
        this.sendUpdateMsg();
    }

    public void addChild(HAnimObject hAnimObject) {
        if (!(hAnimObject instanceof HAnimJoint || hAnimObject instanceof HAnimSegment || hAnimObject instanceof HAnimSite)) {
            throw new IllegalArgumentException(INVALID_CHILD_TYPE_MSG);
        }
        if (this.children == null || this.children.length == this.numChildren) {
            HAnimObject[] hAnimObjectArray = new HAnimObject[this.numChildren + 4];
            if (this.numDisplacers != 0) {
                System.arraycopy(this.children, 0, hAnimObjectArray, 0, this.numChildren);
            }
            this.children = hAnimObjectArray;
        }
        this.children[this.numChildren++] = hAnimObject;
        hAnimObject.setErrorReporter(this.errorReporter);
        if (hAnimObject instanceof HAnimJoint) {
            ((HAnimJoint)hAnimObject).setParent(this, this.sourceCoords, this.numSourceCoords, this.sourceNormals, this.numSourceNormals, this.outputCoords, this.outputNormals);
        } else if (hAnimObject instanceof HAnimSite) {
            ((HAnimSite)hAnimObject).setParent(this);
        }
        this.sendUpdateMsg();
    }

    public void removeChild(HAnimObject hAnimObject) {
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] != hAnimObject) continue;
            System.arraycopy(this.children, i + 1, this.children, i, this.numChildren - i - 1);
            break;
        }
        --this.numChildren;
    }

    public int numDisplacers() {
        return this.numDisplacers;
    }

    public void getDisplacers(HAnimDisplacer[] hAnimDisplacerArray) {
        System.arraycopy(this.displacers, 0, hAnimDisplacerArray, 0, this.numDisplacers);
    }

    public void setDisplacers(HAnimDisplacer[] hAnimDisplacerArray, int n) {
        if (this.displacers == null || this.displacers.length < n) {
            this.displacers = new HAnimDisplacer[n];
        }
        if (n != 0) {
            System.arraycopy(hAnimDisplacerArray, 0, this.displacers, 0, n);
        }
        for (int i = n; i < this.numDisplacers; ++i) {
            this.displacers[i] = null;
        }
        this.numDisplacers = n;
        this.sendUpdateMsg();
    }

    public void addDisplacer(HAnimDisplacer hAnimDisplacer) {
        if (this.displacers == null || this.displacers.length == this.numDisplacers) {
            HAnimDisplacer[] hAnimDisplacerArray = new HAnimDisplacer[this.numDisplacers + 4];
            if (this.numDisplacers != 0) {
                System.arraycopy(this.displacers, 0, hAnimDisplacerArray, 0, this.numDisplacers);
            }
            this.displacers = hAnimDisplacerArray;
        }
        this.displacers[this.numDisplacers++] = hAnimDisplacer;
        this.sendUpdateMsg();
    }

    public void removeDisplacer(HAnimDisplacer hAnimDisplacer) {
        for (int i = 0; i < this.numDisplacers; ++i) {
            if (this.displacers[i] != hAnimDisplacer) continue;
            System.arraycopy(this.displacers, i + 1, this.displacers, i, this.numDisplacers - i - 1);
            this.sendUpdateMsg();
            break;
        }
    }

    protected void setParent(HAnimObjectParent hAnimObjectParent, float[] fArray, int n, float[] fArray2, int n2, Object object, Object object2) {
        this.parent = hAnimObjectParent;
        this.sourceCoords = fArray;
        this.sourceNormals = fArray2;
        this.outputCoords = object;
        this.outputNormals = object2;
        this.numSourceCoords = n;
        this.numSourceNormals = n2;
        this.objectIndex = hAnimObjectParent.requestNextObjectIndex();
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] instanceof HAnimJoint) {
                ((HAnimJoint)this.children[i]).setParent(this, fArray, n, fArray2, n2, object, object2);
                continue;
            }
            if (!(this.children[i] instanceof HAnimSite)) continue;
            ((HAnimSite)this.children[i]).setParent(this);
        }
    }

    protected void updateSources(float[] fArray, int n, float[] fArray2, int n2, Object object, Object object2) {
        this.sourceCoords = fArray;
        this.sourceNormals = fArray2;
        this.outputCoords = object;
        this.outputNormals = object2;
        this.numSourceCoords = n;
        this.numSourceNormals = n2;
        for (int i = 0; i < this.numChildren; ++i) {
            if (!(this.children[i] instanceof HAnimJoint)) continue;
            ((HAnimJoint)this.children[i]).updateSources(fArray, n, fArray2, n2, object, object2);
        }
    }

    protected void updateSkeleton(Matrix4f matrix4f, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl || this.matrixChanged;
        if (this.matrixChanged) {
            HAnimJoint.updateMatrix(this.center, this.rotation, this.scale, this.scaleOrientation, this.translation, this.localMatrix);
            this.matrixChanged = false;
        }
        if (bl2) {
            this.globalMatrix.mul(matrix4f, this.localMatrix);
        }
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] instanceof HAnimJoint) {
                ((HAnimJoint)this.children[i]).updateSkeleton(this.globalMatrix, bl2);
                continue;
            }
            if (!(this.children[i] instanceof HAnimSite)) continue;
            ((HAnimSite)this.children[i]).updateLocation(this.globalMatrix, bl2);
        }
        this.updateSent = false;
    }

    protected void sendUpdateMsg() {
        if (!this.updateSent && this.parent != null) {
            this.parent.childUpdateRequired(this);
            this.updateSent = true;
        }
    }
}

