-- lib/tongue.lua
--
-- Lua I18N library 'Tongue'
--
-- Copyright 2016 Daniel Silverstone <dsilvers@digital-scurf.org>
--
-- For licence terms, see COPYING
--

--- Lua I18N library - Tongue
--

local _VERSION = 1
local _ABI = 1

local VERSION = "Tongue Version " .. tostring(_VERSION)

local codex = require "tongue.codex"
local langpack = require "tongue.langpack"
local transliteration = require "tongue.transliteration"
local util = require "tongue.util"

return {
   _VERSION = _VERSION,
   VERSION = VERSION,
   _ABI = _ABI,
   ABI = ABI,
   codex = codex,
   langpack = langpack,
   transliteration = transliteration,
   translit = transliteration,
   t13n = transliteration,
   util = util,
}
