#	File ports.tcl
#	GUI for selection of ALSA port.

proc port_setup {} {
	global tcl_rcFileName
	global ports
	global iolists
	global font12

	set ports .setup
	toplevel $ports
	wm title $ports "TK-707 ALSA port setup"

	set howto .setup.h
	set howtotext $howto.text
	set howtoscroll $howto.scroll
	frame $howto ;#-relief groove -borderwidth 2
	canvas $howtotext -yscrollcommand "$howtoscroll set" -width 13.5c -height 5c
	scrollbar $howtoscroll -command "$howtotext yview" -width 0.4c
	pack $howtoscroll -side right -fill y
	pack $howtotext
	pack $howto

	$howtotext create text 0.2c 0.2c -anchor nw -font *-${font12}-* -text	\
"Double click on one of Output Ports to make it the Selected Output.\n
The SAVE button will save the setting in ~/.tk707rc so that this
selection dialogue won't appear next time TK-707 is started.\n
The OK button will close this dialogue and allow TK-707 to start
using the selected port. If the current setting hasn't been SAVEd
then this dialogue will appear again next time TK-707 is run.
If no port has been selected, TK707 will not start.\n
Input Port selection is for future use and currently has no effect.\n
When this selection dialogue is raised from the File->Ports menu,
a selection can be SAVEd but ports cannot be changed while
TK-707 is running (yet)."

	set iolists $ports.l
	canvas $iolists -width 14c -height 8c -relief groove -borderwidth 2
	pack $iolists
	set	olist $iolists.ol
	set	ilist $iolists.il
	set oselect $iolists.op
	set iselect $iolists.ip
	listbox $olist -font *-${font12}-* -width 28 -height 6 -selectmode browse -exportselection 1
	listbox $ilist -font *-${font12}-* -width 28 -height 6 -selectmode browse -exportselection 1
	label $oselect -width 28 -height 1 -relief sunken -borderwidth 2
	label $iselect -width 28 -height 1 -relief sunken -borderwidth 2

	$iolists create text 2c 0.5c -font *-${font12}-* -text "Input Ports" -anchor nw
	$iolists create text 9c 0.5c -font *-${font12}-* -text "Output Ports" -anchor nw
	$iolists create window 0.15c 1.5c -window $ilist -anchor nw
	$iolists create window 7c 1.5c -window $olist -anchor nw
	$iolists create window 0.2c 6c -window $iselect -anchor nw
	$iolists create window 7.05c 6c -window $oselect -anchor nw
	$iolists create text 2c 7c -font *-${font12}-* -text "Selected Input" -anchor nw
	$iolists create text 9c 7c -font *-${font12}-* -text "Selected Output" -anchor nw

	# Get list of output ports
	set oportlist [tk7_port_list 1]
	foreach i $oportlist {
		if {[regexp -nocase "MIDI" $i]} {
			$olist insert end $i
		}
	}
	# Get list of input ports
	set iportlist [tk7_port_list 0]
	foreach i $iportlist {
		if {[regexp -nocase "midi" $i]} {
			$ilist insert end $i
		}
	}
	bind .setup.l.il <Double-1> {
		$iolists.ip configure -font *-${font12}-* -text [selection get]
	}
	bind $olist <Double-1> {
		$iolists.op configure -font *-${font12}-* -text [selection get]
	}
	set portacts $ports.pa
	canvas $portacts -width 14c -height 1.5c
	pack $portacts

	button $portacts.c -font *-${font12}-* -text CANCEL -width 6 -command {
		if {! [tk7_port_setcheck]} {
			puts "NO PORTS SET"
			destroy .
			exit
		} else {
			destroy $ports
		}
	}
	button $portacts.s -font *-${font12}-* -text SAVE -width 6 -command {
		set oplist [.setup.l.op configure -text]
		# puts "XX${oplist}XX"
		if {[llength $oplist] != 5} {
			puts nothing
		} else {
			if {[llength [lindex $oplist 4]] > 0} {
				set op [lindex [lindex $oplist 4] 0]
				set oc [lindex [lindex $oplist 4] 1]
				set tkxox(ALSA_OUTPORT) "${op}:${oc}"
				# Save selection
				set OPstr [format "set tkxox(ALSA_OUTPORT) %d:%d" $op $oc]
				set f [open $tcl_rcFileName w]
				seek $f  0 end
				puts $f $OPstr
				close $f
				destroy $ports
			}
		}
	}
	button $portacts.b -font *-${font12}-* -text OK -width 6 -command {
		set oplist [.setup.l.op configure -text]
		if {[llength $oplist] != 5} {
			puts nothing
		} else {
			if {[llength [lindex $oplist 4]] > 0} {
				set op [lindex [lindex $oplist 4] 0]
				set oc [lindex [lindex $oplist 4] 1]
				set tkxox(ALSA_OUTPORT) "${op}:${oc}"
			}
		}
		if {! [tk7_port_setcheck]} {
			#puts "NO PORTS SET"
			destroy .
			exit
		} else {
			destroy $ports
		}
	}
	$portacts create window 3c 0.75c -window  $portacts.c
	$portacts create window 7c 0.75c -window  $portacts.s
	$portacts create window 11c 0.75c -window  $portacts.b

	grab set $ports
	tkwait window $portacts
}
