## TFSA-2023-004: Segfault when opening multiframe gif

### CVE Number
CVE-2023-25667

### Impact
Integer overflow occurs when 2^31 <= num_frames * height * width * channels < 2^32, for example Full HD screencast of at least 346 frames.
```python
import urllib.request
dat = urllib.request.urlopen('https://raw.githubusercontent.com/tensorflow/tensorflow/1c38ad9b78ffe06076745a1ee00cec42f39ff726/tensorflow/core/lib/gif/testdata/3g_multiframe.gif').read()
import tensorflow as tf
tf.io.decode_gif(dat)
```

### Patches
We have patched the issue in GitHub commit [8dc723fcdd1a6127d6c970bd2ecb18b019a1a58d](https://github.com/tensorflow/tensorflow/commit/8dc723fcdd1a6127d6c970bd2ecb18b019a1a58d).

The fix will be included in TensorFlow 2.12.0. We will also cherrypick this commit on TensorFlow 2.11.1


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Andrei





