; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-gnu-linux -mcpu=cortex-a57 < %s | FileCheck %s --check-prefixes=CHECK,CHECK-STD
; RUN: llc -mtriple=aarch64-gnu-linux -mcpu=cortex-a57 -enable-unsafe-fp-math < %s | FileCheck %s --check-prefixes=CHECK,CHECK-UNSAFE

; Incremental updates of the instruction depths should be enough for this test
; case.
; RUN: llc -mtriple=aarch64-gnu-linux -mcpu=cortex-a57 -enable-unsafe-fp-math \
; RUN:     -machine-combiner-inc-threshold=0 -machine-combiner-verify-pattern-order=true < %s | FileCheck %s --check-prefixes=CHECK,CHECK-UNSAFE

; Verify that the first two adds are independent regardless of how the inputs are
; commuted. The destination registers are used as source registers for the third add.

define float @reassociate_adds1(float %x0, float %x1, float %x2, float %x3) {
; CHECK-STD-LABEL: reassociate_adds1:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd s0, s0, s1
; CHECK-STD-NEXT:    fadd s0, s0, s2
; CHECK-STD-NEXT:    fadd s0, s0, s3
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds1:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s1, s2, s3
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd float %x0, %x1
  %t1 = fadd float %t0, %x2
  %t2 = fadd float %t1, %x3
  ret float %t2
}

define float @reassociate_adds1_fast(float %x0, float %x1, float %x2, float %x3) {
; CHECK-LABEL: reassociate_adds1_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    fadd s1, s2, s3
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ret
  %t0 = fadd fast float %x0, %x1
  %t1 = fadd fast float %t0, %x2
  %t2 = fadd fast float %t1, %x3
  ret float %t2
}

define float @reassociate_adds1_reassoc(float %x0, float %x1, float %x2, float %x3) {
; CHECK-STD-LABEL: reassociate_adds1_reassoc:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd s0, s0, s1
; CHECK-STD-NEXT:    fadd s0, s0, s2
; CHECK-STD-NEXT:    fadd s0, s0, s3
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds1_reassoc:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s1, s2, s3
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd reassoc float %x0, %x1
  %t1 = fadd reassoc float %t0, %x2
  %t2 = fadd reassoc float %t1, %x3
  ret float %t2
}

define float @reassociate_adds2(float %x0, float %x1, float %x2, float %x3) {
; CHECK-STD-LABEL: reassociate_adds2:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd s0, s0, s1
; CHECK-STD-NEXT:    fadd s0, s2, s0
; CHECK-STD-NEXT:    fadd s0, s0, s3
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds2:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s1, s2, s3
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd float %x0, %x1
  %t1 = fadd float %x2, %t0
  %t2 = fadd float %t1, %x3
  ret float %t2
}

define float @reassociate_adds3(float %x0, float %x1, float %x2, float %x3) {
; CHECK-STD-LABEL: reassociate_adds3:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd s0, s0, s1
; CHECK-STD-NEXT:    fadd s0, s0, s2
; CHECK-STD-NEXT:    fadd s0, s3, s0
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds3:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s1, s2, s3
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd float %x0, %x1
  %t1 = fadd float %t0, %x2
  %t2 = fadd float %x3, %t1
  ret float %t2
}

define float @reassociate_adds4(float %x0, float %x1, float %x2, float %x3) {
; CHECK-STD-LABEL: reassociate_adds4:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd s0, s0, s1
; CHECK-STD-NEXT:    fadd s0, s2, s0
; CHECK-STD-NEXT:    fadd s0, s3, s0
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds4:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s1, s2, s3
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd float %x0, %x1
  %t1 = fadd float %x2, %t0
  %t2 = fadd float %x3, %t1
  ret float %t2
}

; Verify that we reassociate some of these ops. The optimal balanced tree of adds is not
; produced because that would cost more compile time.

define float @reassociate_adds5(float %x0, float %x1, float %x2, float %x3, float %x4, float %x5, float %x6, float %x7) {
; CHECK-STD-LABEL: reassociate_adds5:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd s0, s0, s1
; CHECK-STD-NEXT:    fadd s0, s0, s2
; CHECK-STD-NEXT:    fadd s0, s0, s3
; CHECK-STD-NEXT:    fadd s0, s0, s4
; CHECK-STD-NEXT:    fadd s0, s0, s5
; CHECK-STD-NEXT:    fadd s0, s0, s6
; CHECK-STD-NEXT:    fadd s0, s0, s7
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds5:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s1, s2, s3
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s1, s4, s5
; CHECK-UNSAFE-NEXT:    fadd s1, s1, s6
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s7
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd float %x0, %x1
  %t1 = fadd float %t0, %x2
  %t2 = fadd float %t1, %x3
  %t3 = fadd float %t2, %x4
  %t4 = fadd float %t3, %x5
  %t5 = fadd float %t4, %x6
  %t6 = fadd float %t5, %x7
  ret float %t6
}

; Verify that we only need two associative operations to reassociate the operands.
; Also, we should reassociate such that the result of the high latency division
; is used by the final 'add' rather than reassociating the %x3 operand with the
; division. The latter reassociation would not improve anything.

define float @reassociate_adds6(float %x0, float %x1, float %x2, float %x3) {
; CHECK-STD-LABEL: reassociate_adds6:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fdiv s0, s0, s1
; CHECK-STD-NEXT:    fadd s0, s2, s0
; CHECK-STD-NEXT:    fadd s0, s3, s0
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds6:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fdiv s0, s0, s1
; CHECK-UNSAFE-NEXT:    fadd s1, s2, s3
; CHECK-UNSAFE-NEXT:    fadd s0, s0, s1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fdiv float %x0, %x1
  %t1 = fadd float %x2, %t0
  %t2 = fadd float %x3, %t1
  ret float %t2
}

; Verify that scalar single-precision multiplies are reassociated.

define float @reassociate_muls1(float %x0, float %x1, float %x2, float %x3) {
; CHECK-STD-LABEL: reassociate_muls1:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fdiv s0, s0, s1
; CHECK-STD-NEXT:    fmul s1, s2, s0
; CHECK-STD-NEXT:    fmul s0, s3, s1
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_muls1:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fdiv s0, s0, s1
; CHECK-UNSAFE-NEXT:    fmul s1, s2, s3
; CHECK-UNSAFE-NEXT:    fmul s0, s0, s1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fdiv float %x0, %x1
  %t1 = fmul float %x2, %t0
  %t2 = fmul float %x3, %t1
  ret float %t2
}

; Verify that scalar double-precision adds are reassociated.

define double @reassociate_adds_double(double %x0, double %x1, double %x2, double %x3) {
; CHECK-STD-LABEL: reassociate_adds_double:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fdiv d0, d0, d1
; CHECK-STD-NEXT:    fadd d0, d2, d0
; CHECK-STD-NEXT:    fadd d0, d3, d0
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds_double:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fdiv d0, d0, d1
; CHECK-UNSAFE-NEXT:    fadd d1, d2, d3
; CHECK-UNSAFE-NEXT:    fadd d0, d0, d1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fdiv double %x0, %x1
  %t1 = fadd double %x2, %t0
  %t2 = fadd double %x3, %t1
  ret double %t2
}

; Verify that scalar double-precision multiplies are reassociated.

define double @reassociate_muls_double(double %x0, double %x1, double %x2, double %x3) {
; CHECK-STD-LABEL: reassociate_muls_double:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fdiv d0, d0, d1
; CHECK-STD-NEXT:    fmul d1, d2, d0
; CHECK-STD-NEXT:    fmul d0, d3, d1
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_muls_double:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fdiv d0, d0, d1
; CHECK-UNSAFE-NEXT:    fmul d1, d2, d3
; CHECK-UNSAFE-NEXT:    fmul d0, d0, d1
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fdiv double %x0, %x1
  %t1 = fmul double %x2, %t0
  %t2 = fmul double %x3, %t1
  ret double %t2
}

; Verify that we reassociate vector instructions too.

define <4 x float> @vector_reassociate_adds1(<4 x float> %x0, <4 x float> %x1, <4 x float> %x2, <4 x float> %x3) {
; CHECK-STD-LABEL: vector_reassociate_adds1:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v2.4s
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v3.4s
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: vector_reassociate_adds1:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    fadd v1.4s, v2.4s, v3.4s
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd <4 x float> %x0, %x1
  %t1 = fadd <4 x float> %t0, %x2
  %t2 = fadd <4 x float> %t1, %x3
  ret <4 x float> %t2
}

define <4 x float> @vector_reassociate_adds2(<4 x float> %x0, <4 x float> %x1, <4 x float> %x2, <4 x float> %x3) {
; CHECK-STD-LABEL: vector_reassociate_adds2:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-STD-NEXT:    fadd v0.4s, v2.4s, v0.4s
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v3.4s
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: vector_reassociate_adds2:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    fadd v1.4s, v2.4s, v3.4s
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd <4 x float> %x0, %x1
  %t1 = fadd <4 x float> %x2, %t0
  %t2 = fadd <4 x float> %t1, %x3
  ret <4 x float> %t2
}

define <4 x float> @vector_reassociate_adds3(<4 x float> %x0, <4 x float> %x1, <4 x float> %x2, <4 x float> %x3) {
; CHECK-STD-LABEL: vector_reassociate_adds3:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v2.4s
; CHECK-STD-NEXT:    fadd v0.4s, v3.4s, v0.4s
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: vector_reassociate_adds3:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    fadd v1.4s, v2.4s, v3.4s
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd <4 x float> %x0, %x1
  %t1 = fadd <4 x float> %t0, %x2
  %t2 = fadd <4 x float> %x3, %t1
  ret <4 x float> %t2
}

define <4 x float> @vector_reassociate_adds4(<4 x float> %x0, <4 x float> %x1, <4 x float> %x2, <4 x float> %x3) {
; CHECK-STD-LABEL: vector_reassociate_adds4:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-STD-NEXT:    fadd v0.4s, v2.4s, v0.4s
; CHECK-STD-NEXT:    fadd v0.4s, v3.4s, v0.4s
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: vector_reassociate_adds4:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    fadd v1.4s, v2.4s, v3.4s
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd <4 x float> %x0, %x1
  %t1 = fadd <4 x float> %x2, %t0
  %t2 = fadd <4 x float> %x3, %t1
  ret <4 x float> %t2
}
; Verify that 128-bit vector single-precision multiplies are reassociated.

define <4 x float> @reassociate_muls_v4f32(<4 x float> %x0, <4 x float> %x1, <4 x float> %x2, <4 x float> %x3) {
; CHECK-STD-LABEL: reassociate_muls_v4f32:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-STD-NEXT:    fmul v0.4s, v2.4s, v0.4s
; CHECK-STD-NEXT:    fmul v0.4s, v3.4s, v0.4s
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_muls_v4f32:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    fmul v1.4s, v2.4s, v3.4s
; CHECK-UNSAFE-NEXT:    fmul v0.4s, v0.4s, v1.4s
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd <4 x float> %x0, %x1
  %t1 = fmul <4 x float> %x2, %t0
  %t2 = fmul <4 x float> %x3, %t1
  ret <4 x float> %t2
}

; Verify that 128-bit vector double-precision multiplies are reassociated.

define <2 x double> @reassociate_muls_v2f64(<2 x double> %x0, <2 x double> %x1, <2 x double> %x2, <2 x double> %x3) {
; CHECK-STD-LABEL: reassociate_muls_v2f64:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    fadd v0.2d, v0.2d, v1.2d
; CHECK-STD-NEXT:    fmul v0.2d, v2.2d, v0.2d
; CHECK-STD-NEXT:    fmul v0.2d, v3.2d, v0.2d
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_muls_v2f64:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    fadd v0.2d, v0.2d, v1.2d
; CHECK-UNSAFE-NEXT:    fmul v1.2d, v2.2d, v3.2d
; CHECK-UNSAFE-NEXT:    fmul v0.2d, v0.2d, v1.2d
; CHECK-UNSAFE-NEXT:    ret
  %t0 = fadd <2 x double> %x0, %x1
  %t1 = fmul <2 x double> %x2, %t0
  %t2 = fmul <2 x double> %x3, %t1
  ret <2 x double> %t2
}

; PR25016: https://llvm.org/bugs/show_bug.cgi?id=25016
; Verify that reassociation is not happening needlessly or wrongly.

declare double @bar()

define double @reassociate_adds_from_calls() {
; CHECK-STD-LABEL: reassociate_adds_from_calls:
; CHECK-STD:       // %bb.0:
; CHECK-STD-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-STD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-STD-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-STD-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-STD-NEXT:    .cfi_offset w30, -8
; CHECK-STD-NEXT:    .cfi_offset b8, -16
; CHECK-STD-NEXT:    .cfi_offset b9, -24
; CHECK-STD-NEXT:    .cfi_offset b10, -32
; CHECK-STD-NEXT:    bl bar
; CHECK-STD-NEXT:    fmov d8, d0
; CHECK-STD-NEXT:    bl bar
; CHECK-STD-NEXT:    fmov d9, d0
; CHECK-STD-NEXT:    bl bar
; CHECK-STD-NEXT:    fmov d10, d0
; CHECK-STD-NEXT:    bl bar
; CHECK-STD-NEXT:    fadd d1, d8, d9
; CHECK-STD-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-STD-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-STD-NEXT:    fadd d1, d1, d10
; CHECK-STD-NEXT:    fadd d0, d1, d0
; CHECK-STD-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-STD-NEXT:    ret
;
; CHECK-UNSAFE-LABEL: reassociate_adds_from_calls:
; CHECK-UNSAFE:       // %bb.0:
; CHECK-UNSAFE-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-UNSAFE-NEXT:    .cfi_def_cfa_offset 32
; CHECK-UNSAFE-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-UNSAFE-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-UNSAFE-NEXT:    .cfi_offset w30, -8
; CHECK-UNSAFE-NEXT:    .cfi_offset b8, -16
; CHECK-UNSAFE-NEXT:    .cfi_offset b9, -24
; CHECK-UNSAFE-NEXT:    .cfi_offset b10, -32
; CHECK-UNSAFE-NEXT:    bl bar
; CHECK-UNSAFE-NEXT:    fmov d8, d0
; CHECK-UNSAFE-NEXT:    bl bar
; CHECK-UNSAFE-NEXT:    fmov d9, d0
; CHECK-UNSAFE-NEXT:    bl bar
; CHECK-UNSAFE-NEXT:    fmov d10, d0
; CHECK-UNSAFE-NEXT:    bl bar
; CHECK-UNSAFE-NEXT:    fadd d1, d8, d9
; CHECK-UNSAFE-NEXT:    fadd d0, d10, d0
; CHECK-UNSAFE-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-UNSAFE-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-UNSAFE-NEXT:    fadd d0, d1, d0
; CHECK-UNSAFE-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-UNSAFE-NEXT:    ret
  %x0 = call double @bar()
  %x1 = call double @bar()
  %x2 = call double @bar()
  %x3 = call double @bar()
  %t0 = fadd double %x0, %x1
  %t1 = fadd double %t0, %x2
  %t2 = fadd double %t1, %x3
  ret double %t2
}

define double @already_reassociated() {
; CHECK-LABEL: already_reassociated:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset w30, -8
; CHECK-NEXT:    .cfi_offset b8, -16
; CHECK-NEXT:    .cfi_offset b9, -24
; CHECK-NEXT:    .cfi_offset b10, -32
; CHECK-NEXT:    bl bar
; CHECK-NEXT:    fmov d8, d0
; CHECK-NEXT:    bl bar
; CHECK-NEXT:    fmov d9, d0
; CHECK-NEXT:    bl bar
; CHECK-NEXT:    fmov d10, d0
; CHECK-NEXT:    bl bar
; CHECK-NEXT:    fadd d1, d8, d9
; CHECK-NEXT:    fadd d0, d10, d0
; CHECK-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-NEXT:    fadd d0, d1, d0
; CHECK-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %x0 = call double @bar()
  %x1 = call double @bar()
  %x2 = call double @bar()
  %x3 = call double @bar()
  %t0 = fadd double %x0, %x1
  %t1 = fadd double %x2, %x3
  %t2 = fadd double %t0, %t1
  ret double %t2
}

