<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:wfw="http://wellformedweb.org/CommentAPI/">
    <xsl:output method="html"/>
    <xsl:template match="/">
        <xsl:apply-templates select="/rss/channel"/>
    </xsl:template>
    <xsl:template match="/rss/channel">
        <h3><xsl:value-of select="title"/></h3>
        <p><xsl:value-of select="description"/></p>
        <p>Date of publication: <xsl:value-of select="pubDate"/></p>
        <ul>
            <xsl:apply-templates select="item"/>
        </ul>
    </xsl:template>
    <xsl:template match="/rss/channel/item">
        <li>
            <h3><xsl:value-of select="title"/></h3>
            <p><i>Date: <xsl:value-of select="pubDate"/></i>
            <br/>
            <xsl:value-of select="description" disable-output-escaping="yes" /></p>
        </li>
    </xsl:template>
</xsl:stylesheet>
