6.2 FX in der Praxis

# FX Praxis

Auf den ersten Blick mögen die Effekte von Sonic Pi sehr einfach
aussehen, aber in Wirklichkeit sind sie höchst komplexe Gebilde. Ihre
scheinbare Einfachheit verleitet manche dazu, zu viele FX in ihre
Projekte einzubauen. Das kann durchaus Spaß machen, wenn Du über einen
sehr starken Computer hast. Aber falls Du - so wie ich - einen
einfachen Raspberry Pi zum Musikmachen benutzt, musst Du darauf
achten, die Maschine nicht zu überlasten. Nur so kannst Du sicher gehen,
dass Sonic Pi ordentlich funktioniert und im Takt bleibt.

Sie Dir den folgenden Code an:

```
loop do
  with_fx :reverb do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

Hier spielen wir die Note 60 mit sehr kurzem `release:`-Wert, und 
erzeugen so einen sehr kurzen Ton. Wir wollen außerdem einen 
Hall-Effekt, und haben deshalb den notwendigen Code-Block außen herum
geschrieben. Soweit sieht alles gut aus. Oder doch nicht?

Sehen wir uns genauer an, was der Code hier macht. Zuerst einmal haben 
wir einen Loop, und wie wir ja schon wissen wird alles, was innerhalb 
der Endlosschleife geschrieben ist, für immer und ewig wiederholt.
Außerdem  haben wir einen `with_fx:`-do/end-Block. Das bedeutet, dass
bei jeder Wiederholung des Loops ein neuer Hall-Effekt erzeugt wird. Das
ist so, als ob wir jedes Mal, wenn wir eine Gitarrenseite zupfen, ein
neues Pedal an die Effektkette hängen würden. Es ist ja ganz nett, das
wir das machen können, aber es ist möglicherweise nicht das, was wir
eigentlich wollen. Ein kleiner Raspberry Pi wird an diesem Code schwer
zu arbeiten haben. Die `with_fx:`-Funktion erledigt die ganze Arbeit,
bei jeder Wiederholung des Loops den Hall-Effekt zu erzeugen, dann zu 
warten, und dann den Effekt wieder zu entfernen, aber insgesamt werden 
dabei wertvolle CPU Ressourcen verbraucht.

Wie können wir einen ähnlichen Code-Block schreiben, bei dem unser 
Gitarrist nur ein einzelnes Hall-Effektpedal zur Klangerzeugung benutzt?
Ganz einfach:

```
with_fx :reverb do
  loop do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

Nun haben wir unseren Loop ins Innere des `with_fx:`-Blocks verpackt. 
So wird nur noch ein einziger Hall-Effekt erzeugt und auf alle Noten 
im Loop angewandt. Dieser Code-Block ist viel effizienter und wird 
auf jedem Raspberry Pi gut funktionieren.

Als Kompromiss könnten wir `with_fx:` auch als 'iteration' innerhalb
eines Loops schreiben:

```
loop do
  with_fx :reverb do
    16.times do
      play 60, release: 0.1
      sleep 0.125
    end
  end
end
```

Somit wird die `with_fx:`-Funktion aus dem Inneren des Loops geholt, und 
der Code erzeugt jetzt nur noch einen Hall-Effekt alle 16 Noten.

Denk daran, man kann nichts falsch machen, dafür aber unendlich viele 
Varianten ausprobieren! Jede dieser Varianten wird sich jedoch ein 
bisschen anders anhören, und jeweils mehr oder weniger gut 
funktionieren. Es ist also empfehlenswert, so viel wie möglich zu 
experimentieren, bis Du die Variante gefunden hast, die am besten 
funktioniert und den Einschränkungen Deines Computers am besten gerecht 
wird.
