#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:24:46 
# conf/unconfig-pam_mountconf.sh

### P A R A M S
MYMOUNTPOINT="$1"

### I N C L U D E S
. ./_include.sh

### M O D I F I E D   F I L E S ...
pammountconf=pam_mount.conf

### S T A R T

echo "+remove pam_mount configuration"

# R E M O V E   P A M _ M O U N T . C O N F
if [ -f ${SECDIR}/${pammountconf} ]; then
	echo "remove ${SECDIR}/${pammountconf}"
	rm -f ${SECDIR}/${pammountconf}
fi

# R E M O V E   M O U N T P O I N T
echo "+remove mount point"
subhome=${MYMOUNTPOINT#\~/}
if [ "${MYMOUNTPOINT}" != "${subhome}" ]; then
	echo "home ${subhome} within user's home"
	# remove mount point to /etc/skel
	if [ -d ${SKELDIR}/${subhome} ]; then
		echo "remove mount point ${SKELDIR}/${subhome}"
		rmdir ${SKELDIR}/${subhome}
	fi
else
	echo "home ${subhome} outside user's home"
	if [ ! "${MYMOUNTPOINT}" = "" ] && [ -d ${MYMOUNTPOINT} ];then
		echo "remove mount point ${MYMOUNTPOINT}"
		rmdir ${MYMOUNTPOINT}
	fi
fi
