// SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note

// This file was generated by running
//
//     bindgen include/uapi/linux/vfio.h --allowlist-file include/uapi/linux/vfio.h \
//         --with-derive-default --no-layout-tests -o bindings.rs -- -I include
//
// at the root of the Linux 5.19.0 tree. The SPDX header and this note were then added manually.

/* automatically generated by rust-bindgen 0.60.1 */

#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const VFIO_API_VERSION: u32 = 0;
pub const VFIO_TYPE1_IOMMU: u32 = 1;
pub const VFIO_SPAPR_TCE_IOMMU: u32 = 2;
pub const VFIO_TYPE1v2_IOMMU: u32 = 3;
pub const VFIO_DMA_CC_IOMMU: u32 = 4;
pub const VFIO_EEH: u32 = 5;
pub const VFIO_TYPE1_NESTING_IOMMU: u32 = 6;
pub const VFIO_SPAPR_TCE_v2_IOMMU: u32 = 7;
pub const VFIO_NOIOMMU_IOMMU: u32 = 8;
pub const VFIO_UNMAP_ALL: u32 = 9;
pub const VFIO_UPDATE_VADDR: u32 = 10;
pub const VFIO_TYPE: u8 = 59u8;
pub const VFIO_BASE: u32 = 100;
pub const VFIO_GROUP_FLAGS_VIABLE: u32 = 1;
pub const VFIO_GROUP_FLAGS_CONTAINER_SET: u32 = 2;
pub const VFIO_DEVICE_FLAGS_RESET: u32 = 1;
pub const VFIO_DEVICE_FLAGS_PCI: u32 = 2;
pub const VFIO_DEVICE_FLAGS_PLATFORM: u32 = 4;
pub const VFIO_DEVICE_FLAGS_AMBA: u32 = 8;
pub const VFIO_DEVICE_FLAGS_CCW: u32 = 16;
pub const VFIO_DEVICE_FLAGS_AP: u32 = 32;
pub const VFIO_DEVICE_FLAGS_FSL_MC: u32 = 64;
pub const VFIO_DEVICE_FLAGS_CAPS: u32 = 128;
pub const VFIO_DEVICE_API_PCI_STRING: &[u8; 9usize] = b"vfio-pci\0";
pub const VFIO_DEVICE_API_PLATFORM_STRING: &[u8; 14usize] = b"vfio-platform\0";
pub const VFIO_DEVICE_API_AMBA_STRING: &[u8; 10usize] = b"vfio-amba\0";
pub const VFIO_DEVICE_API_CCW_STRING: &[u8; 9usize] = b"vfio-ccw\0";
pub const VFIO_DEVICE_API_AP_STRING: &[u8; 8usize] = b"vfio-ap\0";
pub const VFIO_DEVICE_INFO_CAP_ZPCI_BASE: u32 = 1;
pub const VFIO_DEVICE_INFO_CAP_ZPCI_GROUP: u32 = 2;
pub const VFIO_DEVICE_INFO_CAP_ZPCI_UTIL: u32 = 3;
pub const VFIO_DEVICE_INFO_CAP_ZPCI_PFIP: u32 = 4;
pub const VFIO_REGION_INFO_FLAG_READ: u32 = 1;
pub const VFIO_REGION_INFO_FLAG_WRITE: u32 = 2;
pub const VFIO_REGION_INFO_FLAG_MMAP: u32 = 4;
pub const VFIO_REGION_INFO_FLAG_CAPS: u32 = 8;
pub const VFIO_REGION_INFO_CAP_SPARSE_MMAP: u32 = 1;
pub const VFIO_REGION_INFO_CAP_TYPE: u32 = 2;
pub const VFIO_REGION_TYPE_PCI_VENDOR_TYPE: u32 = 2147483648;
pub const VFIO_REGION_TYPE_PCI_VENDOR_MASK: u32 = 65535;
pub const VFIO_REGION_TYPE_GFX: u32 = 1;
pub const VFIO_REGION_TYPE_CCW: u32 = 2;
pub const VFIO_REGION_TYPE_MIGRATION_DEPRECATED: u32 = 3;
pub const VFIO_REGION_SUBTYPE_INTEL_IGD_OPREGION: u32 = 1;
pub const VFIO_REGION_SUBTYPE_INTEL_IGD_HOST_CFG: u32 = 2;
pub const VFIO_REGION_SUBTYPE_INTEL_IGD_LPC_CFG: u32 = 3;
pub const VFIO_REGION_SUBTYPE_NVIDIA_NVLINK2_RAM: u32 = 1;
pub const VFIO_REGION_SUBTYPE_IBM_NVLINK2_ATSD: u32 = 1;
pub const VFIO_REGION_SUBTYPE_GFX_EDID: u32 = 1;
pub const VFIO_DEVICE_GFX_LINK_STATE_UP: u32 = 1;
pub const VFIO_DEVICE_GFX_LINK_STATE_DOWN: u32 = 2;
pub const VFIO_REGION_SUBTYPE_CCW_ASYNC_CMD: u32 = 1;
pub const VFIO_REGION_SUBTYPE_CCW_SCHIB: u32 = 2;
pub const VFIO_REGION_SUBTYPE_CCW_CRW: u32 = 3;
pub const VFIO_REGION_SUBTYPE_MIGRATION_DEPRECATED: u32 = 1;
pub const VFIO_DEVICE_STATE_V1_STOP: u32 = 0;
pub const VFIO_DEVICE_STATE_V1_RUNNING: u32 = 1;
pub const VFIO_DEVICE_STATE_V1_SAVING: u32 = 2;
pub const VFIO_DEVICE_STATE_V1_RESUMING: u32 = 4;
pub const VFIO_DEVICE_STATE_MASK: u32 = 7;
pub const VFIO_REGION_INFO_CAP_MSIX_MAPPABLE: u32 = 3;
pub const VFIO_REGION_INFO_CAP_NVLINK2_SSATGT: u32 = 4;
pub const VFIO_REGION_INFO_CAP_NVLINK2_LNKSPD: u32 = 5;
pub const VFIO_IRQ_INFO_EVENTFD: u32 = 1;
pub const VFIO_IRQ_INFO_MASKABLE: u32 = 2;
pub const VFIO_IRQ_INFO_AUTOMASKED: u32 = 4;
pub const VFIO_IRQ_INFO_NORESIZE: u32 = 8;
pub const VFIO_IRQ_SET_DATA_NONE: u32 = 1;
pub const VFIO_IRQ_SET_DATA_BOOL: u32 = 2;
pub const VFIO_IRQ_SET_DATA_EVENTFD: u32 = 4;
pub const VFIO_IRQ_SET_ACTION_MASK: u32 = 8;
pub const VFIO_IRQ_SET_ACTION_UNMASK: u32 = 16;
pub const VFIO_IRQ_SET_ACTION_TRIGGER: u32 = 32;
pub const VFIO_IRQ_SET_DATA_TYPE_MASK: u32 = 7;
pub const VFIO_IRQ_SET_ACTION_TYPE_MASK: u32 = 56;
pub const VFIO_GFX_PLANE_TYPE_PROBE: u32 = 1;
pub const VFIO_GFX_PLANE_TYPE_DMABUF: u32 = 2;
pub const VFIO_GFX_PLANE_TYPE_REGION: u32 = 4;
pub const VFIO_DEVICE_IOEVENTFD_8: u32 = 1;
pub const VFIO_DEVICE_IOEVENTFD_16: u32 = 2;
pub const VFIO_DEVICE_IOEVENTFD_32: u32 = 4;
pub const VFIO_DEVICE_IOEVENTFD_64: u32 = 8;
pub const VFIO_DEVICE_IOEVENTFD_SIZE_MASK: u32 = 15;
pub const VFIO_DEVICE_FEATURE_MASK: u32 = 65535;
pub const VFIO_DEVICE_FEATURE_GET: u32 = 65536;
pub const VFIO_DEVICE_FEATURE_SET: u32 = 131072;
pub const VFIO_DEVICE_FEATURE_PROBE: u32 = 262144;
pub const VFIO_DEVICE_FEATURE_PCI_VF_TOKEN: u32 = 0;
pub const VFIO_MIGRATION_STOP_COPY: u32 = 1;
pub const VFIO_MIGRATION_P2P: u32 = 2;
pub const VFIO_DEVICE_FEATURE_MIGRATION: u32 = 1;
pub const VFIO_DEVICE_FEATURE_MIG_DEVICE_STATE: u32 = 2;
pub const VFIO_IOMMU_INFO_PGSIZES: u32 = 1;
pub const VFIO_IOMMU_INFO_CAPS: u32 = 2;
pub const VFIO_IOMMU_TYPE1_INFO_CAP_IOVA_RANGE: u32 = 1;
pub const VFIO_IOMMU_TYPE1_INFO_CAP_MIGRATION: u32 = 2;
pub const VFIO_IOMMU_TYPE1_INFO_DMA_AVAIL: u32 = 3;
pub const VFIO_DMA_MAP_FLAG_READ: u32 = 1;
pub const VFIO_DMA_MAP_FLAG_WRITE: u32 = 2;
pub const VFIO_DMA_MAP_FLAG_VADDR: u32 = 4;
pub const VFIO_DMA_UNMAP_FLAG_GET_DIRTY_BITMAP: u32 = 1;
pub const VFIO_DMA_UNMAP_FLAG_ALL: u32 = 2;
pub const VFIO_DMA_UNMAP_FLAG_VADDR: u32 = 4;
pub const VFIO_IOMMU_DIRTY_PAGES_FLAG_START: u32 = 1;
pub const VFIO_IOMMU_DIRTY_PAGES_FLAG_STOP: u32 = 2;
pub const VFIO_IOMMU_DIRTY_PAGES_FLAG_GET_BITMAP: u32 = 4;
pub const VFIO_IOMMU_SPAPR_INFO_DDW: u32 = 1;
pub const VFIO_EEH_PE_DISABLE: u32 = 0;
pub const VFIO_EEH_PE_ENABLE: u32 = 1;
pub const VFIO_EEH_PE_UNFREEZE_IO: u32 = 2;
pub const VFIO_EEH_PE_UNFREEZE_DMA: u32 = 3;
pub const VFIO_EEH_PE_GET_STATE: u32 = 4;
pub const VFIO_EEH_PE_STATE_NORMAL: u32 = 0;
pub const VFIO_EEH_PE_STATE_RESET: u32 = 1;
pub const VFIO_EEH_PE_STATE_STOPPED: u32 = 2;
pub const VFIO_EEH_PE_STATE_STOPPED_DMA: u32 = 4;
pub const VFIO_EEH_PE_STATE_UNAVAIL: u32 = 5;
pub const VFIO_EEH_PE_RESET_DEACTIVATE: u32 = 5;
pub const VFIO_EEH_PE_RESET_HOT: u32 = 6;
pub const VFIO_EEH_PE_RESET_FUNDAMENTAL: u32 = 7;
pub const VFIO_EEH_PE_CONFIGURE: u32 = 8;
pub const VFIO_EEH_PE_INJECT_ERR: u32 = 9;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_info_cap_header {
    pub id: __u16,
    pub version: __u16,
    pub next: __u32,
}
#[doc = " VFIO_GROUP_GET_STATUS - _IOR(VFIO_TYPE, VFIO_BASE + 3,"]
#[doc = "\t\t\t\t\t\tstruct vfio_group_status)"]
#[doc = ""]
#[doc = " Retrieve information about the group.  Fills in provided"]
#[doc = " struct vfio_group_info.  Caller sets argsz."]
#[doc = " Return: 0 on succes, -errno on failure."]
#[doc = " Availability: Always"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_group_status {
    pub argsz: __u32,
    pub flags: __u32,
}
#[doc = " VFIO_DEVICE_GET_INFO - _IOR(VFIO_TYPE, VFIO_BASE + 7,"]
#[doc = "\t\t\t\t\t\tstruct vfio_device_info)"]
#[doc = ""]
#[doc = " Retrieve information about the device.  Fills in provided"]
#[doc = " struct vfio_device_info.  Caller sets argsz."]
#[doc = " Return: 0 on success, -errno on failure."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_device_info {
    pub argsz: __u32,
    pub flags: __u32,
    pub num_regions: __u32,
    pub num_irqs: __u32,
    pub cap_offset: __u32,
}
#[doc = " VFIO_DEVICE_GET_REGION_INFO - _IOWR(VFIO_TYPE, VFIO_BASE + 8,"]
#[doc = "\t\t\t\t       struct vfio_region_info)"]
#[doc = ""]
#[doc = " Retrieve information about a device region.  Caller provides"]
#[doc = " struct vfio_region_info with index value set.  Caller sets argsz."]
#[doc = " Implementation of region mapping is bus driver specific.  This is"]
#[doc = " intended to describe MMIO, I/O port, as well as bus specific"]
#[doc = " regions (ex. PCI config space).  Zero sized regions may be used"]
#[doc = " to describe unimplemented regions (ex. unimplemented PCI BARs)."]
#[doc = " Return: 0 on success, -errno on failure."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_region_info {
    pub argsz: __u32,
    pub flags: __u32,
    pub index: __u32,
    pub cap_offset: __u32,
    pub size: __u64,
    pub offset: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_region_sparse_mmap_area {
    pub offset: __u64,
    pub size: __u64,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct vfio_region_info_cap_sparse_mmap {
    pub header: vfio_info_cap_header,
    pub nr_areas: __u32,
    pub reserved: __u32,
    pub areas: __IncompleteArrayField<vfio_region_sparse_mmap_area>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_region_info_cap_type {
    pub header: vfio_info_cap_header,
    pub type_: __u32,
    pub subtype: __u32,
}
#[doc = " struct vfio_region_gfx_edid - EDID region layout."]
#[doc = ""]
#[doc = " Set display link state and EDID blob."]
#[doc = ""]
#[doc = " The EDID blob has monitor information such as brand, name, serial"]
#[doc = " number, physical size, supported video modes and more."]
#[doc = ""]
#[doc = " This special region allows userspace (typically qemu) set a virtual"]
#[doc = " EDID for the virtual monitor, which allows a flexible display"]
#[doc = " configuration."]
#[doc = ""]
#[doc = " For the edid blob spec look here:"]
#[doc = "    https://en.wikipedia.org/wiki/Extended_Display_Identification_Data"]
#[doc = ""]
#[doc = " On linux systems you can find the EDID blob in sysfs:"]
#[doc = "    /sys/class/drm/${card}/${connector}/edid"]
#[doc = ""]
#[doc = " You can use the edid-decode ulility (comes with xorg-x11-utils) to"]
#[doc = " decode the EDID blob."]
#[doc = ""]
#[doc = " @edid_offset: location of the edid blob, relative to the"]
#[doc = "               start of the region (readonly)."]
#[doc = " @edid_max_size: max size of the edid blob (readonly)."]
#[doc = " @edid_size: actual edid size (read/write)."]
#[doc = " @link_state: display link state (read/write)."]
#[doc = " VFIO_DEVICE_GFX_LINK_STATE_UP: Monitor is turned on."]
#[doc = " VFIO_DEVICE_GFX_LINK_STATE_DOWN: Monitor is turned off."]
#[doc = " @max_xres: max display width (0 == no limitation, readonly)."]
#[doc = " @max_yres: max display height (0 == no limitation, readonly)."]
#[doc = ""]
#[doc = " EDID update protocol:"]
#[doc = "   (1) set link-state to down."]
#[doc = "   (2) update edid blob and size."]
#[doc = "   (3) set link-state to up."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_region_gfx_edid {
    pub edid_offset: __u32,
    pub edid_max_size: __u32,
    pub edid_size: __u32,
    pub max_xres: __u32,
    pub max_yres: __u32,
    pub link_state: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_device_migration_info {
    pub device_state: __u32,
    pub reserved: __u32,
    pub pending_bytes: __u64,
    pub data_offset: __u64,
    pub data_size: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_region_info_cap_nvlink2_ssatgt {
    pub header: vfio_info_cap_header,
    pub tgt: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_region_info_cap_nvlink2_lnkspd {
    pub header: vfio_info_cap_header,
    pub link_speed: __u32,
    pub __pad: __u32,
}
#[doc = " VFIO_DEVICE_GET_IRQ_INFO - _IOWR(VFIO_TYPE, VFIO_BASE + 9,"]
#[doc = "\t\t\t\t    struct vfio_irq_info)"]
#[doc = ""]
#[doc = " Retrieve information about a device IRQ.  Caller provides"]
#[doc = " struct vfio_irq_info with index value set.  Caller sets argsz."]
#[doc = " Implementation of IRQ mapping is bus driver specific.  Indexes"]
#[doc = " using multiple IRQs are primarily intended to support MSI-like"]
#[doc = " interrupt blocks.  Zero count irq blocks may be used to describe"]
#[doc = " unimplemented interrupt types."]
#[doc = ""]
#[doc = " The EVENTFD flag indicates the interrupt index supports eventfd based"]
#[doc = " signaling."]
#[doc = ""]
#[doc = " The MASKABLE flags indicates the index supports MASK and UNMASK"]
#[doc = " actions described below."]
#[doc = ""]
#[doc = " AUTOMASKED indicates that after signaling, the interrupt line is"]
#[doc = " automatically masked by VFIO and the user needs to unmask the line"]
#[doc = " to receive new interrupts.  This is primarily intended to distinguish"]
#[doc = " level triggered interrupts."]
#[doc = ""]
#[doc = " The NORESIZE flag indicates that the interrupt lines within the index"]
#[doc = " are setup as a set and new subindexes cannot be enabled without first"]
#[doc = " disabling the entire index.  This is used for interrupts like PCI MSI"]
#[doc = " and MSI-X where the driver may only use a subset of the available"]
#[doc = " indexes, but VFIO needs to enable a specific number of vectors"]
#[doc = " upfront.  In the case of MSI-X, where the user can enable MSI-X and"]
#[doc = " then add and unmask vectors, it's up to userspace to make the decision"]
#[doc = " whether to allocate the maximum supported number of vectors or tear"]
#[doc = " down setup and incrementally increase the vectors as each is enabled."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_irq_info {
    pub argsz: __u32,
    pub flags: __u32,
    pub index: __u32,
    pub count: __u32,
}
#[doc = " VFIO_DEVICE_SET_IRQS - _IOW(VFIO_TYPE, VFIO_BASE + 10, struct vfio_irq_set)"]
#[doc = ""]
#[doc = " Set signaling, masking, and unmasking of interrupts.  Caller provides"]
#[doc = " struct vfio_irq_set with all fields set.  'start' and 'count' indicate"]
#[doc = " the range of subindexes being specified."]
#[doc = ""]
#[doc = " The DATA flags specify the type of data provided.  If DATA_NONE, the"]
#[doc = " operation performs the specified action immediately on the specified"]
#[doc = " interrupt(s).  For example, to unmask AUTOMASKED interrupt [0,0]:"]
#[doc = " flags = (DATA_NONE|ACTION_UNMASK), index = 0, start = 0, count = 1."]
#[doc = ""]
#[doc = " DATA_BOOL allows sparse support for the same on arrays of interrupts."]
#[doc = " For example, to mask interrupts [0,1] and [0,3] (but not [0,2]):"]
#[doc = " flags = (DATA_BOOL|ACTION_MASK), index = 0, start = 1, count = 3,"]
#[doc = " data = {1,0,1}"]
#[doc = ""]
#[doc = " DATA_EVENTFD binds the specified ACTION to the provided __s32 eventfd."]
#[doc = " A value of -1 can be used to either de-assign interrupts if already"]
#[doc = " assigned or skip un-assigned interrupts.  For example, to set an eventfd"]
#[doc = " to be trigger for interrupts [0,0] and [0,2]:"]
#[doc = " flags = (DATA_EVENTFD|ACTION_TRIGGER), index = 0, start = 0, count = 3,"]
#[doc = " data = {fd1, -1, fd2}"]
#[doc = " If index [0,1] is previously set, two count = 1 ioctls calls would be"]
#[doc = " required to set [0,0] and [0,2] without changing [0,1]."]
#[doc = ""]
#[doc = " Once a signaling mechanism is set, DATA_BOOL or DATA_NONE can be used"]
#[doc = " with ACTION_TRIGGER to perform kernel level interrupt loopback testing"]
#[doc = " from userspace (ie. simulate hardware triggering)."]
#[doc = ""]
#[doc = " Setting of an event triggering mechanism to userspace for ACTION_TRIGGER"]
#[doc = " enables the interrupt index for the device.  Individual subindex interrupts"]
#[doc = " can be disabled using the -1 value for DATA_EVENTFD or the index can be"]
#[doc = " disabled as a whole with: flags = (DATA_NONE|ACTION_TRIGGER), count = 0."]
#[doc = ""]
#[doc = " Note that ACTION_[UN]MASK specify user->kernel signaling (irqfds) while"]
#[doc = " ACTION_TRIGGER specifies kernel->user signaling."]
#[repr(C)]
#[derive(Debug, Default)]
pub struct vfio_irq_set {
    pub argsz: __u32,
    pub flags: __u32,
    pub index: __u32,
    pub start: __u32,
    pub count: __u32,
    pub data: __IncompleteArrayField<__u8>,
}
pub const VFIO_PCI_BAR0_REGION_INDEX: _bindgen_ty_2 = 0;
pub const VFIO_PCI_BAR1_REGION_INDEX: _bindgen_ty_2 = 1;
pub const VFIO_PCI_BAR2_REGION_INDEX: _bindgen_ty_2 = 2;
pub const VFIO_PCI_BAR3_REGION_INDEX: _bindgen_ty_2 = 3;
pub const VFIO_PCI_BAR4_REGION_INDEX: _bindgen_ty_2 = 4;
pub const VFIO_PCI_BAR5_REGION_INDEX: _bindgen_ty_2 = 5;
pub const VFIO_PCI_ROM_REGION_INDEX: _bindgen_ty_2 = 6;
pub const VFIO_PCI_CONFIG_REGION_INDEX: _bindgen_ty_2 = 7;
pub const VFIO_PCI_VGA_REGION_INDEX: _bindgen_ty_2 = 8;
pub const VFIO_PCI_NUM_REGIONS: _bindgen_ty_2 = 9;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
pub const VFIO_PCI_INTX_IRQ_INDEX: _bindgen_ty_3 = 0;
pub const VFIO_PCI_MSI_IRQ_INDEX: _bindgen_ty_3 = 1;
pub const VFIO_PCI_MSIX_IRQ_INDEX: _bindgen_ty_3 = 2;
pub const VFIO_PCI_ERR_IRQ_INDEX: _bindgen_ty_3 = 3;
pub const VFIO_PCI_REQ_IRQ_INDEX: _bindgen_ty_3 = 4;
pub const VFIO_PCI_NUM_IRQS: _bindgen_ty_3 = 5;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
pub const VFIO_CCW_CONFIG_REGION_INDEX: _bindgen_ty_4 = 0;
pub const VFIO_CCW_NUM_REGIONS: _bindgen_ty_4 = 1;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
pub const VFIO_CCW_IO_IRQ_INDEX: _bindgen_ty_5 = 0;
pub const VFIO_CCW_CRW_IRQ_INDEX: _bindgen_ty_5 = 1;
pub const VFIO_CCW_REQ_IRQ_INDEX: _bindgen_ty_5 = 2;
pub const VFIO_CCW_NUM_IRQS: _bindgen_ty_5 = 3;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
#[doc = " VFIO_DEVICE_GET_PCI_HOT_RESET_INFO - _IOWR(VFIO_TYPE, VFIO_BASE + 12,"]
#[doc = "\t\t\t\t\t      struct vfio_pci_hot_reset_info)"]
#[doc = ""]
#[doc = " Return: 0 on success, -errno on failure:"]
#[doc = "\t-enospc = insufficient buffer, -enodev = unsupported for device."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_pci_dependent_device {
    pub group_id: __u32,
    pub segment: __u16,
    pub bus: __u8,
    pub devfn: __u8,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct vfio_pci_hot_reset_info {
    pub argsz: __u32,
    pub flags: __u32,
    pub count: __u32,
    pub devices: __IncompleteArrayField<vfio_pci_dependent_device>,
}
#[doc = " VFIO_DEVICE_PCI_HOT_RESET - _IOW(VFIO_TYPE, VFIO_BASE + 13,"]
#[doc = "\t\t\t\t    struct vfio_pci_hot_reset)"]
#[doc = ""]
#[doc = " Return: 0 on success, -errno on failure."]
#[repr(C)]
#[derive(Debug, Default)]
pub struct vfio_pci_hot_reset {
    pub argsz: __u32,
    pub flags: __u32,
    pub count: __u32,
    pub group_fds: __IncompleteArrayField<__s32>,
}
#[doc = " VFIO_DEVICE_QUERY_GFX_PLANE - _IOW(VFIO_TYPE, VFIO_BASE + 14,"]
#[doc = "                                    struct vfio_device_query_gfx_plane)"]
#[doc = ""]
#[doc = " Set the drm_plane_type and flags, then retrieve the gfx plane info."]
#[doc = ""]
#[doc = " flags supported:"]
#[doc = " - VFIO_GFX_PLANE_TYPE_PROBE and VFIO_GFX_PLANE_TYPE_DMABUF are set"]
#[doc = "   to ask if the mdev supports dma-buf. 0 on support, -EINVAL on no"]
#[doc = "   support for dma-buf."]
#[doc = " - VFIO_GFX_PLANE_TYPE_PROBE and VFIO_GFX_PLANE_TYPE_REGION are set"]
#[doc = "   to ask if the mdev supports region. 0 on support, -EINVAL on no"]
#[doc = "   support for region."]
#[doc = " - VFIO_GFX_PLANE_TYPE_DMABUF or VFIO_GFX_PLANE_TYPE_REGION is set"]
#[doc = "   with each call to query the plane info."]
#[doc = " - Others are invalid and return -EINVAL."]
#[doc = ""]
#[doc = " Note:"]
#[doc = " 1. Plane could be disabled by guest. In that case, success will be"]
#[doc = "    returned with zero-initialized drm_format, size, width and height"]
#[doc = "    fields."]
#[doc = " 2. x_hot/y_hot is set to 0xFFFFFFFF if no hotspot information available"]
#[doc = ""]
#[doc = " Return: 0 on success, -errno on other failure."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vfio_device_gfx_plane_info {
    pub argsz: __u32,
    pub flags: __u32,
    pub drm_plane_type: __u32,
    pub drm_format: __u32,
    pub drm_format_mod: __u64,
    pub width: __u32,
    pub height: __u32,
    pub stride: __u32,
    pub size: __u32,
    pub x_pos: __u32,
    pub y_pos: __u32,
    pub x_hot: __u32,
    pub y_hot: __u32,
    pub __bindgen_anon_1: vfio_device_gfx_plane_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union vfio_device_gfx_plane_info__bindgen_ty_1 {
    pub region_index: __u32,
    pub dmabuf_id: __u32,
}
impl Default for vfio_device_gfx_plane_info__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for vfio_device_gfx_plane_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " VFIO_DEVICE_IOEVENTFD - _IOW(VFIO_TYPE, VFIO_BASE + 16,"]
#[doc = "                              struct vfio_device_ioeventfd)"]
#[doc = ""]
#[doc = " Perform a write to the device at the specified device fd offset, with"]
#[doc = " the specified data and width when the provided eventfd is triggered."]
#[doc = " vfio bus drivers may not support this for all regions, for all widths,"]
#[doc = " or at all.  vfio-pci currently only enables support for BAR regions,"]
#[doc = " excluding the MSI-X vector table."]
#[doc = ""]
#[doc = " Return: 0 on success, -errno on failure."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_device_ioeventfd {
    pub argsz: __u32,
    pub flags: __u32,
    pub offset: __u64,
    pub data: __u64,
    pub fd: __s32,
}
#[doc = " VFIO_DEVICE_FEATURE - _IOWR(VFIO_TYPE, VFIO_BASE + 17,"]
#[doc = "\t\t\t       struct vfio_device_feature)"]
#[doc = ""]
#[doc = " Get, set, or probe feature data of the device.  The feature is selected"]
#[doc = " using the FEATURE_MASK portion of the flags field.  Support for a feature"]
#[doc = " can be probed by setting both the FEATURE_MASK and PROBE bits.  A probe"]
#[doc = " may optionally include the GET and/or SET bits to determine read vs write"]
#[doc = " access of the feature respectively.  Probing a feature will return success"]
#[doc = " if the feature is supported and all of the optionally indicated GET/SET"]
#[doc = " methods are supported.  The format of the data portion of the structure is"]
#[doc = " specific to the given feature.  The data portion is not required for"]
#[doc = " probing.  GET and SET are mutually exclusive, except for use with PROBE."]
#[doc = ""]
#[doc = " Return 0 on success, -errno on failure."]
#[repr(C)]
#[derive(Debug, Default)]
pub struct vfio_device_feature {
    pub argsz: __u32,
    pub flags: __u32,
    pub data: __IncompleteArrayField<__u8>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_device_feature_migration {
    pub flags: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_device_feature_mig_state {
    pub device_state: __u32,
    pub data_fd: __s32,
}
pub const vfio_device_mig_state_VFIO_DEVICE_STATE_ERROR: vfio_device_mig_state = 0;
pub const vfio_device_mig_state_VFIO_DEVICE_STATE_STOP: vfio_device_mig_state = 1;
pub const vfio_device_mig_state_VFIO_DEVICE_STATE_RUNNING: vfio_device_mig_state = 2;
pub const vfio_device_mig_state_VFIO_DEVICE_STATE_STOP_COPY: vfio_device_mig_state = 3;
pub const vfio_device_mig_state_VFIO_DEVICE_STATE_RESUMING: vfio_device_mig_state = 4;
pub const vfio_device_mig_state_VFIO_DEVICE_STATE_RUNNING_P2P: vfio_device_mig_state = 5;
pub type vfio_device_mig_state = ::std::os::raw::c_uint;
#[doc = " VFIO_IOMMU_GET_INFO - _IOR(VFIO_TYPE, VFIO_BASE + 12, struct vfio_iommu_info)"]
#[doc = ""]
#[doc = " Retrieve information about the IOMMU object. Fills in provided"]
#[doc = " struct vfio_iommu_info. Caller sets argsz."]
#[doc = ""]
#[doc = " XXX Should we do these by CHECK_EXTENSION too?"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_type1_info {
    pub argsz: __u32,
    pub flags: __u32,
    pub iova_pgsizes: __u64,
    pub cap_offset: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iova_range {
    pub start: __u64,
    pub end: __u64,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct vfio_iommu_type1_info_cap_iova_range {
    pub header: vfio_info_cap_header,
    pub nr_iovas: __u32,
    pub reserved: __u32,
    pub iova_ranges: __IncompleteArrayField<vfio_iova_range>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_type1_info_cap_migration {
    pub header: vfio_info_cap_header,
    pub flags: __u32,
    pub pgsize_bitmap: __u64,
    pub max_dirty_bitmap_size: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_type1_info_dma_avail {
    pub header: vfio_info_cap_header,
    pub avail: __u32,
}
#[doc = " VFIO_IOMMU_MAP_DMA - _IOW(VFIO_TYPE, VFIO_BASE + 13, struct vfio_dma_map)"]
#[doc = ""]
#[doc = " Map process virtual addresses to IO virtual addresses using the"]
#[doc = " provided struct vfio_dma_map. Caller sets argsz. READ &/ WRITE required."]
#[doc = ""]
#[doc = " If flags & VFIO_DMA_MAP_FLAG_VADDR, update the base vaddr for iova, and"]
#[doc = " unblock translation of host virtual addresses in the iova range.  The vaddr"]
#[doc = " must have previously been invalidated with VFIO_DMA_UNMAP_FLAG_VADDR.  To"]
#[doc = " maintain memory consistency within the user application, the updated vaddr"]
#[doc = " must address the same memory object as originally mapped.  Failure to do so"]
#[doc = " will result in user memory corruption and/or device misbehavior.  iova and"]
#[doc = " size must match those in the original MAP_DMA call.  Protection is not"]
#[doc = " changed, and the READ & WRITE flags must be 0."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_type1_dma_map {
    pub argsz: __u32,
    pub flags: __u32,
    pub vaddr: __u64,
    pub iova: __u64,
    pub size: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vfio_bitmap {
    pub pgsize: __u64,
    pub size: __u64,
    pub data: *mut __u64,
}
impl Default for vfio_bitmap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " VFIO_IOMMU_UNMAP_DMA - _IOWR(VFIO_TYPE, VFIO_BASE + 14,"]
#[doc = "\t\t\t\t\t\t\tstruct vfio_dma_unmap)"]
#[doc = ""]
#[doc = " Unmap IO virtual addresses using the provided struct vfio_dma_unmap."]
#[doc = " Caller sets argsz.  The actual unmapped size is returned in the size"]
#[doc = " field.  No guarantee is made to the user that arbitrary unmaps of iova"]
#[doc = " or size different from those used in the original mapping call will"]
#[doc = " succeed."]
#[doc = ""]
#[doc = " VFIO_DMA_UNMAP_FLAG_GET_DIRTY_BITMAP should be set to get the dirty bitmap"]
#[doc = " before unmapping IO virtual addresses. When this flag is set, the user must"]
#[doc = " provide a struct vfio_bitmap in data[]. User must provide zero-allocated"]
#[doc = " memory via vfio_bitmap.data and its size in the vfio_bitmap.size field."]
#[doc = " A bit in the bitmap represents one page, of user provided page size in"]
#[doc = " vfio_bitmap.pgsize field, consecutively starting from iova offset. Bit set"]
#[doc = " indicates that the page at that offset from iova is dirty. A Bitmap of the"]
#[doc = " pages in the range of unmapped size is returned in the user-provided"]
#[doc = " vfio_bitmap.data."]
#[doc = ""]
#[doc = " If flags & VFIO_DMA_UNMAP_FLAG_ALL, unmap all addresses.  iova and size"]
#[doc = " must be 0.  This cannot be combined with the get-dirty-bitmap flag."]
#[doc = ""]
#[doc = " If flags & VFIO_DMA_UNMAP_FLAG_VADDR, do not unmap, but invalidate host"]
#[doc = " virtual addresses in the iova range.  Tasks that attempt to translate an"]
#[doc = " iova's vaddr will block.  DMA to already-mapped pages continues.  This"]
#[doc = " cannot be combined with the get-dirty-bitmap flag."]
#[repr(C)]
#[derive(Debug, Default)]
pub struct vfio_iommu_type1_dma_unmap {
    pub argsz: __u32,
    pub flags: __u32,
    pub iova: __u64,
    pub size: __u64,
    pub data: __IncompleteArrayField<__u8>,
}
#[doc = " VFIO_IOMMU_DIRTY_PAGES - _IOWR(VFIO_TYPE, VFIO_BASE + 17,"]
#[doc = "                                     struct vfio_iommu_type1_dirty_bitmap)"]
#[doc = " IOCTL is used for dirty pages logging."]
#[doc = " Caller should set flag depending on which operation to perform, details as"]
#[doc = " below:"]
#[doc = ""]
#[doc = " Calling the IOCTL with VFIO_IOMMU_DIRTY_PAGES_FLAG_START flag set, instructs"]
#[doc = " the IOMMU driver to log pages that are dirtied or potentially dirtied by"]
#[doc = " the device; designed to be used when a migration is in progress. Dirty pages"]
#[doc = " are logged until logging is disabled by user application by calling the IOCTL"]
#[doc = " with VFIO_IOMMU_DIRTY_PAGES_FLAG_STOP flag."]
#[doc = ""]
#[doc = " Calling the IOCTL with VFIO_IOMMU_DIRTY_PAGES_FLAG_STOP flag set, instructs"]
#[doc = " the IOMMU driver to stop logging dirtied pages."]
#[doc = ""]
#[doc = " Calling the IOCTL with VFIO_IOMMU_DIRTY_PAGES_FLAG_GET_BITMAP flag set"]
#[doc = " returns the dirty pages bitmap for IOMMU container for a given IOVA range."]
#[doc = " The user must specify the IOVA range and the pgsize through the structure"]
#[doc = " vfio_iommu_type1_dirty_bitmap_get in the data[] portion. This interface"]
#[doc = " supports getting a bitmap of the smallest supported pgsize only and can be"]
#[doc = " modified in future to get a bitmap of any specified supported pgsize. The"]
#[doc = " user must provide a zeroed memory area for the bitmap memory and specify its"]
#[doc = " size in bitmap.size. One bit is used to represent one page consecutively"]
#[doc = " starting from iova offset. The user should provide page size in bitmap.pgsize"]
#[doc = " field. A bit set in the bitmap indicates that the page at that offset from"]
#[doc = " iova is dirty. The caller must set argsz to a value including the size of"]
#[doc = " structure vfio_iommu_type1_dirty_bitmap_get, but excluding the size of the"]
#[doc = " actual bitmap. If dirty pages logging is not enabled, an error will be"]
#[doc = " returned."]
#[doc = ""]
#[doc = " Only one of the flags _START, _STOP and _GET may be specified at a time."]
#[doc = ""]
#[repr(C)]
#[derive(Debug, Default)]
pub struct vfio_iommu_type1_dirty_bitmap {
    pub argsz: __u32,
    pub flags: __u32,
    pub data: __IncompleteArrayField<__u8>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vfio_iommu_type1_dirty_bitmap_get {
    pub iova: __u64,
    pub size: __u64,
    pub bitmap: vfio_bitmap,
}
impl Default for vfio_iommu_type1_dirty_bitmap_get {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_spapr_tce_ddw_info {
    pub pgsizes: __u64,
    pub max_dynamic_windows_supported: __u32,
    pub levels: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_spapr_tce_info {
    pub argsz: __u32,
    pub flags: __u32,
    pub dma32_window_start: __u32,
    pub dma32_window_size: __u32,
    pub ddw: vfio_iommu_spapr_tce_ddw_info,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_eeh_pe_err {
    pub type_: __u32,
    pub func: __u32,
    pub addr: __u64,
    pub mask: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vfio_eeh_pe_op {
    pub argsz: __u32,
    pub flags: __u32,
    pub op: __u32,
    pub __bindgen_anon_1: vfio_eeh_pe_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union vfio_eeh_pe_op__bindgen_ty_1 {
    pub err: vfio_eeh_pe_err,
}
impl Default for vfio_eeh_pe_op__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for vfio_eeh_pe_op {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " VFIO_IOMMU_SPAPR_REGISTER_MEMORY - _IOW(VFIO_TYPE, VFIO_BASE + 17, struct vfio_iommu_spapr_register_memory)"]
#[doc = ""]
#[doc = " Registers user space memory where DMA is allowed. It pins"]
#[doc = " user pages and does the locked memory accounting so"]
#[doc = " subsequent VFIO_IOMMU_MAP_DMA/VFIO_IOMMU_UNMAP_DMA calls"]
#[doc = " get faster."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_spapr_register_memory {
    pub argsz: __u32,
    pub flags: __u32,
    pub vaddr: __u64,
    pub size: __u64,
}
#[doc = " VFIO_IOMMU_SPAPR_TCE_CREATE - _IOWR(VFIO_TYPE, VFIO_BASE + 19, struct vfio_iommu_spapr_tce_create)"]
#[doc = ""]
#[doc = " Creates an additional TCE table and programs it (sets a new DMA window)"]
#[doc = " to every IOMMU group in the container. It receives page shift, window"]
#[doc = " size and number of levels in the TCE table being created."]
#[doc = ""]
#[doc = " It allocates and returns an offset on a PCI bus of the new DMA window."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_spapr_tce_create {
    pub argsz: __u32,
    pub flags: __u32,
    pub page_shift: __u32,
    pub __resv1: __u32,
    pub window_size: __u64,
    pub levels: __u32,
    pub __resv2: __u32,
    pub start_addr: __u64,
}
#[doc = " VFIO_IOMMU_SPAPR_TCE_REMOVE - _IOW(VFIO_TYPE, VFIO_BASE + 20, struct vfio_iommu_spapr_tce_remove)"]
#[doc = ""]
#[doc = " Unprograms a TCE table from all groups in the container and destroys it."]
#[doc = " It receives a PCI bus offset as a window id."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vfio_iommu_spapr_tce_remove {
    pub argsz: __u32,
    pub flags: __u32,
    pub start_addr: __u64,
}
