#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "sphere.icc"
int main (int argc, char**argv) {
  environment rheolef (argc,argv);
  Float tol = (argc > 1) ? atof(argv[1]) : 1e+38;
  geo gamma_h;
  din >> gamma_h;
  space Wh (gamma_h, "P1");
  trial u (Wh); test v (Wh);
  form m  = integrate (u*v);
  field one (Wh, 1);
  Float meas_gamma_h = m(one,one);
  size_t d = gamma_h.dimension();
  Float pi = acos(Float(-1));
  Float meas_gamma = (d == 3) ? 4*pi : 2*pi;
  Float err = fabs(meas_gamma - meas_gamma_h);
  dout << "meas(gamma_h) = " << meas_gamma_h << endl
       << "meas(gamma)   = " << meas_gamma   << endl
       << "err           = " << err          << endl;
  return (err < tol) ? 0 : 1;
}
