% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.BSpline}
\alias{predict.MSpline}
\alias{predict.ISpline}
\alias{predict.CSpline}
\alias{predict.BernsteinPoly}
\alias{predict.NaturalSpline}
\alias{predict.NaturalSplineK}
\title{Compute Spline Function for Given Coefficients}
\usage{
\method{predict}{BSpline}(object, newx = NULL, coef = NULL, ...)

\method{predict}{MSpline}(object, newx = NULL, coef = NULL, ...)

\method{predict}{ISpline}(object, newx = NULL, coef = NULL, ...)

\method{predict}{CSpline}(object, newx = NULL, coef = NULL, ...)

\method{predict}{BernsteinPoly}(object, newx = NULL, coef = NULL, ...)

\method{predict}{NaturalSpline}(object, newx = NULL, coef = NULL, ...)

\method{predict}{NaturalSplineK}(object, newx = NULL, coef = NULL, ...)
}
\arguments{
\item{object}{Spline objects produced by the \code{splines2} package.}

\item{newx}{The \code{x} values at which evaluations are required.  If it is
\code{NULL} (by default), the original \code{x} used to create the
spline object will be used.}

\item{coef}{A numeric vector specifying the coefficients of the spline basis
functions.  If it is \code{NULL} (by default), the spline basis
functions will be returned.  Otherwise, the resulting spline function
will be returned.}

\item{...}{Other options passed to the corresponding function that
constructs the input \code{object}.  For example, the additional options
will be passed to \code{bSpline()} for a \code{BSpline} object.}
}
\value{
The function returns the spline basis functions with the new values
    of \code{x} if \code{coef} is not specified.  Otherwise, the function
    returns the resulting spline function (or its derivative if
    \code{derivs} is specified as a positive integer through \code{...}).
}
\description{
Returns the spline function (with the specified coefficients) or evaluate
the basis functions at the specified \code{x} if the coefficients are not
specified.
}
\examples{
library(splines2)

x <- seq.int(0, 1, 0.2)
knots <- c(0.3, 0.5, 0.6)
newx <- seq.int(0.1, 0.9, 0.2)

## Cubic B-spline basis functions
bs_mat <- bSpline(x, knots = knots)

## compute the B-spline basis functions at new x
predict(bs_mat, newx)

## compute the B-spline function for the specified coefficients
beta <- runif(ncol(bs_mat))
predict(bs_mat, coef = beta)

## compute the first derivative of the B-spline function
predict(bs_mat, coef = beta, derivs = 1)
## or equivalently
predict(deriv(bs_mat), coef = beta)

## compute the second derivative
predict(bs_mat, coef = beta, derivs = 2)
## or equivalently
predict(deriv(bs_mat, derivs = 2), coef = beta)

## compute the integral
predict(bs_mat, coef = beta, integral = TRUE)
## or equivalently
predict(update(bs_mat, integral = TRUE), coef = beta)
}
