% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.r
\name{with_config}
\alias{with_config}
\alias{with_verbose}
\title{Execute code with configuration set.}
\usage{
with_config(config = config(), expr, override = FALSE)

with_verbose(expr, ...)
}
\arguments{
\item{config}{Settings as generated by \code{\link{add_headers}},
\code{\link{set_cookies}} or \code{\link{authenticate}}.}

\item{expr}{code to execute under specified configuration}

\item{override}{if \code{TRUE}, ignore existing settings, if \code{FALSE},
combine new config with old.}

\item{...}{Other arguments passed on to \code{\link{verbose}}}
}
\description{
Execute code with configuration set.
}
\examples{
with_config(verbose(), {
  GET("http://had.co.nz")
  GET("http://google.com")
})

# Or even easier:
with_verbose(GET("http://google.com"))
}
\seealso{
Other ways to set configuration: \code{\link{config}},
  \code{\link{set_config}}
}
