% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waggle.R
\name{waggle}
\alias{waggle}
\title{Waggle back and forth between two numbers}
\usage{
waggle(min, max, value = (min + max)/2, step = (max - min)/50, fps = 10)
}
\arguments{
\item{min}{A minimum value.}

\item{max}{A maximum value.}

\item{value}{Starting value. Defaults to half-way between \code{min} and
\code{max}.}

\item{step}{How much value changes at each frame. Defaults to 50 steps
between min and max so it takes 5 seconds to waggle once.}

\item{fps}{number of frames per second.}
}
\description{
Waggle back and forth between two numbers
}
\examples{
span <- waggle(0.2, 1)
mtcars \%>\% ggvis(~mpg, ~wt) \%>\%
 layer_points() \%>\%
 layer_smooths(span = span)
}
