% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapclust.choose.k.R
\name{snapclust.choose.k}
\alias{snapclust.choose.k}
\title{Choose the number of clusters for snapclust}
\usage{
snapclust.choose.k(max, ..., IC = AIC, IC.only = TRUE)
}
\arguments{
\item{max}{An integer indicating the maximum number of clusters to seek;
\code{\link{snapclust}} will be run for all k from 2 to max.}

\item{...}{Arguments passed to \code{\link{snapclust}}.}

\item{IC}{A function computing the information criterion for
\code{\link{snapclust}} objects. Available statistics are
\code{AIC} (default), \code{AICc}, and \code{BIC}.}

\item{IC.only}{A logical (TRUE by default) indicating if IC values only
should be returned; if \code{FALSE}, full \code{snapclust} objects are
returned.}
}
\description{
The function \code{snapclust.choose.k} can be used to identify optimal values
of 'k' (number of panmictic clusters) using \code{snapclust}. It runs the
method for increasing values of 'k' and for each computes goodness-of-fit
statistics. These statistics are all different versions of deviance penalised
for the number of parameters, so that lower values should correspond to more
optimal clustering solutions. Currently available statistics include AIC,
AICc, BIC, and KIC.\cr
}
\details{
There is no theoretical basis for favouring a given statistic over another
in the case of genetic clustering. In practice, one should look for an
'elbow' in the curve of the statistics as a function of 'k'.
}
\examples{
\dontrun{
 ## 'a' is a simulated dataset with 6 populations, island model
 data(dapcIllus)
 a <- dapcIllus$a
 a

 ## try and choose 'k' using AIC (real value = 6)
 a.aic <- snapclust.choose.k(max = 10, a)
 plot(1:10, a.aic, xlab = "Number of clusters (k)",
      ylab = "AIC", type = "b", pch = 20, cex = 3)

 ## try and choose 'k' using AIC (real value = 6)
 a.kic <- snapclust.choose.k(max = 10, a, IC = KIC)
 plot(1:10, a.kic, xlab = "Number of clusters (k)",
      ylab = "KIC", type = "b", pch = 20, cex = 3)


}
}
\seealso{
\itemize{
 \item \code{\link{snapclust}}: to identify clusters

 \item \code{\link{AIC.snapclust}}: AIC computation

 \item \code{\link{AICc.snapclust}}: AICc computation

 \item \code{\link{BIC.snapclust}}: BIC computation

 \item \code{\link{KIC.snapclust}}: KIC computation
}
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
