% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr_models.R
\name{genSmoothCurves}
\alias{genSmoothCurves}
\title{Fit smooth spline curves and return the response matrix}
\usage{
genSmoothCurves(
  cds,
  new_data,
  trend_formula = "~sm.ns(Pseudotime, df = 3)",
  relative_expr = T,
  response_type = "response",
  cores = 1
)
}
\arguments{
\item{cds}{a CellDataSet object upon which to perform this operation}

\item{new_data}{a data.frame object including columns (for example, Pseudotime) with names specified in the model formula. The values in the data.frame should be consist with the corresponding values from cds object.}

\item{trend_formula}{a formula string specifying the model formula used in fitting the spline curve for each gene/feature.}

\item{relative_expr}{a logic flag to determine whether or not the relative gene expression should be used}

\item{response_type}{the response desired, as accepted by VGAM's predict function}

\item{cores}{the number of cores to be used while testing each gene for differential expression}
}
\value{
a data frame containing the data for the fitted spline curves.
}
\description{
This function will fit smooth spline curves for the gene expression dynamics along pseudotime in a gene-wise manner and return
the corresponding response matrix. This function is build on other functions (fit_models and responseMatrix) and used in calILRs and calABCs functions
}
